/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.azure.core.exception.AzureException;
import com.google.common.util.concurrent.RateLimiter;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.helper.GraphClientProvider;
import com.parablu.bluvault.udc.service.AADManagementService;
import com.parablu.bluvault.udc.service.CloudSettingsService;
import com.parablu.bluvault.udc.service.ComponentSettingService;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.LiteVersionManagementService;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.bluvault.udc.service.impl.AsyncService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.exceptions.UserLimitReachedException;
import com.parablu.mail.service.CloudMailService;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.CPHelperConstant;
import com.parablu.paracloud.constant.CloudConfigRegistry;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCClientTypes;
import com.parablu.paracloud.element.AADUserElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EmailProps;
import com.parablu.paracloud.element.EmailRecipent;
import com.parablu.paracloud.element.GraphUserElement;
import com.parablu.paracloud.element.IdentityProviderSettingsElement;
import com.parablu.paracloud.element.LdapUserElement;
import com.parablu.paracloud.element.LdapUserListElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.OdbMappingList;
import com.parablu.paracloud.element.ResponseElement;
import com.parablu.paracloud.element.SearchUserElement;
import com.parablu.paracloud.element.SiteElement;
import com.parablu.paracloud.element.StringElement;
import com.parablu.paracloud.element.UserDeviceCommentsElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserGroupElement;
import com.parablu.paracloud.element.UserListElement;
import com.parablu.paracloud.element.response.ResponseMetadataElement;
import com.parablu.paracloud.element.response.UserElementResponse;
import com.parablu.paracloud.element.response.UserErrorReponse;
import com.parablu.paracloud.util.CacheHelper;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.paracloud.util.EmailCacher;
import com.parablu.paracloud.util.TokenGenerator;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.LiteVersion;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.OTPValidation;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.Person;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.TenantConsentStatus;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDeviceAccessControl;
import com.parablu.pcbd.domain.UserDeviceComments;
import com.parablu.pcbd.domain.UserGroup;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Request;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserManagementController
extends BaseController {
    private static final String SYNC = "Sync";
    private static final String BKP = "Bkp";
    private static final String BKP_SYNC = "Bkp-Sync";
    private static final String BROWSER = "browser";
    private static final String OS_TYPE = "osType";
    private static final String BACKUP = "backup";
    private static final String SECRET_KEY = "a9985ebcae81";
    private static final String AV_SCAN_ENABLED = "AV Scan Enabled";
    private static final String RW_DETECTION_ENABLED = "RW License Allowed";
    private static final String C2C_RESTORE_ENABLED = "c2c Restore Enabled";
    private static final String USER_BLOCKED = "user-blocked";
    public static final String EMAILS_XML_PATH = "/hbm-mapping/emails.xml";
    private static final String AV_SCAN_FOR_RESTORE = "Endpoint Restore AV Scan";
    private static Logger logger = LogManager.getLogger(UserManagementController.class);
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LiteVersionManagementService liteVersionManagementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AADManagementService aadManagementService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private CloudMailService cloudMailService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    @Autowired
    private CloudSettingsService cloudSettingService;
    @Autowired
    private ComponentSettingService componentSettingService;
    @Autowired
    CloudConfigRegistry registry;
    private static final String DATA_ACCESS_EXCEPTION = " DataAccessException  :";
    private static final String BASE_EXCEPTION = " BaseException  :";
    private static final String USER_NAME = "userName";
    private static final String GATEWAY_NAME = "gatewayName";
    private static final String EXCEPTION = " Exception  :";
    private static final String INVALID_REQUEST = "Invalid Request.";
    private static final String GET_USER_INFO_BACKUP_ENABLED = "get user info Backup Enabled....";
    private static final String USER_NOT_FOUND = "User not found.";
    private static final String EMPTY_RESULT_DATA_ACCESS_EXCEPTION = " EmptyResultDataAccessException  :";
    private static final String BACK_UP_ENABLED = "Backup Enabled";
    private static final String SHARE_POINT_ENABLED = "Sharepoint Backup Enabled";
    private static final String SYNC_ENABLED = "Sync Enabled";
    private static final String ODB_ENABLED = "ODB Enabled";
    private static final String GD_ENABLED = "Google Drive Enabled";
    private static final String GD_SERVICE_ENABLED = "GD Service Account Enabled";
    private static final String USER_NAME_NOT_FOUND = "User name not found.";
    private static final String USER_ALREADY_EXISTS = "User already exists.";
    private static final String DATA_INSTEGRITY_VIOLATION_EXCEPTION = " DataIntegrityViolationException  :";
    private static final String CALLING_UPDATE_USER_INFO = "calling /updateUserInfo ...";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String POST_GET_OPTIONS_DELETE = "POST, GET, OPTIONS, DELETE";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String X_REQUESTED_WITH_FIRST_LOGIN_TOKEN = "x-requested-with, firstLogin, token";
    private static final String PASSWORD = "password";
    private static final String DEVICE_NAME = "deviceName";
    private static final String CLIENT_TYPE = "clientType";
    private static final String PORTAL = "PORTAL";
    private static final String CMDLINE = "command line";
    private static final String LOGGED_INTO = "logged into ";
    private static final String FALSE = "false";
    private static final String CLOUD_NAME = "cloudName";
    private static final String PATH = "path";
    private static final String IS_MINI_CLOUD = "isMiniCloud";
    private static final String MINI_CLOUD_CONSTANT = "_mc_";
    private static final String INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION = "@@@ Inside authenticate DataIntegrityViolationException...";
    private static final String CALLING_VERIFY_RECOVERY_KEY = "calling /verifyRecoveryKey ...";
    private static final String RESET_PASSWORD_KEY = "reset-password-key";
    private static final String IO_EXCEPTION = " IOException  :";
    private static final String INSIDE_AZURE_AUTHENTICATION = "@@@@@@@@@@@@@@ Inside Azure authentication  ...............";
    private static final String RESET_PASSWORD = "-reset-password";
    private static final String LDAP_ENABLED = "isLdapEnabled";
    private static final String AAD_ENABLED = "isAADEnabled";
    private static RateLimiter rateLimiter = null;

    public void setComponentSettingService(ComponentSettingService componentSettingService) {
        this.componentSettingService = componentSettingService;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            boolean includeMSProtected = Boolean.parseBoolean(request.getHeader("includeMSProtected"));
            logger.debug(request.getParameter("includeMSProtected") + "....calling cloud/{cloudName}/user/all ... " + request.getHeader("includeMSProtected"));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            int skipValue = request.getIntHeader("skipValue");
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            logger.debug(" Skip values .... " + skipValue);
            List<UserElement> userList = this.managementService.getAllUsers(cloudId, skipValue, site, null, false);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            if (includeMSProtected) {
                userList = UserManagementController.filterUsersWithProtectionTimes(userList);
            }
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/users/"}, method={RequestMethod.GET})
    public ModelAndView searchUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        try {
            String userName;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response, userName = request.getHeader(USER_NAME))) {
                return null;
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            com.parablu.pcbd.domain.User user = authorizationTokens.getUser();
            List<Object> userList = this.managementService.searchUsers(cloudId, userName, site);
            logger.debug(userList.size() + "....user..searchUsers.." + user.getUserName());
            if (user != null && user.isReadOnlyAdmin() && !CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && !CollectionUtils.isEmpty(userList)) {
                logger.debug("....user..." + user.getUserName());
                List backupPoliciesAdmin = user.getBackupPoliciesAdmin();
                userList = userList.stream().filter(user1 -> backupPoliciesAdmin.contains(user1.getPolicyName())).collect(Collectors.toList());
            }
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/search/users/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object searchUserbyUsernameOrDisplaynameOrEmailId(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        UserElementResponse ue = new UserElementResponse();
        try {
            com.parablu.pcbd.domain.User user;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            String userName = request.getHeader(USER_NAME);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), user = new com.parablu.pcbd.domain.User(), response, userName)) {
                return null;
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            logger.debug(userName + "...search.. .user..." + user.getUserName());
            List<Object> userList = this.managementService.searchUsers(cloudId, userName, site);
            if (user != null && user.isAdmin()) {
                logger.debug("the logged in user has a admin privilege " + user.getUserName() + "....user..." + userName);
            } else if (!(user == null || !user.isReadOnlyAdmin() || CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()))) {
                logger.debug(userList.size() + "....user..." + user.getUserName());
                List backupPoliciesAdmin = user.getBackupPoliciesAdmin();
                List syncPoliciesAdmin = user.getSyncPoliciesAdmin();
                List odbPoliciesAdmin = user.getOdbPoliciesAdmin();
                if (!CollectionUtils.isEmpty(userList)) {
                    userList = userList.stream().filter(user1 -> !CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin()) && backupPoliciesAdmin.contains(user1.getPolicyName()) || !CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin()) && (odbPoliciesAdmin.contains(user1.getOneDrivePolicyName()) || odbPoliciesAdmin.contains(user1.getSpPolicyName()) || odbPoliciesAdmin.contains(user1.getExchangePolicyName()) || syncPoliciesAdmin.contains(user1.getSyncPolicyName()))).collect(Collectors.toList());
                }
            } else if (!CollectionUtils.isEmpty(userList)) {
                userList = userList.stream().filter(user1 -> user.getUserName().equals(user1.getUserName())).collect(Collectors.toList());
            }
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            int totalRecordsCount = userList.size();
            HashSet<UserElement> userElementSet = new HashSet<UserElement>(userList);
            userList = userElementSet.stream().collect(Collectors.toList());
            ue.setUsers(userList);
            response.setStatus(200);
            Map paramSet = request.getParameterMap();
            return this.toJSON(200, this.getMetadataElement(this.registry.get(cloudId).getReportDisplayRecords(), 1, totalRecordsCount, request.getRequestURI(), paramSet), ue);
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("An exception has occurred e={}", (Throwable)e);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userName}/"}, method={RequestMethod.GET})
    public ModelAndView getUserInformation(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getUserInformation...:" + userName);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            com.parablu.pcbd.domain.User currentUser;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), currentUser = new com.parablu.pcbd.domain.User(), response, userName)) {
                return null;
            }
            UserElement ue = this.getUserElement(userName, cloud);
            ue.setPasswdHash(null);
            ue.setSecurityRecoveryKey(null);
            ue.setGoogleSecretKey(null);
            ue.setUserNameLowerCase(null);
            ue.setUserPrinicipalName(null);
            ue.setAzureUniqueId(null);
            if (currentUser != null && !currentUser.getUserName().equalsIgnoreCase(ue.getUserName()) && currentUser.isReadOnlyAdmin() && ue != null) {
                boolean userHaveAccess = false;
                if (!CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin()) && !org.springframework.util.StringUtils.isEmpty((Object)ue.getPolicyName()) && currentUser.getBackupPoliciesAdmin().contains(ue.getPolicyName())) {
                    userHaveAccess = true;
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getSyncPoliciesAdmin()) && !org.springframework.util.StringUtils.isEmpty((Object)ue.getSyncPolicyName()) && currentUser.getSyncPoliciesAdmin().contains(ue.getSyncPolicyName())) {
                    userHaveAccess = true;
                }
                if (!(CollectionUtils.isEmpty((Collection)currentUser.getOdbPoliciesAdmin()) || org.springframework.util.StringUtils.isEmpty((Object)ue.getOneDrivePolicyName()) && org.springframework.util.StringUtils.isEmpty((Object)ue.getExchangePolicyName()) && org.springframework.util.StringUtils.isEmpty((Object)ue.getSpPolicyName()) || !currentUser.getOdbPoliciesAdmin().contains(ue.getOneDrivePolicyName()) && !currentUser.getOdbPoliciesAdmin().contains(ue.getExchangePolicyName()) && !currentUser.getOdbPoliciesAdmin().contains(ue.getSpPolicyName()))) {
                    userHaveAccess = true;
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getGmailPoliciesAdmin()) && !org.springframework.util.StringUtils.isEmpty((Object)ue.getGmailPolicyName()) && currentUser.getGmailPoliciesAdmin().contains(ue.getGmailPolicyName())) {
                    userHaveAccess = true;
                }
                if (!userHaveAccess) {
                    logger.debug("...readonly admin didn't have access so return...");
                    ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
                    modelAndView.addObject((Object)err);
                    response.setStatus(409);
                    return modelAndView;
                }
            }
            logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private UserElement getUserElement(String userName, Cloud cloud) {
        String cloudName = cloud.getCloudName();
        int cloudId = cloud.getCloudId();
        logger.debug("....userName..." + userName);
        UserElement ue = this.managementService.getUserByUserNameOrEmail(cloud, userName);
        if (ue == null && this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
            logger.debug("....userName..." + userName);
            ue = this.managementService.getUserByAADLoginId(cloud, userName);
        }
        List list = cloud.getCloudCustomisableDetails();
        logger.debug(ue.getAutoExpireType() + ".. idle to delete....." + ue.isSyncEnabled() + "..." + ue.getSyncAccessType());
        if (cloud.getContentSearchEnabled() == 1) {
            ue.setSearchEnabled(true);
        }
        boolean isODBUserLevelAcctEnabled = this.isODBUserLevelAcctEnabled(list);
        boolean isGDServiceAcctEnabled = this.isGDServiceAcctEnabled(list);
        logger.debug(" customizable details ............... " + list.size());
        list.removeAll(Collections.singleton(null));
        for (CloudCustomisableDetails customisableDetails : list) {
            List<PciAuthorizationTokens> authorizationTokens;
            PciAuthorizationTokens pciAuthorizationTokens;
            if ("PMS Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setPmsEnabled(true);
            }
            if ("MSP Environment Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                logger.debug("is MSP enabled={}", (Object)true);
                String delegatedAdminEmailId = this.managementService.getDelegatedAdminMailForUser(cloud, ue);
                logger.debug("delegated admin email Id={}", (Object)delegatedAdminEmailId);
                if (!org.springframework.util.StringUtils.isEmpty((Object)delegatedAdminEmailId)) {
                    ue.setDepartment(delegatedAdminEmailId);
                }
            }
            if ("Report Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setReportEnabled(true);
            }
            if ("Migrationtool Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setMigrationToolEnabled(true);
            }
            if ("Support Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setSupportEnabled(true);
            }
            if ("Shared Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setShareEnabled(true);
            }
            if ("LDAP Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setLdapEnabled(true);
            }
            if (BACK_UP_ENABLED.equalsIgnoreCase(customisableDetails.getName()) && ue.isBackupEnabled()) {
                ue.setBackupEnabled(true);
            }
            if (BACK_UP_ENABLED.equalsIgnoreCase(customisableDetails.getName())) {
                ue.setBackupWebAccessEnabled(true);
            }
            if ("AzureBlob Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                ue.setAzureBlobEnabled(true);
            }
            if (ODB_ENABLED.equals(customisableDetails.getName())) {
                pciAuthorizationTokens = null;
                if (isODBUserLevelAcctEnabled) {
                    pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                } else {
                    authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                    if (!CollectionUtils.isEmpty(authorizationTokens)) {
                        pciAuthorizationTokens = authorizationTokens.get(0);
                    }
                }
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                } else {
                    ue.setExternalStorageAuthorized(true);
                }
            }
            if (GD_ENABLED.equals(customisableDetails.getName())) {
                pciAuthorizationTokens = null;
                if (isGDServiceAcctEnabled) {
                    authorizationTokens = this.pciAuthorizationTokensService.getAllPciAuthorizationTokens(cloudId, cloudName);
                    if (!CollectionUtils.isEmpty(authorizationTokens)) {
                        pciAuthorizationTokens = authorizationTokens.get(0);
                    }
                } else {
                    pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                }
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                } else {
                    ue.setExternalStorageAuthorized(true);
                }
            }
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            String accessToken = this.pciAuthorizationTokensService.getAccessTokenForODBBackup(cloudId);
            if (!org.springframework.util.StringUtils.isEmpty((Object)accessToken)) {
                ue.setOffice365BkpEnabled(false);
                continue;
            }
            ue.setOffice365BkpEnabled(true);
        }
        logger.debug("......." + ue.isSyncEnabled() + ".ue.isBackupTargetAssigned().." + ue.isBackupTargetAssigned());
        return ue;
    }

    private boolean isODBUserLevelAcctEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"ODB User Level Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private boolean isGDServiceAcctEnabled(List<CloudCustomisableDetails> list) {
        boolean isGDServiceAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!GD_SERVICE_ENABLED.equals(customisableDetails.getName())) continue;
            isGDServiceAcctEnabled = true;
            break;
        }
        return isGDServiceAcctEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/admin/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createFirstTimeAdminUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /createFirstTimeAdminUser ...");
        UserElement ue = null;
        try {
            List<UserElement> userList;
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            userElement.setAdmin(true);
            userElement.setUserNameLowerCase(userElement.getUserName().toLowerCase());
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            if ((userList = this.managementService.getAllUsers(cloudId, cloudName, false, site)) != null && !userList.isEmpty()) {
                modelAndView.addObject(null);
                response.setStatus(401);
                return null;
            }
            logger.debug(userElement.getOneDrivePolicyName() + " CREATE USER IS SHARE ENABLED .. " + userElement.isShareEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, "", "", false, true);
            List list = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                ue.setExternalStorageAuthorized(false);
                if (!customisableDetails.getName().equals(ODB_ENABLED)) continue;
                PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                    continue;
                }
                ue.setExternalStorageAuthorized(true);
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "ParaBlu", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(userElement.getOneDrivePolicyName() + "..calling /createUser ..." + userElement.isOnedriveBkpEnabled());
        logger.debug("..calling /createUserval ..." + userElement.isSyncEnabled() + "..." + userElement.getSyncAccessType());
        UserElement ue = null;
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        try {
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String encryptedPassword = request.getHeader("encPassword");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            if (!currentUser.isAdmin() && !currentUser.isReadOnlyAdmin()) {
                response.setStatus(401);
                return null;
            }
            int code = 0;
            if (userElement.isSyncEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                return null;
            }
            if ((userElement.isBackupEnabled() || userElement.isServerBackupEnabled()) && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                return null;
            }
            if (userElement.isExchangeBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled());
                code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                    return null;
                }
            }
            if (userElement.isOnedriveBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled() + "..office..." + userElement.isOnedriveBkpEnabled());
                code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                    return null;
                }
            }
            if (userElement.isGmailBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isGmailBkpEnabled());
                code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                    return null;
                }
            }
            if (userElement.isGdriveBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isGdriveBkpEnabled());
                code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, userName, "User");
                    return null;
                }
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            List<UserElement> elements = this.managementService.getAllUsersIncludingGuest(cloudId, cloudName);
            List<DeletedUser> deletedUsers = this.managementService.getAllDeletedUsers(cloudId, cloudName);
            ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
            for (DeletedUser deletedUser : deletedUsers) {
                userIds.add(deletedUser.getUserId());
            }
            List<UserElement> deletedUserElements = this.managementService.getAllDeletedUsersById(cloudId, cloudName, userIds);
            elements.addAll(deletedUserElements);
            for (UserElement element : deletedUserElements) {
                if (!element.getUserName().equalsIgnoreCase(userElement.getUserName())) continue;
                response.setStatus(409);
                response.setHeader("deleted-user", "true");
                return null;
            }
            for (UserElement u : elements) {
                if (u == null || org.springframework.util.StringUtils.isEmpty((Object)u.getEmailId()) || org.springframework.util.StringUtils.isEmpty((Object)userElement.getEmailId())) continue;
                if (u.getEmailId().equalsIgnoreCase(userElement.getEmailId())) {
                    if (u.isGuest()) {
                        this.removeUserbyID(cloudId, u.getUserId().toString());
                        continue;
                    }
                    response.setStatus(412);
                    return null;
                }
                if (!u.getUserName().equalsIgnoreCase(userElement.getUserName()) && !u.getEmailId().equalsIgnoreCase(userElement.getUserName())) continue;
                if (u.isGuest()) {
                    this.removeUserbyID(cloudId, u.getUserId().toString());
                    continue;
                }
                response.setStatus(409);
                return null;
            }
            logger.debug(" CREATE USER IS SHARE ENABLED .. " + userElement.isShareEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, currentUser.getUserName(), encryptedPassword, true, true);
            MiniCloudElementList miniCloudElementList = userElement.getMiniCloudElementList();
            List miniCloudElements = miniCloudElementList.getMiniClouds();
            this.miniCloudAccessControlService.createAccessControlMapping(cloudId, cloudName, userElement.getUserName(), miniCloudElements);
            ue.setMiniCloudElementList(miniCloudElementList);
            List list = cl.getCloud().getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetails : list) {
                ue.setExternalStorageAuthorized(false);
                if (!customisableDetails.getName().equals(ODB_ENABLED)) continue;
                PciAuthorizationTokens pciAuthorizationTokens = this.pciAuthorizationTokensService.getPciAuthorizationTokensForUserId(cloudId, cloudName, ue.getUserId());
                if (pciAuthorizationTokens != null) {
                    ue.setExternalStorageAuthorized(false);
                    continue;
                }
                ue.setExternalStorageAuthorized(true);
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            if (userName.equals("AUTO_Pack_Manager")) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "Order Center", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
            }
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("calling /createUser  DataIntegrityViolationException access ..." + String.valueOf((Object)e));
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("calling /createUser  data access ..." + String.valueOf((Object)e));
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace("calling /createUser  BaseException access ..." + String.valueOf((Object)e));
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/create/"}, method={RequestMethod.POST})
    public ModelAndView createMultipleUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserListElement userElementList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("/users/create/ ...");
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        int totalUsersCount = userElementList.getUserList().size();
        int totalUsersCreated = 0;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            List<UserErrorReponse> responseUserElement = this.managementService.createMultipleUsers(cl.getCloud(), userElementList, currentUser.getUserName(), currentUser.getPolicyName(), currentUser);
            for (UserErrorReponse ueErrorReponse : responseUserElement) {
                if (!ueErrorReponse.getErrorMessage().equalsIgnoreCase("User created")) continue;
                ++totalUsersCreated;
            }
            if (totalUsersCount == totalUsersCreated) {
                response.setStatus(201);
            } else if (totalUsersCreated == 0) {
                response.setStatus(400);
            } else {
                response.setHeader("totalUsersCount", String.valueOf(totalUsersCount));
                response.setHeader("totalUsersCreated", String.valueOf(totalUsersCreated));
                response.setStatus(206);
            }
            modelAndView.addObject(responseUserElement);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(EXCEPTION, null);
            modelAndView.addObject((Object)err);
            e.getStackTrace();
            response.setStatus(417);
            logger.debug("calling /createUser Exception ..." + String.valueOf(e));
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/bulk/update/{userName}/"}, method={RequestMethod.PUT})
    public ModelAndView updateBulkUserInformation(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserListElement userElementList, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("inside bulk user update");
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        UserListElement userListElement = new UserListElement();
        ArrayList usersNotUpdated = new ArrayList();
        try {
            userElementList.getUserList().forEach(userElement -> {
                try {
                    this.updateUserInfo(userName, request, response, cloudName, (UserElement)userElement, usersNotUpdated);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            });
            for (UserElement userNotUpdated : usersNotUpdated) {
                logger.debug("User not updated, userName={}", (Object)userNotUpdated.getUserName());
            }
            if (usersNotUpdated != null && usersNotUpdated.size() > 0) {
                modelAndView.addObject((Object)userListElement.getUserList().addAll(usersNotUpdated));
            } else {
                modelAndView.addObject((Object)userListElement.getUserList());
            }
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
        }
        catch (BaseException e) {
            e.getStackTrace();
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateUserInfo(String userName, HttpServletRequest request, HttpServletResponse response, String cloudName, UserElement userElement, List<UserElement> usersNotUpdated) throws IllegalAccessException, InvocationTargetException {
        try {
            boolean userUnderLegalHold;
            int code;
            logger.debug("inside updateUserInfo");
            boolean isMSPEnv = false;
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            if (userElement == null) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)String.valueOf(userElement.getUserId()))) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName())) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            Cloud cloud = cl.getCloud();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userElement.getUserName())) {
                return;
            }
            List cloudCustomisableDetails = cloud.getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetail : cloudCustomisableDetails) {
                if (!"MSP Environment Enabled".equalsIgnoreCase(customisableDetail.getName())) continue;
                isMSPEnv = true;
            }
            logger.debug("is MSP enabled={}", (Object)isMSPEnv);
            com.parablu.pcbd.domain.User user = this.managementService.getUserDetails(cloudId, cloudName, userElement.getUserName());
            userElement.setBackupEnabled(user.isBackupEnabled());
            logger.debug("user name={}", (Object)userElement.getUserName());
            logger.debug("user ={}", (Object)user);
            boolean emailAlreadyExists = false;
            boolean adEmailAlreadyExists = false;
            if (org.springframework.util.StringUtils.isEmpty((Object)user.getEmailId()) || !user.getEmailId().equalsIgnoreCase(userElement.getEmailId())) {
                if (!user.isLocalUser() && org.springframework.util.StringUtils.isEmpty((Object)userElement.getEmailId())) {
                    Person person = this.ldapService.getUserByEmail(cloudId, userElement.getUserName());
                    if (person == null) {
                        logger.debug("Email Id is empty .............");
                        response.setStatus(206);
                        usersNotUpdated.add(userElement);
                        return;
                    }
                    logger.error(" userName is not part of domain........................");
                    adEmailAlreadyExists = this.managementService.checkIfEmailAlreadyExists(cloudId, person.getEmailId());
                    if (adEmailAlreadyExists) {
                        logger.debug("Email Id is empty ..........");
                        response.setStatus(206);
                        usersNotUpdated.add(userElement);
                        return;
                    }
                    userElement.setEmailId(person.getEmailId());
                }
                emailAlreadyExists = this.managementService.checkIfEmailAlreadyExistsAsUserName(cloudId, userElement.getEmailId());
            }
            if (!userElement.getUserName().equalsIgnoreCase(userElement.getEmailId()) && emailAlreadyExists) {
                logger.error(" Email already exists ...... " + userElement.getEmailId());
                response.setStatus(412);
                usersNotUpdated.add(userElement);
                return;
            }
            if (!user.isSyncEnabled() && userElement.isSyncEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                usersNotUpdated.add(userElement);
                return;
            }
            if (!user.isBackupEnabled() && userElement.isBackupEnabled()) {
                int code2 = 0;
                if (!isMSPEnv) {
                    code2 = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud());
                }
                if (!this.checkLicense(code2, response)) {
                    response.setStatus(403);
                    usersNotUpdated.add(userElement);
                    return;
                }
            }
            if (!user.isExchangeBkpEnabled() && userElement.isExchangeBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled());
                int code3 = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code3, response)) {
                    response.setStatus(428);
                    usersNotUpdated.add(userElement);
                    return;
                }
            }
            if (!user.isOnedriveBkpEnabled() && userElement.isOnedriveBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled() + "..office..." + userElement.isOnedriveBkpEnabled());
                int code4 = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code4, response)) {
                    response.setStatus(438);
                    usersNotUpdated.add(userElement);
                    return;
                }
            }
            int code5 = 0;
            if (!isMSPEnv) {
                code5 = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
            }
            if (!user.isActive() && code5 == 1503) {
                response.setStatus(417);
                usersNotUpdated.add(userElement);
                return;
            }
            if ((userElement.isAdmin() || userElement.isReadOnlyAdmin()) && (userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userElement.getUserName()))) {
                response.setStatus(447);
                usersNotUpdated.add(userElement);
                return;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getCreatedTimestamp())) {
                userElement.setCreatedTimestamp(user.getCreatedTimestamp());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getLastLoggedInTime())) {
                userElement.setLastLoggedInTime(user.getLastLoggedInTime());
            }
            UserElement ue = this.managementService.bulkUpdateUserInfoForMSP(cloudId, cloudName, userElement);
            boolean isBlockDevice = this.validateBackupAndSyncLicense(userElement, user);
            if (isBlockDevice) {
                this.blockDevice(userElement, cloudName, cloudId, userName, user);
            } else {
                List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userElement.getUserName());
                if (!CollectionUtils.isEmpty(list)) {
                    for (DeviceElement deviceElement : list) {
                        String deviceUUID;
                        AuthorizationTokens authorizationTokens;
                        if (deviceElement.isBlocked() || (authorizationTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceUUID = deviceElement.getDeviceUUID())) != null) continue;
                        this.createNewAuthorizationToken(cloudId, cloudName, user, deviceUUID);
                    }
                }
            }
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "edited the details of user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UPDATE.getActionTypeValue());
            logger.debug("end of calling /user/update/  ...");
            return;
        }
        catch (Exception e) {
            logger.error("exception occurrred e={}", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"cloud/{cloudName}/user/update/{userName}/"}, method={RequestMethod.PUT})
    public ModelAndView updateUserInformation(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        boolean isMSPEnv = false;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        logger.error(userElement.toString() + "....backup policies admin ...... ");
        logger.debug(String.valueOf(userElement.getBackupPoliciesAdminList()) + "...calling /user/update/  ..." + String.valueOf(userElement.getSyncPoliciesAdminList()) + userName + " update user sync enabled ..:" + userElement.isSyncEnabled() + "user sync web access enabled.." + userElement.getSyncAccessType());
        try {
            int code;
            if (userElement == null) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)String.valueOf(userElement.getUserId()))) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName())) throw new BaseException(INVALID_REQUEST);
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            Cloud cloud = cl.getCloud();
            String token = request.getHeader("token");
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            List cloudCustomisableDetails = cloud.getCloudCustomisableDetails();
            for (CloudCustomisableDetails customisableDetail : cloudCustomisableDetails) {
                if (!"MSP Environment Enabled".equalsIgnoreCase(customisableDetail.getName())) continue;
                isMSPEnv = true;
            }
            com.parablu.pcbd.domain.User user = this.managementService.getUserDetails(cloudId, cloudName, userElement.getUserName());
            if (!(currentUser.isAdmin() || currentUser.isReadOnlyAdmin() || user.getUserName().equalsIgnoreCase(currentUser.getUserName()))) {
                throw new BaseException(INVALID_REQUEST);
            }
            if (!currentUser.isAdmin() && userElement.isAdmin()) {
                throw new BaseException(INVALID_REQUEST);
            }
            boolean emailAlreadyExists = false;
            boolean adEmailAlreadyExists = false;
            if (org.springframework.util.StringUtils.isEmpty((Object)user.getEmailId()) || !user.getEmailId().equalsIgnoreCase(userElement.getEmailId())) {
                if (!user.isLocalUser() && org.springframework.util.StringUtils.isEmpty((Object)userElement.getEmailId())) {
                    Person person = this.ldapService.getUserByEmail(cloudId, userElement.getUserName());
                    if (person == null) {
                        logger.debug("Email Id is empty .............");
                        response.setStatus(206);
                        return null;
                    }
                    logger.error(" userName is not part of domain........................");
                    adEmailAlreadyExists = this.managementService.checkIfEmailAlreadyExists(cloudId, person.getEmailId());
                    if (adEmailAlreadyExists) {
                        logger.debug("Email Id is empty ..........");
                        response.setStatus(206);
                        return null;
                    }
                    userElement.setEmailId(person.getEmailId());
                }
                emailAlreadyExists = this.managementService.checkIfEmailAlreadyExistsAsUserName(cloudId, userElement.getEmailId());
            }
            if (!userElement.getUserName().equalsIgnoreCase(userElement.getEmailId()) && emailAlreadyExists) {
                logger.error(" Email already exists ...... " + userElement.getEmailId());
                response.setStatus(412);
                return null;
            }
            if (!user.isSyncEnabled() && userElement.isSyncEnabled() && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return null;
            }
            if (!user.isBackupEnabled() && userElement.isBackupEnabled()) {
                int code2 = 0;
                if (!isMSPEnv) {
                    code2 = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud());
                } else if (isMSPEnv && currentUser.isReadOnlyAdmin()) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)user.getUserType())) {
                        code2 = this.managementService.validateBackupUserRestrictionsByPolicy(cloudId, cloudName, currentUser);
                    } else if (User.TYPE.SERVER.toString().equals(user.getUserType())) {
                        code2 = this.managementService.validateBackupServerRestrictionsByPolicy(cloudId, cloudName, currentUser);
                    }
                }
                if (!this.checkLicense(code2, response)) {
                    response.setStatus(403);
                    return null;
                }
            }
            if (!user.isExchangeBkpEnabled() && userElement.isExchangeBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled());
                int code3 = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code3, response)) {
                    response.setStatus(428);
                    return null;
                }
            }
            if (!user.isOnedriveBkpEnabled() && userElement.isOnedriveBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isExchangeBkpEnabled() + "..office..." + userElement.isOnedriveBkpEnabled());
                int code4 = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code4, response)) {
                    response.setStatus(438);
                    return null;
                }
            }
            if (!user.isGmailBkpEnabled() && userElement.isGmailBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isGmailBkpEnabled() + "..office..." + userElement.isGmailBkpEnabled());
                int code5 = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code5, response)) {
                    response.setStatus(449);
                    return null;
                }
            }
            if (!user.isGdriveBkpEnabled() && userElement.isGdriveBkpEnabled()) {
                logger.debug("...trying to validate users ... " + userElement.isGdriveBkpEnabled() + "..office..." + user.isGdriveBkpEnabled());
                int code6 = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloudId, cl.getCloud());
                if (!this.checkLicense(code6, response)) {
                    response.setStatus(449);
                    return null;
                }
            }
            int code7 = 0;
            if (!isMSPEnv) {
                code7 = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
            } else if (isMSPEnv && (currentUser.isReadOnlyAdmin() || currentUser.isAdmin())) {
                code7 = this.managementService.validateBackupUserRestrictionsByPolicy(cloudId, cloudName, user);
            }
            if (!user.isActive() && code7 == 1503) {
                response.setStatus(417);
                return null;
            }
            boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userElement.getUserName());
            if (userUnderLegalHold) {
                response.setStatus(447);
                return null;
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getCreatedTimestamp())) {
                userElement.setCreatedTimestamp(user.getCreatedTimestamp());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)user.getLastLoggedInTime())) {
                userElement.setLastLoggedInTime(user.getLastLoggedInTime());
            }
            userElement.setPasswdHash(user.getPasswdHash());
            userElement.setSecurityRecoveryKey(user.getSecurityRecoveryKey());
            userElement.setGoogleSecretKey(user.getGoogleSecretKey());
            userElement.setUserNameLowerCase(user.getUserNameLowerCase());
            logger.debug(userElement.getNoOfDaysForAutoBlock() + "....idle..userElement backup policy name:" + userElement.getPolicyName());
            logger.debug("..created...userElement sync policy name:" + userElement.getSyncPolicyName());
            UserElement ue = this.managementService.updateUserInfo(cloudId, cloudName, userElement, userName);
            boolean isBlockDevice = this.blockDevice(userElement, cloudName, cloudId, userName, user);
            if (isBlockDevice) {
                logger.debug("Nothing to do.....");
            } else {
                List<DeviceElement> list = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userElement.getUserName());
                if (!CollectionUtils.isEmpty(list)) {
                    for (DeviceElement deviceElement : list) {
                        String deviceUUID;
                        AuthorizationTokens authorizationTokens;
                        if (deviceElement.isBlocked() || (authorizationTokens = this.authorizationService1.getAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceUUID = deviceElement.getDeviceUUID())) != null) continue;
                        this.createNewAuthorizationToken(cloudId, cloudName, user, deviceUUID);
                    }
                }
            }
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
            logger.debug("end of calling /user/update/  ...");
            return modelAndView;
        }
        catch (EmptyResultDataAccessException e) {
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            return modelAndView;
        }
        catch (BaseException e) {
            e.getStackTrace();
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    private boolean validateBackupAndSyncLicense(UserElement userElement, com.parablu.pcbd.domain.User user) {
        boolean isBackupAndSyncEnabledDB;
        boolean blockDevice = false;
        boolean isBackupAndSyncDisabledPortal = !userElement.isBackupEnabled() && (!userElement.isSyncEnabled() || StringUtils.isNotEmpty((CharSequence)userElement.getSyncAccessType()) && !userElement.getSyncAccessType().equals("WEBANDENDPOINT"));
        boolean bl = isBackupAndSyncEnabledDB = user.isBackupEnabled() || user.isSyncEnabled() && StringUtils.isNotEmpty((CharSequence)user.getSyncAccessType()) && user.getSyncAccessType().equals("WEBANDENDPOINT");
        if (isBackupAndSyncDisabledPortal && isBackupAndSyncEnabledDB) {
            logger.debug("Backup and sync license is disabled for endpoint");
            blockDevice = true;
        }
        return blockDevice;
    }

    private boolean blockDevice(UserElement userElement, String cloudName, int cloudId, String userName, com.parablu.pcbd.domain.User user) throws IllegalAccessException, InvocationTargetException {
        boolean isBackupAndSyncEnabledDB;
        List<Device> list = this.deviceManagementService.getDevicesByUserName(cloudId, userElement.getUserName());
        boolean blockDevice = false;
        boolean isBackupAndSyncDisabledPortal = !userElement.isBackupEnabled() && (!userElement.isSyncEnabled() || StringUtils.isNotEmpty((CharSequence)userElement.getSyncAccessType()) && !userElement.getSyncAccessType().equals("WEBANDENDPOINT"));
        boolean bl = isBackupAndSyncEnabledDB = user.isBackupEnabled() || user.isSyncEnabled() && StringUtils.isNotEmpty((CharSequence)user.getSyncAccessType()) && user.getSyncAccessType().equals("WEBANDENDPOINT");
        if (!CollectionUtils.isEmpty(list)) {
            for (Device device : list) {
                if (device.isBlocked()) continue;
                if ((StringUtils.isEmpty((CharSequence)device.getDeviceType()) || device.getDeviceType().equalsIgnoreCase("BACKUP")) && isBackupAndSyncDisabledPortal && isBackupAndSyncEnabledDB) {
                    logger.debug("Backup and sync license is disabled for endpoint");
                    blockDevice = true;
                    device.setBlocked(true);
                    this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    continue;
                }
                if (device.getDeviceType().equalsIgnoreCase("ONEDRIVE") && !userElement.isOnedriveBkpEnabled()) {
                    logger.debug("Onedrive license is disabled for endpoint");
                    device.setBlocked(true);
                    blockDevice = true;
                    this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    continue;
                }
                if (device.getDeviceType().equalsIgnoreCase("OUTLOOK") && !userElement.isExchangeBkpEnabled()) {
                    logger.debug("Exchange license is disabled for endpoint");
                    device.setBlocked(true);
                    blockDevice = true;
                    this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    continue;
                }
                if (device.getDeviceType().equalsIgnoreCase(Device.TYPE.GMAIL.getProduct()) && !userElement.isGmailBkpEnabled()) {
                    logger.debug("Gmail license is disabled for endpoint");
                    device.setBlocked(true);
                    blockDevice = true;
                    this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    continue;
                }
                if (!device.getDeviceType().equalsIgnoreCase(Device.TYPE.GOOGLEDRIVE.getProduct()) || userElement.isGdriveBkpEnabled()) continue;
                logger.debug("Gdrive license is disabled for endpoint");
                device.setBlocked(true);
                blockDevice = true;
                this.deviceManagementService.blockUnblockDevice(cloudId, cloudName, device, true);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
            }
        }
        return blockDevice;
    }

    private void createNewAuthorizationToken(int cloudId, String cloudName, com.parablu.pcbd.domain.User user, String deviceUUID) {
        AuthorizationTokens newAuthorizationTokens = new AuthorizationTokens();
        newAuthorizationTokens.setValiditoryPeriod(-10L);
        newAuthorizationTokens.setUniqueId(deviceUUID);
        newAuthorizationTokens.setModifiedTime(System.currentTimeMillis());
        newAuthorizationTokens.setToken(TokenGenerator.generateToken());
        newAuthorizationTokens.setUser(user);
        newAuthorizationTokens.setClientType(1);
        this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, newAuthorizationTokens);
    }

    @RequestMapping(value={"cloud/{cloudName}/user/block/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView blockUser(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView;
        block52: {
            String cloudName = cloudName1;
            modelAndView = new ModelAndView();
            modelAndView.setViewName("xmlview");
            logger.debug(CALLING_UPDATE_USER_INFO + userName);
            String blockedBy = request.getHeader(USER_NAME);
            boolean isSyncEnabled = false;
            boolean isBackupEnabled = false;
            boolean odbBkpEnabled = false;
            boolean exchangeBkpEnabled = false;
            boolean isMSPEnv = false;
            boolean gmailBkpEnabled = false;
            boolean gdriveBkpEnabled = false;
            int code = 0;
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            try {
                boolean userUnderLegalHold;
                if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                    throw new BaseException(INVALID_REQUEST);
                }
                userName = this.decodeBase64UTFString(userName);
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    return null;
                }
                cloudName = cl.getCloud().getCloudName();
                int cloudId = cl.getCloud().getCloudId();
                String token = request.getHeader("token");
                String revokeOwners = request.getHeader("revokeOwners");
                List list = cl.getCloud().getCloudCustomisableDetails();
                boolean active = Boolean.parseBoolean(request.getHeader("blocked"));
                if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                    return null;
                }
                UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
                boolean isUserActive = userElement.isActive();
                if (active) {
                    for (CloudCustomisableDetails customisableDetails : list) {
                        if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                            isSyncEnabled = true;
                        }
                        if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                            isBackupEnabled = true;
                        }
                        if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            odbBkpEnabled = true;
                        }
                        if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            exchangeBkpEnabled = true;
                        }
                        if ("MSP Environment Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            isMSPEnv = true;
                        }
                        if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            gmailBkpEnabled = true;
                        }
                        if (!"GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                        gdriveBkpEnabled = true;
                    }
                    logger.debug("is MSP enabled={}", (Object)isMSPEnv);
                    if (!isMSPEnv) {
                        code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud());
                        if (!this.checkLicense(code, response)) {
                            return null;
                        }
                    } else if (isMSPEnv) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)userElement.getUserType())) {
                            code = this.deviceAndUserSecurityService.validateBackupUserRestrictionsByPolicy(cloudId, cloudName, currentUser);
                        } else if (User.TYPE.SERVER.toString().equals(userElement.getUserType())) {
                            code = this.deviceAndUserSecurityService.validateBackupServerRestrictionsByPolicy(cloudId, cloudName, currentUser);
                        }
                        if (!this.checkLicense(code, response)) {
                            return null;
                        }
                    }
                    if (!userElement.isSyncEnabled()) {
                        isSyncEnabled = false;
                    }
                    if (!userElement.isBackupEnabled()) {
                        isBackupEnabled = false;
                    }
                    if (!userElement.isOnedriveBkpEnabled()) {
                        odbBkpEnabled = false;
                    }
                    if (!userElement.isExchangeBkpEnabled()) {
                        exchangeBkpEnabled = false;
                    }
                    if (!userElement.isGmailBkpEnabled()) {
                        gmailBkpEnabled = false;
                    }
                    if (!userElement.isGdriveBkpEnabled()) {
                        gdriveBkpEnabled = false;
                    }
                    if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                        logger.debug(" SYNC USER LIMIT REACHED........");
                        return null;
                    }
                    if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                        logger.debug("BACKUP USER LIMIT REACHED........");
                        return null;
                    }
                    if (exchangeBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloudId, cl.getCloud()), response)) {
                        logger.debug("O365 BACKUP USER LIMIT REACHED........");
                        return null;
                    }
                    if (odbBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloudId, cl.getCloud()), response)) {
                        logger.debug("O365 BACKUP USER LIMIT REACHED........");
                        return null;
                    }
                    if (gmailBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloudId, cl.getCloud()), response)) {
                        logger.debug("Gmail BACKUP USER LIMIT REACHED........");
                        return null;
                    }
                    if (gdriveBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloudId, cl.getCloud()), response)) {
                        logger.debug("Gdrive BACKUP USER LIMIT REACHED........");
                        return null;
                    }
                }
                userElement.setActive(active);
                boolean isSoftBlockEnabled = false;
                CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
                if (cloudPropertyElement != null && cloudPropertyElement.isSoftBlockEnabled()) {
                    isSoftBlockEnabled = true;
                }
                if (!active && !isSoftBlockEnabled) {
                    userElement.setBackupEnabled(false);
                    userElement.setSyncEnabled(false);
                    userElement.setOnedriveBkpEnabled(false);
                    userElement.setExchangeBkpEnabled(false);
                    userElement.setOffice365BkpEnabled(false);
                    userElement.setGmailBkpEnabled(false);
                }
                if (userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName)) {
                    response.setStatus(447);
                    return null;
                }
                List<UserDeviceAccessControl> assignedDevices = this.managementService.getUserDevicesAssignedTo(cloudId, cloudName, userName);
                if (active && assignedDevices.size() > 0 && revokeOwners.equalsIgnoreCase(FALSE)) {
                    response.setStatus(202);
                    return null;
                }
                if (active && assignedDevices.size() > 0 && revokeOwners.equalsIgnoreCase("true")) {
                    this.managementService.revokeAssignedDevicesBack(cloudId, cloudName, assignedDevices, blockedBy);
                }
                if (!isMSPEnv || currentUser.isAdmin()) {
                    this.managementService.blockOrUnblockUser(cloudId, userName, active, false);
                } else if (isMSPEnv && currentUser.isReadOnlyAdmin()) {
                    this.managementService.blockOrUnblockUser(cloudId, userName, active, true);
                }
                UserElement ue = this.managementService.getUserInfo(cloudId, cloudName, userName);
                this.managementService.updateUserStatusInDeviceBkpOverview(cloudId, ue.getUserName(), ue.isActive());
                modelAndView.addObject((Object)ue);
                response.setStatus(200);
                if (active && !isUserActive) {
                    if (isMSPEnv && User.TYPE.SERVER.toString().equals(userElement.getUserType())) {
                        this.managementService.blockUnblockDevicebyUserName(cloudId, cloudName, userName, false);
                    }
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UNBLOCK.getActionTypeValue());
                    break block52;
                }
                if (!isUserActive) break block52;
                List<Device> blockedDevices = this.managementService.blockUnblockDevicebyUserName(cloudId, cloudName, userName, true);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_BLOCK.getActionTypeValue());
                if (blockedDevices != null) {
                    for (Device device : blockedDevices) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    }
                }
                logger.debug("email={} and creating email props for block user mail", (Object)this.cloudMailService);
                if (User.TYPE.SERVER.toString().equals(ue.getUserType())) {
                    logger.debug("Action=block server, getting the server details");
                    com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
                    try {
                        BeanUtils.copyProperties((Object)user, (Object)ue);
                    }
                    catch (Exception e) {
                        logger.error("There is an error while sending server block mail");
                    }
                    logger.debug("Action=block server, getting the server device if there are any which are blocked");
                    if (blockedDevices != null && blockedDevices.size() > 0 && blockedDevices.get(0) != null) {
                        logger.debug("Action=block server, getting the server device to send mail ={}", (Object)blockedDevices.get(0).getDeviceName());
                        this.managementService.sendServerDeviceBlockDeleteEmail(cl.getCloud(), "device-blocked", blockedBy, user, blockedDevices.get(0).getDeviceName());
                    } else {
                        logger.debug("Action=block server, getting the server user to send mail ={}", (Object)ue.getUserName());
                        this.managementService.multipleUserBlockOrDeleteMail(cl.getCloud(), cloudName1, cloudId, blockedBy, userName, ue.getEmailId(), USER_BLOCKED);
                    }
                    break block52;
                }
                this.managementService.multipleUserBlockOrDeleteMail(cl.getCloud(), cloudName1, cloudId, blockedBy, userName, ue.getEmailId(), USER_BLOCKED);
            }
            catch (EmptyResultDataAccessException e) {
                ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
                modelAndView.addObject((Object)err);
                response.setStatus(409);
                logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
                logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
            }
            catch (DataAccessException e) {
                ErrorElement err = this.createErrorElement(null, null);
                modelAndView.addObject((Object)err);
                response.setStatus(500);
                logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
                logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            }
            catch (BaseException e) {
                ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
                modelAndView.addObject((Object)err);
                response.setStatus(400);
                logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
            }
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/user/update/consent/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView updateUserConsent(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(CALLING_UPDATE_USER_INFO + userName);
        try {
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String consent = request.getHeader("user-consent-given");
            String deviceName = request.getHeader(DEVICE_NAME);
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
            String userConsetGiven = "not answered";
            if (StringUtils.isNotEmpty((CharSequence)consent) && consent.contentEquals("yes")) {
                userConsetGiven = "Yes";
                userElement.setConsentGivenTime(System.currentTimeMillis());
            }
            userElement.setConsentGiven(consent);
            UserElement ue = this.managementService.updateUserInfo(cloudId, cloudName, userElement, userName);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "updated user consent as " + userConsetGiven, userElement.getUserName(), "", deviceName + " Endpoint", System.currentTimeMillis(), PCActionTypes.DEVICE_UPDATE.getActionTypeValue());
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/users/block/"}, method={RequestMethod.POST})
    public void blockMultipleUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String userNames = request.getHeader("userNames");
        logger.debug(CALLING_UPDATE_USER_INFO + userNames);
        String blockedBy = request.getHeader("blockedBy");
        try {
            int code;
            if (!org.springframework.util.StringUtils.hasText((String)userNames)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> userNameList = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            boolean active = Boolean.parseBoolean(request.getHeader("active"));
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName1)) {
                return;
            }
            if (active && !this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                return;
            }
            if (userNameList.contains(blockedBy)) {
                userNameList.remove(blockedBy);
            }
            for (String userName : userNameList) {
                this.blockOrUnblockUser(cloudName, userName, response, modelAndView, blockedBy, cloudId, active);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private UserElement blockOrUnblockUser(String cloudName, String userName, HttpServletResponse response, ModelAndView modelAndView, String blockedBy, int cloudId, boolean active) {
        UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
        if (userElement != null) {
            boolean isUserActive = userElement.isActive();
            userElement.setActive(active);
            List<UserDeviceAccessControl> assignedDevices = this.managementService.getUserDevicesAssignedTo(cloudId, cloudName, userName);
            if (active && assignedDevices.size() > 0) {
                this.managementService.revokeAssignedDevicesBack(cloudId, cloudName, assignedDevices, blockedBy);
            }
            this.managementService.blockOrUnblockUser(cloudId, userName, active, false);
            this.managementService.updateUserStatusInDeviceBkpOverview(cloudId, userElement.getUserName(), userElement.isActive());
            response.setStatus(200);
            if (active && !isUserActive) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "unblocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_UNBLOCK.getActionTypeValue());
            } else if (isUserActive) {
                List<Device> blockedDevices = this.managementService.blockUnblockDevicebyUserName(cloudId, cloudName, userName, true);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked user", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_BLOCK.getActionTypeValue());
                if (blockedDevices != null) {
                    for (Device device : blockedDevices) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "blocked Asset name:" + device.getDeviceName() + " of User:", blockedBy, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.DEVICE_BLOCK.getActionTypeValue());
                    }
                }
                return userElement;
            }
        }
        return null;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userId}/{userName}/"}, method={RequestMethod.DELETE})
    public ModelAndView deleteUser(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userId") String userId, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /deleteUser ...");
        try {
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userId) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cl.getCloud().getCloudName(), token = request.getHeader("token"), response, userName)) {
                return null;
            }
            boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
            if (userUnderLegalHold) {
                response.setStatus(447);
                return null;
            }
            UserElement userElement = this.managementService.deleteUser(cloudId, cloudName, userId);
            this.setSuccessResponseFields(response);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", userName, userElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/cmd/authenthicate"}, method={RequestMethod.GET})
    public ModelAndView passwordEncode(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        block7: {
            logger.debug("Inside the password authenticate api to encrypt the password given from command line execution and check if valid minicloud");
            ModelAndView modelAndView = new ModelAndView();
            modelAndView.setViewName("jsonview");
            String userName = null;
            String password = null;
            String clientType = null;
            String gatewayName = null;
            String cloudName = null;
            String token = null;
            String isMiniCloud = FALSE;
            String path = null;
            int cloudId = 1;
            password = request.getHeader(PASSWORD);
            userName = request.getHeader(USER_NAME);
            clientType = CMDLINE;
            gatewayName = request.getHeader(GATEWAY_NAME);
            cloudName = request.getHeader(CLOUD_NAME);
            path = request.getHeader(PATH);
            isMiniCloud = request.getHeader(IS_MINI_CLOUD);
            String ip = request.getRemoteAddr();
            String cipher = "AES/CBC/PKCS5Padding";
            String keyString = SECRET_KEY;
            String encrypted = UserManagementController.aesEncrypt(password, keyString, cipher);
            logger.debug("Encrypted: " + encrypted);
            RestTemplate restTemplate = new RestTemplate();
            ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add(USER_NAME, userName);
            headers.add(PASSWORD, encrypted);
            headers.add(CLIENT_TYPE, clientType);
            headers.add("ip", ip);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            String url = gatewayName + "paracloud/cloud/" + cloudName + "/authenthicate";
            logger.debug("authenticate url={}", (Object)url);
            try {
                ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, ModelAndView.class, new Object[0]);
                if (result != null) {
                    logger.debug("result of authentication={}", (Object)result.getStatusCode());
                    HttpHeaders responseHeaders = result.getHeaders();
                    token = responseHeaders.getFirst("token");
                    if (result.getStatusCode().equals((Object)HttpStatus.ACCEPTED)) {
                        logger.debug("User is authenticated");
                        if (isMiniCloud.equalsIgnoreCase("true")) {
                            path = path.replaceAll("/+", "/");
                            String[] params = path.split("/");
                            Object mcName = params[1];
                            mcName = MINI_CLOUD_CONSTANT + (String)mcName;
                            logger.debug("process=validate if it is a minicloud and if it is valid");
                            boolean validateMiniCloud = this.miniCloudAccessControlService.validateMiniCloudOperationAccessForUserCmdLine(cloudId, cloudName, userName, (String)mcName);
                            if (validateMiniCloud) {
                                logger.debug("It is a valid minicloud and user has access");
                                response.setHeader("miniCloudName", (String)mcName);
                                response.setHeader("validMiniCloud", "true");
                            } else {
                                response.setHeader("validMiniCloud", FALSE);
                            }
                        }
                        response.setStatus(202);
                        response.setHeader("token", token);
                        modelAndView.addObject("Authenticated", (Object)true);
                        return modelAndView;
                    }
                    logger.debug("User is not authenticated");
                    response.setStatus(result.getStatusCodeValue());
                    modelAndView.addObject("Authenticated", (Object)false);
                    return modelAndView;
                }
            }
            catch (Exception e) {
                logger.error("an error occurred e={}", (Throwable)e);
                if (!e.getMessage().contains("403")) break block7;
                response.setStatus(403);
            }
        }
        return null;
    }

    private static String aesEncrypt(String password, String keyString, String cipherString) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] keyBytes = md.digest(keyString.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(cipherString);
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] encryptedBytes = cipher.doFinal(password.getBytes(StandardCharsets.UTF_8));
            byte[] composed = new byte[iv.length + encryptedBytes.length];
            System.arraycopy(iv, 0, composed, 0, iv.length);
            System.arraycopy(encryptedBytes, 0, composed, iv.length, encryptedBytes.length);
            return java.util.Base64.getEncoder().encodeToString(composed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/generate/otp"}, method={RequestMethod.POST})
    public void generateIdentifierOtp(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String client = "";
        int cloudId = 0;
        UserElement ue = null;
        try {
            int clientType;
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                logger.debug("header name:" + header);
            }
            String uniqueId = request.getHeader("user-id");
            client = request.getHeader(CLIENT_TYPE);
            logger.debug("@@@  uniqueId ...." + uniqueId);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside authenticated invalid license ...");
                return;
            }
            if (client != null) {
                logger.debug("@@@ Inside client selection ...." + client);
                clientType = PCClientTypes.getClientType((String)client);
            } else {
                client = PORTAL;
                clientType = PCClientTypes.getClientType((String)client);
            }
            Cloud cloud = cl.getCloud();
            cloudId = cloud.getCloudId();
            String otp = new DecimalFormat("000000").format(new Random().nextInt(999999));
            ue = this.managementService.getUserByUserNameOrEmail(cloud, uniqueId);
            if (ue != null) {
                uniqueId = ue.getEmailId();
            }
            this.authorizationService1.updateOTPForUniqueId(cloudId, uniqueId, otp, clientType);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("exception while updating the otp..", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/generate/identifier"}, method={RequestMethod.GET})
    public void generateIdentifier(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        String client = "";
        int cloudId = 0;
        String token = null;
        String captcha = null;
        UserElement userElement = null;
        try {
            AuthorizationTokens authorizationTokens;
            int clientType;
            String username = request.getHeader(USER_NAME);
            client = request.getHeader(CLIENT_TYPE);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside authenticated invalid license ...");
                return;
            }
            if (client != null) {
                logger.debug("@@@ Inside client selection ...." + client);
                clientType = PCClientTypes.getClientType((String)client);
            } else {
                client = PORTAL;
                clientType = PCClientTypes.getClientType((String)client);
            }
            Cloud cloud = cl.getCloud();
            cloudId = cloud.getCloudId();
            com.parablu.pcbd.domain.User user = this.managementService.getUserDetails(cloudId, cloudName, username);
            if (this.isAADEnabled(cloud.getCloudCustomisableDetails()) && user == null) {
                logger.debug("AAD enable and user is null for userName " + username + " so check with field aadLoginId");
                userElement = this.managementService.getUserByAADLoginId(cloud, username);
            }
            UUID uuid = UUID.randomUUID();
            token = String.valueOf(uuid);
            captcha = this.getCaptcha();
            if (user == null && userElement == null) {
                logger.debug("user not present in our database so return");
                response.addHeader("captcha-value", captcha);
                response.addHeader("first-time-login", String.valueOf(false));
                response.addHeader("isSuperAdmin", String.valueOf(false));
                response.setStatus(200);
                return;
            }
            if (user == null && userElement != null) {
                user = this.managementService.getUserDetails(cloudId, cloudName, userElement.getUserName());
            }
            if ((authorizationTokens = this.authorizationService1.getLatestTokenByUserAndClientType(cloudId, cloudName, user, clientType)) != null) {
                authorizationTokens.setUniqueId(captcha);
                this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationTokens);
            } else {
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, user.getUserName(), clientType, captcha);
            }
            response.addHeader("captcha-value", captcha);
            response.addHeader("first-time-login", String.valueOf(user.isFirstLogin()));
            response.addHeader("isSuperAdmin", String.valueOf(user.isSuperAdmin()));
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception while creating captcha..", (Throwable)e);
            response.setStatus(500);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"cloud/{cloudName}/authenthicate"}, method={RequestMethod.GET})
    public ModelAndView authenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        UserElement userElement = new UserElement();
        ModelAndView modelAndView = new ModelAndView();
        String captcha = "";
        boolean captchaValidation = true;
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        String client = "";
        client = request.getHeader(CLIENT_TYPE);
        int cloudId = 0;
        String ip = request.getHeader("ip");
        String osType = request.getHeader(OS_TYPE);
        String browser = request.getHeader(BROWSER);
        Object hostIPDomain = "";
        if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
            hostIPDomain = " from the  ip address " + ip + " using the domain Name " + browser + " and the OS Type was  " + osType;
        }
        if (CMDLINE.equalsIgnoreCase(client)) {
            logger.debug("ip address={}", (Object)ip);
            hostIPDomain = " from the  ip address " + ip;
        }
        try {
            String decryptedPwd;
            String token;
            AADUserElement aadUserByCode;
            int clientType;
            Cloud cloud;
            CloudLicenseTo cl;
            String username;
            String deviceName;
            String password;
            block54: {
                password = request.getHeader(PASSWORD);
                deviceName = request.getHeader(DEVICE_NAME);
                username = request.getHeader(USER_NAME);
                String accesskey = request.getHeader("accessKey");
                captcha = request.getHeader("captcha-value");
                cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    logger.debug("@@@ Inside authenticated invalid license ...");
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed from due to license expired" + client + (String)hostIPDomain, username + " ", "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                    return null;
                }
                cloudId = cl.getCloud().getCloudId();
                this.setRateLimiter(cloudId);
                rateLimiter.acquire();
                logger.debug(rateLimiter.getRate() + ": rate limit rate.. ip ostype, browser ........new changes from druva................ " + ip + ".. " + osType + "...." + browser);
                cloud = cl.getCloud();
                cloudName = cloud.getCloudName();
                if (client != null) {
                    logger.debug("@@@ Inside client selection ...." + client);
                    clientType = PCClientTypes.getClientType((String)client);
                } else {
                    client = PORTAL;
                    clientType = PCClientTypes.getClientType((String)client);
                }
                cloudId = cloud.getCloudId();
                aadUserByCode = null;
                if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails()) && org.springframework.util.StringUtils.isEmpty((Object)password)) {
                    String aadAuthCode = request.getHeader("aadAuthCode");
                    if (org.springframework.util.StringUtils.isEmpty((Object)aadAuthCode)) {
                        logger.debug("Password and auth code is empty...");
                        response.setStatus(400);
                        return null;
                    }
                    String redirectUrlFromHeader = request.getHeader("redirectHost");
                    aadUserByCode = this.aadManagementService.getAADUserByCode(aadAuthCode, cl.getCloud(), true, redirectUrlFromHeader, "");
                    if (aadUserByCode == null) {
                        logger.debug("Failed to get aad user using aadAuthCode :" + aadAuthCode);
                        response.setStatus(440);
                        return null;
                    }
                    logger.debug("Got AAD user form aadAuthCode " + aadUserByCode.getUserPrincipalName());
                    username = aadUserByCode.getUserPrincipalName();
                }
                token = null;
                if (org.springframework.util.StringUtils.isEmpty((Object)username)) {
                    response.setStatus(400);
                    return null;
                }
                AuthorizationTokens authorizationTokens = this.getAuthorizationTokens(cloudName, username, cloudId, clientType);
                if (authorizationTokens == null) {
                    UUID uuid = UUID.randomUUID();
                    token = String.valueOf(uuid);
                    logger.debug(token + " addTokenByUser  .... " + client);
                    this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                    authorizationTokens = this.getAuthorizationTokens(cloudName, username, cloudId, clientType);
                }
                if (!(captchaValidation = this.validateCaptcha(cloudName, username, cloudId, captcha, captchaValidation, clientType, authorizationTokens))) {
                    response.setStatus(400);
                    return null;
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)accesskey)) {
                    OTPValidation otpValidation;
                    if (!StringUtils.isNotEmpty((CharSequence)username)) {
                        logger.error("unique id not found....");
                        response.setStatus(451);
                        return null;
                    }
                    String uniqueIdToCheckOTP = username;
                    UserElement ue = this.managementService.getUserByUserNameOrEmail(1, username);
                    if (ue != null) {
                        uniqueIdToCheckOTP = ue.getEmailId();
                    }
                    if ((otpValidation = this.authorizationService1.getOTPForUniqueId(1, uniqueIdToCheckOTP)) == null || !accesskey.equalsIgnoreCase(otpValidation.getToken())) {
                        logger.error("access key validation not successfull..");
                        response.setStatus(451);
                        return null;
                    }
                    if (accesskey.equalsIgnoreCase(otpValidation.getToken()) && otpValidation.getModifiedTime() + (long)(this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000) < System.currentTimeMillis()) {
                        logger.error("access key validation not successfull.." + this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000);
                        response.setStatus(451);
                        return null;
                    }
                    this.updateToken(cloudName, cloudId, authorizationTokens);
                } else {
                    this.updateToken(cloudName, cloudId, authorizationTokens);
                }
                try {
                    decryptedPwd = this.getDecryptePassword(password);
                    logger.debug("checking for user info>>>>>>>>>>if not migrate from AD..........");
                    userElement = this.managementService.getUserByUserName(cloud, username);
                    if (userElement == null) {
                        logger.debug("AAD enable and user is null for userName " + username + " so check with field aadLoginId");
                        userElement = this.managementService.getUserByAADLoginId(cloud, username);
                    }
                    if (userElement != null && userElement.isGuest()) {
                        logger.debug("user exists removeUserbyID........ " + String.valueOf(userElement.getUserId()));
                        this.managementService.removeUserbyID(cloudId, userElement.getUserId().toString());
                        userElement = null;
                    }
                    CloudPropertyElement cloudPropertyElement = this.cloudSettingService.getCloudPropertyElement(cloudId);
                    if (userElement != null && userElement.isSuperAdmin() && userElement.isLocalUser()) {
                        if (org.springframework.util.StringUtils.isEmpty((Object)accesskey)) {
                            response.setStatus(451);
                            return null;
                        }
                        userElement.setBackupEnabled(true);
                        userElement.setSyncEnabled(true);
                        userElement.setOnedriveBkpEnabled(true);
                        userElement.setShareEnabled(true);
                        userElement.setExchangeBkpEnabled(true);
                        userElement.setGmailBkpEnabled(true);
                        userElement.setGdriveBkpEnabled(true);
                    }
                    if (userElement != null && !userElement.isGuest()) {
                        logger.debug("user exists ........ " + userElement.getUserName());
                        if (userElement.isSuspended()) {
                            logger.debug("User is suspended.....");
                            response.setStatus(451);
                            return null;
                        }
                        if (userElement.getBackupPolicyElement() != null && !userElement.getBackupPolicyElement().isWebBasedLogin() || userElement.getSyncPolicyElement() != null && !userElement.getSyncPolicyElement().isWebBasedLogin() || userElement.getOfficeBackupPolicyElement() != null && !userElement.getOfficeBackupPolicyElement().isWebBasedLogin() || userElement.getGmailBackupPolicyElement() != null && !userElement.getGmailBackupPolicyElement().isWebBasedLogin()) {
                            logger.debug("User is web based login is disabled.....");
                            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed due to web based login disabled " + client + (String)hostIPDomain, userElement.getUserName(), "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                            response.setStatus(452);
                            return null;
                        }
                        break block54;
                    }
                    if (this.isAADEnabled(cloud.getCloudCustomisableDetails()) || this.isLicenseEnabled(cloud.getCloudCustomisableDetails(), "GMAIL Backup Enabled") || this.isLicenseEnabled(cloud.getCloudCustomisableDetails(), "GDRIVE Backup Enabled")) {
                        try {
                            boolean success = false;
                            logger.debug("....user migrate from aad..." + username + "...code..." + String.valueOf(aadUserByCode));
                            success = cloud.getGraphAADEnabled() == 1 ? this.migrateUserFromNewAAD(aadUserByCode, cl, cloud, cloudName, response) : (aadUserByCode == null ? this.migrateUserFromAAD(username, decryptedPwd, cl, cloud, cloudName, response) : this.migrateUserFromAAD(aadUserByCode, cl, cl.getCloud(), cloudName, response, null, false));
                            if (!success) {
                                logger.error(" Authentication failed form AAD for user " + username + "............");
                                if (org.springframework.util.StringUtils.isEmpty((Object)password)) {
                                    response.setStatus(440);
                                    return null;
                                }
                                response.setStatus(401);
                                return null;
                            }
                            userElement = this.managementService.getUserByUserNameOrEmail(cloud, username);
                            break block54;
                        }
                        catch (BaseException e) {
                            logger.debug("Exception :" + e.getMessage());
                            response.setStatus(417);
                            return null;
                        }
                    }
                    if (!this.isLdapEnabledForCloud(cl)) {
                        response.setStatus(401);
                        logger.debug(".......user not found......");
                        return null;
                    }
                    try {
                        boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                        if (!success) {
                            logger.error(" Authentication failed  for user " + username + "............");
                            return null;
                        }
                        userElement = this.managementService.getUserByUserName(cloud, username);
                    }
                    catch (BaseException e) {
                        logger.debug("Exception :" + e.getMessage());
                        response.setStatus(417);
                        return null;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    logger.trace(BASE_EXCEPTION + String.valueOf(exception));
                    logger.error("@@@ Inside authentication BaseException.try.." + exception.getMessage());
                    logger.error("Exception e={}", (Throwable)exception);
                    response.setStatus(400);
                    return null;
                }
            }
            decryptedPwd = this.getDecryptePassword(password);
            if (org.springframework.util.StringUtils.isEmpty((Object)userElement.getPasswdHash())) {
                boolean isAuthenticated = false;
                if (this.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                    if (aadUserByCode == null) {
                        isAuthenticated = this.authenticateAADUser(cl.getCloud(), userElement, decryptedPwd);
                    } else {
                        logger.debug("Since AAD login happen using code no need to authenticate...");
                        isAuthenticated = true;
                    }
                } else if (this.isLdapEnabledForCloud(cl)) {
                    String userElementToCheck = userElement.getUserName();
                    if (!org.springframework.util.StringUtils.isEmpty((Object)userElement.getAadLoginId())) {
                        userElementToCheck = userElement.getAadLoginId();
                    }
                    Object[] objArr = this.ldapService.authenticate(cloudId, userElementToCheck, decryptedPwd);
                    isAuthenticated = (Boolean)objArr[0];
                }
                if (!isAuthenticated) {
                    response.setStatus(400);
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed from " + client + (String)hostIPDomain, userElement.getUserName(), "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                    return null;
                }
                UserElement ue = this.getUserElement(userElement.getUserName(), cloud);
                logger.debug(" USer authenticated .... " + userElement.getUserName() + ".... is active ...." + ue.isActive());
                if (!ue.isActive()) {
                    throw new BaseException("User is not active", 403);
                }
                client = org.springframework.util.StringUtils.isEmpty((Object)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                logger.debug(token + " addTokenByUser  .... " + client);
                this.authorizationService1.deleteToken(cloudId, username, clientType);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userElement.getUserName(), clientType);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client + (String)hostIPDomain, userElement.getUserName(), "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                ue.setEmailId(this.encodeUTFBase64(ue.getEmailId()));
                ue.setDisplayName(this.encodeUTFBase64(ue.getDisplayName()));
                modelAndView.addObject((Object)ue);
                this.managementService.updateUserLoggedInTime(cloudId, userElement.getUserName());
            } else {
                String passwordHash = this.generatePassWordhash(decryptedPwd);
                com.parablu.pcbd.domain.User u = this.managementService.authenticate(cloudId, cloudName, userElement.getUserName(), passwordHash);
                client = org.springframework.util.StringUtils.isEmpty((Object)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client + (String)hostIPDomain, userElement.getUserName(), "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userElement.getUserName(), clientType);
                if (u.isFirstLogin()) {
                    response.setHeader("firstLogin", "true");
                } else {
                    response.setHeader("firstLogin", FALSE);
                }
                UserElement ue = this.getUserElement(userElement.getUserName(), cloud);
                if (ue.isSuperAdmin()) {
                    userElement.setBackupEnabled(true);
                    userElement.setSyncEnabled(true);
                    userElement.setOnedriveBkpEnabled(true);
                    userElement.setShareEnabled(true);
                    userElement.setExchangeBkpEnabled(true);
                }
                ue.setPasswdHash(null);
                ue.setSecurityRecoveryKey(null);
                ue.setGoogleSecretKey(null);
                ue.setUserNameLowerCase(null);
                ue.setUserPrinicipalName(null);
                ue.setAzureUniqueId(null);
                ue.setEmailId(this.encodeUTFBase64(ue.getEmailId()));
                ue.setDisplayName(this.encodeUTFBase64(ue.getDisplayName()));
                logger.debug(ue.isOnedriveBkpEnabled() + GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                modelAndView.addObject((Object)ue);
                this.managementService.updateUserLoggedInTime(cloudId, userElement.getUserName());
            }
            boolean isLDAPEnabled = this.isLdapEnabledForCloud(cl);
            boolean isAADEnabled = this.isAADEnabled(cloud.getCloudCustomisableDetails());
            response.setHeader(LDAP_ENABLED, Boolean.toString(isLDAPEnabled));
            response.setHeader(AAD_ENABLED, Boolean.toString(isAADEnabled));
            response.setHeader("token", token);
            response.setHeader(CLOUD_NAME, cloud.getCloudName());
            response.setStatus(202);
            response.setHeader("Access-Control-Expose-Headers", "token, firstLogin, cloudName, connectedClients");
            return modelAndView;
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + String.valueOf((Object)e));
            response.setStatus(401);
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + e.getMessage());
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error("@@@ Inside authenticate DataAccessException ..." + e.getMessage());
            response.setStatus(401);
            return modelAndView;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error("@@@ Inside authentication BaseException..." + e.getMessage());
            if ("Bad Credentials.".equalsIgnoreCase(e.getMessage())) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login failed from " + client + (String)hostIPDomain, userElement.getUserName(), "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
            response.setStatus(e.getErrorStatus());
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("@@@ Exception...={}", (Throwable)e);
        }
        return modelAndView;
    }

    private AuthorizationTokens getAuthorizationTokens(String cloudName, String username, int cloudId, int clientType) {
        com.parablu.pcbd.domain.User user = this.managementService.getUserDetails(cloudId, cloudName, username);
        AuthorizationTokens authorizationTokens = this.authorizationService1.getLatestTokenByUserAndClientType(cloudId, cloudName, user, clientType);
        return authorizationTokens;
    }

    private void setRateLimiter(int cloudId) {
        if (rateLimiter == null) {
            logger.debug("getAllowedLoginApiCallsPerMin:" + this.registry.get(cloudId).getAllowedLoginApiCallsPerMin());
            double limit = (double)this.registry.get(cloudId).getAllowedLoginApiCallsPerMin() / 60.0;
            logger.debug("getAllowedLoginApiCallsPerMin:" + limit);
            rateLimiter = RateLimiter.create((double)limit);
        }
    }

    private boolean validateCaptcha(String cloudName, String username, int cloudId, String captcha, boolean captchaValidation, int clientType, AuthorizationTokens authorizationTokens) {
        if (authorizationTokens != null) {
            if (authorizationTokens.getUniqueId() != null) {
                if (!captcha.equals(authorizationTokens.getUniqueId())) {
                    captchaValidation = false;
                }
            } else {
                captchaValidation = authorizationTokens.getUniqueId() == null && captcha == null;
            }
        }
        return captchaValidation;
    }

    private boolean migrateUserFromNewAAD(AADUserElement aadUser, CloudLicenseTo cl, Cloud cloud, String cloudName, HttpServletResponse response) {
        boolean success = false;
        if (aadUser == null) {
            logger.debug("aadUser user is null ");
            return success;
        }
        aadUser.setProductType("BOTH");
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        int cloudId = cl.getCloud().getCloudId();
        List list = cl.getCloud().getCloudCustomisableDetails();
        for (CloudCustomisableDetails customisableDetails : list) {
            if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                isSyncEnabled = true;
            }
            if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                isBackupEnabled = true;
            }
            if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                odbBkpEnabled = true;
            }
            if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                exchangeBkpEnabled = true;
            }
            if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                gmailBkpEnabled = true;
            }
            if (!"GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
            gdriveBkpEnabled = true;
        }
        if ("SYNC".equalsIgnoreCase(aadUser.getProductType())) {
            isBackupEnabled = false;
        }
        if ("BACKUP".equalsIgnoreCase(aadUser.getProductType())) {
            isSyncEnabled = false;
        }
        int code = 0;
        if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug(" SYNC USER LIMIT REACHED........");
            isSyncEnabled = false;
        }
        if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloud.getCloudId(), cloudName, cl.getCloud()), response)) {
            logger.debug("BACKUP USER LIMIT REACHED........");
            isBackupEnabled = false;
        }
        if (exchangeBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("O365 BACKUP USER LIMIT REACHED........");
            exchangeBkpEnabled = false;
        }
        if (odbBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("O365 BACKUP USER LIMIT REACHED........");
            odbBkpEnabled = false;
        }
        if (gmailBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GMAIL BACKUP USER LIMIT REACHED........");
            gmailBkpEnabled = false;
        }
        if (gdriveBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloud.getCloudId(), cl.getCloud()), response)) {
            logger.debug("GDRIVE BACKUP USER LIMIT REACHED........");
            gdriveBkpEnabled = false;
        }
        if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled || gmailBkpEnabled || gdriveBkpEnabled)) {
            response.setStatus(417);
            logger.debug("...user limit reached....");
            return success;
        }
        LdapUserElement ldapUserElement = new LdapUserElement();
        ldapUserElement.setUserName(aadUser.getUserPrincipalName());
        ldapUserElement.setEmailId(aadUser.getMail());
        ldapUserElement.setDisplayName(aadUser.getDisplayName());
        ldapUserElement.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
        ldapUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
        ldapUserElement.setDefaultO365Policy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
        ldapUserElement.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
        ldapUserElement.setDefaultGdrivePolicyName(this.registry.get(cloudId).getDefaultGdrivePolicyName());
        ldapUserElement.setLocation(aadUser.getOfficeLocation());
        ldapUserElement.setDepartment(aadUser.getDepartment());
        ldapUserElement.setAccountStatus(true);
        boolean userCreated = false;
        try {
            userCreated = this.managementService.createUserFromLdap(cloud.getCloudId(), cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, gmailBkpEnabled, gdriveBkpEnabled);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        if (userCreated) {
            this.auditHistoryService.saveStatisticToDatabase(cloud.getCloudId(), cloudName, "migrated", "Auto", ldapUserElement.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.AAD_USER_MIGRATION.getActionTypeValue());
            success = true;
        }
        return success;
    }

    private String encodeUTFBase64(String input) {
        try {
            if (org.springframework.util.StringUtils.isEmpty((Object)input)) {
                return "";
            }
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    private String generatePassWordhash(String passHash) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] digesta = null;
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512", "BC");
            digesta = mda.digest(passHash.getBytes());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.trace("getSHA512hash : " + String.valueOf(e));
            logger.trace(e.getMessage());
        }
        return Hex.encodeHexString((byte[])digesta);
    }

    private String getDecryptePassword(String ldapPwdEnc) {
        String decryptedPwd = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)ldapPwdEnc)) {
            try {
                decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + String.valueOf(e));
                logger.error("ERROR in decryption ... " + e.getMessage());
            }
        }
        return decryptedPwd;
    }

    private boolean checkWithADandMigrateUser(CloudLicenseTo cl, int cloudId, String cloudName, String userName, HttpServletResponse response) {
        boolean success = false;
        boolean isSyncEnabled = false;
        boolean isBackupEnabled = false;
        boolean odbBkpEnabled = false;
        boolean exchangeBkpEnabled = false;
        boolean gmailBkpEnabled = false;
        boolean gdriveBkpEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        try {
            Person person = this.ldapService.getPerson(cloudId, userName);
            if (person != null) {
                int code;
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId()) || !person.isAccountStatus()) {
                    return false;
                }
                UserElement user = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), userName);
                if (user != null && user.getEmailId().equalsIgnoreCase(person.getEmailId())) {
                    logger.error(" .........username or email id already exists.......");
                    return false;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId())) {
                    logger.debug(" .....no emailId configured in AD.........." + person.getFullName());
                    return false;
                }
                for (CloudCustomisableDetails customisableDetails : list) {
                    if (customisableDetails.getName().equalsIgnoreCase(SYNC_ENABLED)) {
                        isSyncEnabled = true;
                    }
                    if (customisableDetails.getName().equalsIgnoreCase(BACK_UP_ENABLED)) {
                        isBackupEnabled = true;
                    }
                    if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        odbBkpEnabled = true;
                    }
                    if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        exchangeBkpEnabled = true;
                    }
                    if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                        gmailBkpEnabled = true;
                    }
                    if (!"GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                    gdriveBkpEnabled = true;
                }
                if (isBackupEnabled && "sync".equalsIgnoreCase(person.getAdGroupType())) {
                    isBackupEnabled = false;
                }
                if (isSyncEnabled && BACKUP.equalsIgnoreCase(person.getAdGroupType())) {
                    isSyncEnabled = false;
                }
                if (!this.checkLicense(code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "User");
                    return success;
                }
                if (isSyncEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateSyncUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug(" SYNC USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "Sync User");
                    return success;
                }
                if (isBackupEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateBackupUserRestrictions(cloudId, cloudName, cl.getCloud()), response)) {
                    logger.debug("BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "Backup User");
                    return success;
                }
                if (exchangeBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateExchangeUserRestrictions(cloudId, cl.getCloud()), response)) {
                    logger.debug("O365 BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "O365 Backup User");
                    return success;
                }
                if (odbBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateOnedriveUserRestrictions(cloudId, cl.getCloud()), response)) {
                    logger.debug("O365 BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "O365 Backup User");
                    return success;
                }
                if (gmailBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGmailUserRestrictions(cloudId, cl.getCloud()), response)) {
                    logger.debug("GMAIL BACKUP USER LIMIT REACHED........");
                    this.sendEmailForUserDeviceLimitExceeded(cl.getCloud(), cloudName, person.getFullName(), "GMAIL Backup User");
                    return success;
                }
                if (gdriveBkpEnabled && !this.checkLicense(code = this.deviceAndUserSecurityService.validateGdriveUserRestrictions(cloudId, cl.getCloud()), response)) {
                    logger.debug("GDRIVE BACKUP USER LIMIT REACHED........");
                    gdriveBkpEnabled = false;
                }
                LdapUserElement ldapUserElement = new LdapUserElement();
                ldapUserElement.setUserName(person.getFullName());
                ldapUserElement.setEmailId(person.getEmailId());
                ldapUserElement.setOrganizationUnit(person.getOrganizationalUnit());
                ldapUserElement.setDisplayName(person.getDisplayName());
                ldapUserElement.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                ldapUserElement.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                ldapUserElement.setLocation(person.getLocation());
                ldapUserElement.setDepartment(person.getDepartment());
                ldapUserElement.setAccountStatus(person.isAccountStatus());
                ldapUserElement.setDefaultGmailPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                ldapUserElement.setDefaultGdrivePolicyName(this.registry.get(cloudId).getDefaultGdrivePolicyName());
                boolean userCreated = this.managementService.createUserFromLdap(cloudId, cloudName, ldapUserElement, "AUTO", isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, gmailBkpEnabled, gdriveBkpEnabled);
                if (userCreated) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "migrated", "Auto", userName, "Portal", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                    success = true;
                }
            } else {
                response.setStatus(401);
                logger.debug(" PERSON NOT FOUND  ..... " + userName);
                success = false;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(401);
            success = false;
        }
        return success;
    }

    private boolean migrateUserBasedOnProductType(CloudLicenseTo cl, int cloudId, String cloudName, LdapUserElement ldapUser, HttpServletResponse response, boolean isSyncEnable, boolean isBackupEnable, boolean odbBkpEnable, boolean exchangeBkpEnable, String migratedBy, boolean gmailBkpEnabled, boolean gdriveBkpEnabled) {
        boolean userMigrated = false;
        boolean isSyncEnabled = isSyncEnable;
        boolean isBackupEnabled = isBackupEnable;
        boolean odbBkpEnabled = odbBkpEnable;
        boolean exchangeBkpEnabled = exchangeBkpEnable;
        boolean gmailBkpEnabled1 = gmailBkpEnabled;
        boolean gdriveBkpEnabled1 = gdriveBkpEnabled;
        try {
            Person person = this.ldapService.getPersonByUserName(cloudId, ldapUser.getUserName());
            if (person != null) {
                boolean userCreated;
                if (isBackupEnabled && "sync".equalsIgnoreCase(person.getAdGroupType())) {
                    isBackupEnabled = false;
                }
                if (isSyncEnabled && BACKUP.equalsIgnoreCase(person.getAdGroupType())) {
                    isSyncEnabled = false;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)person.getEmailId())) {
                    logger.debug(" .....no emailId configured in AD.........." + person.getFullName());
                    MigrationStatus migrationStatus = new MigrationStatus();
                    migrationStatus.setMigratedBy(migratedBy);
                    migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
                    migrationStatus.setMigrated(false);
                    migrationStatus.setReason("Email Id is empty");
                    migrationStatus.setUserName(person.getFullName());
                    this.managementService.saveMigrationStatus(cloudId, migrationStatus);
                    return userMigrated;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultSyncPolicy())) {
                    ldapUser.setDefaultSyncPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                }
                if (isBackupEnabled && org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultPolicy())) {
                    ldapUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                }
                if ((odbBkpEnabled || exchangeBkpEnabled) && org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultO365Policy())) {
                    ldapUser.setDefaultPolicy(this.registry.get(cloudId).getPropertyFileValueDefaultO365PolicyName());
                }
                if (gmailBkpEnabled1 && org.springframework.util.StringUtils.isEmpty((Object)ldapUser.getDefaultGmailPolicy())) {
                    ldapUser.setDefaultPolicy(this.registry.get(cloudId).getDefaultGmailPolicy());
                }
                if (userCreated = this.managementService.createUserFromLdap(cloudId, cloudName, ldapUser, migratedBy, isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, gmailBkpEnabled1, gdriveBkpEnabled1)) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "migrated", migratedBy, ldapUser.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.AD_USER_MIGRATION.getActionTypeValue());
                    userMigrated = true;
                }
            }
        }
        catch (Exception e) {
            MigrationStatus migrationStatus = new MigrationStatus();
            migrationStatus.setMigratedBy(migratedBy);
            migrationStatus.setMigratededTimestamp(System.currentTimeMillis());
            migrationStatus.setMigrated(false);
            migrationStatus.setReason("Failed to get user form AD");
            migrationStatus.setUserName(ldapUser.getUserName());
            migrationStatus.setEmailId(ldapUser.getEmailId());
            this.managementService.saveMigrationStatus(cloudId, migrationStatus);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(" Exception  :----------" + e.getMessage());
        }
        return userMigrated;
    }

    @RequestMapping(value={"cloud/{cloudName}/adauthenticate"}, method={RequestMethod.GET})
    public ModelAndView adAuthenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        logger.debug("calling /adauthenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        try {
            Object[] objArr;
            boolean isAuthenticated;
            CloudLicenseTo cl;
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader(DEVICE_NAME);
            String client = PORTAL;
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader(CLIENT_TYPE))) {
                client = request.getHeader(CLIENT_TYPE).toLowerCase();
            }
            if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
                logger.debug("@@@ Inside authenticate invalid license ...");
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                logger.debug("@@@ Inside client selection ..." + client);
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            String ldapPwdEnc = request.getHeader("ldapPwdEnc");
            String decryptedPwd = null;
            if (!StringUtils.isEmpty((CharSequence)ldapPwdEnc)) {
                try {
                    decryptedPwd = this.decrypt(ldapPwdEnc, SECRET_KEY);
                }
                catch (Exception e) {
                    logger.debug("ERROR in decryption ... " + e.getMessage());
                    logger.error(EXCEPTION + String.valueOf(e));
                }
            }
            if (!(isAuthenticated = ((Boolean)(objArr = this.ldapService.authenticate(cloudId, userName, decryptedPwd))[0]).booleanValue())) {
                logger.debug("NOTINSIDEAUTHENTICATE LDAP ENABLED .............." + decryptedPwd);
                response.setStatus(400);
                return null;
            }
            com.parablu.pcbd.domain.User u = this.managementService.getUserDetails(cloudId, cloudName, userName);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userName, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                if (devices != null && !devices.isEmpty()) {
                    response.setHeader("has-connected-clients", "true");
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (DataAccessException e) {
            logger.trace("@@@ Inside authenticate DataAccessException...." + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (BaseException e) {
            logger.trace("@@@ Inside authenticate BaseException..." + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/auth/gen"}, method={RequestMethod.GET})
    public void generateProxyToken(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /generateProxyToken ...");
        String cloudName = cloudName1;
        try {
            String username = request.getHeader(USER_NAME);
            String token = request.getHeader("token");
            if (!org.springframework.util.StringUtils.hasText((String)username)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName = cl.getCloud().getCloudName(), token, cl.getCloud());
            if (!this.checkLicense(code.getStatus(), response)) {
                return;
            }
            String newtoken = TokenGenerator.generateToken();
            int clientType = 2;
            UserElement userElement = this.managementService.getUserByUserName(cl.getCloud(), username);
            if (userElement != null && userElement.getBackupPolicyElement() != null && !userElement.getBackupPolicyElement().isWebBasedLogin() || userElement.getSyncPolicyElement() != null && !userElement.getSyncPolicyElement().isWebBasedLogin()) {
                logger.debug("User is web based login is disabled.....");
                response.setStatus(452);
                return;
            }
            if (userElement != null && !userElement.isSuspended()) {
                com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
                BeanUtils.copyProperties((Object)user, (Object)userElement);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, newtoken, user, clientType);
                response.setHeader("token", newtoken);
                response.setHeader(CLOUD_NAME, cloudName);
                response.setStatus(200);
            } else {
                logger.debug("User is null or suspended for userName " + username);
                response.setStatus(200);
            }
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/auth/validate"}, method={RequestMethod.GET})
    public void validateProxyToken(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /validateProxyToken ...");
        String cloudName = cloudName1;
        try {
            String username = request.getHeader(USER_NAME);
            String proxyToken = request.getHeader("token");
            String ip = request.getHeader("ip");
            String osType = request.getHeader(OS_TYPE);
            String browser = request.getHeader(BROWSER);
            Object hostIPDomain = "";
            if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                hostIPDomain = " from the IP Address " + ip + " using the Domain Name " + browser + " and the OS Type was " + osType;
            }
            if (!org.springframework.util.StringUtils.hasText((String)username)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            logger.debug("@@@ Inside validateProxyToken before validateLicense ...");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside validateProxyToken invalid license ...");
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            logger.debug("@@@ Inside validating token from DB");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, proxyToken);
            if (authorizationTokens == null) {
                response.setStatus(421);
                return;
            }
            if (!authorizationTokens.getUser().getUserName().equals(username)) {
                response.setStatus(401);
                logger.debug("@@@ Inside validateProxyToken after splitting value ...");
                return;
            }
            com.parablu.pcbd.domain.User u = this.managementService.getUserDetails(cloudId, cloudName, username);
            this.authorizationService1.deleteToken(cloudId, cloudName, authorizationTokens);
            int clientType = 2;
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged into portal" + (String)hostIPDomain, username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String newToken1 = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, newToken1, username, clientType);
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            boolean isLDAPEnabled = this.isLdapEnabledForCloud(cl);
            boolean isAADEnabled = this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails());
            response.setHeader(LDAP_ENABLED, Boolean.toString(isLDAPEnabled));
            response.setHeader(AAD_ENABLED, Boolean.toString(isAADEnabled));
            response.setHeader("token", newToken1);
            response.setStatus(202);
            logger.debug("@@@ end of validateProxyToken ");
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/password/reset"}, method={RequestMethod.GET})
    public void resetPassword(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        block15: {
            logger.debug(CALLING_VERIFY_RECOVERY_KEY);
            String cloudName = cloudName1;
            boolean captchaValidation = true;
            try {
                String username = request.getHeader(USER_NAME);
                String captcha = request.getHeader("captcha-value");
                String client = request.getHeader(CLIENT_TYPE);
                if (!org.springframework.util.StringUtils.hasText((String)username)) {
                    response.setStatus(400);
                    return;
                }
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                if (!this.checkLicense(cl, response)) {
                    return;
                }
                if (client != null) {
                    logger.debug("@@@ Inside client selection ...." + client);
                    int clientType = PCClientTypes.getClientType((String)client);
                } else {
                    client = PORTAL;
                    int clientType = PCClientTypes.getClientType((String)client);
                }
                cloudName = cl.getCloud().getCloudName();
                int cloudId = cl.getCloud().getCloudId();
                UUID uuid = UUID.randomUUID();
                String recoveryKey = String.valueOf(uuid);
                UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
                if (element == null) {
                    response.setStatus(403);
                    return;
                }
                if (org.springframework.util.StringUtils.isEmpty((Object)element.getPasswdHash())) {
                    response.setHeader("ldapuser", "true");
                    response.setStatus(400);
                    return;
                }
                username = element.getUserName();
                CacheHelper cacheHelper = new CacheHelper(cloudId, this.registry);
                username = username.replaceAll(" ", "_");
                cacheHelper.addValueToCache(username + RESET_PASSWORD, recoveryKey, 1800);
                response.setHeader("email", element.getEmailId());
                response.setHeader(USER_NAME, username);
                response.setHeader(RESET_PASSWORD_KEY, recoveryKey);
                if (!element.isAdmin()) {
                    if (this.registry.get(cloudId).isPasswordChangeEnforce()) {
                        if (!this.registry.get(cloudId).isCanUserChangePassword()) {
                            response.setHeader("changepassword", FALSE);
                            response.setStatus(622);
                            return;
                        }
                        break block15;
                    }
                    if (element.getBackupPolicyElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)element.getBackupPolicyElement().isCanUserChangePassword()) && !element.getBackupPolicyElement().isCanUserChangePassword() || element.getSyncPolicyElement() != null && !org.springframework.util.StringUtils.isEmpty((Object)element.getSyncPolicyElement().isCanUserChangePassword()) && !element.getSyncPolicyElement().isCanUserChangePassword()) {
                        response.setHeader("changepassword", FALSE);
                        response.setStatus(622);
                        return;
                    }
                    response.setStatus(200);
                    return;
                }
                response.setStatus(200);
                return;
            }
            catch (IOException e) {
                response.setStatus(500);
                logger.trace(IO_EXCEPTION + String.valueOf(e));
                logger.error(IO_EXCEPTION + e.getMessage());
                return;
            }
            catch (DataIntegrityViolationException e) {
                response.setStatus(401);
                logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
                logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            }
            catch (DataAccessException e) {
                response.setStatus(401);
                logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
                logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
            }
            catch (BaseException e) {
                response.setStatus(401);
                logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
            }
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/verify/password/key"}, method={RequestMethod.GET})
    public void verifyResetPasswordKey(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /verifyResetPasswordKey ...");
        try {
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader(RESET_PASSWORD_KEY);
            if (!org.springframework.util.StringUtils.hasText((String)username) || !org.springframework.util.StringUtils.hasText((String)key)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            CacheHelper cacheHelper = new CacheHelper(cl.getCloud().getCloudId(), this.registry);
            username = username.replaceAll(" ", "_");
            String key2 = cacheHelper.getValueFromCache(username + RESET_PASSWORD);
            UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
            if (key2 != null && key2.equalsIgnoreCase(key)) {
                logger.debug("send 200....");
                response.setStatus(200);
                if (element != null) {
                    logger.debug("googleSecretkey....." + element.getGoogleSecretKey());
                    response.setHeader("googleSecretkey", element.getGoogleSecretKey());
                }
                return;
            }
            logger.debug("send 403....");
            response.setStatus(403);
            return;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.trace(IO_EXCEPTION + String.valueOf(e));
            logger.error(IO_EXCEPTION + e.getMessage());
            return;
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/verifyRecoveryKey"}, method={RequestMethod.GET})
    public void verifyRecoveryKey(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        try {
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader("recoveryKey");
            if (!org.springframework.util.StringUtils.hasText((String)username) || !org.springframework.util.StringUtils.hasText((String)key)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return;
            }
            this.managementService.verifyRecoveryKey(cloudId, cloudName, username, key);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/update/password"}, method={RequestMethod.PUT})
    public ModelAndView updateUserPassword(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        boolean captchaValidation = true;
        try {
            OTPValidation otpValidation;
            int clientType;
            String username = request.getHeader(USER_NAME);
            String key = request.getHeader(RESET_PASSWORD_KEY);
            String password = request.getHeader(PASSWORD);
            String oldPassword = request.getHeader("oldPassword");
            String setPassword = request.getHeader("setpassword");
            String accesskey = request.getHeader("accessKey");
            String captcha = request.getHeader("captcha-value");
            String client = request.getHeader(CLIENT_TYPE);
            logger.debug("calling /updateUserPassword ..." + username);
            String googleSecretkey = request.getHeader("googleSecretkey");
            if (!(org.springframework.util.StringUtils.hasText((String)username) && org.springframework.util.StringUtils.hasText((String)key) && org.springframework.util.StringUtils.hasText((String)password))) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            this.setRateLimiter(cl.getCloud().getCloudId());
            rateLimiter.acquire();
            if (client != null) {
                logger.debug("@@@ Inside client selection ...." + client);
                clientType = PCClientTypes.getClientType((String)client);
            } else {
                client = PORTAL;
                clientType = PCClientTypes.getClientType((String)client);
            }
            String token = request.getHeader("token");
            String userName = username.replaceAll(" ", "_");
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response, userName)) {
                // empty if block
            }
            CacheHelper cacheHelper = new CacheHelper(cl.getCloud().getCloudId(), this.registry);
            UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
            boolean isValidationSuccess = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)accesskey)) {
                String uniqueId = userName;
                if (StringUtils.isNotEmpty((CharSequence)uniqueId)) {
                    if (element != null) {
                        uniqueId = element.getEmailId();
                    }
                    if ((otpValidation = this.authorizationService1.getOTPForUniqueId(1, uniqueId)) == null || !accesskey.equalsIgnoreCase(otpValidation.getToken())) {
                        logger.error("access key validation not successfull..");
                        response.setStatus(451);
                        return null;
                    }
                    if (accesskey.equalsIgnoreCase(otpValidation.getToken()) && otpValidation.getModifiedTime() + (long)(this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000) < System.currentTimeMillis()) {
                        logger.error("access key validation not successfull.." + this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000);
                        response.setStatus(451);
                        return null;
                    }
                    isValidationSuccess = true;
                } else {
                    logger.error("unique id not found....");
                    response.setStatus(451);
                    return null;
                }
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)element)) {
                response.setStatus(400);
                return null;
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)oldPassword)) {
                if (!isValidationSuccess) {
                    logger.debug("@@@ Calling isLoggedInUserAllowedToChangeUserPassword " + cloudId + "===" + cloudName + "===" + String.valueOf(element) + "===" + String.valueOf(user));
                    if (!this.managementService.isLoggedInUserAllowedToChangeUserPassword(cloudId, cloudName, element, user)) {
                        response.setStatus(403);
                        return null;
                    }
                }
            } else {
                if (org.springframework.util.StringUtils.isEmpty((Object)element.getPasswdHash())) {
                    response.setHeader("ldapuser", "true");
                    response.setStatus(400);
                    return null;
                }
                try {
                    otpValidation = this.managementService.authenticate(cloudId, cloudName, username, oldPassword);
                }
                catch (BaseException e) {
                    String ip = request.getHeader("ip");
                    String osType = request.getHeader(OS_TYPE);
                    String browser = request.getHeader(BROWSER);
                    Object hostIPDomain = "";
                    logger.debug(username + " .....  ..........ip ostype, browser .................. " + ip + ".. " + osType + "...." + browser);
                    if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                        hostIPDomain = " from the ip address " + ip + " using the domain Name " + browser + " and the OS Type was " + osType;
                    }
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "failed reset the password for  " + client + (String)hostIPDomain + "due to Invalid Credentials", username, "", "", System.currentTimeMillis(), PCActionTypes.RESET_PASSWORD.getActionTypeValue());
                    response.setStatus(403);
                    return null;
                }
            }
            AuthorizationTokens authorizationTokens = this.getAuthorizationTokens(cloudName, element.getUserName(), cloudId, clientType);
            captchaValidation = this.validateCaptcha(cloudName, element.getUserName(), cloudId, captcha, captchaValidation, clientType, authorizationTokens);
            if (!captchaValidation) {
                response.setStatus(400);
                return null;
            }
            String key2 = !org.springframework.util.StringUtils.isEmpty((Object)setPassword) && "true".equalsIgnoreCase(setPassword) ? element.getSecurityRecoveryKey() : cacheHelper.getValueFromCache(userName + RESET_PASSWORD);
            if (key2 != null && key2.equalsIgnoreCase(key)) {
                element.setPasswdHash(password);
                element.setGoogleSecretKey(googleSecretkey);
                this.managementService.updateUserInfo(cloudId, cloudName, element, userName);
                cacheHelper.removeKeyFromCache(userName + RESET_PASSWORD);
                if (key.equals(element.getSecurityRecoveryKey())) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " reset the password to the user Name:" + username, user.getUserName(), "", "Portal", System.currentTimeMillis(), PCActionTypes.SET_PASSWORD.getActionTypeValue());
                } else {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " reset the password ", username, "", "Portal", System.currentTimeMillis(), PCActionTypes.RESET_PASSWORD.getActionTypeValue());
                }
                this.updateToken(cloudName, cloudId, authorizationTokens);
                response.setStatus(200);
                return null;
            }
            response.setStatus(403);
            return null;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.trace(IO_EXCEPTION + String.valueOf(e));
            logger.error(IO_EXCEPTION + e.getMessage());
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private void updateToken(String cloudName, int cloudId, AuthorizationTokens authorizationTokens) {
        if (authorizationTokens != null) {
            authorizationTokens.setUniqueId(null);
            this.authorizationService1.addTokenOrUpdate(cloudId, cloudName, authorizationTokens);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/mail"}, method={RequestMethod.POST})
    public void sendMail(@PathVariable(value="cloudName") String cloudName1, @RequestBody EmailProps email, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        try {
            if (email == null || StringUtils.isBlank((CharSequence)email.getAction())) {
                throw new BaseException("Bad Email props");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            cloudName = cl.getCloud().getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!Boolean.parseBoolean(request.getHeader("isInternalCall")) && !this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return;
            }
            ArrayList<EmailRecipent> notifyRecipents = new ArrayList<EmailRecipent>();
            if (email.isToAllMinicloudUsers() && (email.getMiniCloudName() != null || !email.getMiniCloudName().isEmpty())) {
                List cloudList = email.getMiniCloudName();
                for (String miniCloudName : cloudList) {
                    List<com.parablu.pcbd.domain.User> users = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudName, miniCloudName);
                    if (users == null) continue;
                    for (com.parablu.pcbd.domain.User u : users) {
                        if (!u.isActive()) continue;
                        EmailRecipent emailRecipent = new EmailRecipent();
                        emailRecipent.setUserName(u.getUserName());
                        emailRecipent.setEmail(u.getEmailId());
                        notifyRecipents.add(emailRecipent);
                    }
                }
            }
            if (CollectionUtils.isEmpty((Collection)email.getRecipents())) {
                logger.debug(email.getUserName() + "..reciepients empty ....." + email.getActionBy());
                ArrayList<EmailRecipent> recipents = new ArrayList<EmailRecipent>();
                EmailRecipent emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(email.getActionBy());
                String emailId = this.managementService.getUserInfo(cl.getCloud().getCloudId(), cloudName, email.getActionBy()).getEmailId();
                if (email.getAction().equals("blobfuse-unmount")) {
                    emailRecipent.setEmail(this.decodeBase64UTFString(emailId));
                } else {
                    emailRecipent.setEmail(emailId);
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)email.getUserName()) && !org.springframework.util.StringUtils.isEmpty((Object)email.getActionBy())) {
                    emailRecipent.setUserName(email.getUserName());
                    emailRecipent.setEmail(this.managementService.getUserInfo(cl.getCloud().getCloudId(), cloudName, email.getUserName()).getEmailId());
                }
                recipents.add(emailRecipent);
                email.setRecipents(recipents);
            }
            if (email.getAction().equals("create-server")) {
                logger.debug("action=create-server action by user={} action on server user={}", (Object)email.getActionBy(), (Object)email.getActionOn());
                String pwd = this.generaterandompswd();
                String passwordHash = this.generatePassWordhash(pwd);
                com.parablu.pcbd.domain.User serverUser = this.managementService.getUserDetails(cloudId, cloudName, email.getActionOn());
                try {
                    logger.debug("action=create-server updating the server user={} password", (Object)serverUser.getUserName());
                    serverUser.setPasswdHash(passwordHash);
                    this.managementService.updateUserInfo(cloudId, cloudName, serverUser);
                    logger.debug("action=create-server sending mail");
                    this.managementService.sendCreateServerMail(cl.getCloud(), cloudName, email.getActionBy(), serverUser, pwd);
                    response.setStatus(200);
                    return;
                }
                catch (Exception e) {
                    logger.error("There is an exception while changing the server user password e=", (Throwable)e);
                }
            }
            email.setNotifyRecipents(notifyRecipents);
            logger.debug("calling email..");
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("bkupsDone"))) {
                logger.debug("..... bkupsdone not empty... " + request.getHeader("bkupsDone"));
            }
            logger.debug("calling email.." + email.getBackupsDone());
            email.setBackupsDone(request.getHeader("bkupsDone"));
            this.cloudMailService.sendMail(cl.getCloud(), email);
            response.setStatus(200);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/mail/reset/password"}, method={RequestMethod.POST})
    public void sendMailForPasswordReset(@PathVariable(value="cloudName") String cloudName1, @RequestBody EmailProps email, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(CALLING_VERIFY_RECOVERY_KEY);
        String cloudName = cloudName1;
        boolean captchaValidation = true;
        try {
            if (email == null || StringUtils.isBlank((CharSequence)email.getAction())) {
                throw new BaseException("Bad Email props");
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.setRateLimiter(cloudId);
            rateLimiter.acquire();
            cloudName = cl.getCloud().getCloudName();
            String captcha = email.getPassword();
            String client = email.getMcName();
            int clientType = 2;
            if (client != null) {
                clientType = PCClientTypes.getClientType((String)client);
            }
            AuthorizationTokens authorizationTokens = this.getAuthorizationTokens(cloudName, email.getActionBy(), cloudId, clientType);
            captchaValidation = this.validateCaptcha(cloudName1, email.getActionBy(), cloudId, captcha, captchaValidation, clientType, authorizationTokens);
            if (!captchaValidation) {
                response.setStatus(400);
                return;
            }
            ArrayList<EmailRecipent> notifyRecipents = new ArrayList<EmailRecipent>();
            String emailId = ((EmailRecipent)email.getRecipents().get(0)).getEmail();
            if (!org.springframework.util.StringUtils.isEmpty((Object)emailId)) {
                UserElement userElement = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), emailId);
                email.setActionOn(userElement.getUserName());
            }
            if (email.isToAllMinicloudUsers() && (email.getMiniCloudName() != null || !email.getMiniCloudName().isEmpty())) {
                List cloudList = email.getMiniCloudName();
                for (String miniCloudName : cloudList) {
                    List<com.parablu.pcbd.domain.User> users = this.miniCloudAccessControlService.getAllUserForMiniCloud(cloudId, cloudName, miniCloudName);
                    if (users == null) continue;
                    for (com.parablu.pcbd.domain.User u : users) {
                        if (!u.isActive()) continue;
                        EmailRecipent emailRecipent = new EmailRecipent();
                        emailRecipent.setUserName(u.getUserName());
                        emailRecipent.setEmail(u.getEmailId());
                        notifyRecipents.add(emailRecipent);
                    }
                }
            }
            email.setNotifyRecipents(notifyRecipents);
            logger.debug("calling email..");
            this.cloudMailService.sendMail(cl.getCloud(), email);
            this.updateToken(cloudName, cloudId, authorizationTokens);
            response.setStatus(200);
        }
        catch (DataIntegrityViolationException e) {
            response.setStatus(401);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            response.setStatus(401);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            response.setStatus(401);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION, (Throwable)e);
        }
    }

    @RequestMapping(value={"mail/reload"}, method={RequestMethod.GET})
    public void reloadEmailTemplates(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /reloadEmailTemplates ...");
        try {
            EmailCacher.reloadTemplates((String)EMAILS_XML_PATH);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/mobile/authenthicate"}, method={RequestMethod.GET})
    public ModelAndView authenticateMobile(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticateMobile ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        ResponseElement responseElement = new ResponseElement();
        try {
            String username = request.getHeader(USER_NAME);
            String password = request.getHeader(PASSWORD);
            String deviceName = request.getHeader(DEVICE_NAME);
            String client = request.getHeader(CLIENT_TYPE);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            com.parablu.pcbd.domain.User u = this.managementService.authenticate(cloudId, cloudName, username, password);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged in using Mobile", username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                if (devices != null && !devices.isEmpty()) {
                    response.setHeader("has-connected-clients", "true");
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", "true");
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            responseElement.setStatus(String.valueOf(202));
            responseElement.setToken(token);
        }
        catch (DataIntegrityViolationException e) {
            responseElement.setStatus(String.valueOf(401));
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            responseElement.setStatus(String.valueOf(401));
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            responseElement.setStatus(String.valueOf(e.getErrorStatus()));
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        response.setHeader(CLOUD_NAME, cloudName);
        responseElement.setCloudName(cloudName);
        modelAndView.addObject((Object)responseElement);
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/create/amazonuser/{userName}/"}, method={RequestMethod.POST})
    public ModelAndView createFirstTimeAmazonUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserElement userElement, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /createFirstTimeAdminUser for AMAZON AMI ...");
        UserElement ue = null;
        try {
            List<UserElement> userList;
            if (!org.springframework.util.StringUtils.hasText((String)userElement.getUserName()) || !org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(USER_NAME_NOT_FOUND);
            }
            CloudLicenseTo cl = this.licenseService.validateAmazonLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            userElement.setAdmin(true);
            userElement.setBackupEnabled(true);
            userElement.setSyncEnabled(false);
            userElement.setShareEnabled(false);
            userElement.setActive(true);
            userElement.setFirstLogin(true);
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            if ((userList = this.managementService.getAllUsers(cloudId, cloudName, false, site)) != null && !userList.isEmpty()) {
                modelAndView.addObject(null);
                response.setStatus(401);
                return null;
            }
            logger.debug(" CREATE USER IS BACKUP ENABLED .. " + userElement.isBackupEnabled());
            ue = this.managementService.createUser(cloudId, cloudName, userElement, "", "", false, true);
            modelAndView.addObject((Object)ue);
            response.setStatus(201);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "created  a new user", userName, userElement.getUserName(), "ParaBlu", System.currentTimeMillis(), PCActionTypes.USER_CREATE.getActionTypeValue());
        }
        catch (DataIntegrityViolationException e) {
            ErrorElement err = this.createErrorElement(null, USER_ALREADY_EXISTS);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(DATA_INSTEGRITY_VIOLATION_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_INSTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private boolean isLdapEnabledForCloud(CloudLicenseTo cl) {
        boolean isLdapEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"LDAP Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLdapEnabled = true;
                break;
            }
        }
        return isLdapEnabled;
    }

    private static String getStatus(boolean val) {
        if (val) {
            return "Active";
        }
        return "Blocked";
    }

    public static String md5(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(input.getBytes());
        BigInteger number = new BigInteger(1, messageDigest);
        return number.toString(16);
    }

    public String decrypt(String encryptedPassword, String key) throws Exception {
        int ivSize = 16;
        int keySize = 16;
        logger.info(" encrypted password is " + encryptedPassword);
        byte[] payload = java.util.Base64.getDecoder().decode(encryptedPassword);
        byte[] iv = new byte[ivSize];
        System.arraycopy(payload, 0, iv, 0, iv.length);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = payload.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(payload, ivSize, encryptedBytes, 0, encryptedSize);
        byte[] keyBytes = new byte[keySize];
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(key.getBytes());
        System.arraycopy(md.digest(), 0, keyBytes, 0, keyBytes.length);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipherDecrypt.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] decrypted = cipherDecrypt.doFinal(encryptedBytes);
        return new String(decrypted);
    }

    @RequestMapping(value={"cloud/{cloudName}/ldap/users/migrate"}, method={RequestMethod.POST})
    public ModelAndView ldapconnectivityUser(@PathVariable(value="cloudName") String cloudName1, @RequestBody LdapUserListElement ldapUserListElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug(" Inside migrate users ........ sync enabled>>" + request.getHeader("syncEnabled"));
        int totalUsersCount = ldapUserListElement.getLdapUserElements().size();
        int totalUsersMigrated = 0;
        logger.debug(" Inside migrate users ........ backup enabled>>" + request.getHeader("backupEnabled"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            Cloud cloud = cl.getCloud();
            cloudName = cloud.getCloudName();
            int cloudId = cloud.getCloudId();
            String adminName = request.getHeader("adminName");
            boolean isSyncEnabled = Boolean.parseBoolean(request.getHeader("syncEnabled"));
            boolean isBackupEnabled = Boolean.parseBoolean(request.getHeader("backupEnabled"));
            boolean isO365BackupEnabled = Boolean.parseBoolean(request.getHeader("o365BkpEnabled"));
            ArrayList<String> users = new ArrayList<String>();
            String groupName = request.getHeader("groupName");
            logger.debug(" group added .................. " + groupName);
            long noOfUsersAllowed = (long)cloud.getNoOfUsersAllowed() - this.managementService.countOfPresentUsers(cloudId);
            if (noOfUsersAllowed < (long)totalUsersCount) {
                response.setHeader("userLimit", Long.toString(noOfUsersAllowed));
                response.setStatus(417);
                return null;
            }
            for (LdapUserElement ldapUserElement : ldapUserListElement.getLdapUserElements()) {
                String userName = ldapUserElement.getUserName();
                try {
                    int code = this.deviceAndUserSecurityService.validateUserRestrictions(cloudId, cloudName, cloud);
                    if (!this.checkLicense(code, response)) {
                        return null;
                    }
                    boolean odbBkpEnabled = false;
                    boolean exchangeBkpEnabled = false;
                    boolean site = false;
                    boolean gmailBkpEnabled = false;
                    boolean gdriveBkpEnabled = false;
                    for (CloudCustomisableDetails customisableDetails : cloud.getCloudCustomisableDetails()) {
                        if (customisableDetails == null || !isO365BackupEnabled) continue;
                        if ("OneDrive Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            odbBkpEnabled = true;
                        }
                        if ("Exchange Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            exchangeBkpEnabled = true;
                        }
                        if ("GMAIL Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) {
                            gmailBkpEnabled = true;
                        }
                        if (!"GDRIVE Backup Enabled".equalsIgnoreCase(customisableDetails.getName())) continue;
                        gdriveBkpEnabled = true;
                    }
                    long countOfPresentBackupUsers = this.managementService.countOfPresentBackupUsers(cloudId, cloudName, true);
                    if ((long)cloud.getNoOfBackupUsersAllowed() <= countOfPresentBackupUsers) {
                        isBackupEnabled = false;
                    }
                    long countOfPresentSyncUsers = this.managementService.countOfPresentSyncUsers(cloudId, cloudName, true);
                    if (isO365BackupEnabled) {
                        odbBkpEnabled = true;
                        exchangeBkpEnabled = true;
                        site = true;
                    }
                    long countOfPresentODBBackupUsers = this.managementService.countOfPresentOnedriveUsers(cloudId, true);
                    if ((long)cloud.getNoOfOneDriveUsersAllowed() <= countOfPresentODBBackupUsers) {
                        odbBkpEnabled = false;
                    }
                    long countOfPresentExchangeUsers = this.managementService.countOfPresentExchangeUsers(cloudId, true);
                    if ((long)cloud.getNoOfExchangeUsersAllowed() <= countOfPresentExchangeUsers) {
                        exchangeBkpEnabled = false;
                    }
                    long countOfPresentGmailUsers = this.managementService.countOfPresentGmailBackupUsers(cloudId, cloudName, true);
                    if ((long)cloud.getNoOfExchangeUsersAllowed() <= countOfPresentGmailUsers) {
                        gmailBkpEnabled = false;
                    }
                    long countOfPresentSPSites = this.managementService.countOfPresentSite(cloudId, true);
                    if ((long)cloud.getNoOfSPSitesAllowed() <= countOfPresentSPSites) {
                        site = false;
                    }
                    if (!(isBackupEnabled || isSyncEnabled || odbBkpEnabled || exchangeBkpEnabled || site)) {
                        throw new UserLimitReachedException("user limit reached");
                    }
                    logger.debug(".....license numbers....." + countOfPresentBackupUsers + "...." + countOfPresentSyncUsers + "...." + countOfPresentODBBackupUsers);
                    logger.debug("....license check ..... " + isBackupEnabled + "..." + isSyncEnabled + "...." + odbBkpEnabled + "..." + exchangeBkpEnabled);
                    boolean userMigrated = this.migrateUserBasedOnProductType(cl, cloudId, cloudName, ldapUserElement, response, isSyncEnabled, isBackupEnabled, odbBkpEnabled, exchangeBkpEnabled, adminName, gmailBkpEnabled, gdriveBkpEnabled);
                    if (userMigrated) {
                        ++totalUsersMigrated;
                    }
                }
                catch (UserLimitReachedException e) {
                    logger.debug("...user limit reached.....");
                    this.sendEmailForUserLimitExceded(cloud, cloudName, userName, "User");
                }
                catch (Exception e) {
                    logger.error(" USERS CANNOT BE MIGRATED ................." + String.valueOf(e));
                    logger.debug("USERS CANNOT BE MIGRATED ................." + e.getMessage());
                }
                logger.debug("##### test  " + ldapUserElement.getEmailId());
                users.add(ldapUserElement.getUserName());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)groupName)) {
                this.managementService.saveGroup(cloudId, users, groupName);
            }
            if (totalUsersMigrated != totalUsersCount) {
                modelAndView.addObject("totalUsersMigrated", (Object)totalUsersMigrated);
                modelAndView.addObject("totalUsersCount", (Object)totalUsersCount);
                response.setStatus(206);
            } else {
                response.setStatus(200);
            }
        }
        catch (Exception e) {
            logger.trace("error trying to load elements  ..........." + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("End of Inside migrate users ........ ");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/azure/authenticate"}, method={RequestMethod.POST})
    public void azureAuthentication(HttpServletRequest request, HttpServletResponse response) {
        logger.debug(INSIDE_AZURE_AUTHENTICATION);
        String userName = request.getParameter(USER_NAME);
        String password = request.getParameter(PASSWORD);
        if (org.springframework.util.StringUtils.isEmpty((Object)userName) && org.springframework.util.StringUtils.isEmpty((Object)password)) {
            userName = request.getHeader(USER_NAME);
            password = request.getHeader(PASSWORD);
        }
        try {
            logger.debug(userName + INSIDE_AZURE_AUTHENTICATION);
            Object[] objArr = this.ldapService.authenticate(1, userName, password);
            response.setStatus(200);
            boolean isUserAuthenticated = (Boolean)objArr[0];
            String licenseEnabled = (String)objArr[1];
            response.setHeader("userAuthenticated", Boolean.toString(isUserAuthenticated));
            response.setHeader("licenseEnabled", licenseEnabled);
            logger.debug(INSIDE_AZURE_AUTHENTICATION + isUserAuthenticated);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
            response.setHeader("userAuthenticated", Boolean.FALSE.toString());
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/createMultiUsers/"}, method={RequestMethod.POST})
    public void azureAuthentication(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug(INSIDE_AZURE_AUTHENTICATION);
        String userName = request.getHeader(USER_NAME);
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            for (int i = 0; i <= 100; ++i) {
                com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
                String userNameObj = userName + i;
                user.setUserName(userNameObj);
                user.setPasswdHash("4c09d7197a7ae0d55ebc4b91113014c3");
                user.setEmailId(userNameObj + "@dummy.com");
                user.setBackupEnabled(true);
                user.setSyncEnabled(true);
                this.managementService.createUser(cloudId, cloudName, user);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/delete/{userName}/"}, method={RequestMethod.POST})
    public void markUserAsDelete(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /user/delete/ ..." + userName);
        String blockedBy = request.getHeader(USER_NAME);
        String host = request.getHeader("hostname");
        String cloudName = cloudName1;
        try {
            com.parablu.pcbd.domain.User currentUser;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser = new com.parablu.pcbd.domain.User(), response, userName)) {
                response.setStatus(400);
                return;
            }
            boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
            if (userUnderLegalHold) {
                response.setStatus(447);
                return;
            }
            boolean isUserOwnerOfAnyMiniCloud = this.managementService.isUserOwnerOfAnyMiniCloud(cloudId, userName);
            if (isUserOwnerOfAnyMiniCloud) {
                response.setStatus(448);
                return;
            }
            this.managementService.markUserAsDelete(cloudId, cloudName, userName, currentUser.getUserName(), cl.getCloud(), host);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", blockedBy, userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("EmptyResultDataAccessException " + String.valueOf((Object)e));
            logger.error(" EmptyResultDataAccessException " + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("DataAccessException " + String.valueOf((Object)e));
            logger.error(" DataAccessException " + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/delete/"}, method={RequestMethod.POST})
    public void markMultipleUserAsDelete(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        String deletedBy = request.getHeader("deletedBy");
        String userNames = request.getHeader("userNames");
        logger.debug(CALLING_UPDATE_USER_INFO + userNames);
        try {
            if (!org.springframework.util.StringUtils.hasText((String)userNames)) {
                throw new BaseException(INVALID_REQUEST);
            }
            ArrayList<String> userNameList = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            String failedUsersList = "";
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName1)) {
                response.setStatus(400);
                return;
            }
            for (String userName : userNameList) {
                this.markUserAsDelete(cloudName, response, userName, deletedBy, cloudId, failedUsersList, cl.getCloud());
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace("EmptyResultDataAccessException " + String.valueOf((Object)e));
            logger.error(" EmptyResultDataAccessException " + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace("DataAccessException " + String.valueOf((Object)e));
            logger.error(" DataAccessException " + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    private UserElement markUserAsDelete(String cloudName, HttpServletResponse response, String userName, String deletedBy, int cloudId, String failedUsersList1, Cloud cloud) {
        Object failedUsersList = failedUsersList1;
        boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
        UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, userName);
        if (userElement != null) {
            if (userUnderLegalHold) {
                response.setStatus(447);
                failedUsersList = org.springframework.util.StringUtils.isEmpty((Object)failedUsersList) ? (String)failedUsersList + userName : (String)failedUsersList + "," + userName;
                response.setHeader("failed-users", (String)failedUsersList);
            }
            try {
                this.managementService.markUserAsDelete(cloudId, cloudName, userName, deletedBy, cloud, null);
            }
            catch (BaseException e) {
                failedUsersList = org.springframework.util.StringUtils.isEmpty((Object)failedUsersList) ? (String)failedUsersList + userName : (String)failedUsersList + "," + userName;
                response.setHeader("failed-users", (String)failedUsersList);
                logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
                logger.error(BASE_EXCEPTION + e.getMessage());
            }
            response.setStatus(200);
            if (deletedBy.equals("AUTO_Pack_Manager")) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", deletedBy, userName, "Order Center", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
            } else {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "deleted user", deletedBy, userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_DELETE.getActionTypeValue());
            }
        }
        return userElement;
    }

    @RequestMapping(value={"cloud/{cloudName}/userNames/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUserNames(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            List<com.parablu.pcbd.domain.User> userList = this.managementService.getAllActiveUsers(cloudId);
            Collections.sort(userList, new Comparator<com.parablu.pcbd.domain.User>(this){

                @Override
                public int compare(com.parablu.pcbd.domain.User u1, com.parablu.pcbd.domain.User u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userNameElements = new ArrayList<StringElement>();
            for (com.parablu.pcbd.domain.User user : userList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userNameElements.add(stringElement);
            }
            modelAndView.addObject(userNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/save/group/"}, method={RequestMethod.POST})
    public void saveGroup(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserGroupElement userGroupElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling  /save/group/...:");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user, response, userName1)) {
                return;
            }
            String userNames = userGroupElement.getAssignedUsers();
            String groupName = userGroupElement.getGroupName();
            Group group = this.managementService.getGroupByName(cloudId, groupName);
            logger.debug(user.getUserName() + " user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            logger.debug(" total size .... " + list.size());
            ArrayList<String> list1 = new ArrayList<String>();
            list1.addAll(list);
            if (group != null) {
                List<UserGroup> existingGroups = this.managementService.getAllUsersForGroup(cloudId, null, group.getId().toString());
                for (UserGroup userGroup : existingGroups) {
                    if (userGroup == null) continue;
                    list1.remove(userGroup.getUser().getUserName());
                }
                logger.debug(" removed user size .... " + list1.size());
            }
            this.managementService.saveGroup(cloudId, list, groupName);
            for (String userName : list1) {
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "saved group", user.getUserName(), groupName + " to " + userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_GROUP_SAVE.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        logger.debug(" end of calling /save/group/.. ");
    }

    @RequestMapping(value={"cloud/{cloudName}/groups/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUserGroups(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            List<Group> groupList = this.managementService.getAllGroups(cloudId);
            Collections.sort(groupList, new Comparator<Group>(this){

                @Override
                public int compare(Group u1, Group u2) {
                    return new CompareToBuilder().append((Object)u1.getGroupName().toLowerCase(), (Object)u2.getGroupName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> groupElements = new ArrayList<StringElement>();
            for (Group group : groupList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(group.getGroupName());
                groupElements.add(stringElement);
            }
            modelAndView.addObject(groupElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement();
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/group/{groupName}/"}, method={RequestMethod.GET})
    public ModelAndView getGroupInformation(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="groupName") String groupName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling ./group/{groupName}/..:" + groupName);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            if (!org.springframework.util.StringUtils.hasText((String)groupName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            UserGroupElement groupElement = this.managementService.getGroupElement(cloudId, groupName);
            modelAndView.addObject((Object)groupElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, "Group not found.");
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/group/delete/{groupName}/"}, method={RequestMethod.POST})
    public void deleteGroup(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="groupName") String groupName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug("calling /group/delete/{groupName}/ ..." + groupName);
        String blockedBy = request.getHeader(USER_NAME);
        try {
            com.parablu.pcbd.domain.User user;
            if (!org.springframework.util.StringUtils.hasText((String)groupName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new com.parablu.pcbd.domain.User(), response, userName)) {
                return;
            }
            Group group = this.managementService.getGroupByName(cloudId, groupName);
            this.managementService.deleteGroup(cloudId, group);
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "delete group", blockedBy, user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.USER_GROUP_DELETE.getActionTypeValue());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/group/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUsersAndGroup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling cloud/{cloudName}/user/group/all ...");
        String cloudName = cloudName1;
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        List<UserElement> userList = null;
        ArrayList<String> policyNames = new ArrayList<String>();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            StringElement stringElement;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            if (currentUser.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getSyncPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getOdbPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getOdbPoliciesAdmin());
                }
                logger.debug("the policy names size={}, present for delegated admin={}", (Object)policyNames.size(), (Object)currentUser.getUserName());
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            boolean searchSite = false;
            if (request.getHeader("searchSite") != null) {
                searchSite = Boolean.parseBoolean(request.getHeader("searchSite"));
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(site + " Skip values .... " + skipValue + "...." + searchSite);
            if (currentUser.isAdmin()) {
                userList = this.managementService.getAllUsers(cloudId, skipValue, site, null, searchSite);
            } else if (currentUser.isReadOnlyAdmin()) {
                userList = this.managementService.getAllUsers(cloudId, skipValue, site, policyNames, searchSite);
            }
            List<Group> groups = this.managementService.getAllGroups(cloudId, skipValue);
            userList.removeAll(Collections.singleton(null));
            groups.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userGroupNameElements = new ArrayList<StringElement>();
            for (UserElement user : userList) {
                stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userGroupNameElements.add(stringElement);
            }
            for (Group group : groups) {
                stringElement = new StringElement();
                stringElement.setName(group.getGroupName());
                userGroupNameElements.add(stringElement);
            }
            modelAndView.addObject(userGroupNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION, (Throwable)e);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/users/group/"}, method={RequestMethod.GET})
    public ModelAndView searchUsersAndGroup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling search/user/group.....");
        ModelAndView modelAndView = new ModelAndView();
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        ArrayList<String> policyNames = new ArrayList<String>();
        List<UserElement> userList = null;
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            String userName;
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), currentUser, response, userName = request.getHeader(USER_NAME))) {
                return null;
            }
            if (currentUser.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)currentUser.getBackupPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getSyncPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)currentUser.getOdbPoliciesAdmin())) {
                    policyNames.addAll(currentUser.getOdbPoliciesAdmin());
                }
                logger.debug("the policy names size={}, present for for user={}", (Object)policyNames.size(), (Object)currentUser.getUserName());
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            String mcAssignOwner = request.getHeader("mc-assign-owner");
            logger.debug("mcassign owner:" + mcAssignOwner);
            boolean isMcAssignOwner = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)mcAssignOwner)) {
                isMcAssignOwner = Boolean.valueOf(mcAssignOwner);
            }
            logger.debug(isMcAssignOwner + ":header username:" + userName);
            if (currentUser.isAdmin() || isMcAssignOwner) {
                userList = this.managementService.searchUsers(cloudId, userName, site);
            } else if (currentUser.isReadOnlyAdmin()) {
                userList = this.managementService.delegatedAdminSearchUsers(cloudId, userName, site, policyNames);
                logger.debug("userList size={}", (Object)userList.size());
            }
            if (userList != null) {
                Collections.sort(userList, new Comparator<UserElement>(this){

                    @Override
                    public int compare(UserElement u1, UserElement u2) {
                        return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                    }
                });
            }
            ArrayList<StringElement> userGroupNameElements = new ArrayList<StringElement>();
            for (UserElement user : userList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userGroupNameElements.add(stringElement);
            }
            List<Group> groups = this.managementService.searchGroups(cloudId, userName);
            if (!CollectionUtils.isEmpty(groups)) {
                for (Group group : groups) {
                    StringElement stringElement = new StringElement();
                    stringElement.setName(group.getGroupName());
                    userGroupNameElements.add(stringElement);
                }
            }
            modelAndView.addObject(userGroupNameElements);
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION, (Throwable)e);
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/search/sites/group/"}, method={RequestMethod.GET})
    public ModelAndView searchSitesAndGroup(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling search/sites/group.....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName1)) {
                return null;
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            String userName = request.getHeader(USER_NAME);
            logger.debug("header username:" + userName);
            List<UserElement> userList = this.managementService.searchUsers(cloudId, userName, site);
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ArrayList<StringElement> userGroupNameElements = new ArrayList<StringElement>();
            for (UserElement user : userList) {
                StringElement stringElement = new StringElement();
                stringElement.setName(user.getUserName());
                userGroupNameElements.add(stringElement);
            }
            List<Group> groups = this.managementService.searchGroups(cloudId, userName);
            if (!CollectionUtils.isEmpty(groups)) {
                for (Group group : groups) {
                    StringElement stringElement = new StringElement();
                    stringElement.setName(group.getGroupName());
                    userGroupNameElements.add(stringElement);
                }
            }
            modelAndView.addObject(userGroupNameElements);
            response.setStatus(200);
            logger.debug("end of search/sites/group.....");
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/azure/searchEmail"}, method={RequestMethod.GET})
    public ResponseEntity<List<Person>> searchEmail(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("@@@@@@@@@@@@@@ Inside Azure cloud/azure/searchEmail  ...............");
        String searchBy = request.getParameter("searchBy");
        List persons = new ArrayList();
        if (org.springframework.util.StringUtils.isEmpty((Object)searchBy)) {
            searchBy = request.getHeader("searchBy");
        }
        try {
            logger.debug(searchBy + "@@@@@@@@@@@@@@ Inside Azure searchEmail  ...............");
            persons = this.ldapService.searchUsersByEmail(1, searchBy);
            response.setStatus(200);
            logger.debug(persons.size() + "@@@@@@@@@@@@@@ Inside Azure searchEmail  ..............." + searchBy);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return new ResponseEntity(persons, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"cloud/azure/getPerson/ad/"}, method={RequestMethod.GET})
    public ResponseEntity<Person> searchUserFromAD(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("@@@@@@@@@@@@@@ Inside Azure cloud/azure/getPerson/ad/  ...............");
        String userName = request.getParameter(USER_NAME);
        Person person = null;
        if (org.springframework.util.StringUtils.isEmpty((Object)userName)) {
            userName = request.getHeader(USER_NAME);
        }
        try {
            logger.debug(userName + "@@@@@@@@@@@@@@ Inside Azure cloud/azure/getPerson/ad/  ...............");
            person = this.ldapService.getPerson(1, userName);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        return new ResponseEntity((Object)person, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/ldap/"}, method={RequestMethod.GET})
    public void uploadFileLatest1(HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.debug("Inside file ldap ....  ");
        String userName = request.getHeader(USER_NAME);
        String decryptedPwd = request.getHeader("pwd");
        Object[] objArr = this.ldapService.authenticate(1, userName, decryptedPwd);
        boolean isAuthenticated = (Boolean)objArr[0];
        logger.debug(userName + " isAD authenticated ... " + isAuthenticated);
    }

    @RequestMapping(value={"cloud/{cloudName}/search/user/device"}, method={RequestMethod.GET})
    public ModelAndView searchUsersWithDevices(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            String userName;
            String token;
            CloudLicenseTo cl;
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            if (!this.checkLicense(cl = this.licenseService.validateLicense(cloudName), response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response, userName = request.getHeader(USER_NAME))) {
                return null;
            }
            if (userName.isEmpty()) {
                response.setStatus(400);
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            com.parablu.pcbd.domain.User currentUser = authorizationTokens.getUser();
            List<SearchUserElement> userList = this.managementService.searchUsersWithDevices(cloudId, userName, currentUser, site);
            Collections.sort(userList, new Comparator<SearchUserElement>(this){

                @Override
                public int compare(SearchUserElement u1, SearchUserElement u2) {
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            modelAndView.addObject(userList);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, e.getMessage());
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/"}, method={RequestMethod.POST})
    public ModelAndView getUsersBasedOnNames(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, @PathVariable(value="versionNumber") String versionNumber, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling /users/ ....");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            List<String> userNames1 = userNames;
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String oppType = request.getHeader("oppType");
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return null;
            }
            List<UserElement> userList = this.managementService.getUserListByNames(cl.getCloud(), userNames1, currentUser, response, cl, oppType);
            modelAndView.addObject(userList);
            response.setStatus(200);
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/block/"}, method={RequestMethod.POST})
    public void blockMultipleUsers(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        List<String> userNames1 = userNames;
        UserElement emailUser = null;
        logger.debug("calling /users/block/ .........");
        String blockedBy = request.getHeader("blockedBy");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)blockedBy)) {
                blockedBy = this.decodeBase64UTFString(blockedBy);
            }
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            boolean active = Boolean.parseBoolean(request.getHeader("active"));
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName1)) {
                return;
            }
            if (active) {
                long totalUsersCount;
                long noOfUsersAllowed = (long)cl.getCloud().getNoOfUsersAllowed() - this.managementService.countOfPresentUsers(cloudId);
                if (noOfUsersAllowed < (totalUsersCount = (long)userNames1.size())) {
                    response.setHeader("no-of-possible-users", Long.toString(noOfUsersAllowed));
                    response.setStatus(417);
                    return;
                }
                int code = this.deviceAndUserSecurityService.validateUserRestrictions(cl.getCloud().getCloudId(), cloudName, cl.getCloud());
                if (!this.checkLicense(code, response)) {
                    return;
                }
            }
            if (userNames1.contains(blockedBy)) {
                userNames1.remove(blockedBy);
            }
            for (String userName : userNames1) {
                boolean userUnderLegalHold = this.managementService.isUserUnderLegalHoldForUserName(cloudId, userName);
                if (userUnderLegalHold) {
                    logger.error("....user is under leagal policy so block not allowed....");
                    continue;
                }
                emailUser = this.blockOrUnblockUser(cloudName, userName, response, modelAndView, blockedBy, cloudId, active);
                if (emailUser == null) continue;
                this.managementService.multipleUserBlockOrDeleteMail(cl.getCloud(), cloudName, cloudId, blockedBy, emailUser.getUserName(), emailUser.getEmailId(), USER_BLOCKED);
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/delete/"}, method={RequestMethod.POST})
    public void markMultipleUsersAsDelete(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<String> userNames, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        UserElement emailUser = null;
        String cloudName = cloudName1;
        String deletedBy = request.getHeader("deletedBy");
        logger.debug("calling /users/delete/ ........" + String.valueOf(userNames));
        try {
            String clientName;
            String failedUsersList = "";
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if ("pack-management-client".equals(clientName = request.getHeader("client-name"))) {
                logger.debug("request received from {}", (Object)clientName);
            } else if (!this.performAuthorization(cloudId, cloudName, token, response, userName1)) {
                response.setStatus(400);
                return;
            }
            for (String userName : userNames) {
                emailUser = this.markUserAsDelete(cloudName, response, userName, deletedBy, cloudId, failedUsersList, cl.getCloud());
            }
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/authenticate"}, method={RequestMethod.POST})
    public ModelAndView authenticateNew(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /authenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRST_LOGIN_TOKEN);
        String username = "";
        String client = "";
        String password = "";
        String deviceName = "";
        int cloudId = 0;
        try {
            String token;
            Cloud cloud;
            block23: {
                int clientType;
                block22: {
                    password = request.getHeader(PASSWORD);
                    deviceName = request.getHeader(DEVICE_NAME);
                    client = request.getHeader(CLIENT_TYPE);
                    username = request.getHeader(USER_NAME);
                    CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
                    if (!this.checkLicense(cl, response)) {
                        logger.debug("@@@ Inside authenticate invalid license ...");
                        return null;
                    }
                    cloud = cl.getCloud();
                    cloudName = cloud.getCloudName();
                    clientType = 1;
                    if (client != null) {
                        logger.debug("@@@ Inside client selection ..." + client);
                        clientType = PCClientTypes.getClientType((String)client);
                    }
                    cloudId = cloud.getCloudId();
                    boolean isLdapEnabledForCloud = this.isLdapEnabledForCloud(cl);
                    logger.debug(" LDAPENABLED ............  " + isLdapEnabledForCloud);
                    String parabluSuperUserName = "NEED TO CLEAN API";
                    if (!isLdapEnabledForCloud || username.equalsIgnoreCase(parabluSuperUserName)) break block22;
                    String ldapPwdEnc = request.getHeader("ldapPwdEnc");
                    String decryptedPwd = this.getDecryptePassword(ldapPwdEnc);
                    Object[] objArr = this.ldapService.authenticate(cloudId, username, decryptedPwd);
                    boolean isAuthenticated = (Boolean)objArr[0];
                    String licenseEnabled = (String)objArr[1];
                    this.managementService.autoDeviceBlockBasedOnPolicy(cloud);
                    if (isAuthenticated) {
                        block21: {
                            try {
                                logger.debug("checking for user info>>>>>>>>>>if not migrate from AD..........");
                                UserElement userElement = this.managementService.getUserInfo(cloudId, cloudName, username);
                                if (userElement != null) {
                                    logger.debug("user exists ........ " + userElement.getUserName());
                                }
                            }
                            catch (EmptyResultDataAccessException accessException) {
                                logger.debug("user is null so migrate from AD..........");
                                boolean success = this.checkWithADandMigrateUser(cl, cloudId, cloudName, username, response);
                                if (success) break block21;
                                logger.error(" Authentication failed  for user " + username + "............");
                                logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)accessException));
                                logger.debug(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + accessException.getMessage());
                                return null;
                            }
                        }
                        UserElement ue = this.getUserElement(username, cloud);
                        logger.debug(" USer authenticated .... " + username + ".... is active ...." + ue.isActive());
                        if (!ue.isActive()) {
                            throw new BaseException("User is not active", 403);
                        }
                        client = StringUtils.isEmpty((CharSequence)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                        UUID uuid = UUID.randomUUID();
                        token = String.valueOf(uuid);
                        logger.debug(token + " addTokenByUser  .... " + client);
                        this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                        logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                        modelAndView.addObject((Object)ue);
                        this.managementService.updateUserLoggedInTime(cloudId, username);
                        break block23;
                    } else {
                        response.setStatus(400);
                        String ip = request.getHeader("ip");
                        String osType = request.getHeader(OS_TYPE);
                        String browser = request.getHeader(BROWSER);
                        Object hostIPDomain = "";
                        logger.debug(" ip ostype,  browser .................. " + ip + ".. " + osType + "...." + browser);
                        if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                            hostIPDomain = " from the ip address " + ip + " using  the domain Name " + browser + " and the OS Type was " + osType;
                        }
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login  failed from " + client + (String)hostIPDomain, username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                        return null;
                    }
                }
                com.parablu.pcbd.domain.User u = this.managementService.authenticate(cloudId, cloudName, username, password);
                client = StringUtils.isEmpty((CharSequence)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, LOGGED_INTO + client, username, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
                UUID uuid = UUID.randomUUID();
                token = String.valueOf(uuid);
                this.authorizationService1.addTokenByUser(cloudId, cloudName, token, username, clientType);
                if (u.isSyncEnabled() || u.isBackupEnabled() || u.isServerBackupEnabled()) {
                    List<DeviceElement> devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, u.getUserName());
                    if (devices != null && !devices.isEmpty()) {
                        response.setHeader("has-connected-clients", "true");
                    } else {
                        response.setHeader("has-connected-clients", FALSE);
                    }
                }
                if (u.isFirstLogin()) {
                    response.setHeader("firstLogin", "true");
                    u.setFirstLogin(false);
                    this.managementService.updateUserInfo(cloudId, cloudName, u);
                } else {
                    response.setHeader("firstLogin", FALSE);
                }
                UserElement ue = this.getUserElement(username, cloud);
                logger.debug(GET_USER_INFO_BACKUP_ENABLED + ue.isBackupEnabled());
                this.managementService.updateUserLoggedInTime(cloudId, username);
            }
            response.setHeader("token", token);
            response.setHeader(CLOUD_NAME, cloud.getCloudName());
            response.setStatus(202);
            response.setHeader("Access-Control-Expose-Headers", "token, firstLogin, cloudName, connectedClients");
            return modelAndView;
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + String.valueOf((Object)e));
            response.setStatus(401);
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATON_EXCEPTION + e.getMessage());
            return modelAndView;
        }
        catch (DataAccessException e) {
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error("@@@ Inside authenticate DataAccessException..." + e.getMessage());
            response.setStatus(401);
            return modelAndView;
        }
        catch (BaseException e) {
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error("@@@ Inside authenticate BaseException..." + e.getMessage());
            if ("Bad Credentials.".equalsIgnoreCase(e.getMessage())) {
                String ip = request.getHeader("ip");
                String osType = request.getHeader(OS_TYPE);
                String browser = request.getHeader(BROWSER);
                Object hostIPDomain = "";
                logger.debug(username + " ..... " + password + " ..........ip ostype, browser .................. " + ip + ".. " + osType + "...." + browser);
                if (!(org.springframework.util.StringUtils.isEmpty((Object)ip) && org.springframework.util.StringUtils.isEmpty((Object)osType) && org.springframework.util.StringUtils.isEmpty((Object)browser))) {
                    hostIPDomain = " from the ip address " + ip + " using the domain Name " + browser + " and the OS Type was " + osType;
                }
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " login  failed from " + client + (String)hostIPDomain, username, "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            }
            response.setStatus(e.getErrorStatus());
            return modelAndView;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error("@@@ Exception..." + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/liteVersion"}, method={RequestMethod.GET})
    public ModelAndView getLiteVersioProperties(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling /liteVersion ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            LiteVersion liteVersion = this.liteVersionManagementService.getLiteVersionProperties(cloudId);
            if (liteVersion == null) {
                logger.debug("lite version properties are empty");
                response.setStatus(204);
                return null;
            }
            modelAndView.addObject((Object)liteVersion);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/checkAdConnection"}, method={RequestMethod.GET})
    public void checkADConnection(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling check Ad connection ");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.ldapService.checkAdConnection(cloudId, response);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(EXCEPTION + String.valueOf((Object)e));
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/createExcel/"}, method={RequestMethod.POST})
    public void createExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, @RequestBody ReportQueryElement userQueryElement, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid Cloud Name.....");
            return;
        }
        try {
            boolean isExcelCreated;
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return;
            }
            boolean site = false;
            if (request.getHeader("site") != null) {
                site = Boolean.parseBoolean(request.getHeader("site"));
            }
            logger.debug("...check..." + site);
            String userName = userQueryElement.getUserName();
            String onlyActiveUsers = request.getHeader("onlyActiveUsers");
            logger.debug("...onlyActiveUsers....." + onlyActiveUsers);
            boolean isOnlyActiveUsers = false;
            if (StringUtils.isNotEmpty((CharSequence)onlyActiveUsers) && onlyActiveUsers.equalsIgnoreCase("true")) {
                isOnlyActiveUsers = true;
            }
            if (isExcelCreated = this.managementService.createExcelForUsers(cl, cloudId, userName, currentUser, isOnlyActiveUsers, site)) {
                if (isOnlyActiveUsers) {
                    if (site) {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "performed export sites for ", currentUser.getUserName(), "SharePoint Online", "Portal", System.currentTimeMillis(), PCActionTypes.EXPORT_ALL_DEVICES.getActionTypeValue());
                    } else {
                        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " performed export users with", currentUser.getUserName(), "Only Active Users", "Portal", System.currentTimeMillis(), PCActionTypes.EXPORT_ONLY_ACTIVE_USERS.getActionTypeValue());
                    }
                } else if (site) {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "performed export sites for ", currentUser.getUserName(), "SharePoint Online", "Portal", System.currentTimeMillis(), PCActionTypes.EXPORT_ALL_DEVICES.getActionTypeValue());
                } else {
                    this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "performed export users with", currentUser.getUserName(), "All user", "Portal", System.currentTimeMillis(), PCActionTypes.EXPORT_ALL_USERS.getActionTypeValue());
                }
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean authenticateAADUser(Cloud cloud, UserElement userElement, String password) {
        boolean success = false;
        AADUserElement aaDUserRequestElement = new AADUserElement();
        String userPrincipleName = userElement.getUserName();
        if (!org.springframework.util.StringUtils.isEmpty((Object)userElement.getAadLoginId())) {
            userPrincipleName = userElement.getAadLoginId();
        }
        aaDUserRequestElement.setPassword(password);
        aaDUserRequestElement.setUserName(userPrincipleName);
        logger.debug("...userPrincipleName..." + userPrincipleName);
        AADUserElement aadUser = null;
        try {
            aadUser = (AADUserElement)this.aadManagementService.getAADUser(cloud, userPrincipleName, password);
        }
        catch (Exception e) {
            logger.debug("Fail to login for " + userPrincipleName);
            return false;
        }
        if (aadUser != null) {
            logger.debug("login sucees in aad for " + userPrincipleName);
            return true;
        }
        return success;
    }

    private boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private boolean isLicenseEnabled(List<CloudCustomisableDetails> list, String key) {
        boolean isLicenseEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!key.equals(customisableDetails.getName())) continue;
            isLicenseEnabled = true;
            break;
        }
        return isLicenseEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/users/createExcelForBlackListAndMappedUser"}, method={RequestMethod.GET})
    public void createBlackListAndODBUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            logger.debug(request.getHeader("secAdmin") + "....secAdmin");
            logger.debug(request.getHeader("is-all-user") + "..is-all-user..");
            logger.debug(request.getHeader("newOdbUser") + "..newOdbUser..");
            logger.debug(request.getHeader("failedMailBox") + "..failedMailBox..");
            boolean isAllUser = Boolean.parseBoolean(request.getHeader("is-all-user"));
            boolean secAdmin = Boolean.parseBoolean(request.getHeader("secAdmin"));
            boolean newOdbUser = false;
            boolean failedMailBox = Boolean.parseBoolean(request.getHeader("failedMailBox"));
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            boolean isTextCreated = this.managementService.createTextForBlackListAndMappedUser(cl.getCloud().getCloudId(), cloudName, isAllUser, secAdmin, newOdbUser, failedMailBox);
            logger.debug("..isTextCreated.." + isTextCreated);
            if (isTextCreated) {
                response.setStatus(200);
                FileInputStream inputStream = new FileInputStream(new File("/var/www/odbInfo/BlackList_And_Active_User.txt"));
                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
                logger.debug("....new changes ");
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/mapODBId"}, method={RequestMethod.POST})
    public void mapODBId(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody UserListElement userList) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            if (!this.isODBEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setStatus(450);
                return;
            }
            logger.debug("...");
            this.managementService.mapODBIdsByFilePath(userList);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/users/mapODBIdAndErrorCode"}, method={RequestMethod.POST})
    public void mapODBIdAndErrorCode(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody UserListElement userList) {
        String cloudName = cloudName1;
        logger.debug("Cloud name :" + cloudName);
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("Invalid Cloud Name.....");
                return;
            }
            this.managementService.mapODBIdAndErrorCode(userList, cl.getCloud());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !ODB_ENABLED.equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private void sendEmailForUserDeviceLimitExceeded(Cloud cloud, String cloudName, String userName, String userLicense) {
        int cloudId = cloud.getCloudId();
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<com.parablu.pcbd.domain.User> allAdmins = this.managementService.getAllAdmins(cloudId, cloudName);
            for (com.parablu.pcbd.domain.User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("Portal");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(cloud, email);
    }

    @RequestMapping(value={"cloud/{cloudName}/envDetails/"}, method={RequestMethod.GET})
    public ModelAndView getEnvDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("cloud/{cloudName}/envDetails/....");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.addCloudCustomisableInHeader(response, cl);
            if (this.checkSQLbkpEnabled(cl)) {
                response.setHeader("isSQLBkpEnabled", "true");
            } else {
                response.setHeader("isSQLBkpEnabled", FALSE);
            }
            if (cl.getCloud().getGraphApiEnabled() == 1) {
                response.setHeader("graphApiEnabled", "true");
            } else {
                response.setHeader("graphApiEnabled", FALSE);
            }
            if (this.isClamAVScanEnabled(cl.getCloud())) {
                response.setHeader("clamAVScanEnabled", "true");
            } else {
                response.setHeader("clamAVScanEnabled", FALSE);
            }
            if (cl.getCloud().getGraphAADEnabled() == 1) {
                response.setHeader("graphAADEnabled", "true");
            } else {
                response.setHeader("graphAADEnabled", FALSE);
            }
            if (cl.getCloud().getMultiTenantAADEnabled() == 1) {
                response.setHeader("multiTenantAADEnabled", "true");
            } else {
                response.setHeader("multiTenantAADEnabled", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabled() == 1) {
                response.setHeader("contentSearchEnabled", "true");
            } else {
                response.setHeader("contentSearchEnabled", FALSE);
            }
            logger.debug("....sp sites allowed...." + cl.getCloud().getNoOfSPSitesAllowed());
            if (cl.getCloud().getNoOfSPSitesAllowed() > 0) {
                response.setHeader("Sharepoint_Backup_Enabled", "true");
            } else {
                response.setHeader("Sharepoint_Backup_Enabled", FALSE);
            }
            boolean oneDriveArchivingEnabled = this.isOneDriveArchivingEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (oneDriveArchivingEnabled) {
                response.setHeader("oneDriveArchivingEnabled", "true");
            } else {
                response.setHeader("oneDriveArchivingEnabled", FALSE);
            }
            boolean mailArchivingEnabled = this.isMailArchivingEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (mailArchivingEnabled) {
                response.setHeader("mailArchivingEnabled", "true");
            } else {
                response.setHeader("mailArchivingEnabled", FALSE);
            }
            boolean spArchivingEnabled = this.isSPArchivingEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (spArchivingEnabled) {
                response.setHeader("spArchivingEnabled", "true");
            } else {
                response.setHeader("spArchivingEnabled", FALSE);
            }
            boolean isInPlaceArchiveBackupEnabled = this.isInPlaceArchiveBackupEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isInPlaceArchiveBackupEnabled) {
                response.setHeader("inPlaceArchiveBackupEnabled", "true");
            } else {
                response.setHeader("inPlaceArchiveBackupEnabled", FALSE);
            }
            if (this.isLicenseEnabled(cl.getCloud(), RW_DETECTION_ENABLED)) {
                response.setHeader("rwDetectionEnabled", "true");
            } else {
                response.setHeader("rwDetectionEnabled", FALSE);
            }
            if (this.isLicenseEnabled(cl.getCloud(), C2C_RESTORE_ENABLED)) {
                response.setHeader("c2cRestoreEnabled", "true");
            } else {
                response.setHeader("c2cRestoreEnabled", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForSync() == 1) {
                response.setHeader("contentSearchEnabledForSync", "true");
            } else {
                response.setHeader("contentSearchEnabledForSync", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForOnedrive() == 1) {
                response.setHeader("contentSearchEnabledForOnedrive", "true");
            } else {
                response.setHeader("contentSearchEnabledForOnedrive", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForExchange() == 1) {
                response.setHeader("contentSearchEnabledForExchange", "true");
            } else {
                response.setHeader("contentSearchEnabledForExchange", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForGmail() == 1) {
                response.setHeader("contentSearchEnabledForGmail", "true");
            } else {
                response.setHeader("contentSearchEnabledForGmail", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForSharepoint() == 1) {
                response.setHeader("contentSearchEnabledForSharepoint", "true");
            } else {
                response.setHeader("contentSearchEnabledForSharepoint", FALSE);
            }
            if (cl.getCloud().getContentSearchEnabledForGdrive() == 1) {
                response.setHeader("contentSearchEnabledForGdrive", "true");
            } else {
                response.setHeader("contentSearchEnabledForGdrive", FALSE);
            }
            boolean isMSStorageAPIEnabled = this.isMSStorageAPIEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isMSStorageAPIEnabled) {
                response.setHeader("isMSStorageAPIEnabled", "true");
            } else {
                response.setHeader("isMSStorageAPIEnabled", FALSE);
            }
            boolean isSMBLicenseEnabled = this.isSMBLicenseEnabled(cl.getCloud().getCloudCustomisableDetails());
            if (isSMBLicenseEnabled) {
                response.setHeader("isSMBLicenseEnabled", "true");
            } else {
                response.setHeader("isSMBLicenseEnabled", FALSE);
            }
            if (this.isLicenseEnabled(cl.getCloud(), AV_SCAN_FOR_RESTORE)) {
                response.setHeader("isEndpointRestoreAVScanEnabled", "true");
            } else {
                response.setHeader("isEndpointRestoreAVScanEnabled", FALSE);
            }
            if (isSMBLicenseEnabled) {
                logger.debug(".....smb so send msapp....");
                TenantConsentStatus result = this.managementService.findTenantConsentStatus(cl.getCloud().getCloudId());
                MSAppSetting msAppSettingsDetails = this.componentSettingService.getMSAppSettingsDetails(cl.getCloud().getCloudId());
                IdentityProviderSettingsElement aadCredentialsElement = new IdentityProviderSettingsElement();
                BeanUtils.copyProperties((Object)aadCredentialsElement, (Object)msAppSettingsDetails);
                aadCredentialsElement.setTenentId(msAppSettingsDetails.getTenantId());
                logger.debug(".....end-smb so send msapp...." + result.isTenantIdUpdated());
                if (result == null || !result.isTenantIdUpdated()) {
                    modelAndView.addObject((Object)aadCredentialsElement);
                    response.setStatus(434);
                    return modelAndView;
                }
                return this.checkAndReturnAADElement(response, modelAndView, cl, aadCredentialsElement);
            }
            if (this.isAADEnabled(cl.getCloud().getCloudCustomisableDetails())) {
                response.setHeader("aadEnabled", "true");
                IdentityProviderSettingsElement aadCredentialsElement = null;
                logger.debug("IS CP asIDP:" + this.registry.get(cloudId).isCPasIDP());
                aadCredentialsElement = this.registry.get(cloudId).isCPasIDP() ? this.aadManagementService.getCrashPlanCredentials(cl.getCloud().getCloudId()) : this.aadManagementService.getAADCredentials(cl.getCloud().getCloudId());
                if (aadCredentialsElement != null) {
                    aadCredentialsElement.setSecretKey(null);
                }
                return this.checkAndReturnAADElement(response, modelAndView, cl, aadCredentialsElement);
            }
            if (this.isLdapEnabledForCloud(cl)) {
                response.setHeader("adEnabled", "true");
            }
            response.setStatus(200);
            return modelAndView;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
            return modelAndView;
        }
    }

    private ModelAndView checkAndReturnAADElement(HttpServletResponse response, ModelAndView modelAndView, CloudLicenseTo cl, IdentityProviderSettingsElement aadCredentialsElement) {
        if (aadCredentialsElement != null) {
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cl.getCloud().getCloudId());
            if (cloudPropertyElement != null && !cloudPropertyElement.isPortalSSOEnable()) {
                response.setStatus(434);
                return null;
            }
            modelAndView.addObject((Object)aadCredentialsElement);
            response.setStatus(435);
            return modelAndView;
        }
        response.setStatus(450);
        return null;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/all"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        boolean includeMSProtected = Boolean.parseBoolean(request.getHeader("includeMSProtected"));
        logger.debug(request.getParameter("includeMSProtected") + "....calling getAllUsers ... " + request.getHeader("includeMSProtected"));
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String type = request.getHeader("type");
            String pagination = request.getHeader("pagination");
            com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response, userName)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            UserElementResponse ue = new UserElementResponse();
            ArrayList<String> policyNames = new ArrayList<String>();
            ArrayList<String> syncPolicyNames = new ArrayList<String>();
            ArrayList<String> odbPolicyNames = new ArrayList<String>();
            ArrayList<String> gmailPolicyNames = new ArrayList<String>();
            ArrayList<String> gdrivePolicyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    syncPolicyNames.addAll(user.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    odbPolicyNames.addAll(user.getOdbPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getGmailPoliciesAdmin())) {
                    gmailPolicyNames.addAll(user.getGmailPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getGdrivePoliciesAdmin())) {
                    gdrivePolicyNames.addAll(user.getGdrivePoliciesAdmin());
                }
            }
            List<Object> userList = new ArrayList();
            userList = user.isReadOnlyAdmin() ? this.managementService.getAllUsersForReadOnlyWithPagination(cloudId, pagNum, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames, false, pagination) : this.managementService.getAllUsers(cloudId, pagNum, user, false, pagination);
            userList = CPHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equalsIgnoreCase(type) ? userList.stream().filter(filteredUser -> type.equalsIgnoreCase(filteredUser.getUserType())).collect(Collectors.toList()) : userList.stream().filter(filteredUser -> !CPHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equalsIgnoreCase(filteredUser.getUserType())).collect(Collectors.toList());
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            if (includeMSProtected) {
                userList = UserManagementController.filterUsersWithProtectionTimes(userList);
            }
            ue.setUsers(userList);
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = 0L;
            totalRecordsCount = user.isReadOnlyAdmin() ? this.managementService.getAllUsersCount(cloudId, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames) : this.managementService.getAllUsersCount(cloudId);
            logger.debug(userList.size() + "...users count:" + totalRecordsCount);
            if (CollectionUtils.isEmpty(userList)) {
                totalRecordsCount = 0L;
            }
            response.setStatus(200);
            return this.toJSON(200, new ResponseMetadataElement(), ue);
        }
        catch (BaseException e) {
            logger.debug("EXception..." + e.getMessage());
            response.setStatus(500);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/softBlock/users/all"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getAllSoftBlockUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling getAllSoftBlockUsers ... ");
        try {
            com.parablu.pcbd.domain.User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new com.parablu.pcbd.domain.User(), response, userName)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            UserElementResponse ue = new UserElementResponse();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    policyNames.addAll(user.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    policyNames.addAll(user.getOdbPoliciesAdmin());
                }
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            pageNumber = 555;
            List<UserElement> userList = this.managementService.getAllSoftBlockUsers(cloudId, pagNum, user);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = this.managementService.getAllSoftBlockUsersCount(cloudId, policyNames);
            if (CollectionUtils.isEmpty(userList)) {
                totalRecordsCount = 0L;
            }
            response.setStatus(200);
            logger.debug("end of  getAllSoftBlockUsers ... ");
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), ue);
        }
        catch (Exception e) {
            logger.debug("EXception..." + e.getMessage());
            response.setStatus(500);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/softBlock/users/all/excel/"}, method={RequestMethod.POST})
    @ResponseBody
    public void getAllSoftBlockUsersToexcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getAllSoftBlockUsers to excel... ");
        try {
            com.parablu.pcbd.domain.User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new com.parablu.pcbd.domain.User(), response, userName)) {
                response.setStatus(1201);
                return;
            }
            ArrayList policyNames = new ArrayList();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    policyNames.addAll(user.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    policyNames.addAll(user.getOdbPoliciesAdmin());
                }
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(400);
                return;
            }
            boolean success = this.managementService.createExcelforSoftBlockUsers(cloudId, user);
            if (success) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
            logger.debug("end of  getAllSoftBlockUsers  download... ");
        }
        catch (Exception e) {
            logger.debug("EXception..." + e.getMessage());
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/user/dm/all"}, method={RequestMethod.GET})
    public ModelAndView getAllUsersForDataMigration(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling getAllUsers /user/dm/all... ");
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(" Skip values .... " + skipValue);
            List<UserElement> userList = this.managementService.getAllBlockedUsersForDataMigration(cloudId, skipValue);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
            logger.debug("end of calling getAllUsers /user/dm/all... ");
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/user/startdm/"}, method={RequestMethod.POST})
    public ModelAndView startUserDataMigration(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        logger.debug(request.getHeader("destOdbId") + " start migration of data for users ..." + request.getHeader("users"));
        String blockedBy = request.getHeader(USER_NAME);
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        try {
            if (org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("users")) || org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("destOdbId"))) {
                logger.error("...invalid request...");
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            boolean active = Boolean.parseBoolean(request.getHeader("blocked"));
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return null;
            }
            ArrayList<String> usersList = new ArrayList<String>(Arrays.asList(request.getHeader("users").split(",")));
            Object failedUsers = "";
            for (String userName : usersList) {
                boolean isMigrationStarted = this.managementService.startMigration(cloudId, userName, request.getHeader("destOdbId"));
                if (!isMigrationStarted) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)failedUsers)) {
                        failedUsers = userName;
                        continue;
                    }
                    failedUsers = (String)failedUsers + "," + userName;
                    continue;
                }
                logger.debug(String.valueOf(currentUser) + ".. successfully migrated .... " + userName);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " started data migration ", currentUser.getUserName(), userName, "Portal", System.currentTimeMillis(), PCActionTypes.USER_DATA_MIGRATION.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    private void addCloudCustomisableInHeader(HttpServletResponse response, CloudLicenseTo cl) {
        List list = cl.getCloud().getCloudCustomisableDetails();
        boolean isBackupEnabled = false;
        boolean isSyncEnabled = false;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                response.setHeader(cloudPluginDetails.getName().replace(" ", "_"), "true");
                if (BACK_UP_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) {
                    isBackupEnabled = true;
                }
                if (!SYNC_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSyncEnabled = true;
            }
            if (!isBackupEnabled) {
                response.setHeader(BACK_UP_ENABLED.replace(" ", "_"), FALSE);
            }
            if (!isSyncEnabled) {
                response.setHeader(SYNC_ENABLED.replace(" ", "_"), FALSE);
            }
        }
    }

    private boolean checkSQLbkpEnabled(CloudLicenseTo cl) {
        boolean isSQLBkpEnabled = false;
        List list = cl.getCloud().getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"SQL Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSQLBkpEnabled = true;
                break;
            }
        }
        return isSQLBkpEnabled;
    }

    private boolean isClamAVScanEnabled(Cloud cl) {
        boolean isClamAVScanEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || org.springframework.util.StringUtils.isEmpty((Object)cloudPluginDetails.getName()) || !AV_SCAN_ENABLED.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isClamAVScanEnabled = true;
                break;
            }
        }
        logger.debug("is ClamAV Scan Enabled...." + isClamAVScanEnabled);
        return isClamAVScanEnabled;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/emailIds"}, method={RequestMethod.GET})
    public ModelAndView getAllUsersEmailIds(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String cloudName = cloudName1;
        try {
            logger.debug("calling getAllUsersEmailIds ... ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            List<UserElement> userList = this.managementService.loadAllUsersEmailIds(cloudId);
            UserElementResponse elementResponse = new UserElementResponse();
            elementResponse.setUsers(userList);
            modelAndView.addObject((Object)elementResponse);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/excel/updateOdb"}, method={RequestMethod.POST})
    public void updateOdbIdsViaExcel(@PathVariable(value="cloudName") String cloudName1, @RequestBody List<OdbMappingList> odbMappingList, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            boolean active = Boolean.parseBoolean(request.getHeader("blocked"));
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return;
            }
            List<OdbMappingList> faileduserList = this.managementService.updateObdIdViaExcel(odbMappingList, cloudId, cloudName, currentUser);
            if (faileduserList.isEmpty()) {
                response.setStatus(200);
            } else {
                response.setStatus(409);
            }
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/updateOdb"}, method={RequestMethod.POST})
    public void updateOdbIds(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        String userNames = request.getHeader("userNames");
        try {
            if (org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("users")) || org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("destOdbId"))) {
                logger.error("...invalid request...");
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            boolean active = Boolean.parseBoolean(request.getHeader("blocked"));
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return;
            }
            ArrayList<String> usersList = new ArrayList<String>(Arrays.asList(request.getHeader("users").split(",")));
            Object failedUsers = "";
            for (String userName : usersList) {
                boolean isMigrationStarted = this.managementService.mapODBIds(cloudId, userName, request.getHeader("destOdbId"));
                if (!isMigrationStarted) {
                    if (org.springframework.util.StringUtils.isEmpty((Object)failedUsers)) {
                        failedUsers = userName;
                        continue;
                    }
                    failedUsers = (String)failedUsers + "," + userName;
                    continue;
                }
                logger.debug(String.valueOf(currentUser) + ".. successfully updated .... " + userName);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " update ODB Id for " + userName + " as ", currentUser.getUserName(), request.getHeader("destOdbId"), "Portal", System.currentTimeMillis(), PCActionTypes.UPDATED_ODB_ID.getActionTypeValue());
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/unMapedUsers"}, method={RequestMethod.GET})
    public ModelAndView getAllUnMapedUsers(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String cloudName = cloudName1;
        try {
            logger.debug("calling getAllUsersEmailIds ... ");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            List<UserElement> userList = this.managementService.getAllUnMapedUsers(cloudId);
            UserElementResponse elementResponse = new UserElementResponse();
            elementResponse.setUsers(userList);
            modelAndView.addObject((Object)elementResponse);
            response.setStatus(200);
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (Exception e) {
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/userWithoutDevice"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllUsersWithoutdevice(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling getAllUsersWithoutdevice ... ");
        try {
            com.parablu.pcbd.domain.User user;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String showBlockedDevices = request.getHeader("showBlockedDevices");
            String productType = request.getHeader("productType");
            logger.debug(productType + "...... prod ...showBlockedDevices..." + showBlockedDevices);
            boolean showBlockedDevicesBol = false;
            if (!org.springframework.util.StringUtils.isEmpty((Object)showBlockedDevices) && showBlockedDevices.equalsIgnoreCase("true")) {
                showBlockedDevicesBol = true;
            }
            if (!this.performAuthorization(cloudId, cloudName, token, user = new com.parablu.pcbd.domain.User(), response, userName)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            UserElementResponse ue = new UserElementResponse();
            ArrayList<String> policyNames = new ArrayList();
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("policyNames"))) {
                policyNames = new ArrayList<String>(Arrays.asList(request.getHeader("policyNames").split(",")));
            }
            logger.debug(request.getHeader("policyNames"));
            List<UserElement> userList = this.managementService.getAllUsersWithoutdevice(cloudId, pagNum, policyNames, showBlockedDevicesBol, productType);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = userList.size();
            response.setStatus(200);
            String productTypeString = productType;
            if (!org.springframework.util.StringUtils.isEmpty((Object)productTypeString)) {
                if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                    productTypeString = "Microsoft OneDrive";
                } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                    productTypeString = "SharePoint Online";
                } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                    productTypeString = "Microsoft Exchange";
                } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                    productTypeString = "Backup Product";
                } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.GMAIL.getProductType())) {
                    productTypeString = "Gmail Product";
                } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.GOOGLEDRIVE.getProductType())) {
                    productTypeString = "Gdrive Product";
                }
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "viewed report", user.getUserName(), "Users Without Active Assets (" + productTypeString + ")", "Portal", System.currentTimeMillis(), PCActionTypes.GENERATED_REPORT.getActionTypeValue());
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), ue);
        }
        catch (BaseException e) {
            logger.debug("EXception..." + e.getMessage());
            response.setStatus(500);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/users/userWithoutDevice/createExcel/"}, method={RequestMethod.POST})
    public void createUserWithoutExcel(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        com.parablu.pcbd.domain.User user;
        int cloudId;
        String cloudName = cloudName1;
        String productType = request.getHeader("productType");
        logger.debug("start /users/userWithoutDevice/createExcel/ " + cloudName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            logger.debug("Invalid Cloud Name.....");
            return;
        }
        String token = request.getHeader("token");
        String userName = request.getHeader(USER_NAME);
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            userName = this.decodeBase64UTFString(userName);
        }
        if (!this.performAuthorization(cloudId = cl.getCloud().getCloudId(), cloudName, token, user = new com.parablu.pcbd.domain.User(), response, userName)) {
            return;
        }
        try {
            String showBlockedDevices = request.getHeader("showBlockedDevices");
            logger.debug(productType + "...... prod ...showBlockedDevices..." + showBlockedDevices);
            boolean showBlockedDevicesBol = false;
            if (showBlockedDevices.equalsIgnoreCase("true")) {
                showBlockedDevicesBol = true;
            }
            ArrayList<String> policyNames = new ArrayList();
            if (!org.springframework.util.StringUtils.isEmpty((Object)request.getHeader("policyNames"))) {
                policyNames = new ArrayList<String>(Arrays.asList(request.getHeader("policyNames").split(",")));
            }
            logger.debug(request.getHeader("policyNames"));
            boolean isExcelCreated = this.managementService.createUserWithoutExcel(cl, cloudId, 0, policyNames, showBlockedDevicesBol, productType);
            if (isExcelCreated) {
                response.setStatus(200);
            } else {
                response.setStatus(403);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        String productTypeString = productType;
        if (!org.springframework.util.StringUtils.isEmpty((Object)productTypeString)) {
            if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                productTypeString = "Microsoft OneDrive";
            } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                productTypeString = "SharePoint Online";
            } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                productTypeString = "Microsoft Exchange";
            } else if (productTypeString.equals(CPHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                productTypeString = "Backup Product";
            }
        }
        this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "generated Excel report", user.getUserName(), "Users Without Active Assets (" + productTypeString + ")", "Portal", System.currentTimeMillis(), PCActionTypes.GENERATED_REPORT.getActionTypeValue());
        logger.debug("end /users/userWithoutDevice/createExcel/ " + cloudName);
    }

    private void sendEmailForUserLimitExceded(Cloud cloud, String cloudName, String userName, String userLicense) {
        int cloudId = cloud.getCloudId();
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction("user-limit-reached");
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<com.parablu.pcbd.domain.User> allAdmins = this.managementService.getAllAdmins(cloudId, cloudName);
            for (com.parablu.pcbd.domain.User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy("");
        email.setStartDate(DateUtil.getDateInddMMMyyyy((long)System.currentTimeMillis()));
        email.setDeviceName(userName);
        email.setRecipents(emailRecipents);
        email.setToUser(true);
        email.setBodyData("Portal");
        email.setSupportDescription(userLicense);
        email.setUserName(userName);
        email.setActionOn(userName);
        email.setUserName(userName);
        this.cloudMailService.sendMail(cloud, email);
    }

    @RequestMapping(value={"cloud/{cloudName}/user/update/password/firstLogIn"}, method={RequestMethod.PUT})
    public ModelAndView updateUserPasswordOnFirstLogon(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            String username = request.getHeader(USER_NAME);
            String password = request.getHeader(PASSWORD);
            String accesskey = request.getHeader("accessKey");
            logger.debug("calling /updateUserPassword first log on..." + username);
            if (!org.springframework.util.StringUtils.hasText((String)username) || !org.springframework.util.StringUtils.hasText((String)password)) {
                throw new BaseException(INVALID_REQUEST);
            }
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            CacheHelper cacheHelper = new CacheHelper(cl.getCloud().getCloudId(), this.registry);
            if (!org.springframework.util.StringUtils.isEmpty((Object)accesskey)) {
                String uniqueId = username;
                if (StringUtils.isNotEmpty((CharSequence)uniqueId)) {
                    UserElement ue = this.managementService.getUserByUserNameOrEmail(1, uniqueId);
                    if (ue != null) {
                        uniqueId = ue.getEmailId();
                    }
                    OTPValidation otpValidation = this.authorizationService1.getOTPForUniqueId(1, uniqueId);
                    logger.debug("otp value:" + String.valueOf(otpValidation));
                    logger.debug("otp value:" + otpValidation.getToken());
                    if (otpValidation == null || !accesskey.equalsIgnoreCase(otpValidation.getToken())) {
                        logger.error("access key validation not successfull..");
                        response.setStatus(451);
                        return null;
                    }
                    if (accesskey.equalsIgnoreCase(otpValidation.getToken()) && otpValidation.getModifiedTime() + (long)(this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000) < System.currentTimeMillis()) {
                        logger.error("access key validation not successfull.." + this.registry.get(cloudId).getAccessCodeExpiryTimeInMins() * 60 * 1000);
                        response.setStatus(451);
                        return null;
                    }
                } else {
                    logger.error("unique id not found....");
                    response.setStatus(451);
                    return null;
                }
            }
            String userName = username.replaceAll(" ", "_");
            UserElement element = this.managementService.getUserByUserNameOrEmail(cl.getCloud(), username);
            if (org.springframework.util.StringUtils.isEmpty((Object)element)) {
                response.setStatus(400);
                return null;
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)element.getPasswdHash())) {
                response.setHeader("ldapuser", "true");
                response.setStatus(400);
                return null;
            }
            element.setPasswdHash(password);
            element.setFirstLogin(false);
            this.managementService.updateUserInfo(cloudId, cloudName, element, userName);
            cacheHelper.removeKeyFromCache(userName + RESET_PASSWORD);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " reset the password ", username, "", "Portal", System.currentTimeMillis(), PCActionTypes.RESET_PASSWORD.getActionTypeValue());
            response.setStatus(200);
            return null;
        }
        catch (IOException e) {
            response.setStatus(500);
            logger.trace(IO_EXCEPTION + String.valueOf(e));
            logger.error(IO_EXCEPTION + e.getMessage());
            return null;
        }
        catch (EmptyResultDataAccessException e) {
            ErrorElement err = this.createErrorElement(null, USER_NOT_FOUND);
            modelAndView.addObject((Object)err);
            response.setStatus(409);
            logger.trace(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(EMPTY_RESULT_DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (DataAccessException e) {
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(DATA_ACCESS_EXCEPTION + String.valueOf((Object)e));
            logger.error(DATA_ACCESS_EXCEPTION + e.getMessage());
        }
        catch (BaseException e) {
            ErrorElement err = this.createErrorElement(e.getErrorCode(), null);
            modelAndView.addObject((Object)err);
            response.setStatus(400);
            logger.trace(BASE_EXCEPTION + String.valueOf((Object)e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    public boolean createGuestUser(String userNameList, String productType, int cloudId, String cloudName, HttpServletResponse response, Cloud cloud, String actionByUserName) {
        try {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNameList.split(",")));
            for (String userName : list) {
                UserElement existingUser = this.managementService.getUserByUserNameOrEmail(cloudId, userName);
                if (existingUser != null && StringUtils.isNotEmpty((CharSequence)existingUser.getUserName())) {
                    logger.debug("user already exist.......");
                    continue;
                }
                logger.debug("user doesnot exist....");
                UserElement userElement = new UserElement();
                userElement.setUserName(userName);
                userElement.setEmailId(userName);
                String pwd = this.generaterandompswd();
                userElement.setPasswdHash(this.generatePassWordhash(pwd));
                long modifiedTime = System.currentTimeMillis();
                userElement.setLastModifiedTimestamp(String.valueOf(modifiedTime));
                userElement.setActive(true);
                userElement.setAdmin(false);
                userElement.setReadOnlyAdmin(false);
                userElement.setGuest(true);
                userElement.setFirstLogin(true);
                userElement.setSyncEnabled(false);
                userElement.setSyncAccessType("DISABLED");
                userElement.setBackupEnabled(false);
                userElement.setShareEnabled(true);
                userElement.setCreatedTimestamp(String.valueOf(modifiedTime));
                userElement.setPolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultBkpPolicy());
                userElement.setSyncPolicyName(this.registry.get(cloudId).getPropertyFileValueDefaultSyncPolicy());
                userElement.setDeleted(false);
                userElement.setSoftBlockEnabled(false);
                userElement.setLastLoggedInTime("");
                userElement.setLocalUser(false);
                userElement.setOdbLoginId("");
                userElement.setSuspended(false);
                userElement.setBackupTargetAssigned(false);
                userElement.setBackupTargetErrorCode(0);
                userElement.setUserNameLowerCase(userName.toLowerCase());
                userElement.setActive(false);
                userElement.setPolicyModifiedTime(modifiedTime);
                String googleSecretKey = this.getGoogleSecurityKey();
                userElement.setGoogleSecretKey(googleSecretKey);
                logger.debug(" CREATE USER IS SHARE ENABLED .. " + userElement.isShareEnabled());
                UserElement userElement2 = this.managementService.createUser(cloudId, cloudName, userElement, userElement.getUserName(), pwd, false, false);
            }
        }
        catch (Exception e) {
            logger.error("error to create guest user .....", (Throwable)e);
            return true;
        }
        return false;
    }

    private String generaterandompswd() {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.";
        String pwd = RandomStringUtils.random((int)8, (String)characters);
        return pwd;
    }

    public String getGoogleSecurityKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        Base32 base32 = new Base32();
        String googleSecretKey = base32.encodeToString(bytes);
        return googleSecretKey;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/sites/all"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getAllSites(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="pageNumber") int pageNumber1) {
        String cloudName = cloudName1;
        logger.debug("calling getAllSites ... ");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            cloudName = cloud.getCloudName();
            int pageNumber = pageNumber1;
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            String pagination = request.getHeader("pagination");
            com.parablu.pcbd.domain.User user = new com.parablu.pcbd.domain.User();
            if (!this.performAuthorization(cloudId, cloudName, token, user, response, userName)) {
                return this.toJSON(1201);
            }
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
            int pagNum = 0;
            if (pageNumber > 0) {
                pagNum = pageNumber - 1;
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            UserElementResponse ue = new UserElementResponse();
            ArrayList<String> policyNames = new ArrayList<String>();
            ArrayList<String> syncPolicyNames = new ArrayList<String>();
            ArrayList<String> odbPolicyNames = new ArrayList<String>();
            ArrayList<String> gmailPolicyNames = new ArrayList<String>();
            ArrayList<String> gdrivePolicyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getBackupPoliciesAdmin())) {
                    policyNames.addAll(user.getBackupPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    syncPolicyNames.addAll(user.getSyncPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getOdbPoliciesAdmin())) {
                    odbPolicyNames.addAll(user.getOdbPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getGmailPoliciesAdmin())) {
                    gmailPolicyNames.addAll(user.getGmailPoliciesAdmin());
                }
                if (!CollectionUtils.isEmpty((Collection)user.getGdrivePoliciesAdmin())) {
                    gdrivePolicyNames.addAll(user.getGdrivePoliciesAdmin());
                }
            }
            List<Object> userList = new ArrayList();
            boolean isSite = true;
            if (user.isReadOnlyAdmin()) {
                logger.debug("...inside readonly.....");
                userList = this.managementService.getAllUsersForReadOnlyWithPagination(cloudId, pagNum, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames, isSite, pagination);
            } else {
                logger.debug("...inside normal.....");
                userList = this.managementService.getAllUsers(cloudId, pagNum, user, isSite, pagination);
            }
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            Map paramSet = request.getParameterMap();
            long totalRecordsCount = 0L;
            totalRecordsCount = user.isReadOnlyAdmin() ? this.managementService.getAllUsersCount(cloudId, policyNames, syncPolicyNames, odbPolicyNames, gmailPolicyNames, gdrivePolicyNames) : this.managementService.getAllUsersCount(cloudId);
            if (CollectionUtils.isEmpty(userList)) {
                totalRecordsCount = 0L;
            }
            response.setStatus(200);
            logger.debug("...end of get all sites...");
            return this.toJSON(200, this.getMetadataElement(cloudPropertyElement.getReportRows(), pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), ue);
        }
        catch (BaseException e) {
            logger.debug("EXception..." + e.getMessage());
            response.setStatus(500);
            return this.toJSON(400);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/sites/discovery"}, method={RequestMethod.GET})
    public ModelAndView sitesDiscovery(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        UserElementResponse ue = new UserElementResponse();
        modelAndView.setViewName("xmlview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            int skipValue = request.getIntHeader("skipValue");
            logger.debug(" Skip values .... " + skipValue);
            List<UserElement> userList = this.managementService.getExistingSites(cloudId, skipValue);
            userList.removeAll(Collections.singleton(null));
            Collections.sort(userList, new Comparator<UserElement>(this){

                @Override
                public int compare(UserElement u1, UserElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)UserManagementController.getStatus(u1.isActive()), (Object)UserManagementController.getStatus(u2.isActive())).append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            ue.setUsers(userList);
            modelAndView.addObject((Object)ue);
            response.setStatus(200);
        }
        catch (Exception e) {
            ErrorElement err = this.createErrorElement("500", null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/sites/policyMapping/"}, method={RequestMethod.POST})
    public void updateSiteMapping(@PathVariable(value="cloudName") String cloudName1, @RequestBody SiteElement siteElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/sites/policyMapping/");
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            this.managementService.updateSiteMapping(cloudId, siteElement, currentUser.getUserName());
            response.setStatus(201);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(EXCEPTION, null);
            modelAndView.addObject((Object)err);
            response.setStatus(417);
            logger.error("exception calling versions/{versionNumber}/clouds/{cloudName}/sites/policyMapping/" + String.valueOf(e));
        }
        logger.debug("end of calling versions/{versionNumber}/clouds/{cloudName}/sites/policyMapping/");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/sites/create/"}, method={RequestMethod.POST})
    public void createSite(@PathVariable(value="cloudName") String cloudName1, @RequestBody SiteElement siteElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/sites/create/");
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            this.asyncService.createUserSiteAsync(cl.getCloud(), siteElement, currentUser.getUserName(), cloudName, userName);
            response.setStatus(201);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(EXCEPTION, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.error("exception calling versions/{versionNumber}/clouds/{cloudName}/sites/create/" + String.valueOf(e));
        }
        logger.debug("end of calling versions/{versionNumber}/clouds/{cloudName}/sites/create/");
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/gpusers/create/"}, method={RequestMethod.POST})
    public void createGPUsers(@PathVariable(value="cloudName") String cloudName1, @RequestBody GraphUserElement graphUserElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling versions/{versionNumber}/clouds/{cloudName}/gpusers/create/..." + request.getHeader("productType"));
        com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                logger.debug(headerName + " header name and value : " + headerValue);
            }
            String token = request.getHeader("token");
            String policyType = request.getHeader("policyType");
            String productType = request.getHeader("productType");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            logger.debug(graphUserElement.getDefaultExchangePolicyName() + " ....versions/{versionNumber}/clouds/{cloudName}/gpusers/create/..." + graphUserElement.getDefaultOdbPolicyName());
            int code = this.asyncService.createGraphUserAsync(cl.getCloud(), graphUserElement, currentUser.getUserName(), cloudName, policyType, productType);
            if (code == 1535) {
                logger.debug("....code..." + code + "....406");
                response.setStatus(406);
            } else {
                response.setStatus(201);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement(EXCEPTION, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.error("exception calling versions/{versionNumber}/clouds/{cloudName}/gpusers/create/" + String.valueOf(e));
        }
        logger.debug("end of calling versions/{versionNumber}/clouds/{cloudName}/gpusers/create/");
    }

    private void sendEmailSP(Cloud cloud, String action, String siteName, String userName, String cloudName) {
        EmailProps email = new EmailProps();
        ArrayList<EmailRecipent> emailRecipents = new ArrayList<EmailRecipent>();
        email.setAction(action);
        EmailRecipent emailRecipent = new EmailRecipent();
        try {
            List<com.parablu.pcbd.domain.User> allAdmins = this.managementService.getAllAdmins(1, "");
            for (com.parablu.pcbd.domain.User adminUser : allAdmins) {
                emailRecipent = new EmailRecipent();
                emailRecipent.setUserName(adminUser.getUserName());
                emailRecipent.setEmail(adminUser.getEmailId());
                emailRecipents.add(emailRecipent);
                logger.debug("...admin...." + adminUser.getUserName());
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
        }
        logger.debug("Toatal email recipents count...:" + emailRecipents.size());
        email.setActionBy(userName);
        email.setRecipents(emailRecipents);
        email.setUserName(siteName);
        email.setToUser(true);
        email.setToAdmins(true);
        email.setCloudName(cloudName);
        this.cloudMailService.sendMail(cloud, email);
    }

    private void removeUserbyID(int cloudId, String userId) {
        try {
            this.managementService.removeUserbyID(cloudId, userId);
        }
        catch (Exception e) {
            logger.debug("error.......", (Throwable)e);
            e.printStackTrace();
        }
    }

    private String getCaptcha() {
        char[] data = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] index = new char[7];
        Random r = new Random();
        int i = 0;
        for (i = 0; i < index.length; ++i) {
            int ran = r.nextInt(data.length);
            index[i] = data[ran];
        }
        return new String(index);
    }

    private boolean isLicenseEnabled(Cloud cl, String licenseName) {
        boolean isLicenseEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || org.springframework.util.StringUtils.isEmpty((Object)cloudPluginDetails.getName()) || !licenseName.equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isLicenseEnabled = true;
                break;
            }
        }
        logger.debug(licenseName + " Enabled.... " + isLicenseEnabled);
        return isLicenseEnabled;
    }

    @RequestMapping(value={"cloud/{cloudName}/sites/config"}, method={RequestMethod.GET})
    public ModelAndView sitesConfigDiscovery(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("start of calling cloud/{cloudName}/sites/config");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            List odbPolicyNames = new ArrayList();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return null;
            }
            SiteElement siteElement = this.managementService.getExistingSiteElement(cloudId);
            ArrayList<String> configuredSitesToRemove = new ArrayList<String>();
            if (currentUser != null && currentUser.isReadOnlyAdmin()) {
                odbPolicyNames = currentUser.getOdbPoliciesAdmin();
                Map configuredSites = siteElement.getSiteMap();
                for (Map.Entry configuredSiteEntry : configuredSites.entrySet()) {
                    String policyName = (String)configuredSiteEntry.getValue();
                    String userName = (String)configuredSiteEntry.getKey();
                    if (odbPolicyNames.contains(policyName)) continue;
                    configuredSitesToRemove.add(userName);
                }
                for (String configuredSiteToRemove : configuredSitesToRemove) {
                    configuredSites.remove(configuredSiteToRemove);
                }
            }
            modelAndView.addObject((Object)siteElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement("500", null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        logger.debug("end of calling cloud/{cloudName}/sites/config");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/graphusers/config"}, method={RequestMethod.GET})
    public ModelAndView graphUsersConfigDiscovery(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("start of calling cloud/{cloudName}/graphusers/config..." + request.getHeader("productType"));
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            com.parablu.pcbd.domain.User currentUser = new com.parablu.pcbd.domain.User();
            List odbPolicyNames = new ArrayList();
            String token = request.getHeader("token");
            String userName1 = request.getHeader(USER_NAME);
            String productType = request.getHeader("productType");
            if (StringUtils.isNotEmpty((CharSequence)userName1)) {
                userName1 = this.decodeBase64UTFString(userName1);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName1)) {
                return null;
            }
            logger.debug("....productType...." + productType);
            if ("Exchange".equalsIgnoreCase(productType)) {
                productType = "OUTLOOK";
            }
            if ("ODB".equalsIgnoreCase(productType)) {
                productType = "ONEDRIVE";
            }
            GraphUserElement graphUserElement = this.managementService.getExistingGraphUserElement(cloudId, productType);
            ArrayList<String> configuredgraphusersToRemove = new ArrayList<String>();
            if (currentUser != null && currentUser.isReadOnlyAdmin()) {
                odbPolicyNames = currentUser.getOdbPoliciesAdmin();
                Map configuredgraphusers = graphUserElement.getUserMap();
                for (Map.Entry configuredSiteEntry : configuredgraphusers.entrySet()) {
                    String policyName = (String)configuredSiteEntry.getValue();
                    String userName = (String)configuredSiteEntry.getKey();
                    if (odbPolicyNames.contains(policyName)) continue;
                    configuredgraphusersToRemove.add(userName);
                }
                for (String configuredSiteToRemove : configuredgraphusersToRemove) {
                    configuredgraphusers.remove(configuredSiteToRemove);
                }
            }
            modelAndView.addObject((Object)graphUserElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorElement err = this.createErrorElement("500", null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
            logger.trace(BASE_EXCEPTION + String.valueOf(e));
            logger.error(BASE_EXCEPTION + e.getMessage());
        }
        logger.debug("end of calling cloud/{cloudName}/graphusers/config");
        return modelAndView;
    }

    private boolean isOneDriveArchivingEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isOneDriveArchivingEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isOneDriveArchivingEnabled = true;
            break;
        }
        return isOneDriveArchivingEnabled;
    }

    private boolean isMailArchivingEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isMailArchivingEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"Mail Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isMailArchivingEnabled = true;
            break;
        }
        return isMailArchivingEnabled;
    }

    private boolean isSPArchivingEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isMailArchivingEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SP Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isMailArchivingEnabled = true;
            break;
        }
        return isMailArchivingEnabled;
    }

    private boolean isInPlaceArchiveBackupEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isInPlaceArchiveBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"In-Place Archive Enabled".equalsIgnoreCase(license.getName())) continue;
            isInPlaceArchiveBackupEnabled = true;
            break;
        }
        return isInPlaceArchiveBackupEnabled;
    }

    private boolean isMSStorageAPIEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isInPlaceArchiveBackupEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"MS Storage API Enabled".equalsIgnoreCase(license.getName())) continue;
            isInPlaceArchiveBackupEnabled = true;
            break;
        }
        return isInPlaceArchiveBackupEnabled;
    }

    @RequestMapping(value={"/user/"}, method={RequestMethod.GET})
    public ResponseEntity<com.parablu.pcbd.domain.User> getUser(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Entering CloudSettingsController.pingCloud");
        try {
            String userName = request.getHeader(USER_NAME);
            com.parablu.pcbd.domain.User user = this.managementService.getUserDetails(1, "", userName);
            ResponseEntity entity = new ResponseEntity((Object)user, (HttpStatusCode)HttpStatus.OK);
            return entity;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + String.valueOf(e));
            logger.error(EXCEPTION + e.getMessage());
            response.setStatus(400);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/logout"}, method={RequestMethod.POST})
    public void logout(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader(USER_NAME);
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            logger.debug("token to delete..." + token);
            if (token != null) {
                this.authorizationService1.deleteToken(cloudId, token);
            }
        }
        catch (Exception e) {
            logger.error("exception while updating the otp..", (Throwable)e);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/comments/all"}, method={RequestMethod.GET})
    public ModelAndView getAllComments(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="limit") int limit) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("get all the comments..");
        boolean pagNum = false;
        boolean rowsPerPage = false;
        String token = request.getHeader("token");
        String userName = request.getHeader(USER_NAME);
        String deviceUUID = request.getHeader("deviceUUID");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            userName = this.decodeBase64UTFString(userName);
        }
        if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
            return null;
        }
        try {
            List<UserDeviceCommentsElement> comments = this.managementService.getComments(cloudId, userName, deviceUUID, limit);
            if (comments != null && comments.size() > 0) {
                logger.debug("size of audit list: " + comments.size());
                modelAndView.addObject(comments);
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"versions/{versionNumber}/clouds/{cloudName}/comments/save"}, method={RequestMethod.POST})
    public void saveAllComments(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody UserDeviceComments userDeviceComments) {
        String userName;
        String cloudName = cloudName1;
        logger.debug("save all the comments..");
        boolean pagNum = false;
        boolean rowsPerPage = false;
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token, response, userName = null)) {
            return;
        }
        AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
        if (authorizationTokens != null) {
            userName = authorizationTokens.getUser().getUserName();
        }
        try {
            if (userDeviceComments != null) {
                userDeviceComments.setActionBy(userName);
            }
            this.managementService.saveComments(cloudId, userDeviceComments);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error(BASE_EXCEPTION + e.getMessage());
            response.setStatus(500);
        }
    }

    private boolean isSMBLicenseEnabled(List<CloudCustomisableDetails> licenseDetails) {
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"SMB License Enabled".equalsIgnoreCase(license.getName())) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/cloud/{cloudName}/discoverUsers/"}, method={RequestMethod.GET})
    public ModelAndView createLatestSites(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView("jsonview");
        String productType = request.getHeader("productType");
        logger.debug(".....start of /cloud/{}/discoverUsers/ ... {}", (Object)cloudName, (Object)productType);
        try {
            GraphServiceClient<Request> graphClient;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            GraphClientProvider provider = new GraphClientProvider(cl.getCloud().getCloudId(), this.registry);
            ArrayList allUsers = new ArrayList();
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            try {
                graphClient = provider.createGraphClient();
            }
            catch (AzureException | IllegalArgumentException ex) {
                MSAppSetting msAppSetting = this.managementService.getMSAppSettingsDetails(cl.getCloud().getCloudId());
                if (msAppSetting != null) {
                    this.registry.get(cloudId).setMSClientId(msAppSetting.getClientId());
                    this.registry.get(cloudId).setMSClientSecret(msAppSetting.getClientSecretKey());
                    this.registry.get(cloudId).setMSTenantId(msAppSetting.getTenantId());
                    this.registry.get(cloudId).setMSSharePointUrl(msAppSetting.getClientTokenURL());
                }
                provider = new GraphClientProvider(cl.getCloud().getCloudId(), this.registry);
                graphClient = provider.createGraphClient();
            }
            UserCollectionPage page = (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(new Option[0])).get();
            while (page != null) {
                allUsers.addAll(page.getCurrentPage());
                UserCollectionRequestBuilder next = (UserCollectionRequestBuilder)page.getNextPage();
                page = next == null ? null : (UserCollectionPage)((UserCollectionRequest)next.buildRequest(new Option[0])).get();
            }
            logger.debug("...after iteration.... found {} users", (Object)allUsers.size());
            List<String> types = List.of(Device.TYPE.ONEDRIVE.name(), Device.TYPE.OUTLOOK.name());
            if (!org.springframework.util.StringUtils.isEmpty((Object)productType)) {
                if ("ODB".equalsIgnoreCase(productType)) {
                    types = List.of(Device.TYPE.ONEDRIVE.name());
                } else if ("Exchange".equalsIgnoreCase(productType)) {
                    types = List.of(Device.TYPE.OUTLOOK.name());
                }
            }
            Iterator<String> iterator = types.iterator();
            while (iterator.hasNext()) {
                Set existingUserSet;
                String type;
                String typeFinal = type = iterator.next();
                List<com.parablu.pcbd.domain.User> existingUsers = this.managementService.getExistingGraphUsers(cloudId, typeFinal);
                Set existingUserSetFinal = existingUserSet = existingUsers.stream().map(com.parablu.pcbd.domain.User::getUserName).collect(Collectors.toSet());
                GraphServiceClient<Request> graphClientFinal = graphClient;
                ExecutorService executorService = Executors.newFixedThreadPool(10);
                ArrayList futures = new ArrayList();
                Iterator iterator2 = allUsers.iterator();
                while (iterator2.hasNext()) {
                    User user;
                    User graphUserFinal = user = (User)iterator2.next();
                    futures.add(executorService.submit(() -> {
                        block14: {
                            try {
                                String upn = graphUserFinal.userPrincipalName;
                                UserElement userObj = this.managementService.getUserByUserNameOrEmail(cloud, upn);
                                boolean userAllowed = true;
                                if (userObj != null) {
                                    if (!userObj.isActive()) {
                                        userAllowed = false;
                                    }
                                    if (Device.TYPE.ONEDRIVE.name().equals(typeFinal) && userObj.isOnedriveBkpEnabled()) {
                                        userAllowed = false;
                                    }
                                    if (Device.TYPE.OUTLOOK.name().equals(typeFinal) && userObj.isExchangeBkpEnabled()) {
                                        userAllowed = false;
                                    }
                                }
                                if (existingUserSetFinal.contains(upn) || !userAllowed) break block14;
                                com.parablu.pcbd.domain.User newUser = new com.parablu.pcbd.domain.User();
                                newUser.setUserName(upn);
                                newUser.setUserNameLowerCase(upn.toLowerCase());
                                newUser.setDisplayName(graphUserFinal.displayName);
                                newUser.setAzureUniqueId(graphUserFinal.id);
                                newUser.setEmailId(graphUserFinal.mail);
                                boolean oneDriveEnabled = false;
                                boolean exchangeEnabled = false;
                                if (Device.TYPE.ONEDRIVE.name().equals(typeFinal)) {
                                    try {
                                        graphClientFinal.users(graphUserFinal.id).drive().buildRequest(new Option[0]).get();
                                        oneDriveEnabled = true;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (Device.TYPE.OUTLOOK.name().equals(typeFinal)) {
                                    try {
                                        ((MailFolderDeltaCollectionRequest)graphClientFinal.users(graphUserFinal.id).mailFolders().delta().buildRequest(new Option[0])).get();
                                        exchangeEnabled = true;
                                    }
                                    catch (GraphServiceException e) {
                                        exchangeEnabled = false;
                                    }
                                    catch (ClientException e) {
                                        exchangeEnabled = false;
                                    }
                                }
                                if (Device.TYPE.ONEDRIVE.name().equals(typeFinal) && !oneDriveEnabled || Device.TYPE.OUTLOOK.name().equals(typeFinal) && !exchangeEnabled) {
                                    return;
                                }
                                long now = System.currentTimeMillis();
                                newUser.setActive(true);
                                newUser.setBackupEnabled(true);
                                newUser.setCreatedTimestamp(String.valueOf(now));
                                newUser.setLastModifiedTimestamp(String.valueOf(now));
                                this.managementService.createGraphUser(cloudId, newUser, typeFinal);
                            }
                            catch (Exception ex) {
                                logger.error("Error processing user: " + graphUserFinal.userPrincipalName, (Throwable)ex);
                            }
                        }
                    }));
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        logger.error("Thread execution error", (Throwable)e);
                    }
                }
                executorService.shutdown();
            }
            response.setStatus(200);
            if ("ODB".equalsIgnoreCase(productType)) {
                productType = Device.TYPE.ONEDRIVE.name();
            } else if ("Exchange".equalsIgnoreCase(productType)) {
                productType = Device.TYPE.OUTLOOK.name();
            }
            List<com.parablu.pcbd.domain.User> resultUsers = this.managementService.getExistingGraphUsers(cloud.getCloudId(), productType);
            List userNames = resultUsers.stream().map(com.parablu.pcbd.domain.User::getUserName).collect(Collectors.toList());
            SiteElement siteElement = new SiteElement();
            siteElement.setDiscoveredSites(userNames);
            modelAndView.addObject((Object)siteElement);
        }
        catch (Exception e) {
            logger.error("...unable to get folders....", (Throwable)e);
            response.setStatus(500);
        }
        logger.debug(".....end of /cloud/{}/discoverUsers/ ... {}", (Object)cloudName, (Object)productType);
        return modelAndView;
    }

    public static List<UserElement> filterUsersWithProtectionTimes(List<UserElement> allUsers) {
        return allUsers.stream().filter(user -> user.getMsEXProtectionTime() > 0L || user.getMsODBProtectionTime() > 0L || user.getMsSPProtectionTime() > 0L).collect(Collectors.toList());
    }

    @RequestMapping(value={"cloud/{cloudName}/user/{userName}/recoveryKey"}, method={RequestMethod.GET})
    public void getSecurityRecoveryKey(@PathVariable(value="cloudName") String cloudName1, @PathVariable(value="userName") String userName, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling getSecurityRecoveryKey...:" + userName);
        try {
            com.parablu.pcbd.domain.User currentUser;
            String token;
            if (!org.springframework.util.StringUtils.hasText((String)userName)) {
                throw new BaseException(INVALID_REQUEST);
            }
            userName = this.decodeBase64UTFString(userName);
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            Cloud cloud = cl.getCloud();
            int cloudId = cloud.getCloudId();
            if (!this.performAuthorization(cloudId, cloudName = cloud.getCloudName(), token = request.getHeader("token"), currentUser = new com.parablu.pcbd.domain.User(), response, userName)) {
                return;
            }
            UserElement ue = this.getUserElement(userName, cloud);
            response.setHeader("securityRecoveryKey", ue.getSecurityRecoveryKey());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
        }
    }
}

