/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.pcbd.domain.TenantConsentStatus;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Controller
public class TenantConsentStatusController
extends BaseController {
    private static Logger logger = LogManager.getLogger(TenantConsentStatusController.class);
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;

    @PostMapping(value={"versions/{versionNumber}/clouds/{cloudName}/tenant-consent/save"})
    public ResponseEntity<TenantConsentStatus> saveAllComments(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response, @RequestBody TenantConsentStatus status) {
        String userName;
        String token;
        logger.debug("....start of versions/{versionNumber}/clouds/{cloudName}/tenant-consent/save ....");
        String cloudName = cloudName1;
        logger.debug(request.getParameter("userPrincipalName") + "....start of versions/{versionNumber}/clouds/{cloudName}/tenant-consent/save ...." + request.getHeader("userPrincipalName"));
        String m365userPrincipalName = request.getHeader("m365userPrincipalName");
        String ewsuserPrincipalName = request.getHeader("ewsuserPrincipalName");
        String loggedInUserName = request.getHeader("loggedInUserName");
        if (!StringUtils.isEmpty((CharSequence)m365userPrincipalName)) {
            m365userPrincipalName = this.decodeBase64UTFString(m365userPrincipalName);
        }
        if (!StringUtils.isEmpty((CharSequence)ewsuserPrincipalName)) {
            ewsuserPrincipalName = this.decodeBase64UTFString(ewsuserPrincipalName);
        }
        loggedInUserName = this.decodeBase64UTFString(loggedInUserName);
        logger.debug(ewsuserPrincipalName + "...ewsuserPrincipalName and loggedinuser...." + loggedInUserName);
        logger.debug(m365userPrincipalName + "...m365userPrincipalName and loggedinuser...." + loggedInUserName);
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response, userName = request.getHeader("userName"))) {
            return null;
        }
        TenantConsentStatus saved = this.managementService.saveTenantStatus(cloudId, status);
        if (!StringUtils.isEmpty((CharSequence)m365userPrincipalName)) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " Read Consent given by user " + m365userPrincipalName, loggedInUserName + " ", "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
        }
        if (!StringUtils.isEmpty((CharSequence)ewsuserPrincipalName)) {
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, " Write Consent given by user " + ewsuserPrincipalName, loggedInUserName + " ", "", "", System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
        }
        logger.debug("....end of versions/{versionNumber}/clouds/{cloudName}/tenant-consent/save ....");
        return ResponseEntity.ok((Object)saved);
    }

    @GetMapping(value={"versions/{versionNumber}/clouds/{cloudName}/tenant-consent/get"})
    public ResponseEntity<TenantConsentStatus> get(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String userName;
        String token;
        String cloudName = cloudName1;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudName = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response, userName = request.getHeader("userName"))) {
            return null;
        }
        boolean deviceRegistered = this.managementService.isDeviceRegistered(cloudId);
        TenantConsentStatus result = this.managementService.findTenantConsentStatus(cloudId);
        if (deviceRegistered) {
            result.setAssetsConfigured(true);
        }
        return ResponseEntity.ok((Object)result);
    }
}

