/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.SIEMSettingsService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.element.ErrorElement;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.SIEMCredentialElement;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.SIEMCredentials;
import com.parablu.pcbd.domain.User;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SIEMController
extends BaseController {
    private static Logger logger = LogManager.getLogger(SIEMController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private SIEMSettingsService siemSettingsService;
    @Autowired
    private AuditHistoryDao auditHistoryDao;

    @RequestMapping(value={"{version}/cloud/{cloudName}/siemCredentials/save"}, method={RequestMethod.POST})
    public void saveSIEMCredentials(@PathVariable(value="cloudName") String cloudName, @RequestBody SIEMCredentialElement siemCredentialElement, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Saving SIEM cloud credentials for cloud : " + siemCredentialElement.getCloudName());
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, currentUser, response, userName)) {
                return;
            }
            SIEMCredentials siemCredentials = new SIEMCredentials();
            BeanUtils.copyProperties((Object)siemCredentialElement, (Object)siemCredentials);
            String provider = this.getProvider(siemCredentials.getCloudName());
            siemCredentials.setProvider(provider);
            this.siemSettingsService.saveSIEMCredentials(cloudId, siemCredentials);
            this.saveStatisticToDatabase(cloudId, cloudName, "saved", currentUser.getUserName(), " SIEM Credentials for cloud: " + siemCredentialElement.getCloudName(), PCActionTypes.SIEM_CREDENTIALS_SAVE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Exception occurred while trying to save SIEM Credentials : " + e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
            response.setStatus(500);
        }
        logger.debug("End of calling save SIEM credentials");
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/siemCredentials/all"}, method={RequestMethod.GET})
    public ModelAndView getSIEMCredentials(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName, token, response, userName)) {
                return null;
            }
            SIEMCredentialElement siemCredentialElement = this.siemSettingsService.getSIEMCredentials();
            modelAndView.addObject((Object)siemCredentialElement);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Exception occurred while fetching the SIEM Credentials : " + e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
            ErrorElement err = this.createErrorElement(null, null);
            modelAndView.addObject((Object)err);
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"{version}/cloud/{cloudName}/siemCredentials/{id}"}, method={RequestMethod.DELETE})
    public void deleteSIEMCredentials(@PathVariable(value="cloudName") String cloudName, @PathVariable(value="id") String id, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Calling delete SIEM credentials");
        try {
            String cloudName1;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                response.setStatus(400);
                return;
            }
            User currentUser = new User();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String userName = request.getHeader("userName");
            if (StringUtils.isNotEmpty((CharSequence)userName)) {
                userName = this.decodeBase64UTFString(userName);
            }
            if (!this.performAuthorization(cloudId, cloudName1 = cl.getCloud().getCloudName(), token, currentUser, response, userName)) {
                return;
            }
            logger.debug("Deleting SIEM Credentials for ID : " + id);
            SIEMCredentialElement siemCredentialElement = this.siemSettingsService.getSIEMCredentials();
            if (this.siemSettingsService.deleteSIEMCredentialsFromDB(id)) {
                this.saveStatisticToDatabase(cloudId, cloudName, "deleted", currentUser.getUserName(), "SIEM Credentials: " + siemCredentialElement.getCloudName(), PCActionTypes.SIEM_CREDENTIALS_DELETE.getActionTypeValue());
                response.setStatus(200);
            } else {
                response.setStatus(404);
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while deleting SIEM Credentials" + e.getMessage());
            logger.error("Exception stack trace : ", (Throwable)e);
            response.setStatus(500);
        }
    }

    private String getProvider(String cloudName) {
        String provider = "";
        if ("azureblob".equalsIgnoreCase(cloudName)) {
            provider = "azureblob";
        } else if ("amazon".equalsIgnoreCase(cloudName)) {
            provider = "aws-s3";
        } else if ("ibmCloud".equalsIgnoreCase(cloudName)) {
            provider = "swift";
        } else if ("s3".equalsIgnoreCase(cloudName)) {
            provider = "s3";
        } else if ("b2".equalsIgnoreCase(cloudName)) {
            provider = "b2";
        } else if ("odb".equalsIgnoreCase(cloudName)) {
            provider = "odb";
        }
        return provider;
    }

    private void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, int actionType) {
        AuditHistory audit = this.auditHistoryDefaultValue(action, actionByUser, actionType);
        audit.setActionOnObject(actionOnUser);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    private AuditHistory auditHistoryDefaultValue(String action, String actionByUser, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setTimestamp(System.currentTimeMillis());
        audit.setActionUsingObject("Portal");
        audit.setActionType(actionType);
        return audit;
    }
}

