/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.b.zaf;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.b.zas;
import com.aspose.email.internal.b.zl;
import com.aspose.email.internal.m.zd;
import com.aspose.email.internal.m.zo;
import com.aspose.email.system.DateTime;
import com.aspose.email.system.IFormatProvider;
import com.aspose.email.system.Struct;
import com.aspose.email.system.TimeSpan;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.Exception;
import com.aspose.email.system.exceptions.FormatException;
import java.util.TimeZone;

public class DateTimeOffset
extends Struct<DateTimeOffset>
implements Comparable<DateTimeOffset> {
    public static DateTimeOffset MaxValue = new DateTimeOffset(DateTime.MaxValue.Clone(), TimeSpan.Zero.Clone());
    public static DateTimeOffset MinValue = new DateTimeOffset(DateTime.MinValue.Clone(), TimeSpan.Zero.Clone());
    private DateTime b = new DateTime();
    private TimeSpan c = new TimeSpan();

    public DateTimeOffset() {
    }

    public DateTimeOffset(DateTime dateTime) {
        dateTime.CloneTo(this.b);
        if (dateTime.getKind() == 1L) {
            TimeSpan.Zero.CloneTo(this.c);
        } else {
            zas.a(TimeZone.getDefault(), dateTime.Clone()).CloneTo(this.c);
        }
        if (DateTime.op_LessThan(this.getUtcDateTime(), DateTime.MinValue) || DateTime.op_GreaterThan(this.getUtcDateTime(), DateTime.MaxValue)) {
            throw new ArgumentOutOfRangeException("The UTC date and time that results from applying the offset is earlier than MinValue or later than MaxValue.");
        }
    }

    public DateTimeOffset(DateTime dateTime, TimeSpan offset) {
        if (dateTime.getKind() == 1L && !TimeSpan.equals(offset, TimeSpan.Zero)) {
            throw new ArgumentException("dateTime.Kind equals Utc and offset does not equal zero.");
        }
        if (dateTime.getKind() == 2L && !TimeSpan.equals(offset, zas.a(TimeZone.getDefault(), dateTime.Clone()))) {
            throw new ArgumentException("dateTime.Kind equals Local and offset does not equal the offset of the system's local time zone.");
        }
        if (offset.getTicks() % 600000000L != 0L) {
            throw new ArgumentException("offset is not specified in whole minutes.");
        }
        if (TimeSpan.op_LessThan(offset, new TimeSpan(-14, 0, 0)) || TimeSpan.op_GreaterThan(offset, new TimeSpan(14, 0, 0))) {
            throw new ArgumentOutOfRangeException("offset is less than -14 hours or greater than 14 hours.");
        }
        dateTime.CloneTo(this.b);
        offset.CloneTo(this.c);
        if (DateTime.op_LessThan(this.getUtcDateTime(), DateTime.MinValue) || DateTime.op_GreaterThan(this.getUtcDateTime(), DateTime.MaxValue)) {
            throw new ArgumentOutOfRangeException("The UtcDateTime property is earlier than MinValue or later than MaxValue.");
        }
    }

    public DateTimeOffset(long ticks, TimeSpan offset) {
        this(new DateTime(ticks), offset.Clone());
    }

    public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, TimeSpan offset) {
        this(new DateTime(year, month, day, hour, minute, second), offset.Clone());
    }

    public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeSpan offset) {
        this(new DateTime(year, month, day, hour, minute, second, millisecond), offset.Clone());
    }

    public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, zo calendar, TimeSpan offset) {
        this(new DateTime(year, month, day, hour, minute, second, millisecond, calendar), offset.Clone());
    }

    public DateTimeOffset add(TimeSpan timeSpan) {
        return new DateTimeOffset(this.b.add(timeSpan.Clone()).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addDays(double days) {
        return new DateTimeOffset(this.b.addDays(days).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addHours(double hours) {
        return new DateTimeOffset(this.b.addHours(hours).getTicks(), this.c.Clone());
    }

    public static DateTimeOffset op_Addition(DateTimeOffset dateTimeOffset, TimeSpan timeSpan) {
        return dateTimeOffset.add(timeSpan.Clone());
    }

    public DateTimeOffset addMilliseconds(double milliseconds) {
        return new DateTimeOffset(this.b.addMilliseconds(milliseconds).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addMinutes(double minutes) {
        return new DateTimeOffset(this.b.addMinutes(minutes).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addMonths(int months) {
        return new DateTimeOffset(this.b.addMonths(months).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addSeconds(double seconds) {
        return new DateTimeOffset(this.b.addSeconds(seconds).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addTicks(long ticks) {
        return new DateTimeOffset(this.b.addTicks(ticks).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addYears(int years) {
        return new DateTimeOffset(this.b.addYears(years).getTicks(), this.c.Clone());
    }

    public static int compare(DateTimeOffset first, DateTimeOffset second) {
        return first.compareTo(second.Clone());
    }

    @Override
    public int compareTo(DateTimeOffset other) {
        return this.getUtcDateTime().compareTo(other.getUtcDateTime().Clone());
    }

    public static boolean op_Equality(DateTimeOffset left, DateTimeOffset right) {
        return left.equals(right.Clone());
    }

    public boolean equals(DateTimeOffset other) {
        if (zaf.b(null, other)) {
            return false;
        }
        if (zaf.b(this, other)) {
            return true;
        }
        return DateTime.equals(this.getUtcDateTime(), other.getUtcDateTime());
    }

    public boolean equalsExact(DateTimeOffset other) {
        return DateTime.equals(this.b, other.b) && TimeSpan.equals(this.c, other.c);
    }

    public static DateTimeOffset fromFileTime(long fileTime) {
        if (fileTime < 0L || fileTime > MaxValue.getTicks()) {
            throw new ArgumentOutOfRangeException("fileTime is less than zero or greater than DateTimeOffset.MaxValue.Ticks.");
        }
        return new DateTimeOffset(DateTime.fromFileTime(fileTime).Clone(), zas.a(TimeZone.getDefault(), DateTime.fromFileTime(fileTime).Clone()).Clone());
    }

    public int hashCode() {
        return this.b.hashCode() ^ this.c.hashCode();
    }

    public static boolean op_GreaterThan(DateTimeOffset left, DateTimeOffset right) {
        return DateTime.op_GreaterThan(left.getUtcDateTime(), right.getUtcDateTime());
    }

    public static boolean op_GreaterThanOrEqual(DateTimeOffset left, DateTimeOffset right) {
        return DateTime.op_GreaterThanOrEqual(left.getUtcDateTime(), right.getUtcDateTime());
    }

    public static DateTimeOffset to_DateTimeOffset(DateTime dateTime) {
        return new DateTimeOffset(dateTime.Clone());
    }

    public static boolean op_Inequality(DateTimeOffset left, DateTimeOffset right) {
        return !DateTime.equals(left.getUtcDateTime(), right.getUtcDateTime());
    }

    public static boolean op_LessThan(DateTimeOffset left, DateTimeOffset right) {
        return DateTime.op_LessThan(left.getUtcDateTime(), right.getUtcDateTime());
    }

    public static boolean op_LessThanOrEqual(DateTimeOffset left, DateTimeOffset right) {
        return DateTime.op_LessThanOrEqual(left.getUtcDateTime(), right.getUtcDateTime());
    }

    public static DateTimeOffset parse(String input) {
        return DateTimeOffset.parse(input, null);
    }

    public static DateTimeOffset parse(String input, IFormatProvider formatProvider) {
        return DateTimeOffset.parse(input, formatProvider, 7);
    }

    public static DateTimeOffset parse(String input, IFormatProvider formatProvider, int styles) {
        if (input == null) {
            throw new ArgumentNullException("input");
        }
        DateTime dateTime = new DateTime();
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        RuntimeException runtimeException = null;
        try {
            DateTime[] dateTimeArray = new DateTime[]{dateTime};
            DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
            RuntimeException[] runtimeExceptionArray = new RuntimeException[]{runtimeException};
            boolean bl = !DateTime.a(input, formatProvider, styles, dateTimeArray, dateTimeOffsetArray, true, runtimeExceptionArray);
            dateTimeArray[0].CloneTo(dateTime);
            dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
            runtimeException = runtimeExceptionArray[0];
            if (bl) {
                throw runtimeException;
            }
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            throw new FormatException("The UTC representation falls outside the 1-9999 year range", argumentOutOfRangeException);
        }
        if (dateTime.getTicks() != 0L && dateTimeOffset.getTicks() == 0L) {
            throw new FormatException("The UTC representation falls outside the 1-9999 year range");
        }
        return dateTimeOffset;
    }

    public static DateTimeOffset parseExact(String input, String format, IFormatProvider formatProvider) {
        return DateTimeOffset.parseExact(input, format, formatProvider, 32);
    }

    public static DateTimeOffset parseExact(String input, String format, IFormatProvider formatProvider, int styles) {
        if (format == null) {
            throw new ArgumentNullException("format");
        }
        if (zar.e(format, "")) {
            throw new FormatException("format is an empty string");
        }
        return DateTimeOffset.parseExact(input, new String[]{format}, formatProvider, styles);
    }

    public static DateTimeOffset parseExact(String input, String[] formats, IFormatProvider formatProvider, int styles) {
        if (input == null) {
            throw new ArgumentNullException("input");
        }
        if (zar.e(input, "")) {
            throw new FormatException("input is an empty string");
        }
        if (formats == null) {
            throw new ArgumentNullException("formats");
        }
        if (formats.length == 0) {
            throw new FormatException("Invalid format specifier");
        }
        if ((styles & 0x20) != 0 && (styles & 0x40) != 0) {
            throw new ArgumentException("styles parameter contains incompatible flags");
        }
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
        boolean bl = !DateTimeOffset.a(input, formats, formatProvider, styles, dateTimeOffsetArray);
        dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
        if (bl) {
            throw new FormatException("Invalid format string");
        }
        return dateTimeOffset;
    }

    private static boolean a(String string, String[] stringArray, IFormatProvider iFormatProvider, int n, DateTimeOffset[] dateTimeOffsetArray) {
        for (String string2 : stringArray) {
            if (string2 == null || zar.e(string2, "")) {
                throw new FormatException("Invalid format string");
            }
            DateTimeOffset dateTimeOffset = new DateTimeOffset();
            DateTimeOffset[] dateTimeOffsetArray2 = new DateTimeOffset[]{dateTimeOffset};
            boolean bl = DateTimeOffset.a(string, string2, false, dateTimeOffsetArray2, iFormatProvider, n);
            dateTimeOffsetArray2[0].CloneTo(dateTimeOffset);
            if (!bl) continue;
            dateTimeOffset.CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        MinValue.CloneTo(dateTimeOffsetArray[0]);
        return false;
    }

    private static boolean a(String string, String string2, boolean bl, DateTimeOffset[] dateTimeOffsetArray, IFormatProvider iFormatProvider, int n) {
        int n2;
        zd zd2 = zd.a(iFormatProvider);
        if ((n & 1) != 0) {
            string2 = zar.d(string2, null);
            string = zar.d(string, null);
        }
        if ((n & 2) != 0) {
            string2 = zar.e(string2, null);
            string = zar.e(string, null);
        }
        boolean bl2 = false;
        if ((n & 4) != 0) {
            bl2 = true;
        }
        MinValue.CloneTo(dateTimeOffsetArray[0]);
        boolean bl3 = false;
        boolean bl4 = false;
        if (string2.length() == 1) {
            boolean[] blArray = new boolean[]{bl3};
            boolean[] blArray2 = new boolean[]{bl4};
            string2 = zl.a(string2.charAt(0), zd2, blArray, blArray2, true);
            bl3 = blArray[0];
            bl4 = blArray2[0];
            if (string2 == null) {
                return false;
            }
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        double d = -1.0;
        int n10 = -1;
        TimeSpan timeSpan = TimeSpan.MinValue.Clone();
        int n11 = 0;
        block20: for (int i = 0; i < string2.length(); i += n2) {
            char c = string2.charAt(i);
            switch (c) {
                case 'd': {
                    n2 = zl.a(string2, i, c);
                    if (n5 != -1 || n2 > 4) {
                        return false;
                    }
                    if (n2 <= 2) {
                        int[] nArray = new int[]{n5};
                        n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                        n5 = nArray[0];
                        continue block20;
                    }
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, n2 == 3 ? zd2.b() : zd2.f(), bl2, nArray);
                    n10 = nArray[0];
                    continue block20;
                }
                case 'f': {
                    n2 = zl.a(string2, i, c);
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, n2, true, bl2, nArray);
                    n10 = nArray[0];
                    if (d >= 0.0 || n2 > 7 || n10 == -1) {
                        return false;
                    }
                    d = (double)n10 / Math.pow(10.0, n2);
                    continue block20;
                }
                case 'F': {
                    n2 = zl.a(string2, i, c);
                    int n12 = 0;
                    int[] nArray = new int[]{n10};
                    int[] nArray2 = new int[]{n12};
                    int n13 = DateTimeOffset.a(string, n11, n2, true, bl2, nArray, nArray2);
                    n10 = nArray[0];
                    n12 = nArray2[0];
                    if (n10 == -1) {
                        nArray[0] = n10;
                        n11 += DateTimeOffset.a(string, n11, n12, true, bl2, nArray);
                        n10 = nArray[0];
                    } else {
                        n11 += n13;
                    }
                    if (d >= 0.0 || n2 > 7 || n10 == -1) {
                        return false;
                    }
                    d = (double)n10 / Math.pow(10.0, n12);
                    continue block20;
                }
                case 'h': {
                    n2 = zl.a(string2, i, c);
                    if (n7 != -1 || n2 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                    n10 = nArray[0];
                    if (n10 == -1) {
                        return false;
                    }
                    if (n6 == -1) {
                        n6 = n10;
                        continue block20;
                    }
                    n7 = n6 + n10;
                    continue block20;
                }
                case 'H': {
                    n2 = zl.a(string2, i, c);
                    if (n7 != -1 || n2 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n7};
                    n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                    n7 = nArray[0];
                    continue block20;
                }
                case 'm': {
                    n2 = zl.a(string2, i, c);
                    if (n8 != -1 || n2 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n8};
                    n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                    n8 = nArray[0];
                    continue block20;
                }
                case 'M': {
                    n2 = zl.a(string2, i, c);
                    if (n4 != -1 || n2 > 4) {
                        return false;
                    }
                    if (n2 <= 2) {
                        int[] nArray = new int[]{n4};
                        n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                        n4 = nArray[0];
                        continue block20;
                    }
                    int[] nArray = new int[]{n4};
                    n11 += DateTimeOffset.a(string, n11, n2 == 3 ? zd2.d() : zd2.h(), bl2, nArray);
                    n4 = nArray[0];
                    ++n4;
                    continue block20;
                }
                case 's': {
                    n2 = zl.a(string2, i, c);
                    if (n9 != -1 || n2 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n9};
                    n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                    n9 = nArray[0];
                    continue block20;
                }
                case 't': {
                    String[] stringArray;
                    n2 = zl.a(string2, i, c);
                    if (n7 != -1 || n2 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n10};
                    if (n2 == 1) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = zar.a(zd2.m().charAt(0), 1);
                        stringArray = stringArray2;
                        stringArray2[1] = zar.a(zd2.n().charAt(0), 0);
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = zd2.m();
                        stringArray = stringArray3;
                        stringArray3[1] = zd2.n();
                    }
                    n11 += DateTimeOffset.a(string, n11, stringArray, bl2, nArray);
                    n10 = nArray[0];
                    if (n10 == -1) {
                        return false;
                    }
                    if (n6 == -1) {
                        n6 = n10 * 12;
                        continue block20;
                    }
                    n7 = n6 + n10 * 12;
                    continue block20;
                }
                case 'y': {
                    if (n3 != -1) {
                        return false;
                    }
                    n2 = zl.a(string2, i, c);
                    if (n2 <= 2) {
                        int[] nArray = new int[]{n3};
                        n11 += DateTimeOffset.a(string, n11, 2, n2 == 2, bl2, nArray);
                        n3 = nArray[0];
                        if (n3 == -1) continue block20;
                        n3 = zd2.A().b(n3);
                        continue block20;
                    }
                    if (n2 <= 4) {
                        int n14 = 0;
                        int[] nArray = new int[]{n3};
                        int[] nArray3 = new int[]{n14};
                        n11 += DateTimeOffset.a(string, n11, 5, false, bl2, nArray, nArray3);
                        n3 = nArray[0];
                        n14 = nArray3[0];
                        if (n14 >= n2 && (n14 <= n2 || !((double)n3 / Math.pow(10.0, n14 - 1) < 1.0))) continue block20;
                        return false;
                    }
                    int[] nArray = new int[]{n3};
                    n11 += DateTimeOffset.a(string, n11, n2, true, bl2, nArray);
                    n3 = nArray[0];
                    continue block20;
                }
                case 'K': {
                    n2 = 1;
                    int n15 = 0;
                    int n16 = 0;
                    int n17 = 0;
                    n10 = 0;
                    int[] nArray = new int[]{n17};
                    n11 += DateTimeOffset.a(string, n11, new String[]{"-", "+"}, bl2, nArray);
                    n17 = nArray[0];
                    int[] nArray4 = new int[]{n15};
                    n11 += DateTimeOffset.a(string, n11, 4, false, false, nArray4);
                    n15 = nArray4[0];
                    if (n15 == -1 || n16 == -1 || n17 == -1) {
                        return false;
                    }
                    if (n17 == 0) {
                        n17 = -1;
                    }
                    timeSpan = new TimeSpan(n17 * n15, n17 * n16, 0);
                    continue block20;
                }
                case 'z': {
                    n2 = zl.a(string2, i, c);
                    if (!TimeSpan.equals(timeSpan, TimeSpan.MinValue) || n2 > 3) {
                        return false;
                    }
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    n10 = 0;
                    int[] nArray = new int[]{n20};
                    n11 += DateTimeOffset.a(string, n11, new String[]{"-", "+"}, bl2, nArray);
                    n20 = nArray[0];
                    int[] nArray4 = new int[]{n18};
                    n11 += DateTimeOffset.a(string, n11, 2, n2 != 1, false, nArray4);
                    n18 = nArray4[0];
                    if (n2 == 3) {
                        int[] nArray5 = new int[]{n10};
                        n11 += DateTimeOffset.a(string, n11, new String[]{zd2.p()}, false, nArray5);
                        n10 = nArray5[0];
                        int[] nArray6 = new int[]{n19};
                        n11 += DateTimeOffset.a(string, n11, 2, true, false, nArray6);
                        n19 = nArray6[0];
                    }
                    if (n18 == -1 || n19 == -1 || n20 == -1) {
                        return false;
                    }
                    if (n20 == 0) {
                        n20 = -1;
                    }
                    timeSpan = new TimeSpan(n20 * n18, n20 * n19, 0);
                    continue block20;
                }
                case ':': {
                    n2 = 1;
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, new String[]{zd2.p()}, false, nArray);
                    n10 = nArray[0];
                    if (n10 != -1) continue block20;
                    return false;
                }
                case '/': {
                    n2 = 1;
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, new String[]{zd2.o()}, false, nArray);
                    n10 = nArray[0];
                    if (n10 != -1) continue block20;
                    return false;
                }
                case '%': {
                    n2 = 1;
                    if (i == 0) continue block20;
                    return false;
                }
                case ' ': {
                    n2 = 1;
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, ' ', false, nArray);
                    n10 = nArray[0];
                    if (n10 != -1) continue block20;
                    return false;
                }
                case '\\': {
                    n2 = 2;
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, string2.charAt(i + 1), bl2, nArray);
                    n10 = nArray[0];
                    if (n10 != -1) continue block20;
                    return false;
                }
                case '\"': 
                case '\'': {
                    n2 = 1;
                    while (n11 < string.length()) {
                        char c2 = string2.charAt(i + n2);
                        ++n2;
                        if (c2 == string2.charAt(i)) {
                            if (!bl3 || n2 != 5 || string.charAt(n11 - 3) != 'G' || string.charAt(n11 - 2) != 'M' || string.charAt(n11 - 1) != 'T') continue block20;
                            TimeSpan.Zero.CloneTo(timeSpan);
                            continue block20;
                        }
                        if (c2 == string.charAt(n11++)) continue;
                        return false;
                    }
                    continue block20;
                }
                default: {
                    n2 = 1;
                    int[] nArray = new int[]{n10};
                    n11 += DateTimeOffset.a(string, n11, string2.charAt(i), bl2, nArray);
                    n10 = nArray[0];
                    if (n10 != -1) continue block20;
                    return false;
                }
            }
        }
        if (TimeSpan.equals(timeSpan, TimeSpan.MinValue)) {
            if ((n & 0x40) != 0) {
                TimeSpan.Zero.CloneTo(timeSpan);
            } else if ((n & 0x20) != 0) {
                TimeSpan timeSpan2 = timeSpan = bl4 ? TimeSpan.Zero.Clone() : zas.a(TimeZone.getDefault(), DateTime.getNow().Clone()).Clone();
            }
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (n3 > 0 && n4 > 0 && n5 > 0) {
            dateTimeOffsetArray[0] = new DateTimeOffset(n3, n4, n5, n7, n8, n9, 0, timeSpan.Clone());
            if (bl3) {
                // empty if block
            }
            dateTimeOffsetArray[0].addSeconds(d).CloneTo(dateTimeOffsetArray[0]);
            if ((n & 0x10) != 0) {
                dateTimeOffsetArray[0].toUniversalTime().CloneTo(dateTimeOffsetArray[0]);
            }
            return true;
        }
        return false;
    }

    private static int a(String string, int n, int n2, boolean bl, boolean bl2, int[] nArray) {
        int n3 = 0;
        int[] nArray2 = new int[]{n3};
        return DateTimeOffset.a(string, n, n2, bl, bl2, nArray, nArray2);
    }

    private static int a(String string, int n, int n2, boolean bl, boolean bl2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        nArray2[0] = 0;
        nArray[0] = 0;
        while (bl2 && n < string.length() && string.charAt(n) == ' ') {
            ++n3;
            ++n;
        }
        while (n < string.length() && Character.isDigit(string.charAt(n)) && n2 > 0) {
            nArray[0] = 10 * nArray[0] + ((byte)(string.charAt(n) - 48) & 0xFF);
            ++n;
            ++n3;
            nArray2[0] = nArray2[0] + 1;
            --n2;
        }
        if (bl && n2 > 0) {
            nArray[0] = -1;
        }
        if (nArray2[0] == 0) {
            nArray[0] = -1;
        }
        return n3;
    }

    private static int a(String string, int n, String[] stringArray, boolean bl, int[] nArray) {
        int n2 = 0;
        nArray[0] = -1;
        while (bl && n < string.length() && string.charAt(n) == ' ') {
            ++n2;
            ++n;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.substring(n).startsWith(stringArray[i])) continue;
            nArray[0] = i;
            break;
        }
        if (nArray[0] >= 0) {
            n2 += stringArray[nArray[0]].length();
        }
        return n2;
    }

    private static int a(String string, int n, char c, boolean bl, int[] nArray) {
        int n2 = 0;
        nArray[0] = -1;
        while (bl && n < string.length() && string.charAt(n) == ' ') {
            ++n;
            ++n2;
        }
        if (n < string.length() && string.charAt(n) == c) {
            nArray[0] = c;
            ++n2;
        }
        return n2;
    }

    public TimeSpan subtract(DateTimeOffset value) {
        return DateTime.op_Subtraction(this.getUtcDateTime(), value.getUtcDateTime());
    }

    public DateTimeOffset subtract(TimeSpan value) {
        TimeSpan timeSpan = new TimeSpan(-value.getTicks());
        return this.add(timeSpan.Clone());
    }

    public static TimeSpan op_Subtraction(DateTimeOffset left, DateTimeOffset right) {
        return left.subtract(right.Clone());
    }

    public static DateTimeOffset op_Subtraction(DateTimeOffset dateTimeOffset, TimeSpan timeSpan) {
        return dateTimeOffset.subtract(timeSpan.Clone());
    }

    public long toFileTime() {
        return this.getUtcDateTime().toFileTime();
    }

    public DateTimeOffset toLocalTime() {
        return new DateTimeOffset(this.getUtcDateTime().toLocalTime().Clone(), zas.a(TimeZone.getDefault(), this.getUtcDateTime().toLocalTime().Clone()).Clone());
    }

    public DateTimeOffset toOffset(TimeSpan offset) {
        return new DateTimeOffset(DateTime.op_Addition(DateTime.op_Subtraction(this.b, this.c), offset).Clone(), offset.Clone());
    }

    public String toString() {
        return this.toString(null, null);
    }

    public String toString(IFormatProvider formatProvider) {
        return this.toString(null, formatProvider);
    }

    public String toString(String format) {
        return this.toString(format, null);
    }

    public String toString(String format, IFormatProvider formatProvider) {
        boolean bl;
        zd zd2 = zd.a(formatProvider);
        boolean bl2 = bl = formatProvider == null;
        if (format == null || zar.e(format, "")) {
            bl = false;
            format = zar.a(new String[]{zd2.r(), " ", zd2.t()});
            if (format.indexOf("zzz") < 0) {
                format = format.indexOf("zz") > 0 ? format.replace("zz", "zzz") : (format.indexOf("z") > 0 ? format.replace("z", "zzz") : format + " zzz");
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (format.length() == 1) {
            bl = false;
            char c = format.charAt(0);
            try {
                boolean[] blArray = new boolean[]{bl3};
                boolean[] blArray2 = new boolean[]{bl4};
                format = zl.b(c, zd2, blArray, blArray2, true);
                bl3 = blArray[0];
                bl4 = blArray2[0];
            }
            catch (Exception exception) {
                format = null;
            }
            if (format == null) {
                throw new FormatException("format is not one of the format specifier characters defined for DateTimeFormatInfo");
            }
        }
        return bl3 ? zl.a(this.getUtcDateTime().Clone(), TimeSpan.Zero.Clone(), format, zd2, bl) : zl.a(this.getDateTime().Clone(), this.getOffset().Clone(), format, zd2, bl);
    }

    public DateTimeOffset toUniversalTime() {
        return new DateTimeOffset(this.getUtcDateTime().Clone(), TimeSpan.Zero.Clone());
    }

    public static boolean tryParse(String input, DateTimeOffset[] result) {
        try {
            DateTimeOffset.parse(input).CloneTo(result[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(result[0]);
            return false;
        }
    }

    public static boolean tryParse(String input, IFormatProvider formatProvider, int styles, DateTimeOffset[] result) {
        try {
            DateTimeOffset.parse(input, formatProvider, styles).CloneTo(result[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(result[0]);
            return false;
        }
    }

    public static boolean tryParseExact(String input, String format, IFormatProvider formatProvider, int styles, DateTimeOffset[] result) {
        try {
            DateTimeOffset.parseExact(input, format, formatProvider, styles).CloneTo(result[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(result[0]);
            return false;
        }
    }

    public static boolean tryParseExact(String input, String[] formats, IFormatProvider formatProvider, int styles, DateTimeOffset[] result) {
        try {
            DateTimeOffset.parseExact(input, formats, formatProvider, styles).CloneTo(result[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(result[0]);
            return false;
        }
    }

    public DateTime getDate() {
        return DateTime.specifyKind(this.b.getDate().Clone(), 0L);
    }

    public DateTime getDateTime() {
        return DateTime.specifyKind(this.b.Clone(), 0L);
    }

    public int getDay() {
        return this.b.getDay();
    }

    public int getDayOfWeek() {
        return this.b.getDayOfWeek();
    }

    public int getDayOfYear() {
        return this.b.getDayOfYear();
    }

    public int getHour() {
        return this.b.getHour();
    }

    public DateTime getLocalDateTime() {
        return this.getUtcDateTime().toLocalTime();
    }

    public int getMillisecond() {
        return this.b.getMillisecond();
    }

    public int getMinute() {
        return this.b.getMinute();
    }

    public int getMonth() {
        return this.b.getMonth();
    }

    public static DateTimeOffset getNow() {
        return new DateTimeOffset(DateTime.getNow().Clone());
    }

    public TimeSpan getOffset() {
        return this.c;
    }

    public int getSecond() {
        return this.b.getSecond();
    }

    public long getTicks() {
        return this.b.getTicks();
    }

    public TimeSpan getTimeOfDay() {
        return this.b.getTimeOfDay();
    }

    public DateTime getUtcDateTime() {
        return DateTime.specifyKind(DateTime.op_Subtraction(this.b, this.c).Clone(), 1L);
    }

    public static DateTimeOffset getUtcNow() {
        return new DateTimeOffset(DateTime.getUtcNow().Clone());
    }

    public long getUtcTicks() {
        return this.getUtcDateTime().getTicks();
    }

    public int getYear() {
        return this.b.getYear();
    }

    @Override
    public void CloneTo(DateTimeOffset that) {
        this.b.CloneTo(that.b);
        this.c.CloneTo(that.c);
    }

    @Override
    public DateTimeOffset Clone() {
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        this.CloneTo(dateTimeOffset);
        return dateTimeOffset;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(DateTimeOffset dateTimeOffset) {
        return zaf.a(dateTimeOffset.b, this.b) && zaf.a(dateTimeOffset.c, this.c);
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (zaf.b(null, obj)) {
            return false;
        }
        if (zaf.b(this, obj)) {
            return true;
        }
        if (!(obj instanceof DateTimeOffset)) {
            return false;
        }
        return this.a((DateTimeOffset)obj);
    }

    public static boolean equals(DateTimeOffset obj1, DateTimeOffset obj2) {
        return obj1.equals(obj2);
    }
}

