/*
 * Decompiled with CFR 0.152.
 */
package pst;

import com.aspose.email.FolderInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import pst.MapiMessageCollection;

public class FileWalker1
implements FileVisitor<Path> {
    private AtomicInteger addedFiles;
    private FolderInfo rootFolder;
    private Map<Path, FolderInfo> folderStack;
    private Map<String, Queue<String>> queueStack;
    private File parent;

    public FileWalker1(AtomicInteger addedFiles, FolderInfo rootFolder, File parent) {
        this.addedFiles = addedFiles;
        this.rootFolder = rootFolder;
        this.parent = parent;
        this.folderStack = new HashMap<Path, FolderInfo>();
        this.queueStack = new HashMap<String, Queue<String>>();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        try {
            Queue<String> queue = this.queueStack.get(dir.toFile().getAbsolutePath());
            FolderInfo subFolder = this.folderStack.get(dir);
            if (queue == null || subFolder == null) {
                return FileVisitResult.CONTINUE;
            }
            System.out.println("adding files for folder:" + subFolder.getDisplayName() + "..queue size:" + queue.size());
            System.out.println("total number of files added:" + this.addedFiles.get());
            subFolder.addMessages(new MapiMessageCollection(queue));
            this.queueStack.remove(dir.toFile().getAbsolutePath());
            this.folderStack.remove(dir);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error adding mails into folder bulk:" + e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        File currentDir = dir.toFile();
        try {
            if (currentDir.getName().equalsIgnoreCase("merge") || currentDir.getName().equalsIgnoreCase("decrypted")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (currentDir.getName().equalsIgnoreCase(this.parent.getName())) {
                return FileVisitResult.CONTINUE;
            }
            System.out.println("FOLDER TO BE PROCESSED:" + currentDir.getAbsolutePath());
            String subFolderPath = currentDir.getAbsolutePath().substring(this.parent.getAbsolutePath().length() + 1);
            List<String> subFolders = Arrays.asList(subFolderPath.split("/"));
            FolderInfo info = this.rootFolder;
            for (String path : subFolders) {
                try {
                    System.out.println(info.getDisplayName() + "....path:" + path);
                    info = info.addSubFolder(path);
                }
                catch (Exception e) {
                    info = info.getSubFolder(path);
                    System.out.println("Error adding the subfoledr:" + e.getMessage() + "subfolder:" + info.getDisplayName());
                }
            }
            this.folderStack.put(dir, info);
            LinkedList currentqueue = new LinkedList();
            this.queueStack.put(currentDir.getAbsolutePath(), currentqueue);
            return FileVisitResult.CONTINUE;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Adding folder throws:" + e);
            return FileVisitResult.SKIP_SUBTREE;
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        File currentProcessingFile = file.toFile();
        this.queueStack.get(currentProcessingFile.getParent()).offer(currentProcessingFile.getAbsolutePath());
        this.addedFiles.incrementAndGet();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        exc.printStackTrace();
        System.out.println("Error adding into pst:" + file.toFile().getAbsolutePath() + "..Error:" + exc);
        return FileVisitResult.CONTINUE;
    }
}

