/*
 * Decompiled with CFR 0.152.
 */
package pst;

import com.aspose.email.FolderInfo;
import com.aspose.email.MapiMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class FileWalker
implements FileVisitor<Path> {
    private AtomicInteger addedFiles;
    private FolderInfo rootFolder;
    private Map<Path, FolderInfo> folderStack;
    private File parent;

    public FileWalker(AtomicInteger addedFiles, FolderInfo rootFolder, File parent) {
        this.addedFiles = addedFiles;
        this.rootFolder = rootFolder;
        this.parent = parent;
        this.folderStack = new HashMap<Path, FolderInfo>();
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        this.folderStack.remove(dir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        File currentDir = dir.toFile();
        try {
            if (currentDir.getName().equalsIgnoreCase("merge") || currentDir.getName().equalsIgnoreCase("decrypted")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (currentDir.getName().equals(this.parent.getName())) {
                this.folderStack.put(dir, this.rootFolder);
                return FileVisitResult.CONTINUE;
            }
            String subFolderPath = currentDir.getAbsolutePath().substring(this.parent.getAbsolutePath().length() + 1);
            List<String> subFolders = Arrays.asList(subFolderPath.split("/"));
            FolderInfo currentFolder = this.rootFolder;
            for (String folderName : subFolders) {
                try {
                    currentFolder = currentFolder.addSubFolder(folderName);
                }
                catch (Exception e) {
                    currentFolder = currentFolder.getSubFolder(folderName);
                }
            }
            this.folderStack.put(dir, currentFolder);
            return FileVisitResult.CONTINUE;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FileVisitResult.SKIP_SUBTREE;
        }
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        File currentFile = file.toFile();
        if (currentFile.isFile()) {
            try {
                FolderInfo targetFolder = this.folderStack.get(file.getParent());
                if (targetFolder != null) {
                    MapiMessage message = MapiMessage.load(currentFile.getAbsolutePath());
                    targetFolder.addMessage(message);
                    this.addedFiles.incrementAndGet();
                    message.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        exc.printStackTrace();
        return FileVisitResult.CONTINUE;
    }
}

