/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.aspose.email.FolderInfo;
import com.aspose.email.License;
import com.aspose.email.MapiMessage;
import com.aspose.email.PersonalStorage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import pst.PSTCreator;

public class EmlToPstConverter {
    private static final String LICENSE_PATH = "/home/parablu/Aspose.Email.Java.lic";

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java -jar EmlToPstConverter.jar <emlDirectory> <pstPath>");
            System.exit(1);
        }
        try {
            License license = new License();
            license.setLicense(LICENSE_PATH);
        }
        catch (Exception e) {
            System.out.println("License error: " + e.getMessage());
        }
        String emlDirectory = args[0];
        String pstPath = args[1];
        try {
            EmlToPstConverter.createPstLatest(emlDirectory, pstPath);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error creating pst" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(Path emlPath, String emlDirectory, PersonalStorage pst, Map<String, FolderInfo> folderCache) {
        MapiMessage mapiMessage = null;
        try {
            mapiMessage = MapiMessage.load(emlPath.toString());
            String relativeFolderPath = EmlToPstConverter.getRelativeFolderPath(emlDirectory, emlPath.toString());
            FolderInfo targetFolder = EmlToPstConverter.getOrCreateFolder(pst, folderCache, relativeFolderPath);
            targetFolder.addMessage(mapiMessage);
            System.out.println("Processed: " + emlPath.getFileName() + " to folder: " + relativeFolderPath);
        }
        catch (Exception e) {
            System.err.println("Error processing " + emlPath + ": " + e.getMessage());
        }
        finally {
            if (mapiMessage != null) {
                mapiMessage.dispose();
                mapiMessage = null;
            }
        }
    }

    private static String getRelativeFolderPath(String rootDirectory, String emlFilePath) {
        Path rootPath = Paths.get(rootDirectory, new String[0]);
        Path filePath = Paths.get(emlFilePath, new String[0]);
        Path relativePath = rootPath.relativize(filePath.getParent());
        return relativePath.toString().replace("\\", "/");
    }

    private static FolderInfo getOrCreateFolder(PersonalStorage pst, Map<String, FolderInfo> folderCache, String folderPath) {
        if (folderCache.containsKey(folderPath)) {
            return folderCache.get(folderPath);
        }
        String[] folderParts = folderPath.split("/");
        FolderInfo currentFolder = pst.getRootFolder();
        for (String folderName : folderParts) {
            FolderInfo subFolder = currentFolder.getSubFolder(folderName);
            if (subFolder == null) {
                subFolder = currentFolder.addSubFolder(folderName);
            }
            currentFolder = subFolder;
        }
        folderCache.put(folderPath, currentFolder);
        return currentFolder;
    }

    private static String createPstLatest(String mailFolder, String pstFilePath) {
        System.out.println("...creating unique pst files....." + pstFilePath);
        File fileObj = new File(pstFilePath);
        PersonalStorage pst = PersonalStorage.create(pstFilePath, 0);
        AtomicInteger addedFiles = new AtomicInteger();
        File fold = new File(mailFolder);
        System.out.println("..list of files...." + mailFolder + "...path..files..." + fold.listFiles().length);
        FolderInfo rootFolder = pst.getRootFolder();
        System.out.println("root folder:" + rootFolder.getDisplayName());
        PSTCreator pstcreator = new PSTCreator(addedFiles, rootFolder, fold);
        try {
            pstcreator.createPst();
            pst.dispose();
            fileObj = new File(pstFilePath);
            pstFilePath = fileObj.getAbsolutePath();
        }
        catch (Exception e) {
            System.out.println("...unable to download file...." + e);
            e.printStackTrace();
        }
        return pstFilePath;
    }
}

