/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.RetryPolicyTable;
import com.parablu.pcbd.domain.User;
import com.pg.controller.Graph;
import com.pg.dao.BackupFileDao;
import com.pg.dao.FileDao;
import com.pg.dao.Office365Dao;
import com.pg.dao.UtilDao;
import com.pg.domain.ChunkFile;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.encryption.service.FileEncryptionService;
import com.pg.exception.BaseException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MD5Generator;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.Office365DownloadService;
import com.pg.service.RetryService;
import com.pg.service.UtilService;
import com.pg.service.impl.Office365DownloadServiceImplData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedSupplier;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Office365DownloadServiceImpl
implements Office365DownloadService {
    private static Logger logger = LogManager.getLogger(Office365DownloadServiceImpl.class);
    private static final int BUFFER_CHUNK_SIZE = 1024;
    private RetryPolicy<Response> retryPolicy = null;
    @Autowired
    private UtilService utilService;
    @Autowired
    private Office365Dao office365Dao;
    @Autowired
    private UtilDao utilDao;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private RetryService retryService;
    private static final String BEARER = "Bearer ";

    public void setBackupFileDao(BackupFileDao backupFileDao) {
    }

    public void setFileDao(FileDao fileDao) {
    }

    public void setOffice365Dao(Office365Dao office365Dao) {
        this.office365Dao = office365Dao;
    }

    public void setFileEncryptionService(FileEncryptionService fileEncryptionService) {
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setExternalStorageBackupFileDao(ExternalStorageBackupFileDao externalStorageBackupFileDao) {
    }

    public String getKeyForDecrypt(int cloudId, long timeStamp) {
        EncryptionKey encryptionKey = this.utilDao.getKeyForDecrypt(cloudId, timeStamp, "");
        String encryptionKeyVal = "";
        if (encryptionKey != null) {
            encryptionKeyVal = encryptionKey.getSaltKey();
            logger.debug("Recieved salt key  for file ..... " + encryptionKeyVal);
        }
        return encryptionKeyVal;
    }

    @Override
    public BufferedInputStream downloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, User user, long uploadedTimeStamp, boolean isSync) {
        String odbDownloadPriorityTimeStamp = PCHelperConstant.getODBDownloadPriorityTimeStamp();
        int retryCountFor429 = 0;
        int retryCountForException = 0;
        try {
            logger.debug("........file uploaded time stamp....." + uploadedTimeStamp + ".....odbDownloadPriorityTimeStamp..." + odbDownloadPriorityTimeStamp);
            if (!StringUtils.isEmpty((String)odbDownloadPriorityTimeStamp) && uploadedTimeStamp != 0L && uploadedTimeStamp <= Long.parseLong(odbDownloadPriorityTimeStamp)) {
                logger.debug("...file is older than given date so attempt without deviceUUID logic...");
                return this.downloadFileFromOneDriveWithPriority1(authorizationTokenElement, fileName, chunkFile, deviceUUID, user.getUserName(), false, uploadedTimeStamp, retryCountFor429, retryCountForException, isSync);
            }
            logger.debug("...file is not older than given date so attempt with deviceUUID logic...");
            return this.downloadFileFromOneDriveWithPriority1(authorizationTokenElement, fileName, chunkFile, deviceUUID, user.getUserName(), true, uploadedTimeStamp, retryCountFor429, retryCountForException, isSync);
        }
        catch (BaseException e) {
            logger.debug("Exception :" + e.getMessage());
            return null;
        }
    }

    public BufferedInputStream downloadFileFromOneDriveWithPriority(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, String userName, boolean priorityWithDeviceUUID, long uploadedTimeStamp, int retryCount, int retryCountForException, boolean isSync) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        } else if (!StringUtils.isEmpty((String)userName) && isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
            logger.debug("device unique id : " + userNameInPath);
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        if (!priorityWithDeviceUUID) {
            logger.debug("...without deviceUUID......");
            downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        }
        logger.debug(chunkFile.getFileName() + " ............new path................." + downloadurl);
        BufferedInputStream bufferedInputStream = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        Response result = null;
        try {
            result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
            String tokenUserName = authorizationTokenElementTemp.getUserName();
            int responseCode = result.code();
            logger.debug("Retry Response status code: " + responseCode);
            if (responseCode == 401) {
                logger.debug("inside 401...");
                authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp);
                if (authorizationTokenElementTemp != null) {
                    if (authorizationTokenElement.isServiceAcct()) {
                        authorizationTokenElementTemp.setServiceAcct(true);
                        this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, authorizationTokenElementTemp.getAccessToken(), authorizationTokenElementTemp.getRefreshToken());
                    } else {
                        this.utilService.updatePciAuthorizationToken(authorizationTokenElementTemp, tokenUserName);
                    }
                    result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
                    responseCode = result.code();
                }
            }
            if (responseCode == 429 || responseCode == 503) {
                logger.debug("Reponse code is " + responseCode + " retryCount " + ++retryCount);
                if (retryCount <= 3) {
                    String value = "";
                    if (result.header("Retry-After") != null) {
                        Headers headers = result.headers();
                        value = headers.get("Retry-After");
                        logger.debug("Retry-After ..." + value);
                    }
                    logger.debug("Retry-After ..." + value);
                    if (StringUtils.isEmpty((String)value)) {
                        logger.debug("..Retry-After is empty so set retry value as 3");
                        value = "3";
                    }
                    long waitTime = Long.parseLong(value);
                    long millis = waitTime * 1000L;
                    logger.debug("millis .." + millis);
                    this.sleepForGivenTime(millis);
                    this.downloadFileFromOneDriveWithPriority(authorizationTokenElement, fileName, chunkFile, deviceUUID, userName, priorityWithDeviceUUID, uploadedTimeStamp, retryCount, retryCountForException, isSync);
                } else {
                    logger.debug("Response code is 429/503 reaches max retry so return");
                    throw new BaseException("Response code is 429/503 reaches max retry");
                }
            }
            if (responseCode == 200) {
                InputStream inputStream = result.body().byteStream();
                bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                logger.debug(tokenUserName + "download url : " + downloadurl);
            } else if (responseCode == 404) {
                logger.debug("Response code is 404");
                List allDeviceByUserName = this.deviceDao.getAllDeviceByUserName(1, userName);
                for (Device device : allDeviceByUserName) {
                    if (device == null || StringUtils.isEmpty((String)deviceUUID) || device.getDeviceUUID().equalsIgnoreCase(deviceUUID)) continue;
                    logger.debug("Retry with other deviceUUID " + device.getDeviceUUID());
                    bufferedInputStream = this.downloadFileFromOneDriveWithFailedCase(1, authorizationTokenElement, fileName, chunkFile, device.getDeviceUUID(), priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, 0, isSync);
                    if (bufferedInputStream == null) continue;
                    break;
                }
                if (bufferedInputStream == null) {
                    logger.debug("After checking in all devices for user stream is null so check without deviceUUID");
                    bufferedInputStream = this.downloadFileFromOneDriveWithFailedCase(1, authorizationTokenElement, fileName, chunkFile, "", priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, 0, isSync);
                    if (bufferedInputStream == null) {
                        logger.debug("After checking without deviceUUID stream is empty so call retryDownloadFileFromOneDrive");
                        bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, isSync);
                    }
                }
            } else {
                bufferedInputStream = this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, isSync);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
            logger.error("...retryCountForException.." + retryCountForException);
            if (++retryCountForException <= 3) {
                long millis = 2000L;
                logger.debug("sleep for 2 sec ");
                this.sleepForGivenTime(millis);
                this.downloadFileFromOneDriveWithPriority(authorizationTokenElement, fileName, chunkFile, deviceUUID, userName, priorityWithDeviceUUID, uploadedTimeStamp, retryCount, retryCountForException, isSync);
            }
            logger.debug("exception retrycount reaches max try so terminate");
            throw new BaseException("exception retrycount reaches max try");
        }
        return bufferedInputStream;
    }

    public BufferedInputStream downloadFileFromOneDriveWithPriority1(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, String userName, boolean priorityWithDeviceUUID, long uploadedTimeStamp, int retryCount, int retryCountForException, boolean isSync) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        BufferedInputStream bufferedInputStream = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        Office365DownloadServiceImplData downloadServiceImplData = new Office365DownloadServiceImplData(proxyUserName, password, host, port);
        try {
            boolean incrementPath = false;
            boolean decrementPath = false;
            boolean newPathCheck = false;
            boolean newRetryPathCheck = false;
            boolean oldStylePath = false;
            boolean customOldStylePath = false;
            boolean increOldStylePath = false;
            boolean decreOldStylePath = false;
            boolean newPathCheckOnly = false;
            boolean breakLoop = true;
            int newRetryPath = 1;
            int maxRetryCount = 9;
            ArrayList<String> triedDeviceUUIDs = new ArrayList<String>();
            triedDeviceUUIDs.add(deviceUUID);
            Response result = null;
            if (null == this.retryPolicy) {
                this.getRetryPolicy(authorizationTokenElementTemp);
            }
            String pbFolderName = this.office365Dao.getOdbFolderName(1);
            String userNameInPath = "";
            if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
                userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
                logger.debug("....device unique id ....... " + userNameInPath);
            } else if (!StringUtils.isEmpty((String)userName) && isSync) {
                userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
                logger.debug("device unique id : " + userNameInPath);
            }
            String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElement.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
            if (!priorityWithDeviceUUID) {
                logger.debug("...without deviceUUID......");
                downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
            }
            downloadServiceImplData.setDeviceUUID(deviceUUID);
            downloadServiceImplData.setDownloadUrl(downloadurl);
            do {
                breakLoop = true;
                this.executeDownloadWithFailSafe(downloadServiceImplData, this.retryPolicy);
                result = downloadServiceImplData.getResult();
                int responseCode = result.code();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.body().byteStream();
                    logger.debug(chunkFile.getFileName() + "...entity-length......." + result.body().contentLength());
                    if (result.body().contentLength() < 0L && (responseCode = (result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp)).code()) == 200) {
                        inputStream = result.body().byteStream();
                    }
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    continue;
                }
                if (responseCode != 404) continue;
                logger.debug("pb fix Response code is 404");
                List allDeviceByUserName = this.deviceDao.getAllDeviceByUserName(1, userName);
                Device deviceTemp = new Device();
                deviceTemp.setDeviceUUID("qe4csybanrz8");
                deviceTemp.setDeviceName("hardcoded");
                allDeviceByUserName.add(deviceTemp);
                if (triedDeviceUUIDs.size() != allDeviceByUserName.size()) {
                    for (Device device : allDeviceByUserName) {
                        if (device == null || StringUtils.isEmpty((String)deviceUUID) || triedDeviceUUIDs.contains(device.getDeviceUUID())) continue;
                        breakLoop = false;
                        logger.debug("Retry with other deviceUUID " + device.getDeviceUUID());
                        triedDeviceUUIDs.add(device.getDeviceUUID());
                        downloadServiceImplData.setDeviceUUID(device.getDeviceUUID());
                        if (device.getDeviceName().equalsIgnoreCase("hardcoded")) {
                            userNameInPath = device.getDeviceUUID();
                        } else if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
                            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
                        } else if (!StringUtils.isEmpty((String)userName) && isSync) {
                            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
                        }
                        downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElement.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                        break;
                    }
                } else if (!increOldStylePath) {
                    breakLoop = false;
                    downloadServiceImplData.setDeviceUUID(deviceUUID);
                    userNameInPath = "";
                    if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
                        userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
                        logger.debug("....device unique id ....... " + userNameInPath);
                    } else if (!StringUtils.isEmpty((String)userName) && isSync) {
                        userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
                        logger.debug("device unique id : " + userNameInPath);
                    }
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    logger.debug("...increOldStylePath..." + cloudPath);
                    increOldStylePath = true;
                } else if (!newPathCheckOnly && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + PCHelperConstant.getRetryOdbFolderValue();
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheckOnly = true;
                    logger.debug("...newPathCheck ..." + cloudPath);
                } else if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheck = true;
                    logger.debug("...newPathCheck ..." + cloudPath);
                } else if (!newRetryPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    breakLoop = false;
                    logger.debug("...Inside new logic...");
                    int retryPath = PCHelperConstant.getRetryOdbFolderValue() + newRetryPath;
                    String cloudPath = "" + retryPath;
                    logger.debug("...retryPath..." + retryPath);
                    logger.debug("...downloadurl..." + downloadurl);
                    String folderExistsPath = PCHelperConstant.getParabluLibraryUrlForFolderCheck((String)authorizationTokenElementTemp.getSharePointUrl(), (String)authorizationTokenElementTemp.getAccountId(), (String)("PB/" + userNameInPath + "/" + retryPath));
                    boolean isFolderExists = this.office365Dao.isFolderExists(folderExistsPath, authorizationTokenElementTemp.getAccessToken());
                    logger.debug(isFolderExists + "...isFolderExists..." + folderExistsPath);
                    if (isFolderExists) {
                        downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                        ++newRetryPath;
                    } else {
                        if (newRetryPath < maxRetryCount) {
                            newRetryPathCheck = true;
                        }
                        logger.debug("...Folder not exists....");
                    }
                    logger.debug("...newPathCheck ..." + cloudPath);
                } else if (!decrementPath) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    decrementPath = true;
                    logger.debug("...decre new path..." + cloudPath);
                } else if (!incrementPath) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    logger.debug("...incre new path..." + cloudPath);
                    incrementPath = true;
                } else if (!oldStylePath) {
                    breakLoop = false;
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                } else if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    customOldStylePath = true;
                    logger.debug("...customOldStylePath retryodbValue ..." + cloudPath);
                } else if (!decreOldStylePath) {
                    breakLoop = false;
                    String cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    decreOldStylePath = true;
                    logger.debug("...decreOldStylePath..." + cloudPath);
                }
                downloadServiceImplData.setDownloadUrl(downloadurl);
                if (!incrementPath || !decrementPath || !newPathCheck || !newRetryPathCheck || !oldStylePath || !customOldStylePath || !increOldStylePath || !decreOldStylePath || !newPathCheckOnly) continue;
                logger.debug("All possibilities have been tried so break the loop");
                breakLoop = true;
            } while (!breakLoop);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :", (Throwable)e);
            throw new BaseException("exception retrycount reaches max try");
        }
        return bufferedInputStream;
    }

    public void getRetryPolicy(PciAuthorizationTokenElement authorizationTokenElementTemp) {
        RetryPolicyTable policyTable = this.retryService.getRetryPolicyTable(1, PCHelperConstant.RETRY_POLICY_OPERATION.DOWNLOAD.toString());
        this.retryPolicy = this.retryService.valueOf(policyTable);
        this.retryPolicy.onRetry(e -> {
            ExecutionAttemptedEvent event = e;
            Throwable failure = event.getLastFailure();
            logger.debug("Connection error encountered {}", (Object)failure.getMessage(), (Object)failure);
            logger.debug("Retrying Count:", (Object)event.getAttemptCount());
        });
        this.retryPolicy.handleResultIf(res -> {
            logger.debug("inside retry handleResultIf...........");
            if (res == null) {
                logger.debug("Result is null so retry...........");
                return true;
            }
            if (res instanceof Response) {
                Response response = res;
                int statusCode = response.code();
                if (statusCode == 401) {
                    PciAuthorizationTokenElement tokenElement = this.updateToken(authorizationTokenElementTemp);
                    return true;
                }
                if (statusCode == 429 || statusCode == 503) {
                    String value = "3";
                    logger.debug("inside retry.... response code:" + statusCode);
                    if (response.header("Retry-After") != null) {
                        Headers headers = response.headers();
                        value = headers.get("Retry-After");
                        logger.debug("Retry-After ..." + value);
                    }
                    logger.debug("After getting the sleep value:" + value);
                    long waitTime = Long.parseLong(value);
                    long millis = waitTime * 1000L;
                    this.sleepForGivenTime(millis);
                    return true;
                }
                if (statusCode != 200 && statusCode != 404) {
                    logger.debug("the status code is neither 200 nor 404 nor 429 401 503 so retry : " + statusCode);
                    return true;
                }
            }
            return false;
        });
    }

    private void executeDownloadWithFailSafe(final Office365DownloadServiceImplData downloadServiceImplData, RetryPolicy<Response> retryPolicy) {
        CheckedSupplier<Response> checkedSupplier = new CheckedSupplier<Response>(){

            public Response get() throws Throwable {
                return downloadServiceImplData.executeDownload();
            }
        };
        Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).get((CheckedSupplier)checkedSupplier);
    }

    private PciAuthorizationTokenElement updateToken(PciAuthorizationTokenElement authorizationTokenElement) {
        PciAuthorizationTokenElement authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElement);
        String tokenUserName = authorizationTokenElement.getUserName();
        if (authorizationTokenElementTemp != null) {
            if (authorizationTokenElement.isServiceAcct()) {
                authorizationTokenElementTemp.setServiceAcct(true);
                this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, authorizationTokenElementTemp.getAccessToken(), authorizationTokenElementTemp.getRefreshToken());
            } else {
                this.utilService.updatePciAuthorizationToken(authorizationTokenElementTemp, tokenUserName);
            }
        } else {
            authorizationTokenElementTemp = authorizationTokenElement;
        }
        return authorizationTokenElementTemp;
    }

    private Response executeDownload(String proxyUserName, String password, String host, int port, String downloadurl, PciAuthorizationTokenElement authorizationTokenElement) throws ClientProtocolException, IOException {
        Response result = null;
        HttpGet httpGet = new HttpGet(downloadurl);
        httpGet.addHeader("Authorization", BEARER + authorizationTokenElement.getAccessToken());
        httpGet.addHeader("Accept", "application/json;odata=verbose");
        httpGet.addHeader("Content-Type", "*/*");
        if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
            httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
            logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
        }
        if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
            logger.debug(" without proxy ....");
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(downloadurl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            result = okHttpClient.newCall(request).execute();
        } else {
            logger.debug(" using proxy ....");
            OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
            Request request = new Request.Builder().url(downloadurl).addHeader("Accept", "application/json;odata=verbose").addHeader("Content-Type", "*/*").build();
            result = okHttpClient.newCall(request).execute();
        }
        logger.debug("...Inside execute..." + result.code());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedInputStream downloadFileFromOneDriveWithFailedCase(int cloudId, PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, boolean priorityWithDeviceUUID, String userName, long uploadedTimeStamp, int retryCount, int retryCountForException, boolean isSync) {
        String fileNameTemp = fileName;
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        } else if (!StringUtils.isEmpty((String)userName) && isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
            logger.debug("device unique id : " + userNameInPath);
        }
        if (!priorityWithDeviceUUID) {
            logger.debug("...without deviceUUID......");
            userNameInPath = "";
        }
        String downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileNameTemp, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        logger.debug(chunkFile.getFileName() + " ............new path................." + downloadurl);
        BufferedInputStream bufferedInputStream = null;
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        Response result = null;
        try {
            result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
            String tokenUserName = authorizationTokenElementTemp.getUserName();
            int responseCode = result.code();
            logger.debug("Retry Response status code: " + responseCode);
            if (responseCode == 200) {
                InputStream inputStream = result.body().byteStream();
                logger.debug(chunkFile.getFileName() + "...entity-length......." + result.body().contentLength());
                if (result.body().contentLength() < 0L) {
                    result = this.executeDownload(proxyUserName, password, host, port, downloadurl, authorizationTokenElementTemp);
                    tokenUserName = authorizationTokenElementTemp.getUserName();
                    responseCode = result.code();
                    if (responseCode == 200) {
                        inputStream = result.body().byteStream();
                    }
                }
                bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                logger.debug(tokenUserName + "download url : " + downloadurl);
                return bufferedInputStream;
            }
            if (responseCode == 429 || responseCode == 503) {
                logger.debug("responseCode is " + responseCode + " retryCount " + ++retryCount);
                if (retryCount <= 3) {
                    String value = "";
                    if (result.header("Retry-After") != null) {
                        Headers headers = result.headers();
                        value = headers.get("Retry-After");
                        logger.debug("Retry-After ..." + value);
                    }
                    logger.debug("Retry-After ..." + value);
                    if (StringUtils.isEmpty((String)value)) {
                        logger.debug("..Retry-After is empty so set retry value as 3");
                        value = "3";
                    }
                    long waitTime = Long.parseLong(value);
                    long millis = waitTime * 1000L;
                    logger.debug("millis .." + millis);
                    this.sleepForGivenTime(millis);
                    this.downloadFileFromOneDriveWithFailedCase(cloudId, authorizationTokenElement, fileName, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, retryCount, retryCountForException, isSync);
                    return bufferedInputStream;
                }
                logger.debug("Response code is 429/503 reaches max retry so return");
                throw new BaseException("Response code is 429/503 reaches max retry");
            }
            if (responseCode == 401) {
                if ((authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp)) == null) return bufferedInputStream;
                if (authorizationTokenElement.isServiceAcct()) {
                    authorizationTokenElementTemp.setServiceAcct(true);
                    this.office365Dao.updatePciAuthorizationTokensForServiceAcct(1, authorizationTokenElementTemp.getAccessToken(), authorizationTokenElementTemp.getRefreshToken());
                    return this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, isSync);
                } else {
                    this.utilService.updatePciAuthorizationToken(authorizationTokenElementTemp, tokenUserName);
                }
                return this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, isSync);
            }
            if (responseCode != 404) return this.retryDownloadFileFromOneDrive(authorizationTokenElementTemp, fileNameTemp, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, 0, isSync);
            logger.debug("404 in downloadFileFromOneDriveWithFailedCase for deviceUUID " + deviceUUID + " so return null");
            return null;
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Downloading File From One Drive :" + e.getMessage());
            if (++retryCountForException <= 3) {
                long millis = 2000L;
                logger.debug("sleep for 2 sec ");
                this.sleepForGivenTime(millis);
                this.downloadFileFromOneDriveWithFailedCase(cloudId, authorizationTokenElement, fileName, chunkFile, deviceUUID, priorityWithDeviceUUID, userName, uploadedTimeStamp, retryCount, retryCountForException, isSync);
                return bufferedInputStream;
            }
            logger.debug("exception retryCountForException reaches max try so terminate");
            throw new BaseException("exception retryCountForException reaches max try");
        }
    }

    public BufferedInputStream retryDownloadFileFromOneDrive(PciAuthorizationTokenElement authorizationTokenElement, String fileName, ChunkFile chunkFile, String deviceUUID, boolean priorityWithDeviceUUID, String userName, long uploadedTimeStamp, int retryCountFor429, boolean isSync) {
        boolean retry;
        String downloadurl;
        logger.debug("Retrying file download form ODB");
        String pbFolderName = this.office365Dao.getOdbFolderName(1);
        PciAuthorizationTokenElement authorizationTokenElementTemp = authorizationTokenElement;
        String userNameInPath = "";
        if (!StringUtils.isEmpty((String)deviceUUID) && !isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(deviceUUID);
            logger.debug("....device unique id ....... " + userNameInPath);
        } else if (!StringUtils.isEmpty((String)userName) && isSync) {
            userNameInPath = Office365DownloadServiceImpl.getUniqueODUserFolder(userName);
            logger.debug("device unique id : " + userNameInPath);
        }
        String initialDownloadUrl = downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
        String proxyUserName = PCHelperConstant.getProxyUserName();
        String password = PCHelperConstant.getProxyPassword();
        String host = PCHelperConstant.getProxyHost();
        int port = PCHelperConstant.getProxyPort();
        BufferedInputStream bufferedInputStream = null;
        String originalPath = chunkFile.getCloudStoragePath();
        boolean incrementPath = false;
        boolean decrementPath = false;
        boolean newPathCheck = false;
        boolean newRetryPathCheck = false;
        boolean oldStylePath = false;
        boolean customOldStylePath = false;
        boolean increOldStylePath = false;
        boolean decreOldStylePath = false;
        boolean newPathCheckOnly = false;
        int retryCount = 0;
        int newRetryPath = 1;
        int maxRetryCount = 9;
        int sleepMultiplier = 1;
        long sleepTime = 5000L * (long)sleepMultiplier;
        do {
            retry = false;
            HttpGet httpGet = null;
            boolean retryCountFor503 = false;
            String modifiedPath = chunkFile.getCloudStoragePath();
            try {
                String cloudPath;
                HttpResponse result;
                logger.debug(downloadurl + "......download path........." + retryCount);
                httpGet = new HttpGet(downloadurl);
                httpGet.addHeader("Authorization", BEARER + authorizationTokenElementTemp.getAccessToken());
                httpGet.addHeader("Accept", "application/json;odata=verbose");
                httpGet.addHeader("Content-Type", "*/*");
                if (!StringUtils.isEmpty((String)PCHelperConstant.getODBDecorationValue())) {
                    httpGet.addHeader("User-Agent", PCHelperConstant.getODBDecorationValue());
                    logger.debug("..add retry THROTTLE_DECOR..............." + PCHelperConstant.getODBDecorationValue());
                }
                if (StringUtils.isEmpty((String)proxyUserName) || StringUtils.isEmpty((String)password) || StringUtils.isEmpty((String)host) || port <= 0) {
                    logger.debug(" without proxy ...");
                    HttpClient httpclient = HttpClientUtil.getSSlConnection();
                    result = httpclient.execute((HttpUriRequest)httpGet);
                } else {
                    logger.debug(" using proxy ...");
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(proxyUserName, password));
                    CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
                    HttpHost proxy = new HttpHost(host, port);
                    RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
                    httpGet.setConfig(config);
                    result = httpclient.execute((HttpUriRequest)httpGet);
                }
                int responseCode = result.getStatusLine().getStatusCode();
                logger.debug("Retry Response status code: " + responseCode);
                if (responseCode == 200) {
                    InputStream inputStream = result.getEntity().getContent();
                    bufferedInputStream = new BufferedInputStream(inputStream, 1024);
                    logger.debug(originalPath + "...Retry download url : " + downloadurl);
                    if (originalPath.equals(modifiedPath)) continue;
                    logger.debug("....path modified......");
                    continue;
                }
                if (responseCode == 401) {
                    retry = true;
                    ++retryCount;
                    sleepTime = this.sleepForGivenTime(sleepTime);
                    authorizationTokenElementTemp = this.office365Dao.getAccessToken(authorizationTokenElementTemp);
                    continue;
                }
                if (responseCode == 429 || responseCode == 503) {
                    try {
                        String value;
                        logger.debug("Reponse code is " + responseCode + " retryCountFor429 " + ++retryCountFor429 + " retryCount " + ++retryCount);
                        if (retryCountFor429 <= 3) {
                            value = result.getFirstHeader("Retry-After").getValue();
                            logger.debug("Retry-After ..." + value);
                            if (StringUtils.isEmpty((String)value)) {
                                logger.debug("..Retry-After is empty so set retry value as 3");
                                value = "3";
                            }
                        } else {
                            logger.debug("Response code is 429/503 reaches max retry so return");
                            throw new BaseException("Response code is 429/503 reaches max retry");
                        }
                        long waitTime = Long.parseLong(value);
                        long millis = waitTime * 1000L;
                        logger.debug("millis .." + millis);
                        this.sleepForGivenTime(millis);
                    }
                    catch (Exception e) {
                        logger.error("Exception :" + e.getMessage());
                    }
                    continue;
                }
                if (responseCode == 200) continue;
                retry = true;
                sleepTime = responseCode != 404 ? this.sleepForGivenTime(sleepTime) : 0L;
                logger.debug("..retry attempt for response code ...." + responseCode + "...." + ++retryCount + "....." + authorizationTokenElementTemp.getEmailId());
                logger.debug("..retry url ...." + downloadurl);
                if (responseCode != 404) continue;
                logger.debug("response code is 404 so sleep for 2 sec..");
                this.sleepForGivenTime(2000L);
                logger.debug("sleep for 2 sec completed..");
                if (!increOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...increOldStylePath..." + modifiedPath);
                    increOldStylePath = true;
                    continue;
                }
                if (!newPathCheckOnly && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    cloudPath = "" + PCHelperConstant.getRetryOdbFolderValue();
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheckOnly = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    newPathCheck = true;
                    modifiedPath = cloudPath;
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!newRetryPathCheck && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    logger.debug("...Inside new logic...");
                    int retryPath = PCHelperConstant.getRetryOdbFolderValue() + newRetryPath;
                    String cloudPath2 = "" + retryPath;
                    logger.debug("...retryPath..." + retryPath);
                    logger.debug("...downloadurl..." + downloadurl);
                    String folderExistsPath = PCHelperConstant.getParabluLibraryUrlForFolderCheck((String)authorizationTokenElementTemp.getSharePointUrl(), (String)authorizationTokenElementTemp.getAccountId(), (String)("PB/" + userNameInPath + "/" + retryPath));
                    boolean isFolderExists = this.office365Dao.isFolderExists(folderExistsPath, authorizationTokenElementTemp.getAccessToken());
                    logger.debug(isFolderExists + "...isFolderExists..." + folderExistsPath);
                    if (isFolderExists) {
                        downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath2, (String)pbFolderName);
                        modifiedPath = cloudPath2;
                        ++newRetryPath;
                        ++maxRetryCount;
                    } else {
                        newRetryPathCheck = true;
                        logger.debug("...Folder not exists....");
                    }
                    logger.debug("...newPathCheck ..." + modifiedPath);
                    continue;
                }
                if (!decrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    decrementPath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decre new path..." + modifiedPath);
                    continue;
                }
                if (!incrementPath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)userNameInPath, (String)cloudPath, (String)pbFolderName);
                    modifiedPath = cloudPath;
                    logger.debug("...incre new path..." + modifiedPath);
                    incrementPath = true;
                    continue;
                }
                if (!oldStylePath) {
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)chunkFile.getCloudStoragePath(), (String)pbFolderName);
                    oldStylePath = true;
                    logger.debug("...oldStylePath restore ...");
                    continue;
                }
                if (!customOldStylePath && PCHelperConstant.getRetryOdbFolderValue() > 0) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path + PCHelperConstant.getRetryOdbFolderValue());
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    customOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...customOldStylePath retryodbValue ..." + modifiedPath);
                    continue;
                }
                if (!decreOldStylePath) {
                    cloudPath = chunkFile.getCloudStoragePath();
                    if (StringUtils.isNotEmpty((String)cloudPath)) {
                        int path = Integer.parseInt(cloudPath);
                        cloudPath = "" + (path - 1);
                    }
                    downloadurl = PCHelperConstant.getLibraryDownloadUrl((String)authorizationTokenElementTemp.getSharePointUrl(), (String)fileName, (String)authorizationTokenElementTemp.getAccountId(), (String)"", (String)cloudPath, (String)pbFolderName);
                    decreOldStylePath = true;
                    modifiedPath = cloudPath;
                    logger.debug("...decreOldStylePath..." + modifiedPath);
                    continue;
                }
                logger.debug("file find in any where so attempt once in initial path");
                downloadurl = initialDownloadUrl;
                logger.debug("...initialDownloadUrl..." + initialDownloadUrl);
            }
            catch (Exception e) {
                retry = true;
                ++retryCount;
                sleepTime = this.sleepForGivenTime(sleepTime);
                logger.trace("" + e);
                logger.error("Exception While Retying Download File From One Drive :" + e.getMessage());
            }
        } while (retry && retryCount < maxRetryCount);
        return bufferedInputStream;
    }

    private static String getUniqueODUserFolder(String uniqueId) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)uniqueId)) {
            String md5Val = MD5Generator.generateMD5OfString((String)uniqueId);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }

    private long sleepForGivenTime(long sleepTime) {
        long sleepTimeTemp = sleepTime;
        try {
            logger.debug("SleepTime is" + sleepTimeTemp);
            Thread.sleep(sleepTimeTemp);
            int sleepMultiplier = 2;
            sleepTimeTemp *= (long)sleepMultiplier;
        }
        catch (InterruptedException e1) {
            logger.error("Thread interupted error");
        }
        return sleepTimeTemp;
    }
}

