/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.pg.element.BluKryptElement;
import com.pg.element.ChunkFileElement;
import com.pg.exception.ParacloudBackupException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.ChunkableUploadService;
import com.pg.service.impl.BaseUploadService;
import com.pg.sync.service.SyncUploadService;
import com.pg.util.FileUtils;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ChunkableUploadServiceImpl
extends BaseUploadService
implements ChunkableUploadService {
    private Logger logger = LogManager.getLogger(ChunkableUploadServiceImpl.class);
    @Autowired
    private SyncUploadService syncUploadService;
    private static final String CHUNK = "chunk";
    private static final String INSIDE_UPLOAD_CHUNKABLE_FILE = "@@@@ Inside upload chunkable file ";
    private static final String EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP = " Exception inside uploadChunkableFileToBackUp for file  ";
    private static final String IN_UPLOAD_CHUNKABLE_FILE_FOR_SYNC = "@@@@ Inside upload uploadChunkableFileForSync file ";
    private static final String COMPLETE_PATH = "COMPLETE PATH...............";

    @Override
    public String uploadChunkableFileToBackUp(String cloudName, InputStream inputStream, InputStream searchInputStream, ChunkFileElement fileElement, String osType, boolean isPortalUpload, String indexPath, String batchId, boolean isCompressed) {
        this.logger.debug(INSIDE_UPLOAD_CHUNKABLE_FILE + fileElement.getFileName());
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), osType);
            fileElement.setFileCompletePath(convertedPath);
            this.uploadFile(cloudName, inputStream, searchInputStream, fileElement, isPortalUpload, indexPath, batchId, isCompressed);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
            throw new ParacloudBackupException("IO Exception while transfering from client" + e, 500);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String intermediateUploadFolder = PCHelperConstant.getMntTempChunkPath() + fileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        FileUtils.getExistingFileNamesForGivenPath((String)intermediateUploadFolder);
        List fileChunks = fileElement.getFileChunks();
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadChunkableFileToBackUp(String cloudName, InputStream inputStream, ChunkFileElement fileElement, String osType, String indexPath, String batchId, boolean isCompressed) {
        this.logger.debug(INSIDE_UPLOAD_CHUNKABLE_FILE + fileElement.getFileName());
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), osType);
            fileElement.setFileCompletePath(convertedPath);
            this.uploadFile(cloudName, inputStream, null, fileElement, false, indexPath, batchId, isCompressed);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String intermediateUploadFolder = PCHelperConstant.getMntTempChunkPath() + fileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        List areadyUploadedChunks = FileUtils.getExistingFileNamesForGivenPath((String)intermediateUploadFolder);
        List fileChunks = fileElement.getFileChunks();
        fileChunks.removeAll(areadyUploadedChunks);
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadChunkableFileForSync(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload, String indexPath) {
        this.logger.debug(IN_UPLOAD_CHUNKABLE_FILE_FOR_SYNC + fileElement.getFileName());
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), bluKryptElement.getOsType());
            fileElement.setFileCompletePath(convertedPath);
            this.logger.debug(bluKryptElement.getFilePath() + COMPLETE_PATH + convertedPath);
            this.uploadSyncFile(cloudName, inputStream, fileElement, isPortalUpload, indexPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        this.createFoldersForUpload(deviceTempPath);
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        List areadyUploadedChunks = FileUtils.getExistingFileNamesForGivenPath((String)intermediateUploadFolder);
        List fileChunks = fileElement.getFileChunks();
        fileChunks.removeAll(areadyUploadedChunks);
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadChunkableFileForSyncWithBatchID(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload, String indexPath, String batchId) {
        this.logger.debug(IN_UPLOAD_CHUNKABLE_FILE_FOR_SYNC + fileElement.getFileName());
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), bluKryptElement.getOsType());
            fileElement.setFileCompletePath(convertedPath);
            this.logger.debug(bluKryptElement.getFilePath() + COMPLETE_PATH + convertedPath);
            this.uploadSyncFile(cloudName, inputStream, fileElement, isPortalUpload, indexPath, batchId);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        if (!StringUtils.isEmpty((Object)batchId)) {
            deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultSyncUploadPath((String)cloudName) + fileElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + batchId;
        }
        this.createFoldersForUpload(deviceTempPath);
        String intermediateUploadFolder = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + CHUNK;
        List areadyUploadedChunks = FileUtils.getExistingFileNamesForGivenPath((String)intermediateUploadFolder);
        List fileChunks = fileElement.getFileChunks();
        fileChunks.removeAll(areadyUploadedChunks);
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    @Override
    public boolean cancelSyncFileUpload(String cloudName, BluKryptElement bluKryptElement, ChunkFileElement fileElement, String indexPath) {
        this.logger.debug(IN_UPLOAD_CHUNKABLE_FILE_FOR_SYNC + fileElement.getFileName());
        boolean success = true;
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), bluKryptElement.getOsType());
            fileElement.setFileCompletePath(convertedPath);
            this.logger.debug(bluKryptElement.getFilePath() + COMPLETE_PATH + convertedPath);
            success = this.cancelUploadSyncFile(cloudName, fileElement, indexPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        return success;
    }

    @Override
    public String uploadChunkableFileForSync(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement fileElement, boolean isPortalUpload) {
        return this.uploadChunkableFileForSync(cloudName, bluKryptElement, inputStream, fileElement, isPortalUpload, null);
    }

    @Override
    public String uploadChunkableFileForSync(BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement fileElement, String indexPath, String batchId) {
        return this.uploadChunkableFileForSyncWithBatchID(bluKryptElement.getCloudName(), bluKryptElement, inputStream, fileElement, false, indexPath, batchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadChunkableFileToBackUpForPFT(String cloudName, InputStream inputStream, ChunkFileElement fileElement, long size, String osType, String sourceFilePath, boolean isPortalUpload, String indexPath) {
        this.logger.debug(INSIDE_UPLOAD_CHUNKABLE_FILE + fileElement.getFileName());
        String nextChunkName = "-1";
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), osType);
            fileElement.setFileCompletePath(convertedPath);
            this.uploadFile(cloudName, inputStream, null, fileElement, isPortalUpload, indexPath, null, false);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileElement.getDeviceUUID();
        this.createFoldersForUpload(deviceTempPath);
        List fileChunks = fileElement.getFileChunks();
        if (!CollectionUtils.isEmpty((Collection)fileChunks)) {
            nextChunkName = (String)fileChunks.get(0);
        }
        return nextChunkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> uploadChunkableFileForSyncPortal(String cloudName, BluKryptElement bluKryptElement, InputStream inputStream, ChunkFileElement fileElement, boolean b, String indexPath, String fileTmpPath) {
        this.logger.debug(IN_UPLOAD_CHUNKABLE_FILE_FOR_SYNC + fileElement.getFileName());
        Map<String, String> chunkChecksumMap = new HashMap<String, String>();
        try {
            String convertedPath = this.convertToServerPath(fileElement.getFileCompletePath(), bluKryptElement.getOsType());
            fileElement.setFileCompletePath(convertedPath);
            this.logger.debug(bluKryptElement.getFilePath() + COMPLETE_PATH + convertedPath);
            int[] chunkDetails = this.syncUploadService.getChunkSizeForSyncUser(1, cloudName, bluKryptElement.getUserName());
            chunkChecksumMap = this.uploadSyncFileForPortal(chunkDetails, cloudName, inputStream, fileElement, indexPath, bluKryptElement.getUserName(), fileTmpPath);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(EXCEPTION_IN_UPLOADCHUNKABLEFILE_TO_BACKUP + fileElement.getFileName(), (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return chunkChecksumMap;
    }
}

