/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service;

import com.google.common.util.concurrent.RateLimiter;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.pg.domain.BackupFile;
import com.pg.domain.ChunkFile;
import com.pg.domain.ContentChunkFile;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.FileStatusElement;
import com.pg.element.PciAuthorizationTokenElement;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;

public interface UploadService {
    public boolean saveFileInfo(String var1, String var2, FileInfo var3);

    public void saveFileInfoBusy(String var1, String var2, FileInfo var3);

    public BackupFile getBackupFile(String var1, String var2, String var3, String var4);

    public void deleteBackupFile(String var1, String var2, String var3, String var4);

    public String getOneDriveAccessToken(PciAuthorizationTokenElement var1);

    public FileInfo getFileInfo(String var1, String var2, String var3, String var4);

    public FileInfo getBackupFileInfo(String var1, String var2, String var3, String var4);

    public boolean saveFileInfoForSync(String var1, String var2, FileInfo var3);

    public void deleteUploadedFiles(FileInfo var1, String var2);

    public FileStatusElement uploadAllFilesToCloud(String var1, FileInfo var2, Cloud var3, RateLimiter var4);

    public FileInfo getFileFromPG(String var1, String var2, String var3, boolean var4);

    public void updateFileInfo(String var1, String var2, FileInfo var3);

    public void moveFailedFilesToBkpQueue(String var1, FileInfo var2, boolean var3);

    public boolean restoreQueue(FileInfo var1, Cloud var2);

    public boolean deleteFileInfoFromReBackup(String var1, ObjectId var2);

    public List<FileInfo> getFilesForUpload(String var1, boolean var2);

    public List<FileInfo> getFaileFilesForReUpload(String var1);

    public void restoreFailedFiles(FileInfo var1, Cloud var2);

    public void removeSyncFile(int var1, String var2, String var3);

    public void removeSyncBackUpImage(int var1, String var2);

    public void removeBackupFile(int var1, String var2, String var3);

    public void updateUploadedChunks(String var1, Map<String, ChunkFile> var2, FileInfo var3);

    public boolean saveFileInfoForODB(String var1, String var2, FileInfo var3, String var4, boolean var5);

    public void removeFileInfoForAlreadyExists(String var1, boolean var2, String var3);

    public void removeBackupFromTempDb(Cloud var1, ObjectId var2);

    public void restoreSyncFailedFiles(FileInfo var1, Cloud var2);

    public BackUpImage getBkpFileByIdAndDevice(int var1, ObjectId var2, Device var3);

    public void saveImageToBackUp(int var1, BackUpImage var2, Device var3);

    public boolean restoreOneFileForBlackListUser(String var1, Cloud var2);

    public StringBuilder checkOdbFolders(Cloud var1, StringBuilder var2);

    public BackupPolicy getBackupPolicyForUser(int var1, String var2);

    public OfficeBackupPolicy getOfficeBackupPolicyForUser(int var1, String var2);

    public List<EventHub> getEventHubForDeviceUUID(int var1, String var2);

    public List<BackUpImage> getVersions(int var1, String var2, String var3, String var4, Device var5);

    public boolean saveContentChunkFileInfo(String var1, String var2, ContentChunkFile var3, boolean var4);

    public List<ContentChunkFile> getFilesForContentChnkStatus(String var1, String var2, int var3);

    public void updateStatusOfContentChnkFile(String var1, ContentChunkFile var2, String var3, List<ContentChunkFile> var4, String var5);

    public void removeContentChunkTableFromMongo(String var1, String var2);

    public ContentChunkFile getContentChunkFileInfo(String var1, String var2, String var3);

    public boolean removeContentChunkFileByName(String var1, String var2, String var3);

    public boolean removeContentChunkFileInfoInMongo(ContentChunkFile var1, String var2, String var3);

    public void deleteTablenChunkEntriesIfExistsWithSameHash(String var1);

    public boolean isCollExists(String var1);

    public boolean moveChunkDetailFromTempColl(String var1);

    public void moveFailedFilesToBkpQueueAndDeleteInLocal(String var1, FileInfo var2, boolean var3);

    public void moveFailedFilesToDiffQueueAndDeleteInLocal(String var1, FileInfo var2, boolean var3);

    public void addFailedFiles(DriveFileInfo var1, String var2);

    public List<DriveFileInfo> getFailedFiles(String var1);

    public FileInfo getFileFromPG(String var1, String var2);

    public void checkAzureBlobConnection(Cloud var1);

    public boolean deleteUserFolderInsidePB(ChunkDetail var1);

    public MiniCloud getMiniCloudById(int var1, String var2);

    public OfficeBackupPolicy getOfficeBackupPolicyForUserSite(int var1, String var2);

    public OfficeBackupPolicy getOfficeBackupPolicyForUserDeviceProduct(int var1, String var2, String var3);

    public FileInfo getFileInfoForBatch(String var1, String var2);

    public CMBackUpImage getCMBackupImage(String var1, String var2, String var3);

    public void deleteCPMgtImage(int var1, ObjectId var2, String var3);

    public void saveFileInfoBusy(String var1, String var2, CMBackUpImage var3);

    public FileStatusElement createLinks(Cloud var1, CMBackUpImage var2, String var3);

    public List<CMBackUpImage> getFilesForArchiving(String var1, boolean var2, String var3);

    public void moveCPMgtImage(int var1, CMBackUpImage var2, String var3);

    public boolean isStopBackupBasedOnBlobFuse(int var1, Cloud var2);
}

