/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.pcbd.dao.impl.DeviceDaoImpl;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MailAttachment;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.pg.domain.FileInfo;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.element.RestoreElementList;
import com.pg.element.SharedFileImageElement;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.BackupService;
import com.pg.service.DownloadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DownloadController {
    private static Logger logger = LogManager.getLogger(DownloadController.class);
    private static final String FILE_NOT_FOUND = " file not found  ...........";
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private UtilService utilService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private DeviceDaoImpl deviceDaoImpl;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";

    @RequestMapping(value={"/download/externalFile/"}, method={RequestMethod.GET})
    public ResponseEntity<SharedFileImageElement> downloadExternalFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("  DOWNLOAD ExternalFile  STARTED ....");
        SharedFileImageElement element = new SharedFileImageElement();
        try {
            String fileName = request.getHeader("file-name");
            String folderPath = request.getHeader("file-path");
            String deviceUUID = request.getHeader("deviceUUID");
            String cloudName = request.getHeader("cloudName");
            String userName = request.getHeader("userName");
            String backupId = request.getHeader("backupId");
            String gatewayName = "db-001.parablu.com";
            PciAuthorizationTokenElement pciAuthorizationTokenElement = this.getPciAuthorizationTokenElement(cloudName, userName);
            String saltKey = this.getEncryptedKey(cloudName);
            logger.debug("  SALT KEY ..................... " + saltKey);
            DownloadTO downloadTO = this.downloadService.restoreFileForExternalStorage(pciAuthorizationTokenElement, fileName, folderPath, saltKey, deviceUUID, backupId, gatewayName, true);
            response.addHeader("file-size", String.valueOf(downloadTO.getSize()));
            response.setStatus(200);
            response.addHeader("fileMD5", downloadTO.getMd5());
            element.setFileName(fileName);
            element.setCloudName(cloudName);
            element.setUserName(userName);
            element.setSharedForDownload(true);
            element.setSharedTimeStamp(System.currentTimeMillis());
            element.setDevicePath("download/filename");
            logger.debug(fileName + "  DOWNLOAD ExternalFile  Completed ...." + userName);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("  DOWNLOAD ExternalFile  Completed ....");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    private PciAuthorizationTokenElement getPciAuthorizationTokenElement(String cloudName, String userName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("userName", userName);
        org.springframework.http.HttpEntity entity = new org.springframework.http.HttpEntity((Object)"parameters", (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/pcitoken";
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, PciAuthorizationTokenElement.class, new Object[0]);
        PciAuthorizationTokenElement pciAuthorizationTokenElement = (PciAuthorizationTokenElement)result.getBody();
        pciAuthorizationTokenElement.setUserName(userName);
        pciAuthorizationTokenElement.setCloudName(cloudName);
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting PCI Authorization Token Element :" + e.getMessage());
        }
        return pciAuthorizationTokenElement;
    }

    @RequestMapping(value={"/ping1"}, method={RequestMethod.GET})
    public ResponseEntity<SharedFileImageElement> testping() {
        logger.debug(" Inside privacy gateway ....");
        SharedFileImageElement element = new SharedFileImageElement();
        logger.debug(" end of privacy gateway ....");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncryptedKey(String cloudName) {
        logger.debug(" getEncryptedKey ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        HttpPost httpPost = null;
        String saltKey = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/load/encryptionKey/";
        httpPost = new HttpPost(url);
        HttpResponse response = null;
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"saltKey".equals(header.getName())) continue;
                saltKey = header.getValue();
                logger.debug("Recieved backup Id for file ..... " + saltKey);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Encyption Key :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return saltKey;
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/portal/restoretoonedrive"}, method={RequestMethod.GET})
    public void restoreToOnedriveFromPortal(HttpServletRequest request, HttpServletResponse response) {
        String restoreDeletedFileStr;
        logger.debug("calling  new API..../download/files/");
        ArrayList<RestoreElement> restoreElements = new ArrayList<RestoreElement>();
        RestoreElement restoreElement = this.getRestoreElementFromRequesttoFLS(request);
        restoreElements.add(restoreElement);
        Cloud cloud = this.utilService.getCloud(1);
        Device device = this.utilService.getDeviceForUUID(1, restoreElement.getDeviceUUID());
        String serverModifiedTime = "";
        boolean isrestoreDeletedFile = false;
        if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
            serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
        }
        if (!StringUtils.isEmpty((String)(restoreDeletedFileStr = request.getHeader("restoreDeletedFile")))) {
            isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
        }
        this.backupService.getChildrenForAgent(1, cloud.getCloudName(), restoreElement.getDevicePath(), device, true, serverModifiedTime, isrestoreDeletedFile);
        this.downloadFiles(request, response, restoreElements, true);
    }

    @RequestMapping(value={"/download/files/"}, method={RequestMethod.GET})
    public void downloadAllFilesForDevicePath(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling ..../download/files/");
        ArrayList<RestoreElement> restoreElements = new ArrayList<RestoreElement>();
        RestoreElement restoreElement = this.getRestoreElementFromRequesttoFLS(request);
        restoreElements.add(restoreElement);
        String sourceDeviceUUID = request.getHeader("sourceDeviceUUID");
        logger.debug("........sourceDeviceUUID......." + sourceDeviceUUID);
        Device device = this.deviceDaoImpl.getDeviceInfoByUUID(1, restoreElement.getCloudName(), sourceDeviceUUID);
        if (device.isQuarantineDevice()) {
            logger.debug("........DEVICE_QUARANTINED........" + sourceDeviceUUID);
            response.setStatus(452);
            return;
        }
        this.downloadFiles(request, response, restoreElements, false);
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/download/files"}, method={RequestMethod.GET})
    public void downloadAllFilesForDevicePathForFLS(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling  new API..../download/files/");
        ArrayList<RestoreElement> restoreElements = new ArrayList<RestoreElement>();
        RestoreElement restoreElement = this.getRestoreElementFromRequesttoFLS(request);
        restoreElements.add(restoreElement);
        String sourceDeviceUUID = request.getHeader("sourceDeviceUUID");
        logger.debug("........sourceDeviceUUID......." + sourceDeviceUUID);
        Device device = this.deviceDaoImpl.getDeviceInfoByUUID(1, restoreElement.getCloudName(), sourceDeviceUUID);
        if (device.isQuarantineDevice()) {
            logger.debug("........DEVICE_QUARANTINED........" + sourceDeviceUUID);
            response.setStatus(452);
            return;
        }
        this.downloadFiles(request, response, restoreElements, true);
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/download/files/all"}, method={RequestMethod.POST})
    public void downloadAllFilesForDevicePathForFLSAll(@PathVariable(value="cloudName") String cloudName, @RequestBody RestoreElementList restoreElementList, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling  new API..../download/files/all");
        String sourceDeviceUUID = request.getHeader("sourceDeviceUUID");
        Device device = this.deviceDaoImpl.getDeviceInfoByUUID(1, cloudName, sourceDeviceUUID);
        if (device.isQuarantineDevice()) {
            logger.debug("........DEVICE_QUARANTINED........" + sourceDeviceUUID);
            response.setStatus(452);
            return;
        }
        this.downloadFiles(request, response, restoreElementList.getRestoreElements(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles(HttpServletRequest request, HttpServletResponse response, List<RestoreElement> restoreElements, boolean isEncodeEnable) {
        String restorePath = "";
        String deviceMntPath = "";
        boolean isrestoreDeletedFile = true;
        int skipValue = 0;
        long count = 0L;
        long downloadedCount = 0L;
        long restoredFoldersCount = 0L;
        long foldersToRestoreCount = 0L;
        long restoredSize = 0L;
        long totalRestorableSize = 0L;
        try {
            BackupBatch lastRestoreBatch;
            Device device;
            logger.debug("Restore Elements : " + restoreElements.size());
            String sourceDeviceUUID = request.getHeader("sourceDeviceUUID");
            logger.debug("................." + request.getHeader("sourceDeviceUUID"));
            String isChunkLevelRestore = request.getHeader("restore-by-chunks");
            String skipValueStr = request.getHeader("skip-value");
            String countStr = request.getHeader("count");
            boolean isSync = false;
            if (!StringUtils.isEmpty((String)request.getHeader("isSync"))) {
                isSync = Boolean.parseBoolean(request.getHeader("isSync"));
            }
            String serverModifiedTime = "";
            if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
                serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
            }
            String isImmediateFolderLevel = request.getHeader("immediate-folder-level");
            if (!StringUtils.isEmpty((String)skipValueStr)) {
                skipValue = Integer.valueOf(skipValueStr);
            }
            if (!StringUtils.isEmpty((String)countStr)) {
                downloadedCount = Long.valueOf(countStr);
            }
            String restoredFoldersCountStr = request.getHeader("restored-folders-count");
            String foldersToRestoreCountStr = request.getHeader("folders-to-restore-count");
            String restoredSizeStr = request.getHeader("restored-size");
            String totalRestorableSizeStr = request.getHeader("totalRestorableSize");
            String restoreDeletedFileStr = request.getHeader("restoreDeletedFile");
            if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
            }
            logger.debug("...isrestoreDeletedFile..." + isrestoreDeletedFile);
            logger.debug("...restoredFoldersCountStr..." + restoredFoldersCountStr);
            logger.debug("...foldersToRestoreCountStr..." + foldersToRestoreCountStr);
            logger.debug("...restoredSizeStr..." + restoredSizeStr);
            logger.debug("...totalRestorableSize..." + totalRestorableSizeStr);
            if (!StringUtils.isEmpty((String)restoredFoldersCountStr)) {
                restoredFoldersCount = Long.valueOf(restoredFoldersCountStr);
            }
            if (!StringUtils.isEmpty((String)foldersToRestoreCountStr)) {
                foldersToRestoreCount = Long.valueOf(foldersToRestoreCountStr);
            }
            if (!StringUtils.isEmpty((String)restoredSizeStr)) {
                restoredSize = Long.valueOf(restoredSizeStr);
            }
            if (!StringUtils.isEmpty((String)totalRestorableSizeStr)) {
                totalRestorableSize = Long.valueOf(totalRestorableSizeStr);
            }
            if (totalRestorableSize != 0L) {
                totalRestorableSize = totalRestorableSize / 1000L * 1024L;
            }
            this.updateRestoreProgress(restoredFoldersCount, foldersToRestoreCount, restoredSize, sourceDeviceUUID, totalRestorableSize);
            Cloud cloud = this.utilService.getCloudDetails();
            String userName = "";
            if (isSync) {
                device = this.utilService.getDeviceDetails(sourceDeviceUUID);
                if (device != null) {
                    userName = device.getUserName();
                }
            } else {
                device = this.utilService.getDeviceDetails(restoreElements.get(0).getDeviceUUID());
                if (device != null) {
                    userName = device.getUserName();
                }
            }
            logger.debug("##Start of full restore of device .... " + userName + " ... device .... " + sourceDeviceUUID);
            try {
                response.setContentType("text/html; charset=UTF-8");
                response.getOutputStream().println("Content-Type: multipart/form-data;boundary=--PARABLUEOF");
            }
            catch (IOException e2) {
                logger.trace("" + e2);
                logger.error("Exception While Downloading All Files For Device Path :" + e2.getMessage());
            }
            boolean downloadCompleted = false;
            HashMap<String, Long> fileVersionMap = new HashMap<String, Long>();
            if (StringUtils.isNotEmpty((String)sourceDeviceUUID) && (lastRestoreBatch = this.utilService.getLastRestoreBatch(1, sourceDeviceUUID)) != null && StringUtils.isNotEmpty((String)lastRestoreBatch.getErrorCode())) {
                logger.debug("............batch......." + lastRestoreBatch.getErrorCode());
                if (lastRestoreBatch.getErrorCode().equalsIgnoreCase(STOP_BACKUP_ERROR_CODE) || lastRestoreBatch.getErrorCode().equalsIgnoreCase("429")) {
                    response.setStatus(429);
                    downloadCompleted = true;
                }
            }
            while (!downloadCompleted) {
                downloadedCount = StringUtils.isEmpty((String)isChunkLevelRestore) ? this.downloadService.restoreFilesFromCloud(cloud, restoreElements, userName, response, skipValue, count, downloadedCount, fileVersionMap, isEncodeEnable, serverModifiedTime) : this.downloadService.restoreFilesFromCloudNew(cloud, restoreElements, userName, response, skipValue, count, downloadedCount, fileVersionMap, isImmediateFolderLevel, isEncodeEnable, serverModifiedTime, isrestoreDeletedFile, isSync);
                ++skipValue;
                if (isSync) {
                    downloadedCount = -1L;
                }
                if (!StringUtils.isEmpty((String)restoreElements.get(0).getBackupId())) {
                    downloadedCount = -1L;
                }
                if ((downloadedCount = -1L) == -1L) {
                    response.setHeader("isDownloadComplete", Boolean.TRUE.toString());
                    downloadCompleted = true;
                    logger.error("Download completed .... ");
                } else {
                    response.setHeader("isDownloadComplete", Boolean.FALSE.toString());
                    logger.error(downloadedCount + " ... Download not completed .... " + skipValue);
                }
                if (StringUtils.isNotEmpty((String)sourceDeviceUUID) && (lastRestoreBatch = this.utilService.getLastRestoreBatch(1, sourceDeviceUUID)) != null && StringUtils.isNotEmpty((String)lastRestoreBatch.getErrorCode())) {
                    logger.debug("............batch......." + lastRestoreBatch.getErrorCode());
                    if (lastRestoreBatch.getErrorCode().equalsIgnoreCase(STOP_BACKUP_ERROR_CODE) || lastRestoreBatch.getErrorCode().equalsIgnoreCase("429")) {
                        response.setStatus(429);
                        break;
                    }
                }
                if (response.getStatus() != 451) continue;
                logger.debug("file download failed file md5 is blocked >>>>>>>>>>>$$$$$$$$$$$$ ");
            }
            response.getOutputStream().println();
            response.getOutputStream().write("----PARABLUEOF--\r\n".getBytes());
            response.getOutputStream().close();
        }
        catch (BlukryptClientAbortException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception", (Throwable)e);
            logger.error("Client aborted ........" + e.getErrMsg());
            response.setStatus(500);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception", (Throwable)e);
            logger.error("  UNALBE TO DOWNLOAD FILE ", (Throwable)e);
            response.setStatus(500);
        }
        finally {
            try {
                logger.debug(restorePath + " inside finally block ..... " + deviceMntPath);
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Exception", (Throwable)e);
                logger.error("Client abort exception ......" + e.getMessage());
            }
        }
        logger.debug(" download completed .... ");
    }

    private void updateRestoreProgress(long restoredFoldersCount, long foldersToRestoreCount, long restoredSize, String sourceDeviceUUID, long totalRestorableSize) {
        if (foldersToRestoreCount != 0L && !StringUtils.isEmpty((String)sourceDeviceUUID)) {
            logger.debug("......saving.....");
            RestoreProgressEvents events = new RestoreProgressEvents();
            events.setDeviceUUID(sourceDeviceUUID);
            events.setTotalsize(restoredSize);
            events.setTotalNoOfFilesForRestore(foldersToRestoreCount);
            events.setTotalNoOfRestoreFilesForFolder(restoredFoldersCount);
            events.setTotalRestorableSize(totalRestorableSize);
            this.utilService.saveOrUpdateRestoreForEndPoint(1, events);
        }
    }

    private void deleteDirs(String restorePath, String deviceMntPath) {
        File restoreDir;
        if (!StringUtils.isEmpty((String)restorePath) && (restoreDir = new File(restorePath)).exists()) {
            try {
                FileUtils.forceDelete((File)restoreDir);
            }
            catch (IOException e1) {
                logger.debug(" Unable to delete ... " + e1);
                logger.error(" Unable to delete ... " + e1.getMessage());
                logger.error(" unable to delete ... " + restoreDir);
            }
        }
    }

    private RestoreElement getRestoreElementFromRequesttoFLS(HttpServletRequest request) {
        RestoreElement restoreElement = new RestoreElement();
        String deviceUUID = request.getHeader("deviceUUID");
        String cloudName = request.getHeader("cloudName");
        String restoreId = request.getHeader("restoreBatchId");
        String headerEncoding = request.getHeader("header-encoding");
        String devicePath = request.getHeader("devicePath");
        String fileName = request.getHeader("fileName");
        String restoreToODB = request.getHeader("restore-to-onedrive");
        String restoreStartTime = request.getHeader("restore-start-timestamp");
        if (!StringUtils.isEmpty((String)restoreStartTime)) {
            restoreElement.setRestoreStartTime(restoreStartTime);
        }
        if (!StringUtils.isEmpty((String)restoreToODB)) {
            restoreElement.setRestoreToOnedrive(Boolean.parseBoolean(restoreToODB));
        }
        if (StringUtils.isNotEmpty((String)headerEncoding)) {
            if (!"base64".equalsIgnoreCase(headerEncoding) || StringUtils.isNotEmpty((String)devicePath)) {
                // empty if block
            }
            if (!"base64".equalsIgnoreCase(headerEncoding) || StringUtils.isNotEmpty((String)fileName)) {
                // empty if block
            }
        }
        String downloadAllVersions = request.getHeader("downloadAllVersions");
        String backupId = request.getHeader("backupId");
        boolean isDownloadAllVersions = false;
        if (!StringUtils.isEmpty((String)downloadAllVersions)) {
            isDownloadAllVersions = Boolean.parseBoolean(request.getHeader("downloadAllVersions"));
        }
        restoreElement.setDeviceUUID(deviceUUID);
        restoreElement.setCloudName(cloudName);
        restoreElement.setRestoreBatchId(restoreId);
        restoreElement.setDevicePath(devicePath);
        restoreElement.setFileName(fileName);
        restoreElement.setDownloadAllVersions(isDownloadAllVersions);
        restoreElement.setBackupId(backupId);
        return restoreElement;
    }

    @RequestMapping(value={"download/frompg/"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> downloadFromPG(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath = request.getHeader("filePath");
        logger.error("start download/frompg/ path .........." + filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            logger.debug(FILE_NOT_FOUND + filePath);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        byte[] array = Files.readAllBytes(file.toPath());
        ResponseEntity entity = new ResponseEntity((Object)array, HttpStatus.OK);
        logger.error("end of  download/frompg/ ... ...........");
        return entity;
    }

    @RequestMapping(value={"get/fileInfo/"}, method={RequestMethod.GET})
    public ResponseEntity<FileInfo> getFileInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cloudName = request.getHeader("cloudName");
        String backupId = request.getHeader("backupId");
        logger.error(backupId + " get/fileInfo/  ..........." + cloudName);
        String cloudNameParam = request.getParameter("cloudName");
        String backupIdParam = request.getParameter("backupId");
        logger.error(backupIdParam + " get/fileInfo/param  ..........." + cloudNameParam);
        FileInfo fileInfo = this.uploadService.getBackupFileInfo(cloudName, "", "", backupId);
        if (fileInfo == null) {
            logger.debug(cloudName + FILE_NOT_FOUND + backupId);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        ResponseEntity entity = new ResponseEntity((Object)fileInfo, HttpStatus.OK);
        logger.error(" end of get/fileInfo/  ... ...........");
        return entity;
    }

    @RequestMapping(value={"get/user/fileInfo/"}, method={RequestMethod.GET})
    public ResponseEntity<FileInfo> getUserFileInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cloudName = request.getHeader("cloudName");
        String userName = request.getHeader("userName");
        String backupId = request.getHeader("backupId");
        logger.error(backupId + " get/fileInfo/  ..........." + cloudName + "...userName.." + userName);
        logger.debug(cloudName + FILE_NOT_FOUND + backupId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/fileInfo/details"}, method={RequestMethod.GET})
    public ModelAndView getFileDetails(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        String deviceUUID = request.getHeader("deviceUUID");
        String userName = request.getHeader("userName");
        String odItemId = request.getHeader("odItemId");
        String attachName = request.getHeader("attachName");
        String mailFoldPath = request.getHeader("mailFoldPath");
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        boolean rapidRestoreLink = false;
        deviceUUID = this.decodeBase64UTFString(deviceUUID);
        userName = this.decodeBase64UTFString(userName);
        odItemId = this.decodeBase64UTFString(odItemId);
        attachName = this.decodeBase64UTFString(attachName);
        mailFoldPath = this.decodeBase64UTFString(mailFoldPath);
        logger.error(userName + " /fileInfo/details  ..........." + deviceUUID + "...userName.." + odItemId);
        logger.debug("....path latest....." + mailFoldPath);
        logger.debug("....attach name....." + attachName);
        Device device = this.utilService.getDeviceForUUID(cloudId, deviceUUID);
        BackUpImage backUpImage = null;
        if ("noDevicePath".equals(mailFoldPath)) {
            rapidRestoreLink = true;
            backUpImage = this.utilService.getBackupImageFile(cloudId, odItemId, device);
        } else {
            backUpImage = this.utilService.getBackupImageForItemIdConversion(cloudId, odItemId, device.getDestCollection(), deviceUUID);
        }
        if (backUpImage == null || !rapidRestoreLink && backUpImage.isLinkDeleted()) {
            response.setStatus(204);
            logger.debug("...no content....");
        } else if (rapidRestoreLink) {
            String filePath;
            String fileName = backUpImage.getFileName();
            if (!StringUtils.isEmpty((String)fileName)) {
                fileName = this.encodeBase64UTFString(fileName);
            }
            if (!StringUtils.isEmpty((String)(filePath = backUpImage.getDevicePath()))) {
                filePath = this.encodeBase64UTFString(filePath);
            }
            response.setHeader("cloudName", cloud.getCloudName());
            response.setHeader("backupID", backUpImage.getId().toString());
            response.setHeader("fileName", fileName);
            response.setHeader("filePath", filePath);
            response.setHeader("size", "" + backUpImage.getSize());
            response.setHeader("sizeInBytes", "" + backUpImage.getSizeInBytes());
            response.setHeader("gatewayName", PCHelperConstant.getComponentName());
            response.setHeader("lastServerModifiedTime", "" + backUpImage.getLastServerModifiedTime());
            response.setStatus(200);
        } else {
            String filePath;
            logger.debug("...content-exists....");
            String fileName = backUpImage.getFileName();
            if (!StringUtils.isEmpty((String)fileName)) {
                fileName = this.encodeBase64UTFString(fileName);
            }
            if (!StringUtils.isEmpty((String)(filePath = backUpImage.getDevicePath()))) {
                filePath = this.encodeBase64UTFString(filePath);
            }
            logger.debug("...content-exists1....");
            response.setHeader("cloudName", cloud.getCloudName());
            response.setHeader("backupID", backUpImage.getId().toString());
            response.setHeader("fileName", fileName);
            response.setHeader("filePath", filePath);
            response.setHeader("attachName", attachName);
            response.setHeader("productType", device.getDeviceType());
            logger.debug("...content-exists2....");
            long size = 0L;
            if (!CollectionUtils.isEmpty((Collection)backUpImage.getAttachments())) {
                for (MailAttachment attachment : backUpImage.getAttachments()) {
                    if (!attachment.getName().equalsIgnoreCase(attachName)) continue;
                    size = attachment.getSize().intValue();
                }
            }
            logger.debug(attachName + "....size to download...." + size);
            if (StringUtils.isEmpty((String)attachName) || attachName.equalsIgnoreCase("EMPTY")) {
                size = backUpImage.getSizeInBytes();
            }
            response.setHeader("sizeInBytes", "" + size);
            response.setHeader("gatewayName", PCHelperConstant.getComponentName());
            response.setHeader("lastServerModifiedTime", "" + backUpImage.getLastServerModifiedTime());
            response.setHeader("mailFoldPath", "" + mailFoldPath);
            response.setStatus(200);
        }
        return modelAndView;
    }

    protected String encodeBase64UTFString(String value) {
        String encodedString = value;
        try {
            encodedString = new String(Base64.encodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return encodedString;
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }
}

