/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.impl.DeviceDaoImpl;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlockedDeviceUser;
import com.parablu.pcbd.domain.BluKryptStorageMapping;
import com.parablu.pcbd.domain.C2CAppSettings;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.CPBackupBatch;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.DeletedBackupFile;
import com.parablu.pcbd.domain.DeletedUser;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupJob;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSToken;
import com.parablu.pcbd.domain.EncryptionKey;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.FailedFileInfo;
import com.parablu.pcbd.domain.FailedFileReason;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.OTPValidation;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.ReBackUpImage;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.SIEMCredentials;
import com.parablu.pcbd.domain.SIEMHistory;
import com.parablu.pcbd.domain.SuperAdminAuditHistory;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.dao.UtilDao;
import com.pg.domain.BackupAttempt;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.MailRestoreFileInfo;
import com.pg.domain.OfficeRestoreFileInfo;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class UtilDaoImpl
implements UtilDao {
    private static Logger logger = LogManager.getLogger(UtilDaoImpl.class);
    private static final String ENDTIMESTAMP = "endTimestamp";
    private static final String USER_NAME = "userName";
    private static final String FOLDER_TYPE = "folderType";
    private static final String DEVICE_PATH = "devicePath";
    private static final String FILE_NAME = "fileName";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String ACTION_TO_USER_NAME = "actionToUserName";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private static final String ACTION_STATUS = "actionStatus";
    private static final String ACTION = "action";
    private static final String STATUS_STARTED = "STARTED";
    private static final String STATUS_FAILED = "FAILED";
    private static final String JOB_TYPE = "jobType";
    private static final String BACK_UP = "BACKUP";
    private static final String STATUS = "status";
    private static final String BATCH_END_TIME_STAMP = "batchEndTimestamp";
    private static final String BATCH_START_TIME_STAMP = "batchStartTimestamp";
    private static final String DEVICEUUID = "deviceUUID";
    private static final String RESTORE = "RESTORE";
    private static final String COMPLETED = "COMPLETED";
    private static final String COUNT = "count";
    private static final String BACKUP_BATCH = "BACKUP_BATCH";
    private static final String USER_NAME_LOWER_CASE = "userNameLowerCase";
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    public static final int CHUNK_TOTAL_DB_COUNT = PCHelperConstant.getChunkTotalBuckets();
    private static final String PRIVACY_GATEWAY_SYNC = "privacy_gateway_sync_";
    private static final String COMPONENT_NAME = "componentName";
    private static HashMap<String, Set<String>> superAdminMap = null;
    private MongoOperations mongoAuditOps;
    private MongoOperations mongoOps;
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private MongoOperations blukrypytMongoTemplate;

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    public MongoOperations getBlukrypytMongoTemplate() {
        return this.blukrypytMongoTemplate;
    }

    public void setBlukrypytMongoTemplate(MongoOperations blukrypytMongoTemplate) {
        this.blukrypytMongoTemplate = blukrypytMongoTemplate;
    }

    @Override
    public BackupPolicy getBackupPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserForName(int cloudId, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public User getUserInfo(int cloudId, String cloudName, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        return (User)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public BackupFile getLastBackupFile(int cloudId, String cloudName, String userName) {
        BackupFile backupFile = null;
        try {
            String tableName = "privacy_gateway_od_" + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
            query.limit(1);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(" !!!!! ERROR TRYING TO getBackupFile ...." + e.getMessage());
        }
        return backupFile;
    }

    private void createCollectionIfNotExists(String tableName, MongoTemplate mongoTemplate) {
        try {
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception:" + e.getMessage());
        }
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokensForUserName(int cloudId, String userName) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
            pciAuthorizationTokens = (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public void registerJob(DeviceBackupJob deviceBackupJob, int cloudId) {
        logger.debug("registerJob(DeviceBackupJob deviceBackupJob, int cloudId) > BEGIN");
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)deviceBackupJob);
        logger.debug("registerJob(DeviceBackupJob deviceBackupJob, int cloudId) > END");
    }

    @Override
    public DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, ObjectId jobId) {
        logger.debug("DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, String containerName) > BEGIN");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID).and("id").is((Object)jobId);
        Query query = new Query((CriteriaDefinition)criteria);
        DeviceBackupJob deviceBackupJob = (DeviceBackupJob)mongoTemplate.findOne(query, DeviceBackupJob.class);
        logger.debug("DeviceBackupJob getDeviceBackupJob(int cloudId, String deviceUUID, String containerName) > BEFORE RETURN > deviceBackupJob > " + deviceBackupJob);
        return deviceBackupJob;
    }

    @Override
    public EncryptionKey getEncryptionKey(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ENDTIMESTAMP).is((Object)0), Criteria.where((String)"productType").is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    @Override
    public EncryptionKey getKeyForDecrypt(int cloudId, long timeStamp, String productType) {
        Criteria criteria = new Criteria();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addStartAndEndDateBetweenCriteria(timeStamp, list);
        list.add(Criteria.where((String)"productType").is((Object)productType));
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (EncryptionKey)mongoTemplate.findOne(query, EncryptionKey.class);
    }

    private void addStartAndEndDateBetweenCriteria(Long timeStamp, List<Criteria> list) {
        Criteria criteria2 = Criteria.where((String)"startTimestamp").lte((Object)timeStamp);
        Criteria criteria3 = new Criteria().orOperator(new Criteria[]{Criteria.where((String)ENDTIMESTAMP).gte((Object)timeStamp), Criteria.where((String)ENDTIMESTAMP).is((Object)0)});
        list.add(criteria2);
        list.add(criteria3);
    }

    @Override
    public PciAuthorizationTokens getPciAuthorizationTokens(int cloudId) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List pciAuthorizationTokenList = paracloudMongoTemplate.findAll(PciAuthorizationTokens.class);
        if (!CollectionUtils.isEmpty((Collection)pciAuthorizationTokenList)) {
            pciAuthorizationTokens = (PciAuthorizationTokens)pciAuthorizationTokenList.get(0);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public long getDedupStartTime(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List cloudSettingsList = mongoTemplate.findAll(CloudSettings.class);
        if (CollectionUtils.isEmpty((Collection)cloudSettingsList)) {
            return 0L;
        }
        CloudSettings cloudSettings = (CloudSettings)cloudSettingsList.get(0);
        return cloudSettings.getDedupStartTime();
    }

    @Override
    public void updateBackBatch(int cloudId, String backupBatchId, int uploadedFiles, long totalSize, long numberOfFilesInfected) {
        logger.debug("....inside updateBackBatch...." + backupBatchId);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatchId);
        Query query = new Query((CriteriaDefinition)criteria);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        String currentUploadedFilesStatus = "";
        if (backupBatch != null) {
            if (StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                currentUploadedFilesStatus = uploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
            } else {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                    }
                    logger.debug(uploadedFiles + "...updateprevin...." + prevBkpFiles);
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            Long batchTotalSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                batchTotalSize = Long.valueOf(backupBatch.getUploadedSize());
                logger.debug("....inside 111...." + batchTotalSize);
            }
            long updatedTotalSize = 0L;
            if (batchTotalSize != null) {
                updatedTotalSize = batchTotalSize + totalSize;
            }
            Update update = new Update();
            logger.debug("...updatedTotalSize...." + updatedTotalSize);
            logger.debug("...numberOfFilesInfected...." + (numberOfFilesInfected += backupBatch.getEncryptedFilesSize()));
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set("uploadedSize", (Object)Long.toString(updatedTotalSize));
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            update.set("encryptedFilesSize", (Object)numberOfFilesInfected);
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
            this.updateBackupAttempt(cloudId, backupBatchId, uploadedFiles, totalSize);
        }
    }

    @Override
    public void updateInterruptedBackBatch(int cloudId, String deviceUUID) {
        logger.debug("device to update interrupt backup>>>>" + deviceUUID);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)STATUS_STARTED), Criteria.where((String)BATCH_START_TIME_STAMP).lt((Object)(System.currentTimeMillis() - (long)PCHelperConstant.getPGOverLoadInactivityPeriod()))});
        Query query = new Query((CriteriaDefinition)criteria);
        List backupBatchList = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)backupBatchList)) {
            logger.debug("backup batch list>" + backupBatchList.size());
            Update update = new Update();
            update.set(STATUS, (Object)BackupBatch.STATUS.INTERRUPTED);
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateMulti(query, update, BackupBatch.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"lastBkpStatus").is((Object)BackupBatch.STATUS.STARTED.toString())});
            query = new Query((CriteriaDefinition)criteria);
            update = new Update();
            update.set("lastBkpStatus", (Object)BackupBatch.STATUS.INTERRUPTED.toString());
            mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            for (BackupBatch backupBatch : backupBatchList) {
                BackupAttempt attempt = this.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                if (attempt == null || !attempt.getStatus().equals(BackupBatch.STATUS.STARTED.name())) continue;
                attempt.setBatchEndTimestamp(backupBatch.getBatchEndTimestamp());
                attempt.setStatus(BackupBatch.STATUS.INTERRUPTED.name().toUpperCase());
                attempt.setErrorCode("909");
                this.saveBackupAttempt(cloudId, attempt);
            }
        }
    }

    @Override
    public List<FailedFileInfo> getFailedFiles(int cloudId, String userName) {
        Query query;
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"gatewayName").is((Object)PCHelperConstant.getComponentName())});
            query = new Query((CriteriaDefinition)criteria).limit(500);
        } else {
            query = new Query().limit(500);
        }
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, FailedFileInfo.class);
    }

    @Override
    public void deleteFailedFile(int cloudId, String fileInfoId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(fileInfoId))});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, FailedFileInfo.class);
    }

    @Override
    public void saveFailedFile(int cloudId, FailedFileInfo failedFileInfo) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.save((Object)failedFileInfo);
    }

    @Override
    public List<String> getUnMappedUsersForOneDrive(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DistinctIterable distStr = mongoTemplate.getCollection("FAILED_FILES").distinct(USER_NAME, String.class);
        List list = IteratorUtils.toList((Iterator)distStr.iterator());
        return list;
    }

    private List<String> getCollectionsForBkpQuery(Device device) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)device.getDestCollection())) {
            queryTablesList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add(BACK_UP);
        }
        return queryTablesList;
    }

    private List<String> getCollectionsForSyncQuery(User user, MiniCloud miniCloud) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            queryTablesList.add(user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            queryTablesList.add(miniCloud.getSyncDestinationCollection());
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add(BACK_UP);
        }
        return queryTablesList;
    }

    @Override
    public BackUpImage getParentBackupImageForMd5(int cloudId, String md5, Device device) {
        String dest;
        List backupImageList;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5Checksum").is((Object)md5)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getCollectionsForBkpQuery(device);
        BackUpImage backUpImage = new BackUpImage();
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && ((backUpImage = (BackUpImage)(backupImageList = mongoTemplate.find(query, BackUpImage.class, dest = iterator.next())).stream().filter(bkpImage -> !StringUtils.isEmpty((String)bkpImage.getStoragePlace()) && !CollectionUtils.isEmpty(bkpImage.getChunkFiles())).findFirst().orElse(null)) == null || CollectionUtils.isEmpty(backUpImage.getChunkFiles()))) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getSyncParentBackUpImageForMd5(int cloudId, String md5, User user, MiniCloud miniCloud) {
        String dest;
        List backupImageList;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5Checksum").is((Object)md5)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        BackUpImage backUpImage = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && ((backUpImage = (BackUpImage)(backupImageList = mongoTemplate.find(query, BackUpImage.class, dest = iterator.next())).stream().filter(bkpImage -> !StringUtils.isEmpty((String)bkpImage.getStoragePlace()) && !CollectionUtils.isEmpty(bkpImage.getChunkFiles())).findFirst().orElse(null)) == null || CollectionUtils.isEmpty(backUpImage.getChunkFiles()))) {
        }
        return backUpImage;
    }

    @Override
    public void saveReBackupImage(int cloudId, ReBackUpImage reBackUpImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)reBackUpImage);
    }

    @Override
    public List<Device> getAllDevicesForUser(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public List<DeletedBackupFile> getAllDeletedBackupFiles(int cloudId, boolean isFolder) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"folder").is((Object)isFolder)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, DeletedBackupFile.class);
    }

    @Override
    public void deleteBackupFile(int cloudId, DeletedBackupFile deletedBackupFile) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deletedBackupFile.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, DeletedBackupFile.class);
    }

    @Override
    public List<BackUpImage> getAllChildFilesOfFolder(int cloudId, String devicePath, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(500);
        return mongoTemplate.find(query, BackUpImage.class, device.getDestCollection());
    }

    @Override
    public Device getDeviceInfoByUUID(int cloudId, String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList() {
        return null;
    }

    @Override
    public void saveBackupBatch(int cloudId, BackupBatch backupBatch) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupBatch);
    }

    @Override
    public void updateDeviceBackupOverView(int cloudId, DeviceBackupOverView overView) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)overView);
    }

    @Override
    public Long getFirstBackupEndDate(int cloudId, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Long bkpEndTime = null;
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)JOB_TYPE).is((Object)BACK_UP), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(criteria1);
        this.addUserNameCriteria(cloudId, userName, list);
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
            list.add(criteria4);
        }
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        if (backupBatch != null) {
            bkpEndTime = backupBatch.getBatchEndTimestamp();
        }
        return bkpEndTime;
    }

    @Override
    public Object[] getBackupDateHistoryElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[7];
        BackupBatch lastSuccessfulBatch = this.getLastSuccessfulWithoutTemplate(cloudId, cloudName, userName, deviceUUID, mongoTemplate);
        arr[0] = lastSuccessfulBatch != null ? Long.valueOf(lastSuccessfulBatch.getBatchEndTimestamp()) : null;
        BackupBatch firstBkpBatch = this.getFirstBackupWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        arr[1] = firstBkpBatch != null ? Long.valueOf(firstBkpBatch.getBatchStartTimestamp()) : null;
        BackupBatch lastBkpBatch = this.getLastBackupOnlyWithoutTemplate(cloudId, userName, deviceUUID, mongoTemplate);
        if (lastBkpBatch != null) {
            arr[2] = lastBkpBatch.getStatus();
            arr[3] = lastBkpBatch.getErrorCode();
            arr[4] = lastBkpBatch.getBatchStartTimestamp();
            this.setSummaryValues(lastBkpBatch, arr);
        } else {
            arr[2] = null;
            arr[3] = null;
            arr[4] = null;
            arr[5] = new Integer(0);
            arr[6] = new Integer(0);
        }
        return arr;
    }

    private void setSummaryValues(BackupBatch backupBatch, Object[] arr) {
        Integer totalNoOfFiles = 0;
        Integer noOfFilesRemaining = 0;
        if (backupBatch != null) {
            String uploadedFiles;
            if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
            }
            if (StringUtils.isEmpty((String)(uploadedFiles = backupBatch.getUploadedFiles()))) {
                uploadedFiles = "0/" + totalNoOfFiles;
            }
            String[] parts = uploadedFiles.split("/");
            try {
                Integer actualNoOfFiles = Integer.parseInt(parts[1]);
                Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
                noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
            }
            catch (Exception e) {
                logger.trace(" Exception  :" + e);
                logger.error(" Exception  :" + e.getMessage());
            }
        }
        arr[5] = totalNoOfFiles.toString();
        arr[6] = noOfFilesRemaining.toString();
    }

    private BackupBatch getLastSuccessfulWithoutTemplate(int cloudId, String cloudName, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = this.getBackupBatchCriteria(cloudId, cloudName, userName, deviceName);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        List list1 = mongoTemplate.find(query, BackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            return (BackupBatch)list1.get(0);
        }
        return null;
    }

    private Criteria getBackupBatchCriteria(int cloudId, String cloudName, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        Criteria criteria2 = Criteria.where((String)STATUS).is((Object)COMPLETED);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        list.add(criteria2);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        return criteria;
    }

    private void addDeviceNameCriteria(int cloudId, String deviceName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)deviceName)) {
            Criteria criteria4 = Criteria.where((String)"deviceName").is((Object)deviceName);
            list.add(criteria4);
        }
    }

    private void addUserNameCriteria(int cloudId, String userName, List<Criteria> list) {
        if (!StringUtils.isEmpty((String)userName)) {
            logger.debug(" NEWQUERY to avoid in query ...................");
            if (!StringUtils.isEmpty((String)userName)) {
                Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
                list.add(criteria3);
                logger.debug(" NEWQUERY to avoid in query userName..................." + userName);
            }
            logger.debug(" end of NEWQUERY to avoid in query  for backupbatch...................");
        }
    }

    private BackupBatch getFirstBackupWithoutTemplate(int cloudId, String userName, String deviceName, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        this.addUserNameCriteria(cloudId, userName, list);
        this.addDeviceNameCriteria(cloudId, deviceName, list);
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    private BackupBatch getLastBackupOnlyWithoutTemplate(int cloudId, String userName, String deviceUUID, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = Criteria.where((String)JOB_TYPE).is((Object)BACK_UP);
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria3 = Criteria.where((String)USER_NAME).is((Object)userName);
            list.add(criteria3);
            logger.debug(" user from controller..................." + userName);
        }
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            Criteria criteria4 = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
            list.add(criteria4);
            logger.debug("device from controller...");
        }
        list.add(criteria1);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public Object[] getCountForJobType(int cloudId, String deviceUUID, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)COMPLETED)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{JOB_TYPE}).count().as(COUNT), Aggregation.project((String[])new String[]{COUNT, JOB_TYPE})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        for (BasicDBObject dbObject : stateStatsList) {
            String jobType = (String)dbObject.get("_id");
            if (jobType.equalsIgnoreCase(RESTORE)) {
                arr[0] = Long.valueOf(dbObject.get(COUNT).toString());
            }
            if (!jobType.equalsIgnoreCase(BACK_UP)) continue;
            arr[1] = Long.valueOf(dbObject.get(COUNT).toString());
        }
        return arr;
    }

    @Override
    public List<OfficeBackupPolicy> getPolicyForBluKrypt(int cloudId) {
        logger.debug("......component name ,....." + PCHelperConstant.getComponentName());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"msAppBluKrypt").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{"_id"}));
        List list = mongoTemplate.find(query, OfficeBackupPolicy.class);
        return list;
    }

    @Override
    public void updateBackBatch(int cloudId, ObjectId backupBatchId, String status) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            update.set(STATUS, (Object)status);
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public void updateBackBatch(int cloudId, ObjectId backupBatchId, String status, int errorCode) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            update.set(STATUS, (Object)status);
            update.set("errorCode", (Object)("" + errorCode));
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public List<FailedFileInfo> getSyncFailedFiles(int cloudId, String userName) {
        Query query;
        if (!StringUtils.isEmpty((String)userName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"gatewayName").is((Object)PCHelperConstant.getComponentName())});
            query = new Query((CriteriaDefinition)criteria).limit(500);
        } else {
            query = new Query().limit(500);
        }
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, FailedFileInfo.class, "SYNC_FAILED_FILES");
    }

    @Override
    public void deleteSyncFailedFile(int cloudId, String fileInfoId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)new ObjectId(fileInfoId))});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, FailedFileInfo.class, "SYNC_FAILED_FILES");
    }

    @Override
    public List<String> getUnMappedSyncUsersForOneDrive(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DistinctIterable distStr = mongoTemplate.getCollection("FAILED_FILES").distinct(USER_NAME, String.class);
        List list = IteratorUtils.toList((Iterator)distStr.iterator());
        return list;
    }

    @Override
    public void saveAudit(int cloudId, AuditHistory audit) {
        Set<String> superAdminNames;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        boolean isSuperAdmin = false;
        if (superAdminMap == null || superAdminMap.isEmpty()) {
            this.initialiseMap(cloudId);
        }
        if (!CollectionUtils.isEmpty(superAdminNames = superAdminMap.get("superAdminMap"))) {
            for (String superAdminName : superAdminNames) {
                if (!superAdminName.equalsIgnoreCase(audit.getActionByUserName())) continue;
                isSuperAdmin = true;
                break;
            }
        }
        if (isSuperAdmin) {
            SuperAdminAuditHistory superAdminAudit = new SuperAdminAuditHistory();
            BeanUtils.copyProperties((Object)audit, (Object)superAdminAudit);
            this.mongoAuditOps.save((Object)superAdminAudit);
        } else {
            mongoTemplate.save((Object)audit);
        }
    }

    private synchronized void initialiseMap(int cloudId) {
        Set<String> superAdminNames;
        logger.debug("INITIALIZE cloud map............");
        if (superAdminMap == null) {
            superAdminMap = new HashMap();
        }
        if ((superAdminNames = this.getAllSuperAdmins(cloudId)) == null || superAdminNames.isEmpty()) {
            return;
        }
        if (!CollectionUtils.isEmpty(superAdminNames)) {
            superAdminMap.put("superAdminMap", superAdminNames);
            logger.debug("INITIALIZE superAdminNames ............" + superAdminNames);
        }
    }

    public Set<String> getAllSuperAdmins(int cloudId) {
        HashSet<String> superAdminNames = new HashSet<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"superAdmin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        List superAdmins = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)superAdmins)) {
            for (User user : superAdmins) {
                superAdminNames.add(user.getUserName());
            }
        }
        return superAdminNames;
    }

    public MongoOperations getMongoAuditOps() {
        return this.mongoAuditOps;
    }

    public void setMongoAuditOps(MongoOperations mongoAuditOps) {
        this.mongoAuditOps = mongoAuditOps;
    }

    @Override
    public void saveSyncFailedFile(int cloudId, FailedFileInfo failedFileInfo) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        failedFileInfo.setGatewayName(PCHelperConstant.getComponentName());
        paracloudMongoTemplate.save((Object)failedFileInfo, "SYNC_FAILED_FILES");
    }

    @Override
    public List<String> getAllUniqueBlackListUsersFromLocal(int cloudId, String cloudName) {
        String blackListCollectionName = this.getBlackListCollectionName(true, cloudName);
        blackListCollectionName = blackListCollectionName.toUpperCase();
        logger.debug("...collection tem... " + blackListCollectionName);
        DistinctIterable distStr = this.blukrypytMongoTemplate.getCollection(blackListCollectionName).distinct(USER_NAME, String.class);
        List<String> userNames = new ArrayList();
        if (distStr != null) {
            userNames = IteratorUtils.toList((Iterator)distStr.iterator());
        }
        logger.debug(distStr + "..... " + userNames.size());
        return userNames;
    }

    private static String getConvertDBCharacters(String dbName) {
        String convertedValue = dbName.replace(".", "_");
        convertedValue = convertedValue.replace("@", "_");
        convertedValue = convertedValue.replaceAll(" ", "_");
        convertedValue = convertedValue.replaceAll("/", "");
        return convertedValue;
    }

    private String getBlackListCollectionName(boolean isBackup, String cloudNameparam) {
        String cloudName = cloudNameparam.toLowerCase();
        String collectionName = isBackup ? "BLACK_LIST_" + cloudName + "_bkp" : "BLACK_LIST_" + cloudName + "_sync";
        collectionName = UtilDaoImpl.getConvertDBCharacters(collectionName);
        return collectionName;
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public OfficeBackupPolicy getODBBackupPolicy(int cloudId, String odbPolicyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)odbPolicyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)STATUS).is((Object)STATUS_STARTED)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MailBackupBatch)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public void saveMailBackupBatch(int cloudId, MailBackupBatch backupBatch, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)eventHub);
        mongoTemplate.save((Object)backupBatch);
    }

    @Override
    public List<MailBackupBatch> getMailBatchList(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"officePolicyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public List<MailRestoreFileInfo> getMailRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"mailBackupBatchId").is((Object)batchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), MailRestoreFileInfo.class);
    }

    @Override
    public void deleteMailRestoreBatch(int cloudId, ObjectId batchId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(new Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public void removeMailRestoreItem(int cloudId, ObjectId mailBackupBatchId, String backupId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupId").is((Object)backupId), Criteria.where((String)"mailBackupBatchId").is((Object)mailBackupBatchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(new Query((CriteriaDefinition)criteria), MailRestoreFileInfo.class);
    }

    @Override
    public void deleteEventHubRestoreForDeviceUUID(int cloudId, String deviceUUID, String action) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID), Criteria.where((String)ACTION).is((Object)"RESTORE_CREATED")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, EventHub.class);
        logger.debug("...removed eventhub.... " + action + "....." + deviceUUID + "......" + remove.getDeletedCount());
    }

    @Override
    public void saveRestoreFileInfo(int cloudId, MailRestoreFileInfo mailRestoreFileInfo) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)mailRestoreFileInfo);
    }

    @Override
    public void saveRestoreHistory(int cloudId, RestoreHistory restoreHistoy) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreHistoy);
    }

    @Override
    public RestoreHistory getRestoreHistoryById(int cloudId, ObjectId batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreHistory)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), RestoreHistory.class);
    }

    @Override
    public void saveRestoreEvents(int cloudId, RestoreEvents restoreEvents) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreEvents);
        RestoreProgressEvents restoreProgressEvents = new RestoreProgressEvents();
        restoreProgressEvents.setDeviceUUID(restoreEvents.getActionOnDeviceUUID());
        restoreProgressEvents.setUserName(restoreEvents.getActionBy());
        mongoTemplate.save((Object)restoreProgressEvents);
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)destinationFolder)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID), Criteria.where((String)"destinationFolder").is((Object)destinationFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEventsByDestUUIDForPst(int cloudId, String deviceUUID, String destinationFolder) {
        Criteria criteria = new Criteria();
        if (!StringUtils.isEmpty((String)destinationFolder)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID), Criteria.where((String)"destinationFolder").is((Object)destinationFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void deleteRestoreEventsByDestUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, RestoreEvents.class);
    }

    @Override
    public boolean checkActionIsPresent(int cloudId, EventHub eventHub) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_USER_NAME).is((Object)eventHub.getActionToUserName()), Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)eventHub.getActionToDeviceUUID()), Criteria.where((String)ACTION).is((Object)eventHub.getAction())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return Optional.ofNullable(mongoTemplate.findOne(query, EventHub.class)).isPresent();
    }

    @Override
    public void saveAction(int cloudId, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)eventHub);
    }

    @Override
    public List<RestoreEvents> getRestoreEventsList(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"officePolicyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), RestoreEvents.class);
    }

    @Override
    public List<OfficeRestoreFileInfo> getOfficeRestoreFileInfoFromListForBatchId(int cloudId, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"restoreEventId").is((Object)batchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), OfficeRestoreFileInfo.class);
    }

    @Override
    public void removeOfficeRestoreDriveItem(int cloudId, ObjectId restoreDriveItemId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)restoreDriveItemId));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, OfficeRestoreFileInfo.class);
    }

    @Override
    public void deleteRestoreEventForDeviceUUID(int cloudId, String deviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, RestoreEvents.class);
    }

    @Override
    public void updateEwsId(int cloudId, String backupId, String ewsId, String odItemId, String destCollection) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage findOne = (BackUpImage)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupId))), BackUpImage.class, destCollection);
        if (findOne != null) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"ewsId").is((Object)findOne.getEwsId()), Criteria.where((String)"odItemId").is((Object)findOne.getOdItemId())});
            query = new Query((CriteriaDefinition)criteria);
            List bkpImages = mongoTemplate.find(query, BackUpImage.class, destCollection);
            if (!CollectionUtils.isEmpty((Collection)bkpImages)) {
                for (BackUpImage backUpImage : bkpImages) {
                    if (backUpImage == null) continue;
                    logger.debug("...iterating id for update....." + backUpImage.getId().toString());
                    Update update = new Update();
                    update.set("ewsId", (Object)ewsId);
                    update.set("odItemId", (Object)odItemId);
                    criteria = Criteria.where((String)"id").is((Object)backUpImage.getId());
                    query = new Query((CriteriaDefinition)criteria);
                    mongoTemplate.updateFirst(query, update, BackUpImage.class, destCollection);
                }
            }
        }
    }

    @Override
    public RestoreProgressEvents getRestoreProgresByDeviceUUID(int cloudId, String deviceUUID, String actionBy) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)actionBy)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreProgressEvents)mongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void saveRestoreProgressForDevice(int cloudId, RestoreProgressEvents restoreProgressEvents) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)restoreProgressEvents);
    }

    public long getCountOfFileForPath(int cloudId, String deviceUUID, String filePath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"filePath").is((Object)filePath)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), OfficeRestoreFileInfo.class);
    }

    @Override
    public void updateRestoreProgress(int cloudId, int restoredFiles, int restoredSize, long currentFolderRestoredFiles, String currentRestorePath, String deviceUUID, String subject, String actionBy) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)actionBy)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findOne(query, RestoreProgressEvents.class);
        Update update = new Update();
        update.set("restoredFiles", (Object)restoredFiles);
        update.set("size", (Object)restoredSize);
        update.set("currentFolderPath", (Object)currentRestorePath);
        update.set("restoredFilesForFolder", (Object)currentFolderRestoredFiles);
        update.set("totalNoOfRestoreFilesForFolder", (Object)currentFolderRestoredFiles);
        if (StringUtils.isNotEmpty((String)subject)) {
            update.set("subject", (Object)subject);
        }
        mongoTemplate.updateFirst(query, update, RestoreProgressEvents.class);
    }

    @Override
    public void updateRapidRestoreProgress(int cloudId, String deviceUUID, String actionBy, String currentRestoreFile, long rapidRestoredFiles, String rapidRestoreStatus) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)actionBy)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findOne(query, RestoreProgressEvents.class);
        Update update = new Update();
        update.set("rapidRestoreStatus", (Object)rapidRestoreStatus);
        update.set("noOfRapidRestoredFiles", (Object)rapidRestoredFiles);
        update.set("currentRapidRestoreFile", (Object)currentRestoreFile);
        mongoTemplate.updateFirst(query, update, RestoreProgressEvents.class);
        RestoreEvents events = this.getRestoreEventByUUID(cloudId, deviceUUID);
        if (events == null) {
            mongoTemplate.remove(query, RestoreProgressEvents.class);
        }
    }

    @Override
    public void removeRestoreProgress(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, RestoreProgressEvents.class);
    }

    @Override
    public RestoreProgressEvents getRestoreEventProgressByUUID(int cloudId, String deviceUUID, String loginUserName) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)loginUserName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreProgressEvents)paracloudMongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public void updateCurrentRestoreProgressPath(int cloudId, long currentFolderRestoredFiles, String currentRestorePath, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findOne(query, RestoreProgressEvents.class);
        Update update = new Update();
        update.set("currentFolderPath", (Object)currentRestorePath);
        update.set("restoredFilesForFolder", (Object)0);
        long count = this.getCountOfFileForPath(cloudId, deviceUUID, currentRestorePath);
        if (count > 0L) {
            update.set("totalNoOfRestoreFilesForFolder", (Object)count);
        } else {
            update.set("totalNoOfRestoreFilesForFolder", (Object)count);
        }
        mongoTemplate.updateFirst(query, update, RestoreProgressEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEventByUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    private void updateBackupAttempt(int cloudId, String batchId, int uploadedFiles, long totalSize) {
        logger.debug("...Inside updateing attempt info..." + batchId + "....uploadedFiles..." + uploadedFiles + ".....totalSize...." + totalSize);
        BackupAttempt lastBackupAttemptById = this.getLastBackupAttemptById(cloudId, batchId);
        String currentUploadedFilesStatus = "";
        if (lastBackupAttemptById != null) {
            logger.debug("..........lastBackupAttemptById.........." + lastBackupAttemptById.toString());
            if (StringUtils.isEmpty((String)lastBackupAttemptById.getUploadedFiles())) {
                currentUploadedFilesStatus = uploadedFiles + "/" + lastBackupAttemptById.getTotalNoOfFiles();
            } else {
                String[] parts = lastBackupAttemptById.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                    }
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + lastBackupAttemptById.getTotalNoOfFiles();
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            Long batchTotalSize = 0L;
            if (!StringUtils.isEmpty((String)lastBackupAttemptById.getUploadedSize())) {
                batchTotalSize = Long.valueOf(lastBackupAttemptById.getUploadedSize());
            }
            long updatedTotalSize = 0L;
            if (batchTotalSize != null) {
                updatedTotalSize = batchTotalSize + totalSize;
            }
            logger.debug("..........lastBackupAttemptById.size........." + batchTotalSize);
            logger.debug("..........lastBackupAttemptById... ......." + totalSize);
            logger.debug("..........updatedTotalSize... ......." + updatedTotalSize);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = Criteria.where((String)"id").is((Object)lastBackupAttemptById.getId());
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.set("uploadedSize", (Object)Long.toString(updatedTotalSize));
            update.inc("totalNoOfFiles", (Number)uploadedFiles);
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupAttempt.class);
        }
    }

    @Override
    public BackupAttempt getLastBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
    }

    @Override
    public List<BackupAttempt> getLastTwoBackupAttemptById(int cloudId, String batchId) {
        Criteria criteria1 = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria1);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(3);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupAttempt.class);
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String fileName, String devicePath, Device device) {
        String deviceUUID = device.getDeviceUUID();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        ArrayList<BackUpImage> backUpImages = new ArrayList<BackUpImage>();
        List<String> bkpCollectionList = this.getBackupCollectionList(device);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImages.addAll(list);
        }
        return backUpImages;
    }

    private List<String> getBackupCollectionList(Device device) {
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            bkpCollectionList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            bkpCollectionList.add(BACK_UP);
        }
        return bkpCollectionList;
    }

    @Override
    public BackupBatch getLastRestoreBatch(int cloudId, String actionToDeviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)actionToDeviceUUID), Criteria.where((String)JOB_TYPE).is((Object)RESTORE)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_END_TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
    }

    @Override
    public User saveUser(int cloudId, User user) {
        user.setLastModifiedTimestamp("" + Long.toString(System.currentTimeMillis()));
        this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
        return user;
    }

    @Override
    public void updateBkpTargetStatus(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)0);
        update.set("backupTargetAssigned", (Object)true);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        mongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void saveOrUpdateRestoreForEndPoint(int cloudId, RestoreProgressEvents progressEvents) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        RestoreProgressEvents progressEventsFromDB = (RestoreProgressEvents)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"deviceUUID").is((Object)progressEvents.getDeviceUUID()))), RestoreProgressEvents.class);
        if (progressEventsFromDB != null) {
            Update update = new Update();
            update.set("totalsize", (Object)progressEvents.getTotalsize());
            update.set("totalNoOfFilesForRestore", (Object)progressEvents.getTotalNoOfFilesForRestore());
            update.set("totalNoOfRestoreFilesForFolder", (Object)progressEvents.getTotalNoOfRestoreFilesForFolder());
            logger.debug("...saving for updating....new ...." + progressEvents.toString());
            mongoTemplate.updateFirst(query, update, RestoreProgressEvents.class);
        } else {
            logger.debug("...saving for first time........" + progressEvents.toString());
            mongoTemplate.save((Object)progressEvents);
        }
    }

    @Override
    public RestoreProgressEvents getProgressEvent(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreProgressEvents)mongoTemplate.findOne(query, RestoreProgressEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEvents(int cloudId, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"actionOnDeviceUUID").is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public List<RestoreEvents> getRestoreEventsForBlukrypt(int cloudId, String componentName, boolean interruptedRestoresFirst) throws Exception {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List<RestoreEvents> startedRestoresForBlukrypt = new ArrayList<RestoreEvents>();
        ArrayList<RestoreEvents> newlyAddedRestoresForBlukrypt = new ArrayList<RestoreEvents>();
        RestoreEvents newlyAddedRestoreForBlukrypt = null;
        Criteria criteria = null;
        Query query = null;
        try {
            if (interruptedRestoresFirst) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)RestoreEvents.STATUS.STARTED.toString()), Criteria.where((String)COMPONENT_NAME).is((Object)componentName)});
                query = new Query((CriteriaDefinition)criteria);
                startedRestoresForBlukrypt = mongoTemplate.find(query, RestoreEvents.class);
                logger.debug("process = assign restore for blukrypt, number of started restore for this blukrypt ={} are ={}", (Object)componentName, (Object)startedRestoresForBlukrypt.size());
                for (RestoreEvents startedRestoreForBlukrypt : startedRestoresForBlukrypt) {
                    logger.debug("process = assign restore for blukrypt, started restore for blukrypt for restore ={} whose status is ={}", (Object)startedRestoreForBlukrypt.getId(), (Object)startedRestoreForBlukrypt.getStatus());
                }
            }
            if (startedRestoresForBlukrypt.size() == 0) {
                criteria = Criteria.where((String)STATUS).is((Object)RestoreEvents.STATUS.QUEUE.toString());
                query = new Query((CriteriaDefinition)criteria);
                newlyAddedRestoreForBlukrypt = (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
                if (newlyAddedRestoreForBlukrypt != null) {
                    if (StringUtils.isBlank((String)newlyAddedRestoreForBlukrypt.getDestinationDeviceUUID())) {
                        logger.debug("process = assign restore for blukrypt, the restore event is pst download, check if it is a main machine");
                        if (PCHelperConstant.isParacloud()) {
                            logger.debug("process = assign restore for blukrypt, the restore event is pst download, it is a main machine hence continue");
                        } else {
                            logger.debug("process = assign restore for blukrypt, the restore event is pst download, it is not a main machine hence exit");
                            return new ArrayList<RestoreEvents>();
                        }
                    }
                    logger.debug("process = assign restore for blukrypt, newly added restore found that can be added to this blukrypt={} to take is ={}", (Object)componentName, (Object)newlyAddedRestoreForBlukrypt.getId());
                    criteria = Criteria.where((String)"id").is((Object)newlyAddedRestoreForBlukrypt.getId());
                    query = new Query((CriteriaDefinition)criteria);
                    Update update = new Update();
                    update.set(STATUS, (Object)RestoreEvents.STATUS.STARTED.toString());
                    update.set(COMPONENT_NAME, (Object)componentName);
                    logger.debug("process = assign restore for blukrypt, setting the found restore ={} to this blukrypt={} in data base", (Object)newlyAddedRestoreForBlukrypt.getId(), (Object)componentName);
                    mongoTemplate.updateFirst(query, update, RestoreEvents.class);
                    RestoreEvents updatedRestoreEvent = this.getupdatedRestoreEventStatus(cloudId, newlyAddedRestoreForBlukrypt);
                    if (RestoreEvents.STATUS.STARTED.toString().equals(updatedRestoreEvent.getStatus()) && componentName.equals(updatedRestoreEvent.getComponentName())) {
                        logger.debug("process = assign restore for blukrypt, write successfull to data base for the found restore ={} to this blukrypt={} ", (Object)newlyAddedRestoreForBlukrypt.getId(), (Object)componentName);
                        newlyAddedRestoresForBlukrypt.add(newlyAddedRestoreForBlukrypt);
                    }
                } else {
                    logger.debug("process = assign restore for blukrypt, number of newly restore to be taken by this blukrypt ={} are not found", (Object)componentName);
                }
                return newlyAddedRestoresForBlukrypt;
            }
            return startedRestoresForBlukrypt;
        }
        catch (MongoWriteException e) {
            if (newlyAddedRestoreForBlukrypt != null) {
                logger.error("There is an error while changing the restore event of id={} status from ={} to ={} for component name ={}", (Object)newlyAddedRestoreForBlukrypt.getId(), (Object)newlyAddedRestoreForBlukrypt.getStatus(), (Object)newlyAddedRestoreForBlukrypt.getComponentName());
                this.getupdatedRestoreEventStatus(cloudId, newlyAddedRestoreForBlukrypt);
            }
            return null;
        }
    }

    @Override
    public RestoreEvents getupdatedRestoreEventStatus(int cloudId, RestoreEvents restoreForBlukrypt) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)restoreForBlukrypt.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        RestoreEvents actualRestoreOfBlukrypt = (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
        logger.debug("process = reading restore for blukrypt, the restore event with id={} with status ={} is taken by ={}", (Object)actualRestoreOfBlukrypt.getId(), (Object)actualRestoreOfBlukrypt.getStatus(), (Object)actualRestoreOfBlukrypt.getComponentName());
        return actualRestoreOfBlukrypt;
    }

    @Override
    public void updateTotalNoOFFiles(int cloudId, String batchId, long totalNoOfFiles) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("totalNoOfFiles", (Object)("" + totalNoOfFiles));
        mongoTemplate.updateFirst(query, update, BackupBatch.class);
    }

    @Override
    public void updateBackupBatchTotalCount(int cloudId, String batchId) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch findOne = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)batchId))), BackupBatch.class);
        if (findOne != null) {
            Update update = new Update();
            if (!StringUtils.isEmpty((String)findOne.getTotalNoOfFiles())) {
                long totalNoOfFiles = Long.parseLong(findOne.getTotalNoOfFiles());
                update.set("totalNoOfFiles", (Object)("" + (totalNoOfFiles - 1L)));
                mongoTemplate.updateFirst(query, update, BackupBatch.class);
            }
        }
    }

    @Override
    public void saveBackupAttempt(int cloudId, BackupAttempt attempt) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)attempt);
        logger.debug("....attempt id...." + attempt.getId().toString());
    }

    @Override
    public void updateBackupAttempt(int cloudId, String uploadedFiles, String batchId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"batchId").is((Object)batchId);
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
        query.limit(1);
        BackupAttempt attempt = (BackupAttempt)mongoTemplate.findOne(query, BackupAttempt.class);
        logger.debug("..desc order ..." + attempt.getId());
        criteria = Criteria.where((String)"id").is((Object)attempt.getId());
        query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("uploadedFiles", (Object)uploadedFiles);
        mongoTemplate.updateFirst(query, update, BackupAttempt.class);
    }

    @Override
    public void updateAttemptForRestart(int cloudId, ObjectId id, String errorCode) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(STATUS, (Object)"INTERRUPTED");
        if (!StringUtils.isEmpty((String)errorCode) && errorCode.equalsIgnoreCase("1996")) {
            update.set("errorCode", (Object)"1996");
        } else {
            update.set("errorCode", (Object)"909");
        }
        update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
        logger.debug(id + "........attempt..." + errorCode);
        mongoTemplate.updateFirst(query, update, BackupAttempt.class);
    }

    @Override
    public void updateGDParentFolderId(int cloudId, String userName, String parabluFolderId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("gdParentFolderId", (Object)parabluFolderId);
        mongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserLimitMailSent(int cloudId, String deviceUUID, boolean mailSent) {
        logger.debug(".........updateUserLimitMailSent....." + deviceUUID + "...." + mailSent);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("storageLimitMailSent", (Object)mailSent);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public BluKryptStorageMapping getBluKryptStorageMapping(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blukrytName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BluKryptStorageMapping)mongoTemplate.findOne(query, BluKryptStorageMapping.class);
    }

    @Override
    public void saveBlukryptStorage(int cloudId, BluKryptStorageMapping bluKryptStorageMapping) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blukrytName").is((Object)bluKryptStorageMapping.getBlukrytName())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BluKryptStorageMapping.class);
        mongoTemplate.save((Object)bluKryptStorageMapping);
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppSetting)mongoTemplate.findOne(new Query(), MSAppSetting.class);
    }

    @Override
    public void updateAzureProperties(int cloudId, String userName, String odbDriveid) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("odbDriveid", (Object)odbDriveid);
        mongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public ChunkDetail getChunkDetailForMd5ForRestore(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            String string = DEDUP.DISABLED.toString();
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal) || DEDUP.DISABLED.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long timeMillisec = System.currentTimeMillis();
        logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        return this.getChunkDetailByFilteringDedupStrtTime(cloudId, md5, mongoTemplate, query, timeMillisec, queryTablesList, isUpload);
    }

    private ChunkDetail getChunkDetailByFilteringDedupStrtTime(int cloudId, String md5, MongoTemplate mongoTemplate, Query query, long timeMillisec, List<String> queryTablesList, boolean isUpload) {
        ChunkDetail chunkDetail = null;
        ArrayList chunkDetailList = new ArrayList();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (!CollectionUtils.isEmpty(chunkDetailList)) {
            CloudSettings cloudSettings = this.getCloudSettings(cloudId);
            chunkDetail = isUpload && cloudSettings != null && cloudSettings.getDedupStartTime() != 0L ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.get(0);
        }
        long afterTimeMillisec = System.currentTimeMillis();
        logger.debug(chunkDetail + "... findone query MD5 for searching in chunk table is>>" + md5 + "...." + (afterTimeMillisec - timeMillisec));
        return chunkDetail;
    }

    public CloudSettings getCloudSettings(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        return (CloudSettings)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), CloudSettings.class);
    }

    private List<String> getChunkDetailCollections(String md5) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        queryTablesList.add("CHUNK_DETAIL_" + chunkDetailDest);
        return queryTablesList;
    }

    @Override
    public void updateChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        ChunkDetail chunkDetailObj;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)chunkDetail.getId()));
        if (chunkDetail.getId() != null && (chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL)) != null) {
            collectionName = CHUNK_DETAIL;
        }
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail);
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        Update update = new Update();
        update.set("refCount", (Object)chunkDetail.getRefCount());
        mongoTemplate.updateFirst(query, update, ChunkDetail.class, collectionName);
    }

    private void createChunkIndex(MongoTemplate mongoTemplate, String collectionName) {
        MongoCollection chunkCollection = mongoTemplate.getCollection(collectionName);
        chunkCollection.createIndex(Indexes.ascending((String[])new String[]{"md5"}));
    }

    private String getChunkNewCollectionName(ChunkDetail chunkDetail) {
        int hashCode = Arrays.hashCode(chunkDetail.getMd5().getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    @Override
    public BackupFile getSyncFileByUserNameFileNameandFilePath(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"filePath").is((Object)filePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            logger.trace("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public PstBatch getPstBatch(String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)batchId)});
        return (PstBatch)this.mongoOps.findOne(new Query((CriteriaDefinition)criteria), PstBatch.class);
    }

    @Override
    public List<PstBatchDetail> getPstBatchDetails(String pstBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"pstBatchId").is((Object)pstBatchId)});
        return this.mongoOps.find(new Query((CriteriaDefinition)criteria), PstBatchDetail.class);
    }

    @Override
    public void saveFailedFilesReason(int cloudId, FailedFileReason failedFileReason) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.save((Object)failedFileReason);
    }

    @Override
    public C2CAppSettings getC2CAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (C2CAppSettings)mongoTemplate.findOne(new Query(), C2CAppSettings.class);
    }

    @Override
    public void removeBackupFileFromBatch(int cloudId, String id, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id), Criteria.where((String)"batchId").is((Object)batchId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, com.pg.domain.BackupFile.class, "PST_BATCH");
        logger.debug("...removed removeBackupFileFromBatch.... " + id + "...delete.." + remove.getDeletedCount());
    }

    @Override
    public void saveFileForPstDownload(com.pg.domain.BackupFile backupFileData, String batchId) {
        try {
            backupFileData.setBatchId(batchId);
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
            mongoTemplate.save((Object)backupFileData, "PST_BATCH");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeFileForPstDownload(String batchId, String ewsId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"batchId").is((Object)batchId), Criteria.where((String)"ewsId").is((Object)ewsId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        DeleteResult remove = mongoTemplate.remove(query, com.pg.domain.BackupFile.class, "PST_BATCH");
        logger.debug("...removed removeBackupFileFromBatch.... " + ewsId + "...delete.." + remove.getDeletedCount());
    }

    @Override
    public List<com.pg.domain.BackupFile> getFilesForMailBatchId(int cloudId, String restoreBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"batchId").is((Object)restoreBatchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), com.pg.domain.BackupFile.class, "PST_BATCH");
    }

    @Override
    public void updateBackupBatchFailedFile(int cloudId, String backupBatchId) {
        logger.debug("....inside updateBackBatch...." + backupBatchId);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatchId);
        Query query = new Query((CriteriaDefinition)criteria);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        String currentUploadedFilesStatus = "";
        Integer total = new Integer(0);
        logger.debug("...update failcase...." + backupBatch.toString());
        try {
            total = Integer.parseInt(backupBatch.getTotalNoOfFiles());
            total = total - 1;
        }
        catch (NumberFormatException e1) {
            logger.error(backupBatchId + "...unable to parse totalnooffiles...." + backupBatch.getTotalNoOfFiles());
        }
        if (backupBatch != null) {
            if (StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                currentUploadedFilesStatus = "0/" + total;
            } else {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = prevBkpFiles;
                    }
                    logger.debug(backupBatch.getUploadedFiles() + "...updateprevin...." + prevBkpFiles + "..." + total);
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + total;
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            logger.debug("...beforeupdate...." + currentUploadedFilesStatus);
            Update update = new Update();
            update.set("totalNoOfFiles", (Object)("" + total));
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public long getLastUploadedTimestampForSIEM() {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        SIEMHistory siemHistory = (SIEMHistory)mongoTemplate.findOne(new Query(), SIEMHistory.class);
        if (siemHistory != null) {
            return siemHistory.getLastUploadedTimestamp();
        }
        return 0L;
    }

    @Override
    public List<AuditHistory> getAuditHistoryForRange(long lastUploadedTimestamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"timestamp").gt((Object)lastUploadedTimestamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public SIEMCredentials getSIEMCredentials() {
        return (SIEMCredentials)this.mongoOps.findOne(new Query(), SIEMCredentials.class);
    }

    @Override
    public void updateLastUploadedTimestamp(long jobTimestamp) {
        Update update = new Update();
        update.set("lastUploadedTimestamp", (Object)jobTimestamp);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        mongoTemplate.upsert(new Query(), update, SIEMHistory.class);
    }

    @Override
    public DeletedUser getDeletedUserForName(int cloudId, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
        Query query = new Query((CriteriaDefinition)criteria);
        return (DeletedUser)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, DeletedUser.class);
    }

    private String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    @Override
    public void moveChunkDetailToDeleteCollection(int cloudId, ChunkDetail chunkDetail) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String destcollection = this.getChunkNewCollectionName(chunkDetail.getMd5());
        logger.debug(chunkDetail.getId() + "...deelete chunk detail from ..." + destcollection);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)chunkDetail.getMd5()), Criteria.where((String)USER_NAME).is((Object)chunkDetail.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class, destcollection);
        mongoTemplate.save((Object)chunkDetail, "DELETE_CHUNK_DETAIL");
    }

    @Override
    public ChunkDetail getDeletedChunkDetail(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        query.limit(1);
        List list = mongoTemplate.find(query, ChunkDetail.class, "DELETE_CHUNK_DETAIL");
        ChunkDetail detail = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            detail = (ChunkDetail)list.get(0);
        }
        return detail;
    }

    @Override
    public void deleteChunkEntries(int cloudId, ChunkDetail chunkDetail, String chunkBucketName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)chunkDetail.getUserName()), Criteria.where((String)"deviceUUID").is((Object)chunkDetail.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class, chunkBucketName);
    }

    @Override
    public void deleteChunkEntriesFinal(int cloudId, ChunkDetail chunkDetail) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)chunkDetail.getUserName()), Criteria.where((String)"deviceUUID").is((Object)chunkDetail.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class, "DELETE_CHUNK_DETAIL");
    }

    @Override
    public List<PrivacyGateway> getAllPrivacyGateways(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(PrivacyGateway.class);
    }

    @Override
    public OTPValidation getOTPForUniqueId(int cloudId, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)userId));
        return (OTPValidation)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, OTPValidation.class);
    }

    @Override
    public OfficeBackupPolicy getSpBackupPolicy(int cloudId, String spPolicyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)spPolicyName)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    @Override
    public void updateSiteId(int cloudId, String userName, String driveId) {
        logger.debug(".....user name update ...." + userName);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("siteId", (Object)driveId);
        mongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateBackBatch(int cloudId, String backupBatchId, int uploadedFiles, long totalSize) {
        logger.debug("....inside updateBackBatch...." + backupBatchId);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatchId);
        Query query = new Query((CriteriaDefinition)criteria);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        String currentUploadedFilesStatus = "";
        if (backupBatch != null) {
            if (StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                currentUploadedFilesStatus = uploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
            } else {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                    }
                    int totalNoOfFiles = 0;
                    if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                        totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                    }
                    if (updatedUploadedFiles > totalNoOfFiles) {
                        updatedUploadedFiles = totalNoOfFiles;
                    }
                    logger.debug(uploadedFiles + "...updateprevin1...." + prevBkpFiles);
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
                    logger.debug(updatedUploadedFiles + "...updateprevin2...." + totalNoOfFiles);
                    if (totalNoOfFiles == 1 && updatedUploadedFiles == 0) {
                        currentUploadedFilesStatus = "0/0";
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            Long batchTotalSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                batchTotalSize = Long.valueOf(backupBatch.getUploadedSize());
                logger.debug("....inside 111...." + batchTotalSize);
            }
            long updatedTotalSize = 0L;
            if (batchTotalSize != null) {
                updatedTotalSize = batchTotalSize + totalSize;
            }
            Update update = new Update();
            logger.debug("...updatedTotalSize...." + updatedTotalSize);
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set("uploadedSize", (Object)Long.toString(updatedTotalSize));
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
            this.updateBackupAttempt(cloudId, backupBatchId, uploadedFiles, totalSize);
        }
    }

    @Override
    public void updateBackBatchForRestore(int cloudId, String backupBatchId, int uploadedFiles, long totalSize) {
        logger.debug("....inside updateBackBatch...." + backupBatchId);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatchId);
        Query query = new Query((CriteriaDefinition)criteria);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query, BackupBatch.class);
        String currentUploadedFilesStatus = "";
        if (backupBatch != null) {
            if (StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                currentUploadedFilesStatus = uploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
            } else {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = uploadedFiles;
                    }
                    int totalNoOfFiles = 0;
                    if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                        totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                    }
                    if (updatedUploadedFiles > totalNoOfFiles) {
                        updatedUploadedFiles = totalNoOfFiles;
                    }
                    logger.debug(uploadedFiles + "...updateprevin...." + prevBkpFiles);
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            Update update = new Update();
            logger.debug("...updatedTotalSize...." + totalSize);
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set("uploadedSize", (Object)Long.toString(totalSize));
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public BlockedDeviceUser getBlockedDeviceUser(int cloudId, String deviceUUID, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        BlockedDeviceUser blockedDeviceUser = (BlockedDeviceUser)mongoTemplate.findOne(query, BlockedDeviceUser.class);
        if (blockedDeviceUser != null) {
            return blockedDeviceUser;
        }
        blockedDeviceUser = new BlockedDeviceUser();
        blockedDeviceUser.setDeviceUUID(deviceUUID);
        blockedDeviceUser.setUserName(userName);
        mongoTemplate.save((Object)blockedDeviceUser);
        blockedDeviceUser = (BlockedDeviceUser)mongoTemplate.findOne(query, BlockedDeviceUser.class);
        return blockedDeviceUser;
    }

    @Override
    public void updateBlockedDeviceDataProgress(int cloudId, String deviceUUID, String userName, boolean dataDeleted) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        BlockedDeviceUser blockedDeviceUser = (BlockedDeviceUser)mongoTemplate.findOne(query, BlockedDeviceUser.class);
        if (blockedDeviceUser != null) {
            Update update = new Update();
            update.set("dataDeleted", (Object)dataDeleted);
            update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BlockedDeviceUser.class);
        }
    }

    @Override
    public void updateBlockedDeviceDBProgress(int cloudId, String deviceUUID, String userName, boolean dbDeleted) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        BlockedDeviceUser blockedDeviceUser = (BlockedDeviceUser)mongoTemplate.findOne(query, BlockedDeviceUser.class);
        if (blockedDeviceUser != null) {
            Update update = new Update();
            update.set("dbRecDeleted", (Object)dbDeleted);
            update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, BlockedDeviceUser.class);
        }
    }

    @Override
    public void saveOfficeRestoreFileInfo(int cloudId, OfficeRestoreFileInfo officeRestoreFileInfo) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        try {
            mongoTemplate.save((Object)officeRestoreFileInfo);
        }
        catch (Exception e) {
            logger.error("Exception in saving the info", (Object)e.getMessage());
        }
    }

    @Override
    public void updateEWSToken(int cloudId, String token) {
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        EWSToken ewsToken = (EWSToken)mongoTemplate.findOne(query = new Query(), EWSToken.class);
        if (ewsToken != null) {
            mongoTemplate.remove((Object)ewsToken);
        }
        EWSToken ewsNewToken = new EWSToken();
        ewsNewToken.setToken(token);
        mongoTemplate.save((Object)ewsNewToken);
    }

    @Override
    public String getEWSToken(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        EWSToken ewsToken = (EWSToken)mongoTemplate.findOne(query, EWSToken.class);
        String token = "";
        if (ewsToken != null) {
            token = ewsToken.getToken();
        }
        return token;
    }

    @Override
    public void updateFullBkpForBatch(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("isFullBackup", (Object)true);
        mongoTemplate.updateFirst(query, update, BackupBatch.class);
    }

    @Override
    public void removeBackupBatch(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BackupBatch.class);
    }

    @Override
    public void updateBackupBatchStatusAndSize(int cloudId, ObjectId backupBatchId, String status, long folderSize, long totalNoOfFiles) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            update.set(STATUS, (Object)status);
            update.set("totalSizeToUpload", (Object)folderSize);
            update.set("totalNoOfFiles", (Object)totalNoOfFiles);
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public void deletePSTBatch(int cloudId, String restoreBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"batchId").is((Object)restoreBatchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("....delete restorebatch...." + restoreBatchId);
        mongoTemplate.remove(new Query((CriteriaDefinition)criteria), com.pg.domain.BackupFile.class, "PST_BATCH");
    }

    @Override
    public void updateAbortBackBatch(int cloudId, ObjectId backupBatchId) {
        Criteria criteria;
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupBatch backupBatch = (BackupBatch)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)"id").is((Object)backupBatchId))), BackupBatch.class);
        if (backupBatch != null) {
            Update update = new Update();
            String[] parts = backupBatch.getUploadedFiles().split("/");
            int uploadedFiles = parts.length != 0 ? Integer.parseInt(parts[0]) : 0;
            String currentUploadedFilesStatus = uploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set("uploadedSize", (Object)0);
            mongoTemplate.updateFirst(query, update, BackupBatch.class);
        }
    }

    @Override
    public long countFilesForMailBatchId(int cloudId, String restoreBatchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"batchId").is((Object)restoreBatchId)});
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), "PST_BATCH");
    }

    @Override
    public void deleteRestoreEventForPst(int cloudId, ObjectId restoreEventId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(restoreEventId.toString()))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, RestoreEvents.class);
    }

    @Override
    public RestoreEvents getRestoreEventByID(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"_id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreEvents)mongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void saveCapacityMgmtImage(int cloudId, CMBackUpImage cmBackUpImage, String destType, String productType) {
        logger.debug("...saveCapacityMgmtImage....");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        cmBackUpImage.setDestCollection(destType);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)cmBackUpImage.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)cmBackUpImage.getOdItemId())});
        Query query = new Query((CriteriaDefinition)criteria);
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            logger.debug("...saveCapacityMgmtImage1....");
            List find = mongoTemplate.find(query, CMBackUpImage.class, "CAPACITY_MGMT_BACKUP_SP");
            if (!CollectionUtils.isEmpty((Collection)find) && find.size() >= 1) {
                logger.debug("...saveCapacityMgmtImggggggImage2....");
                mongoTemplate.findAndReplace(query, (Object)cmBackUpImage, "CAPACITY_MGMT_BACKUP_SP");
            } else {
                mongoTemplate.save((Object)cmBackUpImage, "CAPACITY_MGMT_BACKUP_SP");
                logger.debug("...saveCapacityMgmtImage3....");
            }
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            mongoTemplate.save((Object)cmBackUpImage, "CAPACITY_MGMT_BACKUP_ODB");
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            mongoTemplate.save((Object)cmBackUpImage, "CAPACITY_MGMT_BACKUP_OUTLOOK");
        }
    }

    @Override
    public void deleteCPMgtImage(int cloudId, BackUpImage backUpImage, String destType, String productType) {
        String dbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"_id").is((Object)backUpImage.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        CMBackUpImage cmBackUpImage = (CMBackUpImage)mongoTemplate.findOne(query, CMBackUpImage.class, dbName);
        if (cmBackUpImage != null) {
            logger.debug(backUpImage.getOdItemId() + ".....exists record....." + backUpImage.getId().toString());
            mongoTemplate.remove(query, CMBackUpImage.class, dbName);
        } else {
            logger.debug(backUpImage.getOdItemId() + ".....exists record....." + backUpImage.getId().toString());
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)backUpImage.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)backUpImage.getOdItemId())});
            query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAllAndRemove(query, CMBackUpImage.class, dbName);
        }
    }

    @Override
    public void updateCapacityMgmt(int cloudId, String deviceUUID, long actualFileSize, long cpCompressedStorage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"deviceUUID").is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        logger.debug(deviceUUID + "...actualsize..." + actualFileSize + "...." + cpCompressedStorage);
        update.inc("cpActualFileSize", (Number)actualFileSize);
        update.inc("cpCompressedStorage", (Number)cpCompressedStorage);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
        logger.debug("****update response**" + updateFirst.getModifiedCount());
    }

    @Override
    public CPBackupBatch getCPBackupBatch(int cloudId, String productType) {
        CPBackupBatch backupBatch = null;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)STATUS).is((Object)STATUS_STARTED), Criteria.where((String)"productType").is((Object)productType)});
        List list = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), CPBackupBatch.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupBatch = (CPBackupBatch)list.get(0);
        }
        return backupBatch;
    }

    @Override
    public String saveCPBackupBatch(int cloudId, CPBackupBatch cpBackupBatch) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)cpBackupBatch);
        return cpBackupBatch.getId().toString();
    }

    @Override
    public void updateCPBackupBatch(int cloudId, String backupBatchId, int uploadedFiles, long totalSize) {
        logger.debug("....inside updateBackBatch...." + backupBatchId);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)new ObjectId(backupBatchId));
        Query query = new Query((CriteriaDefinition)criteria);
        CPBackupBatch backupBatch = (CPBackupBatch)mongoTemplate.findOne(query, CPBackupBatch.class);
        String currentUploadedFilesStatus = "";
        if (backupBatch != null) {
            if (StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                currentUploadedFilesStatus = uploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
            } else {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                    int updatedUploadedFiles = 0;
                    if (prevBkpFiles != null) {
                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                    }
                    int totalNoOfFiles = 0;
                    if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                        totalNoOfFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                    }
                    if (updatedUploadedFiles > totalNoOfFiles) {
                        updatedUploadedFiles = totalNoOfFiles;
                    }
                    logger.debug(uploadedFiles + "...updateprevin1...." + prevBkpFiles);
                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + backupBatch.getTotalNoOfFiles();
                    logger.debug(updatedUploadedFiles + "...updateprevin2...." + totalNoOfFiles);
                    if (totalNoOfFiles == 1 && updatedUploadedFiles == 0) {
                        currentUploadedFilesStatus = "0/0";
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            Long batchTotalSize = 0L;
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedSize())) {
                batchTotalSize = Long.valueOf(backupBatch.getUploadedSize());
                logger.debug("....inside 111...." + batchTotalSize);
            }
            long updatedTotalSize = 0L;
            if (batchTotalSize != null) {
                updatedTotalSize = batchTotalSize + totalSize;
            }
            Update update = new Update();
            logger.debug("...updatedTotalSize...." + updatedTotalSize);
            update.set("uploadedFiles", (Object)currentUploadedFilesStatus);
            update.set("uploadedSize", (Object)Long.toString(updatedTotalSize));
            if (totalSize > 0L) {
                update.inc("cpConvFiles", (Number)1);
            }
            update.set(BATCH_END_TIME_STAMP, (Object)System.currentTimeMillis());
            mongoTemplate.updateFirst(query, update, CPBackupBatch.class);
        }
    }

    @Override
    public CPBackupBatch getCPBackupBatchById(int cloudId, String batchId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(batchId))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (CPBackupBatch)mongoTemplate.findOne(query, CPBackupBatch.class);
    }

    @Override
    public CPBackupBatch getLatestCPBackupBatch(int cloudId, String productType) {
        CPBackupBatch backupBatch = null;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)productType)});
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        backupBatch = (CPBackupBatch)mongoTemplate.findOne(query, CPBackupBatch.class);
        return backupBatch;
    }

    @Override
    public void createCPBackupBatch(int cloudId, String productType, boolean manual) {
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(productType)) {
            productType = Device.TYPE.ONEDRIVE.name();
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(productType)) {
            productType = Device.TYPE.OUTLOOK.name();
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(productType)) {
            productType = Device.TYPE.SHAREPOINT.name();
        }
        CPBackupBatch backupBatch = null;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"productType").is((Object)productType), Criteria.where((String)STATUS).is((Object)STATUS_STARTED)});
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{BATCH_START_TIME_STAMP}));
        query.limit(1);
        backupBatch = (CPBackupBatch)mongoTemplate.findOne(query, CPBackupBatch.class);
        if (backupBatch == null) {
            CPBackupBatch cpBackupBatch = new CPBackupBatch();
            cpBackupBatch.setStatus(CPBackupBatch.STATUS.STARTED.toString());
            logger.debug(manual + "....producttype...." + productType);
            cpBackupBatch.setProductType(productType);
            cpBackupBatch.setManualJob(manual);
            cpBackupBatch.setBatchStartTimestamp(System.currentTimeMillis());
            String dbName = "";
            if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
                dbName = "CAPACITY_MGMT_BACKUP_SP";
            } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
                dbName = "CAPACITY_MGMT_BACKUP_ODB";
            } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
            }
            query = new Query();
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"lastRecordForBatch").is((Object)true)});
            query.limit(1);
            CMBackUpImage backUpImage = (CMBackUpImage)mongoTemplate.findOne(query, CMBackUpImage.class, dbName);
            if (backUpImage != null) {
                backUpImage.setLastRecordForBatch(false);
                mongoTemplate.save((Object)backUpImage);
            }
            long totalCount = mongoTemplate.count(query, CMBackUpImage.class, dbName);
            cpBackupBatch.setTotalNoOfFiles("" + totalCount);
            query = new Query();
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastModifiedTime"}));
            query.limit(1);
            backUpImage = (CMBackUpImage)mongoTemplate.findOne(query, CMBackUpImage.class, dbName);
            if (backUpImage != null) {
                backUpImage.setLastRecordForBatch(true);
                logger.debug("....backUpImagelastrecord..." + backUpImage.getId().toString());
                mongoTemplate.save((Object)backUpImage, dbName);
            }
            logger.debug(dbName + "....total countforbatch..." + totalCount);
            mongoTemplate.save((Object)cpBackupBatch);
        }
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedInclusionFolders(int cloudId, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)DeviceDaoImpl.FOLDER_TYPE_ENUM.INCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, UserDefinedFolders.class);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedExclusionFolders(int cloudId, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)DeviceDaoImpl.FOLDER_TYPE_ENUM.EXCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }

    @Override
    public void removebkpAttempt(int cloudId, ObjectId id) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAndRemove(query, BackupAttempt.class);
    }

    @Override
    public void saveBackupImage(int cloudId, BackUpImage backUpImage, String destCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)backUpImage.getDeviceUUID()), Criteria.where((String)"odItemId").is((Object)backUpImage.getOdItemId())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("attachments", backUpImage.getAttachments());
        logger.debug(".....update attachments..." + backUpImage.getAttachments());
        mongoTemplate.updateFirst(query, update, BackUpImage.class, destCollection);
    }

    static enum DEDUP {
        DISABLED,
        USER,
        GLOBAL;

    }
}

