/*
 * Decompiled with CFR 0.152.
 */
package com.pg.dao.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.PciAuthorizationTokens;
import com.parablu.pcbd.domain.RwSampleFileInfo;
import com.parablu.pcbd.domain.RwSampleFileInfoNames;
import com.parablu.pcbd.domain.User;
import com.pg.dao.FileDao;
import com.pg.domain.BackupFile;
import com.pg.domain.ContentChunkFile;
import com.pg.domain.DriveFileInfo;
import com.pg.domain.FileInfo;
import com.pg.element.BluKryptBackupFileElement;
import com.pg.element.ChunkFile;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.CacheHelper;
import com.pg.httpclient.util.HttpClientUtil;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FileDaoImpl
implements FileDao {
    public static final String NOT_ABLE_TO_RESTORE_TO_QUEUE = "not able to restore to queue.... ";
    public static final String LOCAL = "_local";
    public static final String BACKUP_PG = "backup_pg";
    public static final String CONTENT_CHUNK_PG = "content_chunk";
    private static final String PRIVACY_GATEWAY_BACKUP = "privacy_gateway_backup_";
    private static final String PRIVACY_GETEWAY = "privacy_gateway_";
    public static final String CHUNK_DETAIL_PG = "chunk_detail_";
    private static final String SYNC = "_sync";
    private static final String BACKUP_FILE_ID = "backup-file-id";
    private static final String PARAMETERS = "parameters";
    private static final String PARACLOUD_CLOUD_URL = "/paracloud/cloud/";
    private static final String GET_BACKUPFILE_URL = "/get/backupfile/";
    private static final String PARENT_FILE_NOT_IN_PG = " Parent File not in pg...... ";
    private static Logger logger = LogManager.getLogger(FileDaoImpl.class);
    private BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private MongoOperations blukrypytOdbTemplate;
    private MongoOperations blukrypytMongoTemplate;
    private MongoOperations msgMongoTemplate;

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public MongoOperations getBlukrypytOdbTemplate() {
        return this.blukrypytOdbTemplate;
    }

    public void setBlukrypytOdbTemplate(MongoOperations blukrypytOdbTemplate) {
        this.blukrypytOdbTemplate = blukrypytOdbTemplate;
    }

    public MongoOperations getBlukrypytMongoTemplate() {
        return this.blukrypytMongoTemplate;
    }

    public void setBlukrypytMongoTemplate(MongoOperations blukrypytMongoTemplate) {
        this.blukrypytMongoTemplate = blukrypytMongoTemplate;
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    private void logMessage(String logMessage) {
        logger.debug(logMessage);
    }

    @Override
    @Transactional
    public boolean saveFileInfo(FileInfo fileInfo, String cloudNameparam, String userNameParam) {
        this.logMessage("Before savng file info");
        String collectionName = this.getCollectionName(true, cloudNameparam);
        boolean fileBkpSuccess = this.saveFileInfoInMongo(fileInfo);
        if (fileBkpSuccess) {
            boolean fileBkpLocalSuccess = this.saveToLocalDb(fileInfo, collectionName);
            if (!fileBkpLocalSuccess) {
                this.removeBackupFromTempDb(1, "", new ObjectId(fileInfo.getId()), true);
                return false;
            }
        } else {
            return false;
        }
        this.logMessage("End of savng file info");
        return true;
    }

    @Override
    @Transactional
    public boolean saveFileInfoInMongo(FileInfo fileInfo) {
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
            mongoTemplate.save((Object)fileInfo, BACKUP_PG.toUpperCase());
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... " + e.getMessage());
            return false;
        }
        return true;
    }

    public static FileInfo readFromFile(String cloudName, FileInfo fileInfo) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String path = "/parablu/tmp-chunk/upload/localwrite/" + fileInfo.getId() + ".json";
            return (FileInfo)objectMapper.readValue(new File(path), FileInfo.class);
        }
        catch (IOException e) {
            logger.error("Error reading object from file: " + e.getMessage());
            return null;
        }
    }

    public void writeToFile(FileInfo fileInfo, String cloudName) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String filePath;
            String path = "/parablu/tmp-chunk/upload/localwrite/";
            if (!new File(path).exists()) {
                new File(path).mkdirs();
            }
            if (!new File(filePath = path + fileInfo.getId() + ".json").exists()) {
                new File(filePath).createNewFile();
            }
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(filePath), (Object)fileInfo);
            logger.debug("FileInfo written to file: " + filePath);
        }
        catch (Exception e) {
            logger.error("Error writing FileInfo to file: " + e.getMessage());
        }
    }

    @Override
    public void updateUploadedChunksAndSize(Cloud cloud, Long sizeInCloud, FileInfo fileInfo, Map<String, com.pg.domain.ChunkFile> uploadedFiles) {
        String collectionName = this.getCollectionName(true, cloud.getCloudName());
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        logger.debug(uploadedFiles.size() + "*******FILE-write....." + fileInfo.isAllChunksUploaded());
        fileInfo.setUploadedChunks(uploadedFiles);
        FileInfo info = FileDaoImpl.readFromFile(cloud.getCloudName(), fileInfo);
        if (info != null) {
            fileInfo.setStorageUtilizedInCloud(info.getStorageUtilizedInCloud() + sizeInCloud);
        } else {
            fileInfo.setStorageUtilizedInCloud(sizeInCloud);
        }
        this.writeToFile(fileInfo, cloud.getCloudName());
        if (fileInfo.isAllChunksUploaded()) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)fileInfo.getId())});
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.set("uploadedChunks", uploadedFiles);
            if (sizeInCloud != null) {
                update.inc("storageUtilizedInCloud", (Number)sizeInCloud);
            }
            this.blukrypytMongoTemplate.updateFirst(query, update, FileInfo.class, pgCollectionName);
        }
    }

    private String getCollectionName(boolean isBackup, String cloudNameparam) {
        String cloudName = cloudNameparam.toLowerCase();
        String collectionName = isBackup ? PRIVACY_GATEWAY_BACKUP + cloudName : PRIVACY_GETEWAY + cloudName + SYNC;
        collectionName = FileDaoImpl.getConvertDBCharacters(collectionName);
        return collectionName;
    }

    public boolean saveToLocalDb(FileInfo fileInfo, String collectionName) {
        try {
            String pgCollectionName = (collectionName + LOCAL).toUpperCase();
            this.blukrypytMongoTemplate.save((Object)fileInfo, pgCollectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to local .... " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean saveToBlackListDb(FileInfo fileInfo, String collectionName) {
        try {
            String collection = collectionName.toUpperCase();
            this.blukrypytMongoTemplate.save((Object)fileInfo, collection);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to local .... " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveFileInfo(FileInfo fileInfo, boolean isBackup, String cloudName) {
        String collectionName = this.getCollectionName(isBackup, cloudName);
        boolean fileBkpSuccess = this.saveFileInfoInMongo(fileInfo);
        if (fileBkpSuccess) {
            boolean fileBkpLocalSuccess = this.saveToLocalDb(fileInfo, collectionName);
            if (!fileBkpLocalSuccess) {
                this.removeBackupFromTempDb(1, "", new ObjectId(fileInfo.getId()), true);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    @Transactional
    public boolean saveFileInfoForSync(FileInfo fileInfo, String cloudNameParam, String gatewayNameParam) {
        String collectionName = this.getCollectionName(true, cloudNameParam);
        boolean fileBkpSuccess = this.saveFileInfoInMongo(fileInfo);
        if (fileBkpSuccess) {
            boolean fileBkpLocalSuccess = this.saveToLocalDb(fileInfo, collectionName);
            if (!fileBkpLocalSuccess) {
                this.removeBackupFromTempDb(1, "", new ObjectId(fileInfo.getId()), true);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void deleteFile(FileInfo fileInfo, String cloudNameParam) {
        String cloudName = cloudNameParam.toLowerCase();
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        this.blukrypytMongoTemplate.findAndRemove(query, FileInfo.class, pgCollectionName);
    }

    private void deleteFile(boolean isBackup, FileInfo fileInfo, String cloudNameParam) {
        String cloudName = cloudNameParam.toLowerCase();
        String collectionName = this.getCollectionName(isBackup, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        this.blukrypytMongoTemplate.findAndRemove(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public BackupFile getBackupFile(String userName, String cloudName, String id, String gatewayName) {
        BackupFile backupFile = new BackupFile();
        try {
            logger.debug("Getting backup file info from rest api******************");
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add("userName", userName);
            headers.add(BACKUP_FILE_ID, id);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_URL + cloudName + GET_BACKUPFILE_URL;
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, BluKryptBackupFileElement.class, new Object[0]);
            BluKryptBackupFileElement element = (BluKryptBackupFileElement)result.getBody();
            if (StringUtils.isEmpty((String)element.getBackupId())) {
                logger.debug("BACKUP File not available ........ for user  " + userName + " Backup id " + id);
                return null;
            }
            ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : element.getChunkFiles()) {
                com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunkList.add(file);
            }
            BeanUtils.copyProperties((Object)element, (Object)backupFile);
            backupFile.setBackupId(new ObjectId(element.getBackupId()));
            backupFile.getChunkFiles().clear();
            backupFile.getChunkFiles().addAll(chunkList);
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO getBackupFile rest...." + e);
        }
        return backupFile;
    }

    @Override
    public BackupFile getSyncFile(String userName, String cloudName, String id, String gatewayName) {
        BackupFile backupFile = new BackupFile();
        try {
            logger.debug("Getting backup file info from rest api******************");
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add("userName", userName);
            headers.add("sync-revision-id", id);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_URL + cloudName + "/get/syncfile/";
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, BluKryptBackupFileElement.class, new Object[0]);
            BluKryptBackupFileElement element = (BluKryptBackupFileElement)result.getBody();
            if (StringUtils.isEmpty((String)element.getBackupId())) {
                logger.debug("File not available ........ for user  " + userName + " Backup id " + id);
                return null;
            }
            ArrayList<com.pg.domain.ChunkFile> chunkList = new ArrayList<com.pg.domain.ChunkFile>();
            for (ChunkFile chunkFile : element.getChunkFiles()) {
                com.pg.domain.ChunkFile file = new com.pg.domain.ChunkFile();
                BeanUtils.copyProperties((Object)chunkFile, (Object)file);
                chunkList.add(file);
            }
            BeanUtils.copyProperties((Object)element, (Object)backupFile);
            backupFile.setBackupId(new ObjectId(element.getBackupId()));
            backupFile.getChunkFiles().clear();
            backupFile.getChunkFiles().addAll(chunkList);
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO getSyncFile ...." + e);
        }
        return backupFile;
    }

    @Override
    public void deleteBackupFile(String userNameParam, String cloudNameParam, String id, String accessToken) {
        BackupFile backupFile = null;
        try {
            String cloudName = cloudNameParam.toLowerCase();
            String userName = userNameParam.toLowerCase();
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add("userName", userName);
            headers.add(BACKUP_FILE_ID, id);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_URL + cloudName + GET_BACKUPFILE_URL;
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, BackupFile.class, new Object[0]);
            backupFile = (BackupFile)result.getBody();
            if (backupFile != null) {
                for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
                    this.deleteFile(chunkFile.getFileId(), accessToken);
                    logger.debug("@@@@@DELETED CHUNK FROM ONE DRIVE......" + chunkFile.getFileId());
                }
            }
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO delete file ...." + e);
        }
    }

    private void deleteFile(String fileName, String accessToken) throws Exception {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        String url = "https://apis.live.net/v5.0/" + fileName + "?access_token=" + accessToken;
        restTemplate.delete(url, new Object[0]);
        reqFactory.destroy();
    }

    @Override
    public FileInfo getFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("userName", userName);
        headers.add(BACKUP_FILE_ID, dedupifiedBackupId);
        HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_URL + cloudName + GET_BACKUPFILE_URL;
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, BackupFile.class, new Object[0]);
        BackupFile backupFile = (BackupFile)result.getBody();
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFileName(backupFile.getFileName());
        fileInfo.setFilePath(backupFile.getFilePath());
        for (com.pg.domain.ChunkFile chunkFile : backupFile.getChunkFiles()) {
            fileInfo.getChunkFiles().add(chunkFile.getFileName());
        }
        fileInfo.setDeviceUUID(backupFile.getDeviceUUID());
        fileInfo.setMd5(backupFile.getMd5());
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while getting fileinfo:" + e.getMessage());
        }
        return fileInfo;
    }

    private static String getConvertDBCharacters(String dbName) {
        String convertedValue = dbName.replace(".", "_");
        convertedValue = convertedValue.replace("@", "_");
        convertedValue = convertedValue.replaceAll(" ", "_");
        convertedValue = convertedValue.replaceAll("/", "");
        return convertedValue;
    }

    @Override
    public FileInfo getBackupFileInfo(String cloudName, String userName, String gatewayName, String dedupifiedBackupId) {
        this.logMessage("###Before, inside getBackupFileInfo### ");
        FileInfo fileInfo = null;
        String dbname = PRIVACY_GATEWAY_BACKUP + cloudName;
        try {
            dbname = FileDaoImpl.getConvertDBCharacters(dbname);
            fileInfo = this.getPgFileFromMongo(1, cloudName, dedupifiedBackupId, true);
            if (fileInfo != null) {
                logger.debug(" file from db...");
                return fileInfo;
            }
            String bkpCollectionName = FileDaoImpl.getConvertDBCharacters(dbname + "_bkp");
            fileInfo = this.getFileInforFromLocal(bkpCollectionName, dedupifiedBackupId);
        }
        catch (Exception e) {
            logger.debug(PARENT_FILE_NOT_IN_PG + e);
            logger.error(PARENT_FILE_NOT_IN_PG + e.getMessage());
        }
        return fileInfo;
    }

    @Override
    public List<com.pg.domain.ChunkFile> getBackupFileIfExists(String userName, String cloudName, String dedupBackupId, String gatewayName) {
        BackupFile backupFile = null;
        try {
            HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
            ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
            messageConverters.add(new MappingJackson2HttpMessageConverter());
            restTemplate.setMessageConverters(messageConverters);
            HttpHeaders headers = new HttpHeaders();
            headers.add("userName", userName);
            headers.add(BACKUP_FILE_ID, dedupBackupId);
            HttpEntity entity = new HttpEntity((Object)PARAMETERS, (MultiValueMap)headers);
            String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + PARACLOUD_CLOUD_URL + cloudName + GET_BACKUPFILE_URL;
            ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, BackupFile.class, new Object[0]);
            backupFile = (BackupFile)result.getBody();
            reqFactory.destroy();
            return backupFile.getChunkFiles();
        }
        catch (Exception e) {
            logger.error(" !!!!! ERROR TRYING TO getBackupFileIfExists ...." + e);
            try {
                FileInfo fileInfo = this.getBackupFileInfo(cloudName, userName, gatewayName, dedupBackupId);
                logger.debug(" !!!!! Got dedupified file from fileinfo ...." + dedupBackupId);
                ArrayList<com.pg.domain.ChunkFile> list = new ArrayList<com.pg.domain.ChunkFile>();
                for (String fileName : fileInfo.getChunkFiles()) {
                    com.pg.domain.ChunkFile chunkFile = new com.pg.domain.ChunkFile();
                    chunkFile.setFileName(fileName);
                    chunkFile.setMd5(fileName);
                    chunkFile.setFileId(fileName);
                    chunkFile.setFileSource(fileName);
                    chunkFile.setfSPath("fSPath");
                    list.add(chunkFile);
                }
                return list;
            }
            catch (Exception e1) {
                logger.error(" !!!!! @@@ERROR TRYING TO getPGBackupFile ...." + e1);
                return Collections.emptyList();
            }
        }
    }

    @Override
    public long getThreadSize(String cloudName) {
        return 0L;
    }

    @Override
    public synchronized void saveFileInfoForTrends(BackupFile backupFile, String cloudNameParam, String gatewayName, String storagePlace) {
        logger.debug("SAVE FILE INFO FOR TREND REPORTS");
        try {
            double sizeInMb = this.changeSizeToMb(backupFile.getSize());
            CacheHelper.getInstance().updateCloudSize(cloudNameParam, true, Double.valueOf(sizeInMb));
        }
        catch (Exception e) {
            logger.debug("Error..." + e.getMessage());
            logger.trace("Exception.. " + e);
        }
    }

    private double changeSizeToMb(Long fileSize) {
        Double size = 0.0;
        DecimalFormat numberFormat = new DecimalFormat("#.00");
        if (fileSize != null) {
            size = (double)(fileSize / 1024L) / 1024.0;
            String sizeInMb = numberFormat.format(size);
            logger.debug("Size In Md>>>>>>>>>>>" + sizeInMb);
            size = Double.valueOf(sizeInMb);
            logger.debug("Size In Mb after converting to double>>>>>>>>>>>" + size);
        }
        return size;
    }

    @Override
    public void deleteSyncFile(FileInfo fileInfo, String cloudNameParam, String gatewayNameParam) {
        this.deleteFile(true, fileInfo, cloudNameParam);
    }

    public PciAuthorizationTokens getPciAuthorizationTokensForUserName(int cloudId, String userName) {
        PciAuthorizationTokens pciAuthorizationTokens = null;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)"deleted").is((Object)false), Criteria.where((String)"deleted").exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()));
            pciAuthorizationTokens = (PciAuthorizationTokens)this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, PciAuthorizationTokens.class);
        }
        return pciAuthorizationTokens;
    }

    @Override
    public FileInfo getFileFromPG(String userName, String cloudNameParam, String id, boolean sync) {
        logger.debug("....getFileFromPG .........." + id);
        String queuename = this.getCollectionName(!sync, cloudNameParam);
        FileInfo fileInfo = this.getFileInforFromLocal(queuename, id);
        if (fileInfo != null) {
            logger.debug("...file from pg....");
            return fileInfo;
        }
        return this.getPgFileFromMongo(1, cloudNameParam, id, !sync);
    }

    protected FileInfo getFileInforFromLocal(String collectionName, String fileInfoId) {
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfoId));
        return (FileInfo)this.blukrypytMongoTemplate.findOne(query, FileInfo.class, pgCollectionName);
    }

    @Override
    @Transactional
    public void updateFileInfo(String cloudName, String gatewayName, FileInfo fileInfo) {
        this.deleteFile(fileInfo, cloudName);
        this.saveFileInfo(fileInfo, true, cloudName);
    }

    @Override
    @Transactional
    public void moveFailedFilesToBkpQueue(FileInfo fileInfo, String cloudName, boolean isBlackListUser) {
        this.logMessage("Before saving bkp queue file info");
        if (isBlackListUser) {
            String blackListCollectionName = this.getBlackListCollectionName(true, cloudName);
            this.saveToBlackListDb(fileInfo, blackListCollectionName);
        } else {
            String bkpCollectionName = this.getBkpCollectionName(true, cloudName);
            this.saveToLocalDb(fileInfo, bkpCollectionName);
        }
        this.logMessage("End of saving bkp queue file info");
    }

    private String getBkpCollectionName(boolean isBackup, String cloudNameparam) {
        String cloudName = cloudNameparam.toLowerCase();
        String collectionName = isBackup ? PRIVACY_GATEWAY_BACKUP + cloudName + "_bkp" : PRIVACY_GETEWAY + cloudName + SYNC + "_bkp";
        collectionName = FileDaoImpl.getConvertDBCharacters(collectionName);
        return collectionName;
    }

    private String getBlackListCollectionName(boolean isBackup, String cloudNameparam) {
        String cloudName = cloudNameparam.toLowerCase();
        String collectionName = isBackup ? "BLACK_LIST_" + cloudName + "_bkp" : "BLACK_LIST_" + cloudName + SYNC;
        collectionName = FileDaoImpl.getConvertDBCharacters(collectionName);
        return collectionName;
    }

    @Override
    @Transactional
    public boolean restoreQueue(FileInfo fileInfo, Cloud cloud) {
        boolean restoreQueue = false;
        try {
            String collectionName = this.getCollectionName(true, cloud.getCloudName());
            this.saveToLocalDb(fileInfo, collectionName);
            restoreQueue = true;
        }
        catch (Exception e) {
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
        }
        return restoreQueue;
    }

    @Override
    public FileInfo getPgFileFromMongo(int cloudId, String cloudName, String backupId, boolean isBackup) {
        String collectionName = this.getBkpCollectionName(true, cloudName);
        logger.debug("...file from getPgFileFromMongo..." + collectionName);
        FileInfo fileInfo = this.getFileInforFromLocal(collectionName, backupId);
        if (fileInfo != null) {
            logger.debug("...restoring from new collection locally... ");
            return fileInfo;
        }
        logger.debug("...file from main db....");
        return this.getFileFromMainDb(cloudId, cloudName, backupId, isBackup);
    }

    private FileInfo getFileFromMainDb(int cloudId, String cloudName, String backupId, boolean isBackup) {
        String collectionName = BACKUP_PG.toUpperCase();
        logger.debug("....getPgFileFromMongo...." + collectionName);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondary());
        FileInfo fileInfo = (FileInfo)paracloudMongoTemplate.findOne(query, FileInfo.class, collectionName);
        if (fileInfo == null) {
            collectionName = isBackup ? PRIVACY_GATEWAY_BACKUP + cloudName + "_pg" : PRIVACY_GETEWAY + cloudName + SYNC + "_pg";
            collectionName = collectionName.toUpperCase();
            paracloudMongoTemplate.setReadPreference(ReadPreference.secondary());
            fileInfo = (FileInfo)paracloudMongoTemplate.findOne(query, FileInfo.class, collectionName);
        } else {
            logger.debug("...file exists...." + fileInfo.getId());
        }
        return fileInfo;
    }

    @Override
    public void removeBackupFromTempDb(int cloudId, String cloudName, ObjectId backupId, boolean isBackup) {
        logger.debug(backupId + " inside dao removebackup...." + isBackup);
        String collectionName = BACKUP_PG.toUpperCase();
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        paracloudMongoTemplate.remove(query, FileInfo.class, collectionName);
    }

    @Override
    public List<FileInfo> getFilesForUpload(String cloudName, boolean firstTime) {
        FileInfo fileInfo;
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        List<FileInfo> fileInfoList = new ArrayList();
        Criteria criteria = new Criteria();
        logger.debug(firstTime + "...sizetoupload...." + PCHelperConstant.getUploadFileSizeLimitInMB());
        if (!firstTime) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"busy").is((Object)false)});
        } else {
            try {
                MongoCollection bkpCollection = this.blukrypytMongoTemplate.getCollection(pgCollectionName);
                bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"busy"}));
                logger.debug("...busy.completed creating index for ... " + pgCollectionName);
            }
            catch (Exception e) {
                logger.debug(" Exception  :" + e.getMessage());
            }
            Query queryNew = new Query((CriteriaDefinition)criteria);
            queryNew.limit(500);
            List busyQueryFileInfoList = this.blukrypytMongoTemplate.find(queryNew, FileInfo.class, pgCollectionName);
            if (!CollectionUtils.isEmpty((Collection)busyQueryFileInfoList)) {
                for (FileInfo fileInfo2 : busyQueryFileInfoList) {
                    Update update = new Update();
                    update.set("busy", (Object)false);
                    Criteria criteriaque = new Criteria();
                    criteriaque.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)fileInfo2.getId())});
                    queryNew = new Query((CriteriaDefinition)criteriaque);
                    UpdateResult updateResult = this.blukrypytMongoTemplate.updateMulti(queryNew, update, FileInfo.class, pgCollectionName);
                    logger.debug("....update busy to true" + updateResult.getModifiedCount());
                }
            }
            try {
                MongoCollection bkpCollection = this.blukrypytMongoTemplate.getCollection(pgCollectionName);
                bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"size"}));
                logger.debug("....completed creating index for ... " + pgCollectionName);
            }
            catch (Exception e) {
                logger.debug(" Exception  :" + e.getMessage());
            }
        }
        logger.debug(firstTime + "...upload size....." + PCHelperConstant.getUploadFileSizeLimitInMB());
        Query query = new Query((CriteriaDefinition)criteria).limit(PCHelperConstant.getQueryLimit());
        query.with(new Sort(Sort.Direction.DESC, new String[]{"size"}));
        logger.debug("...sort-size started...");
        fileInfoList = this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
        logger.debug("...sort-size ended...");
        if (CollectionUtils.isEmpty(fileInfoList)) {
            query = new Query((CriteriaDefinition)Criteria.where((String)"busy").is((Object)false)).limit(PCHelperConstant.getQueryLimit());
            query.with(new Sort(Sort.Direction.DESC, new String[]{"size"}));
            fileInfoList = this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
        } else {
            logger.debug(PCHelperConstant.getUploadFileSizeLimitInMB() + "..getUploadFileSizeLimitInMB...." + ((FileInfo)fileInfoList.get(0)).getSize());
        }
        if (!CollectionUtils.isEmpty(fileInfoList) && (fileInfo = fileInfoList.get(0)) != null) {
            logger.debug("......sort-size first values......." + fileInfo.getSize() + "...." + fileInfo.getFileName() + "...." + fileInfo.getUserName());
        }
        return fileInfoList;
    }

    @Override
    public FileInfo getFileFromPG(String cloudName, String backupId) {
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        logger.debug("...file  from local val...." + pgCollectionName);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        logger.debug(pgCollectionName + "....delete file ... " + backupId);
        return (FileInfo)this.blukrypytMongoTemplate.findOne(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public boolean resetBusyFlag(String cloudName) {
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"busy").is((Object)true)).limit(100);
        Update update = new Update();
        update.set("busy", (Object)false);
        UpdateResult updateResult = this.blukrypytMongoTemplate.updateMulti(query, update, FileInfo.class, pgCollectionName);
        logger.debug("updateResult for set busy false matched count:" + updateResult.getMatchedCount() + " Modified count:" + updateResult.getModifiedCount());
        return true;
    }

    @Override
    public void updateUploadedChunks(String cloudName, Map<String, com.pg.domain.ChunkFile> uploadedFiles, FileInfo fileInfo) {
        try {
            String collectionName = this.getCollectionName(true, cloudName);
            String pgCollectionName = (collectionName + LOCAL).toUpperCase();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)fileInfo.getId())});
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.set("uploadedChunks", uploadedFiles);
            UpdateResult updateFirst = this.blukrypytMongoTemplate.updateFirst(query, update, FileInfo.class, pgCollectionName);
            logger.debug(".........." + updateFirst.getMatchedCount());
        }
        catch (Exception e) {
            logger.error(".... exception......" + e.getMessage());
        }
    }

    @Override
    public List<FileInfo> getFaileFilesForReUpload(String cloudName) {
        String bkpCollectionName = this.getBkpCollectionName(true, cloudName);
        String pgCollectionName = (bkpCollectionName + LOCAL).toUpperCase();
        Query query = new Query().limit(500);
        return this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
    }

    private void removeFromBkptable(FileInfo fileInfo, String cloudName) {
        String collectionName = this.getBkpCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        logger.debug(pgCollectionName + "....delete file ... " + fileInfo.getId());
        this.blukrypytMongoTemplate.remove(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public List<FileInfo> getFilesForSyncUpload(String cloudName) {
        String collectionName = this.getCollectionName(false, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query().limit(1000);
        return this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public void deleteSyncFile(FileInfo fileInfo, String cloudName) {
        String collectionName = this.getCollectionName(false, cloudName.toLowerCase());
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        this.blukrypytMongoTemplate.findAndRemove(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public FileInfo getFileFromMainMongoDb(int cloudId, String cloudName, String backupId) {
        String collectionName = BACKUP_PG.toUpperCase();
        logger.debug("....getPgFileFromMongo...." + collectionName);
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondary());
        return (FileInfo)paracloudMongoTemplate.findOne(query, FileInfo.class, collectionName);
    }

    @Override
    public void removeSyncFile(int cloudId, String syncRevisionId, String consolidatedId) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)syncRevisionId));
        paracloudMongoTemplate.findAndRemove(query, FileRevision.class);
        query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)consolidatedId));
        paracloudMongoTemplate.findAndRemove(query, ConsolidatedImage.class);
    }

    @Override
    public void removeSyncBackUpImageFile(int cloudId, String syncBackUpImageId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)syncBackUpImageId));
        mongoTemplate.findAndRemove(query, BackUpImage.class);
    }

    @Override
    public void removeBackupFile(int cloudId, String backupId, String destCollection) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        paracloudMongoTemplate.findAndRemove(query, BackUpImage.class, destCollection);
    }

    @Override
    public ConsolidatedImage getConsolImgbyFilenameDevicepathandUsername(int cloudId, String fileName, String filePath, String userName) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)"devicePath").is((Object)filePath), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (ConsolidatedImage)paracloudMongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public String getRevisionFileByconsolidatedImageId(int cloudId, ConsolidatedImage consolidatedImage) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"consolidatedImage").is((Object)consolidatedImage)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastModifiedTime"}));
        FileRevision fileRevision = (FileRevision)paracloudMongoTemplate.findOne(query, FileRevision.class);
        if (fileRevision != null) {
            return fileRevision.getId().toString();
        }
        return "";
    }

    @Override
    @Transactional
    public boolean saveFileInfoForODB(String cloudName, String userName, FileInfo fileInfo, String driveFileInfoId, boolean isMail) {
        logger.debug(this.blukrypytMongoTemplate + "... changeeddd template. val.1.... ");
        boolean isSuccess = this.saveFileInfo(fileInfo, cloudName, userName);
        if (isSuccess) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(driveFileInfoId)));
            logger.debug(driveFileInfoId + "....odbMsgMongoTemplate msg template... ");
            if (isMail) {
                this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class);
            } else {
                this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class);
            }
        }
        return isSuccess;
    }

    @Override
    public void removeFileInfoForAlreadyExists(String driveFileInfoId, boolean isMail, String deviceUUID) {
        String collectionName = this.getDriveFileCollectionName(deviceUUID);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(driveFileInfoId)));
        logger.debug(driveFileInfoId + "....odbMsgMongoTemplate msg template... " + isMail);
        if (isMail) {
            this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class, collectionName);
        } else {
            this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class, collectionName);
        }
    }

    private String getDriveFileCollectionName(String deviceUUID) {
        String collectionName = "DRIVE_FILE_INFO_" + deviceUUID;
        collectionName = collectionName.toUpperCase();
        return collectionName;
    }

    @Override
    public void removeFileInfoForPrevDeltaItem(String driveFileInfoId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(driveFileInfoId)));
        logger.debug(driveFileInfoId + "....PREV_DELTA_ITEMS msg template... ");
        this.msgMongoTemplate.findAndRemove(query, DriveFileInfo.class, "PREV_DELTA_ITEMS");
    }

    public boolean saveToSyncLocalDb(FileInfo fileInfo, String collectionName) {
        try {
            String pgCollectionName = (collectionName + LOCAL).toUpperCase();
            this.blukrypytMongoTemplate.save((Object)fileInfo, pgCollectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to local .... " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void moveSyncFailedFilesToBkpQueue(FileInfo fileInfo, String cloudName) {
        this.logMessage("Before saving sync bkp queue file info");
        String bkpCollectionName = this.getBkpCollectionName(false, cloudName);
        this.saveToLocalDb(fileInfo, bkpCollectionName);
        this.logMessage("End of saving sync files to bkp queue ");
    }

    @Override
    public boolean restoreSyncQueue(FileInfo fileInfo, Cloud cloud) {
        boolean restoreQueue = false;
        try {
            String collectionName = this.getCollectionName(false, cloud.getCloudName());
            this.saveToSyncLocalDb(fileInfo, collectionName);
            restoreQueue = true;
        }
        catch (Exception e) {
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
        }
        return restoreQueue;
    }

    @Override
    public List<FileInfo> getSyncFailFilesForReUpload(String cloudName) {
        String bkpCollectionName = this.getBkpCollectionName(false, cloudName);
        String pgCollectionName = (bkpCollectionName + LOCAL).toUpperCase();
        Query query = new Query().limit(500);
        return this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
    }

    private void removeSyncFileFromBkptable(FileInfo fileInfo, String cloudName) {
        String collectionName = this.getBkpCollectionName(false, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        logger.debug(pgCollectionName + "....delete file ... " + fileInfo.getId());
        this.blukrypytMongoTemplate.remove(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public boolean restoreOneFileForBlackListUser(String userName, Cloud cloud) {
        boolean restoreQueue = false;
        try {
            String collectionName = this.getBlackListCollectionName(true, cloud.getCloudName());
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
            FileInfo fileInfo = (FileInfo)this.blukrypytMongoTemplate.findOne(query, FileInfo.class, collectionName.toUpperCase());
            if (fileInfo != null) {
                this.moveFailedFilesToBkpQueueAndDeleteInLocal(fileInfo, cloud.getCloudName(), false, false, true);
            }
            restoreQueue = true;
        }
        catch (Exception e) {
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
        }
        return restoreQueue;
    }

    private void removeFromBlackListTable(FileInfo fileInfo, String cloudName) {
        String collectionName = this.getBlackListCollectionName(true, cloudName);
        String pgCollectionName = collectionName.toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)fileInfo.getId()));
        logger.debug(pgCollectionName + "....delete file from blacklist ... " + fileInfo.getId());
        this.blukrypytMongoTemplate.remove(query, FileInfo.class, pgCollectionName);
    }

    @Override
    @Transactional
    public void restoreMultiFileForBlackListUser(String userName, Cloud cloud) {
        try {
            String collectionName = this.getBlackListCollectionName(true, cloud.getCloudName());
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
            query.limit(2000);
            List list = this.blukrypytMongoTemplate.find(query, FileInfo.class, collectionName.toUpperCase());
            logger.debug("....list..." + list.size());
            for (FileInfo fileInfo : list) {
                if (fileInfo == null) continue;
                this.moveFailedFilesToBkpQueueAndDeleteInLocal(fileInfo, cloud.getCloudName(), false, false, true);
            }
        }
        catch (Exception e) {
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
            logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
        }
    }

    public String getDatabaseName() {
        return "parablumsg";
    }

    public MongoClient mongoClient() {
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)this.getDatabaseName(), (char[])"parablu".toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().build();
        MongoClient client = new MongoClient(Arrays.asList(new ServerAddress(PCHelperConstant.getPropertyValueDBHost1().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort1().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost2().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort2().trim())), new ServerAddress(PCHelperConstant.getPropertyValueDBHost3().trim(), Integer.parseInt(PCHelperConstant.getPropertyValueDBPort3().trim()))), credential, options);
        return client;
    }

    public MongoDbFactory mongoDbFactory() {
        SimpleMongoDbFactory factory = new SimpleMongoDbFactory(this.mongoClient(), this.getDatabaseName());
        return factory;
    }

    public MongoTemplate odbMongoTemplate() {
        MongoTemplate template = new MongoTemplate(this.mongoDbFactory());
        return template;
    }

    public MongoTemplate mailMongoTemplate() {
        MongoTemplate template = new MongoTemplate(this.mongoDbFactory());
        return template;
    }

    @Override
    public Set<String> getBluKyptCollections() {
        Set collectionNames = this.blukrypytMongoTemplate.getCollectionNames();
        return collectionNames;
    }

    @Override
    public void dropBluCollBasedonBatchstatus(String collName) {
        this.blukrypytMongoTemplate.dropCollection(collName);
    }

    protected long getPGFileCount(String collectionName, String gatewayName) {
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"gatewayName").is((Object)gatewayName));
        return this.blukrypytMongoTemplate.count(query, FileInfo.class, pgCollectionName);
    }

    @Override
    public long getPgFileCount(int cloudId, String cloudName, String gatewayName) {
        String collectionName = this.getBkpCollectionName(true, cloudName);
        return this.getPGFileCount(collectionName, gatewayName);
    }

    @Override
    public boolean saveContentChunkFileInfoInMongo(ContentChunkFile contentChunkFile, String fileName, String cloudName, boolean isUpdate) {
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + fileName.toUpperCase();
            if (isUpdate) {
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"fileName").is((Object)contentChunkFile.getFileName())});
                Query query = new Query((CriteriaDefinition)criteria);
                this.blukrypytMongoTemplate.findAllAndRemove(query, ContentChunkFile.class, collectionName);
            }
            logger.debug("Content chunk table name...." + collectionName);
            this.blukrypytMongoTemplate.save((Object)contentChunkFile, collectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... " + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void delCollIfSameNameExists(String tableName) {
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase();
            logger.debug("Collection name is:" + collectionName);
            Set collectioinNames = this.blukrypytMongoTemplate.getCollectionNames();
            logger.debug("Collection is conatains value of:" + tableName.split("_")[0]);
            collectioinNames.forEach(collName -> {
                logger.debug(collName + " Collection conatains or not :" + tableName);
                if (collName.contains(CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.split("_")[0].toUpperCase())) {
                    logger.debug(collName + " Collection conatains is:" + tableName);
                    if (!collName.equalsIgnoreCase(collectionName)) {
                        logger.debug("crc value for the previous collection is:" + collName);
                        this.blukrypytMongoTemplate.dropCollection(collName);
                        logger.debug("collection dropped successfully..");
                    } else {
                        logger.debug("Both collection are same" + collName);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("...errror trying to get coll details .... ", (Throwable)e);
            return;
        }
        logger.debug("End of check delCollIfSameNameExists");
    }

    @Override
    public boolean isCollExists(String tableName) {
        boolean exists = false;
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase();
            logger.debug("Collection name is:" + collectionName);
            exists = this.blukrypytMongoTemplate.collectionExists(collectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to get coll details .... ", (Throwable)e);
            return exists;
        }
        return exists;
    }

    @Override
    public ContentChunkFile getContentChunkFileInfoInMongo(String tableName, String fileName, String cloudName) {
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            return (ContentChunkFile)this.blukrypytMongoTemplate.findOne(query, ContentChunkFile.class, collectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... ", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean removeContentChunkFileInfoInMongo(ContentChunkFile contentChunkFile, String tableName, String cloudName) {
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)contentChunkFile.getId())});
            Query query = new Query((CriteriaDefinition)criteria);
            this.blukrypytMongoTemplate.remove(query, ContentChunkFile.class, collectionName);
            return true;
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean removeContentChunkFileByName(String fileName, String tableName, String cloudName) {
        try {
            String collectionName = CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            this.blukrypytMongoTemplate.findAllAndRemove(query, ContentChunkFile.class, collectionName);
            return true;
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean dropContentChunkFileCollectionInMongo(String tableName, String cloudName, String type) {
        try {
            String collectionName = type.equalsIgnoreCase("contentChunk") ? CONTENT_CHUNK_PG.toUpperCase() + "_" + tableName.toUpperCase() : CHUNK_DETAIL_PG.toUpperCase() + "_" + tableName.toUpperCase();
            this.blukrypytMongoTemplate.dropCollection(collectionName);
            return true;
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... " + e.getMessage());
            return false;
        }
    }

    @Override
    public List<ContentChunkFile> getFilesForContentChunkStatus(String tableNameHash, String queryParam, int skipValue) {
        String pgCollectionName = (CONTENT_CHUNK_PG.toUpperCase() + "_" + tableNameHash).toUpperCase();
        logger.debug("pgCollectionName....." + pgCollectionName);
        Query query = new Query().skip((long)skipValue);
        return this.blukrypytMongoTemplate.find(query, ContentChunkFile.class, pgCollectionName);
    }

    @Override
    public ChunkDetail getChunkDetailFromLocalMongo(String tableName, String md5) {
        try {
            String collectionName = CHUNK_DETAIL_PG.toUpperCase() + "_" + tableName.toUpperCase();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
            Query query = new Query((CriteriaDefinition)criteria);
            return (ChunkDetail)this.blukrypytMongoTemplate.findOne(query, ChunkDetail.class, collectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to save to mongo .... ", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ChunkDetail> getAllChunkDetailsFromLocalMongo(String tableName) {
        try {
            logger.debug("Taking all files from local chunk detail table name:" + tableName);
            String collectionName = CHUNK_DETAIL_PG.toUpperCase() + "_" + tableName.toUpperCase();
            return this.blukrypytMongoTemplate.findAll(ChunkDetail.class, collectionName);
        }
        catch (Exception e) {
            logger.error("...errror trying to gt from mongo .... ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveChunkDetailFromLocalMongo(String tableName, ChunkDetail chunkDetail) {
        try {
            String collectionName = CHUNK_DETAIL_PG.toUpperCase() + "_" + tableName.toUpperCase();
            this.blukrypytMongoTemplate.save((Object)chunkDetail, collectionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @Transactional
    public synchronized void moveFailedFilesToBkpQueueAndDeleteInLocal(FileInfo fileInfo, String cloudName, boolean isBlackListUser, boolean moveFromLocalTOBkp, boolean moveFromblackListToLocal) {
        this.logMessage("Before saving bkp queue file info");
        boolean isFileMoved = false;
        if (moveFromLocalTOBkp) {
            if (isBlackListUser) {
                String blackListCollectionName = this.getBlackListCollectionName(true, cloudName);
                isFileMoved = this.saveToBlackListDb(fileInfo, blackListCollectionName);
            } else {
                String bkpCollectionName = this.getBkpCollectionName(true, cloudName);
                isFileMoved = this.saveToLocalDb(fileInfo, bkpCollectionName);
            }
            if (isFileMoved) {
                this.deleteFile(fileInfo, cloudName);
            }
        } else if (moveFromblackListToLocal) {
            try {
                String collectionName = this.getCollectionName(true, cloudName);
                if (this.saveToLocalDb(fileInfo, collectionName)) {
                    this.removeFromBlackListTable(fileInfo, cloudName);
                }
            }
            catch (Exception e) {
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
            }
        } else {
            try {
                String collectionName = this.getCollectionName(true, cloudName);
                if (this.saveToLocalDb(fileInfo, collectionName)) {
                    this.removeFromBkptable(fileInfo, cloudName);
                }
            }
            catch (Exception e) {
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
            }
            this.logMessage("End of saving bkp queue file info");
        }
    }

    @Override
    @Transactional
    public synchronized void moveFailedFilesToBkpQueueAndDeleteInLocalForSync(FileInfo fileInfo, String cloudName, boolean moveFromLocalTOBkp) {
        this.logMessage("Before saving bkp queue file info");
        boolean isFileMoved = false;
        if (moveFromLocalTOBkp) {
            this.logMessage("Before saving sync bkp queue file info");
            String bkpCollectionName = this.getBkpCollectionName(false, cloudName);
            isFileMoved = this.saveToLocalDb(fileInfo, bkpCollectionName);
            this.logMessage("End of saving sync files to bkp queue ");
            if (isFileMoved) {
                this.deleteFile(false, fileInfo, cloudName);
            }
        } else {
            try {
                String collectionName = this.getCollectionName(false, cloudName);
                if (this.saveToLocalDb(fileInfo, collectionName)) {
                    this.removeSyncFileFromBkptable(fileInfo, cloudName);
                }
            }
            catch (Exception e) {
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e.getMessage());
                logger.error(NOT_ABLE_TO_RESTORE_TO_QUEUE + e);
            }
            this.logMessage("End of saving bkp queue file info");
        }
    }

    @Override
    @Transactional
    public void moveFailedFilesToDiffQueueAndDeleteInLocal(FileInfo fileInfo, String cloudName, boolean isBlackListUser) {
        this.logMessage("Before saving bkp queue file info diff que ");
        boolean isFileMoved = false;
        if (isBlackListUser) {
            String blackListCollectionName = this.getBlackListCollectionName(true, "FAILED");
            isFileMoved = this.saveToBlackListDb(fileInfo, blackListCollectionName);
        } else {
            String bkpCollectionName = this.getBkpCollectionName(true, cloudName);
            isFileMoved = this.saveToLocalDb(fileInfo, bkpCollectionName);
        }
        if (isFileMoved) {
            this.deleteFile(fileInfo, cloudName);
        }
        this.logMessage("End of saving bkp queue file info");
    }

    @Override
    public void addFailedFiles(DriveFileInfo item, String policyName) {
        this.msgMongoTemplate.save((Object)item, "RETRY_FAILED_FILES");
    }

    @Override
    public List<DriveFileInfo> getFailedFiles(String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.msgMongoTemplate.find(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public void saveFileInfoBusy(FileInfo fileInfo, String cloudName) {
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)fileInfo.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("busy", (Object)true);
        this.blukrypytMongoTemplate.updateFirst(query, update, FileInfo.class, pgCollectionName);
    }

    @Override
    public long getRWSampleFilesCount(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(RwSampleFileInfo.class);
        return list.size();
    }

    @Override
    public void saveRWSampleFiles(int cloudId, RwSampleFileInfo rwSampleFileInfo) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)rwSampleFileInfo, "RW_SAMPLE_FILES");
    }

    @Override
    public List<String> getRWSampleFilesList(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(RwSampleFileInfo.class);
        ArrayList<String> md5List = new ArrayList<String>();
        for (RwSampleFileInfo rw : list) {
            md5List.add(rw.getMd5Checksum());
        }
        return md5List;
    }

    @Override
    public List<String> getRWSampleFilesListNew(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.findAll(RwSampleFileInfoNames.class);
        ArrayList<String> md5List = new ArrayList<String>();
        for (RwSampleFileInfoNames rw : list) {
            md5List.add(rw.getFileName());
        }
        return md5List;
    }

    @Override
    public boolean deleteAllBlukryptDbForDeviceUUID(Cloud cloud, String deviceUUID, String userName, String destColection) {
        boolean allRecDeleted = false;
        String cloudName = cloud.getCloudName().toLowerCase();
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Criteria criteriaObj = new Criteria();
        criteriaObj.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"storagePlace").ne((Object)"CLOUD"), Criteria.where((String)"folder").is((Object)false)});
        logger.debug("...criteria..");
        Query query = new Query((CriteriaDefinition)criteriaObj);
        query.limit(50);
        logger.debug("...query...");
        ArrayList backUpImageList = new ArrayList();
        int i = 0;
        do {
            backUpImageList = new ArrayList();
            logger.debug("...beofre files to delete....." + i);
            Query query1 = new Query((CriteriaDefinition)criteriaObj);
            query1.limit(50);
            List list = paracloudMongoTemplate.find(query1, BackUpImage.class, destColection);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                backUpImageList.addAll(list);
            }
            logger.debug(i + "...files to delete....." + backUpImageList.size());
            if (!CollectionUtils.isEmpty(backUpImageList)) {
                logger.debug("....file exists..." + backUpImageList.size());
                for (BackUpImage bkpImage : backUpImageList) {
                    Criteria criteria = new Criteria();
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)bkpImage.getId())});
                    Query query2 = new Query((CriteriaDefinition)criteria);
                    this.blukrypytMongoTemplate.remove(query2, FileInfo.class, pgCollectionName);
                    String blackListCollectionName = this.getBlackListCollectionName(true, cloudName).toUpperCase();
                    this.blukrypytMongoTemplate.remove(query2, FileInfo.class, blackListCollectionName);
                    paracloudMongoTemplate.remove(query2, FileInfo.class, BACKUP_PG.toUpperCase());
                    paracloudMongoTemplate.remove(query2, BackUpImage.class, destColection);
                }
            } else {
                logger.debug("...files to allRecDeleted....." + backUpImageList.size());
                allRecDeleted = true;
            }
            ++i;
        } while (!CollectionUtils.isEmpty(backUpImageList));
        if (allRecDeleted) {
            logger.debug("....no rec..." + deviceUUID);
            allRecDeleted = true;
            Query queryObj = new Query((CriteriaDefinition)Criteria.where((String)"deviceUUID").is((Object)deviceUUID));
            Device device = (Device)paracloudMongoTemplate.findOne(queryObj, Device.class);
            if (device != null) {
                logger.debug("...update device...");
                device.setFilesDelStorageIssue(true);
                paracloudMongoTemplate.save((Object)device);
            } else {
                logger.debug("... device does not exists...");
            }
        } else {
            logger.debug("....rec exists...");
        }
        return allRecDeleted;
    }

    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    @Override
    public FileInfo getFileInfoForBatch(String batchId, String cloudName) {
        String collectionName = this.getCollectionName(true, cloudName);
        String pgCollectionName = (collectionName + LOCAL).toUpperCase();
        List fileInfoList = new ArrayList();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"batchId").is((Object)batchId));
        fileInfoList = this.blukrypytMongoTemplate.find(query, FileInfo.class, pgCollectionName);
        FileInfo fileInfo = null;
        if (!CollectionUtils.isEmpty(fileInfoList)) {
            fileInfo = (FileInfo)fileInfoList.get(0);
        }
        return fileInfo;
    }

    @Override
    public List<CMBackUpImage> getFilesForArchiving(String cloudName, boolean firstTime, String productType) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Criteria criteria = new Criteria();
        String dbName = "";
        String faildbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
            faildbName = "FAILED_CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        logger.debug(firstTime + "...getFilesForArchiving....");
        Query queryNew = new Query((CriteriaDefinition)criteria);
        queryNew.limit(25);
        List failedfileInfoList = mongoTemplate.find(queryNew, CMBackUpImage.class, faildbName);
        if (CollectionUtils.isEmpty((Collection)failedfileInfoList)) {
            for (CMBackUpImage failCmBackUpImage : failedfileInfoList) {
                mongoTemplate.save((Object)failCmBackUpImage, dbName);
                mongoTemplate.remove((Object)failCmBackUpImage, faildbName);
            }
        }
        ArrayList<CMBackUpImage> fileInfoList = new ArrayList();
        fileInfoList = mongoTemplate.find(queryNew, CMBackUpImage.class, dbName);
        logger.debug("...getFilesForArchiving...." + fileInfoList);
        return fileInfoList;
    }

    @Override
    public CMBackUpImage getCMBackupImage(String cloudName, String backupId, String productType) {
        String dbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        logger.debug("....file details ... " + backupId);
        return (CMBackUpImage)mongoTemplate.findOne(query, CMBackUpImage.class, dbName);
    }

    @Override
    public void deleteCPMgtImage(int cloudId, ObjectId id, String productType) {
        String dbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        logger.debug("....file details ... " + id);
        mongoTemplate.remove(query, CMBackUpImage.class, dbName);
    }

    @Override
    public void saveFileInfoBusy(String cloudName, String userName, CMBackUpImage cmBackUpImage) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)cmBackUpImage.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("busy", (Object)true);
        mongoTemplate.updateFirst(query, update, CMBackUpImage.class);
    }

    @Override
    public void moveCPMgtImage(int cloudId, CMBackUpImage cmBackUpImage, String productType) {
        String dbName = "";
        if (productType.equalsIgnoreCase(Device.TYPE.SHAREPOINT.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_SP";
        } else if (productType.equalsIgnoreCase(Device.TYPE.ONEDRIVE.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_ODB";
        } else if (productType.equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            dbName = "CAPACITY_MGMT_BACKUP_OUTLOOK";
        }
        CMBackUpImage backUpImageNew = new CMBackUpImage();
        BeanUtils.copyProperties((Object)cmBackUpImage, (Object)backUpImageNew);
        backUpImageNew.setLastRecordForBatch(false);
        backUpImageNew.setId(null);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backUpImageNew, dbName);
        mongoTemplate.remove((Object)cmBackUpImage, dbName);
    }
}

