/*
 * Decompiled with CFR 0.152.
 */
package com.pg.gzip;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.springframework.oxm.Marshaller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.view.xml.MarshallingView;

public class GzipMarshallView
extends MarshallingView {
    private Marshaller customMarshaller;

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object toBeMarshalled = this.locateToBeMarshalled(model);
        if (toBeMarshalled == null) {
            throw new ServletException("Unable to locate object to be marshalled in model: " + model);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bos);
        this.customMarshaller.marshal(toBeMarshalled, (Result)new StreamResult(gzipOutputStream));
        gzipOutputStream.close();
        response.setContentType(this.getContentType());
        response.setContentLength(bos.size());
        FileCopyUtils.copy((byte[])bos.toByteArray(), (OutputStream)response.getOutputStream());
    }

    public void setCustomMarshaller(Marshaller customMarshaller) {
        this.customMarshaller = customMarshaller;
    }
}

