/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.microsoft.graph.core.DateOnly;
import com.microsoft.graph.models.RecurrenceRange;
import java.io.IOException;
import java.time.LocalDate;

public class RecurrenceRangeDeserializer
extends JsonDeserializer<RecurrenceRange> {
    public RecurrenceRange deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        RecurrenceRange range = new RecurrenceRange();
        String fieldName = "";
        while (jsonParser.nextToken() != null) {
            fieldName = jsonParser.getCurrentName();
            if ("startDate".equals(fieldName)) {
                jsonParser.nextToken();
                range.startDate = this.parseDate(jsonParser.getText());
                continue;
            }
            if ("endDate".equals(fieldName)) {
                jsonParser.nextToken();
                range.endDate = this.parseDate(jsonParser.getText());
                continue;
            }
            jsonParser.skipChildren();
        }
        return range;
    }

    private DateOnly parseDate(String dateStr) {
        LocalDate localDate = LocalDate.parse(dateStr);
        return new DateOnly(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
    }
}

