/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.CMBackUpImage;
import com.parablu.pcbd.domain.CPBackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class ODBCapacityMgmtJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(ODBCapacityMgmtJob.class);
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private static final String STOPPED_BACKUP_ERROR_CODE = "1207";
    private static final String PAUSED_BACKUP_ERROR_CODE = "1992";
    private static List<CMBackUpImage> fileInfoList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private UploadService uploadService;
    private UtilService utilService;
    private Set<String> filesUnderProcess = new HashSet<String>();
    private static final String COUNT_429 = "CountOf429";

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        block35: {
            if (!PCHelperConstant.isJobEnabled((String)"odbCapacityMgmtJobTrigger")) {
                logger.debug("ODBCapacityMgmtJob ............. disabled");
                return;
            }
            final Cloud cloud = this.utilService.getCloud(1);
            boolean onedriveLinkEnabled = this.isOneDriveArchivingEnabled(cloud);
            if (!PCHelperConstant.isParacloud() || !onedriveLinkEnabled) {
                logger.debug(PCHelperConstant.isParacloud() + "..sant.not main machine..sleep for 30 mins." + onedriveLinkEnabled);
                try {
                    Thread.sleep(TimeUnit.MINUTES.toMinutes(30L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return;
            }
            logger.debug("@@@@ODBCapacityMgmtJob started ..... " + PCHelperConstant.getODBCallFrequency());
            try {
                boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
                if (isJobsShouldStop) {
                    logger.debug("stopJobsEnabled in privacygateway.properties so return");
                    return;
                }
                long batchStartTime = System.currentTimeMillis();
                CPBackupBatch cpBackupBatch = new CPBackupBatch();
                boolean pausedCase = false;
                String backupBatchId = "";
                CPBackupBatch existBackupBatch = this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                if (existBackupBatch != null && existBackupBatch.isManualJob()) {
                    logger.debug("....manual job running so wait..");
                    break block35;
                }
                if (existBackupBatch != null) {
                    logger.debug(".....inside exist....");
                    cpBackupBatch = existBackupBatch;
                    backupBatchId = cpBackupBatch.getId().toString();
                } else {
                    logger.debug(".....inside 1....");
                    CPBackupBatch exisBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                    if (exisBatch != null && exisBatch.getStatus().equalsIgnoreCase("PAUSED")) {
                        logger.debug(".....inside 2....");
                        pausedCase = true;
                        backupBatchId = exisBatch.getId().toString();
                        boolean startedCaseExists = true;
                        do {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(20L));
                            existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                            logger.debug(".....inside 3...." + existBackupBatch);
                            if (existBackupBatch != null && existBackupBatch.getStatus().equalsIgnoreCase("PAUSED")) {
                                startedCaseExists = true;
                                logger.debug(".....inside 4...." + existBackupBatch);
                                continue;
                            }
                            startedCaseExists = false;
                            logger.debug(".....inside 5...." + existBackupBatch);
                        } while (startedCaseExists);
                    } else {
                        CPBackupBatch existBackupBatchCreated;
                        this.utilService.createCPBackupBatch(cloud.getCloudId(), OfficeBackupPolicy.TYPE.ODB.toString(), false);
                        cpBackupBatch = existBackupBatchCreated = this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                    }
                    if (!pausedCase) {
                        cpBackupBatch.setStatus(CPBackupBatch.STATUS.STARTED.toString());
                        cpBackupBatch.setProductType(Device.TYPE.ONEDRIVE.name());
                        if (existBackupBatch == null) {
                            // empty if block
                        }
                        backupBatchId = this.utilService.saveCPBackupBatch(cloud.getCloudId(), cpBackupBatch);
                    }
                }
                List latestList = this.uploadService.getFilesForArchiving(cloud.getCloudName(), false, Device.TYPE.ONEDRIVE.name());
                boolean i = false;
                latestList.removeAll(Collections.singleton(null));
                String errorCode = "";
                boolean lastRecord = false;
                if (CollectionUtils.isEmpty((Collection)latestList)) {
                    lastRecord = true;
                }
                do {
                    String backupBatchIdFinal = backupBatchId;
                    if (!CollectionUtils.isEmpty((Collection)latestList)) {
                        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("MailCP-$$%d$$");
                        CountDownLatch latch = new CountDownLatch(latestList.size());
                        ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                        for (CMBackUpImage cmBackUpImage : latestList) {
                            Runnable uploadJob = () -> this.processBkpImage(cmBackUpImage, backupBatchIdFinal, cloud, latch);
                            executorService.submit(uploadJob);
                        }
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        executorService.shutdown();
                    } else {
                        logger.debug("...no files to process... ");
                    }
                    existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                    if (existBackupBatch != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode())) {
                        logger.debug(",,,,errorcode11...." + existBackupBatch.getErrorCode());
                        if (existBackupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE)) {
                            errorCode = STOPPED_BACKUP_ERROR_CODE;
                            break;
                        }
                        if (existBackupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE)) {
                            errorCode = PAUSED_BACKUP_ERROR_CODE;
                            break;
                        }
                    }
                    logger.debug(lastRecord + "....completed 1000 file batch..." + errorCode);
                    if (!StringUtils.isEmpty((String)errorCode)) {
                        lastRecord = true;
                    }
                    String uploadedFiles = existBackupBatch.getUploadedFiles();
                    logger.debug("....completed  file batch..." + uploadedFiles);
                    try {
                        if (!StringUtils.isEmpty((String)uploadedFiles)) {
                            String[] parts = uploadedFiles.split("/");
                            int actualNoOfFiles = Integer.parseInt(parts[1]);
                            int noOfFilesBackedup = Integer.parseInt(parts[0]);
                            logger.debug(uploadedFiles + "....totalfiles...." + actualNoOfFiles + "..." + noOfFilesBackedup);
                            if (actualNoOfFiles != 0 && noOfFilesBackedup != 0 && actualNoOfFiles == noOfFilesBackedup) {
                                lastRecord = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.trace(" Exception  :" + e);
                        logger.error(" Exception  :" + e.getMessage());
                    }
                    if (!lastRecord) {
                        latestList = this.uploadService.getFilesForArchiving(cloud.getCloudName(), false, Device.TYPE.ONEDRIVE.name());
                        latestList.removeAll(Collections.singleton(null));
                    } else {
                        latestList = new ArrayList();
                    }
                    logger.debug(lastRecord + ",,,,errorcode...." + errorCode);
                    logger.debug(CollectionUtils.isEmpty(latestList) + ".....batch size...." + latestList.size());
                } while (!lastRecord || !CollectionUtils.isEmpty(latestList));
                logger.debug(",,,,errorcode...." + errorCode);
                if (StringUtils.isEmpty((String)errorCode) || "0".equalsIgnoreCase(errorCode)) {
                    logger.debug(",,,,wait 2 min before complete...." + errorCode);
                    Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
                    cpBackupBatch = this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                    cpBackupBatch.setBatchEndTimestamp(System.currentTimeMillis());
                    cpBackupBatch.setStatus(CPBackupBatch.STATUS.COMPLETED.toString());
                    this.utilService.saveCPBackupBatch(cloud.getCloudId(), cpBackupBatch);
                } else {
                    final Timer timer = new Timer();
                    timer.scheduleAtFixedRate(new TimerTask(){
                        int counter = 0;

                        @Override
                        public void run() {
                            logger.debug("Message printed at " + this.counter + " seconds.");
                            CPBackupBatch existBackupBatch = ODBCapacityMgmtJob.this.utilService.getCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
                            if (existBackupBatch != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode()) && existBackupBatch.getErrorCode().equals(ODBCapacityMgmtJob.PAUSED_BACKUP_ERROR_CODE)) {
                                if (this.counter > 10) {
                                    this.counter -= 10;
                                }
                            } else {
                                timer.cancel();
                            }
                            this.counter += 10;
                            if (this.counter >= 1200) {
                                timer.cancel();
                            }
                        }
                    }, 0L, 10000L);
                }
                logger.debug(" ...completed capacity mgmt..........");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(" exception in backup upload job......." + e.getMessage());
                logger.trace("exception in backup upload job ......." + e);
            }
        }
    }

    private boolean isOneDriveArchivingEnabled(Cloud cloud) {
        boolean isOneDriveArchivingEnabled = false;
        List licenseDetails = cloud.getCloudCustomisableDetails();
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"OneDrive Archiving Enabled".equalsIgnoreCase(license.getName())) continue;
            isOneDriveArchivingEnabled = true;
            break;
        }
        return isOneDriveArchivingEnabled;
    }

    private void processBkpImage(CMBackUpImage cmBackUpImage, String backupBatchId, Cloud cloud, CountDownLatch latch) {
        logger.debug(cmBackUpImage.getId().toString() + "&&&&&&&&&&&&&DATE&&&&&&&&&&&&" + ODBCapacityMgmtJob.getDateInFormat(cmBackUpImage.getLastModifiedTime()));
        boolean lastRecord = false;
        CPBackupBatch existBackupBatch = this.utilService.getLatestCPBackupBatch(cloud.getCloudId(), Device.TYPE.ONEDRIVE.name());
        String errorCode = "";
        if (existBackupBatch != null && StringUtils.isNotEmpty((String)existBackupBatch.getErrorCode())) {
            logger.debug(",,,,errorcode11...." + existBackupBatch.getErrorCode());
            if (existBackupBatch.getErrorCode().equals(STOPPED_BACKUP_ERROR_CODE)) {
                errorCode = STOPPED_BACKUP_ERROR_CODE;
                lastRecord = true;
            } else if (existBackupBatch.getErrorCode().equals(PAUSED_BACKUP_ERROR_CODE)) {
                errorCode = PAUSED_BACKUP_ERROR_CODE;
                lastRecord = true;
            }
        }
        String uploadedFiles = existBackupBatch.getUploadedFiles();
        try {
            if (!StringUtils.isEmpty((String)uploadedFiles)) {
                String[] parts = uploadedFiles.split("/");
                int actualNoOfFiles = Integer.parseInt(parts[1]);
                int noOfFilesBackedup = Integer.parseInt(parts[0]);
                logger.debug(uploadedFiles + "....totalfiles...." + actualNoOfFiles + "..." + noOfFilesBackedup);
                if (actualNoOfFiles != 0 && noOfFilesBackedup != 0 && actualNoOfFiles == noOfFilesBackedup) {
                    lastRecord = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace(" Exception  :" + e);
            logger.error(" Exception  :" + e.getMessage());
        }
        if (!lastRecord) {
            boolean fileProcessed = this.processFiles(cmBackUpImage, cloud, backupBatchId);
            long size = 0L;
            if (fileProcessed) {
                size = cmBackUpImage.getSizeInBytes();
            }
        }
        latch.countDown();
    }

    private FileStatusElement uploadFile(CMBackUpImage cmBackUpImage, Cloud cloud, String backupBatchId) {
        FileStatusElement element = new FileStatusElement();
        try {
            element = this.uploadService.createLinks(cloud, cmBackUpImage, backupBatchId);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(cmBackUpImage.getId().toString() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return element;
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD).replaceAll(":", ".");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dateStringFormat;
    }

    public boolean processFiles(CMBackUpImage cmBackUpImage, Cloud cloud, String cpBackupBatchId) {
        boolean isFileUploaded = false;
        try {
            String idVal = cmBackUpImage.getId().toString();
            logger.debug(cmBackUpImage.getDeviceType() + ".....Processing " + idVal);
            FileStatusElement element = this.uploadFile(cmBackUpImage, cloud, cpBackupBatchId);
            isFileUploaded = element.isUploadStatus();
            if (isFileUploaded) {
                this.uploadService.deleteCPMgtImage(cloud.getCloudId(), cmBackUpImage.getId(), Device.TYPE.ONEDRIVE.name());
            } else {
                logger.debug(" moveCPMgtImage............. " + isFileUploaded);
                this.uploadService.moveCPMgtImage(cloud.getCloudId(), cmBackUpImage, Device.TYPE.ONEDRIVE.name());
            }
            logger.debug(" message status.............. " + isFileUploaded);
            if (cmBackUpImage != null && cmBackUpImage.getId() != null) {
                this.filesUnderProcess.remove(idVal);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside ODBCapacityMgmtJob Processor PooledConnectionFactory !" + e.getMessage());
        }
        return isFileUploaded;
    }

    public void updateBackupBatch(CPBackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, Long size) {
        logger.debug("calling backup Batch ..." + backupBatchOdb.getNoOfFiles());
        try {
            int cloudId = cloud.getCloudId();
            if (size == null) {
                size = 0L;
            }
            this.utilService.updateCPBackupBatch(cloudId, backupBatchOdb.getId().toString(), uploadedFiles, size);
            CPBackupBatch backupBatch = this.utilService.getCPBackupBatchById(cloudId, backupBatchOdb.getId().toString());
            if (!StringUtils.isEmpty((String)backupBatch.getUploadedFiles())) {
                String[] parts = backupBatch.getUploadedFiles().split("/");
                try {
                    Integer uploadedFilesLast = Integer.parseInt(parts[0]);
                    Integer totalUploaded = Integer.parseInt(parts[1]);
                    logger.debug("...uploadedfiles..." + uploadedFilesLast + "/" + totalUploaded);
                    if (uploadedFilesLast > totalUploaded) {
                        this.utilService.updateCPBackupBatch(cloudId, backupBatchOdb.getId().toString(), -1, Long.valueOf(-size.longValue()));
                        return;
                    }
                }
                catch (Exception e) {
                    logger.trace("Exception  :" + e);
                    logger.error("Exception  :" + e.getMessage());
                }
            }
            logger.debug("[backupBatch][" + backupBatchOdb.getUserName() + "][" + backupBatchOdb.getDeviceUUID() + "][" + backupBatchOdb.getId() + "][" + backupBatchOdb.getStatus() + "][" + backupBatchOdb.getBatchStartTimestamp() + "][" + backupBatchOdb.getBatchEndTimestamp() + "]");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling backup Batch ...");
    }
}

