/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class EWSTokenUpdateJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(EWSTokenUpdateJob.class);
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private UtilService utilService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isParacloud()) {
            logger.debug(PCHelperConstant.isParacloud() + "...not main machine..sleep for 60 mins.");
            try {
                Thread.sleep(TimeUnit.MINUTES.toMinutes(60L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        logger.debug("@@@@EWSTokenUpdateJob started1 ..... ");
        Object executor = null;
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            Cloud cloud = this.utilService.getCloud(1);
            boolean isMailEnabled = this.isExchangeBackupEnabled(cloud);
            if (!isMailEnabled) {
                Thread.sleep(TimeUnit.MINUTES.toMillis(60L));
                return;
            }
            logger.debug("@@@@EWSTokenUpdateJob started ..... ");
            this.utilService.updateEWSToken(cloud.getCloudId());
            logger.debug("@@@@EWSTokenUpdateJob ended ..... ");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExchangeBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExchangeBackupEnabled = true;
                break;
            }
        }
        return isExchangeBackupEnabled;
    }
}

