/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.service.MSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MailAutoCrawlJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(MailAutoCrawlJob.class);
    private static final String IS_JOB_RUNNING = "isJobRunning";
    private MSService msService;
    private TimerTask crawlTimerTask = null;
    private Timer crawlTimer = null;
    private static String EX_POLICY_TYPE = "Exchange";

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....MailAutoCrawlJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isMailEnabled = this.isExchangeBackupEnabled(cloud);
            String deviceType = Device.TYPE.OUTLOOK.name();
            this.msService.updateAllIncompleteBatchQueueStatus(cloud.getCloudId(), deviceType);
            if (isMailEnabled) {
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                int crawlThreads = 50;
                if (PCHelperConstant.getCrawlThreadsLimit() > 0) {
                    crawlThreads = PCHelperConstant.getCrawlThreadsLimit();
                }
                logger.debug(" threads val........" + crawlThreads);
                ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setNameFormat("MailCrawl-%d");
                executor = Executors.newFixedThreadPool(crawlThreads, factoryBuilder.build());
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartUpload(cloud, executor, pool);
                for (int i = 0; i < crawlThreads; ++i) {
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.delay();
                    this.callUploadFiles(cloud, executor, pool);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in MailAutoCrawlJob......." + e.getMessage());
            logger.trace("exception in MailAutoCrawlJob ......." + e);
        }
        logger.debug("....MailAutoCrawlJob job ended...");
    }

    private void delay() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside while loop..........", (Object)PCHelperConstant.isBrevityLogging());
        BackupBatch backupBatch = null;
        try {
            boolean isTomcatRunning = true;
            if (MemoryStore.get((String)IS_JOB_RUNNING) != null) {
                isTomcatRunning = (Boolean)MemoryStore.get((String)IS_JOB_RUNNING);
            }
            logger.debug("........Is tomcat job running........." + isTomcatRunning);
            if (!isTomcatRunning) {
                logger.error("..Tomcat job is going to be stopped.. so stopping upload ....");
                return;
            }
        }
        catch (Exception e) {
            logger.error("Exception While stopping :" + e.getMessage());
        }
        try {
            logger.debug("........Before getFileForProcessing.........");
            backupBatch = this.getFileForProcessing(cloud);
            if (backupBatch != null) {
                logger.debug("........Before getFileForProcessing1........." + backupBatch.getUserName());
            }
            if (backupBatch != null) {
                logger.debug(backupBatch.getId().toString() + "...assigning batch......" + backupBatch.getUserName());
                User user = this.msService.getUserInfo(cloud.getCloudId(), backupBatch.getUserName());
                this.crawlIndUserData(cloud, user, backupBatch.getBatchStartTimestamp());
                logger.error(backupBatch.getId().toString() + " %%%%%%% batch completed for user ...." + backupBatch.getUserName());
            } else {
                logger.debug("....no batch wit for 1 mins ....");
                Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
            }
            logger.debug("Thread ready for next batch .... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside MailAutoCrawlJob .... " + e.getMessage());
            logger.trace("exception inside MailAutoCrawlJob ...." + e);
        }
        logger.error("no batch to upload so wait and then retry>>>>");
        this.callUploadFiles(cloud, executor, pool);
    }

    private synchronized BackupBatch getFileForProcessing(Cloud cloud) {
        BackupBatch backupBatch = this.msService.getIncompleteBatch(cloud.getCloudId(), Device.TYPE.OUTLOOK.name());
        if (backupBatch == null) {
            logger.debug("...no batch to process...");
        } else {
            logger.debug("...starting  batch to process..." + backupBatch.getUserName());
        }
        return backupBatch;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.crawlTimer == null) {
            this.crawlTimer = new Timer();
        }
        if (this.crawlTimerTask == null) {
            this.crawlTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.debug("Check the task is completed>>>>>>>>", (Object)PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            MailAutoCrawlJob.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.crawlTimer.schedule(this.crawlTimerTask, 1000L, 1000L);
        }
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExchangeBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExchangeBackupEnabled = true;
                break;
            }
        }
        return isExchangeBackupEnabled;
    }

    private void crawlIndUserData(Cloud cloud, User user, long batchStartTime) {
        logger.debug(user.getExchangePolicyName() + "...mail process started user...." + user.getUserName());
        this.uploadMailsForUser(cloud, batchStartTime, user);
        logger.debug(user.getExchangePolicyName() + "...mail process ended user...." + user.getUserName());
    }

    private void uploadMailsForUser(Cloud cloud, long batchStartTime, User user) {
        boolean isPolicyModified = false;
        logger.debug("....inside for mail loopss.........." + user.getUserName());
        String userName = user.getUserName();
        Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), userName);
        if (device == null) {
            logger.debug("... no outlook device for user... " + userName);
            return;
        }
        if (device.isBlocked() || device.isDeleted()) {
            logger.debug("... device blocked for user... " + userName);
            return;
        }
        RestoreEvents restoreEvents = this.msService.getRestoreEventsByUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (restoreEvents != null && restoreEvents.isSuspendBackup()) {
            logger.error(".....restore is running so backup cannot continue...  ");
            return;
        }
        int cloudId = cloud.getCloudId();
        OfficeBackupPolicy officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), user.getUserName(), EX_POLICY_TYPE);
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), user.getUserName());
        if (device != null) {
            this.setInclusionAndExclusionFolders(userName, device, cloudId, officeBackupPolicy);
        }
        if (officeBackupPolicyFromLocal == null) {
            logger.debug(user.getUserName() + "..... policy local .... null..");
        }
        logger.debug(user.getUserName() + "...officeBackupPolicyFromLocal...");
        OfficeBackupPolicy officeBackupPolicyFromLoc = officeBackupPolicyFromLocal;
        try {
            if (officeBackupPolicyFromLocal == null || officeBackupPolicy.getLastModifiedTimestamp() != officeBackupPolicyFromLocal.getLastModifiedTimestamp()) {
                if (officeBackupPolicyFromLocal == null) {
                    officeBackupPolicyFromLoc = officeBackupPolicy;
                } else {
                    isPolicyModified = true;
                }
                this.msService.saveOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy);
            }
        }
        catch (Exception e) {
            logger.error("...error trying to save local policy");
        }
        try {
            logger.debug(user.getUserName() + "users list1......................................." + user);
            logger.debug(user.isExchangeBkpEnabled() + "users list1......................................." + user.isActive());
            if (user != null && user.isActive() && user.isExchangeBkpEnabled()) {
                logger.error(user.getUserName() + " %%%%%%% mail process started for user ...");
                this.processUser(user, cloud, officeBackupPolicy, officeBackupPolicyFromLoc, isPolicyModified, batchStartTime);
                logger.error(user.getUserName() + " %%%%%%% mail process ended for user ...");
            }
            logger.debug("Thread ready for next user11 .... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(user.getUserName() + "exception inside MailAutoCrawlJob .... " + e.getMessage());
            logger.trace("exception inside MailAutoCrawlJob ...." + e);
        }
    }

    private void setInclusionAndExclusionFolders(String userName, Device device, int cloudId, OfficeBackupPolicy officeBackupPolicy) {
        ArrayList<BackupFolders> inclusionbackupFolders = new ArrayList<BackupFolders>();
        List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, device.getDeviceUUID(), userName);
        if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                BackupFolders backupFolderElement = new BackupFolders();
                backupFolderElement.setId(userDefinedFolders.getId());
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                inclusionbackupFolders.add(backupFolderElement);
            }
        }
        ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
        List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, device.getDeviceUUID(), userName);
        if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                ExcludedFolders backupFolderElement = new ExcludedFolders();
                backupFolderElement.setId(userDefinedFolders.getId());
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                exclusionbackupFolders.add(backupFolderElement);
            }
        }
        if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getBackupFolders())) {
            officeBackupPolicy.setBackupFolders(new ArrayList());
        }
        if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getExcludedFolders())) {
            officeBackupPolicy.setExcludedFolders(new ArrayList());
        }
        officeBackupPolicy.getBackupFolders().addAll(inclusionbackupFolders);
        officeBackupPolicy.getExcludedFolders().addAll(exclusionbackupFolders);
    }

    public void processUser(User user, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oneDriveBackupPolicyFromLocal, boolean isPolicyModified, long batchStartTime) {
        try {
            String userName = user.getUserName();
            logger.debug("Processing " + userName);
            Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), userName);
            if (device == null) {
                logger.debug("... no onedrive device for user... " + userName);
                return;
            }
            if (device.isBlocked() || device.isDeleted()) {
                logger.debug("... device blocked for user... " + userName);
                return;
            }
            ArrayList list = oneDriveBackupPolicy.getPrivacyGateways();
            HashSet<String> gateWays = new HashSet<String>();
            for (PrivacyGateway gateway : list) {
                gateWays.add(gateway.getGatewayName());
            }
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                return;
            }
            boolean alreadyBkpStarted = this.msService.isBkpAllowed(cloud.getCloudId(), device, userName, oneDriveBackupPolicyFromLocal.getPolicyName());
            if (!alreadyBkpStarted) {
                boolean isFullBkp = this.isFullBkpStarted(cloud, device, userName);
                ObjectId eventHubId = this.updateEventHub(cloud, device);
                this.msService.processDeltaChangesForUserMail(user, cloud, oneDriveBackupPolicy, isPolicyModified, isFullBkp, eventHubId.toString(), batchStartTime, device);
                this.msService.updateEventHubOdStatus(cloud.getCloudId(), eventHubId);
            } else {
                logger.debug("... backup already forced....");
                this.msService.deleteQueuedEntry(cloud.getCloudId(), device.getUserName(), device.getDeviceUUID(), oneDriveBackupPolicyFromLocal.getPolicyName());
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("Exception inside MailAutoCrawlJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean isFullBkpStarted(Cloud cloud, Device device, String userName) {
        boolean fullBkpStarted = false;
        List<EventHub> list = this.msService.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (!CollectionUtils.isEmpty(list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                fullBkpStarted = true;
                break;
            }
        }
        return fullBkpStarted;
    }

    public static int[] toIntArray1(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    public ObjectId updateEventHub(Cloud cloud, Device device) {
        logger.debug("calling updateEventHub ....");
        ObjectId eventHubId = null;
        try {
            int cloudId = cloud.getCloudId();
            String deviceUUID = device.getDeviceUUID();
            String userName = device.getUserName();
            String actionByUserName = "Schedule";
            String acctionToUserName = userName;
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            String action = PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString();
            eventHub.setAction(action);
            eventHubId = this.msService.saveEventHubAction(cloudId, eventHub);
        }
        catch (Exception e) {
            logger.error("... exception trying to save eventhub ..." + e.getMessage());
        }
        return eventHubId;
    }
}

