/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.google.common.util.concurrent.RateLimiter;
import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.ExternalStorageBackupFileDao;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.BlocklistedFolders;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.CloudSettings;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.RestoreBackUpImage;
import com.parablu.pcbd.domain.UnreferencedChunkDetail;
import com.parablu.pcbd.domain.User;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class ExternalStorageBackupFileDaoImpl
implements ExternalStorageBackupFileDao {
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    public static final int CHUNK_TOTAL_DB_COUNT = PCHelperConstant.getChunkTotalBuckets();
    public static final String CLOUD = "CLOUD";
    Logger logger = LogManager.getLogger(ExternalStorageBackupFileDaoImpl.class);
    private static final String PRIVACY_GATEWAY_OD = "privacy_gateway_od_";
    private static final String CHUNKFILES = "chunkFiles";
    private static final String USER_NAME = "userName";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private static final String PRIVACY_GATEWAY_SYNC = "privacy_gateway_sync_";
    private RateLimiter limiter = null;

    private void logMessage(String logMessage) {
        this.logger.trace(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public void saveBackupFileInfo(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.createCollectionIfNotExists(tableName, mongoTemplate);
        mongoTemplate.insert((Object)backupFile, tableName);
    }

    private void createCollectionIfNotExists(String tableName, MongoTemplate mongoTemplate) {
        try {
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("Exception while collection exists:" + e.getMessage());
        }
    }

    @Override
    public BackupFile getBackupFile(int cloudId, String cloudName, String userName, String id) {
        this.logMessage("@@@@ Before getting backup file @@@@");
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(id)));
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
            this.logMessage("@@@@ After getting backup file from DB @@@@");
        }
        catch (Exception e) {
            this.logger.error("getBackupFile" + e);
        }
        return backupFile;
    }

    @Override
    public void saveSyncFileInfo(int cloudId, String cloudName, String userName, BackupFile backupFile) {
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.createCollectionIfNotExists(tableName, mongoTemplate);
        this.logger.debug("before saving to sync db>>>>>>>>>>>");
        mongoTemplate.save((Object)backupFile, tableName);
    }

    @Override
    public BackupFile getSyncFile(int cloudId, String cloudName, String userName, String id) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public BackupFile getSyncFile(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)"filePath").is((Object)filePath)});
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public void deleteSyncFile(int cloudId, String cloudName, String userName, String fileName, String filePath) {
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"fileName").is((Object)fileName), Criteria.where((String)"filePath").is((Object)filePath)});
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.findAndRemove(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
    }

    @Override
    public void deleteBackupFile(int cloudId, String cloudName, String userName, String id) {
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            mongoTemplate.remove(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("delete backup file" + e);
        }
    }

    @Override
    public void deleteTableForUser(int cloudId, String cloudName, String userName) {
        String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("Deleting the table for user....." + userName);
        if (mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.dropCollection(tableName);
        }
    }

    @Override
    public List<BackupFile> getBackupFilesForGivenPathAndFileName(int cloudId, String cloudName, String userName, String folderPath, String fileName) {
        List backupFiles = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            String folderPathVar = folderPath;
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            String macOs = "Macintosh";
            if (!folderPath.startsWith("Macintosh")) {
                String devicePathSeparator = "\\";
                folderPathVar = folderPath.replace("/", devicePathSeparator);
            }
            this.logger.debug("FolderPATH>>>>>>>>>>>" + folderPathVar);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"filePath").is((Object)folderPathVar), Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error("gatbackup filesfor given file and path:" + e.getMessage());
        }
        return backupFiles;
    }

    @Override
    public void markBackupFiletoDelete(int cloudId, String cloudName, String userName, String id) {
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            Update update = new Update();
            update.set("deleted", (Object)true);
            mongoTemplate.findAndModify(query, update, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("mark backup fileto delete:" + e);
        }
    }

    public List<BackupFile> getBackupFiles1(int cloudId, String cloudName, String userName, int skipValue) {
        List backupFiles = null;
        try {
            this.logger.debug("cloud id>>" + cloudId + "cloudName>>:" + cloudName + "skipValue>>" + skipValue);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            Query query = new Query();
            if (skipValue != 0 && skipValue != -1) {
                query.skip((long)(skipValue * 300));
                query.limit(300);
            } else {
                query.limit(300);
            }
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get backup files1:" + e);
        }
        return backupFiles;
    }

    @Override
    public List<BackupFile> getBackupFiles(int cloudId, String cloudName, String userName, int skipValue) {
        ArrayList<BackupFile> backupFiles = new ArrayList<BackupFile>();
        try {
            this.logger.debug("cloud id>" + cloudId + "cloudName>:" + cloudName + "skipValue>>" + skipValue);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CHUNKFILES, (Object)new Document("$exists", (Object)Boolean.TRUE)), Filters.eq((String)CHUNKFILES, (Object)new Document("$size", (Object)1))});
            FindIterable limit = skipValue != 0 && skipValue != -1 ? collection.find(searchQuery).skip(skipValue * 300).limit(300) : collection.find(searchQuery).limit(300);
            MongoCursor iterator = limit.iterator();
            while (iterator.hasNext()) {
                Document obj = (Document)iterator.next();
                BackupFile backupFile = (BackupFile)mongoTemplate.getConverter().read(BackupFile.class, (Object)obj);
                backupFiles.add(backupFile);
            }
            iterator.close();
        }
        catch (Exception e) {
            this.logger.error("get backup files" + e);
        }
        return backupFiles;
    }

    @Override
    public long getCountOfTheTable(int cloudId, String cloudName, String userName) {
        long count = 0L;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            count = mongoTemplate.getCollection(tableName).countDocuments();
        }
        catch (Exception e) {
            this.logger.error("getcount of the table:" + e);
        }
        return count;
    }

    @Override
    public BackupFile getBackupFileForDedupBackupId(int cloudId, String cloudName, String userName, String dedupBackupId) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"dedupBackupId").is((Object)dedupBackupId));
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get backup files for dedup backup id:" + e);
        }
        return backupFile;
    }

    @Override
    public BackupFile getLastBackupFile(int cloudId, String cloudName, String userName) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Query query = new Query();
            query.with(new Sort(Sort.Direction.DESC, new String[]{"id"}));
            query.limit(1);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get last backup file:" + e);
        }
        return backupFile;
    }

    @Override
    public BackUpImage getLastBackupImageFile(int cloudId, String userName) {
        BackUpImage backupFile = null;
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2)), Criteria.where((String)"storagePlace").exists(true)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
            query.limit(1);
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        }
        catch (Exception e) {
            this.logger.error("get last backup imagefile:" + e);
        }
        return backupFile;
    }

    @Override
    public int getchunkFileCountForGivenPath(int cloudId, String cloudName, String userName, String cloudStoragePath) {
        long fileCount = 0L;
        try {
            this.logger.debug("cloud id>>>>" + cloudId + "cloudName>>>>:" + cloudName);
            String tableName = PRIVACY_GATEWAY_OD + cloudName + "_" + userName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            tableName = tableName.toUpperCase();
            MongoCollection collection = mongoTemplate.getCollection(tableName);
            Bson searchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CHUNKFILES, (Object)new Document("$elemMatch", (Object)new Document("cloudStoragePath", (Object)cloudStoragePath)))});
            fileCount = collection.countDocuments(searchQuery);
        }
        catch (Exception e) {
            this.logger.error(" !!!!! ERROR TRYING TO get chunkfile count ...." + e);
        }
        return (int)fileCount;
    }

    @Override
    public BackUpImage saveChunksForBackup(int cloudId, ObjectId backupId, List<ChunkFile> chunkFiles, boolean isCompressed) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupId)});
        Query query = new Query((CriteriaDefinition)criteria);
        BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
        if (bkpImage != null) {
            bkpImage.setChunkFiles(new ArrayList<ChunkFile>());
            bkpImage.getChunkFiles().addAll(chunkFiles);
            bkpImage.setCompressed(isCompressed);
            if (bkpImage.getDevice() != null && StringUtils.isEmpty((String)bkpImage.getDeviceUUID())) {
                this.logger.debug("Inside saveChunksForBackup while uploading to cloud device is empty in backupImage");
                bkpImage.setDeviceUUID(bkpImage.getDevice().getDeviceUUID());
            }
            mongoTemplate.save((Object)bkpImage);
        }
        return bkpImage;
    }

    @Override
    public void saveChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        this.logger.debug("@@@@@Before saving chunk details@@@");
        this.setRateLimiter();
        this.logger.debug("%%% PVN ACQ for getting backup image in job secs:" + this.limiter.acquire());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        if (chunkDetail.getId() != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)chunkDetail.getMd5())});
            Query query = new Query((CriteriaDefinition)criteria);
            ChunkDetail chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL);
            if (chunkDetailObj != null) {
                collectionName = CHUNK_DETAIL;
            }
        }
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        mongoTemplate.save((Object)chunkDetail, collectionName);
        this.logger.debug("@@@@@After saving chunk details@@@...." + collectionName + "...." + chunkDetail.getCloudStoragePath());
    }

    private void createChunkIndex(MongoTemplate mongoTemplate, String collectionName) {
        MongoCollection chunkCollection = mongoTemplate.getCollection(collectionName);
        chunkCollection.createIndex(Indexes.ascending((String[])new String[]{"md5"}));
    }

    private String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    @Override
    public ChunkDetail getChunkDetailForMd51(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Criteria clientDedupCri = Criteria.where((String)"preEntry").is((Object)false);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{clientDedupCri, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        long timeMillisec = System.currentTimeMillis();
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = this.getChunkDetailByFilteringDedupStrtTime(cloudId, md5, mongoTemplate, query, timeMillisec, queryTablesList, isUpload);
        return chunkDetail;
    }

    @Override
    public List<ChunkDetail> getChunkDetailListForMd5(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Criteria clientDedupCri = Criteria.where((String)"preEntry").is((Object)false);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{clientDedupCri, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ArrayList<ChunkDetail> chunkDetailList = new ArrayList<ChunkDetail>();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        return chunkDetailList;
    }

    private ChunkDetail getChunkDetailByFilteringDedupStrtTime(int cloudId, String md5, MongoTemplate mongoTemplate, Query query, long timeMillisec, List<String> queryTablesList, boolean isUpload) {
        ChunkDetail chunkDetail = null;
        ArrayList chunkDetailList = new ArrayList();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (!CollectionUtils.isEmpty(chunkDetailList)) {
            CloudSettings cloudSettings = this.getCloudSettings(cloudId);
            chunkDetail = isUpload && cloudSettings != null && cloudSettings.getDedupStartTime() != 0L ? (ChunkDetail)chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).findFirst().orElse(null) : (ChunkDetail)chunkDetailList.get(0);
        }
        long afterTimeMillisec = System.currentTimeMillis();
        this.logger.debug(chunkDetail + "... findone query MD5 for searching in chunk table is>>" + md5 + "...." + (afterTimeMillisec - timeMillisec));
        return chunkDetail;
    }

    @Override
    public ChunkDetail getChunkForUpdateRefCount(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Criteria criteriaAsDeletedFalse = new Criteria();
        criteriaAsDeletedFalse.andOperator(new Criteria[]{criteria, Criteria.where((String)"deleteProcessStarted").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteriaAsDeletedFalse);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = this.getChunkDetailByFilteringDedupStrtTime(cloudId, md5, mongoTemplate, query, System.currentTimeMillis(), queryTablesList, isUpload);
        return chunkDetail;
    }

    @Override
    public List<ChunkDetail> getChunkDetailForMd5ForRestore(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            String string = DEDUP.DISABLED.toString();
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal) || DEDUP.DISABLED.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        ArrayList<ChunkDetail> chunkDetailList = new ArrayList<ChunkDetail>();
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        return chunkDetailList;
    }

    @Override
    public BackUpImage getBackupImageForId(int cloudId, String id, Device device) {
        this.setRateLimiter();
        this.logger.debug("%%% PVN ACQ for getting backup image in job secs:" + this.limiter.acquire());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(id)));
        BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
        return bkpImage;
    }

    @Override
    public BackUpImage getPresentBackupImageForFilePathNameMd5(int cloudId, Device device, BackUpImage image) {
        this.setRateLimiter();
        this.logger.debug("%%% PVN ACQ for getting backup image in job secs:" + this.limiter.acquire());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (image.isFolder()) {
            if (StringUtils.isEmpty((String)image.getDevicePath())) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"fileName").is((Object)image.getFileName()), Criteria.where((String)"md5Checksum").is((Object)image.getMd5Checksum()), Criteria.where((String)"status").is((Object)"ADDED")});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)image.getDevicePath()), Criteria.where((String)"fileName").is((Object)image.getFileName()), Criteria.where((String)"md5Checksum").is((Object)image.getMd5Checksum()), Criteria.where((String)"status").is((Object)"ADDED")});
            }
        } else if (StringUtils.isEmpty((String)image.getDevicePath())) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"fileName").is((Object)image.getFileName()), Criteria.where((String)"md5Checksum").is((Object)image.getMd5Checksum()), Criteria.where((String)"status").is((Object)"ADDED")});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)image.getDevicePath()), Criteria.where((String)"fileName").is((Object)image.getFileName()), Criteria.where((String)"md5Checksum").is((Object)image.getMd5Checksum()), Criteria.where((String)"status").is((Object)"ADDED")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        BackUpImage bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, device.getDestCollection());
        return bkpImage;
    }

    private void setRateLimiter() {
        if (this.limiter == null) {
            this.limiter = RateLimiter.create((double)PCHelperConstant.getNumOfHitsToDBForContentChunkCheck());
            this.logger.debug("....Rate limiter value:" + this.limiter.getRate());
        }
    }

    @Override
    public BackUpImage getSyncBackUpImageForId(int cloudId, String id, User user, MiniCloud miniCloud) {
        String dest;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)new ObjectId(id)));
        BackUpImage bkpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (bkpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return bkpImage;
    }

    @Override
    public void deleteUnReferencedChunks(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"refCount").is((Object)0)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, ChunkDetail.class);
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)fileRevision);
    }

    @Override
    public List<ChunkDetail> getUnReferencedChunks(int cloudId, String chunkBucketName, List<ObjectId> objectIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"refCount").lte((Object)0), Criteria.where((String)"clientDedupRefCount").lte((Object)0), Criteria.where((String)"id").nin(objectIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(500);
        if (StringUtils.isNotEmpty((String)chunkBucketName)) {
            return mongoTemplate.find(query, ChunkDetail.class, chunkBucketName);
        }
        return mongoTemplate.find(query, ChunkDetail.class);
    }

    @Override
    public void deleteUnReferencedChunks(int cloudId, List<ObjectId> objectIds, String chunkBucketName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(objectIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (StringUtils.isNotEmpty((String)chunkBucketName)) {
            mongoTemplate.remove(query, ChunkDetail.class, chunkBucketName);
        } else {
            mongoTemplate.remove(query, ChunkDetail.class);
        }
    }

    @Override
    public List<BackupFile> getAllSyncFiles(int cloudId, String cloudName, String userName) {
        List backupFiles = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(500);
            backupFiles = mongoTemplate.find(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFiles;
    }

    protected ChunkDetail getChunkDetailForUser(String userName, List<ChunkDetail> chunkDetails) {
        ArrayList<ChunkDetail> list = new ArrayList<ChunkDetail>();
        for (ChunkDetail chDetail : chunkDetails) {
            if (chDetail == null || StringUtils.isEmpty((String)chDetail.getUserName()) || userName == null || !chDetail.getUserName().equalsIgnoreCase(userName)) continue;
            list.add(chDetail);
        }
        ChunkDetail chunkDetail = null;
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, this.chunkDetailComparator());
            chunkDetail = (ChunkDetail)list.get(0);
        }
        return chunkDetail;
    }

    protected ChunkDetail getGlobalChunkDetail(List<ChunkDetail> chunkDetails) {
        ArrayList<ChunkDetail> list = new ArrayList<ChunkDetail>();
        for (ChunkDetail chDetail : chunkDetails) {
            if (chDetail == null) continue;
            list.add(chDetail);
        }
        ChunkDetail chunkDetail = null;
        if (!CollectionUtils.isEmpty(list)) {
            Collections.sort(list, this.chunkDetailComparator());
            chunkDetail = (ChunkDetail)list.get(0);
        }
        this.logMessage("#####After Getting chunk details for MD5###");
        return chunkDetail;
    }

    protected Comparator<ChunkDetail> chunkDetailComparator() {
        return new Comparator<ChunkDetail>(){

            @Override
            public int compare(ChunkDetail c1, ChunkDetail c2) {
                Long t1 = c2.getChunkCreatedTime();
                Long t2 = c1.getChunkCreatedTime();
                return t1.compareTo(t2);
            }
        };
    }

    @Override
    @Cacheable(value={"getCloudSettings"})
    public CloudSettings getCloudSettings(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        return (CloudSettings)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), CloudSettings.class);
    }

    @Override
    public BackUpImage saveChunksAndUpdateStorageForBackup(int cloudId, ObjectId backupId, List<ChunkFile> chunkFiles, boolean isCompressed, Device device, User user, MiniCloud miniCloud, boolean isSync) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)backupId));
        BackUpImage backUpImage = null;
        String destCollection = "";
        List<Object> queryTablesList = new ArrayList();
        queryTablesList = !isSync ? this.getCollectionsForBkpQuery(device) : this.getCollectionsForSyncQuery(user, miniCloud);
        for (String string : queryTablesList) {
            this.logger.debug("..inside dest...&&&&.... " + string);
            backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, string);
            this.logger.debug("....bkpimage..." + backUpImage);
            if (backUpImage == null) continue;
            destCollection = string;
            break;
        }
        this.logger.debug(backUpImage + "....savechunksandupdate storage..." + backupId + "..dest..." + destCollection);
        if (backUpImage != null) {
            backUpImage.setChunkFiles(new ArrayList<ChunkFile>());
            backUpImage.getChunkFiles().addAll(chunkFiles);
            backUpImage.setCompressed(isCompressed);
            if (StringUtils.isEmpty((String)backUpImage.getDeviceUUID())) {
                this.logger.debug("Inside saveChunksForBackup while uploading to cloud device is empty in backupImage");
                backUpImage.setDeviceUUID(device.getDeviceUUID());
            }
            backUpImage.setStoragePlace(CLOUD);
            backUpImage.setBusy(false);
            backUpImage.setLastCloudUploadedTime(System.currentTimeMillis());
            mongoTemplate.save((Object)backUpImage, destCollection);
        }
        return backUpImage;
    }

    private List<String> getCollectionsForBkpQuery(Device device) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)device.getDestCollection())) {
            queryTablesList.add(device.getDestCollection());
        }
        if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add("BACKUP");
        }
        return queryTablesList;
    }

    private List<String> getCollectionsForSyncQuery(User user, MiniCloud miniCloud) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            queryTablesList.add(user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            queryTablesList.add(miniCloud.getSyncDestinationCollection());
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add("BACKUP");
        }
        return queryTablesList;
    }

    private List<String> getChunkDetailCollections(String md5) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            queryTablesList.add(CHUNK_DETAIL);
        }
        String collectionName = this.getChunkNewCollectionName(md5);
        queryTablesList.add(collectionName);
        return queryTablesList;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5AndUserName(int cloudId, String md5, String userName) {
        String dest;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("MD5 for searching in chunk table is>>" + md5 + " and userName" + userName);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (chunkDetail = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, dest = iterator.next())) == null) {
        }
        if (chunkDetail == null) {
            this.logger.debug("Chunk Detail is nulll>>>>>>inside dao impl" + md5);
        }
        return chunkDetail;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5UserNameAndProductType(int cloudId, String md5, String userName, String productType) {
        String dest;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"productType").is((Object)productType)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (chunkDetail = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, dest = iterator.next())) == null) {
        }
        if (chunkDetail == null) {
            this.logger.debug("Chunk Detail is nulll>>>>>>inside dao impl" + md5);
        }
        return chunkDetail;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5(int cloudId, String md5) {
        String dest;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("MD5 for searching in chunk table is>>" + md5);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        Query query = new Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (chunkDetail = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, dest = iterator.next())) == null) {
        }
        if (chunkDetail == null) {
            this.logger.debug("Chunk Detail is nulll>>>>>>inside dao impl");
        }
        return chunkDetail;
    }

    @Override
    public void deleteSyncFiles(int cloudId, ObjectId objectId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
        tableName = tableName.toUpperCase();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, BackupFile.class, tableName);
    }

    @Override
    public List<BackUpImage> getBackupFolderForBasePath(int cloudId, String cloudName, String userName, Device device, String devicePath, boolean isrestoreDeletedFile) {
        Criteria criteria;
        ArrayList<BackUpImage> backupImageList = new ArrayList();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (isrestoreDeletedFile) {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)true)});
        } else {
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)"present").is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    @Override
    public List<BackUpImage> getBackupFilesForBasePath(int cloudId, String cloudName, String userName, Device device, String devicePath, boolean isrestoreDeletedFile) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        if (isrestoreDeletedFile) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)false), Criteria.where((String)"present").is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    @Override
    public BackUpImage getBackupFileById(int cloudId, Device device, String backupID, boolean isrestoreDeletedFile) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(backupID))});
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        BackUpImage backupImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, destCollection);
        return backupImage;
    }

    @Override
    public void saveDereferancedChunkDetail(int cloudId, UnreferencedChunkDetail dererancedChunk) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)dererancedChunk);
    }

    @Override
    public List<UnreferencedChunkDetail> getUnReferencedChunksFromNewColl(int cloudId, List<ObjectId> objectIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").nin(objectIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(500);
        return mongoTemplate.find(query, UnreferencedChunkDetail.class);
    }

    @Override
    public ChunkDetail getChunkDetailById(int cloudId, ObjectId id, String destColl) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, destColl);
    }

    @Override
    public void deleteUnrefrancedChunkById(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, UnreferencedChunkDetail.class);
    }

    @Override
    public void deleteUnReferencedChunksByIdInChunkDetail(int cloudId, ObjectId objectId, String chunkBucketName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (StringUtils.isNotEmpty((String)chunkBucketName)) {
            mongoTemplate.remove(query, ChunkDetail.class, chunkBucketName);
        } else {
            mongoTemplate.remove(query, ChunkDetail.class);
        }
    }

    @Override
    public void deleteChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        this.logMessage("@@@@@Before deleteChunkDelail@@@");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        if (chunkDetail.getId() != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(chunkDetail.getId().toString()))});
            Query query = new Query((CriteriaDefinition)criteria);
            ChunkDetail chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL);
            if (chunkDetailObj != null) {
                collectionName = CHUNK_DETAIL;
            }
            if (StringUtils.isEmpty((String)collectionName)) {
                collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
            }
            mongoTemplate.remove(query, collectionName);
        }
        this.logMessage("@@@@@After saving chunk details@@@");
    }

    @Override
    public void updateChunkAsDeleteStarted(int cloudId, ChunkDetail chunkDetail, boolean deleteProcessStarted) {
        this.logMessage("@@@@@Before updateChunkForDeleteStarted@@@");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        if (chunkDetail.getId() != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(chunkDetail.getId().toString()))});
            Query query = new Query((CriteriaDefinition)criteria);
            ChunkDetail chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL);
            if (chunkDetailObj != null) {
                collectionName = CHUNK_DETAIL;
            }
            if (StringUtils.isEmpty((String)collectionName)) {
                collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
            }
            Update update = new Update();
            update.set("deleteProcessStarted", (Object)true);
            mongoTemplate.updateFirst(query, update, collectionName);
        }
        this.logMessage("@@@@@After updateChunkForDeleteStarted@@@");
    }

    @Override
    public List<BlocklistedFolders> getAllBlacklistFolders(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(BlocklistedFolders.class);
    }

    @Override
    public void saveBlockListedFolders(int cloudId, BlocklistedFolders blocklistedFolders) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.insert((Object)blocklistedFolders);
    }

    @Override
    public List<ConsolidatedImage> getAllChildFilesOfFolder(int cloudId, String userName, String filePath, boolean isFolder) {
        List<ConsolidatedImage> consolidatedImages = new ArrayList<ConsolidatedImage>();
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            if (StringUtils.isEmpty((String)userName)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"devicePath").is((Object)filePath), Criteria.where((String)"folder").is((Object)isFolder)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"devicePath").is((Object)filePath), Criteria.where((String)"folder").is((Object)isFolder), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            consolidatedImages = mongoTemplate.find(query, ConsolidatedImage.class);
        }
        catch (Exception e) {
            this.logger.error("get All sync folder:" + e);
        }
        return consolidatedImages;
    }

    @Override
    public ConsolidatedImage getSyncFolderById(int cloudId, String syncRevisionId) {
        FileRevision fileRevision = new FileRevision();
        try {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)syncRevisionId));
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            fileRevision = (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return fileRevision.getConsolidatedImage();
    }

    @Override
    public BackupFile getBkpFileByFileName(int cloudId, String cloudName, String userName, String filePath, String fileName) {
        BackupFile backupFile = new BackupFile();
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            if (StringUtils.isEmpty((String)userName)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"filePath").is((Object)filePath), Criteria.where((String)"fileName").is((Object)fileName)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"filePath").is((Object)filePath), Criteria.where((String)"fileName").is((Object)fileName)});
            }
            Query query = new Query((CriteriaDefinition)criteria);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public List<ChunkDetail> getChunksToDelete(int cloudId, String gatewayName, String ipAddress, int limit, String coll, List<ObjectId> failedChunkIds) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        Criteria gatewayCriteria = new Criteria();
        if (StringUtils.isEmpty((String)gatewayName) || StringUtils.isEmpty((String)ipAddress)) {
            gatewayCriteria.orOperator(new Criteria[]{Criteria.where((String)"gatewayName").exists(false)});
            criteria.andOperator(new Criteria[]{gatewayCriteria, Criteria.where((String)"refCount").lte((Object)0), Criteria.where((String)"clientDedupRefCount").lte((Object)0), Criteria.where((String)"id").nin(failedChunkIds)});
        } else {
            gatewayCriteria.orOperator(new Criteria[]{Criteria.where((String)"gatewayName").is((Object)gatewayName), Criteria.where((String)"gatewayName").is((Object)ipAddress)});
            criteria.andOperator(new Criteria[]{gatewayCriteria, Criteria.where((String)"refCount").lte((Object)0), Criteria.where((String)"clientDedupRefCount").lte((Object)0), Criteria.where((String)"id").nin(failedChunkIds)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(limit);
        return mongoTemplate.find(query, ChunkDetail.class, coll);
    }

    @Override
    public boolean updateChunkWithGatewayName(int cloudId, ChunkDetail chunk, String gatewayName, String coll) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"gatewayName").exists(false), Criteria.where((String)"id").is((Object)chunk.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("gatewayName", (Object)gatewayName);
        UpdateResult upsert = mongoTemplate.upsert(query, update, ChunkDetail.class, coll);
        return upsert.isModifiedCountAvailable();
    }

    @Override
    public BackupFile getBackupFileBydeviceUUID(int cloudId, Device device) {
        this.logMessage("@@@@ Before getting backup file @@@@");
        BackupFile backupFile = null;
        try {
            String tableName = device.getDestCollection();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"storagePlace").is((Object)CLOUD)});
            Query query = new Query((CriteriaDefinition)criteria);
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
            this.logMessage("@@@@ After getting backup file from DB @@@@");
        }
        catch (Exception e) {
            this.logger.error("getBackupFile" + e);
        }
        return backupFile;
    }

    @Override
    public BackUpImage getLastUploadedBackupFileBydeviceUUID(int cloudId, Device device) {
        this.logMessage("@@@@ Before getLastUploadedBackupFileBydeviceUUID @@@@");
        BackUpImage backupFile = null;
        try {
            String tableName = device.getDestCollection();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"storagePlace").is((Object)CLOUD)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.with(new Sort(Sort.Direction.DESC, new String[]{"lastCloudUploadedTime"}));
            query.limit(1);
            backupFile = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, tableName);
            if (backupFile != null) {
                this.logger.debug("bkp file found..." + backupFile.getId());
                if (backupFile.getLastCloudUploadedTime() >= ExternalStorageBackupFileDaoImpl.getStartOfDay()) {
                    return backupFile;
                }
            }
            this.logMessage("@@@@ AftergetLastUploadedBackupFileBydeviceUUID from db @@@@");
        }
        catch (Exception e) {
            this.logger.error("getBackupFile" + e);
        }
        return null;
    }

    @Override
    public ChunkDetail getChunkDetailForMd5ForClientDedup(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive, String batachId) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        long timeMillisec = System.currentTimeMillis();
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        List<Object> chunkDetailList = new ArrayList();
        ChunkDetail chunkDetail = null;
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (CollectionUtils.isEmpty(chunkDetailList)) {
            this.logger.debug("chunkDetailList is null");
            return chunkDetail;
        }
        CloudSettings cloudSettings = this.getCloudSettings(cloudId);
        if (cloudSettings != null && cloudSettings.getDedupStartTime() != 0L) {
            chunkDetailList = chunkDetailList.stream().filter(chunkDetail1 -> chunkDetail1.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).collect(Collectors.toList());
        }
        this.logger.debug("chunkDetailList found :" + chunkDetailList.size());
        chunkDetail = chunkDetailList.stream().filter(chunk -> !chunk.isDeleteProcessStarted() && (chunk.getRefCount() > 0 || chunk.getClientDedupRefCount() > 0)).findFirst().orElse(null);
        long afterTimeMillisec = System.currentTimeMillis();
        this.logger.debug(chunkDetail + "... findone query MD5 for searching in chunk table is>>" + md5 + "...." + (afterTimeMillisec - timeMillisec));
        if (chunkDetail == null) {
            this.logger.debug("chunk detail is null....");
            return chunkDetail;
        }
        this.logger.debug(chunkDetail + " chunk inside getChunkDetailForMd5..... ");
        try {
            if (chunkDetail != null) {
                this.logger.debug(" before updating the chunk detail with chunk busy flag batch id:" + batachId);
                chunkDetail.setChunkBusy(true);
                chunkDetail.setNoOftimesChunkReferredForClientDedup(chunkDetail.getNoOftimesChunkReferredForClientDedup() + 1);
                chunkDetail.setLastRefrdTimeFrClDedup(System.currentTimeMillis());
                chunkDetail.setBackupBatchesRefdForClDedup(new ArrayList<String>());
                String collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
                this.createChunkIndex(mongoTemplate, collectionName);
                this.logger.debug(collectionName + " chunk inside getChunkDetailForMd5..... ");
                mongoTemplate.save((Object)chunkDetail, collectionName);
            }
        }
        catch (Exception e) {
            this.logger.error("error while set chunk busy if chunk d etaial is not null..... ", (Throwable)e);
        }
        return chunkDetail;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void saveChunkDetailForClientDedup(int cloudId, ChunkDetail chunkDetail) {
        this.logMessage("@@@@@Before saving chunk detail for client dedup@@@");
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        int clientDedupRefCount = chunkDetail.getClientDedupRefCount();
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        if (chunkDetail.isChunkBusy()) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)chunkDetail.getId())});
            Query query = new Query((CriteriaDefinition)criteria);
            ChunkDetail chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL);
            if (chunkDetailObj == null) {
                chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, collectionName);
            }
            if (chunkDetailObj == null) {
                this.logger.error(chunkDetail.getMd5() + ":Chunk detail got deleted even though it is marked as busy something terribly went wrong..." + chunkDetail.getId());
                return;
            }
            BeanUtils.copyProperties((Object)chunkDetailObj, (Object)chunkDetail);
            chunkDetail.setClientDedupRefCount(chunkDetail.getClientDedupRefCount() + clientDedupRefCount);
            chunkDetail.setNoOftimesChunkReferredForClientDedup(chunkDetail.getNoOftimesChunkReferredForClientDedup() - 1);
            if (chunkDetail.getNoOftimesChunkReferredForClientDedup() == 0) {
                this.logger.debug("chunkrefd for client dedup became zero so set busy status false");
                chunkDetail.setChunkBusy(false);
            }
            this.logger.debug(clientDedupRefCount + ":old chunk detail is still there and now the updated ref count is:" + chunkDetail.getClientDedupRefCount());
            this.logger.debug("New chunkbusy status:" + chunkDetail.isChunkBusy() + " new chunkrefd for client dedup count:" + chunkDetail.getNoOftimesChunkReferredForClientDedup());
        } else {
            this.logger.debug("chunk detail is a new one so save it");
        }
        mongoTemplate.save((Object)chunkDetail, collectionName);
        this.logMessage("@@@@@After saving chunk detail for client dedup@@@");
    }

    private static long getStartOfDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    @Override
    public List<ChunkDetail> getChunkDetailForMd5ToUpload(int cloudId, String md5, String dedupType, String userName, boolean isUpload, boolean checkWithUserCaseSensitive) {
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        this.setRateLimiter();
        this.logger.debug("%%% PVN ACQ for getting chunkDetail in job secs:" + this.limiter.acquire());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            if (checkWithUserCaseSensitive) {
                this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
            } else {
                this.logger.debug(".................Inside old chunk query ..........");
                criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).is((Object)userName)});
            }
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("#####Before Getting chunk details for MD5###" + md5);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        List<ChunkDetail> chunkDetailList = new ArrayList<ChunkDetail>();
        for (String dest : queryTablesList) {
            List chunkDetailByDB = mongoTemplate.find(query, ChunkDetail.class, dest);
            if (CollectionUtils.isEmpty((Collection)chunkDetailByDB)) continue;
            chunkDetailList.addAll(chunkDetailByDB);
        }
        if (!isUpload) {
            return chunkDetailList;
        }
        CloudSettings cloudSettings = this.getCloudSettings(cloudId);
        if (cloudSettings != null && !CollectionUtils.isEmpty(chunkDetailList) && cloudSettings.getDedupStartTime() != 0L) {
            chunkDetailList = chunkDetailList.stream().filter(chunkDetail -> chunkDetail.getChunkCreatedTime() > cloudSettings.getDedupStartTime()).collect(Collectors.toList());
        }
        return chunkDetailList;
    }

    @Override
    public List<RestoreBackUpImage> getBackupFolderForBasePathLatest(int cloudId, String cloudName, String userName, Device device, String devicePath, boolean present) {
        ArrayList<RestoreBackUpImage> backupImageList = new ArrayList();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)true), Criteria.where((String)"present").is((Object)present)});
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        backupImageList = mongoTemplate.find(query, RestoreBackUpImage.class, destCollection);
        return this.getFilteredBackupImageListByGrouping(backupImageList, true);
    }

    @Override
    public List<RestoreBackUpImage> getBackupFilesForBasePathLatest(int cloudId, String cloudName, String userName, Device device, String devicePath) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().exclude(CHUNKFILES);
        String destCollection = device.getDestCollection();
        this.logger.debug(".....val...." + device.getDeviceUUID() + "..." + devicePath + "....");
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList<RestoreBackUpImage> backupImageList = new ArrayList<RestoreBackUpImage>();
        List list = mongoTemplate.find(query, RestoreBackUpImage.class, destCollection);
        backupImageList.addAll(list);
        return backupImageList;
    }

    @Override
    public BackupFile getSyncFileForMd5(int cloudId, String cloudName, String fileName, String md5) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            this.createCollectionIfNotExists(tableName, mongoTemplate);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)"fileName").is((Object)fileName)});
            Query query = new Query((CriteriaDefinition)criteria);
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public List<BackUpImage> getBackupFilesForBasePath(int cloudId, String cloudName, String userName, Device device, String devicePath) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath), Criteria.where((String)"folder").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        this.logger.debug(".....val...." + device.getDeviceUUID() + "..." + devicePath + "....");
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    @Override
    public BackUpImage getBackupFileById(int cloudId, Device device, String backupID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)new ObjectId(backupID))});
        Query query = new Query((CriteriaDefinition)criteria);
        String destCollection = device.getDestCollection();
        BackUpImage backupImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, destCollection);
        return backupImage;
    }

    private List<RestoreBackUpImage> getFilteredBackupImageListByGrouping(List<RestoreBackUpImage> backUpImages, boolean restoreDeletedFiles) {
        this.logger.debug("Inside grouping backup images");
        this.logger.debug("Inside grouping backup images" + backUpImages.size());
        ArrayList filteredBackUpImages = new ArrayList();
        ArrayList<RestoreBackUpImage> filteredBackUpImagesList = new ArrayList<RestoreBackUpImage>();
        ArrayList deltedBackUpImages = new ArrayList();
        ArrayList<RestoreBackUpImage> deletedBackUpImagesList = new ArrayList<RestoreBackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(RestoreBackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<RestoreBackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(RestoreBackUpImage::getDevicePath, Collectors.groupingBy(RestoreBackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<RestoreBackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        for (RestoreBackUpImage filteredBackUpImage : filteredBackUpImages) {
            if (filteredBackUpImage.isPresent()) {
                filteredBackUpImagesList.add(filteredBackUpImage);
                continue;
            }
            deletedBackUpImagesList.add(filteredBackUpImage);
        }
        if (restoreDeletedFiles) {
            backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(RestoreBackUpImage::getFileName)).entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            Map<String, Map<String, List<RestoreBackUpImage>>> map1 = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(RestoreBackUpImage::getDevicePath, Collectors.groupingBy(RestoreBackUpImage::getFileName)));
            for (Map.Entry<String, Map<String, List<RestoreBackUpImage>>> entry : map1.entrySet()) {
                entry.getValue().entrySet().stream().forEach(p -> deltedBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(RestoreBackUpImage::getLastServerModifiedTime).reversed()).filter(p1 -> p1.isPresent()).findFirst().orElse(null)));
            }
            block3: for (RestoreBackUpImage bkpimage : deletedBackUpImagesList) {
                for (RestoreBackUpImage bkpimage1 : deltedBackUpImages) {
                    if (bkpimage1 == null || !bkpimage.getFileName().equals(bkpimage1.getFileName()) || !bkpimage.getDevicePath().equals(bkpimage1.getDevicePath())) continue;
                    bkpimage1.setPresent(false);
                    filteredBackUpImagesList.add(bkpimage1);
                    continue block3;
                }
            }
        }
        return filteredBackUpImagesList;
    }

    @Override
    public List<BackUpImage> getBackupFilesForBasePathSkipValue(int cloudId, String cloudName, String userName, Device device, String devicePath, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceUUID").is((Object)device.getDeviceUUID()), Criteria.where((String)"devicePath").is((Object)devicePath)});
        Query query = new Query((CriteriaDefinition)criteria);
        boolean isMail = false;
        if (!StringUtils.isEmpty((String)device.getDeviceType()) && device.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
            isMail = true;
        }
        query.fields().exclude(CHUNKFILES).exclude("bodyContent");
        if (skipValue != 0 && skipValue != -1) {
            query.skip((long)(skipValue * 50));
        }
        query.limit(50);
        String destCollection = device.getDestCollection();
        this.logger.debug(isMail + ".....valnew...." + device.getDeviceUUID() + "..." + devicePath + "....");
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List backupImageList = mongoTemplate.find(query, BackUpImage.class, destCollection);
        return backupImageList;
    }

    static enum DEDUP {
        DISABLED,
        USER,
        GLOBAL;

    }
}

