/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.service.MSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class ODBAutoScheduleJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private static Logger logger = LogManager.getLogger(ODBAutoScheduleJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    CompletionService<String> userPool = null;
    private static String OD_POLICY_TYPE = "ODB";

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....msDownload job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
            if (isOneDriveForBusinessBackupEnabled) {
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                boolean threadSizeVal = true;
                executor = Executors.newFixedThreadPool(1);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                ExecutorService userExecutor = Executors.newCachedThreadPool();
                this.userPool = new ExecutorCompletionService<String>(userExecutor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                logger.debug("... get officeBackupPolicyList list ... " + officeBackupPolicyList.size());
                this.checkThreadStatusAndStartScheduleForPolicy(cloud, executor, pool);
                for (int i = 0; i < 1; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloud, executor, pool, true);
                }
            } else {
                logger.debug("...odb not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isOneDriveForBusinessBackupEnabled);
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
        logger.debug("....msDownload job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void initiatePolicySchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            ODBAutoScheduleJob.this.initiatePolicySchedules(cloud, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        try {
            block16: {
                int cloudId = cloud.getCloudId();
                List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPoliciesForBluKrypt(cloudId, OD_POLICY_TYPE);
                ArrayList<User> usersList = new ArrayList<User>();
                HashedMap userPolicyMap = new HashedMap();
                ArrayList<OfficeBackupPolicy> eligiblePolicy = new ArrayList<OfficeBackupPolicy>();
                for (OfficeBackupPolicy officeBackupPolicy : policyList) {
                    long nextSchedule;
                    if (!officeBackupPolicy.isActive() || (nextSchedule = this.msService.getNextScheduledMinute(officeBackupPolicy)) > 1L) continue;
                    eligiblePolicy.add(officeBackupPolicy);
                }
                for (OfficeBackupPolicy officeBackupPolicy : eligiblePolicy) {
                    List<User> allUsersForOfficeBackupPolicy = this.msService.getAllUsersForOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy.getPolicyName(), OD_POLICY_TYPE);
                    usersList.addAll(allUsersForOfficeBackupPolicy);
                    for (User user : allUsersForOfficeBackupPolicy) {
                        userPolicyMap.put(user.getUserName(), officeBackupPolicy);
                    }
                }
                usersList.removeAll(Collections.singleton(null));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.debug(".... before odb backup..................." + usersList.size());
                try {
                    long batchStartTime = System.currentTimeMillis();
                    ArrayList<User> finalList = new ArrayList<User>();
                    for (User user : usersList) {
                        if (!user.isOnedriveBkpEnabled()) continue;
                        String userName = user.getUserName();
                        Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
                        boolean userEligible = true;
                        if (device == null || device.isBlocked() || device.isDeleted()) {
                            userEligible = false;
                        } else {
                            BackupBatch lastBkpBatch = this.msService.getLastBackupOnly(cloud.getCloudId(), userName, device.getDeviceUUID());
                            if (lastBkpBatch != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString()))) {
                                this.msService.checkBatchExistsOrNot(lastBkpBatch, ((OfficeBackupPolicy)userPolicyMap.get(user.getUserName())).getPolicyName());
                                logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
                                userEligible = false;
                            }
                        }
                        if (!userEligible) continue;
                        finalList.add(user);
                    }
                    logger.debug("....policy and users....." + finalList.size());
                    if (CollectionUtils.isEmpty(finalList)) break block16;
                    ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("ODBQueueThread-$$%d$$");
                    CountDownLatch latch = new CountDownLatch(finalList.size());
                    ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                    for (User user : finalList) {
                        Runnable uploadJob = () -> this.lambda$schdeuleUsersForPolicy$1(cloud, (Map)userPolicyMap, user, batchStartTime, cloudId, latch);
                        executorService.submit(uploadJob);
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executorService.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("..error trying to parse user sp..." + e.getMessage());
                }
            }
            logger.debug(".... completed usersList....................");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside SPAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside SPAutoScheduleJob ...." + e);
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private void createQueueForUser(Cloud cloud, OfficeBackupPolicy officeBackupPolicy, long batchStartTime, int cloudId, User user, CountDownLatch latch) {
        String userName = user.getUserName();
        Device device = this.msService.getODDeviceForUserName(cloudId, userName);
        if (device == null || device.isBlocked() || device.isDeleted()) {
            logger.debug("... no o device or device blocked for user.. " + userName);
            latch.countDown();
        } else {
            boolean isFullBkp = this.msService.isFullBkpStarted(cloud, device, userName);
            this.msService.createQueuedBatch(cloud, officeBackupPolicy, batchStartTime, user, isFullBkp, device);
            latch.countDown();
        }
    }

    private /* synthetic */ void lambda$schdeuleUsersForPolicy$1(Cloud cloud, Map userPolicyMap, User user, long batchStartTime, int cloudId, CountDownLatch latch) {
        this.createQueueForUser(cloud, (OfficeBackupPolicy)userPolicyMap.get(user.getUserName()), batchStartTime, cloudId, user, latch);
    }
}

