/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.MSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class MailAutoScheduleJob
extends QuartzJobBean
implements Job {
    private MSService msService;
    private static Logger logger = LogManager.getLogger(MailAutoScheduleJob.class);
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static String EX_POLICY_TYPE = "Exchange";

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....MailAutoScheduleJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isMailEnabled = this.isExchangeBackupEnabled(cloud);
            if (isMailEnabled) {
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                long threadSize = this.msService.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
                if (threadSize == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                boolean threadSizeVal = true;
                executor = Executors.newFixedThreadPool(1);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                this.checkThreadStatusAndStartScheduleForPolicy(cloud, executor, pool);
                for (int i = 0; i < 1; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloud, executor, pool, true);
                }
            } else {
                logger.debug("...mail not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isMailEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in MailAutoScheduleJob......." + e.getMessage());
            logger.trace("exception in MailAutoScheduleJob ......." + e);
        }
        logger.debug("....MailAutoScheduleJob job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isExchangeBackupEnabled(Cloud cl) {
        boolean isExchangeBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Exchange Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExchangeBackupEnabled = true;
                break;
            }
        }
        return isExchangeBackupEnabled;
    }

    private void initiatePolicySchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            MailAutoScheduleJob.this.initiatePolicySchedules(cloud, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        try {
            block18: {
                int cloudId = cloud.getCloudId();
                List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPoliciesForBluKrypt(cloudId, EX_POLICY_TYPE);
                ArrayList<User> usersList = new ArrayList<User>();
                HashedMap userPolicyMap = new HashedMap();
                ArrayList<OfficeBackupPolicy> eligiblePolicy = new ArrayList<OfficeBackupPolicy>();
                for (OfficeBackupPolicy officeBackupPolicy : policyList) {
                    if (!officeBackupPolicy.isActive()) continue;
                    long nextSchedule = this.msService.getNextScheduledMinute(officeBackupPolicy);
                    logger.debug(officeBackupPolicy.getPolicyName() + "....policy and next schedule..." + nextSchedule);
                    if (nextSchedule > 1L) continue;
                    eligiblePolicy.add(officeBackupPolicy);
                    logger.debug("...eligible policy added...." + eligiblePolicy.size());
                }
                logger.debug("...eligible policy...." + eligiblePolicy.size());
                for (OfficeBackupPolicy officeBackupPolicy : eligiblePolicy) {
                    List<User> allUsersForOfficeBackupPolicy = this.msService.getAllUsersForOfficeBackupPolicy(cloud.getCloudId(), officeBackupPolicy.getPolicyName(), EX_POLICY_TYPE);
                    usersList.addAll(allUsersForOfficeBackupPolicy);
                    for (User user : allUsersForOfficeBackupPolicy) {
                        userPolicyMap.put(user.getUserName(), officeBackupPolicy);
                    }
                }
                usersList.removeAll(Collections.singleton(null));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.debug(".... before mail backup..................." + usersList.size());
                try {
                    long batchStartTime = System.currentTimeMillis();
                    ArrayList<User> finalList = new ArrayList<User>();
                    for (User user : usersList) {
                        if (!user.isExchangeBkpEnabled()) continue;
                        String userName = user.getUserName();
                        Device device = this.msService.getMailDeviceForUserName(cloud.getCloudId(), userName);
                        boolean userEligible = true;
                        if (device == null || device.isBlocked() || device.isDeleted()) {
                            userEligible = false;
                            logger.debug("...user not eligible..." + user.getUserName());
                        } else {
                            BackupBatch lastBkpBatch = this.msService.getLastBackupOnly(cloud.getCloudId(), userName, device.getDeviceUUID());
                            if (lastBkpBatch != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString()))) {
                                this.msService.checkBatchExistsOrNot(lastBkpBatch, ((OfficeBackupPolicy)userPolicyMap.get(user.getUserName())).getPolicyName());
                                logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
                                userEligible = false;
                            }
                            if (lastBkpBatch != null && BackupBatch.STATUS.INTERRUPTED.toString().equalsIgnoreCase(lastBkpBatch.getStatus()) && StringUtils.isNotEmpty((String)lastBkpBatch.getErrorCode()) && "1996".equalsIgnoreCase(lastBkpBatch.getErrorCode())) {
                                userEligible = false;
                            }
                            logger.debug(userName + "...user status eligible..." + userEligible);
                            if (lastBkpBatch != null) {
                                logger.debug(userName + "...user status eligible..." + lastBkpBatch.getStatus());
                            }
                        }
                        if (!userEligible) continue;
                        logger.debug("...user details..." + user.getUserName());
                        finalList.add(user);
                    }
                    logger.debug("....policy and users....." + finalList.size());
                    if (CollectionUtils.isEmpty(finalList)) break block18;
                    ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("MaQueueThread-$$%d$$");
                    CountDownLatch latch = new CountDownLatch(finalList.size());
                    ExecutorService executorService = Executors.newFixedThreadPool(10, threadFactoryBuilder.build());
                    for (User user : finalList) {
                        Runnable uploadJob = () -> this.lambda$schdeuleUsersForPolicy$1(cloud, (Map)userPolicyMap, user, batchStartTime, cloudId, latch);
                        executorService.submit(uploadJob);
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    executorService.shutdown();
                }
                catch (Exception e) {
                    logger.error("..error trying to parse user sp..." + e.getMessage());
                }
            }
            logger.debug(".... completed usersList....................");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("exception inside SPAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside SPAutoScheduleJob ...." + e);
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private void createQueueForUser(Cloud cloud, OfficeBackupPolicy officeBackupPolicy, long batchStartTime, int cloudId, User user, CountDownLatch latch) {
        String userName = user.getUserName();
        logger.debug("...user val...." + userName);
        Device device = this.msService.getOutlookDeviceForUserName(cloudId, userName);
        if (device == null || device.isBlocked() || device.isDeleted()) {
            logger.debug("... no mail device or device blocked for user.. " + userName);
            latch.countDown();
        } else {
            boolean isFullBkp = this.msService.isFullBkpStarted(cloud, device, userName);
            this.msService.createQueuedBatch(cloud, officeBackupPolicy, batchStartTime, user, isFullBkp, device);
            latch.countDown();
        }
    }

    private /* synthetic */ void lambda$schdeuleUsersForPolicy$1(Cloud cloud, Map userPolicyMap, User user, long batchStartTime, int cloudId, CountDownLatch latch) {
        this.createQueueForUser(cloud, (OfficeBackupPolicy)userPolicyMap.get(user.getUserName()), batchStartTime, cloudId, user, latch);
    }
}

