/*
 * Decompiled with CFR 0.152.
 */
package com.pg.service.impl;

import com.google.gson.JsonElement;
import com.microsoft.aad.adal4j.AuthenticationCallback;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Contact;
import com.microsoft.graph.models.Deleted;
import com.microsoft.graph.models.Drive;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemDeltaParameterSet;
import com.microsoft.graph.models.DriveItemVersion;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.models.TodoTaskList;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.ContactDeltaCollectionPage;
import com.microsoft.graph.requests.ContactDeltaCollectionRequest;
import com.microsoft.graph.requests.ContactDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemCollectionPage;
import com.microsoft.graph.requests.DriveItemCollectionRequest;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemDeltaCollectionPage;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequest;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemRequestBuilder;
import com.microsoft.graph.requests.DriveItemVersionCollectionPage;
import com.microsoft.graph.requests.DriveItemVersionCollectionRequest;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.EventDeltaCollectionPage;
import com.microsoft.graph.requests.EventDeltaCollectionRequest;
import com.microsoft.graph.requests.EventDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.ListCollectionPage;
import com.microsoft.graph.requests.ListCollectionRequest;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.ListItemVersionCollectionPage;
import com.microsoft.graph.requests.ListItemVersionCollectionRequest;
import com.microsoft.graph.requests.MailFolderCollectionPage;
import com.microsoft.graph.requests.MailFolderCollectionRequest;
import com.microsoft.graph.requests.MailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.MailFolderDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.MailFolderRequestBuilder;
import com.microsoft.graph.requests.MessageDeltaCollectionPage;
import com.microsoft.graph.requests.MessageDeltaCollectionRequest;
import com.microsoft.graph.requests.MessageDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.TodoTaskDeltaCollectionPage;
import com.microsoft.graph.requests.TodoTaskDeltaCollectionRequest;
import com.microsoft.graph.requests.TodoTaskDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.TodoTaskListCollectionPage;
import com.microsoft.graph.requests.TodoTaskListCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.graph.requests.UserRequestBuilder;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FolderFileInfo;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SiteDeltaPath;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.parablu.pcbd.domain.UserPolicy;
import com.parablu.pcbd.domain.UsersWOBackup;
import com.pg.dao.UtilDao;
import com.pg.domain.BackupAttempt;
import com.pg.domain.DriveFileInfo;
import com.pg.graph.helper.Graph;
import com.pg.graph.helper.ScheduleTO;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.odb.util.RetryPolicyFactory;
import com.pg.service.MSService;
import com.pg.service.RetryService;
import com.pg.service.impl.BaseUploadService;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ConnectingIdType;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.ImpersonatedUserId;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.sync.ChangeCollection;
import microsoft.exchange.webservices.data.sync.ItemChange;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MSServiceImpl
extends BaseUploadService
implements MSService {
    private static Logger logger = LogManager.getLogger(MSServiceImpl.class);
    private static final String BASE_FOLDER = "Files";
    public static final String INTERRUPTED_STATUS = "INTERRUPTED";
    public static final int STATUS_LICENSE_ACTIVE = 1500;
    public static final int STATUS_LICENSE_EXPIRED = 1501;
    private static final String IN_PLACE_ARCHIVE = "In-Place Archive/";
    private static final String RESOURCE = "https://outlook.office365.com";
    private static final String SERVICE_ROOT = "https://graph.microsoft.com";
    private static final int[] EXPONENTIAL = new int[]{1, 3, 5, 8, 10};
    private static final String AUTHORITY = "https://login.microsoftonline.com/";
    private static final String EWS_URL = "https://outlook.office365.com/EWS/Exchange.asmx";
    private UserDao userDao;
    private DeviceDao deviceDao;
    private CloudDao cloudDao;
    private MSUtilDao msUtilDao;
    @Autowired
    private UtilDao utilDao;
    private BackUpImageDao backUpImageDao;
    @Autowired
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private RetryService<?> retryService;
    @Autowired
    private RetryPolicyFactory retryPolicyFactory;

    public BackupOverViewDao getBackupOverViewDao() {
        return this.backupOverViewDao;
    }

    public void setBackupOverViewDao(BackupOverViewDao backupOverViewDao) {
        this.backupOverViewDao = backupOverViewDao;
    }

    public UtilDao getUtilDao() {
        return this.utilDao;
    }

    public void setUtilDao(UtilDao utilDao) {
        this.utilDao = utilDao;
    }

    public RetryService<?> getRetryService() {
        return this.retryService;
    }

    public void setRetryService(RetryService<?> retryService) {
        this.retryService = retryService;
    }

    public void setCloudDao(CloudDao cloudDao) {
        this.cloudDao = cloudDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public void setMsUtilDao(MSUtilDao msUtilDao) {
        this.msUtilDao = msUtilDao;
    }

    public BackUpImageDao getBackUpImageDao() {
        return this.backUpImageDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    @Override
    public Cloud getCloud(int cloudId) {
        Cloud cloud = this.cloudDao.getAllClouds().stream().findFirst().orElse(null);
        return cloud;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId, String policyType) {
        return this.msUtilDao.getAllOfficeBackupPolicies(cloudId, policyType);
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllUsersForOfficeBackupPolicy(int cloudId, String policyName, String productType) {
        return this.userDao.getAllUsersForOfficeBackupPolicy(cloudId, policyName, productType);
    }

    private boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    @Override
    public void processDeltaChangesForUserDrive(com.parablu.pcbd.domain.User userObj, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oldBackupPolicy, boolean isPolicyModified, String eventHubId, long batchStartTime) {
        String userName = userObj.getUserName();
        int cloudId = cloud.getCloudId();
        Device device = this.deviceDao.getODDeviceForUserName(cloudId, userName);
        if (device == null) {
            logger.debug("... no onedrive device for user... " + userName);
            return;
        }
        if (device.isBlocked() || device.isDeleted()) {
            logger.debug("... device blocked for user... " + userName);
            return;
        }
        boolean isFullBackup = this.isFullBkpStarted(cloud, device, userName);
        if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && userObj != null && !userObj.isBackupTargetAssigned()) {
            logger.debug(".....backupTargetAssigned is false so return..." + userName);
            this.createBatchForTargetUnAssignedUser(cloudId, device.getDeviceUUID(), userName, oneDriveBackupPolicy, batchStartTime);
            this.deleteEventHub(cloudId, new ObjectId(eventHubId));
            this.deleteEventHubForUser(cloudId, userName, "STARTED");
            return;
        }
        String deviceUUID = device.getDeviceUUID();
        String productType = device.getDeviceType();
        String batchId = "";
        boolean emptyToken = false;
        try {
            String prevDeviceToken;
            ArrayList<DriveItem> listItems;
            String deltaToken;
            block29: {
                logger.debug(isFullBackup + ".....policy is modified........." + isPolicyModified);
                deltaToken = device.getDeltaToken();
                if (StringUtils.isEmpty((String)device.getDeltaToken())) {
                    isFullBackup = true;
                    emptyToken = true;
                }
                if (isFullBackup) {
                    deltaToken = "";
                    isPolicyModified = false;
                }
                listItems = new ArrayList<DriveItem>();
                prevDeviceToken = deltaToken;
                String emailId = userObj.getEmailId();
                Drive drive = null;
                try {
                    ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
                    requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
                    UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(requestOptions)).top(1).get());
                    String userId = "";
                    for (User userObj1 : iUserCollectionPage.getCurrentPage()) {
                        logger.debug(userObj1.userPrincipalName + "... vals..." + userObj1.givenName);
                        userId = userObj1.id;
                    }
                    logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
                    drive = this.getDrive(this.getGraphClient(), userId);
                }
                catch (GraphServiceException e) {
                    e.printStackTrace();
                    logger.error("..error..." + e.getMessage());
                    logger.debug("..od not availabe latest ...." + e.getResponseCode());
                    if (e.getResponseCode() == 404) {
                        this.createBatchForFailedOneDrive(cloudId, deviceUUID, userName, oneDriveBackupPolicy);
                        return;
                    }
                }
                catch (Exception e) {
                    if (!e.getMessage().contains("Request_ResourceNotFound")) break block29;
                    this.createBatchForFailedOneDrive(cloudId, deviceUUID, userName, oneDriveBackupPolicy);
                    return;
                }
            }
            if (isPolicyModified) {
                listItems = new ArrayList();
                logger.debug(".... policymodified new log .... " + deviceUUID);
                deltaToken = this.findFiles(deviceUUID, "", listItems, userName, userObj.getEmailId(), cloud);
                List<DriveItem> currentPolicyItems = this.getAllFilesForPolicy(listItems, deviceUUID, userName, cloudId, oneDriveBackupPolicy, device.getDestCollection(), false);
                List<DriveItem> prevPolicyItems = this.getAllFilesForPolicy(listItems, deviceUUID, userName, cloudId, oldBackupPolicy, device.getDestCollection(), false);
                ArrayList<DriveItem> newItems = new ArrayList<DriveItem>(currentPolicyItems);
                ArrayList<DriveItem> itemsToBeDeleted = new ArrayList<DriveItem>(prevPolicyItems);
                List<DriveItem> finalNewITems = MSServiceImpl.getDiffItems(newItems, prevPolicyItems);
                List<DriveItem> finalDeleteITems = MSServiceImpl.getDiffItems(itemsToBeDeleted, currentPolicyItems);
                if (finalNewITems.size() == 0) {
                    ArrayList<DriveItem> listItems1 = new ArrayList<DriveItem>();
                    this.findFiles(deviceUUID, prevDeviceToken, listItems1, userName, userObj.getEmailId(), cloud);
                    List<DriveItem> finalprevDiffNewITems2 = MSServiceImpl.getDiffItems(prevPolicyItems, listItems1);
                    List<DriveItem> finalNewITemsprev = MSServiceImpl.getDiffItems(newItems, finalprevDiffNewITems2);
                    finalNewITems.addAll(finalNewITemsprev);
                }
                if (CollectionUtils.isEmpty(finalDeleteITems) && CollectionUtils.isEmpty(finalNewITems)) {
                    logger.debug(prevDeviceToken + "....checkingzero files case ... " + deltaToken);
                    deltaToken = this.findFiles(deviceUUID, prevDeviceToken, finalNewITems, userName, userObj.getEmailId(), cloud);
                }
                batchId = this.handleModifiedPolicyItems(finalNewITems, finalDeleteITems, deviceUUID, userName, cloud, oneDriveBackupPolicy, device.getDestCollection(), eventHubId, batchStartTime, isFullBackup, emptyToken);
            } else {
                logger.debug("... backup token.... " + deltaToken);
                ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
                batchId = "";
                if (backupBatch != null) {
                    batchId = backupBatch.getId().toString();
                }
                BackupBatch batch = null;
                if (!StringUtils.isEmpty((String)batchId)) {
                    batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                }
                logger.debug(batchId + "....user...." + userName);
                if (batch == null) {
                    logger.debug("....user1...." + userName);
                    batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, deviceUUID);
                    batchId = batch.getId().toString();
                    logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
                    logger.debug(batchId + "....user2 delete batch...." + userName + "...." + batch.getStatus());
                    ODBBackupBatch odbBackupBatch = new ODBBackupBatch();
                    BeanUtils.copyProperties((Object)batch, (Object)odbBackupBatch);
                    odbBackupBatch.setId(new ObjectId(batchId));
                    backupBatch = this.msUtilDao.deleteAndCreateBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), odbBackupBatch);
                }
                backupBatch.setStatus("STARTED");
                BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batchId);
                if (backupAttempt != null && backupAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.name())) {
                    backupAttempt.setBatchId(batchId);
                    backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
                    logger.debug("......firstattempt.....");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                    this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
                    device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
                    if (!PCHelperConstant.BACKUP_STATUS.SCANNING.toString().equalsIgnoreCase(backupAttempt.getStatus())) {
                        this.addScanningAttempt(cloudId, batchId, backupBatch);
                    }
                    logger.debug("......secondtattempt.....");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                    backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
                    batch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
                    this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                }
                if (backupAttempt == null) {
                    backupAttempt = new BackupAttempt();
                    BeanUtils.copyProperties((Object)backupBatch, (Object)backupAttempt);
                    backupAttempt.setBatchId(backupBatch.getId().toString());
                    backupAttempt.setId(null);
                    backupAttempt.setErrorCode("0");
                    backupAttempt.setBatchStartTimestamp(batch.getBatchStartTimestamp());
                    backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    backupAttempt.setStatus(batch.getStatus());
                    this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
                    this.addScanningAttempt(cloudId, batchId, backupBatch);
                }
                batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                if (emptyToken) {
                    this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
                    batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                }
                if (batch == null) {
                    batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
                    batchId = batch.getId().toString();
                }
                if (this.isBkpStopped(cloudId, batchId)) {
                    return;
                }
                String retryToken = deltaToken;
                boolean firstCrawl = true;
                deltaToken = this.findOdFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, userObj.getEmailId(), cloud, firstCrawl, productType);
                firstCrawl = false;
                if ("DIFF-BLUKRYPT".equalsIgnoreCase(deltaToken)) {
                    logger.debug("....diff blukrypt....");
                    this.msUtilDao.deleteBatchFromOdServer(new ObjectId(batchId), oneDriveBackupPolicy.getPolicyName());
                    this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                } else {
                    long totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                    if (totalNoOfFiles == 0L) {
                        logger.debug("...retrt one more time wait for 5 sec because it is 0 files...");
                        Thread.sleep(5000L);
                        logger.debug("...retrt one more time after 5 sec because it is 0 files...");
                        deltaToken = retryToken;
                        deltaToken = this.findOdFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, userObj.getEmailId(), cloud, firstCrawl, productType);
                        totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                    }
                    long totalSizeToUpload = 0L;
                    logger.debug("...total files and size...." + totalNoOfFiles + "...size..." + totalSizeToUpload);
                    backupBatch.setId(new ObjectId(batchId));
                    backupBatch.setStatus("COMPLETED");
                    backupBatch.setTotalSizeToUpload(totalSizeToUpload);
                    long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
                    long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
                    logger.debug("...total filecount...." + totalFilesCount + "...failedcount..." + totalFailedCount);
                    backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
                    batch.setNoOfFiles(0L);
                    batch.setTotalNoOfFiles("" + totalFilesCount);
                    backupBatch.setTotalNoOfFiles("" + totalFilesCount);
                    logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
                    this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
                    this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                    this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
                    logger.debug(listItems.size() + "...@@@@@@@@@@@@@@@@new delta token from deltapage...." + deltaToken);
                    this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), deltaToken, prevDeviceToken);
                    this.addWaitForBackupAttempt(cloudId, batchId, backupBatch);
                    batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
                    this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                    this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
                    this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                }
            }
        }
        catch (Error e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...error trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(batchId + " ...exception trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
    }

    private void addScanningAttempt(int cloudId, String batchId, ODBBackupBatch backupBatch) {
        BackupAttempt attempt = new BackupAttempt();
        BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
        attempt.setId(null);
        attempt.setErrorCode("0");
        attempt.setBatchId(batchId);
        attempt.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
        attempt.setBatchStartTimestamp(System.currentTimeMillis());
        this.utilDao.saveBackupAttempt(cloudId, attempt);
    }

    private void addWaitForBackupAttempt(int cloudId, String batchId, ODBBackupBatch backupBatch) {
        BackupAttempt attempt = new BackupAttempt();
        BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
        attempt.setId(null);
        attempt.setErrorCode("0");
        attempt.setBatchId(batchId);
        attempt.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
        attempt.setBatchStartTimestamp(System.currentTimeMillis());
        this.utilDao.saveBackupAttempt(cloudId, attempt);
    }

    private void createBatchForTargetUnAssignedUser(int cloudId, String deviceUUID, String userName, OfficeBackupPolicy oneDriveBackupPolicy, long batchStartTime) {
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String batchId = backupBatch.getId().toString();
        BackupBatch batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        logger.debug(batchId + "....user...." + userName);
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
        }
        if (batch != null && PCHelperConstant.BACKUP_STATUS.QUEUED.toString().equalsIgnoreCase(batch.getStatus())) {
            logger.debug("..... in queued ...." + batch.getStatus());
            BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            backupAttempt.setErrorCode("543");
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            batch.setErrorCode("543");
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        this.msUtilDao.deleteBatchFromOdServer(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
        batch.setNoOfFiles(0L);
        batch.setTotalNoOfFiles("0");
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
    }

    private void createBatchForFailedMailBox(int cloudId, String deviceUUID, String userName, OfficeBackupPolicy oneDriveBackupPolicy, long batchStartTime) {
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String batchId = backupBatch.getId().toString();
        BackupBatch batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        logger.debug(batchId + "....user...." + userName);
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
        }
        if (batch != null && PCHelperConstant.BACKUP_STATUS.QUEUED.toString().equalsIgnoreCase(batch.getStatus())) {
            logger.debug("..... in queued ...." + batch.getStatus());
            BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batch.getId().toString());
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            backupAttempt.setErrorCode("544");
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            batch.setErrorCode("544");
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        this.msUtilDao.deleteBatchFromOdServer(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
        batch.setNoOfFiles(0L);
        batch.setTotalNoOfFiles("0");
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + batch.getId().toString());
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
    }

    private void createBatchForFailedSP(int cloudId, String deviceUUID, String userName, OfficeBackupPolicy oneDriveBackupPolicy) {
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String batchId = backupBatch.getId().toString();
        BackupBatch batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        logger.debug(batchId + "....user...." + userName);
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
        }
        if (batch != null && PCHelperConstant.BACKUP_STATUS.QUEUED.toString().equalsIgnoreCase(batch.getStatus())) {
            logger.debug("..... in queued ...." + batch.getStatus());
            BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batch.getId().toString());
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            backupAttempt.setErrorCode("545");
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            batch.setErrorCode("545");
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        this.msUtilDao.deleteBatchFromOdServer(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
        batch.setNoOfFiles(0L);
        batch.setTotalNoOfFiles("0");
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + batch.getId().toString());
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batch.getBatchStartTimestamp());
    }

    private void createBatchForFailedOneDrive(int cloudId, String deviceUUID, String userName, OfficeBackupPolicy oneDriveBackupPolicy) {
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String batchId = backupBatch.getId().toString();
        BackupBatch batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        logger.debug(batchId + "....user...." + userName);
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
        }
        if (batch != null && PCHelperConstant.BACKUP_STATUS.QUEUED.toString().equalsIgnoreCase(batch.getStatus())) {
            logger.debug("..... in queued ...." + batch.getStatus());
            BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batch.getId().toString());
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            backupAttempt.setErrorCode("546");
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
            batch.setErrorCode("546");
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        this.msUtilDao.deleteBatchFromOdServer(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
        batch.setNoOfFiles(0L);
        batch.setTotalNoOfFiles("0");
        batch.setBatchEndTimestamp(System.currentTimeMillis());
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + batch.getId().toString());
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batch.getBatchStartTimestamp());
        this.msUtilDao.updateBkpBatchDetailsEndTime(cloudId, batch);
        this.deleteEventHubForUser(cloudId, userName, "STARTED");
        this.deleteEventHubForUser(cloudId, userName, "PROCESSED");
    }

    private static List<DriveItem> getDiffItems(List<DriveItem> newDriveItems, List<DriveItem> prevDriveItems) {
        Predicate<DriveItem> somePre = newItem -> prevDriveItems.stream().noneMatch(prevItem -> newItem.id.compareTo(prevItem.id) == 0);
        List<DriveItem> newItemsToBeAdded = ((Stream)newDriveItems.stream().parallel()).filter(somePre).collect(Collectors.toList());
        logger.debug("..itemnewlogic.. " + newItemsToBeAdded.size());
        return newItemsToBeAdded;
    }

    private GraphServiceClient<Request> getGraphClient() {
        return Graph.getInstance().getGraphClient();
    }

    private String getDriveIdForUser(Cloud cloud, String emailId) {
        Drive drive = null;
        try {
            ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
            requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(requestOptions)).top(1).get());
            String userId = "";
            for (User userObj : iUserCollectionPage.getCurrentPage()) {
                logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                userId = userObj.id;
            }
            logger.debug(userId + ".. get drive1 for user given name.... " + emailId);
            drive = this.getDrive(this.getGraphClient(), userId);
            if (drive != null) {
                logger.debug(emailId + "....drive id for user ... " + drive.id);
                return drive.id;
            }
        }
        catch (Exception ee) {
            logger.error(".... exception......" + ee.getMessage());
        }
        return null;
    }

    private Drive getDrive(GraphServiceClient<Request> graphClient, String userId) {
        Drive drive = (Drive)this.retryPolicyFactory.executeWithRetry(() -> graphClient.users(userId).drive().buildRequest(new Option[0]).get());
        return drive;
    }

    private String findFiles(String deviceUUID, String deltaToken, List<DriveItem> listItems, String userName, String emailId, Cloud cloud) {
        DriveItemDeltaCollectionRequestBuilder nextPage;
        String deltaLink = "";
        DriveItemDeltaCollectionPage deltaPage = null;
        logger.debug("... before drive..." + deviceUUID);
        int cloudId = cloud.getCloudId();
        String driveId = this.getDriveIdForUser(cloud, emailId);
        DriveRequestBuilder drives = this.getDrive(cloudId, driveId);
        logger.debug(driveId + "... after drive...");
        try {
            if (!StringUtils.isEmpty((String)deltaToken)) {
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta().buildRequest(new Option[0])).get());
            }
        }
        catch (Error e) {
            logger.error(driveId + " ... unable to get drive so pause for 1 min ... " + userName);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ...inside Exception unable to get drive so pause for 1 min ... " + userName);
        }
        logger.debug("... after deltapage..." + deltaPage);
        boolean isNextPageExists = false;
        List currentPage = null;
        int i = 0;
        do {
            currentPage = deltaPage.getCurrentPage();
            logger.debug("... after currentpage...");
            listItems.addAll(currentPage);
            logger.debug(i + "... itempage size... " + currentPage.size());
            deltaLink = deltaPage.deltaLink();
            nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
            if (deltaLink == null) {
                logger.error("... delta link is null... " + nextPage.getRequestUrl());
                String serviceRoot = " https://graph.microsoft.com";
                deltaLink = ((DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(serviceRoot, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
            driveItemDeltaParameterSet.token = deltaToken;
            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)drives.root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            logger.debug("... after currentpage deltaToken...");
            ++i;
        } while (currentPage.size() > 0 && nextPage != null && (isNextPageExists = true));
        return deltaToken;
    }

    private String findOdFiles(String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String emailId, Cloud cloud, boolean firstCrawl, String productType) {
        logger.debug("... before drive..." + deviceUUID);
        try {
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl, productType);
        }
        catch (GraphServiceException ee) {
            logger.error("...response code ....wait 2 mins.." + ee.getResponseCode());
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug(" graph service exception found so retry ..... ");
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl, productType);
        }
        catch (Exception ee) {
            logger.debug(" od files exception found so retry ..... ");
            deltaToken = this.getODFiles(deviceUUID, deltaToken, userName, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, emailId, cloud, firstCrawl, productType);
        }
        return deltaToken;
    }

    private String getODFiles(String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, ODBBackupBatch backupBatch, String batchId, String eventHubId, String emailId, Cloud cloud, boolean firstCrawl, String productType) {
        String deltaLink = "";
        DriveItemDeltaCollectionPage deltaPage = null;
        String driveId = this.getDriveIdForUser(cloud, emailId);
        if (StringUtils.isEmpty((String)driveId) || !StringUtils.isEmpty((String)driveId) && "404".equals(driveId)) {
            this.updateOverViewStatus(cloud.getCloudId(), deviceUUID, 2003);
            return deltaToken;
        }
        int cloudId = cloud.getCloudId();
        try {
            if (!StringUtils.isEmpty((String)deltaToken)) {
                logger.debug("...inside delta...." + deltaToken);
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            } else {
                logger.debug("...empty delta...." + deltaToken);
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
                logger.debug("...after empty delta...." + deltaToken);
            }
        }
        catch (Error e) {
            logger.error(deviceUUID + " ... unable to get drive so pause for 1 min ... " + userName + "..." + driveId);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.debug("... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
            }
        }
        catch (GraphServiceException e) {
            logger.debug("...graph response code...." + e.getResponseCode());
            if (e.getResponseCode() == 401) {
                logger.error(" ...inside GraphServiceException and 401 case... ");
            } else if (e.getResponseCode() == 429) {
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException driveItemDeltaParameterSet) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        if (!StringUtils.isEmpty((String)deltaToken)) {
                            DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                            driveItemDeltaParameterSet.token = deltaToken;
                            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
                        } else {
                            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
                        }
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (e.getResponseCode() != 429) continue;
                        success = true;
                    }
                } while (success);
            } else {
                logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + deviceUUID);
                if (e.getResponseCode() == 403) {
                    logger.debug("403...check for permisiion for user ..." + userName);
                    return deltaToken;
                }
                if (e.getResponseCode() == 410) {
                    logger.debug("...token is out of sync .. so empty delta....");
                    deltaToken = "";
                    isFullBackup = true;
                }
            }
            logger.debug(driveId + "... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ...inside Exception unable to get drive so pause for 1 min ... " + userName);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException driveItemDeltaParameterSet) {
                // empty catch block
            }
            logger.debug("... retry for drive...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            }
            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
        }
        logger.debug("... after deltapage..." + deltaPage);
        boolean isNextPageExists = false;
        List currentPage = null;
        int i = 0;
        int totalFiles = 0;
        boolean firstTimeCheckForFolders = true;
        String prevDeviceToken = "";
        do {
            if (this.isBkpStopped(cloudId, batchId)) {
                return "";
            }
            currentPage = deltaPage.getCurrentPage();
            logger.debug("... after currentpage..." + totalFiles);
            ArrayList<DriveItem> newList = new ArrayList<DriveItem>();
            newList.addAll(currentPage);
            int noOfFiles = 0;
            oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloud.getCloudId(), userName, oneDriveBackupPolicy.getPolicyType());
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                return "DIFF-BLUKRYPT";
            }
            noOfFiles = this.handleItemsForOd(newList, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, deviceDestCollection, false, backupBatch, batchId, eventHubId, driveId, deltaToken, firstTimeCheckForFolders, firstCrawl, productType, cloud);
            firstTimeCheckForFolders = false;
            logger.debug(noOfFiles + "...total files processedd...." + (totalFiles += noOfFiles));
            deltaLink = deltaPage.deltaLink();
            DriveItemDeltaCollectionRequestBuilder nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
            if (deltaLink == null) {
                logger.error("... delta link is null... " + nextPage.getRequestUrl());
                String serviceRoot = " https://graph.microsoft.com";
                deltaLink = ((DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(serviceRoot, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            logger.debug("...token...val..." + deltaToken);
            try {
                if (!StringUtils.isEmpty((String)deltaToken)) {
                    DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                    driveItemDeltaParameterSet.token = deltaToken;
                    deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
                }
            }
            catch (GraphServiceException e) {
                logger.debug("...graph response code...." + e.getResponseCode());
                logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + deviceUUID);
                if (e.getResponseCode() == 429) {
                    boolean success = true;
                    do {
                        try {
                            if (!StringUtils.isEmpty((String)deltaToken)) {
                                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                                driveItemDeltaParameterSet.token = deltaToken;
                                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
                            } else {
                                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
                            }
                            success = false;
                        }
                        catch (GraphServiceException ew) {
                            if (e.getResponseCode() != 429) continue;
                            success = true;
                        }
                    } while (success);
                } else if (e.getResponseCode() == 410) {
                    logger.debug("...token is out of sync .. so empty delta....");
                    deltaToken = "";
                    isFullBackup = true;
                    if (!StringUtils.isEmpty((String)deltaToken)) {
                        DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                        driveItemDeltaParameterSet.token = deltaToken;
                        deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
                    } else {
                        deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
                    }
                }
            }
            catch (ClientException ee) {
                try {
                    int count = 0;
                    int maxTries = 5;
                    do {
                        try {
                            logger.debug(count + "...retry iteration...." + userName);
                            Thread.sleep(EXPONENTIAL[count] * 60000);
                            if (!StringUtils.isEmpty((String)deltaToken)) {
                                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                                driveItemDeltaParameterSet.token = deltaToken;
                                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
                                continue;
                            }
                            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().drives(driveId).root().delta().buildRequest(new Option[0])).get());
                        }
                        catch (GraphServiceException graphServiceException) {
                        }
                        catch (ClientException clientException) {
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (++count != maxTries && deltaPage == null);
                }
                catch (GraphServiceException graphServiceException) {
                    // empty catch block
                }
            }
            logger.debug(totalFiles + "... after currentpage deltaToken..." + noOfFiles + "....current..." + currentPage.size());
            ++i;
            if (currentPage.size() <= 0 || nextPage == null) {
                isNextPageExists = false;
                continue;
            }
            isNextPageExists = true;
            this.deviceDao.updateDeviceDeltaToken(cloudId, deviceUUID, deltaToken, prevDeviceToken);
            prevDeviceToken = deltaToken;
        } while (isNextPageExists);
        return deltaToken;
    }

    private List<String> crawlGraphContacts(int cloudId, String userId, String userName, boolean isFullBackup, String deviceDestCollection, String deviceUUID) {
        ArrayList<String> list = new ArrayList<String>();
        String deltaToken = "";
        logger.debug(isFullBackup + "......contacts for...." + userName);
        if (!isFullBackup) {
            deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser("contacts", userName);
        }
        if (StringUtils.isEmpty((String)deltaToken)) {
            deltaToken = "";
        }
        logger.debug(deltaToken + "......contacts for1...." + userName);
        boolean isNextPageExists = false;
        try {
            ContactDeltaCollectionRequestBuilder nextPage;
            do {
                ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
                if (!StringUtils.isEmpty((String)deltaToken)) {
                    QueryOption queryOption = new QueryOption("$deltatoken", (Object)deltaToken);
                    requestOptions.add(queryOption);
                }
                ContactDeltaCollectionPage deltaPage = (ContactDeltaCollectionPage)this.getGraphClient().users(userId).contacts().delta().buildRequest(requestOptions).get();
                for (Contact contact : deltaPage.getCurrentPage()) {
                    list.add(contact.id);
                }
                while (deltaPage.getNextPage() != null) {
                    deltaPage = (ContactDeltaCollectionPage)((ContactDeltaCollectionRequest)((ContactDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
                    for (Contact contact : deltaPage.getCurrentPage()) {
                        if (contact.additionalDataManager().containsKey((Object)"@removed")) {
                            logger.debug("....deletedstatus....");
                            try {
                                BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, contact.id, deviceDestCollection, deviceUUID);
                                if (backUpImageold == null) continue;
                                logger.debug("....handle deleted files case......" + contact.id);
                                BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                            }
                            catch (Exception e) {
                                logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                            }
                            continue;
                        }
                        list.add(contact.id);
                    }
                }
                String nextDeltaLink = deltaPage.getNextPage() != null ? ((ContactDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl() : "";
                deltaToken = deltaPage.deltaLink;
                deltaToken = MSServiceImpl.getDeltaToken(deltaToken);
                logger.debug(deltaToken + "....Next Delta Link: " + nextDeltaLink);
                logger.debug("....getdeltatoken...." + deltaToken);
                nextPage = (ContactDeltaCollectionRequestBuilder)deltaPage.getNextPage();
                this.msUtilDao.updateDeltaForPathAndUser("contacts", userName, deltaToken);
            } while (nextPage != null && (isNextPageExists = true));
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.error("....unable to get contacts......" + e.getMessage());
        }
        logger.debug("...total contacts ... " + list.size());
        return list;
    }

    private List<String> crawlGraphTasks(int cloudId, String userId, String userName, boolean isFullBackup, String deviceDestCollection, String deviceUUID) {
        ArrayList<String> list = new ArrayList<String>();
        String deltaToken = "";
        logger.debug(isFullBackup + "......tasks for...." + userName);
        if (StringUtils.isEmpty((String)deltaToken)) {
            deltaToken = "";
        }
        logger.debug(deltaToken + "......tasks for1...." + userName);
        boolean isNextPageExists = false;
        try {
            TodoTaskListCollectionPage taskListsPage = (TodoTaskListCollectionPage)((TodoTaskListCollectionRequest)this.getGraphClient().users(userId).todo().lists().buildRequest(new Option[0])).get();
            List taskLists = taskListsPage.getCurrentPage();
            if (taskLists != null && !taskLists.isEmpty()) {
                for (TodoTaskList firstTaskList : taskLists) {
                    TodoTaskDeltaCollectionRequestBuilder nextPage;
                    logger.debug("Task List: " + firstTaskList.displayName);
                    deltaToken = "";
                    if (!isFullBackup) {
                        deltaToken = this.msUtilDao.getDeltaLinkForPathAndUserTasks("tasks", userName, firstTaskList.id);
                    }
                    ArrayList<Object> requestOptions = new ArrayList<Object>();
                    logger.debug("Task Lis1t: " + firstTaskList.displayName);
                    TodoTaskDeltaCollectionPage deltaPage = null;
                    ArrayList<TodoTask> tasksList = new ArrayList<TodoTask>();
                    do {
                        JsonElement value;
                        String key;
                        boolean taskDeleted;
                        AdditionalDataManager additionalData;
                        if (!StringUtils.isEmpty((String)deltaToken)) {
                            QueryOption queryOption = new QueryOption("$deltatoken", (Object)deltaToken);
                            requestOptions.add(queryOption);
                            requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=10"));
                            deltaPage = (TodoTaskDeltaCollectionPage)this.getGraphClient().users(userId).todo().lists(firstTaskList.id).tasks().delta().buildRequest(requestOptions).select("id,createdDateTime").get();
                        } else {
                            requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=10"));
                            deltaPage = (TodoTaskDeltaCollectionPage)this.getGraphClient().users(userId).todo().lists(firstTaskList.id).tasks().delta().buildRequest(requestOptions).select("id,createdDateTime").get();
                        }
                        logger.debug("Task List2: " + firstTaskList.displayName);
                        for (TodoTask task : deltaPage.getCurrentPage()) {
                            logger.debug(firstTaskList.displayName + ".....status....." + task.additionalDataManager());
                            additionalData = task.additionalDataManager();
                            taskDeleted = false;
                            for (Map.Entry entry : additionalData.entrySet()) {
                                key = (String)entry.getKey();
                                value = (JsonElement)entry.getValue();
                                logger.debug("Key: " + key + ", Value: " + value.toString());
                                if (!key.equals("@removed") || !value.toString().contains("deleted")) continue;
                                taskDeleted = true;
                            }
                            logger.debug(taskDeleted + "....additional data manager... " + task.additionalDataManager().containsKey((Object)"removed"));
                            if (taskDeleted) {
                                logger.debug("The task has been deleted.  " + task.id);
                                try {
                                    this.deleteTask(cloudId, deviceDestCollection, deviceUUID, task);
                                }
                                catch (Exception e) {
                                    logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                                }
                                continue;
                            }
                            logger.debug(task.title + "..task-status...." + task.status.name());
                            if (task.status.name().equalsIgnoreCase("COMPLETED")) {
                                this.deleteTask(cloudId, deviceDestCollection, deviceUUID, task);
                            }
                            tasksList.add(task);
                        }
                        while (deltaPage.getNextPage() != null) {
                            deltaPage = (TodoTaskDeltaCollectionPage)((TodoTaskDeltaCollectionRequest)((TodoTaskDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
                            for (TodoTask task : deltaPage.getCurrentPage()) {
                                additionalData = task.additionalDataManager();
                                taskDeleted = false;
                                for (Map.Entry entry : additionalData.entrySet()) {
                                    key = (String)entry.getKey();
                                    value = (JsonElement)entry.getValue();
                                    logger.debug("Key: " + key + ", Value: " + value.toString());
                                    if (!key.equals("@removed") || !value.toString().contains("deleted")) continue;
                                    taskDeleted = true;
                                }
                                if (taskDeleted) {
                                    logger.debug("....deletedstatus....");
                                    try {
                                        this.deleteTask(cloudId, deviceDestCollection, deviceUUID, task);
                                    }
                                    catch (Exception e) {
                                        logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                                    }
                                    continue;
                                }
                                if (task.status.name().equalsIgnoreCase("COMPLETED")) {
                                    this.deleteTask(cloudId, deviceDestCollection, deviceUUID, task);
                                }
                                tasksList.add(task);
                            }
                        }
                        String nextDeltaLink = deltaPage.getNextPage() != null ? ((TodoTaskDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl() : "";
                        deltaToken = deltaPage.deltaLink;
                        deltaToken = MSServiceImpl.getDeltaToken(deltaToken);
                        logger.debug(deltaToken + "....Next Delta Link: " + nextDeltaLink);
                        logger.debug("....getdeltatoken...." + deltaToken);
                        nextPage = (TodoTaskDeltaCollectionRequestBuilder)deltaPage.getNextPage();
                        this.msUtilDao.updateDeltaForPathAndUserTasks("tasks", firstTaskList.id, userName, deltaToken);
                    } while (nextPage != null && deltaToken != null && (isNextPageExists = true));
                    tasksList.sort((task1, task2) -> {
                        OffsetDateTime date1 = task1.createdDateTime;
                        OffsetDateTime date2 = task2.createdDateTime;
                        if (date1 == null && date2 == null) {
                            return 0;
                        }
                        if (date1 == null) {
                            return 1;
                        }
                        if (date2 == null) {
                            return -1;
                        }
                        return date2.compareTo(date1);
                    });
                    for (TodoTask task : tasksList) {
                        list.add(firstTaskList.id + "-##-" + task.id);
                    }
                }
            } else {
                logger.debug("No task lists found.");
            }
        }
        catch (GraphServiceException e) {
            System.err.println("Error occurred: " + e.getMessage());
        }
        logger.debug("...total tasks ... " + list.size());
        return list;
    }

    private void deleteTask(int cloudId, String deviceDestCollection, String deviceUUID, TodoTask task) {
        BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, task.id, deviceDestCollection, deviceUUID);
        if (backUpImageold != null) {
            logger.debug("....handle deleted files case......" + task.id);
            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
        }
    }

    private static String getDeltaToken(String url1) {
        if (StringUtils.isEmpty((String)url1)) {
            return url1;
        }
        url1 = url1.substring(url1.lastIndexOf(61) + 1);
        url1 = url1.replace("'", "");
        url1 = url1.replace(")", "");
        return url1;
    }

    private int handleItemsForOd(List<DriveItem> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String driveID, String deltaToken, boolean firstTimeCheckForFolders, boolean firstCrawl, String productType, Cloud cloud) {
        int file = 0;
        int folder = 0;
        int noOfFiles = 0;
        int totalSizeToUpload = 0;
        ArrayList<DriveItem> folders = new ArrayList<DriveItem>();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        for (DriveItem driveItem : currentPage) {
            Deleted deleted = driveItem.deleted;
            if (deleted != null) continue;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder == null) continue;
            String basePath = "";
            String itemName = driveItem.name;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                String folderPathVal = BASE_FOLDER + newPath;
                ++folder;
                folderMap.put(folderPathVal, driveItem.id);
            }
            if (isFullBackup) continue;
            boolean allow = this.handleFolderElement(basePath, basePath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, cloud);
            allow = false;
            BackUpImage backUpImage = this.msUtilDao.getBackupImageForItemId(cloudId, driveItem.id, deviceDestCollection, deviceUUID);
            if (backUpImage != null && backUpImage.getDevicePath().equalsIgnoreCase(basePath)) {
                logger.debug("...already folder exists ..." + backUpImage.getFileName());
                logger.debug("......existsval-...." + backUpImage.getDevicePath() + "******" + basePath);
                logger.debug("......exists...." + backUpImage.getDevicePath().equalsIgnoreCase(basePath));
                allow = false;
            } else {
                logger.debug("...folder not exists so add ..." + driveItem.id);
            }
            if (!allow) continue;
            logger.debug("... folder allowed.... " + basePath + "..." + allow);
        }
        int i = 0;
        logger.debug("......folders.... " + folders.size());
        if (firstTimeCheckForFolders) {
            List<DriveItem> listItems = this.getModifiedFolderFiles(cloudId, deviceDestCollection, folders, deviceUUID, driveID, deltaToken);
            currentPage.addAll(listItems);
        }
        logger.debug("... files to process... " + currentPage.size());
        i = 0;
        boolean isLinkPolicyEnabled = false;
        if (oneDriveBackupPolicy != null && oneDriveBackupPolicy.isCreateLinkEnabled()) {
            isLinkPolicyEnabled = true;
        }
        for (DriveItem driveItem : currentPage) {
            String newPath;
            ++i;
            boolean isFolder = false;
            if (driveItem.folder != null) {
                isFolder = true;
            }
            String basePath = "";
            boolean isPresent = true;
            String itemName = driveItem.name;
            logger.debug(".....driveitemname......" + itemName);
            oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                continue;
            }
            logger.debug(driveItem.name + "..filetoProcess..." + driveItem.id);
            Deleted deleted = driveItem.deleted;
            if (deleted != null) {
                logger.debug(productType + "....deletedstatus...." + deleted);
                try {
                    BackUpImage deletedBkpImage;
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, driveItem.id, deviceDestCollection, deviceUUID);
                    if (backUpImageold != null && !isLinkPolicyEnabled) {
                        logger.debug("....handle deleted files case......" + driveItem.id);
                        deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                    }
                    if (backUpImageold == null || !isLinkPolicyEnabled) continue;
                    deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                    this.msUtilDao.checkAndDeleteCPFile(cloudId, driveItem.id, deviceUUID, productType, deletedBkpImage, deviceDestCollection);
                }
                catch (Exception e) {
                    logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                }
                continue;
            }
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) {
                String parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                parentPath = StringUtils.isEmpty((String)parentPath) ? BASE_FOLDER : BASE_FOLDER + parentPath;
                newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added 1.... " + driveItem.name);
                BackUpImage backUpImage = this.msUtilDao.getBackupImageFolder(cloudId, parentPath, driveItem.name, deviceDestCollection, deviceUUID);
                if (backUpImage != null) {
                    logger.debug("...folder exists..." + backUpImage.getDevicePath());
                } else {
                    logger.debug("...folder does not exists ..." + newPath);
                }
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
                ++folder;
            } else if (driveItem.file != null) {
                String parentPath;
                ++file;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            if (StringUtils.isEmpty((String)basePath)) {
                basePath = "";
            }
            if (StringUtils.isEmpty((String)itemName)) continue;
            boolean isFileAllowed = this.handleElement(basePath, itemName, driveItem.size, oneDriveBackupPolicy, deviceUUID, userName, cloudId, isMail);
            String appDisplayName = PCHelperConstant.getGraphAppName();
            logger.debug("...graph app name...." + appDisplayName);
            if (itemName.endsWith(".url") && driveItem.lastModifiedBy != null && driveItem.lastModifiedBy.application != null && driveItem.lastModifiedBy.application.displayName != null && (driveItem.lastModifiedBy.application.displayName.contains("Parablu Inc") || driveItem.lastModifiedBy.application.displayName.contains("Microsoft Graph") || !StringUtils.isEmpty((String)appDisplayName) && driveItem.lastModifiedBy.application.displayName.equals(appDisplayName))) continue;
            if (!isFileAllowed) {
                logger.debug("...file cannot be allowed... " + itemName);
                continue;
            }
            boolean backupAllVersions = oneDriveBackupPolicy.isBackupAllVersions();
            oneDriveBackupPolicy.setBackupAllVersions(false);
            if (backupAllVersions) {
                DriveItemVersionCollectionPage driveItemVersionCollectionPage;
                int maxVersions = oneDriveBackupPolicy.getCrawlVersions();
                if (maxVersions > 25 || maxVersions == -1) {
                    maxVersions = 25;
                }
                if ((driveItemVersionCollectionPage = (DriveItemVersionCollectionPage)((DriveItemVersionCollectionRequest)this.getGraphClient().drives(driveID).items(driveItem.id).versions().buildRequest(Arrays.asList(new QueryOption("$top", (Object)maxVersions)))).get()) == null) continue;
                List currentVersionsPage = driveItemVersionCollectionPage.getCurrentPage();
                ArrayList<String> versionIdList = new ArrayList<String>();
                for (DriveItemVersion driveItemVersion : currentVersionsPage) {
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemIdAndVersionId(cloudId, driveItem.id, driveItemVersion.id, deviceDestCollection, deviceUUID);
                    if (backUpImageold != null) break;
                    versionIdList.add(driveItemVersion.id);
                }
                versionIdList.sort((v1, v2) -> {
                    String[] version1 = v1.split("\\.");
                    String[] version2 = v2.split("\\.");
                    int majorCompare = Integer.compare(Integer.parseInt(version1[0]), Integer.parseInt(version2[0]));
                    if (majorCompare != 0) {
                        return majorCompare;
                    }
                    int minor1 = version1.length > 1 ? Integer.parseInt(version1[1]) : 0;
                    int minor2 = version2.length > 1 ? Integer.parseInt(version2[1]) : 0;
                    return Integer.compare(minor1, minor2);
                });
                for (String versionId : versionIdList) {
                    DriveFileInfo driveFileInfo = this.createDriveFileInfo(deviceUUID, userName, isFullBackup, batchId, folderMap, driveItem, isFolder, basePath, isPresent, itemName, versionId);
                    totalSizeToUpload += driveItem.size.intValue();
                    boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
                    this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
                    if (!itemSaved) continue;
                    ++noOfFiles;
                }
                continue;
            }
            DriveFileInfo driveFileInfo = this.createDriveFileInfo(deviceUUID, userName, isFullBackup, batchId, folderMap, driveItem, isFolder, basePath, isPresent, itemName, "");
            totalSizeToUpload += driveItem.size.intValue();
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        folderMap.forEach((path, itemId) -> {
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(backupBatch.getDeviceUUID());
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        logger.debug(".....nooffiles....." + noOfFiles);
        return noOfFiles;
    }

    private DriveFileInfo createDriveFileInfo(String deviceUUID, String userName, boolean isFullBackup, String batchId, Map<String, String> folderMap, DriveItem driveItem, boolean isFolder, String basePath, boolean isPresent, String itemName, String versionId) {
        DriveFileInfo driveFileInfo = new DriveFileInfo();
        driveFileInfo.setDeviceUUID(deviceUUID);
        String folderPath = BASE_FOLDER + basePath;
        driveFileInfo.setItemPath(folderPath);
        driveFileInfo.setItemName(itemName);
        driveFileInfo.setItemId(driveItem.id);
        driveFileInfo.setFolder(isFolder);
        driveFileInfo.setFilePresent(isPresent);
        driveFileInfo.setOperation("FILE");
        if (!StringUtils.isEmpty((String)versionId)) {
            driveFileInfo.setVersionId(versionId);
        }
        driveFileInfo.setBackupBatchId(batchId);
        driveFileInfo.setFullBackup(isFullBackup);
        if (driveItem.lastModifiedDateTime != null) {
            driveFileInfo.setO365LastModifiedTime(driveItem.lastModifiedDateTime.toInstant().toEpochMilli());
        } else {
            driveFileInfo.setO365LastModifiedTime(driveItem.createdDateTime.toInstant().toEpochMilli());
        }
        String folderItemId = "";
        if (folderMap.get(folderPath) != null) {
            folderItemId = folderMap.get(folderPath);
        }
        driveFileInfo.setParentItemId(folderItemId);
        driveFileInfo.setUserName(userName);
        driveFileInfo.setSize(driveItem.size);
        return driveFileInfo;
    }

    private void addChildFolders(String userPrincId, List<MailFolder> sublistItems, Map<String, String> folderPathMap, MailFolder fol) {
        MailFolderCollectionPage iMailFolderCollectionPage2 = (MailFolderCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderRequestBuilder)this.getGraphClient().users(userPrincId).mailFolders().byId(fol.id)).childFolders().buildRequest(new Option[0])).get());
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        do {
            mailcurrentPage = iMailFolderCollectionPage2.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            if (iMailFolderCollectionPage2.getNextPage() == null) break;
            iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)iMailFolderCollectionPage2.getNextPage()).buildRequest(new Option[0])).get();
        } while (listFolderItems.size() > 0 && (isNextPageExists = true));
        String parentPath1 = folderPathMap.get(fol.id);
        if (StringUtils.isEmpty((String)parentPath1)) {
            String pathva = fol.displayName;
            if (!StringUtils.isEmpty((String)parentPath1)) {
                pathva = parentPath1 + "/" + fol.displayName;
            }
            folderPathMap.put(fol.id, pathva);
        }
        listFolderItems.forEach(chfol -> {
            String parentPath = (String)folderPathMap.get(chfol.parentFolderId);
            String path = MSServiceImpl.getPath(fol, chfol, parentPath);
            folderPathMap.put(chfol.id, path);
            if (chfol.childFolderCount > 0) {
                this.addChildFolders(userPrincId, sublistItems, folderPathMap, (MailFolder)chfol);
                sublistItems.addAll(listFolderItems);
            }
        });
        sublistItems.addAll(listFolderItems);
    }

    private void addChildFoldersList(String userPrincId, List<MailFolder> sublistItems, Map<String, String> folderPathMap, MailFolder fol) {
        MailFolderCollectionPage iMailFolderCollectionPage2 = (MailFolderCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderRequestBuilder)this.getGraphClient().users(userPrincId).mailFolders().byId(fol.id)).childFolders().buildRequest(new Option[0])).get());
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        do {
            mailcurrentPage = iMailFolderCollectionPage2.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            if (iMailFolderCollectionPage2.getNextPage() == null) break;
            iMailFolderCollectionPage2 = (MailFolderCollectionPage)((MailFolderCollectionRequest)((MailFolderCollectionRequestBuilder)iMailFolderCollectionPage2.getNextPage()).buildRequest(new Option[0])).get();
        } while (listFolderItems.size() > 0 && (isNextPageExists = true));
        String parentPath1 = folderPathMap.get(fol.id);
        if (StringUtils.isEmpty((String)parentPath1)) {
            String pathva = fol.displayName;
            if (!StringUtils.isEmpty((String)parentPath1)) {
                pathva = parentPath1 + "/" + fol.displayName;
            }
            folderPathMap.put(fol.id, pathva);
        }
        listFolderItems.forEach(chfol -> {
            String parentPath = (String)folderPathMap.get(chfol.parentFolderId);
            String path = MSServiceImpl.getPath(fol, chfol, parentPath);
            folderPathMap.put(chfol.id, path);
            if (chfol.childFolderCount > 0) {
                this.addChildFoldersList(userPrincId, sublistItems, folderPathMap, (MailFolder)chfol);
                sublistItems.addAll(listFolderItems);
            }
        });
        sublistItems.addAll(listFolderItems);
    }

    private static String getPath(MailFolder fol, MailFolder chfol, String parentPath) {
        String path = fol.displayName + "/" + chfol.displayName;
        if (!StringUtils.isEmpty((String)parentPath)) {
            path = parentPath + "/" + chfol.displayName;
        }
        return path;
    }

    private static boolean isContainExactWord(String fullString, String partWord) {
        String pattern = "\\b" + partWord + "\\b";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(fullString);
        return m.find();
    }

    private void removeDeletedFolderFiles(int cloudId, String userName, String deviceUUID, Map<String, String> folderPathMap, String deviceDestCollection, String userPrincId, Map<String, String> inplaceFolderPathMap) {
        Set<String> delFolderMap = this.getDeletedFolderList(userName, folderPathMap);
        logger.debug("..folder delete size..." + delFolderMap.size());
        HashMap<String, String> deleteFolderPathMap = new HashMap<String, String>();
        HashSet<String> finalDelFolderMap = new HashSet<String>();
        for (String deleteFolder : delFolderMap) {
            if ("Deletions".equalsIgnoreCase(deleteFolder)) continue;
            logger.debug("...folder to delete...." + deleteFolder);
            String key = MSServiceImpl.getKeyFromValue(folderPathMap, deleteFolder);
            logger.debug(deleteFolder + ".......folderdelete...." + key);
            if (!StringUtils.isEmpty((String)key)) {
                MailFolder mailFolderVal = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> ((MailFolderRequestBuilder)this.getGraphClient().users(userPrincId).mailFolders().byId(key)).buildRequest(new Option[0]).get());
                if (mailFolderVal != null) {
                    JsonElement jsonElement = (JsonElement)mailFolderVal.additionalDataManager().get((Object)"@removed");
                    boolean isDeleted = false;
                    if (jsonElement != null) {
                        isDeleted = true;
                    }
                    logger.debug(deleteFolder + "..is folder deleted..." + isDeleted);
                    if (isDeleted) {
                        deleteFolderPathMap.put(key, deleteFolder);
                        finalDelFolderMap.add(deleteFolder);
                    }
                }
                logger.debug("......valdelete...." + mailFolderVal);
                continue;
            }
            logger.debug("....else dleete folder ..." + deleteFolder);
            if (inplaceFolderPathMap != null && inplaceFolderPathMap.size() > 0) {
                ArrayList<String> list = new ArrayList<String>(inplaceFolderPathMap.keySet());
                if (list.contains(deleteFolder)) continue;
                logger.debug(deleteFolder + "..is folder deleted key null...");
                deleteFolderPathMap.put(key, deleteFolder);
                finalDelFolderMap.add(deleteFolder);
                continue;
            }
            logger.debug(deleteFolder + "..is folder deleted key null...");
            deleteFolderPathMap.put(key, deleteFolder);
            finalDelFolderMap.add(deleteFolder);
        }
        if (!CollectionUtils.isEmpty(finalDelFolderMap)) {
            for (String newPathVal : finalDelFolderMap) {
                BackUpImage deletedBkpImage;
                if (StringUtils.isEmpty((String)newPathVal)) continue;
                String parentpath = newPathVal;
                String child = "";
                try {
                    parentpath = newPathVal.substring(0, newPathVal.lastIndexOf(47));
                    child = newPathVal.substring(newPathVal.lastIndexOf(47));
                    child = child.replaceFirst("/", "");
                }
                catch (Exception e) {
                    logger.error("...try checking path..." + parentpath);
                }
                logger.debug("...deleting folderrep lates..." + parentpath + "...." + child);
                if (!StringUtils.isEmpty((String)newPathVal) && (newPathVal.startsWith("In-Place Archive") || !StringUtils.isEmpty((String)parentpath) && parentpath.startsWith("recoverableitemsdeletions")) || (deletedBkpImage = this.msUtilDao.getBackupImageFolder(cloudId, parentpath, child, deviceDestCollection, deviceUUID)) != null && deletedBkpImage.isFolder() && !deletedBkpImage.isPresent()) continue;
                logger.debug("...start of delete files for path..." + newPathVal + "....devicuuid..." + deviceUUID);
                this.msUtilDao.deleteMailsForPath(cloudId, newPathVal, deviceUUID, deviceDestCollection);
                logger.debug("...end of delete files for path..." + newPathVal + "....devicuuid..." + deviceUUID);
                try {
                    try {
                        parentpath = newPathVal.substring(0, newPathVal.lastIndexOf(47));
                        child = newPathVal.substring(newPathVal.lastIndexOf(47));
                        child = child.replaceFirst("/", "");
                    }
                    catch (Exception e) {
                        logger.error("...try checking path..." + parentpath);
                    }
                    logger.debug("...deleting folderrep lates..." + parentpath + "...." + child);
                    if (deletedBkpImage == null || !deletedBkpImage.isFolder()) continue;
                    BackUpImage deletedBkpImageFold = this.convertToBkpImage(deletedBkpImage.getDeviceUUID(), deletedBkpImage);
                    this.msUtilDao.saveDeletedBackupImageForMail(cloudId, deletedBkpImageFold, deviceDestCollection);
                    this.msUtilDao.deletedeltPathForUser(deletedBkpImageFold.getDevicePath() + "/" + deletedBkpImageFold.getFileName(), userName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.debug("...unable to delete folder..." + newPathVal);
                }
            }
        }
    }

    private String handleMailItems(List<Message> currentPage, String deviceUUID, String userName, String emailId, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, String deltaToken, String eventHubId, long batchStartTime) {
        int folder = 0;
        int noOfFiles = 0;
        int cloudId = cloud.getCloudId();
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String orgPolicyName = oneDriveBackupPolicy.getPolicyName();
        String batchId = "";
        if (backupBatch != null) {
            batchId = backupBatch.getId().toString();
        }
        logger.debug(userName + "... files to process user... " + batchId);
        BackupBatch batch = null;
        if (!StringUtils.isEmpty((String)batchId)) {
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        logger.debug(batchId + "....user...." + userName);
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, deviceUUID);
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
            logger.debug(batchId + "....user2 delete batch...." + userName + "...." + batch.getStatus());
            ODBBackupBatch odbBackupBatch = new ODBBackupBatch();
            if (backupBatch != null) {
                BeanUtils.copyProperties((Object)backupBatch, (Object)odbBackupBatch);
            } else {
                BeanUtils.copyProperties((Object)batch, (Object)odbBackupBatch);
            }
            odbBackupBatch.setId(new ObjectId(batchId));
            backupBatch = this.msUtilDao.deleteAndCreateBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), odbBackupBatch);
        }
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        if (batch != null && PCHelperConstant.BACKUP_STATUS.QUEUED.toString().equalsIgnoreCase(batch.getStatus())) {
            logger.debug(".....not in scanning...." + batch.getStatus());
            backupBatch.setStatus("STARTED");
            BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batchId);
            if (backupAttempt == null) {
                backupAttempt = new BackupAttempt();
                BeanUtils.copyProperties((Object)backupBatch, (Object)backupAttempt);
                backupAttempt.setBatchId(backupBatch.getId().toString());
                backupAttempt.setId(null);
                backupAttempt.setErrorCode("0");
                backupAttempt.setBatchStartTimestamp(batch.getBatchStartTimestamp());
                backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.QUEUED.toString());
                this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            } else {
                backupAttempt.setBatchId(batchId);
                backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            }
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            if (!PCHelperConstant.BACKUP_STATUS.SCANNING.toString().equalsIgnoreCase(backupAttempt.getStatus())) {
                this.addScanningAttempt(cloudId, batchId, backupBatch);
            }
            backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        ArrayList folders = new ArrayList();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        int i = 0;
        logger.debug(userName + "......folders.... " + folders.size());
        logger.debug("... files to process... " + currentPage.size());
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBackupOverViewForDevice(cloudId, deviceUUID);
        boolean isNewDevice = false;
        if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            isNewDevice = true;
        }
        User userFound = null;
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(new Option[0])).filter("mail eq '" + emailId + "'").top(1).get());
        for (User userObj : iUserCollectionPage.getCurrentPage()) {
            logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
            if (!emailId.equalsIgnoreCase(userObj.mail) || !emailId.equalsIgnoreCase(userObj.userPrincipalName)) continue;
            userFound = userObj;
            break;
        }
        if (userFound == null) {
            for (User user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        if (userFound == null) {
            logger.error(".... user not found ..." + userName);
            return "";
        }
        String userPrincId = userFound.id;
        UserRequestBuilder users = (UserRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId));
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        logger.debug(mailFolders + ".. mail-folders..." + userName);
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = null;
        if (isFullBackup) {
            deltaToken = "";
        }
        try {
            deltaPage = (MailFolderDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)this.getGraphClient().users(userPrincId).mailFolders().delta().buildRequest(new Option[0])).get());
        }
        catch (GraphServiceException e2) {
            logger.error("...error trying to get folders..... " + e2.getResponseCode());
            return "ACCESS_DENIED";
        }
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        ArrayList<Folder> archivelistFolderItems = new ArrayList<Folder>();
        do {
            if (this.isBkpStopped(cloudId, batchId)) {
                return "";
            }
            mailcurrentPage = deltaPage.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(SERVICE_ROOT, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (mailcurrentPage.size() > 0 && (isNextPageExists = true));
        logger.debug(deltaToken + "...total folders.. " + listFolderItems.size());
        ArrayList sublistItems = new ArrayList();
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        String rootId = this.getRootFolderId(userPrincId);
        listFolderItems.forEach(fol -> {
            MailFolder folderval = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> ((MailFolderRequestBuilder)this.getGraphClient().users(userPrincId).mailFolders().byId(fol.parentFolderId)).buildRequest(new Option[0]).get());
            if (folderval.id.equalsIgnoreCase(rootId)) {
                folderPathMap.put(fol.id, fol.displayName);
            }
            if (fol.childFolderCount > 0) {
                this.addChildFoldersList(userPrincId, sublistItems, (Map<String, String>)folderPathMap, (MailFolder)fol);
            }
        });
        deltaToken = "";
        String userPrincIdStr = userPrincId;
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder mailFolder = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get());
            folderPathMap.put(mailFolder.id, "Recoverable Items");
            mailFolder = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincIdStr).mailFolders("RecoverableItemsPurges").buildRequest(new Option[0]).get());
            folderPathMap.put(mailFolder.id, "Purged Items");
        }
        Map<String, String> inplaceFolderPathMap = new HashMap<String, String>();
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            EWSAppSetting appSetting = this.msUtilDao.getEwsAppSettingDetail(cloudId);
            logger.debug(".....ewsapppp......" + appSetting.getClientId() + "....sec..." + appSetting.getClientSecretKey());
            String token = MSServiceImpl.getEWSAccesToken(appSetting.getClientId(), appSetting.getClientSecretKey(), appSetting.getTenantId());
            ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
            inplaceFolderPathMap = MSServiceImpl.getInPlaceArchiveFolders(service, emailId);
        }
        HashMap deltaMap = new HashMap();
        boolean allTokenDeleted = true;
        if (oneDriveBackupPolicy.isContactsEnabled()) {
            folderPathMap.put("contacts", "contacts");
        }
        for (Map.Entry entry : folderPathMap.entrySet()) {
            if (!isFullBackup) {
                deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser((String)entry.getValue(), userName);
            }
            logger.debug("...all paths....." + (String)entry.getValue() + "...." + deltaToken);
            if (!StringUtils.isEmpty((String)deltaToken)) {
                allTokenDeleted = false;
            }
            deltaMap.put(entry.getValue(), deltaToken);
        }
        if (oneDriveBackupPolicy.isContactsEnabled()) {
            folderPathMap.remove("contacts");
        }
        if (allTokenDeleted) {
            isFullBackup = true;
            this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        this.removeDeletedFolderFiles(cloudId, userName, deviceUUID, folderPathMap, deviceDestCollection, userPrincId, inplaceFolderPathMap);
        boolean diffBlukrypt = false;
        String userPrincIdStrVal = userFound.id;
        if (!batch.isFullBackup()) {
            // empty if block
        }
        int totalCount = 0;
        int totalFolderCount = folderPathMap.size();
        int folderProcessed = 0;
        diffBlukrypt = false;
        block29: for (Map.Entry entry : folderPathMap.entrySet()) {
            boolean isFileAllowed;
            String parentPath;
            ++folderProcessed;
            String folderId = (String)entry.getKey();
            MailFolder fol2 = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> ((MailFolderRequestBuilder)this.getGraphClient().users(userPrincIdStrVal).mailFolders().byId(folderId)).buildRequest(new Option[0]).get());
            String actualPath = parentPath = (String)entry.getValue();
            if (((String)entry.getValue()).contains("/")) {
                String[] parentPatharr = ((String)entry.getValue()).split("/");
                parentPath = parentPatharr[0];
            }
            if (!(isFileAllowed = this.handleMailElement(actualPath, parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false, cloud))) continue;
            folderMap.put(fol2.displayName, fol2.id);
            totalCount += fol2.totalItemCount.intValue();
            String messagesDelta = "";
            MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
            if (deltaMap.get(entry.getValue()) != null) {
                messagesDelta = (String)deltaMap.get(entry.getValue());
                messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
            }
            if (isFullBackup) {
                messagesDelta = "";
            }
            int j = 0;
            LinkedList<HeaderOption> requestOptionsPagination = new LinkedList<HeaderOption>();
            requestOptionsPagination.add(new HeaderOption("Prefer", "odata.maxpagesize=20"));
            try {
                String messageDeltaFinal = messagesDelta;
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                } else {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                    logger.debug("... old delta... ..." + messagesDelta);
                }
            }
            catch (ClientException ee) {
                logger.debug(folderId + "...fol retry..." + fol2.displayName + "..." + fol2.id);
                if (!StringUtils.isEmpty((String)ee.getMessage()) && ee.getMessage().contains("SyncStateNotFound") | ee.getMessage().contains("SyncStateInvalid")) {
                    messagesDelta = "";
                    logger.debug("..invalid state found for folder and user..." + userName + "...." + (String)entry.getValue());
                    this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messagesDelta);
                    continue;
                }
                boolean crawlCompleted = false;
                do {
                    try {
                        if (this.isBkpStopped(cloudId, batchId)) {
                            return "";
                        }
                        logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 60 sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                        logger.error(folderProcessed + "/" + totalFolderCount + "...foldersprocessed ..." + ee.getMessage());
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (StringUtils.isEmpty((String)messagesDelta)) {
                            iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                            crawlCompleted = true;
                            continue;
                        }
                        String messageDeltaFinal = messagesDelta;
                        logger.debug("... old delta... ..." + messagesDelta);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)((MessageDeltaCollectionRequest)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(new Option[0])).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                        crawlCompleted = true;
                    }
                    catch (ClientException eee) {
                        crawlCompleted = false;
                    }
                } while (!crawlCompleted);
            }
            logger.debug("....deltapage..." + iMessageDeltaCollectionPage);
            if (iMessageDeltaCollectionPage == null) continue;
            boolean isNextPageExistsv = false;
            String messDeltaLink = "";
            String nextRequestUrl = "";
            String prevRequestUrl = "";
            List currentPage2 = null;
            do {
                try {
                    if (this.isBkpStopped(cloudId, batchId)) {
                        return "";
                    }
                    oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
                    if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                        logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                        diffBlukrypt = true;
                        continue block29;
                    }
                    currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                    String path2 = fol2.displayName;
                    if (!StringUtils.isEmpty((String)((String)folderPathMap.get(fol2.id)))) {
                        path2 = (String)folderPathMap.get(fol2.id);
                    }
                    Map mailFilterMap = oneDriveBackupPolicy.getOutlookFilters();
                    HashSet<String> messageSet = new HashSet<String>();
                    HashSet<String> deletedMessageSet = new HashSet<String>();
                    for (Message message : currentPage2) {
                        boolean isFromAllowed = true;
                        boolean isToAllowed = true;
                        boolean isSubjectAllowed = true;
                        String fromVal = "";
                        String toVal = "";
                        String subject = "";
                        if (mailFilterMap != null && mailFilterMap.size() > 0) {
                            for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                                if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    fromVal = (String)filterEntry.getValue();
                                }
                                if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    toVal = (String)filterEntry.getValue();
                                }
                                if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                                subject = (String)filterEntry.getValue();
                            }
                            if (!StringUtils.isEmpty((String)fromVal)) {
                                isFromAllowed = this.fromFilterCheck(message, fromVal);
                            }
                            if (!StringUtils.isEmpty((String)toVal)) {
                                isToAllowed = this.toFilterCheck(message, toVal);
                            }
                            if (!StringUtils.isEmpty((String)subject)) {
                                String[] subjectArr = subject.split(",");
                                List<Object> subjList = new ArrayList();
                                subjList = Arrays.asList(subjectArr);
                                if (!CollectionUtils.isEmpty(subjList)) {
                                    for (String string : subjList) {
                                        if (StringUtils.isEmpty((String)message.subject) || !MSServiceImpl.isContainExactWord(message.subject.toLowerCase(), string.toLowerCase())) continue;
                                        isSubjectAllowed = false;
                                    }
                                }
                            }
                        }
                        boolean isMailAllowed = true;
                        if (!StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)subject) && !isFromAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject) && !isToAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && !isSubjectAllowed) {
                            isMailAllowed = false;
                        }
                        if (!(StringUtils.isEmpty((String)subject) || StringUtils.isEmpty((String)toVal) || StringUtils.isEmpty((String)fromVal))) {
                            isMailAllowed = isSubjectAllowed || isToAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal)) {
                            isMailAllowed = isSubjectAllowed || isToAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal)) {
                            isMailAllowed = isSubjectAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject)) {
                            logger.debug(message.subject + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                            isMailAllowed = isToAllowed || isFromAllowed;
                        }
                        if (!isMailAllowed) continue;
                        boolean mailAllow = true;
                        if (!isFullBackup) {
                            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, message.id, deviceDestCollection, deviceUUID);
                            if (backUpImageold != null) {
                                BackUpImage backUpImage = this.msUtilDao.getBackupImageForItemIdWOStatus(cloudId, message.id, deviceDestCollection, deviceUUID);
                                logger.debug(backUpImage + "....--message-to-track backUpImageold....." + backUpImageold.getSubject());
                                logger.debug(path2 + "....message-to-track path....." + backUpImageold.getDevicePath());
                                mailAllow = backUpImage == null || !path2.equalsIgnoreCase(backUpImageold.getDevicePath()) || oneDriveBackupPolicy.isCreateMailLinkEnabled() && !backUpImageold.isMailLinkGenerated();
                            } else {
                                mailAllow = true;
                            }
                        }
                        boolean isDeleted = false;
                        JsonElement jsonElement = (JsonElement)message.additionalDataManager().get((Object)"@removed");
                        if (jsonElement != null) {
                            isDeleted = true;
                        }
                        if (!mailAllow && !isDeleted) continue;
                        if (isDeleted) {
                            deletedMessageSet.add(message.id);
                            continue;
                        }
                        messageSet.add(message.id);
                    }
                    logger.debug("....after iteraion..." + messageSet.size());
                    int currentFiles = this.processMessageList(messageSet, deletedMessageSet, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, batchId, folderMap, i, path2, userFound.id, deviceDestCollection, eventHubId, isNewDevice);
                    noOfFiles += currentFiles;
                    if (iMessageDeltaCollectionPage != null && iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl());
                    }
                    if (iMessageDeltaCollectionPage.getNextPage() == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block29;
                    }
                    messDeltaLink = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                    logger.debug(folderProcessed + "/" + totalFolderCount + "....before calling next page ..." + noOfFiles + "..noofiles...." + deltaTokenval);
                    if (StringUtils.isEmpty((String)deltaTokenval)) {
                        logger.debug(".....NODELTA...." + messDeltaLink);
                        logger.debug(fol2.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + noOfFiles + "/" + totalCount);
                        continue block29;
                    }
                    try {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                    }
                    catch (ClientException ee) {
                        ee.printStackTrace();
                        boolean crawlCompleted = false;
                        do {
                            try {
                                logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 60 sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                                logger.error(folderProcessed + "/" + totalFolderCount + "...foldersprocessed stacktrace ..." + noOfFiles + "......" + ee.getMessage());
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (InterruptedException isSubjectAllowed) {
                                    // empty catch block
                                }
                                if (StringUtils.isEmpty((String)messagesDelta)) {
                                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                                    crawlCompleted = true;
                                    continue;
                                }
                                String messageDeltaFinal = messagesDelta;
                                logger.debug("... old delta... ..." + messagesDelta);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                                crawlCompleted = true;
                            }
                            catch (GraphServiceException eee) {
                                logger.error("...graph exception retry..." + eee.getResponseCode());
                                crawlCompleted = false;
                            }
                            catch (ClientException eee) {
                                logger.error("...Client  exception retry..." + eee.getMessage());
                                crawlCompleted = false;
                            }
                        } while (!crawlCompleted);
                    }
                    logger.debug("....end of calling next page ...");
                    if (iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    }
                    if (!StringUtils.isEmpty((String)nextRequestUrl)) {
                        prevRequestUrl = nextRequestUrl;
                    }
                    ++j;
                    if (currentPage2.size() <= 0) {
                        if (messDeltaLink == null) {
                            messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        }
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block29;
                    }
                    isNextPageExistsv = true;
                    logger.debug(backupBatch.getId().toString() + "... " + fol2.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + noOfFiles + "/" + totalCount);
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 401) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException mailFilterMap) {
                            // empty catch block
                        }
                    }
                    logger.debug(e.getResponseCode() + "...token waited ..." + nextRequestUrl);
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        nextRequestUrl = prevRequestUrl;
                    }
                    logger.debug("....trying after 401...." + emailId + "..." + userName + "...." + folderId);
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                    } else {
                        logger.debug("... old delta1... ..." + nextRequestUrl);
                        String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                    }
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (ClientException ee) {
                    ee.printStackTrace();
                    boolean isDeltaquerySucess = false;
                    do {
                        logger.debug(folderId + "....client exception eeeee wait for 5 sec... " + ee.getMessage());
                        logger.debug(nextRequestUrl + "....nextRequestUrl eeeee prevRequestUrl... " + prevRequestUrl);
                        logger.debug("....messDeltaLink... " + messDeltaLink);
                        try {
                            Thread.sleep(5000L);
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                nextRequestUrl = prevRequestUrl;
                            }
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                logger.debug("...no nextRequestUrl....");
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                            } else {
                                logger.debug("... old delta1..new. ...");
                                String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                            }
                            isDeltaquerySucess = true;
                        }
                        catch (Exception e) {
                            isDeltaquerySucess = false;
                        }
                    } while (!isDeltaquerySucess);
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                    logger.error("..broken.... " + eee.getMessage());
                    isNextPageExistsv = false;
                }
            } while (isNextPageExistsv);
        }
        folderMap.forEach((path, itemId) -> {
            logger.debug("path  : " + path + " itemId : " + itemId);
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(deviceUUID);
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        try {
            logger.debug(".....is contacts enabled in office policy .... " + oneDriveBackupPolicy.isContactsEnabled());
            if (!diffBlukrypt && oneDriveBackupPolicy.isContactsEnabled()) {
                noOfFiles = this.findContacts(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
            }
            logger.debug(".....is tasks enabled in office policy .... " + oneDriveBackupPolicy.isTasksEnabled());
            if (!diffBlukrypt && oneDriveBackupPolicy.isTasksEnabled()) {
                noOfFiles = this.findTasks(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
            }
            logger.debug(userName + "...userNameval....inplacearchive flag.... " + oneDriveBackupPolicy.isInPlaceMailArchiveEnabled());
            if (!diffBlukrypt && oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
                noOfFiles = this.handleEWSInPlaceMailArchive(userName, emailId, cloudId, archivelistFolderItems, noOfFiles, deviceUUID, batchId, userFound.id, eventHubId, deviceDestCollection, oneDriveBackupPolicy, isFullBackup, cloud);
            }
            if (!diffBlukrypt && oneDriveBackupPolicy.isCalendarEnabled()) {
                logger.debug("...start of calendars....");
                noOfFiles = this.findEWSCalendar(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
                logger.debug("...end of calendars....");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("... error trying to crawl contacts and tasks ...." + e.getMessage());
        }
        if (diffBlukrypt) {
            logger.debug("....diff blukrypt....");
            oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
            this.msUtilDao.saveBatch(cloudId, batchId, orgPolicyName, oneDriveBackupPolicy.getPolicyName(), eventHubId, oneDriveBackupPolicy.getMsAppBluKrypt());
        } else {
            backupBatch.setId(new ObjectId(batchId));
            backupBatch.setStatus("COMPLETED");
            long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
            long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
            backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
            batch.setNoOfFiles(0L);
            batch.setTotalNoOfFiles("" + totalFilesCount);
            backupBatch.setTotalNoOfFiles("" + totalFilesCount);
            batch.setStatus(BackupBatch.STATUS.SCANNING.toString());
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion11..." + backupBatch.getId().toString());
            this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion22..." + backupBatch.getId().toString());
            this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
            logger.debug(folder + ".....folder + file......." + totalFilesCount);
            logger.debug(".....nooffiles....." + totalFilesCount);
            this.addWaitForBackupAttempt(cloudId, batchId, backupBatch);
            batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
            this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
            this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
            this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        }
        return deltaToken;
    }

    private void handleDeletedMailsFirst(Map<String, String> folderPathMap, String userPrincIdStrVal, OfficeBackupPolicy oneDriveBackupPolicy, Cloud cloud, Device device, Map<String, String> deltaMap, String batchId) {
        String userPrincId = userPrincIdStrVal;
        String deviceUUID = device.getDeviceUUID();
        String userName = device.getUserName();
        int deletedTotalCount = 0;
        int cloudId = cloud.getCloudId();
        int deletedtotalFolderCount = folderPathMap.size();
        int deletedfolderProcessed = 0;
        boolean diffBlukrypt = false;
        block21: for (Map.Entry<String, String> entry : folderPathMap.entrySet()) {
            boolean isFileAllowed;
            String parentPath;
            ++deletedfolderProcessed;
            String folderId = entry.getKey();
            MailFolder fol = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> ((MailFolderRequestBuilder)this.getGraphClient().users(userPrincIdStrVal).mailFolders().byId(folderId)).buildRequest(new Option[0]).get());
            String actualPath = parentPath = entry.getValue();
            if (entry.getValue().contains("/")) {
                String[] parentPatharr = entry.getValue().split("/");
                parentPath = parentPatharr[0];
            }
            if (!(isFileAllowed = this.handleMailElement(actualPath, parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false, cloud))) continue;
            deletedTotalCount += fol.totalItemCount.intValue();
            String messagesDelta = "";
            MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
            if (deltaMap.get(entry.getValue()) != null) {
                messagesDelta = deltaMap.get(entry.getValue());
                messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
            }
            int j = 0;
            LinkedList<HeaderOption> requestOptionsPagination = new LinkedList<HeaderOption>();
            requestOptionsPagination.add(new HeaderOption("Prefer", "odata.maxpagesize=20"));
            try {
                String messageDeltaFinal = messagesDelta;
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincIdStrVal).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                } else {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincIdStrVal).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                    logger.debug("... old delta... ..." + messagesDelta);
                }
            }
            catch (ClientException ee) {
                logger.debug(folderId + "...fol retry..." + fol.displayName + "..." + fol.id);
                if (!StringUtils.isEmpty((String)ee.getMessage()) && ee.getMessage().contains("SyncStateNotFound") | ee.getMessage().contains("SyncStateInvalid")) {
                    messagesDelta = "";
                }
                boolean crawlCompleted = false;
                do {
                    try {
                        if (this.isBkpStopped(cloudId, batchId)) {
                            return;
                        }
                        logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 60 sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                        logger.error(deletedfolderProcessed + "/" + deletedtotalFolderCount + "...foldersprocessed ..." + ee.getMessage());
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (StringUtils.isEmpty((String)messagesDelta)) {
                            iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                            crawlCompleted = true;
                            continue;
                        }
                        String messageDeltaFinal = messagesDelta;
                        logger.debug("... old delta... ..." + messagesDelta);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)((MessageDeltaCollectionRequest)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(new Option[0])).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                        crawlCompleted = true;
                    }
                    catch (ClientException eee) {
                        crawlCompleted = false;
                    }
                } while (!crawlCompleted);
            }
            logger.debug("....deltapage..." + iMessageDeltaCollectionPage);
            if (iMessageDeltaCollectionPage == null) continue;
            boolean isNextPageExistsv = false;
            String messDeltaLink = "";
            String nextRequestUrl = "";
            String prevRequestUrl = "";
            List currentPage2 = null;
            do {
                try {
                    if (this.isBkpStopped(cloudId, batchId)) {
                        return;
                    }
                    oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
                    if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                        logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                        diffBlukrypt = true;
                        continue block21;
                    }
                    currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                    String path = fol.displayName;
                    if (!StringUtils.isEmpty((String)folderPathMap.get(fol.id))) {
                        path = folderPathMap.get(fol.id);
                    }
                    Map mailFilterMap = oneDriveBackupPolicy.getOutlookFilters();
                    HashSet<String> deletedMessageSet = new HashSet<String>();
                    HashSet messageSet = new HashSet();
                    for (Message message : currentPage2) {
                        boolean isFromAllowed = true;
                        boolean isToAllowed = true;
                        boolean isSubjectAllowed = true;
                        String fromVal = "";
                        String toVal = "";
                        String subject = "";
                        if (mailFilterMap != null && mailFilterMap.size() > 0) {
                            for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                                if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    fromVal = (String)filterEntry.getValue();
                                }
                                if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    toVal = (String)filterEntry.getValue();
                                }
                                if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                                subject = (String)filterEntry.getValue();
                            }
                            if (!StringUtils.isEmpty((String)fromVal)) {
                                isFromAllowed = this.fromFilterCheck(message, fromVal);
                            }
                            if (!StringUtils.isEmpty((String)toVal)) {
                                isToAllowed = this.toFilterCheck(message, toVal);
                            }
                            if (!StringUtils.isEmpty((String)subject)) {
                                String[] subjectArr = subject.split(",");
                                List<Object> subjList = new ArrayList();
                                subjList = Arrays.asList(subjectArr);
                                if (!CollectionUtils.isEmpty(subjList)) {
                                    for (String string : subjList) {
                                        if (StringUtils.isEmpty((String)message.subject) || !MSServiceImpl.isContainExactWord(message.subject.toLowerCase(), string.toLowerCase())) continue;
                                        isSubjectAllowed = false;
                                    }
                                }
                            }
                        }
                        boolean isMailAllowed = true;
                        if (!StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)subject) && !isFromAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject) && !isToAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && !isSubjectAllowed) {
                            isMailAllowed = false;
                        }
                        if (!(StringUtils.isEmpty((String)subject) || StringUtils.isEmpty((String)toVal) || StringUtils.isEmpty((String)fromVal))) {
                            isMailAllowed = isSubjectAllowed || isToAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal)) {
                            isMailAllowed = isSubjectAllowed || isToAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal)) {
                            isMailAllowed = isSubjectAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject)) {
                            logger.debug(message.subject + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                            isMailAllowed = isToAllowed || isFromAllowed;
                        }
                        if (!isMailAllowed) continue;
                        boolean isDeleted = false;
                        JsonElement jsonElement = (JsonElement)message.additionalDataManager().get((Object)"@removed");
                        if (jsonElement != null) {
                            isDeleted = true;
                        }
                        if (!isDeleted) continue;
                        deletedMessageSet.add(message.id);
                    }
                    logger.debug("....after iteraion..." + deletedMessageSet.size());
                    for (String msgId : deletedMessageSet) {
                        logger.debug("..deleted message list .... " + msgId);
                        BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, msgId, device.getDestCollection(), deviceUUID);
                        if (backUpImageold == null) continue;
                        logger.debug(backUpImageold.getSubject() + "..deleted message list1 .... " + msgId);
                        BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, device.getDestCollection());
                    }
                    if (iMessageDeltaCollectionPage.getNextPage() == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        continue block21;
                    }
                    messDeltaLink = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                    logger.debug(deletedfolderProcessed + "/" + deletedtotalFolderCount + "....before calling next page .....noofiles...." + deltaTokenval);
                    if (StringUtils.isEmpty((String)deltaTokenval)) {
                        logger.debug(".....NODELTA...." + messDeltaLink);
                        logger.debug(fol.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + deletedTotalCount);
                        continue block21;
                    }
                    try {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                    }
                    catch (ClientException ee) {
                        ee.printStackTrace();
                        boolean crawlCompleted = false;
                        do {
                            try {
                                logger.error(userPrincId + "...com.microsoft.graph.core.ClientException wait for 60 sec and retry byid so try for less mails 10 as option..." + ee.getMessage());
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (InterruptedException deletedBkpImage) {
                                    // empty catch block
                                }
                                if (StringUtils.isEmpty((String)messagesDelta)) {
                                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                                    crawlCompleted = true;
                                    continue;
                                }
                                String messageDeltaFinal = messagesDelta;
                                logger.debug("... old delta... ..." + messagesDelta);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                                crawlCompleted = true;
                            }
                            catch (GraphServiceException eee) {
                                logger.error("...graph exception retry..." + eee.getResponseCode());
                                crawlCompleted = false;
                            }
                            catch (ClientException eee) {
                                logger.error("...Client  exception retry..." + eee.getMessage());
                                crawlCompleted = false;
                            }
                        } while (!crawlCompleted);
                    }
                    logger.debug("....end of calling next page ...");
                    if (iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    }
                    if (!StringUtils.isEmpty((String)nextRequestUrl)) {
                        prevRequestUrl = nextRequestUrl;
                    }
                    ++j;
                    if (currentPage2.size() <= 0) {
                        if (messDeltaLink != null) continue block21;
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        continue block21;
                    }
                    isNextPageExistsv = true;
                    logger.debug("... " + fol.displayName + "...................$$CRAWLSTATUS$$............" + userName + "............ " + j + "..." + deletedTotalCount);
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 401) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException mailFilterMap) {
                            // empty catch block
                        }
                    }
                    logger.debug(e.getResponseCode() + "...token waited ..." + nextRequestUrl);
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        nextRequestUrl = prevRequestUrl;
                    }
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                    } else {
                        logger.debug("... old delta1... ..." + nextRequestUrl);
                        String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                    }
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (ClientException ee) {
                    ee.printStackTrace();
                    boolean isDeltaquerySucess = false;
                    do {
                        logger.debug(folderId + "....client exception eeeee wait for 5 sec... " + ee.getMessage());
                        logger.debug(nextRequestUrl + "....nextRequestUrl eeeee prevRequestUrl... " + prevRequestUrl);
                        logger.debug("....messDeltaLink... " + messDeltaLink);
                        try {
                            Thread.sleep(5000L);
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                nextRequestUrl = prevRequestUrl;
                            }
                            if (StringUtils.isEmpty((String)nextRequestUrl)) {
                                logger.debug("...no nextRequestUrl....");
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).select("id,from,toRecipients,body,subject").get());
                            } else {
                                logger.debug("... old delta1..new. ...");
                                String deltaTokenval = MSServiceImpl.getDeltaToken(nextRequestUrl);
                                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders(folderId).messages().delta().buildRequest(requestOptionsPagination).deltaToken(deltaTokenval).select("id,from,toRecipients,body,subject").get());
                            }
                            isDeltaquerySucess = true;
                        }
                        catch (Exception e) {
                            isDeltaquerySucess = false;
                        }
                    } while (!isDeltaquerySucess);
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (Exception eee) {
                    eee.printStackTrace();
                    logger.error("..broken.... " + eee.getMessage());
                    isNextPageExistsv = false;
                }
            } while (isNextPageExistsv);
        }
    }

    private int findEWSCalendar(String deviceUUID, String userName, int cloudId, boolean isFullBackup, int noOfFiles, String batchId, User userFound, String deviceDestCollection, String eventHubId) {
        String graphUserId = userFound.id;
        return this.crawlGraphCalendar(cloudId, graphUserId, userName, isFullBackup, noOfFiles, deviceUUID, batchId, eventHubId, deviceDestCollection);
    }

    private int crawlGraphCalendar(int cloudId, String userId, String userName, boolean isFullBackup, int noOfFiles, String deviceUUID, String batchId, String eventHubId, String deviceDestCollection) {
        String deltaToken = "";
        logger.debug(isFullBackup + "......calendar for...." + userName);
        if (!isFullBackup) {
            deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser("calendar", userName);
        }
        if (StringUtils.isEmpty((String)deltaToken)) {
            deltaToken = "";
        }
        logger.debug(deltaToken + "......calendar for1...." + userId);
        boolean isNextPageExists = false;
        try {
            EventDeltaCollectionRequestBuilder nextPage;
            OffsetDateTime startDateTime = OffsetDateTime.parse("1990-09-23T00:00:00Z");
            OffsetDateTime now = OffsetDateTime.now();
            OffsetDateTime endDateTime = now.withYear(now.getYear() + 15);
            EventDeltaCollectionPage deltaPage = null;
            do {
                boolean itemSaved;
                DriveFileInfo driveFileInfo;
                BackUpImage deletedBkpImage;
                BackUpImage backUpImageold;
                JsonElement value;
                String key;
                boolean eventDeleted;
                AdditionalDataManager additionalData;
                ArrayList<Object> requestOptions = new ArrayList<Object>();
                if (!StringUtils.isEmpty((String)deltaToken)) {
                    QueryOption queryOption = new QueryOption("$deltatoken", (Object)deltaToken);
                    requestOptions.add(queryOption);
                    requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=10"));
                    requestOptions.add(new QueryOption("startDateTime", (Object)startDateTime.toString()));
                    requestOptions.add(new QueryOption("endDateTime", (Object)endDateTime.toString()));
                    deltaPage = (EventDeltaCollectionPage)this.getGraphClient().users(userId).calendarView().delta().buildRequest(requestOptions).get();
                } else {
                    deltaPage = (EventDeltaCollectionPage)this.getGraphClient().users(userId).calendarView().delta().buildRequest(Arrays.asList(new QueryOption("startDateTime", (Object)startDateTime.toString()), new QueryOption("endDateTime", (Object)endDateTime.toString()), new HeaderOption("Prefer", "odata.maxpagesize=10"))).get();
                }
                for (Event event : deltaPage.getCurrentPage()) {
                    additionalData = event.additionalDataManager();
                    eventDeleted = false;
                    if (additionalData.containsKey((Object)"@removed")) {
                        logger.debug(".....event deleted...." + eventDeleted);
                        eventDeleted = true;
                    }
                    for (Map.Entry entry : additionalData.entrySet()) {
                        key = (String)entry.getKey();
                        value = (JsonElement)entry.getValue();
                        logger.debug("Key: " + key + ", Value: " + value.toString());
                        if (!key.equals("@removed") || !value.toString().contains("deleted")) continue;
                        eventDeleted = true;
                    }
                    if (eventDeleted) {
                        logger.debug("....deletedstatus....");
                        try {
                            backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, event.id, deviceDestCollection, deviceUUID);
                            if (backUpImageold == null) continue;
                            logger.debug("....handle deleted calendar case......" + event.id);
                            deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                        }
                        catch (Exception e) {
                            logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                        }
                        continue;
                    }
                    logger.debug(".....event deleted1...." + eventDeleted);
                    LocalDateTime localDateTime = LocalDateTime.parse(event.start.dateTime);
                    logger.debug(event.start.dateTime + "....datetime event....." + event.start.timeZone);
                    ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of(event.start.timeZone));
                    DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
                    DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMM");
                    DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd");
                    String year = zonedDateTime.format(yearFormatter);
                    String month = zonedDateTime.format(monthFormatter);
                    String day = zonedDateTime.format(dayFormatter);
                    OffsetDateTime offsetDateTime = event.createdDateTime;
                    if (offsetDateTime == null) continue;
                    driveFileInfo = new DriveFileInfo();
                    driveFileInfo.setDeviceUUID(deviceUUID);
                    driveFileInfo.setBackupBatchId(batchId);
                    driveFileInfo.setItemPath("Calendar/" + year + "/" + month + "/" + day);
                    driveFileInfo.setItemId(event.id);
                    driveFileInfo.setUserName(userName);
                    driveFileInfo.setCalendar(true);
                    driveFileInfo.setOperation("FILE");
                    driveFileInfo.setGraphUserId(userId);
                    itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
                    if (!itemSaved) continue;
                    ++noOfFiles;
                }
                while (deltaPage.getNextPage() != null) {
                    deltaPage = (EventDeltaCollectionPage)((EventDeltaCollectionRequest)((EventDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
                    for (Event event : deltaPage.getCurrentPage()) {
                        additionalData = event.additionalDataManager();
                        eventDeleted = false;
                        if (additionalData.containsKey((Object)"@removed")) {
                            logger.debug(".....event deleted...." + eventDeleted);
                            eventDeleted = true;
                        }
                        for (Map.Entry entry : additionalData.entrySet()) {
                            key = (String)entry.getKey();
                            value = (JsonElement)entry.getValue();
                            logger.debug("Key: " + key + ", Value: " + value.toString());
                            if (!key.equals("@removed") || !value.toString().contains("deleted")) continue;
                            eventDeleted = true;
                        }
                        logger.debug(".....event deleted...." + eventDeleted);
                        if (eventDeleted) {
                            logger.debug("....deletedstatus....");
                            try {
                                backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, event.id, deviceDestCollection, deviceUUID);
                                if (backUpImageold == null) continue;
                                logger.debug("....handle deleted calendar case......" + event.id);
                                deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                            }
                            catch (Exception e) {
                                logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                            }
                            continue;
                        }
                        OffsetDateTime offsetDateTime = event.createdDateTime;
                        if (offsetDateTime == null) continue;
                        LocalDateTime localDateTime = LocalDateTime.parse(event.start.dateTime);
                        logger.debug(event.start.dateTime + "....datetime event....." + event.start.timeZone);
                        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of(event.start.timeZone));
                        DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("yyyy");
                        DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMM");
                        DateTimeFormatter dayFormatter = DateTimeFormatter.ofPattern("dd");
                        String year = zonedDateTime.format(yearFormatter);
                        String month = zonedDateTime.format(monthFormatter);
                        String day = zonedDateTime.format(dayFormatter);
                        driveFileInfo = new DriveFileInfo();
                        driveFileInfo.setDeviceUUID(deviceUUID);
                        driveFileInfo.setBackupBatchId(batchId);
                        driveFileInfo.setItemPath("Calendar/" + year + "/" + month + "/" + day);
                        driveFileInfo.setItemId(event.id);
                        driveFileInfo.setUserName(userName);
                        driveFileInfo.setCalendar(true);
                        driveFileInfo.setOperation("FILE");
                        driveFileInfo.setGraphUserId(userId);
                        itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
                        if (!itemSaved) continue;
                        ++noOfFiles;
                    }
                }
                String nextDeltaLink = deltaPage.getNextPage() != null ? ((EventDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl() : "";
                deltaToken = deltaPage.deltaLink;
                deltaToken = MSServiceImpl.getDeltaToken(deltaToken);
                logger.debug(deltaToken + ".calendar...Next Delta Link: " + nextDeltaLink);
                logger.debug("..calendar..getdeltatoken...." + deltaToken);
                nextPage = (EventDeltaCollectionRequestBuilder)deltaPage.getNextPage();
                this.msUtilDao.updateDeltaForPathAndUser("calendar", userName, deltaToken);
            } while (nextPage != null && deltaToken != null && (isNextPageExists = true));
        }
        catch (GraphServiceException e) {
            e.printStackTrace();
            logger.error("Error occurred: " + e.getMessage());
        }
        logger.debug("...total calendar... " + noOfFiles);
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        return noOfFiles;
    }

    private boolean toFilterCheck(Message message, String toVal) {
        boolean isToAllowed = true;
        List<Object> toList = new ArrayList();
        List toRecipients = message.toRecipients;
        if (!CollectionUtils.isEmpty((Collection)toRecipients)) {
            String[] torecArr = toVal.split(",");
            if (torecArr != null) {
                toList = Arrays.asList(torecArr);
            }
            for (Recipient torec : toRecipients) {
                if (CollectionUtils.isEmpty(toList)) continue;
                for (String string : toList) {
                    String string2 = string.replace("*", "");
                    try {
                        if (!torec.emailAddress.address.contains(string2)) continue;
                        isToAllowed = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isToAllowed;
    }

    private boolean fromFilterCheck(Message message, String fromVal) {
        boolean isFromAllowed = true;
        String[] fromValArr = fromVal.split(",");
        List<Object> fromList = new ArrayList();
        if (fromValArr != null && !CollectionUtils.isEmpty(fromList = Arrays.asList(fromValArr))) {
            for (String string : fromList) {
                String string2 = string.replace("*", "");
                try {
                    if (!message.from.emailAddress.address.contains(string2)) continue;
                    isFromAllowed = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return isFromAllowed;
    }

    private String handleModifiedMailItems(String deviceUUID, String userName, String emailId, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String deviceDestCollection, String deltaToken, String eventHubId, long batchStartTime, Cloud cloud) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        int folder = 0;
        int noOfFiles = 0;
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String orgPolicyName = oneDriveBackupPolicy.getPolicyName();
        String batchId = "";
        if (backupBatch != null) {
            batchId = backupBatch.getId().toString();
        }
        BackupBatch batch = null;
        if (!StringUtils.isEmpty((String)batchId)) {
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, deviceUUID);
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
            ODBBackupBatch odbBackupBatch = new ODBBackupBatch();
            BeanUtils.copyProperties((Object)batch, (Object)odbBackupBatch);
            odbBackupBatch.setId(new ObjectId(batchId));
            backupBatch = this.msUtilDao.deleteAndCreateBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), odbBackupBatch);
        }
        backupBatch.setStatus("STARTED");
        BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batchId);
        if (backupAttempt != null && backupAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.name())) {
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            if (!PCHelperConstant.BACKUP_STATUS.SCANNING.toString().equalsIgnoreCase(backupAttempt.getStatus())) {
                this.addScanningAttempt(cloudId, batchId, backupBatch);
            }
            backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        if (backupAttempt == null) {
            backupAttempt = new BackupAttempt();
            BeanUtils.copyProperties((Object)backupBatch, (Object)backupAttempt);
            backupAttempt.setBatchId(backupBatch.getId().toString());
            backupAttempt.setId(null);
            backupAttempt.setErrorCode("0");
            backupAttempt.setBatchStartTimestamp(batch.getBatchStartTimestamp());
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(batch.getStatus());
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.addScanningAttempt(cloudId, batchId, backupBatch);
        }
        batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        ArrayList folders = new ArrayList();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBackupOverViewForDevice(cloudId, deviceUUID);
        boolean isNewDevice = false;
        if (deviceBackupOverView != null && StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime())) {
            isNewDevice = true;
        }
        int i = 0;
        logger.debug(userName + "......folders.... " + folders.size());
        i = 0;
        String userPrincId = this.getAzureUserId(emailId);
        if (StringUtils.isEmpty((String)userPrincId)) {
            logger.error(".... user not found ..." + userName);
            return "";
        }
        MailFolderCollectionRequestBuilder mailFolders = (MailFolderCollectionRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId).mailFolders());
        logger.debug(".. mail folders..." + userName);
        String deltaLink = "";
        MailFolderDeltaCollectionPage deltaPage = null;
        if (isFullBackup) {
            deltaToken = "";
        }
        deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
        boolean isNextPageExists = false;
        List mailcurrentPage = null;
        ArrayList listFolderItems = new ArrayList();
        ArrayList<Folder> archivelistFolderItems = new ArrayList<Folder>();
        do {
            mailcurrentPage = deltaPage.getCurrentPage();
            listFolderItems.addAll(mailcurrentPage);
            deltaLink = deltaPage.deltaLink();
            if (deltaLink == null) {
                deltaLink = ((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(SERVICE_ROOT, "");
            }
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            if (deltaPage.getNextPage() == null) break;
            deltaPage = (MailFolderDeltaCollectionPage)((MailFolderDeltaCollectionRequest)((MailFolderDeltaCollectionRequestBuilder)deltaPage.getNextPage()).buildRequest(new Option[0])).get();
            ++i;
        } while (mailcurrentPage.size() > 0 && (isNextPageExists = true));
        logger.debug(deltaToken + "...total folders.. " + listFolderItems.size());
        logger.debug(userName + "...userNameval....inplacearchive flag.... " + oneDriveBackupPolicy.isInPlaceMailArchiveEnabled());
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            noOfFiles = this.handleEWSInPlaceMailArchive(userName, emailId, cloudId, archivelistFolderItems, noOfFiles, deviceUUID, batchId, userPrincId, eventHubId, deviceDestCollection, oneDriveBackupPolicy, isFullBackup, cloud);
        }
        if (this.isBkpStopped(cloudId, batchId)) {
            return "";
        }
        ArrayList sublistItems = new ArrayList();
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        String rootId = this.getRootFolderId(userPrincId);
        listFolderItems.forEach(fol -> {
            MailFolder folderval = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> ((MailFolderRequestBuilder)this.getGraphClient().users(userPrincId).mailFolders().byId(fol.parentFolderId)).buildRequest(new Option[0]).get());
            if (folderval.id.equalsIgnoreCase(rootId)) {
                folderPathMap.put(fol.id, fol.displayName);
            }
            if (fol.childFolderCount > 0) {
                this.addChildFolders(userPrincId, sublistItems, (Map<String, String>)folderPathMap, (MailFolder)fol);
            }
        });
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder mailFolder = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get());
            folderPathMap.put(mailFolder.id, "Recoverable Items");
            mailFolder = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId).mailFolders("RecoverableItemsPurges").buildRequest(new Option[0]).get());
            folderPathMap.put(mailFolder.id, "Purged Items");
        }
        deltaToken = "";
        Map<String, String> inplaceFolderPathMap = new HashMap<String, String>();
        if (oneDriveBackupPolicy.isInPlaceMailArchiveEnabled()) {
            String token = this.getEWSToken(cloudId);
            ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
            inplaceFolderPathMap = MSServiceImpl.getInPlaceArchiveFolders(service, emailId);
        }
        this.removeDeletedFolderFiles(cloudId, userName, deviceUUID, folderPathMap, deviceDestCollection, userPrincId, inplaceFolderPathMap);
        HashMap deltaMap = new HashMap();
        boolean allTokenDeleted = true;
        for (Map.Entry entry : folderPathMap.entrySet()) {
            logger.debug(isFullBackup + "..." + (String)entry.getValue() + "...all delta paths....." + (String)entry.getValue());
            if (!isFullBackup) {
                deltaToken = this.msUtilDao.getDeltaLinkForPathAndUser((String)entry.getValue(), userName);
            }
            logger.debug("...all paths....." + (String)entry.getValue() + "...." + deltaToken);
            deltaMap.put(entry.getValue(), deltaToken);
            if (StringUtils.isEmpty((String)deltaToken)) continue;
            allTokenDeleted = false;
        }
        if (allTokenDeleted) {
            isFullBackup = true;
            this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        int totalCount = 0;
        boolean diffBlukrypt = false;
        if (!batch.isFullBackup()) {
            // empty if block
        }
        block14: for (Map.Entry entry : folderPathMap.entrySet()) {
            Object parentPath;
            oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                diffBlukrypt = true;
                continue;
            }
            if (this.isBkpStopped(cloudId, batchId)) continue;
            logger.debug((String)entry.getValue() + "..allowedpaths check.. ");
            MailFolder fol2 = ((MailFolderRequestBuilder)mailFolders.byId((String)entry.getKey())).buildRequest(new Option[0]).get();
            Object actualPath = parentPath = (String)entry.getValue();
            if (((String)entry.getValue()).contains("/")) {
                String[] parentPatharr = ((String)entry.getValue()).split("/");
                parentPath = parentPatharr[0];
            }
            boolean isFileAllowed = this.handleMailElement((String)actualPath, (String)parentPath, oneDriveBackupPolicy, deviceUUID, userName, cloudId, false, cloud);
            logger.debug((String)entry.getValue() + "..." + isFileAllowed);
            if (!isFileAllowed) {
                logger.debug("...path cannot be allowed... " + fol2.displayName);
                continue;
            }
            folderMap.put(fol2.displayName, fol2.id);
            logger.debug(fol2.displayName + "..allowedpaths.. " + fol2.totalItemCount);
            totalCount += fol2.totalItemCount.intValue();
            logger.debug(".. fol id .. " + (String)entry.getKey());
            MailFolderRequestBuilder byId = null;
            String messagesDelta = "";
            MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
            if (deltaMap.get(entry.getValue()) != null) {
                messagesDelta = (String)deltaMap.get(entry.getValue());
                if (!StringUtils.isEmpty((String)messagesDelta) && messagesDelta.startsWith(SERVICE_ROOT)) {
                    String serviceRoot = " https://graph.microsoft.com";
                    messagesDelta = messagesDelta.replaceFirst(serviceRoot, "");
                }
                messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
            }
            LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
            requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
            try {
                byId = (MailFolderRequestBuilder)mailFolders.byId((String)entry.getKey());
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).select("id,from,toRecipients,body,subject").get());
                } else {
                    byId = null;
                    logger.debug(fol2.displayName + "... old delta... ..." + messagesDelta);
                    String messageDeltaFinal = messagesDelta;
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                }
            }
            catch (GraphServiceException ee) {
                if (ee.getResponseCode() == 401) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (StringUtils.isEmpty((String)messagesDelta)) {
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).select("id,from,toRecipients,body,subject").get());
                    } else {
                        byId = null;
                        logger.debug(fol2.displayName + "... old delta... ..." + messagesDelta);
                        String messageDeltaFinal = messagesDelta;
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                    }
                }
                logger.error("...response code ..." + ee.getResponseCode());
            }
            catch (ClientException ee) {
                logger.error(byId + "...com.microsoft.graph.core.ClientException wait for 20 sec and retry byid ..." + ee.getMessage());
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException messageDeltaFinal) {
                    // empty catch block
                }
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).select("id,from,toRecipients,body,subject").get());
                }
                byId = null;
                logger.debug(fol2.displayName + "... old delta... ..." + messagesDelta);
                String messageDeltaFinal = messagesDelta;
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)this.getGraphClient().users(userPrincId).mailFolders((String)entry.getKey()).messages().delta().buildRequest((List)requestOptions).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
            }
            Map mailFilterMap = oneDriveBackupPolicy.getOutlookFilters();
            boolean isNextPageExistsv = false;
            int j = 0;
            String messDeltaLink = "";
            String nextRequestUrl = "";
            List currentPage2 = null;
            do {
                try {
                    if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt())) {
                        logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                        diffBlukrypt = true;
                        isNextPageExistsv = false;
                        continue block14;
                    }
                    if (this.isBkpStopped(cloudId, batchId)) continue block14;
                    currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                    if (currentPage2 != null) {
                        logger.debug("....files for current page ..." + currentPage2.size());
                    } else {
                        logger.debug("....files for current page ..nuull...");
                    }
                    String path2 = fol2.displayName;
                    if (!StringUtils.isEmpty((String)((String)folderPathMap.get(fol2.id)))) {
                        path2 = (String)folderPathMap.get(fol2.id);
                    }
                    HashSet<String> messageSet = new HashSet<String>();
                    HashSet<String> deletedMessageSet = new HashSet<String>();
                    for (Message message : currentPage2) {
                        boolean isFromAllowed = true;
                        boolean isToAllowed = true;
                        boolean isSubjectAllowed = true;
                        logger.debug(message.subject + "......message from.21.....");
                        String fromVal = "";
                        String toVal = "";
                        String subject = "";
                        if (mailFilterMap != null && mailFilterMap.size() > 0) {
                            for (Map.Entry filterEntry : mailFilterMap.entrySet()) {
                                if ("from".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    fromVal = (String)filterEntry.getValue();
                                }
                                if ("to".equalsIgnoreCase((String)filterEntry.getKey())) {
                                    toVal = (String)filterEntry.getValue();
                                }
                                if (!"subject".equalsIgnoreCase((String)filterEntry.getKey())) continue;
                                subject = (String)filterEntry.getValue();
                            }
                            logger.debug(fromVal + "......mailfilter..latest........." + toVal + "...." + subject);
                            if (!StringUtils.isEmpty((String)fromVal)) {
                                isFromAllowed = this.fromFilterCheck(message, fromVal);
                            }
                            if (!StringUtils.isEmpty((String)toVal)) {
                                isToAllowed = this.toFilterCheck(message, toVal);
                            }
                            if (!StringUtils.isEmpty((String)subject)) {
                                String[] subjectArr = subject.split(",");
                                List<Object> subjList = new ArrayList();
                                subjList = Arrays.asList(subjectArr);
                                if (!CollectionUtils.isEmpty(subjList)) {
                                    for (String string : subjList) {
                                        logger.debug(message.subject + "....sub..." + string);
                                        if (StringUtils.isEmpty((String)message.subject) || !MSServiceImpl.isContainExactWord(message.subject.toLowerCase(), string.toLowerCase())) continue;
                                        isSubjectAllowed = false;
                                    }
                                }
                            }
                        }
                        boolean isMailAllowed = true;
                        if (!StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)subject) && !isFromAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject) && !isToAllowed) {
                            isMailAllowed = false;
                        }
                        if (!StringUtils.isEmpty((String)subject) && StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal) && !isSubjectAllowed) {
                            isMailAllowed = false;
                        }
                        if (!(StringUtils.isEmpty((String)subject) || StringUtils.isEmpty((String)toVal) || StringUtils.isEmpty((String)fromVal))) {
                            isMailAllowed = isSubjectAllowed || isToAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)toVal) && StringUtils.isEmpty((String)fromVal)) {
                            isMailAllowed = isSubjectAllowed || isToAllowed;
                        }
                        if (!StringUtils.isEmpty((String)subject) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)toVal)) {
                            isMailAllowed = isSubjectAllowed || isFromAllowed;
                        }
                        if (!StringUtils.isEmpty((String)toVal) && !StringUtils.isEmpty((String)fromVal) && StringUtils.isEmpty((String)subject)) {
                            logger.debug(message.subject + "...fromto condition...." + isToAllowed + ".." + isFromAllowed);
                            isMailAllowed = isToAllowed || isFromAllowed;
                        }
                        if (!isMailAllowed) {
                            logger.debug(isFromAllowed + ".." + isToAllowed + ".." + isSubjectAllowed + "...subject.." + message.subject);
                            continue;
                        }
                        boolean mailAllow = true;
                        if (!isFullBackup) {
                            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, message.id, deviceDestCollection, deviceUUID);
                            mailAllow = backUpImageold != null ? oneDriveBackupPolicy.isCreateMailLinkEnabled() && !backUpImageold.isMailLinkGenerated() : true;
                        }
                        boolean isDeleted = false;
                        JsonElement jsonElement = (JsonElement)message.additionalDataManager().get((Object)"@removed");
                        if (jsonElement != null) {
                            isDeleted = true;
                        }
                        if (!mailAllow && !isDeleted) continue;
                        if (isDeleted) {
                            deletedMessageSet.add(message.id);
                            continue;
                        }
                        messageSet.add(message.id);
                    }
                    int currentFiles = this.processMessageList(messageSet, deletedMessageSet, deviceUUID, userName, cloudId, oneDriveBackupPolicy, isFullBackup, batchId, folderMap, i, path2, userPrincId, deviceDestCollection, eventHubId, isNewDevice);
                    noOfFiles += currentFiles;
                    messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                    if (iMessageDeltaCollectionPage != null && iMessageDeltaCollectionPage.getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl());
                    }
                    if (iMessageDeltaCollectionPage.getNextPage() == null) {
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block14;
                    }
                    if ((iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get()).getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                        nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                    }
                    ++j;
                    if (currentPage2.size() <= 0) {
                        if (messDeltaLink == null) {
                            messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                        }
                        this.msUtilDao.updateDeltaForPathAndUser((String)entry.getValue(), userName, messDeltaLink);
                        continue block14;
                    }
                    isNextPageExistsv = true;
                    logger.debug(fol2.displayName + ".... " + j + "..." + noOfFiles + "/" + totalCount);
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 401) {
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException messageSet) {
                            // empty catch block
                        }
                    }
                    logger.debug("...token waited ..." + nextRequestUrl);
                    byId = this.getMailFolders(cloudId, userName, (String)entry.getKey());
                    if (StringUtils.isEmpty((String)nextRequestUrl)) {
                        MailFolderRequestBuilder byIdFinal = byId;
                        iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)byIdFinal.messages().delta().buildRequest((List)requestOptions).select("id,from,toRecipients,body,subject").get());
                    } else {
                        byId = null;
                        logger.debug("... old delta1... ..." + messDeltaLink);
                    }
                    logger.debug("...token waited11 ..." + nextRequestUrl);
                }
                catch (Exception eee) {
                    logger.error("..broken.... " + eee.getMessage());
                }
            } while (isNextPageExistsv);
        }
        if (cloud.getMailRecoverableItemsEnabled() == 1) {
            MailFolder delfolder = (MailFolder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId).mailFolders("recoverableitemsdeletions").buildRequest(new Option[0]).get());
            this.handleDeletedMails(deviceUUID, userName, emailId, cloudId, deviceDestCollection, mailFolders, delfolder);
        }
        User userFound = null;
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(requestOptions)).top(1).get());
        for (User userObj : iUserCollectionPage.getCurrentPage()) {
            logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
            if (!emailId.equalsIgnoreCase(userObj.mail) || !emailId.equalsIgnoreCase(userObj.userPrincipalName)) continue;
            userFound = userObj;
            break;
        }
        if (userFound == null) {
            for (User user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        if (userFound == null) {
            logger.error(".... user not found ..." + userName);
            return "";
        }
        logger.debug(".....is contacts enabled in office policy .... " + oneDriveBackupPolicy.isContactsEnabled());
        if (oneDriveBackupPolicy.isContactsEnabled()) {
            noOfFiles = this.findContacts(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
        }
        logger.debug(".....is tasks enabled in office policy .... " + oneDriveBackupPolicy.isTasksEnabled());
        if (oneDriveBackupPolicy.isTasksEnabled()) {
            noOfFiles = this.findTasks(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
        }
        if (oneDriveBackupPolicy.isCalendarEnabled()) {
            logger.debug("...start of calendars....");
            noOfFiles = this.findEWSCalendar(deviceUUID, userName, cloudId, isFullBackup, noOfFiles, batchId, userFound, deviceDestCollection, eventHubId);
            logger.debug("...end of calendars....");
        }
        folderMap.forEach((path, itemId) -> {
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(deviceUUID);
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        if (this.isBkpStopped(cloudId, batchId)) {
            return "";
        }
        if (diffBlukrypt) {
            logger.debug("....diff blukrypt...." + eventHubId);
            oneDriveBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, oneDriveBackupPolicy.getPolicyType());
            logger.debug(oneDriveBackupPolicy.getMsAppBluKrypt() + "....diff blukrypt...." + eventHubId);
            this.msUtilDao.saveBatch(cloudId, batchId, orgPolicyName, oneDriveBackupPolicy.getPolicyName(), eventHubId, oneDriveBackupPolicy.getMsAppBluKrypt());
        } else {
            backupBatch.setId(new ObjectId(batchId));
            backupBatch.setStatus("COMPLETED");
            backupBatch.setBatchStartTimestamp(batchStartTime);
            long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
            long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
            backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
            batch.setNoOfFiles(0L);
            batch.setTotalNoOfFiles("" + totalFilesCount);
            backupBatch.setTotalNoOfFiles("" + totalFilesCount);
            batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
            this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
            this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
            this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
        }
        logger.debug(folder + ".....folder + file......." + noOfFiles);
        logger.debug(".....nooffiles....." + noOfFiles);
        return deltaToken;
    }

    private Set<String> getDeletedFolderList(String userName, Map<String, String> folderPathMap) {
        HashSet<String> delFolderMap = new HashSet<String>();
        List list = this.msUtilDao.getAllDeltaLinkUser(userName);
        HashSet<String> newFolderMap = new HashSet<String>();
        for (Map.Entry<String, String> entry : folderPathMap.entrySet()) {
            newFolderMap.add(entry.getKey());
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (DeltaPath deltaPath : list) {
                if (newFolderMap.contains(deltaPath.getPath())) continue;
                delFolderMap.add(deltaPath.getPath());
            }
        }
        return delFolderMap;
    }

    private int findContacts(String deviceUUID, String userName, int cloudId, boolean isFullBackup, int noOfFiles, String batchId, User userFound, String deviceDestCollection, String eventHubId) {
        List<String> contactsList = this.crawlGraphContacts(cloudId, userFound.id, userName, isFullBackup, deviceDestCollection, deviceUUID);
        for (String contact : contactsList) {
            logger.debug("... contact details ... " + contact);
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setItemPath("Contacts");
            driveFileInfo.setItemId(contact);
            driveFileInfo.setUserName(userName);
            driveFileInfo.setContact(true);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setGraphUserId(userFound.id);
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        return noOfFiles;
    }

    private int findTasks(String deviceUUID, String userName, int cloudId, boolean isFullBackup, int noOfFiles, String batchId, User userFound, String deviceDestCollection, String eventHubId) {
        List<String> tasksList = this.crawlGraphTasks(cloudId, userFound.id, userName, isFullBackup, deviceDestCollection, deviceUUID);
        ArrayList existingIds = new ArrayList();
        HashSet existingIdsSet = new HashSet();
        for (String contact : tasksList) {
            logger.debug("... task details1 ... " + contact);
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setItemPath("Tasks");
            driveFileInfo.setItemId(contact);
            driveFileInfo.setUserName(userName);
            driveFileInfo.setTasks(true);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setGraphUserId(userFound.id);
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        logger.debug(existingIdsSet.size() + "..sss.." + existingIds.size() + "....existingids....");
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        return noOfFiles;
    }

    private void handleDeletedMails(String deviceUUID, String userName, String emailId, int cloudId, String deviceDestCollection, MailFolderCollectionRequestBuilder mailFolders, MailFolder fol) {
        logger.debug("...handle deleted mails...");
        logger.debug(fol.displayName + "..allowedpaths.. " + fol.totalItemCount);
        MailFolderRequestBuilder byId = null;
        String messagesDelta = this.msUtilDao.getDeltaLinkForPathAndUser(fol.displayName, userName);
        messagesDelta = MSServiceImpl.getDeltaToken(messagesDelta);
        MessageDeltaCollectionPage iMessageDeltaCollectionPage = null;
        LinkedList<HeaderOption> requestOptions = new LinkedList<HeaderOption>();
        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=20"));
        try {
            byId = (MailFolderRequestBuilder)mailFolders.byId(fol.id);
            if (StringUtils.isEmpty((String)messagesDelta)) {
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
            } else {
                logger.debug(fol.displayName + "... old delta... ..." + messagesDelta);
                iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
            }
        }
        catch (GraphServiceException ee) {
            if (ee.getResponseCode() == 401) {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (StringUtils.isEmpty((String)messagesDelta)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get();
                } else {
                    logger.debug("... old delta... ..." + messagesDelta);
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)byId.messages().delta().buildRequest(requestOptions).deltaToken(messagesDelta).select("id,from,toRecipients,body,subject").get();
                }
            }
            logger.error("...response code ..." + ee.getResponseCode());
        }
        boolean isNextPageExistsv = false;
        int j = 0;
        String messDeltaLink = "";
        String nextRequestUrl = "";
        List currentPage2 = null;
        do {
            if (iMessageDeltaCollectionPage == null) continue;
            try {
                currentPage2 = iMessageDeltaCollectionPage.getCurrentPage();
                if (currentPage2 != null) {
                    logger.debug("....files for current page delete ..." + currentPage2.size());
                } else {
                    logger.debug("....files for current page ..nuull...");
                }
                for (Message deletedMessage : currentPage2) {
                    try {
                        logger.debug(".....delete file...." + deletedMessage.id);
                        BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedMessage.id, deviceDestCollection, deviceUUID);
                        if (backUpImageold == null) continue;
                        BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                    }
                    catch (Exception e) {
                        logger.error(".... unable to delete..... " + e.getMessage());
                    }
                }
                messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                if (iMessageDeltaCollectionPage.getNextPage() == null) {
                    this.msUtilDao.updateDeltaForPathAndUser(fol.displayName, userName, messDeltaLink);
                    break;
                }
                if ((iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).buildRequest(requestOptions).select("id,from,toRecipients,body,subject").get()).getNextPage() != null && !StringUtils.isEmpty((String)((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl())) {
                    nextRequestUrl = ((MessageDeltaCollectionRequestBuilder)iMessageDeltaCollectionPage.getNextPage()).getRequestUrl();
                }
                ++j;
                if (currentPage2.size() <= 0) {
                    if (messDeltaLink == null) {
                        messDeltaLink = iMessageDeltaCollectionPage.deltaLink();
                    }
                    this.msUtilDao.updateDeltaForPathAndUser(fol.displayName, userName, messDeltaLink);
                    break;
                }
                isNextPageExistsv = true;
            }
            catch (GraphServiceException e) {
                if (e.getResponseCode() == 401) {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException deletedMessage) {
                        // empty catch block
                    }
                }
                logger.debug("...token waited ..." + nextRequestUrl);
                MailFolderRequestBuilder byIdFinal = byId = this.getMailFolders(cloudId, userName, fol.id);
                if (StringUtils.isEmpty((String)nextRequestUrl)) {
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)byIdFinal.messages().delta().buildRequest((List)requestOptions).select("id,from,toRecipients,body,subject").get());
                } else {
                    logger.debug("... old delta1... ..." + messDeltaLink);
                    String messageDeltaFinal = messagesDelta;
                    iMessageDeltaCollectionPage = (MessageDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (MessageDeltaCollectionPage)byIdFinal.messages().delta().buildRequest((List)requestOptions).deltaToken(messageDeltaFinal).select("id,from,toRecipients,body,subject").get());
                }
                logger.debug("...token waited11 ..." + nextRequestUrl);
            }
            catch (Exception eee) {
                eee.printStackTrace();
                logger.error("..broken.... " + eee.getMessage());
            }
        } while (isNextPageExistsv);
    }

    private int processMessageList(Set<String> messageSet, Set<String> deletedMessageSet, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, boolean isFullBackup, String batchId, Map<String, String> folderMap, int i, String mailPath, String graphUserId, String deviceDestCollection, String eventHubId, boolean isNewDevice) {
        ArrayList driveList = new ArrayList();
        int noOfFiles = 0;
        for (String msgId : deletedMessageSet) {
            logger.debug("..deleted message list .... " + msgId);
            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, msgId, deviceDestCollection, deviceUUID);
            if (backUpImageold == null || isFullBackup) continue;
            logger.debug(backUpImageold.getSubject() + "..deleted message list1 .... " + msgId);
            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
        }
        for (String msgId : messageSet) {
            ++i;
            String basePath = "";
            boolean isPresent = true;
            BackUpImage backUpImageold = null;
            if (isNewDevice) {
                backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, msgId, deviceDestCollection, deviceUUID);
            }
            if (backUpImageold != null && !isFullBackup) {
                logger.debug(backUpImageold.getSubject() + "..deleted message list2 .... " + msgId);
                BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                continue;
            }
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            String folderPath = BASE_FOLDER + basePath;
            driveFileInfo.setItemPath(mailPath);
            driveFileInfo.setItemId(msgId);
            driveFileInfo.setFolder(false);
            driveFileInfo.setFilePresent(isPresent);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setMail(true);
            driveFileInfo.setFullBackup(isFullBackup);
            driveFileInfo.setGraphUserId(graphUserId);
            String folderItemId = "";
            if (folderMap.get(folderPath) != null) {
                folderItemId = folderMap.get(folderPath);
            }
            driveFileInfo.setParentItemId(folderItemId);
            driveFileInfo.setUserName(userName);
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        logger.debug(noOfFiles + ".... before bulk save ...." + driveList.size());
        this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
        logger.debug(".... after bulk save ....");
        return noOfFiles;
    }

    private String handleModifiedPolicyItems(List<DriveItem> newItems, List<DriveItem> deletedItems, String deviceUUID, String userName, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, String deviceDestCollection, String eventHubId, long batchStartTime, boolean isFullBackup, boolean emptyToken) {
        int file = 0;
        int folder = 0;
        int noOfFiles = 0;
        int totalSizeToUpload = 0;
        int cloudId = cloud.getCloudId();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
        String batchId = "";
        if (backupBatch != null) {
            batchId = backupBatch.getId().toString();
        }
        BackupBatch batch = null;
        if (!StringUtils.isEmpty((String)batchId)) {
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        if (batch == null) {
            logger.debug("....user1...." + userName);
            batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, deviceUUID);
            batchId = batch.getId().toString();
            logger.debug(batchId + "....user2...." + userName + "...." + batch.getStatus());
            logger.debug(batchId + "....user2 delete batch...." + userName + "...." + batch.getStatus());
            ODBBackupBatch odbBackupBatch = new ODBBackupBatch();
            BeanUtils.copyProperties((Object)batch, (Object)odbBackupBatch);
            odbBackupBatch.setId(new ObjectId(batchId));
            backupBatch = this.msUtilDao.deleteAndCreateBatch(deviceUUID, oneDriveBackupPolicy.getPolicyName(), odbBackupBatch);
        }
        backupBatch.setStatus("STARTED");
        BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batchId);
        if (emptyToken) {
            this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
            batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        }
        if (backupAttempt != null && backupAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.name())) {
            backupAttempt.setBatchId(batchId);
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), oneDriveBackupPolicy.getPolicyName());
            device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            if (!PCHelperConstant.BACKUP_STATUS.SCANNING.toString().equalsIgnoreCase(backupAttempt.getStatus())) {
                this.addScanningAttempt(cloudId, batchId, backupBatch);
            }
            backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            batch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        }
        if (backupAttempt == null) {
            backupAttempt = new BackupAttempt();
            BeanUtils.copyProperties((Object)backupBatch, (Object)backupAttempt);
            backupAttempt.setBatchId(backupBatch.getId().toString());
            backupAttempt.setId(null);
            backupAttempt.setErrorCode("0");
            backupAttempt.setBatchStartTimestamp(batch.getBatchStartTimestamp());
            backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
            backupAttempt.setStatus(batch.getStatus());
            this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
            this.addScanningAttempt(cloudId, batchId, backupBatch);
        }
        batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        if (this.isBkpStopped(cloudId, batchId)) {
            return "";
        }
        for (DriveItem deletedItem : deletedItems) {
            try {
                BackUpImage latestBkpImage;
                BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedItem.id, deviceDestCollection, deviceUUID);
                if (backUpImageold == null || (latestBkpImage = this.msUtilDao.getDeletedBkpImageforPathandFile(cloudId, deviceUUID, backUpImageold.getDevicePath(), backUpImageold.getFileName(), deviceDestCollection)) != null) continue;
                BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
            }
            catch (Exception e) {
                logger.error(".... unable to delete..... " + e.getMessage());
            }
        }
        for (DriveItem driveItem : newItems) {
            String parentPath;
            logger.debug("...ssitems.val.. " + driveItem);
            boolean isFolder = false;
            if (driveItem.folder != null) {
                isFolder = true;
            }
            String basePath = "";
            boolean isPresent = true;
            String itemName = driveItem.name;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
                ++folder;
            } else if (driveItem.file != null) {
                ++file;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            DriveFileInfo driveFileInfo = new DriveFileInfo();
            driveFileInfo.setDeviceUUID(deviceUUID);
            driveFileInfo.setItemPath(BASE_FOLDER + basePath);
            driveFileInfo.setItemName(itemName);
            driveFileInfo.setItemId(driveItem.id);
            driveFileInfo.setFolder(isFolder);
            driveFileInfo.setFilePresent(isPresent);
            driveFileInfo.setOperation("FILE");
            driveFileInfo.setBackupBatchId(batchId);
            driveFileInfo.setFullBackup(false);
            if (driveItem.lastModifiedDateTime != null) {
                driveFileInfo.setO365LastModifiedTime(driveItem.lastModifiedDateTime.toInstant().toEpochMilli());
            } else {
                driveFileInfo.setO365LastModifiedTime(driveItem.createdDateTime.toInstant().toEpochMilli());
            }
            logger.debug(itemName + ".....filetime..." + driveFileInfo.getO365LastModifiedTime());
            if (driveItem.parentReference != null) {
                driveFileInfo.setParentItemId(driveItem.parentReference.id);
            }
            driveFileInfo.setUserName(userName);
            driveFileInfo.setSize(driveItem.size);
            totalSizeToUpload += driveItem.size.intValue();
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        backupBatch.setId(new ObjectId(batchId));
        backupBatch.setStatus("COMPLETED");
        backupBatch.setNoOfFiles((long)noOfFiles);
        backupBatch.setTotalSizeToUpload((long)totalSizeToUpload);
        long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
        long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
        backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
        batch.setNoOfFiles(0L);
        batch.setTotalNoOfFiles("" + totalFilesCount);
        backupBatch.setTotalNoOfFiles("" + totalFilesCount);
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
        this.updateInterruptedStatusForPgOverLoadLimit(cloudId, oneDriveBackupPolicy, backupBatch, batch);
        this.addWaitForBackupAttempt(cloudId, batchId, backupBatch);
        batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
        this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
        logger.debug(folder + ".....folder + file......." + file);
        logger.debug(".....nooffiles....." + noOfFiles);
        return batchId;
    }

    private List<DriveItem> getAllFilesForPolicy(List<DriveItem> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy oneDriveBackupPolicy, String deviceDestCollection, boolean isMail) {
        ArrayList<DriveItem> list = new ArrayList<DriveItem>();
        int i = 0;
        for (DriveItem driveItem : currentPage) {
            String basePath = "";
            String itemName = driveItem.name;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                logger.debug("..folder.." + driveItem.name + "...." + driveItem.folder.childCount);
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                logger.debug(parentPath + "..... folder to be added .... " + newPath);
            } else if (driveItem.file != null) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
            }
            if (StringUtils.isEmpty((String)basePath)) {
                basePath = "";
            }
            boolean isFileAllowed = this.handleElement(basePath, itemName, driveItem.size, oneDriveBackupPolicy, deviceUUID, userName, cloudId, isMail);
            logger.debug("..processed files......" + ++i + "/" + currentPage.size());
            if (!isFileAllowed) continue;
            list.add(driveItem);
        }
        return list;
    }

    private List<DriveItem> getModifiedFolderFiles(int cloudId, String deviceDestCollection, List<DriveItem> folders, String deviceUUID, String driveId, String deltaToken) {
        ArrayList<DriveItem> listItems = new ArrayList<DriveItem>();
        logger.debug("....iterating getModifiedFolderFiles......");
        for (DriveItem folderItem : folders) {
            try {
                List currentPage;
                BackUpImage backUpImageold = this.msUtilDao.getBackupImageFolderForItemIdForModified(cloudId, folderItem.id, deviceDestCollection);
                logger.debug(folderItem.name + ".... folder idbaa ss .... " + folderItem.id + "....." + backUpImageold);
                if (backUpImageold != null) {
                    String newPathVal = backUpImageold.getDevicePath() + "/" + backUpImageold.getFileName();
                    logger.debug(".... bkp image latest.... " + backUpImageold.getFileName() + "..." + backUpImageold.getDevicePath());
                    String parentPath = StringUtils.substringAfterLast((String)folderItem.parentReference.path, (String)"root:");
                    logger.debug("... parentpath ... " + parentPath);
                    parentPath = StringUtils.isEmpty((String)parentPath) ? "Files/" : BASE_FOLDER + parentPath + "/";
                    String newPath = parentPath + folderItem.name;
                    boolean isPathChanged = !newPathVal.equals(newPath);
                    logger.debug(isPathChanged + "...." + newPathVal + ".... isPathChanged..." + newPath + "....." + folderItem.name);
                    if (isPathChanged) {
                        boolean isNextPageExists = false;
                        DriveItemRequestBuilder items = (DriveItemRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(driveId).items(folderItem.id));
                        ArrayList<Object> requestOptions = new ArrayList<Object>();
                        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                        if (!StringUtils.isEmpty((String)deltaToken)) {
                            requestOptions.add(new QueryOption("token", (Object)deltaToken));
                        }
                        DriveItemCollectionPage iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                        do {
                            logger.debug(folderItem.name + "... before getting items...." + listItems.size());
                            currentPage = iDriveItemCollectionPage.getCurrentPage();
                            listItems.addAll(currentPage);
                            logger.debug(folderItem.name + "... after getting items1...." + folderItem.id + "..." + listItems.size());
                            DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                            if (currentPage.size() <= 0 || nextPage == null) break;
                            isNextPageExists = true;
                            iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                        } while (isNextPageExists);
                        logger.debug("...files under folder..." + folderItem.name + "...." + listItems.size());
                        List<DriveItem> foldlistItems = new ArrayList<DriveItem>();
                        foldlistItems = this.getSubfolderItems(cloudId, driveId, folderItem, foldlistItems, deltaToken);
                        if (!CollectionUtils.isEmpty(foldlistItems)) {
                            block7: for (DriveItem driItem : foldlistItems) {
                                isNextPageExists = false;
                                items = (DriveItemRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(driveId).items(driItem.id));
                                iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                                do {
                                    logger.debug("... before getting subfolder items...." + listItems.size());
                                    currentPage = iDriveItemCollectionPage.getCurrentPage();
                                    listItems.addAll(currentPage);
                                    logger.debug(listItems.size() + "... after getting subdfolder items1...." + driItem.id + "..." + driItem.name);
                                    DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                                    if (currentPage.size() <= 0 || nextPage == null) continue block7;
                                    isNextPageExists = true;
                                    iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                                } while (isNextPageExists);
                            }
                        }
                        logger.debug("...files after subfolder..." + folderItem.name + "...." + listItems.size());
                        this.msUtilDao.deleteAllFilesUnderFolder(cloudId, newPathVal, deviceUUID, deviceDestCollection);
                        continue;
                    }
                    logger.debug("... no children foor path");
                    continue;
                }
                logger.debug(".... no images...." + folderItem.name);
                boolean isNextPageExists = false;
                DriveItemRequestBuilder items = (DriveItemRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(driveId).items(folderItem.id));
                ArrayList<Object> requestOptions = new ArrayList<Object>();
                requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
                if (!StringUtils.isEmpty((String)deltaToken)) {
                    requestOptions.add(new QueryOption("token", (Object)deltaToken));
                }
                DriveItemCollectionPage iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                do {
                    logger.debug(folderItem.name + "... before getting items...." + listItems.size());
                    currentPage = iDriveItemCollectionPage.getCurrentPage();
                    listItems.addAll(currentPage);
                    logger.debug(folderItem.name + "... after getting items1...." + folderItem.id + "..." + listItems.size());
                    DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                    if (currentPage.size() <= 0 || nextPage == null) break;
                    isNextPageExists = true;
                    iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                } while (isNextPageExists);
                logger.debug("...files under folder..." + folderItem.name + "...." + listItems.size());
                List<DriveItem> foldlistItems = new ArrayList<DriveItem>();
                foldlistItems = this.getSubfolderItems(cloudId, driveId, folderItem, foldlistItems, deltaToken);
                if (!CollectionUtils.isEmpty(foldlistItems)) {
                    block10: for (DriveItem driItem : foldlistItems) {
                        isNextPageExists = false;
                        items = (DriveItemRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(driveId).items(driItem.id));
                        iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).get();
                        do {
                            logger.debug("... before getting subfolder items...." + listItems.size());
                            currentPage = iDriveItemCollectionPage.getCurrentPage();
                            listItems.addAll(currentPage);
                            logger.debug(listItems.size() + "... after getting subdfolder items1...." + driItem.id + "..." + driItem.name);
                            DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage();
                            if (currentPage.size() <= 0 || nextPage == null) continue block10;
                            isNextPageExists = true;
                            iDriveItemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)iDriveItemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
                        } while (isNextPageExists);
                    }
                }
                logger.debug("...files after subfolder..." + folderItem.name + "...." + listItems.size());
            }
            catch (Error e) {
                logger.error("... ERRORR...... " + e.getMessage());
            }
            catch (ClientException gg) {
                logger.error("... ERRORR...... " + gg.getMessage());
            }
            catch (RuntimeException gg) {
                logger.error("... ERRORR...... " + gg.getMessage());
            }
            catch (Exception ee) {
                logger.error("... ERRORR...... " + ee.getMessage());
            }
        }
        return listItems;
    }

    private List<DriveItem> getSubfolderItems(int cloudId, String driveId, DriveItem folderItem, List<DriveItem> foldlistItems, String deltaToken) {
        DriveItemCollectionPage foldertemCollectionPage;
        boolean isNextPageExists = false;
        DriveItemRequestBuilder items = (DriveItemRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(driveId).items(folderItem.id));
        ArrayList<Object> requestOptions = new ArrayList<Object>();
        requestOptions.add(new HeaderOption("Prefer", "odata.maxpagesize=40"));
        if (!StringUtils.isEmpty((String)deltaToken)) {
            requestOptions.add(new QueryOption("token", (Object)deltaToken));
        }
        if ((foldertemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)items.children().buildRequest(requestOptions)).filter("Folder ne null").get()) != null) {
            do {
                logger.debug(folderItem.name + "... before getting folders...." + foldlistItems.size());
                List currentPage = foldertemCollectionPage.getCurrentPage();
                foldlistItems.addAll(currentPage);
                if (!CollectionUtils.isEmpty((Collection)currentPage)) {
                    for (DriveItem driveItem : currentPage) {
                        foldlistItems = this.getSubfolderItems(cloudId, driveId, driveItem, foldlistItems, deltaToken);
                    }
                }
                logger.debug(foldlistItems.size() + "... after getting folders...." + folderItem.id + "..." + folderItem.name);
                DriveItemCollectionRequestBuilder nextPage = (DriveItemCollectionRequestBuilder)foldertemCollectionPage.getNextPage();
                if (currentPage.size() <= 0 || nextPage == null) {
                    isNextPageExists = false;
                    continue;
                }
                isNextPageExists = true;
                foldertemCollectionPage = (DriveItemCollectionPage)((DriveItemCollectionRequest)((DriveItemCollectionRequestBuilder)foldertemCollectionPage.getNextPage()).buildRequest(requestOptions)).get();
            } while (isNextPageExists);
        }
        return foldlistItems;
    }

    private BackUpImage convertToBkpImage(String deviceUUID, BackUpImage backUpImageold) {
        BackUpImage backUpImageDeleted = new BackUpImage();
        BeanUtils.copyProperties((Object)backUpImageold, (Object)backUpImageDeleted);
        backUpImageDeleted.setId(null);
        long timeMilliSec = System.currentTimeMillis();
        backUpImageDeleted.setDevicePath(backUpImageold.getDevicePath());
        backUpImageDeleted.setFileName(backUpImageold.getFileName());
        backUpImageDeleted.setDeviceUUID(deviceUUID);
        backUpImageDeleted.setLastServerModifiedTime(timeMilliSec);
        backUpImageDeleted.setFolder(backUpImageold.isFolder());
        backUpImageDeleted.setMd5Checksum(backUpImageold.getMd5Checksum());
        backUpImageDeleted.setPresent(false);
        backUpImageDeleted.setfSPath(backUpImageold.getfSPath());
        backUpImageDeleted.setUserName(backUpImageold.getUserName());
        backUpImageDeleted.setStatus(PCHelperConstant.REVISION_STATUS.DELETED.toString());
        backUpImageDeleted.setLastClientModifiedTime(backUpImageold.getLastClientModifiedTime());
        backUpImageDeleted.setBaseBackup(false);
        backUpImageDeleted.setSize(backUpImageold.getSize());
        backUpImageDeleted.setOdItemId(backUpImageold.getOdItemId());
        backUpImageDeleted.setGatewayName(backUpImageold.getGatewayName());
        backUpImageDeleted.setSubject(backUpImageold.getSubject());
        backUpImageDeleted.setFrom(backUpImageold.getFrom());
        backUpImageDeleted.setBodyContent(backUpImageold.getBodyContent());
        backUpImageDeleted.setBccRecipients(backUpImageold.getBccRecipients());
        backUpImageDeleted.setCcRecipients(backUpImageold.getCcRecipients());
        backUpImageDeleted.setToRecipients(backUpImageold.getToRecipients());
        backUpImageDeleted.setHasAttachments(backUpImageold.isHasAttachments());
        backUpImageDeleted.setTaskSubject(backUpImageold.getTaskSubject());
        backUpImageDeleted.setTaskStartDate(backUpImageold.getTaskStartDate());
        backUpImageDeleted.setTaskReminderTime(backUpImageold.getTaskReminderTime());
        backUpImageDeleted.setTaskDueDate(backUpImageold.getTaskDueDate());
        backUpImageDeleted.setContactMobile(backUpImageold.getContactMobile());
        backUpImageDeleted.setContactAddrStreet(backUpImageold.getContactAddrStreet());
        backUpImageDeleted.setContactAddrCity(backUpImageold.getContactAddrCity());
        backUpImageDeleted.setContactAddrState(backUpImageold.getContactAddrState());
        backUpImageDeleted.setContactAddrCountry(backUpImageold.getContactAddrCountry());
        backUpImageDeleted.setContactAddrPostalCode(backUpImageold.getContactAddrPostalCode());
        backUpImageDeleted.setChunkFiles(backUpImageold.getChunkFiles());
        boolean isMail = false;
        if (backUpImageold.isMail()) {
            isMail = true;
            backUpImageDeleted.setEwsId(backUpImageold.getEwsId());
        }
        backUpImageDeleted.setMail(isMail);
        return backUpImageDeleted;
    }

    public boolean handleElement(String path, String fileName, Long fileSize, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId, boolean isMail) {
        boolean skipFileBasedonSize;
        boolean allow = false;
        path = path.toLowerCase();
        fileName = fileName.toLowerCase();
        if (oneDriveBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("...allow all .. becoz legal hold enabled ...");
            return true;
        }
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForOdbBackupFolders(path, path, inclusionbackupFolders);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(path, path, excludedFolders);
        if (!allow) {
            logger.error("... file not under excluded path..." + path);
            return allow;
        }
        allow = this.checkForExtensions(fileName, oneDriveBackupPolicy.getInclusionFilter(), oneDriveBackupPolicy.getFilterType());
        if (!allow) {
            logger.error("... file not allowed becoz of extension..." + fileName);
            return allow;
        }
        if (!isMail && (skipFileBasedonSize = MSServiceImpl.checkFileSize(fileSize, Long.parseLong(oneDriveBackupPolicy.getMaxFileSize())))) {
            logger.error(".. file size is bigger for onedrive..." + fileSize + "....." + oneDriveBackupPolicy.getMaxFileSize());
            return false;
        }
        return allow;
    }

    public boolean handleMailElement(String actualPath, String path, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId, boolean inplaceArchive, Cloud cloud) {
        boolean allow = false;
        path = path.toLowerCase();
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForBackupFolders(actualPath, path, inclusionbackupFolders, inplaceArchive, cloud);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(actualPath, actualPath, excludedFolders);
        if (!allow) {
            return allow;
        }
        return allow;
    }

    public boolean handleFolderElement(String actualPath, String path, OfficeBackupPolicy oneDriveBackupPolicy, String deviceUUID, String userName, int cloudId, Cloud cloud) {
        boolean allow = false;
        path = path.toLowerCase();
        if (oneDriveBackupPolicy.isLegalHoldEnabled()) {
            logger.debug("...allow all .. becoz legal hold enabled ...");
            return true;
        }
        ArrayList<BackupFolders> inclusionbackupFolders = oneDriveBackupPolicy.getBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForBackupFolders(actualPath, path, inclusionbackupFolders, false, cloud);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = oneDriveBackupPolicy.getExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(actualPath, path, excludedFolders);
        if (!allow) {
            return allow;
        }
        return allow;
    }

    private void addDeviceLevelExclusion(String deviceUUID, String userName, int cloudId, List<ExcludedFolders> excludedFolders) {
        List userDeviceExcludedFoldersList = this.deviceDao.getAllUserDefinedExclusionFolders(cloudId, deviceUUID, userName);
        if (!CollectionUtils.isEmpty((Collection)userDeviceExcludedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDeviceExcludedFoldersList) {
                ExcludedFolders backupFolderElement = new ExcludedFolders();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                excludedFolders.add(backupFolderElement);
            }
        }
    }

    private void addDeviceLevelInclusion(String deviceUUID, String userName, int cloudId, List<BackupFolders> inclusionbackupFolders) {
        List userDefinedFoldersList = this.deviceDao.getAllUserDefinedInclusionFolders(cloudId, deviceUUID, userName);
        if (!CollectionUtils.isEmpty((Collection)userDefinedFoldersList)) {
            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                BackupFolders backupFolderElement = new BackupFolders();
                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                inclusionbackupFolders.add(backupFolderElement);
            }
        }
    }

    private static boolean checkFileSize(Long fileSize, long allowedSize) {
        boolean isFileTobeSkipped = true;
        if (allowedSize != 0L && allowedSize != -1L) {
            long fileSizeinBytes = fileSize;
            float fileSizeinMb = (float)fileSizeinBytes / 1048576.0f;
            if (fileSizeinMb <= (float)allowedSize) {
                isFileTobeSkipped = false;
            }
        } else if (allowedSize == -1L) {
            isFileTobeSkipped = false;
        }
        return isFileTobeSkipped;
    }

    private static String getNormalizedPath(String path) {
        String newPath = path;
        if (!newPath.endsWith("/")) {
            newPath = newPath + "/";
        }
        return newPath;
    }

    private boolean checkForBackupFolders(String actualPath, String path, List<BackupFolders> backupFolders, boolean inPlaceArchive, Cloud cloud) {
        boolean allow = false;
        if (backupFolders == null || backupFolders.size() <= 0) {
            allow = true;
        } else {
            path = this.updatePath(path);
            String newPath = MSServiceImpl.getNormalizedPath(path);
            actualPath = this.updatePath(actualPath);
            String newActualPath = MSServiceImpl.getNormalizedPath(actualPath);
            path = newPath.toLowerCase();
            actualPath = newActualPath.toLowerCase();
            if (cloud.getMailRecoverableItemsEnabled() == 1 && (actualPath.startsWith("recoverable items") || actualPath.startsWith("purged items") || actualPath.startsWith("Recoverable Items") || actualPath.startsWith("Purged Items"))) {
                return true;
            }
            boolean inplaceFoldersConfigured = false;
            boolean inplaceSpecifFolderAdded = false;
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath()) || !folder.getFolderPath().contains("In-Place Archive")) continue;
                inplaceSpecifFolderAdded = true;
            }
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath())) continue;
                if (!inplaceSpecifFolderAdded && folder.getFolderPath().equals("/")) {
                    allow = true;
                    break;
                }
                if (folder.getFolderPath().contains("In-Place Archive")) {
                    inplaceFoldersConfigured = true;
                }
                String normalizedPath = MSServiceImpl.getNormalizedPath(folder.getFolderPath());
                normalizedPath = normalizedPath.toLowerCase();
                normalizedPath = this.updatePath(normalizedPath);
                if (inplaceSpecifFolderAdded && path.contains("in-place archive") && normalizedPath.equalsIgnoreCase("/") || !path.startsWith(normalizedPath) && !actualPath.equalsIgnoreCase(normalizedPath) && !actualPath.startsWith(normalizedPath)) continue;
                logger.debug(path + "..pathnormalized.." + normalizedPath);
                allow = true;
                break;
            }
            if (!allow && !inplaceFoldersConfigured && inPlaceArchive) {
                allow = true;
            }
        }
        logger.debug(allow + "...Checking fornn3.." + path);
        return allow;
    }

    private boolean checkForOdbBackupFolders(String actualPath, String path, List<BackupFolders> backupFolders) {
        boolean allow = false;
        if (backupFolders == null || backupFolders.size() <= 0) {
            allow = true;
        } else {
            path = this.updatePath(path);
            actualPath = this.updatePath(actualPath);
            String newPath = MSServiceImpl.getNormalizedPath(path);
            String newActualPath = MSServiceImpl.getNormalizedPath(actualPath);
            path = newPath.toLowerCase();
            actualPath = newActualPath.toLowerCase();
            for (BackupFolders folder : backupFolders) {
                if (folder == null || StringUtils.isEmpty((String)folder.getFolderPath())) continue;
                if (folder.getFolderPath().equals("/")) {
                    allow = true;
                    break;
                }
                String normalizedPath = MSServiceImpl.getNormalizedPath(folder.getFolderPath());
                normalizedPath = normalizedPath.toLowerCase();
                normalizedPath = this.updatePath(normalizedPath);
                path = path.replaceAll("//", "/");
                actualPath = actualPath.replaceAll("//", "/");
                if (!path.startsWith(normalizedPath) && !actualPath.equalsIgnoreCase(normalizedPath) && !actualPath.startsWith(normalizedPath)) continue;
                allow = true;
                break;
            }
        }
        return allow;
    }

    private String updatePath(String path) {
        if (!(StringUtils.isEmpty((String)path) || path.equals("/") || path.startsWith("/"))) {
            StringBuilder str = new StringBuilder(path);
            path = str.insert(0, "/").toString();
        }
        return path;
    }

    private boolean checkForPathNotExcluded(String actualPath, String path, List<ExcludedFolders> excludedFolders) {
        boolean allow = true;
        if (excludedFolders == null || excludedFolders.size() <= 0) {
            allow = true;
        } else {
            path = MSServiceImpl.getNormalizedPath(path.toLowerCase());
            path = this.updatePath(path);
            for (ExcludedFolders excludedFolder : excludedFolders) {
                String pathInPolicy = excludedFolder.getFolderPath();
                String normalizedPath = MSServiceImpl.getNormalizedPath(pathInPolicy.toLowerCase());
                normalizedPath = this.updatePath(normalizedPath);
                path = path.replaceAll("//", "/");
                logger.debug(excludedFolder.getFolderPath() + "..excludedpathsva ...." + path + "..." + normalizedPath);
                if (!path.startsWith(normalizedPath)) continue;
                logger.debug("Path (" + path + ") disallowed because of Rule(excludedFolders) " + excludedFolder.getFolderPath());
                allow = false;
                break;
            }
        }
        return allow;
    }

    private boolean checkForExtensions(String fileName, List<InclusionFilter> inclusionFilterList, String filterType) {
        boolean allow = false;
        if (CollectionUtils.isEmpty(inclusionFilterList)) {
            return true;
        }
        HashSet<String> filterExtensions = new HashSet<String>();
        for (InclusionFilter inclusionFilter : inclusionFilterList) {
            String[] extensions;
            for (String ext : extensions = inclusionFilter.getExtensionName().split(",")) {
                ext = ext.toLowerCase();
                filterExtensions.add(ext);
            }
        }
        boolean allowAllextensions = filterExtensions.contains("all");
        if (filterExtensions != null && !allowAllextensions) {
            if (!StringUtils.isEmpty((String)filterType) && filterType.equalsIgnoreCase("exclusion")) {
                if (filterExtensions.size() > 0 && !filterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                    allow = true;
                }
            } else if (filterExtensions.size() > 0 && filterExtensions.contains(FilenameUtils.getExtension((String)fileName.toLowerCase()))) {
                allow = true;
            }
        } else {
            allow = true;
        }
        return allow;
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId) {
        logger.debug("....getEventsToProcess1..... ");
        return this.msUtilDao.getStartBackupEventHubList(cloudId);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, action);
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        return this.msUtilDao.getEventHubForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public Device getODDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getODDeviceForUserName(cloudId, userName);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyForUserName(int cloudId, String userName, String policyType) {
        return this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, policyType);
    }

    @Override
    public void updateEventHubOdStatus(int cloudId, ObjectId eventHubId) {
        this.msUtilDao.updateEventHubOdStatus(cloudId, eventHubId);
    }

    @Override
    public boolean isPrevBkpPaused(String actionToDeviceUUID, String policyName) {
        return this.msUtilDao.isPrevBkpPaused(actionToDeviceUUID, policyName);
    }

    @Override
    public void updatePauseBkp(String actionToDeviceUUID, String policyName) {
        this.msUtilDao.updatePauseBkp(actionToDeviceUUID, policyName);
    }

    @Override
    public com.parablu.pcbd.domain.User getUserInfo(int cloudId, String userName) {
        return this.userDao.getUserInfoByName(cloudId, "", userName);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        return this.msUtilDao.getThreadSize(cloudId, cloudName);
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy oneDriveBackupPolicy) {
        this.msUtilDao.saveOfficeBackupPolicy(cloudId, oneDriveBackupPolicy);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyFromLocal(int cloudId, String policyName) {
        return this.msUtilDao.getOfficeBackupPolicyFromLocal(cloudId, policyName);
    }

    @Override
    public List<ODBBackupBatch> getCurrentBatch(String policyName, String userName, String deviceUUID) {
        return this.msUtilDao.getCurrentBatch(policyName, userName, deviceUUID);
    }

    @Override
    public void processDeltaChangesForUserMail(com.parablu.pcbd.domain.User userObj, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, boolean isPolicyModified, boolean isFullBackup, String eventHubId, long batchStartTime, Device device) {
        String userName = userObj.getUserName();
        String emailId = userObj.getEmailId();
        int cloudId = cloud.getCloudId();
        String deviceUUID = device.getDeviceUUID();
        if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && userObj != null && !userObj.isBackupTargetAssigned()) {
            logger.debug(eventHubId + ".....backupTargetAssigned is false so return..." + userName);
            this.createBatchForTargetUnAssignedUser(cloudId, device.getDeviceUUID(), userName, oneDriveBackupPolicy, batchStartTime);
            this.deleteEventHub(cloudId, new ObjectId(eventHubId));
            this.deleteEventHubForUser(cloudId, userName, "STARTED");
            return;
        }
        try {
            logger.debug(isFullBackup + ".....policy is modified........." + isPolicyModified);
            String deltaToken = device.getDeltaToken();
            List allDeltaLinkUser = this.msUtilDao.getAllDeltaLinkUser(userName);
            if (CollectionUtils.isEmpty((Collection)allDeltaLinkUser)) {
                isFullBackup = true;
            }
            logger.debug(isFullBackup + ".....policy is modified1........." + allDeltaLinkUser);
            if (isFullBackup) {
                deltaToken = "";
                logger.debug(device.getDeviceUUID() + ".....policy is modified2........." + userName);
            }
            logger.debug(device.getDeviceUUID() + ".....policy is modified3........." + userName);
            ArrayList<Message> listItems = new ArrayList<Message>();
            User userFound = null;
            ArrayList<Option> requestOptions = new ArrayList<Option>();
            requestOptions.add((Option)new QueryOption("$filter", (Object)("mail eq '" + emailId + "'")));
            userFound = this.getUserFromOffice(emailId, userFound, requestOptions);
            if (userFound == null) {
                logger.error(".... user not found ..." + emailId + "..." + userName);
                this.createBatchForFailedMailBox(cloudId, deviceUUID, userName, oneDriveBackupPolicy, batchStartTime);
                return;
            }
            User userFoundFianl = userFound;
            UserRequestBuilder users = (UserRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userFoundFianl.id));
            MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
            try {
                ((MailFolderDeltaCollectionRequest)mailFolders.delta().buildRequest(new Option[0])).get();
            }
            catch (GraphServiceException e2) {
                logger.error("...error-trying to get folders..... " + e2.getResponseCode());
                if (e2.getResponseCode() == 404) {
                    BackupBatch batch = this.msUtilDao.getQueueBatchForFailedMailBox(cloudId, deviceUUID);
                    if (batch != null) {
                        batch.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
                        batch.setErrorCode("544");
                        this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                        BackupAttempt backupAttempt = new BackupAttempt();
                        backupAttempt.setBatchId(batch.getId().toString());
                        backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                        backupAttempt.setStatus(PCHelperConstant.BACKUP_STATUS.ABORTED.name());
                        backupAttempt.setErrorCode("544");
                        this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
                        this.msUtilDao.updateMsgBatchStatus(batch.getId(), oneDriveBackupPolicy.getPolicyName());
                        batch.setNoOfFiles(0L);
                        batch.setTotalNoOfFiles("0");
                        batch.setBatchEndTimestamp(System.currentTimeMillis());
                        logger.debug(oneDriveBackupPolicy.getPolicyName() + "...update batch for completion..." + batch.getId().toString());
                        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                        this.msUtilDao.updateBkpBatchDetailsEndTime(cloudId, batch);
                        this.deleteEventHub(cloudId, new ObjectId(eventHubId));
                        this.deleteEventHubForUser(cloudId, userName, "STARTED");
                        this.deleteEventHubForUser(cloudId, userName, "PROCESSED");
                        return;
                    }
                    ODBBackupBatch backupBatch = new ODBBackupBatch();
                    backupBatch.setDeviceUUID(deviceUUID);
                    backupBatch.setUserName(userName);
                    backupBatch.setNoOfFiles(0L);
                    backupBatch.setTotalNoOfFiles("0");
                    backupBatch.setStatus("COMPLETED");
                    backupBatch.setBatchStartTimestamp(System.currentTimeMillis());
                    backupBatch.setErrorCode("544");
                    String batchId = this.msUtilDao.saveBatchDetails(cloudId, backupBatch, oneDriveBackupPolicy.getPolicyName(), batchStartTime);
                    this.userDao.updateFailedMailBox(cloudId, userName);
                }
                return;
            }
            String destCollection = device.getDestCollection();
            isPolicyModified = false;
            if (isPolicyModified) {
                listItems = new ArrayList();
                logger.debug(".... policymodified new log .... " + deviceUUID);
                this.handleModifiedMailItems(deviceUUID, userName, emailId, cloudId, oneDriveBackupPolicy, isFullBackup, destCollection, deltaToken, eventHubId, batchStartTime, cloud);
            } else {
                logger.debug(isFullBackup + "... backup token1.... " + deltaToken);
                deltaToken = this.handleMailItems(listItems, deviceUUID, userName, emailId, cloud, oneDriveBackupPolicy, isFullBackup, destCollection, deltaToken, eventHubId, batchStartTime);
            }
            logger.debug(listItems.size() + "...@@@@@@@@@@@@@@@@new delta token from deltapage...." + deltaToken);
        }
        catch (Error e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...exception trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...exception trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
    }

    private void updateQueueOrScanProcessing(int cloudId, String deviceUUID) {
        this.msUtilDao.updateQueueOrScanProcessing(cloudId, deviceUUID);
    }

    private void deleteEventHubForUser(int cloudId, String userName, String status) {
        this.msUtilDao.deleteEventHub(cloudId, userName, status);
    }

    private User getUserFromOffice(String emailId, User userFound, List<Option> requestOptions) {
        UserCollectionPage iUserCollectionPage = null;
        try {
            iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(requestOptions)).top(1).get());
            for (Object user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(((User)user).mail) || !emailId.equalsIgnoreCase(((User)user).userPrincipalName)) continue;
                userFound = user;
                break;
            }
        }
        catch (ClassCastException ee) {
            logger.error("...classcast exception .. so wait for 30 sec and retry .... ");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException user) {
                // empty catch block
            }
            try {
                iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(new Option[0])).top(1).get());
                for (User user : iUserCollectionPage.getCurrentPage()) {
                    logger.debug("................userfound.........." + user.mail);
                }
            }
            catch (ClassCastException eea) {
                logger.debug(".....error in retry2..... ");
                userFound = this.getUserFromOffice(emailId, (User)userFound, requestOptions);
            }
        }
        if (userFound == null) {
            for (Object user : iUserCollectionPage.getCurrentPage()) {
                if (!emailId.equalsIgnoreCase(((User)user).mail)) continue;
                userFound = user;
                break;
            }
        }
        return userFound;
    }

    public MailFolderRequestBuilder getMailFolders(int cloudId, String userName, String folderName) {
        User userFound = null;
        ArrayList<QueryOption> requestOptions = new ArrayList<QueryOption>();
        requestOptions.add(new QueryOption("$filter", (Object)("mail eq '" + userName + "'")));
        UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(requestOptions)).top(1).get());
        for (User user : iUserCollectionPage.getCurrentPage()) {
            if (!userName.equalsIgnoreCase(user.mail) || !userName.equalsIgnoreCase(user.userPrincipalName)) continue;
            userFound = user;
            break;
        }
        if (userFound == null) {
            for (User user : iUserCollectionPage.getCurrentPage()) {
                if (!userName.equalsIgnoreCase(user.mail)) continue;
                userFound = user;
                break;
            }
        }
        String userPrincId = userFound.id;
        UserRequestBuilder users = (UserRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().users(userPrincId));
        MailFolderCollectionRequestBuilder mailFolders = users.mailFolders();
        return (MailFolderRequestBuilder)mailFolders.byId(folderName);
    }

    public static synchronized String getEWSAccesToken(EWSAppSetting ewsAppSetting) {
        logger.debug("getEWSAccesToken....");
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + ewsAppSetting.getTenantId(), false, es);
            AuthenticationCallback<AuthenticationResult> callback = new AuthenticationCallback<AuthenticationResult>(){

                public void onSuccess(AuthenticationResult result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug("requesting token.....");
            Future future = context.acquireToken(RESOURCE, new ClientCredential(ewsAppSetting.getClientId(), ewsAppSetting.getClientSecretKey()), (AuthenticationCallback)callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
            logger.debug("requesting token last....." + accessToken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessToken;
    }

    public static ExchangeService getAuthenticatedService(String token, String senderAddr) {
        ExchangeService service = null;
        try {
            service = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            service.getHttpHeaders().put("Authorization", "Bearer " + token);
            service.getHttpHeaders().put("X-AnchorMailbox", senderAddr);
            service.setUrl(new URI(EWS_URL));
            service.setImpersonatedUserId(new ImpersonatedUserId(ConnectingIdType.PrincipalName, senderAddr));
        }
        catch (Exception e) {
            logger.error("....error trying ....." + e.getMessage());
        }
        return service;
    }

    @Override
    public ObjectId saveEventHubAction(int cloudId, EventHub eventHub) {
        return this.msUtilDao.saveEventHubAction(cloudId, eventHub);
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, AuditHistory auditHistory) {
        this.msUtilDao.saveStatisticToDatabase(cloudId, auditHistory);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedInclusionFolders(int cloudId, String deviceUUID, String userName) {
        return this.deviceDao.getAllUserDefinedInclusionFolders(cloudId, deviceUUID, userName);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedExclusionFolders(int cloudId, String deviceUUID, String userName) {
        return this.deviceDao.getAllUserDefinedExclusionFolders(cloudId, deviceUUID, userName);
    }

    @Override
    public Device getMailDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getMailDeviceForUserName(cloudId, userName);
    }

    @Override
    public RestoreEvents getRestoreEventsByUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getRestoreEventsByUUID(cloudId, deviceUUID);
    }

    @Override
    public boolean isPrevBkpDeferred(String actionToDeviceUUID, String policyName) {
        return this.msUtilDao.isPrevBkpDeferred(actionToDeviceUUID, policyName);
    }

    @Override
    public void updateDeferredBkp(String actionToDeviceUUID, String policyName) {
        this.msUtilDao.updateDeferredBkp(actionToDeviceUUID, policyName);
    }

    @Override
    public DeviceBackupOverView getDeviceBackupOverViewForDevice(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public List<EventHub> getStartBackupEventHubListForBlukrypt(int cloudId) {
        return this.msUtilDao.getStartBackupEventHubListForBlukrypt(cloudId);
    }

    @Override
    public void removeOldEventHub(int cloudId) {
        this.msUtilDao.removeOldEventHub(cloudId);
    }

    @Override
    public void deleteEventHub(int cloudId, ObjectId eventHubId) {
        this.msUtilDao.deleteEventHub(cloudId, eventHubId);
    }

    public static String getKeyFromValue(Map<String, String> hm, Object value) {
        for (String o : hm.keySet()) {
            if (!hm.get(o).equals(value)) continue;
            return o;
        }
        return null;
    }

    private DriveRequestBuilder getDrive(int cloudId, String deviceUUID) {
        DriveRequestBuilder drives = null;
        try {
            drives = (DriveRequestBuilder)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().drives(deviceUUID));
        }
        catch (GraphServiceException ee) {
            logger.error(ee.getMessage() + "... error in getting drives ...." + deviceUUID + "...error code..." + ee.getResponseCode());
        }
        catch (Error ee) {
            logger.error(ee.getMessage() + "... error in getting drives ...." + deviceUUID);
        }
        return drives;
    }

    @Override
    public Device getSharePointDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getSharePointDeviceForUserName(cloudId, userName);
    }

    @Override
    public void processDeltaChangesForSite(com.parablu.pcbd.domain.User userObj, int cloudId, OfficeBackupPolicy spPolicy, boolean isPolicyModified, boolean isFullBkp, String eventHubId, long batchStartTime, String siteId) {
        String userName = userObj.getUserName();
        Device device = this.deviceDao.getSharePointDeviceForUserName(cloudId, userName);
        if (device == null) {
            logger.debug("... no onedrive device for user... " + userName);
            return;
        }
        if (device.isBlocked() || device.isDeleted()) {
            logger.debug("... device blocked for user... " + userName);
            return;
        }
        Cloud cloud = this.getCloud(cloudId);
        boolean isFullBackup = this.isFullBkpStarted(cloud, device, userName);
        if (this.isODBEnabled(cloud.getCloudCustomisableDetails()) && userObj != null && !userObj.isBackupTargetAssigned()) {
            logger.debug(".....backupTargetAssigned is false so return..." + userName);
            this.createBatchForTargetUnAssignedUser(cloudId, device.getDeviceUUID(), userName, spPolicy, batchStartTime);
            this.deleteEventHub(cloudId, new ObjectId(eventHubId));
            this.deleteEventHubForUser(cloudId, userName, "STARTED");
            return;
        }
        String deviceUUID = device.getDeviceUUID();
        String productType = device.getDeviceType();
        String batchId = "";
        try {
            boolean siteActive;
            String prevDeviceToken;
            ArrayList listItems;
            String deltaToken;
            block28: {
                logger.debug(isFullBackup + ".....policy is modified........." + isPolicyModified);
                deltaToken = device.getDeltaToken();
                if (StringUtils.isEmpty((String)deltaToken)) {
                    isFullBackup = true;
                }
                if (isFullBackup) {
                    deltaToken = "";
                    isPolicyModified = false;
                }
                listItems = new ArrayList();
                prevDeviceToken = deltaToken;
                siteActive = true;
                try {
                    Site site = (Site)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().sites(siteId).buildRequest(new Option[0]).get());
                }
                catch (GraphServiceException e) {
                    e.printStackTrace();
                    logger.error("..error..." + e.getMessage());
                    logger.debug("..site not availabe latest ...." + e.getResponseCode());
                    if (e.getResponseCode() != 404) break block28;
                    AuditHistory audit = new AuditHistory();
                    audit.setAction(" blocked the SharePoint Online site " + userName + "  - unable to find the SharePoint site ");
                    audit.setActionByUserName("AUTO");
                    audit.setTimestamp(System.currentTimeMillis());
                    audit.setActionType(14);
                    this.saveStatisticToDatabase(cloudId, audit);
                    this.deviceDao.blockUnblockDevice(cloudId, "", device, true);
                    this.createBatchForFailedSP(cloudId, deviceUUID, userName, spPolicy);
                    siteActive = false;
                }
            }
            if (siteActive) {
                ODBBackupBatch backupBatch = this.msUtilDao.getQueuedBatch(deviceUUID, spPolicy.getPolicyName(), BackupBatch.STATUS.QUEUED.name());
                batchId = "";
                if (backupBatch != null) {
                    batchId = backupBatch.getId().toString();
                }
                BackupBatch batch = null;
                if (!StringUtils.isEmpty((String)batchId)) {
                    batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                }
                if (batch == null) {
                    logger.debug("....user1...." + userName);
                    batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, deviceUUID);
                    batchId = batch.getId().toString();
                    logger.debug(batchId + "....user2 delete batch...." + userName + "...." + batch.getStatus());
                    ODBBackupBatch odbBackupBatch = new ODBBackupBatch();
                    BeanUtils.copyProperties((Object)batch, (Object)odbBackupBatch);
                    odbBackupBatch.setId(new ObjectId(batchId));
                    backupBatch = this.msUtilDao.deleteAndCreateBatch(deviceUUID, spPolicy.getPolicyName(), odbBackupBatch);
                }
                backupBatch.setStatus("STARTED");
                BackupAttempt backupAttempt = this.utilDao.getLastBackupAttemptById(cloudId, batchId);
                if (backupAttempt != null && backupAttempt.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.name())) {
                    backupAttempt.setBatchId(batchId);
                    backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
                    logger.debug("......firstattempt.....");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                    this.msUtilDao.updateMsgBatchStatus(backupBatch.getId(), spPolicy.getPolicyName());
                    device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
                    if (!PCHelperConstant.BACKUP_STATUS.SCANNING.toString().equalsIgnoreCase(backupAttempt.getStatus())) {
                        this.addScanningAttempt(cloudId, batchId, backupBatch);
                    }
                    logger.debug("......secondtattempt.....");
                    Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                    backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
                    batch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
                    this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                }
                if (backupAttempt == null) {
                    backupAttempt = new BackupAttempt();
                    BeanUtils.copyProperties((Object)backupBatch, (Object)backupAttempt);
                    backupAttempt.setBatchId(backupBatch.getId().toString());
                    backupAttempt.setId(null);
                    backupAttempt.setErrorCode("0");
                    backupAttempt.setBatchStartTimestamp(batch.getBatchStartTimestamp());
                    backupAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                    backupAttempt.setStatus(batch.getStatus());
                    this.utilDao.saveBackupAttempt(cloudId, backupAttempt);
                    this.addScanningAttempt(cloudId, batchId, backupBatch);
                }
                batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                if (isFullBackup) {
                    this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
                    batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
                }
                if (batch == null) {
                    batch = this.backUpImageDao.getBackupBatchByDeviceUUID(cloudId, backupBatch.getDeviceUUID());
                    batchId = batch.getId().toString();
                }
                if (this.isBkpStopped(cloudId, batchId)) {
                    return;
                }
                if (isPolicyModified) {
                    logger.debug("... backup token.... " + deltaToken);
                    String retryToken = deltaToken;
                    deltaToken = this.findSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, siteId, productType, cloud);
                    if ("DIFF-BLUKRYPT".equalsIgnoreCase(deltaToken)) {
                        logger.debug("....diff blukrypt....");
                        this.msUtilDao.deleteBatchFromOdServer(new ObjectId(batchId), spPolicy.getPolicyName());
                        this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                    } else {
                        long totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                        if (totalNoOfFiles == 0L) {
                            logger.debug("...retrt one more time wait for 5 sec because it is 0 files...");
                            Thread.sleep(5000L);
                            logger.debug("...retrt one more time after 5 sec because it is 0 files...");
                            deltaToken = retryToken;
                            deltaToken = this.findSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, siteId, productType, cloud);
                            totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                        }
                        long totalSizeToUpload = 0L;
                        this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), deltaToken, prevDeviceToken);
                        logger.debug("...total files and size...." + totalNoOfFiles + "...size..." + totalSizeToUpload);
                        backupBatch.setId(new ObjectId(batchId));
                        backupBatch.setStatus("COMPLETED");
                        backupBatch.setTotalSizeToUpload(totalSizeToUpload);
                        long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
                        long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
                        backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
                        batch.setNoOfFiles(0L);
                        batch.setTotalNoOfFiles("" + totalFilesCount);
                        backupBatch.setTotalNoOfFiles("" + totalFilesCount);
                        batch.setStatus(BackupBatch.STATUS.SCANNING.toString());
                        logger.debug(spPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
                        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, spPolicy.getPolicyName(), batchStartTime);
                        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                        this.updateInterruptedStatusForPgOverLoadLimit(cloudId, spPolicy, backupBatch, batch);
                        this.addWaitForBackupAttempt(cloudId, batchId, backupBatch);
                        batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
                        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                        this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                    }
                } else {
                    logger.debug("... backup token.... " + deltaToken);
                    logger.debug("....BACKUPSTART...");
                    String retryToken = deltaToken;
                    deltaToken = this.findSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, siteId, productType, cloud);
                    if ("DIFF-BLUKRYPT".equalsIgnoreCase(deltaToken)) {
                        logger.debug("....diff blukrypt....");
                        this.msUtilDao.deleteBatchFromOdServer(new ObjectId(batchId), spPolicy.getPolicyName());
                        this.msUtilDao.deleteActionBasedOnBackupBatchStatus(cloudId, deviceUUID, "START_BACKUP");
                    } else {
                        long totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                        if (totalNoOfFiles == 0L) {
                            logger.debug("...retrt one more time wait for 5 sec because it is 0 files...");
                            Thread.sleep(5000L);
                            logger.debug("...retrt one more time after 5 sec because it is 0 files...");
                            deltaToken = retryToken;
                            deltaToken = this.findSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, device.getDestCollection(), false, backupBatch, batchId, eventHubId, siteId, productType, cloud);
                            totalNoOfFiles = this.msUtilDao.getTotalFilesCountByBatchId(batchId, deviceUUID);
                        }
                        long totalSizeToUpload = 0L;
                        logger.debug("...total files and size...." + totalNoOfFiles + "...size..." + totalSizeToUpload);
                        backupBatch.setId(new ObjectId(batchId));
                        backupBatch.setStatus("COMPLETED");
                        backupBatch.setTotalSizeToUpload(totalSizeToUpload);
                        long totalFilesCount = this.msUtilDao.getTotalFilesCountByDeviceUUID(backupBatch.getDeviceUUID());
                        long totalFailedCount = this.msUtilDao.getTotaFailedlFilesFromPrevBackup(deviceUUID);
                        backupBatch.setNoOfFiles(totalFilesCount += totalFailedCount);
                        batch.setNoOfFiles(0L);
                        batch.setTotalNoOfFiles("" + totalFilesCount);
                        backupBatch.setTotalNoOfFiles("" + totalFilesCount);
                        logger.debug(spPolicy.getPolicyName() + "...update batch for completion..." + backupBatch.getId().toString());
                        this.msUtilDao.updateBatchDetails(cloudId, backupBatch, spPolicy.getPolicyName(), batchStartTime);
                        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                        this.updateInterruptedStatusForPgOverLoadLimit(cloudId, spPolicy, backupBatch, batch);
                        logger.debug(listItems.size() + "...@@@@@@@@@@@@@@@@new delta token from deltapage...." + deltaToken);
                        this.deviceDao.updateDeviceDeltaToken(cloudId, device.getDeviceUUID(), deltaToken, prevDeviceToken);
                        this.addWaitForBackupAttempt(cloudId, batchId, backupBatch);
                        batch.setStatus(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString());
                        this.msUtilDao.updateBkpBatchDetails(cloudId, batch, batchStartTime);
                        this.updateInterruptedStatusForPgOverLoadLimit(cloudId, spPolicy, backupBatch, batch);
                        this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, batch, 0);
                    }
                }
            }
        }
        catch (Error e) {
            e.printStackTrace();
            logger.error(e.getMessage() + " ...error trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(batchId + " ...exception trying to process .. user ... " + userName);
            this.updateQueueOrScanProcessing(cloudId, deviceUUID);
        }
    }

    private void updateInterruptedStatusForPgOverLoadLimit(int cloudId, OfficeBackupPolicy spPolicy, ODBBackupBatch backupBatch, BackupBatch batch) {
        long threadSize = PCHelperConstant.getPGOverloadLimit();
        logger.debug(" ...updateInterruptedStatusForPgOverLoadLimit... " + threadSize);
        if (threadSize <= 0L) {
            this.msUtilDao.updateDeferedBatchStatusInOdServer(backupBatch.getId(), spPolicy.getPolicyName());
            this.updateBatchAndOverview(cloudId, backupBatch.getId(), INTERRUPTED_STATUS, backupBatch.getDeviceUUID(), 1996);
            this.updateBatchAttempt(cloudId, batch, false, false, true, false);
        }
    }

    private void updateBatchAndOverview(int cloudId, ObjectId backupBatchId, String status, String deviceUUID, int errorCode) {
        this.utilDao.updateBackBatch(cloudId, backupBatchId, status, errorCode);
        Device device = this.utilDao.getDeviceInfoByUUID(cloudId, deviceUUID);
        BackupBatch backupBatch = this.backUpImageDao.getBackupBatchById(cloudId, backupBatchId.toString());
        this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, backupBatch, errorCode);
    }

    private void updateBatchAttempt(int cloudId, BackupBatch batch, boolean isFirstAttempt, boolean startOp, boolean overLoad, boolean licenseExpired) {
        block28: {
            try {
                BackupBatch backupBatch = this.backUpImageDao.getBackupBatchById(cloudId, batch.getId().toString());
                if (backupBatch != null) {
                    logger.debug(isFirstAttempt + "........updateBatchAttempt.status........" + backupBatch.getStatus());
                    if (isFirstAttempt) {
                        BackupAttempt attempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
                        attempt.setBatchId(backupBatch.getId().toString());
                        attempt.setId(null);
                        attempt.setErrorCode("0");
                        this.utilDao.saveBackupAttempt(cloudId, attempt);
                        break block28;
                    }
                    if (overLoad || licenseExpired) {
                        BackupAttempt bkpAttempt = this.utilDao.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                        logger.debug(backupBatch.getErrorCode() + "........overLoad........" + bkpAttempt);
                        if (bkpAttempt != null && ("SCANNING".equalsIgnoreCase(bkpAttempt.getStatus()) || INTERRUPTED_STATUS.equalsIgnoreCase(bkpAttempt.getStatus()))) {
                            logger.debug("....stats Type..." + bkpAttempt.getStatus());
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            BackupAttempt attempt = new BackupAttempt();
                            BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
                            attempt.setBatchId(backupBatch.getId().toString());
                            attempt.setId(null);
                            attempt.setBatchStartTimestamp(System.currentTimeMillis());
                            attempt.setErrorCode("1996");
                            attempt.setStatus(INTERRUPTED_STATUS);
                            attempt.setBatchEndTimestamp(System.currentTimeMillis());
                            attempt.setNoOfFiles(0L);
                            attempt.setTotalNoOfFiles(0L);
                            String currentUploadedFilesStatus = "";
                            int uploadedFiles = 0;
                            int updatedUploadedFiles = 0;
                            if (StringUtils.isEmpty((String)attempt.getUploadedFiles())) {
                                currentUploadedFilesStatus = uploadedFiles + "/" + attempt.getTotalNoOfFiles();
                            } else {
                                String[] parts = backupBatch.getUploadedFiles().split("/");
                                try {
                                    Integer prevBkpFiles = Integer.parseInt(parts[0]);
                                    if (prevBkpFiles != null) {
                                        updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                                    }
                                    currentUploadedFilesStatus = updatedUploadedFiles + "/" + attempt.getTotalNoOfFiles();
                                }
                                catch (Exception e) {
                                    logger.trace("Exception  :" + e);
                                    logger.error("Exception  :" + e.getMessage());
                                }
                            }
                            logger.debug(backupBatch.getUploadedFiles() + ".......currentUploadedFilesStatus......" + currentUploadedFilesStatus);
                            logger.debug(attempt.getId() + ".......currentUploadedFilesStatus backupbatch......" + backupBatch.getStatus());
                            attempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            attempt.setUploadedSize(backupBatch.getUploadedSize());
                            attempt.setStatus(backupBatch.getStatus());
                            this.utilDao.saveBackupAttempt(cloudId, attempt);
                            logger.debug("....SCANNING Type completed...");
                            break block28;
                        }
                        if (bkpAttempt != null) {
                            logger.debug(backupBatch.getUploadedFiles() + "........overLoad.attempt......." + bkpAttempt.getUploadedSize());
                            if (licenseExpired) {
                                bkpAttempt.setErrorCode("1501");
                            } else if ("PAUSED".equalsIgnoreCase(backupBatch.getStatus())) {
                                bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                            } else {
                                bkpAttempt.setErrorCode("1996");
                            }
                            bkpAttempt.setUploadedSize(bkpAttempt.getUploadedSize());
                            bkpAttempt.setStatus(INTERRUPTED_STATUS);
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            this.utilDao.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        break block28;
                    }
                    if (!backupBatch.getStatus().equals("STARTED")) {
                        BackupAttempt bkpAttempt = this.utilDao.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                        logger.debug(backupBatch.getErrorCode() + ".........attempt vla........" + bkpAttempt.toString());
                        if (bkpAttempt != null) {
                            if (bkpAttempt.getStatus().equalsIgnoreCase("SCANNING")) {
                                bkpAttempt.setErrorCode("0");
                            } else {
                                bkpAttempt.setErrorCode(backupBatch.getErrorCode());
                            }
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            bkpAttempt.setStatus(backupBatch.getStatus());
                            bkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                            bkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                            bkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                            this.utilDao.saveBackupAttempt(cloudId, bkpAttempt);
                        }
                        if (bkpAttempt != null && startOp && bkpAttempt.getStatus().equalsIgnoreCase("STARTED")) {
                            logger.debug("...update code ..." + backupBatch.getErrorCode());
                            this.utilDao.updateAttemptForRestart(cloudId, bkpAttempt.getId(), backupBatch.getErrorCode());
                        }
                        break block28;
                    }
                    BackupAttempt attempt = this.utilDao.getLastBackupAttemptById(cloudId, backupBatch.getId().toString());
                    logger.debug(startOp + "..." + attempt.getStatus() + ".........attempt..new logic......" + attempt.toString());
                    if (attempt != null) {
                        BackupAttempt lastBkpAttempt = new BackupAttempt();
                        BeanUtils.copyProperties((Object)backupBatch, (Object)lastBkpAttempt);
                        lastBkpAttempt.setBatchStartTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setBatchEndTimestamp(System.currentTimeMillis());
                        lastBkpAttempt.setNoOfFiles(0L);
                        lastBkpAttempt.setTotalNoOfFiles(0L);
                        lastBkpAttempt.setBatchId(backupBatch.getId().toString());
                        lastBkpAttempt.setId(null);
                        String currentUploadedFilesStatus = "";
                        int uploadedFiles = 0;
                        int updatedUploadedFiles = 0;
                        if (StringUtils.isEmpty((String)lastBkpAttempt.getUploadedFiles())) {
                            currentUploadedFilesStatus = uploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                        } else {
                            String[] parts = backupBatch.getUploadedFiles().split("/");
                            try {
                                Integer prevBkpFiles = Integer.parseInt(parts[0]);
                                if (prevBkpFiles != null) {
                                    updatedUploadedFiles = uploadedFiles + prevBkpFiles;
                                }
                                currentUploadedFilesStatus = updatedUploadedFiles + "/" + lastBkpAttempt.getTotalNoOfFiles();
                            }
                            catch (Exception e) {
                                logger.trace("Exception  :" + e);
                                logger.error("Exception  :" + e.getMessage());
                            }
                        }
                        logger.debug(backupBatch.getUploadedFiles() + ".......currentUploadedFilesStatus......" + currentUploadedFilesStatus);
                        logger.debug(lastBkpAttempt.getId() + ".......currentUploadedFilesStatus backupbatch......" + backupBatch.getStatus());
                        lastBkpAttempt.setUploadedFiles(backupBatch.getUploadedFiles());
                        lastBkpAttempt.setUploadedSize(backupBatch.getUploadedSize());
                        lastBkpAttempt.setStatus(backupBatch.getStatus());
                        this.utilDao.saveBackupAttempt(cloudId, lastBkpAttempt);
                    }
                    if (attempt != null && startOp && attempt.getStatus().equalsIgnoreCase("STARTED")) {
                        this.utilDao.updateAttemptForRestart(cloudId, attempt.getId(), backupBatch.getErrorCode());
                    }
                    break block28;
                }
                logger.debug("...else attempt..... ");
            }
            catch (Exception e) {
                logger.trace("Error failed to save BackupAttempt ..." + e);
                logger.error("Error failed to save BackupAttempt ..." + e);
            }
        }
    }

    private String findSPFiles(int cloudId, String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy spPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String siteId, String productType, Cloud cloud) {
        logger.debug(siteId + "... before drive..." + deviceUUID);
        ArrayList<String> listIds = new ArrayList<String>();
        String siteName = "";
        List existListId = new ArrayList();
        HashMap<String, String> listMap = new HashMap<String, String>();
        try {
            Site site = null;
            try {
                site = (Site)this.retryPolicyFactory.executeWithRetry(() -> this.getGraphClient().sites(siteId).buildRequest(new Option[0]).get());
            }
            catch (GraphServiceException e) {
                e.printStackTrace();
                logger.error("..error..." + e.getMessage());
                logger.debug("..site not availabe latest ...." + e.getResponseCode());
                if (e.getResponseCode() == 404) {
                    AuditHistory audit = new AuditHistory();
                    audit.setAction(" blocked the SharePoint Online site " + userName + "  - unable to find the SharePoint site ");
                    audit.setActionByUserName("AUTO");
                    audit.setTimestamp(System.currentTimeMillis());
                    audit.setActionType(14);
                    this.saveStatisticToDatabase(cloudId, audit);
                    Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
                    this.deviceDao.blockUnblockDevice(cloudId, siteName, device, true);
                    this.createBatchForFailedSP(cloudId, deviceUUID, userName, spPolicy);
                }
            }
            catch (Exception e) {
                logger.error("..error..." + e.getMessage());
                logger.debug("..site not availabe ....");
            }
            if (this.isBkpStopped(cloudId, batchId)) {
                return "";
            }
            siteName = site.displayName;
            logger.debug(site.displayName + "... before site..." + site.name);
            existListId = this.msUtilDao.getListIdsForSiteId(siteId);
            ListCollectionPage listCollectionPage = (ListCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (ListCollectionPage)((ListCollectionRequest)this.getGraphClient().sites(siteId).lists().buildRequest(new Option[0])).get());
            List currentListPageVal = null;
            ListCollectionRequestBuilder nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
            do {
                currentListPageVal = listCollectionPage.getCurrentPage();
                for (com.microsoft.graph.models.List list : listCollectionPage.getCurrentPage()) {
                    if (!"documentLibrary".equals(list.list.template)) continue;
                    listIds.add(list.id);
                    listMap.put(list.id, list.name);
                    logger.debug(list.name + "....list.." + list.displayName + ".." + list.id);
                    existListId.remove(list.id);
                }
                nextListPage = (ListCollectionRequestBuilder)listCollectionPage.getNextPage();
                if (nextListPage == null) continue;
                listCollectionPage = (ListCollectionPage)((ListCollectionRequest)nextListPage.buildRequest(new Option[0])).get();
            } while (StringUtils.isEmpty((String)siteId) && currentListPageVal.size() > 0 && nextListPage != null && listCollectionPage != null && nextListPage != null);
        }
        catch (Exception e) {
            logger.error("..error..." + e.getMessage());
        }
        listIds.addAll(existListId);
        List siteDpLists = this.msUtilDao.getDeltaTokenForSite(siteId);
        if (CollectionUtils.isEmpty((Collection)siteDpLists) && (isFullBackup = true)) {
            this.msUtilDao.updateFullBkpforBatch(cloudId, batchId);
        }
        for (String listId : listIds) {
            if (this.isBkpStopped(cloudId, batchId)) {
                return "";
            }
            String siteListName = siteName + "/" + (String)listMap.get(listId);
            siteListName = (String)listMap.get(listId);
            SiteDeltaPath deltaPath = this.msUtilDao.getDeltaTokenForSiteAndList(siteId, listId);
            deltaToken = "";
            if (!isFullBackup) {
                if (deltaPath != null) {
                    logger.debug("...delta tokennnnnn...." + deltaPath.getDeltaToken());
                    deltaToken = deltaPath.getDeltaToken();
                    if (StringUtils.isEmpty((String)siteListName)) {
                        siteListName = deltaPath.getSiteName();
                    }
                }
            } else {
                deltaToken = "";
            }
            try {
                logger.debug(siteListName + "....." + siteId + "...listtoken..." + listId + "...." + deltaToken);
                logger.debug(isFullBackup + "....." + siteListName + "...listitera..." + listId + "...." + deltaToken);
                deltaToken = this.getSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, siteId, listId, siteListName, productType, cloud);
            }
            catch (GraphServiceException ee) {
                logger.error("...response code ....wait 2 mins.." + ee.getResponseCode());
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.debug(" graph service exception found so retry ..... ");
                deltaToken = this.getSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, siteId, listId, siteListName, productType, cloud);
            }
            catch (Exception ee) {
                logger.debug(" od files exception found so retry ..... ");
                deltaToken = this.getSPFiles(cloudId, deviceUUID, deltaToken, userName, spPolicy, isFullBackup, deviceDestCollection, backupBatch, batchId, eventHubId, siteId, listId, siteListName, productType, cloud);
            }
            this.msUtilDao.updateDeltaTokenForSiteAndList(siteId, listId, deltaToken, siteListName);
        }
        return deltaToken;
    }

    private String getSPFiles(int cloudId, String deviceUUID, String deltaToken, String userName, OfficeBackupPolicy spPolicy, boolean isFullBackup, String deviceDestCollection, ODBBackupBatch backupBatch, String batchId, String eventHubId, String siteId, String listId, String siteName, String productType, Cloud cloud) {
        LinkedList<QueryOption> reqOptions;
        LinkedList<QueryOption> requestOptions = null;
        String deltaLink = "";
        DriveItemDeltaCollectionPage deltaPage = null;
        logger.debug("... getSPFiles..." + userName);
        try {
            if (!StringUtils.isEmpty((String)deltaToken)) {
                logger.debug("...inside delta...." + deltaToken);
                DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
                driveItemDeltaParameterSet.token = deltaToken;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            } else {
                logger.debug("...empty delta...." + deltaToken);
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta().buildRequest(new Option[0])).get());
                logger.debug("...after empty delta...." + deltaToken);
            }
        }
        catch (Error e) {
            logger.error(deviceUUID + " ... unable to get drive so pause for 1 min ... " + userName + "..." + siteName);
        }
        catch (GraphServiceException e) {
            logger.debug("...graph response code...." + e.getResponseCode());
            logger.error(e.getResponseCode() + " ...inside GraphServiceException unable to get drive so pause for 1 min ... " + userName + "...devuuid.." + siteName + "...list..." + listId);
            if (e.getResponseCode() == 404) {
                logger.debug("....unable to get list... we have to delete..." + listId);
                logger.debug("...graph response code...." + siteName + "..." + deviceUUID + "...." + deviceDestCollection);
                try {
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageFolder(cloudId, siteName, "", deviceDestCollection, deviceUUID);
                    if (backUpImageold != null) {
                        logger.debug("..deleted lst...." + backUpImageold.getId().toString());
                        BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                        String newPathVal = backUpImageold.getDevicePath() + "/" + backUpImageold.getFileName();
                        if (StringUtils.isEmpty((String)backUpImageold.getDevicePath())) {
                            newPathVal = backUpImageold.getFileName();
                        }
                        String newDevPath = newPathVal;
                        logger.debug("..deleted lst child path...." + newPathVal);
                        List children = this.msUtilDao.getChildrenByFolder(cloudId, newPathVal, backUpImageold.getDeviceUUID(), deviceDestCollection);
                        if (!CollectionUtils.isEmpty((Collection)children)) {
                            children.forEach(image -> {
                                List subChildreFolders;
                                logger.debug("..... deleting child images.... " + image.getDevicePath() + ".." + image.getFileName());
                                BackUpImage deletedBkpImageChild = this.convertToBkpImage(image.getDeviceUUID(), (BackUpImage)image);
                                this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImageChild, deviceDestCollection);
                                if (image.isFolder() && !CollectionUtils.isEmpty((Collection)(subChildreFolders = this.msUtilDao.getALLSubChildrenByFolder(cloudId, newDevPath, backUpImageold.getDeviceUUID(), deviceDestCollection)))) {
                                    subChildreFolders.forEach(subimage -> {
                                        logger.debug("..... deleting child images sub.... " + subimage.getDevicePath() + ".." + subimage.getFileName());
                                        BackUpImage deletedSubBkpImageChild = this.convertToBkpImage(subimage.getDeviceUUID(), (BackUpImage)subimage);
                                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedSubBkpImageChild, deviceDestCollection);
                                    });
                                }
                            });
                        }
                    }
                }
                catch (Exception e1) {
                    logger.error(".. error trying to save deleted bkp image...." + e1.getMessage());
                }
                this.msUtilDao.deleteDeltaTokenForSiteAndList(siteId, listId);
                logger.debug(siteId + "...deleted site.. so return..." + listId);
                return "";
            }
            if (e.getResponseCode() == 403) {
                logger.debug("403...check for permisiion for user ..." + userName);
                return deltaToken;
            }
            if (e.getResponseCode() == 410) {
                logger.debug("...token is out of sync .. so empty delta....");
                deltaToken = "";
                isFullBackup = true;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            logger.debug(deviceUUID + "... retry for site ...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                requestOptions = new LinkedList();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                reqOptions = requestOptions;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta().buildRequest((List)reqOptions).get());
            } else {
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta().buildRequest(new Option[0])).get());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ...inside Exception unable to get drive so pause for 1 min ... " + userName);
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException reqOptions2) {
                // empty catch block
            }
            logger.debug("... retry for site...");
            if (!StringUtils.isEmpty((String)deltaToken)) {
                requestOptions = new LinkedList<QueryOption>();
                requestOptions.add(new QueryOption("token", (Object)deltaToken));
                reqOptions = requestOptions;
                deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta().buildRequest((List)reqOptions).get());
            }
            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta().buildRequest(new Option[0])).get());
        }
        logger.debug("... after deltapage..." + deltaPage);
        boolean isNextPageExists = false;
        List currentPage = null;
        int i = 0;
        int totalFiles = 0;
        do {
            if (this.isBkpStopped(cloudId, batchId)) {
                return "";
            }
            spPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, spPolicy.getPolicyType());
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(spPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + spPolicy.getMsAppBluKrypt());
                return "DIFF-BLUKRYPT";
            }
            currentPage = deltaPage.getCurrentPage();
            logger.debug("... after currentpage...");
            ArrayList<DriveItem> newList = new ArrayList<DriveItem>();
            newList.addAll(currentPage);
            int noOfFiles = this.handleItemsForSP(newList, deviceUUID, userName, cloudId, spPolicy, isFullBackup, deviceDestCollection, false, backupBatch, batchId, eventHubId, siteId, listId, siteName, productType, cloud);
            logger.debug(i + "... itempage size... " + currentPage.size());
            logger.debug(noOfFiles + "...total files processedd...." + (totalFiles += noOfFiles));
            deltaLink = deltaPage.deltaLink();
            DriveItemDeltaCollectionRequestBuilder nextPage = (DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage();
            logger.debug("....before deltalink.... " + deltaLink);
            if (deltaLink == null) {
                logger.error("... delta link is null... " + nextPage.getRequestUrl());
                String serviceRoot = " https://graph.microsoft.com";
                deltaLink = ((DriveItemDeltaCollectionRequestBuilder)deltaPage.getNextPage()).getRequestUrl().replaceFirst(serviceRoot, "");
            }
            logger.debug("....after deltalink.... " + deltaLink);
            deltaToken = MSServiceImpl.getDeltaToken(deltaLink);
            logger.debug("...token...val..." + deltaToken);
            DriveItemDeltaParameterSet driveItemDeltaParameterSet = new DriveItemDeltaParameterSet();
            driveItemDeltaParameterSet.token = deltaToken;
            deltaPage = (DriveItemDeltaCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (DriveItemDeltaCollectionPage)((DriveItemDeltaCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().root().delta(DriveItemDeltaParameterSet.newBuilder().withToken(driveItemDeltaParameterSet.token).build()).buildRequest(new Option[0])).get());
            logger.debug("... after currentpage deltaToken...");
            ++i;
            if (currentPage.size() <= 0 || nextPage == null) break;
            isNextPageExists = true;
            this.msUtilDao.updateDeltaTokenForSiteAndList(siteId, listId, deltaToken, siteName);
        } while (isNextPageExists);
        return deltaToken;
    }

    private int handleItemsForSP(List<DriveItem> currentPage, String deviceUUID, String userName, int cloudId, OfficeBackupPolicy spPolicy, boolean isFullBackup, String deviceDestCollection, boolean isMail, ODBBackupBatch backupBatch, String batchId, String eventHubId, String siteId, String listId, String siteName, String productType, Cloud cloud) {
        int file = 0;
        int folder = 0;
        int noOfFiles = 0;
        int totalSizeToUpload = 0;
        ArrayList<DriveItem> folders = new ArrayList<DriveItem>();
        HashMap<String, String> folderMap = new HashMap<String, String>();
        for (DriveItem driveItem : currentPage) {
            boolean allow;
            Deleted deleted = driveItem.deleted;
            if (deleted != null) continue;
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder == null) continue;
            String basePath = "";
            String itemName = driveItem.name;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                String folderPathVal = siteName + newPath;
                ++folder;
                folderMap.put(folderPathVal, driveItem.id);
            }
            if (isFullBackup || !(allow = this.handleSPFolderElement(basePath, basePath, spPolicy, deviceUUID, userName, cloudId, cloud))) continue;
            logger.debug("... folder allowed.... " + basePath + "..." + allow);
            folders.add(driveItem);
        }
        int i = 0;
        logger.debug("......folders.... " + folders.size());
        logger.debug("... files to process... " + currentPage.size());
        boolean isLinkPolicyEnabled = false;
        if (spPolicy != null && spPolicy.isCreateLinkEnabled()) {
            isLinkPolicyEnabled = true;
        }
        i = 0;
        for (DriveItem driveItem : currentPage) {
            logger.debug(++i + "/" + currentPage.size() + "...items... " + driveItem.id);
            boolean isFolder = false;
            if (driveItem.folder != null) {
                isFolder = true;
            }
            String basePath = "";
            boolean isPresent = true;
            String itemName = driveItem.name;
            Deleted deleted = driveItem.deleted;
            if (deleted != null) {
                logger.debug(isLinkPolicyEnabled + "....handle deleted files case......" + driveItem.id);
                try {
                    BackUpImage deletedBkpImage;
                    String parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                    basePath = siteName + "/" + parentPath;
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, driveItem.id, basePath, deviceDestCollection, deviceUUID);
                    logger.debug(backUpImageold + "...deleted file...." + backUpImageold.isLinkGenerated());
                    if (backUpImageold != null && !backUpImageold.isLinkGenerated()) {
                        deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                        this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                    }
                    if (backUpImageold == null || !isLinkPolicyEnabled) continue;
                    deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                    this.msUtilDao.checkAndDeleteCPFile(cloudId, driveItem.id, deviceUUID, productType, deletedBkpImage, deviceDestCollection);
                }
                catch (Exception e) {
                    logger.error(".. error trying to save deleted bkp image...." + e.getMessage());
                }
                continue;
            }
            if (!StringUtils.isEmpty((String)driveItem.name) && driveItem.name.equalsIgnoreCase("root")) {
                logger.debug("...rooot vaal so skip...");
                continue;
            }
            if (driveItem.folder != null) continue;
            if (driveItem.folder != null && !StringUtils.isEmpty((String)itemName) && !driveItem.name.equalsIgnoreCase("root")) {
                String parentPath;
                basePath = parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                String newPath = parentPath + "/" + driveItem.name;
                ++folder;
            } else if (driveItem.file != null) {
                ++file;
                String parentPath = StringUtils.substringAfterLast((String)driveItem.parentReference.path, (String)"root:");
                basePath = siteName + "/" + parentPath;
            }
            if (StringUtils.isEmpty((String)basePath)) {
                basePath = "";
            }
            boolean isFileAllowed = this.handleSPElement(basePath, itemName, driveItem.size, spPolicy, deviceUUID, userName, cloudId, isMail);
            String appDisplayName = PCHelperConstant.getGraphAppName();
            logger.debug("...graph app name...." + appDisplayName);
            if (itemName.endsWith(".url") && driveItem.lastModifiedBy != null && driveItem.lastModifiedBy.application != null && driveItem.lastModifiedBy.application.displayName != null && (driveItem.lastModifiedBy.application.displayName.contains("Parablu Inc") || driveItem.lastModifiedBy.application.displayName.contains("Microsoft Graph") || !StringUtils.isEmpty((String)appDisplayName) && driveItem.lastModifiedBy.application.displayName.equals(appDisplayName))) continue;
            if (!isFileAllowed) {
                logger.debug("...file cannot be allowed... " + itemName);
                continue;
            }
            boolean backupAllVersions = spPolicy.isBackupAllVersions();
            int driveItemSize = driveItem.size.intValue();
            if (backupAllVersions) {
                int maxVersions = spPolicy.getCrawlVersions();
                logger.debug(maxVersions + "..crawlversions....." + driveItem.name + "......" + driveItem.id + "..." + driveItem.deleted + "...site and list....." + siteId + "..." + listId);
                DriveItemVersionCollectionPage driveItemVersionCollectionPage = (DriveItemVersionCollectionPage)((DriveItemVersionCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().items(driveItem.id).versions().buildRequest(Arrays.asList(new QueryOption("$top", (Object)maxVersions)))).get();
                ListItemVersionCollectionPage listItemVersionCollectionPage1 = (ListItemVersionCollectionPage)((ListItemVersionCollectionRequest)this.getGraphClient().sites(siteId).lists(listId).drive().items(driveItem.id).listItem().versions().buildRequest(Arrays.asList(new QueryOption("$top", (Object)maxVersions)))).get();
                ArrayList<String> versionIdList = new ArrayList<String>();
                HashMap<String, Long> versionDateMap = new HashMap<String, Long>();
                HashMap<String, Long> versionSizeMap = new HashMap<String, Long>();
                HashSet<String> itemDeleted = new HashSet<String>();
                if (driveItemVersionCollectionPage == null) continue;
                List currentVersionsPage = driveItemVersionCollectionPage.getCurrentPage();
                for (DriveItemVersion driveItemVersion : currentVersionsPage) {
                    boolean checkLastVersionIsDeleted;
                    BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemIdAndVersionId(cloudId, driveItem.id, driveItemVersion.id, deviceDestCollection, deviceUUID);
                    if ((basePath = basePath.replaceAll("//", "/")).endsWith("/")) {
                        basePath = basePath.substring(0, basePath.lastIndexOf(47));
                    }
                    if (!(backUpImageold == null || basePath.equalsIgnoreCase(backUpImageold.getDevicePath()) && driveItem.name.equalsIgnoreCase(backUpImageold.getFileName()))) {
                        basePath = basePath.replaceAll("//", "/");
                        logger.debug(basePath + "......file already exists but moved......" + backUpImageold.getDevicePath());
                        if (itemDeleted.contains(driveItem.id)) continue;
                        if (backUpImageold != null && !backUpImageold.isLinkGenerated()) {
                            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                            itemDeleted.add(driveItem.id);
                        }
                        backUpImageold = null;
                    }
                    if (backUpImageold != null && (checkLastVersionIsDeleted = this.msUtilDao.isLastVersionDeletedForItemId(cloudId, driveItem.id, deviceUUID, deviceDestCollection))) {
                        logger.debug("....last version deleted so backup again ...." + driveItem.name);
                        backUpImageold = null;
                    }
                    if (backUpImageold != null) break;
                    logger.debug(".....driveitem and version....." + driveItem.name + "...." + driveItemVersion.id);
                    versionIdList.add(driveItemVersion.id);
                    if (driveItemVersion.lastModifiedDateTime != null) {
                        versionDateMap.put(driveItemVersion.id, driveItemVersion.lastModifiedDateTime.toInstant().toEpochMilli());
                    }
                    versionSizeMap.put(driveItemVersion.id, driveItemVersion.size);
                }
                versionIdList.sort((v1, v2) -> {
                    String[] version1 = v1.split("\\.");
                    String[] version2 = v2.split("\\.");
                    int majorCompare = Integer.compare(Integer.parseInt(version1[0]), Integer.parseInt(version2[0]));
                    if (majorCompare != 0) {
                        return majorCompare;
                    }
                    int minor1 = version1.length > 1 ? Integer.parseInt(version1[1]) : 0;
                    int minor2 = version2.length > 1 ? Integer.parseInt(version2[1]) : 0;
                    return Integer.compare(minor1, minor2);
                });
                for (String string : versionIdList) {
                    DriveFileInfo driveFileInfo = this.createDriveFileInforOd(deviceUUID, userName, isFullBackup, batchId, siteId, listId, folderMap, driveItem, isFolder, basePath, isPresent, itemName, string);
                    if (versionDateMap.get(string) != null) {
                        driveFileInfo.setO365LastModifiedTime(((Long)versionDateMap.get(string)).longValue());
                    }
                    if (versionSizeMap.get(string) != null) {
                        driveItemSize = ((Long)versionSizeMap.get(string)).intValue();
                    }
                    totalSizeToUpload += driveItemSize;
                    boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
                    this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
                    if (!itemSaved) continue;
                    ++noOfFiles;
                }
                continue;
            }
            DriveFileInfo driveFileInfo = this.createDriveFileInforOd(deviceUUID, userName, isFullBackup, batchId, siteId, listId, folderMap, driveItem, isFolder, basePath, isPresent, itemName, "");
            totalSizeToUpload += driveItemSize;
            boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
            this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
            if (!itemSaved) continue;
            ++noOfFiles;
        }
        folderMap.forEach((path, itemId) -> {
            FolderFileInfo folderFileInfo = new FolderFileInfo();
            folderFileInfo.setItemId(itemId);
            folderFileInfo.setItemPath(path);
            folderFileInfo.setDeviceUUID(backupBatch.getDeviceUUID());
            this.msUtilDao.saveFolderItem(folderFileInfo);
        });
        logger.debug(folder + ".....folder + file......." + file);
        logger.debug(".....nooffiles....." + noOfFiles);
        return noOfFiles;
    }

    private DriveFileInfo createDriveFileInforOd(String deviceUUID, String userName, boolean isFullBackup, String batchId, String siteId, String listId, Map<String, String> folderMap, DriveItem driveItem, boolean isFolder, String basePath, boolean isPresent, String itemName, String versionId) {
        DriveFileInfo driveFileInfo = new DriveFileInfo();
        driveFileInfo.setDeviceUUID(deviceUUID);
        String folderPath = basePath;
        folderPath = folderPath.replaceAll("//", "/");
        driveFileInfo.setItemPath(folderPath);
        driveFileInfo.setItemName(itemName);
        driveFileInfo.setItemId(driveItem.id);
        driveFileInfo.setSharePoint(true);
        driveFileInfo.setSiteId(siteId);
        driveFileInfo.setListId(listId);
        if (!StringUtils.isEmpty((String)versionId)) {
            driveFileInfo.setVersionId(versionId);
        }
        driveFileInfo.setFolder(isFolder);
        driveFileInfo.setFilePresent(isPresent);
        driveFileInfo.setOperation("FILE");
        driveFileInfo.setBackupBatchId(batchId);
        driveFileInfo.setFullBackup(isFullBackup);
        String folderItemId = "";
        if (folderMap.get(folderPath) != null) {
            folderItemId = folderMap.get(folderPath);
        }
        if (driveItem.lastModifiedDateTime != null) {
            driveFileInfo.setO365LastModifiedTime(driveItem.lastModifiedDateTime.toInstant().toEpochMilli());
        } else {
            driveFileInfo.setO365LastModifiedTime(driveItem.createdDateTime.toInstant().toEpochMilli());
        }
        driveFileInfo.setParentItemId(folderItemId);
        driveFileInfo.setUserName(userName);
        driveFileInfo.setSize(driveItem.size);
        return driveFileInfo;
    }

    public boolean handleSPElement(String path, String fileName, Long fileSize, OfficeBackupPolicy spPolicy, String deviceUUID, String userName, int cloudId, boolean isMail) {
        boolean skipFileBasedonSize;
        boolean allow = false;
        path = path.toLowerCase();
        fileName = fileName.toLowerCase();
        if (spPolicy.isLegalHoldEnabled()) {
            logger.debug("...allow all .. becoz legal hold enabled ...");
            return true;
        }
        ArrayList<BackupFolders> inclusionbackupFolders = spPolicy.getBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForOdbBackupFolders(path, path, inclusionbackupFolders);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = spPolicy.getExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(path, path, excludedFolders);
        if (!allow) {
            logger.error("... file not under excluded path..." + path);
            return allow;
        }
        allow = this.checkForExtensions(fileName, spPolicy.getInclusionFilter(), spPolicy.getFilterType());
        if (!allow) {
            logger.error("... file not allowed becoz of extension..." + fileName);
            return allow;
        }
        if (!isMail && (skipFileBasedonSize = MSServiceImpl.checkFileSize(fileSize, Long.parseLong(spPolicy.getMaxFileSize())))) {
            logger.error(".. file size is bigger for onedrive..." + fileSize + "....." + spPolicy.getMaxFileSize());
            return false;
        }
        return allow;
    }

    public boolean handleSPFolderElement(String actualPath, String path, OfficeBackupPolicy spPolicy, String deviceUUID, String userName, int cloudId, Cloud cloud) {
        boolean allow = false;
        path = path.toLowerCase();
        if (spPolicy.isLegalHoldEnabled()) {
            logger.debug("...allow all .. becoz legal hold enabled ...");
            return true;
        }
        ArrayList<BackupFolders> inclusionbackupFolders = spPolicy.getBackupFolders();
        if (CollectionUtils.isEmpty((Collection)inclusionbackupFolders)) {
            inclusionbackupFolders = new ArrayList<BackupFolders>();
        }
        this.addDeviceLevelInclusion(deviceUUID, userName, cloudId, inclusionbackupFolders);
        allow = this.checkForBackupFolders(actualPath, path, inclusionbackupFolders, false, cloud);
        if (!allow) {
            return allow;
        }
        ArrayList<ExcludedFolders> excludedFolders = spPolicy.getExcludedFolders();
        if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
            excludedFolders = new ArrayList<ExcludedFolders>();
        }
        this.addDeviceLevelExclusion(deviceUUID, userName, cloudId, excludedFolders);
        allow = this.checkForPathNotExcluded(actualPath, path, excludedFolders);
        if (!allow) {
            return allow;
        }
        return allow;
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllSitesForOfficeBackupPolicy(int cloudId, String policyName) {
        return this.userDao.getAllSitesForOfficeBackupPolicy(cloudId, policyName);
    }

    private static List<Folder> findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, List<Folder> archivelistFolderItems, Map<String, String> folderPathMap) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = IN_PLACE_ARCHIVE + parentPath + "/" + subFolder.getDisplayName();
                logger.debug("...before replacepath..." + path);
                path = path.replaceAll(IN_PLACE_ARCHIVE, "");
                for (int i = 0; i < 15; ++i) {
                    if (!path.startsWith("/")) continue;
                    path = path.replaceFirst("/", "");
                }
                logger.debug("...after replacepath..." + path);
                path = IN_PLACE_ARCHIVE + path;
                logger.debug(path + ".....folder...." + subFolder.getDisplayName());
                archivelistFolderItems.add(subFolder);
                folderPathMap.put(subFolder.getId().getUniqueId(), path);
                MSServiceImpl.findAllSubFolders(service, subFolder.getId(), path, archivelistFolderItems, folderPathMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return archivelistFolderItems;
    }

    private int handleEWSInPlaceMailArchive(String userName, String emailId, int cloudId, List<Folder> archivelistFolderItems, int noOfFiles, String deviceUUID, String batchId, String userFoundId, String eventHubId, String deviceDestCollection, OfficeBackupPolicy officeBackupPolicy, boolean isFullBkp, Cloud cloud) {
        logger.debug("....handleEWSInPlaceMailArchive....." + emailId);
        ArrayList driveList = new ArrayList();
        String token = this.getEWSToken(cloudId);
        ExchangeService service = MSServiceImpl.getAuthenticatedService(token, emailId);
        Mailbox userMailbox = new Mailbox(emailId);
        logger.debug(userName + "...user maillate ...." + userMailbox);
        FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
        FindFoldersResults inPlaceFolders = null;
        HashMap<String, String> folderPathMap = new HashMap<String, String>();
        try {
            logger.debug("....before service findfolders....." + userMailbox);
            boolean isInPlaceEnabled = true;
            try {
                inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            }
            catch (ServiceResponseException exception) {
                Thread.sleep(15000L);
                token = this.getEWSToken(cloudId);
                service = MSServiceImpl.getAuthenticatedService(token, emailId);
                inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
                isInPlaceEnabled = false;
            }
            if (!isInPlaceEnabled) {
                logger.error(".....inplace archive disabled ");
                return 0;
            }
            logger.debug(".....parent archive ... " + folderId.getUniqueId());
            LinkedList<String> inputIdsList = new LinkedList<String>();
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                inputIdsList.add(folder.getId().getUniqueId());
                archivelistFolderItems.add(folder);
                folderPathMap.put(folder.getId().getUniqueId(), IN_PLACE_ARCHIVE + folder.getDisplayName());
                MSServiceImpl.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), archivelistFolderItems, folderPathMap);
            }
            logger.debug("......inplace after ... " + archivelistFolderItems.size());
            HashSet<String> idSet = new HashSet<String>();
            int ijj = 0;
            for (Folder folder : archivelistFolderItems) {
                String parentPath;
                String folPath = (String)folderPathMap.get(folder.getId().getUniqueId());
                logger.debug("...iteratingfoldpathlatest..." + ijj + "..." + folPath);
                String actualPath = parentPath = folPath;
                if (folPath.contains("/")) {
                    String[] parentPatharr = folPath.split("/");
                    parentPath = "/" + parentPatharr[0];
                }
                logger.debug(actualPath + "..trying path...." + parentPath);
                boolean isFileAllowed = this.handleMailElement(actualPath, parentPath, officeBackupPolicy, deviceUUID, userName, cloudId, true, cloud);
                logger.debug(folPath + "..." + isFileAllowed);
                if (!isFileAllowed) {
                    logger.debug("...path cannot be allowed... " + folPath);
                    continue;
                }
                ++ijj;
                idSet.add(folder.getId().getUniqueId());
            }
            int ifol = 0;
            int ifolderFiles = 0;
            for (String folderUniqueId : idSet) {
                ifolderFiles = 0;
                boolean hasMoreItems = false;
                String folPath = (String)folderPathMap.get(folderUniqueId);
                logger.debug(++ifol + "/" + archivelistFolderItems.size() + ".... startfolder .... " + folPath);
                String syncState = "";
                if (!isFullBkp) {
                    syncState = this.msUtilDao.getDeltaLinkForPathAndUser(folPath, userName);
                }
                Iterator iterator = null;
                logger.debug(folPath + ".....delta-token....." + syncState);
                do {
                    token = this.getEWSToken(cloudId);
                    service = MSServiceImpl.getAuthenticatedService(token, emailId);
                    ChangeCollection syncFolderItems = null;
                    try {
                        syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 400, SyncFolderItemsScope.NormalItems, syncState);
                    }
                    catch (ServiceResponseException ee) {
                        if (ee.getMessage().contains("Synchronization state data is corrupt or otherwise invalid")) {
                            syncFolderItems = null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("...error parsing token for folder retry after 15 sec  " + folPath);
                        try {
                            Thread.sleep(45000L);
                            token = this.getEWSToken(cloudId);
                            service = MSServiceImpl.getAuthenticatedService(token, emailId);
                            syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 510, SyncFolderItemsScope.NormalItems, syncState);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (syncFolderItems == null) {
                        int i = 0;
                        do {
                            try {
                                token = this.getEWSToken(cloudId);
                                service = MSServiceImpl.getAuthenticatedService(token, emailId);
                                syncFolderItems = service.syncFolderItems(new FolderId(folderUniqueId), PropertySet.FirstClassProperties, null, 510, SyncFolderItemsScope.NormalItems, syncState);
                            }
                            catch (ServiceResponseException ee) {
                                if (!ee.getMessage().contains("Synchronization state data is corrupt or otherwise invalid")) continue;
                                syncFolderItems = null;
                                i = 5;
                                this.msUtilDao.updateDeltaForPathAndUser(folPath, userName, "");
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                logger.debug(i + "...wait for 20 sec...." + emailId);
                                Thread.sleep(20000L);
                            }
                        } while (syncFolderItems == null && ++i < 5);
                    }
                    if (syncFolderItems == null) continue;
                    syncState = syncFolderItems.getSyncState();
                    logger.debug(folPath + "......inplace after ... " + noOfFiles);
                    iterator = syncFolderItems.iterator();
                    hasMoreItems = iterator.hasNext();
                    int i = 0;
                    officeBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, officeBackupPolicy.getPolicyType());
                    if (!PCHelperConstant.getComponentName().equalsIgnoreCase(officeBackupPolicy.getMsAppBluKrypt())) {
                        logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + officeBackupPolicy.getMsAppBluKrypt());
                        continue;
                    }
                    if (this.isBkpStopped(cloudId, batchId)) continue;
                    while (iterator.hasNext()) {
                        ItemChange next = (ItemChange)iterator.next();
                        Item item = next.getItem();
                        if (item == null) {
                            String deletedItemId = next.getItemId().getUniqueId();
                            logger.error("...item is deleted....." + deletedItemId);
                            BackUpImage backUpImageold = this.msUtilDao.getBackupImageForItemId(cloudId, deletedItemId, deviceDestCollection, deviceUUID);
                            if (backUpImageold == null) continue;
                            BackUpImage deletedBkpImage = this.convertToBkpImage(deviceUUID, backUpImageold);
                            this.msUtilDao.saveDeletedBackupImage(cloudId, deletedBkpImage, deviceDestCollection);
                            continue;
                        }
                        logger.debug(item.getSubject() + "....item state...." + ifol + "/" + archivelistFolderItems.size());
                        DriveFileInfo driveFileInfo = new DriveFileInfo();
                        driveFileInfo.setDeviceUUID(deviceUUID);
                        driveFileInfo.setBackupBatchId(batchId);
                        driveFileInfo.setItemPath(folPath);
                        driveFileInfo.setItemId(item.getId().getUniqueId());
                        driveFileInfo.setUserName(userName);
                        driveFileInfo.setUserMailId(emailId);
                        driveFileInfo.setInPlaceArchive(true);
                        driveFileInfo.setOperation("FILE");
                        driveFileInfo.setGraphUserId(userFoundId);
                        boolean itemSaved = this.msUtilDao.saveDriveItem(cloudId, driveFileInfo);
                        ++ifolderFiles;
                        if (itemSaved) {
                            ++noOfFiles;
                        }
                        ++i;
                    }
                    logger.debug(noOfFiles + "....files processed...." + i);
                    if (service != null) {
                        service.close();
                    }
                    if (this.isBkpStopped(cloudId, batchId)) continue;
                    officeBackupPolicy = this.userDao.getOfficeBackupPolicyForUserName(cloudId, userName, officeBackupPolicy.getPolicyType());
                    if (!PCHelperConstant.getComponentName().equalsIgnoreCase(officeBackupPolicy.getMsAppBluKrypt())) {
                        logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + officeBackupPolicy.getMsAppBluKrypt());
                        continue;
                    }
                    this.msUtilDao.updateDeltaForPathAndUser(folPath, userName, syncState);
                    logger.debug(".... before bulk save ...." + noOfFiles);
                    this.msUtilDao.updateEventHubTime(cloudId, eventHubId);
                    logger.debug(folPath + ".... after bulk save ...." + ifolderFiles);
                    driveList = new ArrayList();
                } while (hasMoreItems);
                logger.debug(folPath + "........folderfilesews...." + ifolderFiles);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("....error trying to get inplace archive folders ...." + e.getMessage());
        }
        return noOfFiles;
    }

    public String getEWSToken(int cloudId) {
        return this.msUtilDao.getEWSToken(cloudId);
    }

    private static void findAllSubFolders(ExchangeService service, FolderId parentFolderId, String parentPath, Map<String, String> folderPathMap) {
        try {
            FindFoldersResults foundFolders = service.findFolders(parentFolderId, new FolderView(Integer.MAX_VALUE));
            for (Folder subFolder : foundFolders) {
                String path = parentPath + "/" + subFolder.getDisplayName();
                logger.debug(path + ".....folder...." + subFolder.getDisplayName());
                folderPathMap.put(path, subFolder.getId().getUniqueId());
                MSServiceImpl.findAllSubFolders(service, subFolder.getId(), path, folderPathMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> getInPlaceArchiveFolders(ExchangeService service, String emailId) {
        HashMap<String, String> folderPathMapLatest = new HashMap<String, String>();
        logger.debug("...user..." + emailId);
        ArrayList<String> inplaceFolderPaths = new ArrayList<String>();
        try {
            Mailbox userMailbox = new Mailbox(emailId);
            FolderId folderId = new FolderId(WellKnownFolderName.ArchiveMsgFolderRoot, userMailbox);
            HashMap<String, String> folderPathMap = new HashMap<String, String>();
            FindFoldersResults inPlaceFolders = null;
            inPlaceFolders = service.findFolders(folderId, new FolderView(Integer.MAX_VALUE));
            LinkedList<String> inputIdsList = new LinkedList<String>();
            for (Folder folder : inPlaceFolders.getFolders()) {
                if (StringUtils.isEmpty((String)folder.getDisplayName()) || "PersonMetadata".equalsIgnoreCase(folder.getDisplayName()) || "Tasks".equalsIgnoreCase(folder.getDisplayName()) || "Calendar".equalsIgnoreCase(folder.getDisplayName())) continue;
                inputIdsList.add(folder.getId().getUniqueId());
                folderPathMap.put(folder.getDisplayName(), folder.getId().getUniqueId());
                logger.debug("foldersunderInplace..." + folder.getDisplayName());
                MSServiceImpl.findAllSubFolders(service, folder.getId(), folder.getDisplayName(), folderPathMap);
            }
            for (Map.Entry entry : folderPathMap.entrySet()) {
                String path = IN_PLACE_ARCHIVE + (String)entry.getKey();
                folderPathMapLatest.put(path, (String)entry.getValue());
                inplaceFolderPaths.add(path);
                logger.debug("......" + path + "...." + (String)entry.getValue());
            }
        }
        catch (Exception e) {
            logger.debug("....error trying to get inplace archive folders ...." + e.getMessage());
        }
        return folderPathMapLatest;
    }

    public static synchronized String getEWSAccesToken(String clientId, String secret, String tenantId) {
        String accessToken = "";
        try {
            long now = System.currentTimeMillis();
            ExecutorService es = Executors.newFixedThreadPool(2);
            AuthenticationContext context = new AuthenticationContext(AUTHORITY + tenantId, false, es);
            AuthenticationCallback callback = new AuthenticationCallback(){

                public void onSuccess(Object result) {
                    logger.debug("received token");
                }

                public void onFailure(Throwable exc) {
                    throw new RuntimeException(exc);
                }
            };
            logger.debug(tenantId + ".... requesting token ...." + clientId + "...." + secret);
            Future future = context.acquireToken(RESOURCE, new ClientCredential(clientId, secret), callback);
            AuthenticationResult result = (AuthenticationResult)future.get(30L, TimeUnit.SECONDS);
            accessToken = result.getAccessToken();
            logger.debug("...ews clientid and secret ...." + accessToken);
        }
        catch (Exception e) {
            logger.error("...error trying ...." + e.getMessage());
        }
        return accessToken;
    }

    @Override
    public void updateOverViewStatus(int cloudId, String actionToDeviceUUID, int errorCode) {
        this.msUtilDao.updateOverViewStatus(cloudId, actionToDeviceUUID, errorCode);
    }

    public void updateOverViewStatusScan(int cloudId, String actionToDeviceUUID, String status) {
        this.msUtilDao.updateOverViewStatusScan(cloudId, actionToDeviceUUID, status);
    }

    @Override
    public List<com.parablu.pcbd.domain.User> getAllUsers(int cloudId) {
        return this.userDao.getAllUsers(cloudId, "");
    }

    @Override
    public List<DeviceBackupOverView> getAllOfficeOverViews(int cloudId, String userName) {
        return this.deviceDao.getAllOfficeOverViews(cloudId, userName);
    }

    @Override
    public BackupBatch getLastBackupOnly(int cloudId, String userName, String deviceUUID) {
        return this.msUtilDao.getLastBackupOnly(cloudId, userName, deviceUUID);
    }

    @Override
    public UserPolicy getUserPolicy(String userName, String type) {
        return this.msUtilDao.getUserPolicy(userName, type);
    }

    @Override
    public void saveUserPolicy(UserPolicy userPolicy) {
        this.msUtilDao.saveUserPolicy(userPolicy);
    }

    @Override
    public void deleteUserPolicy(String userName, String policyType) {
        this.msUtilDao.deleteUserPolicy(userName, policyType);
    }

    @Override
    public void deleteUserAfterBackup(UsersWOBackup usersWOBackup) {
        this.msUtilDao.deleteUserAfterBackup(usersWOBackup);
    }

    @Override
    public void saveUserBeforeBackup(UsersWOBackup usersWOBackup) {
        this.msUtilDao.saveUserBeforeBackup(usersWOBackup);
    }

    public String getRootFolderId(String userId) {
        String rootFolderId;
        block11: {
            rootFolderId = "";
            String siteUrl = "https://graph.microsoft.com/v1.0/users/" + userId + "/mailFolders/msgfolderroot";
            logger.debug("...siteurl...." + siteUrl);
            try {
                Request request1 = new Request.Builder().url(siteUrl).build();
                OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
                Call call1 = okHttpClient.newCall(request1);
                Response response1 = call1.execute();
                int responseCode1 = response1.code();
                logger.debug("...response code..." + responseCode1);
                String bodyStr = response1.body().string();
                logger.debug("...." + bodyStr);
                JSONObject jsonObject = new JSONObject(bodyStr);
                rootFolderId = (String)jsonObject.get("id");
            }
            catch (GraphServiceException e) {
                if (e.getResponseCode() != 429) break block11;
                logger.error(" ...inside GraphServiceException and 429 case... ");
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException okHttpClient) {
                    // empty catch block
                }
                boolean success = true;
                do {
                    try {
                        Request request1 = new Request.Builder().url(siteUrl).build();
                        OkHttpClient okHttpClient = Graph.getInstance().getOkHttpClient();
                        Call call1 = okHttpClient.newCall(request1);
                        Response response1 = call1.execute();
                        int responseCode1 = response1.code();
                        logger.debug("...response code..." + responseCode1);
                        String bodyStr = response1.body().string();
                        logger.debug("...." + bodyStr);
                        JSONObject jsonObject = new JSONObject(bodyStr);
                        rootFolderId = (String)jsonObject.get("id");
                        success = false;
                    }
                    catch (GraphServiceException ew) {
                        if (ew.getResponseCode() != 429) continue;
                        success = true;
                        try {
                            Thread.sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Exception eee) {
                        logger.error("...error trying to get ee..." + eee.getMessage());
                    }
                } while (success);
                logger.error("GraphServiceException....", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("graph exception to delete:", (Object)e.getMessage());
            }
        }
        return rootFolderId;
    }

    private String getAzureUserId(String emailId) {
        String userId;
        block9: {
            userId = "";
            try {
                com.parablu.pcbd.domain.User user;
                UserCollectionPage iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(new Option[0])).filter("mail eq '" + emailId + "'").top(1).get());
                for (User userObj : iUserCollectionPage.getCurrentPage()) {
                    logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                    userId = userObj.id;
                }
                if (StringUtils.isEmpty((String)userId)) {
                    iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(new Option[0])).filter("userPrincipalName eq '" + emailId + "'").top(1).get());
                    for (User userObj : iUserCollectionPage.getCurrentPage()) {
                        logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                        userId = userObj.id;
                    }
                }
                if (StringUtils.isEmpty((String)userId) && (user = this.userDao.getUserDetailsForEmail(1, emailId)) != null) {
                    iUserCollectionPage = (UserCollectionPage)this.retryPolicyFactory.executeWithRetry(() -> (UserCollectionPage)((UserCollectionRequest)this.getGraphClient().users().buildRequest(new Option[0])).filter("userPrincipalName eq '" + user.getUserName() + "'").top(1).get());
                    for (User userObj : iUserCollectionPage.getCurrentPage()) {
                        logger.debug(userObj.userPrincipalName + "... vals..." + userObj.givenName);
                        userId = userObj.id;
                    }
                }
            }
            catch (GraphServiceException ee) {
                if (ee.getResponseCode() != 429) break block9;
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                userId = this.getAzureUserId(emailId);
            }
        }
        return userId;
    }

    @Override
    public CloudPropertyElement getCloudPropertyElement(int cloudId) {
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(cloudId);
        CloudPropertyElement cloudPropertyElement = null;
        if (cloudProperties != null) {
            cloudPropertyElement = new CloudPropertyElement();
            BeanUtils.copyProperties((Object)cloudProperties, (Object)cloudPropertyElement);
        }
        return cloudPropertyElement;
    }

    public BackupBatch startQueuedBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, long totalFiles, int errorCode, long batchStartTimestamp, boolean fullBackup) {
        logger.debug("calling start backup Batch ..." + uploadedFiles);
        BackupBatch backupBatch = new BackupBatch();
        try {
            DeviceBackupOverView deviceBackupOverView;
            int tot;
            int cloudId = cloud.getCloudId();
            String jobType = "BACKUP";
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ " + backupBatchOdb.getErrorCode());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            if (!StringUtils.isEmpty((String)totalNoOfFiles) && (long)(tot = Integer.parseInt(totalNoOfFiles)) < totalFiles) {
                totalNoOfFiles = "" + totalFiles;
            }
            if ((deviceBackupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID)) == null || !fullBackup && StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpStartTime())) {
                fullBackup = true;
            }
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.QUEUED.toString());
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(batchStartTimestamp);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setBatchEndTimestamp(System.currentTimeMillis());
            backupBatch.setErrorCode(backupBatchOdb.getErrorCode());
            backupBatch.setFullBackup(fullBackup);
            backupBatch.setDeviceType(device.getDeviceType());
            this.utilDao.saveBackupBatch(cloudId, backupBatch);
            BackupAttempt attempt = new BackupAttempt();
            BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
            attempt.setBatchId(backupBatch.getId().toString());
            attempt.setId(null);
            attempt.setErrorCode("0");
            attempt.setBatchStartTimestamp(batchStartTimestamp);
            attempt.setStatus(PCHelperConstant.BACKUP_STATUS.QUEUED.toString());
            this.utilDao.saveBackupAttempt(cloudId, attempt);
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, backupBatch, errorCode);
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
        return backupBatch;
    }

    public BackupBatch startScanningBackupBatch(BackupBatch backupBatchOdb, Cloud cloud, int uploadedFiles, long totalFiles, int errorCode, long batchStartTimestamp, boolean fullBackup) {
        logger.debug("calling start backup Batch ..." + uploadedFiles);
        BackupBatch backupBatch = new BackupBatch();
        try {
            int tot;
            int cloudId = cloud.getCloudId();
            String jobType = "BACKUP";
            String totalNoOfFiles = "" + backupBatchOdb.getNoOfFiles();
            String deviceUUID = backupBatchOdb.getDeviceUUID();
            logger.debug(" ************ " + backupBatchOdb.getErrorCode());
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
            if (!StringUtils.isEmpty((String)totalNoOfFiles) && (long)(tot = Integer.parseInt(totalNoOfFiles)) < totalFiles) {
                totalNoOfFiles = "" + totalFiles;
            }
            backupBatch.setId(backupBatchOdb.getId());
            backupBatch.setUserName(backupBatchOdb.getUserName());
            backupBatch.setDeviceName(backupBatchOdb.getDeviceName());
            backupBatch.setDeviceUUID(deviceUUID);
            backupBatch.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            backupBatch.setJobType(jobType);
            backupBatch.setBatchStartTimestamp(batchStartTimestamp);
            backupBatch.setDeviceName(device.getDeviceName());
            backupBatch.setErrorCode(backupBatchOdb.getErrorCode());
            backupBatch.setFullBackup(fullBackup);
            this.utilDao.saveBackupBatch(cloudId, backupBatch);
            BackupAttempt attempt = new BackupAttempt();
            BeanUtils.copyProperties((Object)backupBatch, (Object)attempt);
            attempt.setBatchId(backupBatch.getId().toString());
            attempt.setId(null);
            attempt.setErrorCode("0");
            attempt.setStatus(PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            this.utilDao.saveBackupAttempt(cloudId, attempt);
            this.updateBackupOverview(cloudId, "BACKUP", deviceUUID, device, backupBatch, errorCode);
            this.updateOverViewStatusScan(cloudId, deviceUUID, PCHelperConstant.BACKUP_STATUS.SCANNING.toString());
            logger.debug(" after updateoverview..");
        }
        catch (Exception e) {
            logger.trace("Error failed to save backupBatch ..." + e);
            logger.error("Error failed to save backupBatch ..." + e.getMessage());
        }
        logger.debug("end of calling method backup Batch ...");
        return backupBatch;
    }

    private void updateBackupOverview(int cloudId, String jobType, String deviceUUID, Device device, BackupBatch backupBatch, int errorCode) {
        DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        if (overView == null) {
            logger.debug(" No device backup ....");
            this.saveDeviceBackupOverView(cloudId, device);
        } else {
            logger.debug(backupBatch + " update device backup ...." + backupBatch.getBatchStartTimestamp());
            if (StringUtils.isEmpty((String)overView.getFirstBkpStartTime())) {
                String firstBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
                overView.setFirstBkpStartTime(firstBkpStartTime);
            }
            String lastBkpStartTime = this.getDateInFormat(backupBatch.getBatchStartTimestamp());
            overView.setLastBkpStartTime(lastBkpStartTime);
            if (backupBatch.getBatchEndTimestamp() > 0L) {
                overView.setLastBkpEndTime(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
            } else {
                overView.setLastBkpEndTime(this.getDateInFormat(System.currentTimeMillis()));
            }
            overView.setLastBkpStatus(backupBatch.getStatus());
            overView.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            logger.debug("TotalNoOfFiles : " + backupBatch.getTotalNoOfFiles() + " UploadedFiles : " + backupBatch.getUploadedFiles());
            overView.setNoOfFilesRemaining(this.getNoOfFilesRemaining(backupBatch.getTotalNoOfFiles(), backupBatch.getUploadedFiles()));
            logger.debug(overView.getNoOfSuccessfulBackups() + "Backup/Restore Status*" + backupBatch.getStatus() + "**");
            logger.debug(errorCode + "...noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
            if (BackupBatch.STATUS.COMPLETED.toString().equalsIgnoreCase(backupBatch.getStatus())) {
                String lastSuccessfulBkp = this.getDateInFormat(backupBatch.getBatchEndTimestamp());
                overView.setLastSuccessfulBkp(lastSuccessfulBkp);
                overView.setLastSuccessfulBackupStartTime(backupBatch.getBatchStartTimestamp());
                overView.setLastSuccessfulBackupEndTime(backupBatch.getBatchEndTimestamp());
                logger.debug(device.getUserName() + " @#@# Backup  Completed ........." + device.getDeviceName());
                logger.debug("...totalfilllll....." + backupBatch.getUploadedFiles() + "..." + backupBatch.getTotalNoOfFiles());
                long noOfSuccessfulBackups = overView.getNoOfSuccessfulBackups();
                overView.setNoOfSuccessfulBackups(noOfSuccessfulBackups + 1L);
                if (StringUtils.isEmpty((String)overView.getFirstBkpEndTime())) {
                    logger.debug(" ..firstbkp empty....");
                    Long firstBkpEndTime = this.utilDao.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID());
                    logger.debug(" ..firstbkp empty...." + firstBkpEndTime);
                    if (firstBkpEndTime != null) {
                        String firstSuccessfulEndBkp = this.getDateInFormat(firstBkpEndTime);
                        overView.setFirstBkpEndTime(firstSuccessfulEndBkp);
                    } else {
                        overView.setFirstBkpEndTime(lastSuccessfulBkp);
                    }
                    if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                        overView.setFirstFullBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                    } else {
                        overView.setFirstFullBkpTotalSizeOfFiles(0L);
                    }
                    overView.setFirstFullBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                }
                if (StringUtils.isNotEmpty((String)backupBatch.getUploadedSize())) {
                    overView.setLastSucessfulBkpTotalSizeOfFiles(Long.parseLong(backupBatch.getUploadedSize()) / 1024L);
                } else {
                    overView.setLastSucessfulBkpTotalSizeOfFiles(0L);
                }
                overView.setLastSucessfulBkpNoOfFiles(this.getActualUploadedFiles(backupBatch.getUploadedFiles()));
                overView.setCurrentlyRunningBkpNoOfFiles(0L);
                overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
            }
            overView.setReason(backupBatch.getErrorCode());
            if (!StringUtils.isEmpty((String)backupBatch.getStatus()) && backupBatch.getStatus().equals("ABORTED")) {
                overView.setCurrentlyRunningBkpNoOfFiles(0L);
                overView.setCurrentlyRunningBkpTotalSizeOfFiles(0L);
            }
            overView.setTotalSizeToUpload(backupBatch.getTotalSizeToUpload());
            logger.debug(backupBatch.getStatus() + "...end-noofsuccessfulbkps... " + overView.getNoOfSuccessfulBackups());
            overView.setLastBkpStatus(backupBatch.getStatus());
            this.utilDao.updateDeviceBackupOverView(cloudId, overView);
        }
    }

    long getActualUploadedFiles(String uploadedFiles) {
        if (StringUtils.isEmpty((String)uploadedFiles)) {
            uploadedFiles = "0/0";
        }
        String[] parts = uploadedFiles.split("/");
        return Long.parseLong(parts[0]);
    }

    private String getNoOfFilesRemaining(String totalNoOfFilesFromBatch, String uploadedFilesBatchTemp) {
        String uploadedFilesBatch = uploadedFilesBatchTemp;
        Integer noOfFilesRemaining = 0;
        logger.debug(" Files ********************** " + uploadedFilesBatch);
        if (StringUtils.isEmpty((String)uploadedFilesBatch)) {
            uploadedFilesBatch = "0/" + totalNoOfFilesFromBatch;
        }
        String[] parts = uploadedFilesBatch.split("/");
        try {
            Integer actualNoOfFiles = Integer.parseInt(parts[1]);
            Integer noOfFilesBackedup = Integer.parseInt(parts[0]);
            noOfFilesRemaining = actualNoOfFiles - noOfFilesBackedup;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return noOfFilesRemaining.toString();
    }

    public void saveDeviceBackupOverView(int cloudId, Device device) {
        DeviceBackupOverView backupOverView = new DeviceBackupOverView();
        com.parablu.pcbd.domain.User user = this.userDao.getUserByName(cloudId, device.getUserName());
        ObjectId deviceId = device.getId();
        Object[] arr = this.utilDao.getBackupDateHistoryElement(cloudId, "", device.getUserName(), device.getDeviceUUID());
        if (arr[0] != null) {
            String lastSuccessfulBkp = this.getDateInFormat((Long)arr[0]);
            backupOverView.setLastSuccessfulBkp(lastSuccessfulBkp);
        }
        if (arr[1] != null) {
            String firstSuccessfulBkp = this.getDateInFormat((Long)arr[1]);
            backupOverView.setFirstBkpStartTime(firstSuccessfulBkp);
        }
        if (arr[2] != null) {
            backupOverView.setLastBkpStatus(arr[2].toString());
            backupOverView.setReason(arr[3].toString());
            backupOverView.setLastBkpStartTime(this.getDateInFormat((Long)arr[4]));
        }
        backupOverView.setTotalNoOfFiles(arr[5].toString());
        backupOverView.setNoOfFilesRemaining(arr[6].toString());
        String userName = user.getUserName();
        long storageUsed = this.backUpImageDao.getTotalSizeUsedByUserForDevice(cloudId, userName, deviceId);
        backupOverView.setStorageUtilized(storageUsed);
        Object[] countArr = this.utilDao.getCountForJobType(cloudId, device.getDeviceUUID(), device.getUserName());
        if (countArr[1] != null) {
            Long noOfSuccessfulBackups = (Long)countArr[1];
            logger.debug(" ############### ....  ..... " + noOfSuccessfulBackups);
            backupOverView.setNoOfSuccessfulBackups(noOfSuccessfulBackups.longValue());
        }
        if (countArr[0] != null) {
            Long noOfSuccessfulRestores = (Long)countArr[0];
            logger.debug(" #####@@@@@@######### ....  ..... " + noOfSuccessfulRestores);
            backupOverView.setNoOfSuccessfulRestores(noOfSuccessfulRestores.longValue());
        }
        device.setUserId(user.getUserId());
        device.setUserName(user.getUserName());
        backupOverView.setUserName(user.getUserName());
        backupOverView.setEmailId(user.getEmailId());
        backupOverView.setUserActive(user.isActive());
        backupOverView.setUserDeleted(user.isDeleted());
        backupOverView.setPolicyName(user.getPolicyName());
        backupOverView.setDeviceBolcked(device.isBlocked());
        backupOverView.setDeviceUUID(device.getDeviceUUID());
        backupOverView.setClientVersion(device.getClientVersion());
        backupOverView.setEpaInstallationDate(device.getDeviceCreatedDate());
        backupOverView.setDeviceName(device.getDeviceName());
        backupOverView.setDeviceDeleted(device.isDeleted());
        this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
        this.deviceDao.updateDevice(cloudId, device);
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    @Override
    public String saveBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        return this.msUtilDao.saveBatchDetails(cloudId, backupBatch, policyName, batchStartTime);
    }

    @Override
    public void createQueuedBatch(Cloud cloud, OfficeBackupPolicy officeBackupPolicy, long batchStartTime, com.parablu.pcbd.domain.User user, boolean isFullBackup, Device device) {
        String userName = user.getUserName();
        BackupBatch lastBkpBatch = this.getLastBackupOnly(cloud.getCloudId(), userName, device.getDeviceUUID());
        if (lastBkpBatch != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.QUEUED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.SCANNING.toString()))) {
            logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
        } else {
            ODBBackupBatch backupBatch = new ODBBackupBatch();
            backupBatch.setDeviceUUID(device.getDeviceUUID());
            backupBatch.setUserName(userName);
            backupBatch.setNoOfFiles(0L);
            backupBatch.setBatchStartTimestamp(batchStartTime);
            backupBatch.setStatus("QUEUED");
            String batchId = this.saveBatchDetails(cloud.getCloudId(), backupBatch, officeBackupPolicy.getPolicyName(), batchStartTime);
            if (lastBkpBatch == null || lastBkpBatch != null && !lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.WAITING_FOR_BACKUP.toString())) {
                BackupBatch backupBatchOrg = new BackupBatch();
                BeanUtils.copyProperties((Object)backupBatch, (Object)backupBatchOrg);
                backupBatchOrg.setBatchStartTimestamp(backupBatch.getBatchStartTimestamp());
                backupBatchOrg.setId(new ObjectId(batchId));
                BackupBatch backupBatch2 = this.startQueuedBackupBatch(backupBatchOrg, cloud, cloud.getCloudId(), 0L, 0, batchStartTime, isFullBackup);
            }
        }
    }

    @Override
    public Device getOutlookDeviceForUserName(int cloudId, String userName) {
        return this.deviceDao.getOutlookDeviceForUserName(cloudId, userName);
    }

    @Override
    public boolean isFullBkpStarted(Cloud cloud, Device device, String userName) {
        boolean fullBkpStarted = false;
        List list = this.msUtilDao.getEventHubForDeviceUUID(cloud.getCloudId(), device.getDeviceUUID());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                fullBkpStarted = true;
                break;
            }
        }
        return fullBkpStarted;
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId, String deviceType) {
        return this.msUtilDao.getStartBackupEventHubList(cloudId, deviceType);
    }

    @Override
    public boolean isBkpStopped(int cloudId, String batchId) {
        BackupBatch batch = this.backUpImageDao.getBackupBatchById(cloudId, batchId);
        boolean batchStopped = false;
        if (batch != null && !StringUtils.isEmpty((String)batch.getErrorCode()) && ("1209".equalsIgnoreCase(batch.getErrorCode()) || "1310".equalsIgnoreCase(batch.getErrorCode()) || "1311".equalsIgnoreCase(batch.getErrorCode()))) {
            batchStopped = true;
        }
        return batchStopped;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPoliciesForBluKrypt(int cloudId, String policyType) {
        return this.msUtilDao.getAllOfficeBackupPoliciesForBluKrypt(cloudId, policyType);
    }

    @Override
    public boolean isBkpAllowed(int cloudId, Device device, String userName, String policyName) {
        BackupBatch lastBkpBatch;
        boolean alreadyBkpStarted = false;
        DeviceBackupOverView deviceBackupOverView = this.getDeviceBackupOverViewForDevice(cloudId, device.getDeviceUUID());
        logger.debug("....user backupallaowed..." + deviceBackupOverView);
        if (deviceBackupOverView != null) {
            logger.debug(userName + "....user backupallaowed..." + deviceBackupOverView.getLastBkpStatus() + "..." + deviceBackupOverView.getReason());
            if (INTERRUPTED_STATUS.equals(deviceBackupOverView.getLastBkpStatus()) && "1996".equals(deviceBackupOverView.getReason())) {
                logger.error(".....overload limit reached and deferred so wait..");
                return true;
            }
        }
        if ((lastBkpBatch = this.getLastBackupOnly(cloudId, userName, device.getDeviceUUID())) != null && (lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.toString()) || lastBkpBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.PAUSED.toString()))) {
            logger.debug("....user already in " + lastBkpBatch.getStatus() + " so not scheduling..." + userName + "...." + device.getDeviceType());
            return true;
        }
        return alreadyBkpStarted;
    }

    @Override
    public List<EventHub> getFailedStartEventHubList(int cloudId, String deviceType) {
        return this.msUtilDao.getFailedStartEventHubList(cloudId, deviceType);
    }

    @Override
    public List<BackupBatch> getAllIncompleteBatch(int cloudId, String deviceType) {
        return this.msUtilDao.getAllIncompleteBatch(cloudId, deviceType);
    }

    @Override
    public void updateAllIncompleteBatchQueueStatus(int cloudId, String deviceType) {
        this.msUtilDao.updateAllIncompleteBatchQueueStatus(cloudId, deviceType);
    }

    @Override
    public BackupBatch getIncompleteBatch(int cloudId, String deviceType) {
        return this.msUtilDao.getIncompleteBatch(cloudId, deviceType);
    }

    @Override
    public long getNextScheduledMinute(OfficeBackupPolicy oneDriveBackupPolicy) {
        long nextScheduleMinute;
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "inside NEXT SCHEDULE TIME IN MINUTES:");
        List<ScheduleTO> list = MSServiceImpl.getSchedulesList(oneDriveBackupPolicy.getSchedules());
        if (list == null || list.isEmpty()) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "..Schedule List is null or empty after retry so set default 12 mins");
            return 12L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        MSServiceImpl.getAppropriateDatesForSchedules(list, dates, 0);
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
        MSServiceImpl.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
        Date currentDate = Calendar.getInstance().getTime();
        currentDate.setSeconds(0);
        Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        logger.debug(oneDriveBackupPolicy.getPolicyName() + ".." + currentTime.getTime().getTime() + "...currenttime and scheduel time.." + nextScheduleDate.getTime() + "..diff..." + timeDiff);
        if (timeDiff <= 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff <= 0.." + timeDiff);
            nextScheduleMinute = 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        } else {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff > 0.." + timeDiff);
            nextScheduleMinute = TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        }
        if (nextScheduleMinute == 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "Next schedule minute is zero");
            nextScheduleMinute = this.getNextScheduledMinute(oneDriveBackupPolicy);
        }
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "..NEXT SCHEDULE TIME IN MINUTES:" + nextScheduleMinute);
        return nextScheduleMinute;
    }

    private static List<ScheduleTO> getSchedulesList(List<Schedule> schedulesList) {
        ArrayList<ScheduleTO> list = new ArrayList<ScheduleTO>();
        if (!CollectionUtils.isEmpty(schedulesList)) {
            for (Schedule schedule : schedulesList) {
                ScheduleTO tempFile = new ScheduleTO();
                tempFile.setScheduleName(schedule.getScheduleName());
                tempFile.setStartTime(schedule.getTime());
                tempFile.setDayArray(schedule.getDayArray());
                tempFile.setBackupType(schedule.getBackupType());
                tempFile.setContainerName("");
                list.add(tempFile);
            }
        }
        return list;
    }

    private static void getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                if (CollectionUtils.isEmpty(scheduleTO.getDayArray())) continue;
                for (Integer i : scheduleTO.getDayArray()) {
                    Calendar calendar1 = Calendar.getInstance();
                    int currentSeconds = Calendar.getInstance().getTime().getSeconds();
                    if (i > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, i - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - i));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, currentSeconds);
                    if (checkPrevSchedule == 0 && Calendar.getInstance().getTime().getTime() > calendar1.getTime().getTime()) {
                        calendar1.add(5, 7);
                    } else if (checkPrevSchedule == 1 && Calendar.getInstance().getTime().getTime() < calendar1.getTime().getTime()) {
                        calendar1.add(5, -7);
                    }
                    dates.add(calendar1.getTime());
                }
            }
            catch (ParseException e) {
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
    }

    public RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    @Override
    public void checkBatchExistsOrNot(BackupBatch backupBatchVal, String policyName) {
        this.msUtilDao.checkBatchExistsOrNot(backupBatchVal, policyName);
    }

    @Override
    public void deleteQueuedEntry(int cloudId, String userName, String deviceUUID, String policyName) {
        this.msUtilDao.deleteQueuedEntry(cloudId, userName, deviceUUID, policyName);
    }
}

