/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mongo_device_utility.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderUtil.class);

    public static Map<String, String> readConnectionDetails(String filePath) throws IOException {
        HashMap<String, String> connectionDetails = new HashMap<String, String>();
        try {
            Files.lines(Paths.get(filePath, new String[0])).forEach(line -> {
                if (!line.trim().isEmpty() && line.contains("=")) {
                    String[] parts = line.split("=", 2);
                    if (parts.length == 2) {
                        connectionDetails.put(parts[0].trim(), parts[1].trim());
                    } else {
                        logger.error("Invalid line format in connection file: {}", line);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("Failed to read connection details from file: {}", (Object)filePath, (Object)e);
            throw e;
        }
        return connectionDetails;
    }
}

