/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.mongo_device_utility.config;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.parablu.mongo_device_utility.utils.FileReaderUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.stereotype.Component;

@Component
public class MongoConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(MongoConnectionManager.class);
    private final Map<String, MongoTemplate> mongoTemplates = new ConcurrentHashMap();
    private final Map<String, String> connectionDetails;

    public MongoConnectionManager(ApplicationArguments args) throws Exception {
        File file;
        String filePath = "src/main/resources/connections.txt";
        if (args.getNonOptionArgs().size() > 0) {
            filePath = (String)args.getNonOptionArgs().get(0);
        }
        if (!(file = new File(filePath)).exists() || !file.canRead()) {
            logger.error("Connection file {} does not exist or is not readable.", (Object)filePath);
            throw new IllegalArgumentException("Invalid connection file path.");
        }
        this.connectionDetails = FileReaderUtil.readConnectionDetails((String)filePath);
        if (this.connectionDetails.isEmpty()) {
            logger.error("No valid connection details found in file: {}", (Object)filePath);
            throw new IllegalArgumentException("No valid connection details found.");
        }
        logger.info("Connection details successfully loaded from file: {}", (Object)filePath);
    }

    public MongoTemplate getMongoTemplateForClient(String clientName) {
        return this.mongoTemplates.computeIfAbsent(clientName, key -> {
            try {
                String host = (String)this.connectionDetails.get(clientName + ".host");
                String port = (String)this.connectionDetails.get(clientName + ".port");
                String username = (String)this.connectionDetails.get(clientName + ".username");
                String password = (String)this.connectionDetails.get(clientName + ".password");
                String dbName = (String)this.connectionDetails.get(clientName + ".db");
                host = host == null || host.isEmpty() ? "localhost" : host;
                String string = port = port == null || port.isEmpty() ? "27017" : port;
                if (host == null || port == null || username == null || password == null || dbName == null) {
                    logger.error("Missing connection details for client: {}", (Object)clientName);
                    throw new IllegalArgumentException("Missing connection details for client: " + clientName);
                }
                String uri = String.format("mongodb://%s:%s@%s:%s/%s", username, password, host, port, dbName);
                ConnectionString connectionString = new ConnectionString(uri);
                MongoClient mongoClient = MongoClients.create((ConnectionString)connectionString);
                return new MongoTemplate((MongoDatabaseFactory)new SimpleMongoClientDatabaseFactory(mongoClient, dbName));
            }
            catch (Exception e) {
                logger.error("Failed to create MongoTemplate for client: {}", (Object)clientName, (Object)e);
                throw new RuntimeException("Failed to create MongoTemplate for client: " + clientName, e);
            }
        });
    }
}

