/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.graph.helper.ScheduleTO;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.helper.utils.MemoryStore;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.service.MSService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class SPAutoScheduleJob
extends QuartzJobBean
implements Job {
    private final String POLICY_TYPE = "Sharepoint";
    private MSService msService;
    private Set<String> policyUnderProcess = new HashSet<String>();
    private static Logger logger = LogManager.getLogger(SPAutoScheduleJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private TimerTask userTimerTask = null;
    private Timer userTimer = null;
    private TimerTask policyTimerTask = null;
    private Timer policyTimer = null;
    private Timer userBackupTimer = null;
    private TimerTask userBackupTimerTask = null;
    private static List<User> userInfoList = null;
    CompletionService<String> userPool = null;
    private static Map<String, List<User>> policyUserMap = null;
    private Set<String> userUnderProcess = new HashSet<String>();
    private static String SP_POLICY_TYPE = "Sharepoint";

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....SPAutoScheduleJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isEnabled = this.isSharePointBackupEnabled(cloud);
            if (isEnabled) {
                List<OfficeBackupPolicy> policyList;
                boolean licenseActive = this.vaildatedLicensceStatus(cloud);
                if (!licenseActive) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                long threadSize = this.msService.getThreadSize(cloudId, cloud.getCloudName());
                if (threadSize == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                if (!CollectionUtils.isEmpty(policyList = this.msService.getAllOfficeBackupPolicies(cloudId, SP_POLICY_TYPE))) {
                    threadSize = policyList.size();
                }
                threadSize = 1L;
                logger.debug(" threads val........" + threadSize);
                int threadSizeVal = (int)threadSize;
                executor = Executors.newFixedThreadPool(threadSizeVal);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                ExecutorService userExecutor = Executors.newCachedThreadPool();
                this.userPool = new ExecutorCompletionService<String>(userExecutor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                logger.debug("... get officeBackupPolicyList list ... " + officeBackupPolicyList.size());
                this.checkThreadStatusAndStartScheduleForPolicy(cloudId, executor, pool);
                for (int i = 0; i < threadSizeVal; ++i) {
                    logger.debug("Creating thread for first time policy >>>>>>>>> i value::" + i);
                    this.initiatePolicySchedules(cloudId, executor, pool, true);
                }
            } else {
                logger.debug("...sp not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" exception in SPAutoScheduleJob......." + e.getMessage());
            logger.trace("exception in SPAutoScheduleJob ......." + e);
        }
        logger.debug("....SPAutoScheduleJob job ended...");
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    private boolean isSharePointBackupEnabled(Cloud cl) {
        boolean isSharePointBackupEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"Sharepoint Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSharePointBackupEnabled = true;
                break;
            }
        }
        return isSharePointBackupEnabled;
    }

    private void initiatePolicySchedules(int cloudId, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloudId, executor, pool, firstTime);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartScheduleForPolicy(final int cloudId, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.policyTimer == null) {
            this.policyTimer = new Timer();
        }
        if (this.policyTimerTask == null) {
            this.policyTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed schedule policy >>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for schedule policy so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            SPAutoScheduleJob.this.initiatePolicySchedules(cloudId, executor, pool, false);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartScheduleForPolicy", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug(".......inside checkThreadStatusAndStartScheduleForPolicy....  ");
            this.policyTimer.schedule(this.policyTimerTask, 100L, 1000L);
        }
    }

    public void checkThreadStatusAndStartUpload(final int cloudId, final CompletionService<String> pool, final List<User> usersList) {
        if (this.userTimer == null) {
            this.userTimer = new Timer();
        }
        if (this.userTimerTask == null) {
            this.userTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed>>>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed so assign new task>>>>>>>>>>>");
                            SPAutoScheduleJob.this.initiateMSDeltaQueries(cloudId, pool, usersList);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            logger.debug("...iniitiatecheckThreadStatusAndStartUpload...");
            this.userTimer.schedule(this.userTimerTask, 1000L, 1000L);
        }
    }

    private void initiateMSDeltaQueries(int cloudId, CompletionService<String> pool, List<User> usersList) {
        logger.debug("Files to backup ............... :");
        Runnable uploadJob = () -> this.uploadFiles(cloudId, pool, usersList);
        pool.submit(uploadJob, "");
    }

    private void schdeuleUsersForPolicy(int cloudId, ExecutorService executor, CompletionService<String> pool, boolean firstTime) {
        block9: {
            try {
                OfficeBackupPolicy officeBackupPolicy = this.getPolicyForProcessing(cloudId);
                if (officeBackupPolicy != null) {
                    logger.debug(Thread.currentThread().getName() + "... entering schedule sites forpolicy... " + officeBackupPolicy.getPolicyName() + "..." + Thread.currentThread().getName());
                    logger.debug((MemoryStore.get((String)("SP_AUTO_" + officeBackupPolicy.getPolicyName())) == null) + "... entering memstore... " + officeBackupPolicy.getPolicyName() + "..." + Thread.currentThread().getName());
                    CloudPropertyElement cloudPropertyElement = this.msService.getCloudPropertyElement(1);
                    if (MemoryStore.get((String)("SP_AUTO_" + officeBackupPolicy.getPolicyName())) != null) break block9;
                    logger.debug("... is Backup allowed first.... " + officeBackupPolicy.getPolicyName());
                    boolean isBackupAllowed = this.isBackupAllowed(officeBackupPolicy, firstTime);
                    logger.debug(officeBackupPolicy.getPolicyName() + "... is Backup allowed.... " + isBackupAllowed);
                    if (!officeBackupPolicy.isActive()) {
                        logger.debug("....Policy is not active so backup will not happen.");
                        isBackupAllowed = false;
                    }
                    if (!isBackupAllowed) break block9;
                    logger.debug(officeBackupPolicy.getPolicyName() + "..policyThreadname..." + MemoryStore.get((String)(officeBackupPolicy.getPolicyName() + "thread")) + "...." + Thread.currentThread().getName());
                    logger.debug("....inside schdeuleUsersForPolicy.........." + officeBackupPolicy.getPolicyName());
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    List<User> allSitesForOfficeBackupPolicy = this.msService.getAllSitesForOfficeBackupPolicy(cloudId, officeBackupPolicy.getPolicyName());
                    ArrayList<User> users = new ArrayList<User>();
                    for (User user : allSitesForOfficeBackupPolicy) {
                        if (!user.isSite()) continue;
                        users.add(user);
                    }
                    if (CollectionUtils.isEmpty(users)) {
                        logger.debug("... no sites available for policy.... " + officeBackupPolicy.getPolicyName());
                        this.policyUnderProcess.remove(officeBackupPolicy.getPolicyName());
                    } else {
                        logger.debug("... get sites list ... " + users.size());
                        logger.debug("Creating thread for sites for policy name ::" + officeBackupPolicy.getPolicyName());
                        this.initiateMSDeltaQueries(cloudId, this.userPool, users);
                    }
                    logger.debug("Thread ready for next File11 .... " + officeBackupPolicyList.size());
                    break block9;
                }
                logger.error(".. no policy for ");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("exception inside SPAutoScheduleJob .... " + e.getMessage());
                logger.trace("exception inside SPAutoScheduleJob ...." + e);
            }
        }
        logger.error("completed users for schedule wait for next retry>>>>");
    }

    private boolean isBackupAllowed(OfficeBackupPolicy oneDriveBackupPolicy, boolean firstTime) {
        boolean isBackupAllowed = false;
        if (!oneDriveBackupPolicy.isActive()) {
            logger.debug(".....Not a Valid policy....." + oneDriveBackupPolicy.getPolicyName());
            return isBackupAllowed;
        }
        long nextSchedule = this.getNextScheduledMinute(oneDriveBackupPolicy);
        String policyName = oneDriveBackupPolicy.getPolicyName();
        if (!firstTime && nextSchedule <= 2L) {
            try {
                logger.debug(oneDriveBackupPolicy.getPolicyName() + "....wait for mins..." + nextSchedule);
                Thread.sleep(nextSchedule * 60000L);
                nextSchedule = 1L;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        logger.debug(policyName + "....after getting nextscheduel..." + nextSchedule);
        if (nextSchedule == 1L) {
            logger.debug(policyName + "... wait for backup schedule to start in 1 min for policy ..." + policyName);
            if (MemoryStore.get((String)("SP_AUTO_" + policyName)) == null) {
                logger.debug("... enable backup for policy ... " + policyName);
                MemoryStore.add((String)("SP_AUTO_" + policyName), (Object)nextSchedule);
                if (MemoryStore.get((String)("SP_AUTO_" + policyName + "thread")) == null) {
                    MemoryStore.add((String)("SP_AUTO_" + policyName + "thread"), (Object)Thread.currentThread().getName());
                }
                isBackupAllowed = true;
            } else {
                logger.debug("... already backup enable for policy ... " + policyName);
                isBackupAllowed = false;
            }
        }
        return isBackupAllowed;
    }

    private List<OfficeBackupPolicy> getPolicyListForProcessing(int cloudId) {
        List<OfficeBackupPolicy> policyList = this.msService.getAllOfficeBackupPolicies(cloudId, SP_POLICY_TYPE);
        for (OfficeBackupPolicy policy : policyList) {
            logger.debug("......policy....." + policy.getPolicyName());
            officeBackupPolicyList.add(policy);
        }
        logger.debug(SP_POLICY_TYPE + "......policy list....." + officeBackupPolicyList.size());
        return officeBackupPolicyList;
    }

    private void uploadFiles(int cloudId, CompletionService<String> pool1, List<User> usersList) {
        User getUser = usersList.get(0);
        OfficeBackupPolicy officeBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloudId, getUser.getUserName(), OfficeBackupPolicy.TYPE.SHAREPOINT.toString());
        OfficeBackupPolicy officeBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloudId, officeBackupPolicy.getPolicyName());
        logger.debug(".... before sp backup...................");
        try {
            long batchStartTime = System.currentTimeMillis();
            ArrayList<User> userInfoListlocal = new ArrayList<User>();
            userInfoListlocal.addAll(usersList);
            logger.debug("....policy and users..." + officeBackupPolicy.getPolicyName() + "..." + userInfoListlocal.size());
            if (!CollectionUtils.isEmpty(userInfoListlocal)) {
                userInfoListlocal.parallelStream().forEach(user -> this.uploadSPFilesForSite(cloudId, officeBackupPolicy, officeBackupPolicyFromLocal, batchStartTime, (User)user));
            } else {
                logger.debug("...no users to process... ");
            }
        }
        catch (Exception e) {
            logger.error("..error trying to parse user sp..." + e.getMessage());
        }
        MemoryStore.delete((String)("SP_AUTO_" + officeBackupPolicy.getPolicyName()));
        logger.debug(".... completed usersList....................");
    }

    private void uploadSPFilesForSite(int cloudId, OfficeBackupPolicy officeBackupPolicy, OfficeBackupPolicy officeBackupPolicyFromLocal, long batchStartTime, User user) {
        boolean isPolicyModified = false;
        logger.debug("....inside for sp loopss.........." + user.getUserName());
        String userName = user.getUserName();
        Device device = this.msService.getSharePointDeviceForUserName(cloudId, userName);
        if (device == null) {
            return;
        }
        RestoreEvents restoreEvents = this.msService.getRestoreEventsByUUID(cloudId, device.getDeviceUUID());
        if (restoreEvents != null && restoreEvents.isSuspendBackup()) {
            logger.error(".....restore is running so backup cannot continue...  ");
            return;
        }
        if (device != null) {
            ArrayList<BackupFolders> inclusionbackupFolders = new ArrayList<BackupFolders>();
            List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                    BackupFolders backupFolderElement = new BackupFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    inclusionbackupFolders.add(backupFolderElement);
                }
            }
            ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
            List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, device.getDeviceUUID(), userName);
            if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
                for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                    ExcludedFolders backupFolderElement = new ExcludedFolders();
                    backupFolderElement.setId(userDefinedFolders.getId());
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    exclusionbackupFolders.add(backupFolderElement);
                }
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getBackupFolders())) {
                officeBackupPolicy.setBackupFolders(new ArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)officeBackupPolicy.getExcludedFolders())) {
                officeBackupPolicy.setExcludedFolders(new ArrayList());
            }
            officeBackupPolicy.getBackupFolders().addAll(inclusionbackupFolders);
            officeBackupPolicy.getExcludedFolders().addAll(exclusionbackupFolders);
        }
        if (officeBackupPolicyFromLocal == null) {
            logger.debug(user.getUserName() + "..... policy local .... null..");
        }
        logger.debug(user.getUserName() + "...officeBackupPolicyFromLocal...");
        OfficeBackupPolicy officeBackupPolicyFromLoc = officeBackupPolicyFromLocal;
        try {
            if (officeBackupPolicyFromLocal == null || officeBackupPolicy.getLastModifiedTimestamp() != officeBackupPolicyFromLocal.getLastModifiedTimestamp()) {
                if (officeBackupPolicyFromLocal == null) {
                    officeBackupPolicyFromLoc = officeBackupPolicy;
                } else {
                    isPolicyModified = true;
                }
                this.msService.saveOfficeBackupPolicy(cloudId, officeBackupPolicy);
            }
        }
        catch (Exception e) {
            logger.error("...error trying to save local policy");
        }
        try {
            logger.debug(user.getUserName() + "site list1......................................." + user.isActive());
            if (user != null && user.isActive() && user.isSite()) {
                logger.error(user.getUserName() + " %%%%%%% process started for site ...");
                this.processSite(user, cloudId, officeBackupPolicy, officeBackupPolicyFromLoc, isPolicyModified, batchStartTime);
                logger.error(user.getUserName() + " %%%%%%% process ended for site ...");
            }
            logger.debug("Thread ready for next user11 .... ");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(user.getUserName() + "exception inside SPAutoScheduleJob .... " + e.getMessage());
            logger.trace("exception inside SPAutoScheduleJob ...." + e);
        }
    }

    public void processSite(User user, int cloudId, OfficeBackupPolicy spPolicy, OfficeBackupPolicy spPolicyFromLocal, boolean isPolicyModified, long batchStartTime) {
        try {
            String gateway;
            Object gateway22;
            String userName = user.getUserName();
            logger.debug("Processing site " + userName);
            Device device = this.msService.getSharePointDeviceForUserName(cloudId, userName);
            if (device == null) {
                logger.debug("... no sp device for site... " + userName);
                return;
            }
            if (device.isBlocked() || device.isDeleted()) {
                logger.debug("... device blocked for site... " + userName);
                return;
            }
            ArrayList list = spPolicy.getPrivacyGateways();
            HashSet<String> gateWays = new HashSet<String>();
            for (Object gateway22 : list) {
                gateWays.add(gateway22.getGatewayName());
            }
            boolean isBlukryptRunning = false;
            gateway22 = gateWays.iterator();
            while (gateway22.hasNext() && (StringUtils.isEmpty((String)(gateway = (String)gateway22.next())) || !(isBlukryptRunning = this.isBluKryptRunning(gateway)))) {
            }
            if (!isBlukryptRunning) {
                logger.debug("... blukrypt is not running .... ");
                return;
            }
            if (!PCHelperConstant.getComponentName().equalsIgnoreCase(spPolicy.getMsAppBluKrypt())) {
                logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + spPolicy.getMsAppBluKrypt());
                return;
            }
            boolean alreadyBkpStarted = this.isBkpAllowed(cloudId, device, userName, spPolicyFromLocal.getPolicyName());
            if (!alreadyBkpStarted) {
                boolean isFullBkp = this.isFullBkpStarted(cloudId, device, userName);
                ObjectId eventHubId = this.updateEventHub(cloudId, device);
                this.msService.processDeltaChangesForSite(user, cloudId, spPolicy, spPolicyFromLocal, isPolicyModified, isFullBkp, eventHubId.toString(), batchStartTime, user.getSiteId());
                this.msService.updateEventHubOdStatus(cloudId, eventHubId);
            } else {
                logger.debug("... backup already forced....");
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.trace("" + e);
            logger.error("Exception inside SPAutoScheduleJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean isFullBkpStarted(int cloudId, Device device, String userName) {
        boolean fullBkpStarted = false;
        List<EventHub> list = this.msService.getEventHubForDeviceUUID(cloudId, device.getDeviceUUID());
        if (!CollectionUtils.isEmpty(list)) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                fullBkpStarted = true;
                break;
            }
        }
        return fullBkpStarted;
    }

    private boolean isBkpAllowed(int cloudId, Device device, String userName, String policyName) {
        List<ODBBackupBatch> batchlist;
        List<EventHub> list;
        boolean alreadyBkpStarted = false;
        DeviceBackupOverView deviceBackupOverView = this.msService.getDeviceBackupOverViewForDevice(cloudId, device.getDeviceUUID());
        logger.debug("....user backupallaowed..." + deviceBackupOverView);
        if (deviceBackupOverView != null) {
            logger.debug(userName + "....user backupallaowed..." + deviceBackupOverView.getLastBkpStatus() + "..." + deviceBackupOverView.getReason());
            if ("INTERRUPTED".equals(deviceBackupOverView.getLastBkpStatus()) && "1996".equals(deviceBackupOverView.getReason())) {
                logger.error(".....overload limit reached and deferred so wait..");
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(list = this.msService.getEventHubForDeviceUUID(cloudId, device.getDeviceUUID()))) {
            for (EventHub eventHub : list) {
                if (eventHub == null || !"START_BACKUP".equalsIgnoreCase(eventHub.getAction()) && !"FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) continue;
                logger.debug(".....isBkpAllowed....true");
                return true;
            }
        }
        if (!CollectionUtils.isEmpty(batchlist = this.msService.getCurrentBatch(policyName, userName, device.getDeviceUUID()))) {
            logger.debug("... already batchlist is not empty  .... " + userName);
            logger.debug(".....isBkpAllowed..batchlist...true");
            return true;
        }
        return alreadyBkpStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBluKryptRunning(String blukryptName) {
        boolean isBlukryptRunning = false;
        String url = "https://" + blukryptName + "/BluKryptBuilder/ping/";
        HttpGet httpGet = null;
        HttpClient httpclient = null;
        HttpResponse result = null;
        try {
            httpGet = new HttpGet(url);
            httpclient = HttpClientUtil.getSSlConnection();
            result = httpclient.execute((HttpUriRequest)httpGet);
            int responseCode = result.getStatusLine().getStatusCode();
            if (responseCode == 200) {
                isBlukryptRunning = true;
            }
            logger.debug(responseCode + "..." + isBlukryptRunning + "... ableto reach blukrypt ..... " + url);
        }
        catch (Exception e1) {
            logger.debug(e1.getMessage() + "...... unableto reach blukrypt ..... " + url);
        }
        finally {
            httpGet.releaseConnection();
        }
        return isBlukryptRunning;
    }

    private synchronized OfficeBackupPolicy getPolicyForProcessing(int cloudId) {
        if (CollectionUtils.isEmpty(officeBackupPolicyList) && CollectionUtils.isEmpty(officeBackupPolicyList = this.getPolicyListForProcessing(cloudId))) {
            try {
                logger.debug("...no policy to process... ");
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        logger.debug("....policy list .... " + officeBackupPolicyList.size());
        OfficeBackupPolicy oneDriveBackupPolicy = null;
        if (!CollectionUtils.isEmpty(officeBackupPolicyList)) {
            oneDriveBackupPolicy = officeBackupPolicyList.get(0);
        }
        if (oneDriveBackupPolicy != null) {
            if (this.policyUnderProcess.contains(oneDriveBackupPolicy.getPolicyName())) {
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            } else {
                this.policyUnderProcess.add(oneDriveBackupPolicy.getPolicyName());
                officeBackupPolicyList.remove(oneDriveBackupPolicy);
            }
        }
        if (oneDriveBackupPolicy == null) {
            try {
                logger.debug("... wait for next policy... ");
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        logger.debug("...after list size....." + officeBackupPolicyList.size());
        return oneDriveBackupPolicy;
    }

    private long getNextScheduledMinute(OfficeBackupPolicy oneDriveBackupPolicy) {
        long nextScheduleMinute;
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "inside NEXT SCHEDULE TIME IN MINUTES:");
        List<ScheduleTO> list = SPAutoScheduleJob.getSchedulesList(oneDriveBackupPolicy.getSchedules());
        if (list == null || list.isEmpty()) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "..Schedule List is null or empty after retry so set default 12 mins");
            return 12L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        SPAutoScheduleJob.getAppropriateDatesForSchedules(list, dates, 0);
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        TreeSet<Date> datesToCheckPreviousSchedule = new TreeSet<Date>();
        SPAutoScheduleJob.getAppropriateDatesForSchedules(list, datesToCheckPreviousSchedule, 1);
        Date currentDate = Calendar.getInstance().getTime();
        currentDate.setSeconds(0);
        Date nextScheduleDate = highestDateUpUntilNow == null ? Collections.min(dates) : highestDateUpUntilNow;
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        logger.debug(oneDriveBackupPolicy.getPolicyName() + ".." + currentTime.getTime().getTime() + "...currenttime and scheduel time.." + nextScheduleDate.getTime() + "..diff..." + timeDiff);
        if (timeDiff <= 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff <= 0.." + timeDiff);
            nextScheduleMinute = 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        } else {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "...timeDiff > 0.." + timeDiff);
            nextScheduleMinute = TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        }
        if (nextScheduleMinute == 0L) {
            logger.debug(oneDriveBackupPolicy.getPolicyName() + "Next schedule minute is zero");
            nextScheduleMinute = this.getNextScheduledMinute(oneDriveBackupPolicy);
        }
        logger.debug(oneDriveBackupPolicy.getPolicyName() + "..NEXT SCHEDULE TIME IN MINUTES:" + nextScheduleMinute);
        return nextScheduleMinute;
    }

    public static int[] toIntArray1(String input) {
        String beforeSplit = input.replaceAll("\\[|\\]|\\s", "");
        String[] split = beforeSplit.split("\\,");
        int[] result = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            result[i] = Integer.parseInt(split[i]);
        }
        return result;
    }

    private static List<ScheduleTO> getSchedulesList(List<Schedule> schedulesList) {
        ArrayList<ScheduleTO> list = new ArrayList<ScheduleTO>();
        if (!CollectionUtils.isEmpty(schedulesList)) {
            for (Schedule schedule : schedulesList) {
                ScheduleTO tempFile = new ScheduleTO();
                tempFile.setScheduleName(schedule.getScheduleName());
                tempFile.setStartTime(schedule.getTime());
                tempFile.setDayArray(schedule.getDayArray());
                tempFile.setBackupType(schedule.getBackupType());
                tempFile.setContainerName("");
                list.add(tempFile);
            }
        }
        return list;
    }

    private static void getAppropriateDatesForSchedules(List<ScheduleTO> list, NavigableSet<Date> dates, int checkPrevSchedule) {
        for (ScheduleTO scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getStartTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                if (CollectionUtils.isEmpty(scheduleTO.getDayArray())) continue;
                for (Integer i : scheduleTO.getDayArray()) {
                    Calendar calendar1 = Calendar.getInstance();
                    int currentSeconds = Calendar.getInstance().getTime().getSeconds();
                    if (i > dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, i - dayOfWeek);
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek - 7);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i < dayOfWeek) {
                        if (checkPrevSchedule == 0) {
                            calendar1.add(5, 7 - (dayOfWeek - i));
                            calendar1.set(11, date1.getHours());
                            calendar1.set(12, date1.getMinutes());
                            calendar1.set(13, date1.getSeconds());
                            dates.add(calendar1.getTime());
                            continue;
                        }
                        if (checkPrevSchedule != 1) continue;
                        calendar1.add(5, i - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, date1.getSeconds());
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (i != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, currentSeconds);
                    if (checkPrevSchedule == 0 && Calendar.getInstance().getTime().getTime() > calendar1.getTime().getTime()) {
                        calendar1.add(5, 7);
                    } else if (checkPrevSchedule == 1 && Calendar.getInstance().getTime().getTime() < calendar1.getTime().getTime()) {
                        calendar1.add(5, -7);
                    }
                    dates.add(calendar1.getTime());
                }
            }
            catch (ParseException e) {
                logger.trace("" + e);
                logger.error("Exception getting schedules " + e.getMessage());
            }
        }
    }

    public ObjectId updateEventHub(int cloudId, Device device) {
        logger.debug("calling updateEventHub ....");
        ObjectId eventHubId = null;
        try {
            String deviceUUID = device.getDeviceUUID();
            String userName = device.getUserName();
            String actionByUserName = "Schedule";
            String acctionToUserName = userName;
            logger.debug("... creating event hub....");
            EventHub eventHub = new EventHub();
            eventHub.setActionBy(actionByUserName);
            eventHub.setActionStatus(PCHelperConstant.EVENTHUB_ACTION_STATUS.CREATED.toString());
            eventHub.setActionToUserName(acctionToUserName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setOdStatus(EventHub.ODSTATUS.STARTED.toString());
            String action = PCHelperConstant.EVENTHUB_ACTION.START_BACKUP.toString();
            eventHub.setAction(action);
            eventHubId = this.msService.saveEventHubAction(cloudId, eventHub);
        }
        catch (Exception e) {
            logger.error("... exception trying to save eventhub ..." + e.getMessage());
        }
        return eventHubId;
    }
}

