/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.MSService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.SchedulerException;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class ODBBackupScheduleJob
extends QuartzJobBean
implements Job {
    private static String OD_POLICY_TYPE = "ODB";
    private MSService msService;
    private Set<String> eventsUnderProcess = new HashSet<String>();
    private static Logger logger = LogManager.getLogger(ODBBackupScheduleJob.class);
    private static List<OfficeBackupPolicy> officeBackupPolicyList = null;
    private static List<EventHub> eventHubList = null;
    private TimerTask scheduleTimerTask = null;
    private Timer scheduleTimer = null;

    public void setMsService(MSService msService) {
        this.msService = msService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List jobs = arg0.getScheduler().getCurrentlyExecutingJobs();
            if (jobs != null && !jobs.isEmpty()) {
                for (JobExecutionContext job : jobs) {
                    if (!job.getTrigger().equals((Object)arg0.getTrigger()) || job.getJobInstance().equals((Object)this)) continue;
                    logger.debug("There's another instance running,SO skipping>>>>>>>>>>>>> : " + (Object)((Object)this));
                    return;
                }
            }
        }
        catch (SchedulerException e) {
            logger.debug("" + (Object)((Object)e));
            logger.error("" + e.getCause());
        }
        logger.debug("....ODBBackupScheduleJob job started...");
        ExecutorService executor = null;
        try {
            int cloudId = 1;
            Cloud cloud = this.msService.getCloud(cloudId);
            boolean isOneDriveForBusinessBackupEnabled = this.isOneDriveForBusinessBackupEnabled(cloud);
            if (isOneDriveForBusinessBackupEnabled) {
                boolean licenseActive;
                if (cloud != null) {
                    logger.debug("......cloud val...." + cloud.getCloudName());
                }
                if (!(licenseActive = this.vaildatedLicensceStatus(cloud))) {
                    logger.debug("....license inactive no crawl....");
                    Thread.sleep(1200000L);
                    return;
                }
                long threadSize = this.msService.getThreadSize(cloud.getCloudId(), cloud.getCloudName());
                if (threadSize == 0L) {
                    threadSize = PCHelperConstant.getThreadLimit();
                }
                logger.debug(" threads val........" + threadSize);
                boolean threadSizeVal = true;
                executor = Executors.newFixedThreadPool(1);
                ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
                officeBackupPolicyList = new ArrayList<OfficeBackupPolicy>();
                this.checkThreadStatusAndStartSchedule(cloud, executor, pool);
                for (int i = 0; i < 1; ++i) {
                    logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                    this.initiateSchedules(cloud, executor, pool);
                }
            } else {
                logger.debug("...odb backup not enabled.... so sleep for 20 mins...");
                Thread.sleep(1200000L);
            }
            logger.debug(" exit upload part.........." + isOneDriveForBusinessBackupEnabled);
        }
        catch (Exception e) {
            logger.error(" exception in ODBBackupScheduleJob job......." + e.getMessage());
            logger.trace("exception in ODBBackupScheduleJob job ......." + e);
        }
        logger.debug("....ODBBackupScheduleJob job ended...");
    }

    private boolean isOneDriveForBusinessBackupEnabled(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((String)cloudPluginDetails.getName()) || !"OneDrive Backup Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void initiateSchedules(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("starting policy schedules ............... :");
        Runnable schedulePolicyJob = () -> this.schdeuleUsersForPolicy(cloud, executor, pool);
        pool.submit(schedulePolicyJob, "");
    }

    private void checkThreadStatusAndStartSchedule(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.scheduleTimer == null) {
            this.scheduleTimer = new Timer();
        }
        if (this.scheduleTimerTask == null) {
            this.scheduleTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        logger.error("Check the task is completed check for backup actions >>>>>>>");
                        Future future = pool.take();
                        if (future.isDone()) {
                            logger.debug("Thread is completed for backup actions so assign new task with future>>>>>>>>>>>" + (String)future.get());
                            ODBBackupScheduleJob.this.initiateSchedules(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in ODBBackupScheduleJob...", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.scheduleTimer.schedule(this.scheduleTimerTask, 1000L, 1000L);
        }
    }

    private synchronized List<EventHub> getEventsToProcess(Cloud cloud) {
        List<EventHub> eventHubList = this.msService.getStartBackupEventHubList(cloud.getCloudId());
        return eventHubList;
    }

    private synchronized EventHub getEventForProcessing(Cloud cloud) {
        if (CollectionUtils.isEmpty(eventHubList) && CollectionUtils.isEmpty(eventHubList = this.getEventsToProcess(cloud))) {
            return null;
        }
        EventHub eventHub = eventHubList.get(0);
        if (eventHub != null) {
            String eventID = eventHub.getId().toString();
            if (this.eventsUnderProcess.contains(eventID)) {
                eventHubList.remove(eventHub);
                if (CollectionUtils.isEmpty(eventHubList)) {
                    try {
                        logger.debug("...no events to process take a delay...");
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return this.getEventForProcessing(cloud);
            }
            eventHubList.remove(eventHub);
            this.eventsUnderProcess.add(eventID);
        }
        logger.debug("...after list size....." + eventHubList.size());
        return eventHub;
    }

    private void schdeuleUsersForPolicy(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        logger.debug("....inside schdeuleUsersForPolicy 1.........");
        try {
            EventHub eventHub = this.getEventForProcessing(cloud);
            if (eventHub != null && !StringUtils.isEmpty((String)eventHub.getActionBy()) && !eventHub.getActionBy().equalsIgnoreCase("Schedule")) {
                String userName = eventHub.getActionToUserName();
                logger.debug(".....event ... " + eventHub.getActionToUserName() + "...." + eventHub.getAction());
                Device device = this.msService.getODDeviceForUserName(cloud.getCloudId(), userName);
                User user = this.msService.getUserInfo(cloud.getCloudId(), userName);
                if (user != null && user.isActive() && user.isOnedriveBkpEnabled()) {
                    if (device != null && device.getDeviceUUID().equalsIgnoreCase(eventHub.getActionToDeviceUUID())) {
                        ArrayList backupFoldersLocal;
                        ArrayList backupFolders;
                        logger.debug(userName + " %%%%%%% process eventHub started for user1 ..." + eventHub.getActionToDeviceUUID());
                        boolean isFullBackup = false;
                        if ("FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) {
                            isFullBackup = true;
                        }
                        boolean isPolicyModified = false;
                        int cloudId = cloud.getCloudId();
                        OfficeBackupPolicy oneDriveBackupPolicy = this.msService.getOfficeBackupPolicyForUserName(cloud.getCloudId(), userName, OD_POLICY_TYPE);
                        ArrayList<Object> inclusionbackupFolders = new ArrayList<Object>();
                        List<UserDefinedFolders> userDefinedFoldersList = this.msService.getAllUserDefinedInclusionFolders(cloudId, eventHub.getActionToDeviceUUID(), userName);
                        if (!CollectionUtils.isEmpty(userDefinedFoldersList)) {
                            for (UserDefinedFolders userDefinedFolders : userDefinedFoldersList) {
                                BackupFolders backupFolderElement = new BackupFolders();
                                backupFolderElement.setId(userDefinedFolders.getId());
                                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                                inclusionbackupFolders.add(backupFolderElement);
                            }
                        }
                        ArrayList<ExcludedFolders> exclusionbackupFolders = new ArrayList<ExcludedFolders>();
                        List<UserDefinedFolders> exclusionuserDefinedFoldersList = this.msService.getAllUserDefinedExclusionFolders(cloudId, eventHub.getActionToDeviceUUID(), userName);
                        if (!CollectionUtils.isEmpty(exclusionuserDefinedFoldersList)) {
                            for (UserDefinedFolders userDefinedFolders : exclusionuserDefinedFoldersList) {
                                ExcludedFolders backupFolderElement = new ExcludedFolders();
                                backupFolderElement.setId(userDefinedFolders.getId());
                                backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                                exclusionbackupFolders.add(backupFolderElement);
                            }
                        }
                        logger.debug("...onedrive policy... " + oneDriveBackupPolicy);
                        if (!PCHelperConstant.getComponentName().equalsIgnoreCase(oneDriveBackupPolicy.getMsAppBluKrypt()) || !oneDriveBackupPolicy.isActive()) {
                            logger.error(PCHelperConstant.getComponentName() + ".....wrong agent for backup..." + oneDriveBackupPolicy.getMsAppBluKrypt());
                            if (!oneDriveBackupPolicy.isActive()) {
                                logger.debug(".....Not a Valid policy....." + oneDriveBackupPolicy.getPolicyName());
                            }
                            this.eventsUnderProcess.remove(eventHub.getId().toString());
                            return;
                        }
                        if (CollectionUtils.isEmpty((Collection)oneDriveBackupPolicy.getBackupFolders())) {
                            oneDriveBackupPolicy.setBackupFolders(new ArrayList());
                        }
                        if (CollectionUtils.isEmpty((Collection)oneDriveBackupPolicy.getExcludedFolders())) {
                            oneDriveBackupPolicy.setExcludedFolders(new ArrayList());
                        }
                        oneDriveBackupPolicy.getBackupFolders().addAll(inclusionbackupFolders);
                        oneDriveBackupPolicy.getExcludedFolders().addAll(exclusionbackupFolders);
                        OfficeBackupPolicy oneDriveBackupPolicyFromLocal = this.msService.getOfficeBackupPolicyFromLocal(cloud.getCloudId(), oneDriveBackupPolicy.getPolicyName());
                        oneDriveBackupPolicy.getBackupFolders().forEach(folder -> logger.debug("... onedrive policy folder .... " + folder.getFolderPath()));
                        if (oneDriveBackupPolicyFromLocal == null || oneDriveBackupPolicy.getLastModifiedTimestamp() != oneDriveBackupPolicyFromLocal.getLastModifiedTimestamp()) {
                            if (oneDriveBackupPolicyFromLocal == null) {
                                oneDriveBackupPolicyFromLocal = oneDriveBackupPolicy;
                            } else {
                                backupFolders = oneDriveBackupPolicy.getBackupFolders();
                                backupFoldersLocal = oneDriveBackupPolicyFromLocal.getBackupFolders();
                                if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                                    backupFolders = new ArrayList();
                                }
                                if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                                    backupFoldersLocal = new ArrayList();
                                }
                                ArrayList excludedFolders = oneDriveBackupPolicy.getExcludedFolders();
                                ArrayList excludedFoldersLocal = oneDriveBackupPolicyFromLocal.getExcludedFolders();
                                if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                                    excludedFolders = new ArrayList();
                                }
                                if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                                    excludedFoldersLocal = new ArrayList();
                                }
                                ArrayList<String> backupFoldStr = new ArrayList<String>();
                                ArrayList<String> backupFoldLocalStr = new ArrayList<String>();
                                ArrayList<String> excludedFoldStr = new ArrayList<String>();
                                ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
                                for (BackupFolders folders : backupFolders) {
                                    backupFoldStr.add(folders.getFolderPath());
                                }
                                for (BackupFolders folders : backupFoldersLocal) {
                                    backupFoldLocalStr.add(folders.getFolderPath());
                                }
                                for (BackupFolders folders : excludedFolders) {
                                    excludedFoldStr.add(folders.getFolderPath());
                                }
                                for (BackupFolders folders : excludedFoldersLocal) {
                                    excludedFoldLocalStr.add(folders.getFolderPath());
                                }
                                logger.debug(ODBBackupScheduleJob.compare(backupFoldStr, backupFoldLocalStr) + "....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                                logger.debug(ODBBackupScheduleJob.compare(excludedFoldStr, excludedFoldLocalStr) + "....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                                boolean allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
                                logger.debug("....comparelist..." + allElementsPresent);
                                allElementsPresent = ODBBackupScheduleJob.compare(backupFoldStr, backupFoldLocalStr) && ODBBackupScheduleJob.compare(excludedFoldStr, excludedFoldLocalStr);
                                logger.debug("...after...comparelist..." + allElementsPresent);
                                isPolicyModified = !allElementsPresent;
                            }
                            this.msService.saveOfficeBackupPolicy(cloud.getCloudId(), oneDriveBackupPolicy);
                        } else {
                            backupFolders = oneDriveBackupPolicy.getBackupFolders();
                            backupFoldersLocal = oneDriveBackupPolicyFromLocal.getBackupFolders();
                            if (CollectionUtils.isEmpty((Collection)backupFolders)) {
                                backupFolders = new ArrayList();
                            }
                            if (CollectionUtils.isEmpty((Collection)backupFoldersLocal)) {
                                backupFoldersLocal = new ArrayList();
                            }
                            ArrayList excludedFolders = oneDriveBackupPolicy.getExcludedFolders();
                            ArrayList excludedFoldersLocal = oneDriveBackupPolicyFromLocal.getExcludedFolders();
                            if (CollectionUtils.isEmpty((Collection)excludedFolders)) {
                                excludedFolders = new ArrayList();
                            }
                            if (CollectionUtils.isEmpty((Collection)excludedFoldersLocal)) {
                                excludedFoldersLocal = new ArrayList();
                            }
                            ArrayList<String> backupFoldStr = new ArrayList<String>();
                            ArrayList<String> backupFoldLocalStr = new ArrayList<String>();
                            ArrayList<String> excludedFoldStr = new ArrayList<String>();
                            ArrayList<String> excludedFoldLocalStr = new ArrayList<String>();
                            for (BackupFolders folders : backupFolders) {
                                backupFoldStr.add(folders.getFolderPath());
                            }
                            for (BackupFolders folders : backupFoldersLocal) {
                                backupFoldLocalStr.add(folders.getFolderPath());
                            }
                            for (BackupFolders folders : excludedFolders) {
                                excludedFoldStr.add(folders.getFolderPath());
                            }
                            for (BackupFolders folders : excludedFoldersLocal) {
                                excludedFoldLocalStr.add(folders.getFolderPath());
                            }
                            logger.debug(ODBBackupScheduleJob.compare(backupFoldStr, backupFoldLocalStr) + "....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                            logger.debug(ODBBackupScheduleJob.compare(excludedFoldStr, excludedFoldLocalStr) + "....folllsss........." + backupFoldStr.size() + ".." + backupFoldLocalStr.size() + "...exc.." + excludedFoldStr.size() + "..." + excludedFoldLocalStr.size());
                            boolean allElementsPresent = backupFoldStr.equals(backupFoldLocalStr) && excludedFoldStr.equals(excludedFoldLocalStr);
                            logger.debug("....comparelist..." + allElementsPresent);
                            allElementsPresent = ODBBackupScheduleJob.compare(backupFoldStr, backupFoldLocalStr) && ODBBackupScheduleJob.compare(excludedFoldStr, excludedFoldLocalStr);
                            logger.debug("...after...comparelist..." + allElementsPresent);
                            isPolicyModified = !allElementsPresent;
                        }
                        boolean isPrevBkpPaused = false;
                        if ("START_BACKUP".equalsIgnoreCase(eventHub.getAction()) || "FULL_BACKUP".equalsIgnoreCase(eventHub.getAction())) {
                            isPrevBkpPaused = this.msService.isPrevBkpPaused(eventHub.getActionToDeviceUUID(), oneDriveBackupPolicy.getPolicyName());
                        }
                        logger.debug(eventHub.getAction() + "....isprevbkp paused.... " + isPrevBkpPaused);
                        if (isPrevBkpPaused) {
                            logger.debug(eventHub.getActionToDeviceUUID() + "....isprevbkp paused1.... " + oneDriveBackupPolicy.getPolicyName());
                            this.msService.updatePauseBkp(eventHub.getActionToDeviceUUID(), oneDriveBackupPolicy.getPolicyName());
                            this.msService.deleteActionBasedOnBackupBatchStatus(cloud.getCloudId(), eventHub.getActionToDeviceUUID(), eventHub.getAction());
                            this.eventsUnderProcess.remove(eventHub.getId().toString());
                        } else {
                            this.processUser(user, cloud, oneDriveBackupPolicy, oneDriveBackupPolicyFromLocal, isPolicyModified, eventHub.getId().toString());
                            this.msService.updateEventHubOdStatus(cloud.getCloudId(), eventHub.getId());
                            this.eventsUnderProcess.remove(eventHub.getId().toString());
                        }
                        logger.error(userName + " %%%%%%% process eventHub ended for user ..." + eventHub.getActionToDeviceUUID());
                    } else {
                        logger.debug("...not a valid device....");
                        eventHubList.remove(eventHub);
                        this.eventsUnderProcess.remove(eventHub.getId().toString());
                    }
                } else {
                    logger.debug("... user not active...");
                    if (user.isOnedriveBkpEnabled()) {
                        this.msService.deleteActionBasedOnBackupBatchStatus(cloud.getCloudId(), eventHub.getActionToDeviceUUID(), eventHub.getAction());
                        this.eventsUnderProcess.remove(eventHub.getId().toString());
                    } else if (device != null && !user.isOnedriveBkpEnabled()) {
                        logger.debug("...device there but license disabled...");
                        this.msService.updateOverViewStatus(cloud.getCloudId(), eventHub.getActionToDeviceUUID(), 2001);
                        if (device != null && device.getDeviceUUID().equalsIgnoreCase(eventHub.getActionToDeviceUUID())) {
                            logger.debug(device.getDeviceUUID() + "...not a valid device..." + eventHub.getActionToDeviceUUID());
                            this.msService.deleteActionBasedOnBackupBatchStatus(cloud.getCloudId(), eventHub.getActionToDeviceUUID(), eventHub.getAction());
                            this.eventsUnderProcess.remove(eventHub.getId().toString());
                        } else {
                            logger.debug("...not a valid device...");
                            this.eventsUnderProcess.remove(eventHub.getId().toString());
                        }
                    }
                }
            }
            Thread.sleep(5000L);
            logger.debug("Thread ready for next user .... ");
        }
        catch (Exception e) {
            logger.error("exception inside BackupUploadJob .... " + e.getMessage());
            logger.trace("exception inside BackupUploadJob ...." + e);
        }
    }

    private boolean vaildatedLicensceStatus(Cloud cloud) {
        return cloud.getValidityPeriod() >= System.currentTimeMillis() && cloud.getStatusCode().equals("ACTIVE");
    }

    public void processUser(User user, Cloud cloud, OfficeBackupPolicy oneDriveBackupPolicy, OfficeBackupPolicy oneDriveBackupPolicyFromLocal, boolean isPolicyModified, String eventHubId) {
        try {
            String userName = user.getUserName();
            logger.debug("Processing " + userName);
            if (oneDriveBackupPolicy == null) {
                logger.debug("... no policy assigned for user .... " + userName);
            } else {
                this.msService.processDeltaChangesForUserDrive(user, cloud, oneDriveBackupPolicy, oneDriveBackupPolicyFromLocal, isPolicyModified, eventHubId, System.currentTimeMillis());
            }
            logger.debug(" processed user .............. " + userName);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    public static boolean compare(List<String> first, List<String> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && second == null) {
            return false;
        }
        if (first == null && second != null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : first) {
            map.put(str, str);
        }
        for (String str : second) {
            if (map.containsKey(str)) continue;
            return false;
        }
        return true;
    }
}

