from flask import Flask, request,jsonify, g, abort, make_response
from langchain.chains import RetrievalQAWithSourcesChain
from langchain.llms import OpenAI
import sys
import os
from datetime import datetime

from langchain.chains import ConversationalRetrievalChain
#from langchain.chat_models import ChatOpenAI


from langchain.vectorstores.pgvector import PGVector
import logging

logging.basicConfig(level=logging.INFO)

app = Flask(__name__)


CONNECTION_STRING = PGVector.connection_string_from_db_params(
    database="postgres",
    user="postgres",
    password="",
    host="",
    port='5432',
    driver= "psycopg2")

import os

logging.info("STARTING")
    

org_id = 1
collection_name = f'parablu_vector_store_{org_id}'


index_name = "03-May-2023"

#index_name = "02-May-2023"


API_KEY = os.getenv("API_KEY")

os.environ["OPENAI_API_TYPE"] = "azure"
os.environ["OPENAI_API_BASE"] = "https://dev-open-ai-project1.openai.azure.com/"
os.environ["OPENAI_API_KEY"] = "7d48a4e36ec94eaebd892343c9192d8d"
os.environ["OPENAI_API_VERSION"] = "2023-03-15-preview"

from langchain.chat_models import AzureChatOpenAI
from langchain.embeddings import OpenAIEmbeddings

embeddings = OpenAIEmbeddings()

store = PGVector(
    connection_string=CONNECTION_STRING,
    embedding_function=embeddings, 
    collection_name=collection_name,
)

for key, value in os.environ.items():
    logging.info(f"{key}: {value}")



@app.route("/")
def base():
    return jsonify({"version":0.3})


def make_chat_request(index_name,query,chat_history):
    retriever = store.as_retriever(search_kwargs={'filter': {'index_id':index_name}})

    #must be a tuple passes in
    chat_history = [(q[0],q[1]) for q in chat_history]


    #llm = ChatOpenAI(temperature=0.0,model_name='gpt-4')

    llm = AzureChatOpenAI(
        deployment_name="dev-open-ai-model",
        model_name="gpt-35-turbo",
    )

    chain = ConversationalRetrievalChain.from_llm(
        llm,
        retriever=retriever,
        return_source_documents=True,
        max_tokens_limit=4097)

            
    result = chain({"question": query, "chat_history": chat_history})

    sources = []
    for sd in result['source_documents']:
        sources.append(sd.metadata['source'])
        
    print(result)
    return {"answer":result['answer'],
            "sources":sources}

@app.route("/chat",methods=['POST','OPTIONS'])
def chat():
    headers = request.headers

    if 'API-KEY' not in headers or headers['API-KEY'] != API_KEY:
        return abort(403)
    
    chat_request = request.json
    print(chat_request)

    date_obj = datetime.strptime(chat_request['index'], "%d-%b-%Y")

    # Convert the datetime object back to a string, but with the month name capitalized
    date_str_capitalized = date_obj.strftime("%d-%B-%Y")    
    
    result = make_chat_request(date_str_capitalized,chat_request['query'],chat_request['chat_history'])

    return jsonify({"chat_results":result})


#https://www.freecodecamp.org/news/how-to-dockerize-a-flask-app/
