/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.paracloud.element.CloudPropertyElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.text.SimpleDateFormat;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class TmpChunkCleanerJob
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(TmpChunkCleanerJob.class);
    private static long maxDurationInMs = 604800000L;
    private UtilService utilService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        File[] deviceUuidFolders;
        logger.debug("-------------------Inside TempChunkCleanerJob-------------------");
        if (!PCHelperConstant.isJobEnabled((String)"tmpChunkCleanerTrigger")) {
            logger.debug("TempChunkCleanerJob ............. disabled");
            return;
        }
        CloudPropertyElement cloudPropertyElement = this.utilService.getCloudPropertyElement(1);
        if (cloudPropertyElement.getDaysToDeleteTmpChunk() > 0) {
            maxDurationInMs = cloudPropertyElement.getDaysToDeleteTmpChunk() * 1000 * 60 * 60 * 24;
        }
        logger.debug("maxDurationInMs={}", (Object)maxDurationInMs);
        String folderPath = PCHelperConstant.getMntTempChunkPath();
        logger.debug("the tmp-chunk path is={}", (Object)folderPath);
        File tmpChunkFolder = new File(folderPath);
        if (tmpChunkFolder.exists() && tmpChunkFolder.isDirectory() && (deviceUuidFolders = tmpChunkFolder.listFiles()) != null) {
            logger.debug("deviceUUIDFolder list size={}", (Object)deviceUuidFolders.length);
            for (File deviceUuidFolder : deviceUuidFolders) {
                TmpChunkCleanerJob.deleteFolderOrFiles(deviceUuidFolder.getAbsolutePath());
            }
        }
    }

    private static void deleteFolderOrFiles(String folderPath) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
        try {
            File[] batchIds;
            File deviceUuidFolder = new File(folderPath);
            logger.debug("Iterating for deviceUUID={}", (Object)folderPath);
            if (deviceUuidFolder.exists() && deviceUuidFolder.isDirectory() && (batchIds = deviceUuidFolder.listFiles()) != null) {
                logger.debug("batchIds list size={}", (Object)batchIds.length);
                for (File batchId : batchIds) {
                    if (!batchId.exists() || !batchId.isDirectory()) continue;
                    logger.debug("batch Id={}, directory last modified={}", (Object)batchId.getName(), (Object)sdf.format(batchId.lastModified()));
                    long durationOfBatch = Math.abs(System.currentTimeMillis() - batchId.lastModified());
                    logger.debug("the time duration of batch Id directory since it is modified present in server is={}", (Object)durationOfBatch);
                    if (durationOfBatch <= maxDurationInMs) continue;
                    logger.debug("the batchId directory={} is eligible for cleanup", (Object)batchId.getName());
                    FileUtils.deleteDirectory((File)batchId);
                    logger.debug("deleted successfully");
                }
            }
        }
        catch (Exception e) {
            logger.error("an exception has occurred={}", (Throwable)e);
        }
    }
}

