/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.User;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;

@DisallowConcurrentExecution
public class BlackListUserCleanerJob
extends QuartzJobBean {
    private static Logger logger = LogManager.getLogger(BlackListUserCleanerJob.class);
    private UtilService utilService;

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public static void deleteFilesOlderThan(File directory, long cutoffDate) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    BlackListUserCleanerJob.deleteFilesOlderThan(file, cutoffDate);
                    continue;
                }
                long lastModified = file.lastModified();
                if (lastModified >= cutoffDate) continue;
                boolean deleted = file.delete();
                if (deleted) {
                    logger.debug("Deleted file: " + file.getName());
                    continue;
                }
                logger.debug("Failed to delete file: " + file.getName());
            }
        }
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blackListUserCleanerJobTrigger")) {
            logger.debug("BlackListUserCleanerJob ............... disabled");
            return;
        }
        int cloudId = 1;
        Cloud cloud = this.utilService.getCloud(cloudId);
        List blockedUsers = this.utilService.getAllBlockedUsers(cloudId);
        for (User blockUser : blockedUsers) {
            List blockedDevices = this.utilService.getAllBlockedDevices(cloudId, blockUser.getUserName());
            for (Device device : blockedDevices) {
                this.utilService.deleteAllBlukryptDbForDeviceUUID(cloud, device.getDeviceUUID(), device.getUserName(), device.getDestCollection());
                logger.debug("...delete files if any....." + blockUser.getUserName() + "....." + device.getDeviceName());
                String pathname = "/parablu/" + cloud.getCloudName() + "/upload/" + device.getDeviceUUID();
                File targetDir = new File(pathname);
                long cutoffDate = System.currentTimeMillis() - (long)(cloud.getNoDayOldFilesDelForBlockedUser() * 24 * 60 * 60 * 1000);
                logger.debug("...cutoffdate...." + cutoffDate);
                BlackListUserCleanerJob.deleteFilesOlderThan(targetDir, cutoffDate);
            }
        }
        List blackListUsers = this.utilService.getAllBlackListUsers(cloudId);
        logger.debug("************* Black List User Cleaner Job started ***********" + CollectionUtils.isEmpty((Collection)blackListUsers));
        List localBlackListUsers = this.utilService.getAllUniqueBlackListUsersFromLocal(cloudId, cloud.getCloudName());
        logger.debug("@@@@BlackListUserFilesRetryJob started .... ");
        ArrayList<String> blackListUsersFromMain = new ArrayList<String>();
        for (BlackListUser blackListUser : blackListUsers) {
            logger.debug("..check user... " + blackListUser.getUserName());
            User user = this.utilService.getUserInfoByName(cloudId, blackListUser.getUserName());
            if (user != null && user.isBackupTargetAssigned()) {
                this.utilService.deleteBlackListUserByUserName(cloudId, blackListUser.getUserName());
                this.utilService.changeTargetAssignByUserName(cloudId, blackListUser.getUserName());
                continue;
            }
            blackListUsersFromMain.add(blackListUser.getUserName());
        }
        localBlackListUsers.removeAll(blackListUsersFromMain);
        logger.debug("..localBlackListUsers..." + localBlackListUsers.size());
        logger.debug("************* Black List User Cleaner Job started ***********");
        if (!CollectionUtils.isEmpty((Collection)localBlackListUsers)) {
            localBlackListUsers.parallelStream().forEach(userName -> {
                logger.debug("... unique users list ..." + userName);
                this.utilService.restoreMultiFileForBlackListUser(userName, cloud);
                logger.debug("... user file moved... ");
            });
        }
    }
}

