/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pmm.service.impl;

import com.parablu.helper.constant.GeneralHelperConstant;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MediaElement;
import com.parablu.paracloud.element.MediaListElement;
import com.parablu.paracloud.element.MediaValidationElement;
import com.parablu.paracloud.element.response.MediaListResponseElement;
import com.parablu.paracloud.util.DiskSpaceHelper;
import com.parablu.paracloud.util.FileTypeHelper;
import com.parablu.paracloud.util.PathConversionHelper;
import com.parablu.paracloud.util.PathGenerator;
import com.parablu.paracloud.util.ThumbnailHelper;
import com.parablu.pcbd.dao.MediaImageDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MediaImage;
import com.parablu.pmm.exception.ParacloudMediaException;
import com.parablu.pmm.service.MediaService;
import com.parablu.pmm.util.MediaObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediaServiceImpl
implements MediaService {
    private Logger logger = LogManager.getLogger(MediaServiceImpl.class);
    private static final String WINDOWS_OS = "win";
    private MediaImageDao mediaImageDao;

    public void setMediaImageDao(MediaImageDao mediaImageDao) {
        this.mediaImageDao = mediaImageDao;
    }

    @Override
    public MediaImage readFromMediaTable(int cloudId, String cloudName, String fileName) {
        return this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, fileName);
    }

    @Override
    public void saveToDatabase(int cloudId, String cloudName, MediaImage mediaImage) {
        this.mediaImageDao.saveImage(cloudId, cloudName, mediaImage);
    }

    @Override
    public MediaListResponseElement validateMediaFiles(int cloudId, String cloudName, String deviceRegid, MediaValidationElement mediaSyncListElement, boolean completeMediaIntegrity, Device device) {
        boolean isAndroidDevice = true;
        if (device == null) {
            throw new ParacloudMediaException("Device  not found ", 500);
        }
        String deviceOperatingSystem = device.getOsType();
        if (deviceOperatingSystem == null) {
            throw new ParacloudMediaException("Exception as dao record is null", 500);
        }
        deviceOperatingSystem = deviceOperatingSystem.toLowerCase();
        if (deviceOperatingSystem.toLowerCase().contains(WINDOWS_OS)) {
            isAndroidDevice = false;
        }
        List newFileElements = mediaSyncListElement.getFilesToAddList().getMediaFileElementList();
        List<MediaImage> filesNotToUpload = this.getFilesNotToUpload(cloudId, cloudName, isAndroidDevice, newFileElements);
        List<MediaElement> fileNotToUploadMediaElements = MediaObjectUtils.convertMediaImageListToMediaElementList(filesNotToUpload);
        MediaListResponseElement mediaListResponseElement = new MediaListResponseElement();
        MediaListElement fileListElement = new MediaListElement();
        fileListElement.setMediaFileElementList(fileNotToUploadMediaElements);
        mediaListResponseElement.setFilesNotToAddList(fileListElement);
        return mediaListResponseElement;
    }

    private List<MediaImage> getFilesNotToUpload(int cloudId, String cloudName, boolean isAndroidDevice, List<MediaElement> newFileElements) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        HashMap<String, String> md5FileNameMap = new HashMap<String, String>();
        for (MediaElement mediaElement : newFileElements) {
            fileNameList.add(mediaElement.getFileName());
            md5FileNameMap.put(mediaElement.getFileName(), mediaElement.getMd5checksum());
        }
        List mediaImages = this.mediaImageDao.getFilesAlreadyPresentFromUploadList(cloudId, cloudName, fileNameList);
        ArrayList<MediaImage> duplicateMediaImages = new ArrayList<MediaImage>();
        for (MediaImage mediaImage : mediaImages) {
            String md5 = (String)md5FileNameMap.get(mediaImage.getFileName());
            if (md5 == null || !md5.equals(mediaImage.getMd5Checksum())) continue;
            if (!isAndroidDevice) {
                mediaImage.setClientFilePath(PathConversionHelper.getServerCompatiblePath((String)mediaImage.getClientFilePath(), (boolean)isAndroidDevice));
            }
            duplicateMediaImages.add(mediaImage);
        }
        return duplicateMediaImages;
    }

    @Override
    public int changeWebDAVStatus(int cloudId, String cloudName, String userName, String password, String status) {
        String scriptBinDirectory = PCHelperConstant.getPropertyFileValueScriptsBinDir();
        scriptBinDirectory = scriptBinDirectory + "/wedav";
        if ("enable".equals(status) || "disable".equals(status)) {
            ProcessBuilder probuilder = "disable".equals(status) ? new ProcessBuilder("sudo", scriptBinDirectory + status + ".sh", cloudName) : new ProcessBuilder("sudo", scriptBinDirectory + status + ".sh", cloudName, userName, password);
            try {
                Process p = probuilder.start();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)p.getInputStream(), (Writer)writer, (String)"UTF-8");
                String processLog = writer.toString();
                IOUtils.closeQuietly((InputStream)p.getInputStream());
                this.logger.debug(processLog);
                if (p.waitFor() != 0) {
                    IOUtils.copy((InputStream)p.getErrorStream(), (Writer)writer, (String)"UTF-8");
                    String error = writer.toString();
                    IOUtils.closeQuietly((InputStream)p.getErrorStream());
                    throw new BaseException("Error in return of p.waitFor()" + error, 0);
                }
            }
            catch (Exception exp) {
                this.logger.debug("changeWebDAVStatus : ", (Throwable)exp);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean getWebDAVStatus(int cloudId, String cloudName) {
        return false;
    }

    @Override
    public void deleteFilePermanently(int cloudId, String cloudName, Cloud cloud, MediaElement mediaElement) {
        MediaImage mediaImage = this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, mediaElement.getFileName());
        if (mediaImage == null) {
            throw new ParacloudMediaException("File not found", 400);
        }
        String filePath = mediaImage.getFileSystemPath();
        String fileName = mediaImage.getFileName();
        this.mediaImageDao.removeEntryFromTable(cloudId, cloudName, mediaImage);
        File file = new File(PCHelperConstant.getPropertyFileValueParabluMediaFolderBasePath((String)cloud.getCloudName()) + mediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        if (file.exists()) {
            long fileSize = file.length();
            if (!file.delete()) {
                DiskSpaceHelper.updateCloudSize((String)cloud.getCloudName(), (int)0, (long)fileSize);
                throw new ParacloudMediaException("File could not be deleted", 500);
            }
        }
        this.deleteThumbNailFile(cloud, mediaImage, fileName);
    }

    private void deleteThumbNailFile(Cloud cloud, MediaImage mediaImage, String fileName) {
        File thumbNailFile = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloud.getCloudName()) + mediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + mediaImage.getThumbNailPath());
        thumbNailFile.delete();
    }

    @Override
    public void uploadMediaFile(int cloudId, String cloudName, Cloud cloud, MediaElement mediaElement, String uploadPath, Device device, String fileExtension, String mediaType) throws IOException {
        MediaImage mediaImage = this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, mediaElement.getFileName());
        String oldMediaFile = mediaElement.getFileName();
        if (mediaImage != null) {
            String newFileName = this.generateNewNameForFile(cloudId, cloudName, mediaImage.getFileName());
            mediaElement.setFileName(newFileName);
        }
        MediaImage mediaImage2 = MediaObjectUtils.convertMediaElementToMediaImage(mediaElement);
        String fileSysPath = PathGenerator.getFsPathForMediaFiles();
        mediaImage2.setFileSystemPath(fileSysPath);
        mediaImage2.setFolder(false);
        this.generateThumbNailPath(mediaImage2, fileSysPath);
        mediaImage2.setLastClientModifiedTime(System.currentTimeMillis());
        mediaImage2.setExtension(fileExtension);
        mediaImage2.setMediaType(mediaType);
        mediaImage2.setDevice(device);
        String filePath = mediaImage2.getFileSystemPath();
        String fileName = mediaElement.getFileName();
        File sourceFile = new File(uploadPath + oldMediaFile);
        mediaImage2.setSize((double)(sourceFile.length() / 1024L));
        mediaImage2.setUserName(device.getUserName());
        this.mediaImageDao.saveImage(cloudId, cloudName, mediaImage2);
        File destinationFile = new File(PCHelperConstant.getPropertyFileValueParabluMediaFolderBasePath((String)cloud.getCloudName()) + mediaType + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        File parentFile = destinationFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new ParacloudMediaException("Parent Files Failed to be created", 500);
        }
        FileUtils.moveFile((File)sourceFile, (File)destinationFile);
        ThumbnailHelper.createThumbnails((String)cloud.getCloudName(), (String)(mediaType + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + mediaImage2.getThumbNailPath()), (File)destinationFile, (String)fileExtension);
        DiskSpaceHelper.updateCloudSize((String)cloud.getCloudName(), (int)2, (long)destinationFile.length());
    }

    private void generateThumbNailPath(MediaImage mediaImage2, String fileSysPath) {
        String thumbNailFileName = FilenameUtils.getBaseName((String)mediaImage2.getFileName());
        mediaImage2.setThumbNailPath(fileSysPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + thumbNailFileName + ".png");
    }

    @Override
    public void uploadMediaFile(int cloudId, String cloudName, Cloud cloud, MediaElement mediaElement) throws IOException {
        String extension = this.getExtensionOfFile(mediaElement.getFileName());
        this.uploadMediaFile(cloudId, cloudName, cloud, mediaElement, PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloud.getCloudName()), null, extension, this.getMediaTypeFromExtension(extension));
    }

    private String getMediaTypeFromExtension(String fileExtension) {
        if (FileTypeHelper.isAudioFile((String)fileExtension)) {
            return "music";
        }
        if (FileTypeHelper.isVideoFile((String)fileExtension)) {
            return "video";
        }
        return "picture";
    }

    private String getExtensionOfFile(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }

    private String generateNewNameForFile(int cloudId, String cloudName, String originalFileName) {
        int count = 1;
        String fileExtension = FilenameUtils.getExtension((String)originalFileName);
        String fileName = FilenameUtils.getBaseName((String)originalFileName);
        String newFileName = fileName + "(" + count + ")";
        while (this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, newFileName) != null) {
            newFileName = fileName + "(" + ++count + ")";
        }
        return newFileName + "." + fileExtension;
    }

    @Override
    public void renameMediaFile(int cloudId, String cloudName, Cloud cloud, MediaElement mediaElement, String destinationFileName, String userName) {
        MediaImage soruceMediaImage = this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, mediaElement.getFileName());
        MediaImage destinationMediaImage = this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, destinationFileName);
        if (destinationMediaImage != null) {
            throw new ParacloudMediaException("File already Exists", 500);
        }
        if (soruceMediaImage == null) {
            throw new ParacloudMediaException("File already Exists", 400);
        }
        String filePath = soruceMediaImage.getFileSystemPath();
        String fileName = soruceMediaImage.getFileName();
        soruceMediaImage.setFileName(destinationFileName);
        String sourceThumbNailPath = soruceMediaImage.getThumbNailPath();
        soruceMediaImage.setThumbNailPath(this.generateRenamedThumbnauilPath(destinationFileName, filePath));
        soruceMediaImage.setUserName(userName);
        this.mediaImageDao.saveImage(cloudId, cloudName, soruceMediaImage);
        File sourceFile = new File(PCHelperConstant.getPropertyFileValueParabluMediaFolderBasePath((String)cloud.getCloudName()) + soruceMediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + fileName);
        File destination = new File(PCHelperConstant.getPropertyFileValueParabluMediaFolderBasePath((String)cloud.getCloudName()) + soruceMediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + destinationFileName);
        if (!sourceFile.renameTo(destination)) {
            throw new ParacloudMediaException("Rename Failed", 500);
        }
        this.renameThumbnail(cloud, soruceMediaImage, sourceThumbNailPath);
    }

    private String generateRenamedThumbnauilPath(String destinationFileName, String filePath) {
        String baseFileName = FilenameUtils.getBaseName((String)destinationFileName);
        return filePath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + baseFileName + ".png";
    }

    private void renameThumbnail(Cloud cloud, MediaImage soruceMediaImage, String sourceThumbnailPath) {
        File tSourceFile = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloud.getCloudName()) + soruceMediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + sourceThumbnailPath);
        File tDestination = new File(PCHelperConstant.getPropertyFileValueParabluThumbnailsBasePath((String)cloud.getCloudName()) + soruceMediaImage.getMediaType() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + soruceMediaImage.getThumbNailPath());
        tSourceFile.renameTo(tDestination);
    }

    @Override
    public List<MediaElement> getAllMediaImagesBytype(int cloudId, String cloudName, String type) {
        List images = this.mediaImageDao.getAllMediaForMediaType(cloudId, cloudName, type);
        return MediaObjectUtils.convertMediaImageListToMediaElementList(images);
    }

    @Override
    public MediaElement getElementForFile(int cloudId, String cloudName, String fileName) {
        MediaImage image = this.mediaImageDao.getMediaImageForFile(cloudId, cloudName, fileName);
        return MediaObjectUtils.convertMediaImageToMediaElement(image, image.getDevice().getUserName());
    }
}

