/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.controller;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MediaElement;
import com.parablu.paracloud.element.MediaListElement;
import com.parablu.paracloud.element.MediaValidationElement;
import com.parablu.paracloud.element.response.MediaListResponseElement;
import com.parablu.pcbd.domain.User;
import com.parablu.pmm.delegate.MediaUploadService;
import com.parablu.pmm.exception.ParacloudMediaException;
import com.parablu.pmm.service.MediaService;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import com.parablu.rf.exception.ResourceFunnelException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MediaController
extends BaseController {
    private static Logger logger = LogManager.getLogger(MediaController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private MediaUploadService mediaUploadService;
    @Autowired
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    private static final String STATUS = "status";
    private static final String PARACLOUD_MEDIA_EXCEPTION = "ParacloudMediaException";
    private static final String APPLICATION_XML = "application/xml";
    private static final String FILE_NAME = "fileName";

    @RequestMapping(value={"/cloud/{cloudName}/crawl/media"}, method={RequestMethod.POST})
    public ModelAndView validateMediaSync(@PathVariable(value="cloudName") String cloudName, @RequestBody MediaValidationElement mediaSyncListElement, HttpServletRequest request, HttpServletResponse response) {
        logger.trace("CrawlController . getDeltaDifference");
        String token = request.getHeader("token");
        String cloudNameTemp = cloudName;
        ModelAndView modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp = cl.getCloud().getCloudName(), token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        try {
            MediaListResponseElement serverResponse = this.mediaService.validateMediaFiles(cloudId, cloudNameTemp, code.getDevice().getDeviceUUID(), mediaSyncListElement, false, code.getDevice());
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName("gzipview");
            modelAndView.addObject((Object)serverResponse);
        }
        catch (ParacloudMediaException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while validating media sync " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.debug("Error in crawl getDeltaDifference " + e);
            response.setHeader("errorMessage", e.toString());
            response.setStatus(500);
        }
        return modelAndView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/cloud/{cloudName}/upload/media"}, method={RequestMethod.PUT})
    public void uploadMediaFile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        MediaElement mediaFileElement = null;
        InputStream inputStream = null;
        String token = request.getHeader("token");
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            this.closeInputStreamIfExists(request);
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        try {
            mediaFileElement = new MediaElement();
            String headerEncoding = request.getHeader("header-encoding");
            if (headerEncoding != null && "base64".equalsIgnoreCase(headerEncoding)) {
                mediaFileElement.setFileName(this.decodeBase64UTFString(request.getHeader("file-name")));
                mediaFileElement.setFileCompletePath(this.decodeBase64UTFString(request.getHeader("file-path")));
                mediaFileElement.setMetaData(this.decodeBase64UTFString(request.getHeader("meta-data")));
                mediaFileElement.setExtension(this.decodeBase64UTFString(request.getHeader("extension")));
            } else {
                mediaFileElement.setFileName(request.getHeader("file-name"));
                mediaFileElement.setFileCompletePath(request.getHeader("file-path"));
                mediaFileElement.setMetaData(request.getHeader("meta-data"));
                mediaFileElement.setExtension(request.getHeader("extension"));
            }
            mediaFileElement.setFolder(Boolean.valueOf(request.getHeader("is-folder")).booleanValue());
            mediaFileElement.setMd5checksum(request.getHeader("fileMD5"));
            mediaFileElement.setSize(request.getHeader("file-size"));
            String fileModifiedTimestamp = request.getHeader("modified");
            mediaFileElement.setLastModifiedTimestamp(Long.valueOf(fileModifiedTimestamp).longValue());
            mediaFileElement.setMediaType(request.getHeader("media-type"));
            long cloudSizeAllowedInBytes = (long)((float)(this.licenseService.getCloudDiskSpaceLimit(cloudNameTemp) * 1024L * 1024L) * 0.95f);
            if (mediaFileElement.isFolder()) {
                this.mediaUploadService.uploadFileAsMedia(cloudId, cloudNameTemp, cl.getCloud(), null, mediaFileElement, 0, cloudSizeAllowedInBytes, code.getDevice());
            } else {
                inputStream = request.getInputStream();
                this.mediaUploadService.uploadFileAsMedia(cloudId, cloudNameTemp, cl.getCloud(), inputStream, mediaFileElement, 0, cloudSizeAllowedInBytes, code.getDevice());
            }
            response.setStatus(200);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudNameTemp, "uploaded", code.getDevice().getUserName(), mediaFileElement.getFileName(), code.getDevice().getDeviceName(), System.currentTimeMillis(), PCActionTypes.FILE_UPLOAD.getActionTypeValue());
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while uploading media file " + e.getMessage());
            response.setHeader("errorMessage", e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception while uploading media file " + e.getMessage());
            response.setHeader("errorMessage", e.getMessage());
            response.setStatus(500);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.debug("IOException ", (Throwable)e);
                }
            }
            try {
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.debug("IOException ", (Throwable)e);
            }
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/media/files/upload"}, method={RequestMethod.POST})
    public void uploadMediaResource(@PathVariable(value="cloudName") String cloudName, @RequestBody MediaElement fileElement, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        String applicationType = request.getContentType();
        String cloudNameTemp = cloudName;
        if (applicationType == null) {
            applicationType = APPLICATION_XML;
        }
        if (APPLICATION_XML.equalsIgnoreCase(applicationType)) {
            modelAndView.setViewName("xmlview");
        } else {
            modelAndView.setViewName("jsonview");
        }
        logger.debug("Calling upload for fileName: " + fileElement.getFileName() + " and the relative path: " + fileElement.getFileCompletePath());
        CloudLicenseTo cl = this.licenseService.validateLicenseAndStorageRestrictions(cloudNameTemp);
        cloudNameTemp = cl.getCloud().getCloudName();
        if (!this.checkLicense(cl, response)) {
            File f = new File(PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudNameTemp) + fileElement.getFileName());
            if (f.exists()) {
                f.delete();
            }
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        try {
            this.mediaService.uploadMediaFile(cloudId, cloudNameTemp, cl.getCloud(), fileElement);
        }
        catch (ParacloudMediaException e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)((Object)e));
            response.setStatus(e.getErrorStatus());
            return;
        }
        catch (Exception e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/media/files/info"}, method={RequestMethod.GET})
    public ModelAndView getMediaFileInfo(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String token;
        String fileName = request.getHeader(FILE_NAME);
        String cloudNameTemp = cloudName;
        ModelAndView modelAndView = new ModelAndView();
        String applicationType = request.getContentType();
        if (applicationType == null) {
            applicationType = APPLICATION_XML;
        }
        if (APPLICATION_XML.equalsIgnoreCase(applicationType)) {
            modelAndView.setViewName("xmlview");
        } else {
            modelAndView.setViewName("jsonview");
        }
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
            return null;
        }
        try {
            MediaElement mediaElement = this.mediaService.getElementForFile(cloudId, cloudNameTemp, fileName);
            modelAndView.addObject((Object)mediaElement);
        }
        catch (ParacloudMediaException e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)((Object)e));
            response.setStatus(e.getErrorStatus());
            return null;
        }
        catch (Exception e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/media/files/rename"}, method={RequestMethod.POST})
    public void renameResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String token;
        String sourceFileName = request.getHeader(FILE_NAME);
        String cloudNameTemp = cloudName;
        String destFileName = request.getHeader("destinationFileName");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        User user = new User();
        cloudNameTemp = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        MediaElement mediaElement = new MediaElement();
        try {
            mediaElement.setFileName(sourceFileName);
            this.mediaService.renameMediaFile(cloudId, cloudNameTemp, cl.getCloud(), mediaElement, destFileName, user.getUserName());
        }
        catch (ParacloudMediaException e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)((Object)e));
            response.setStatus(e.getErrorStatus());
            return;
        }
        catch (Exception e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/media/files/delete"}, method={RequestMethod.DELETE})
    public void deleteResource(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String fileName = request.getHeader(FILE_NAME);
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        String token = request.getHeader("token");
        cloudNameTemp = cl.getCloud().getCloudName();
        if (!this.performAuthorization(cloudId, cloudNameTemp, token, response)) {
            return;
        }
        if (!this.checkIfDeviceIsAttached(cl.getCloud().getCloudName(), response)) {
            return;
        }
        MediaElement fileElement = new MediaElement();
        fileElement.setFileName(fileName);
        try {
            this.mediaService.deleteFilePermanently(cloudId, cloudNameTemp, cl.getCloud(), fileElement);
        }
        catch (ParacloudMediaException e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)((Object)e));
            response.setStatus(e.getErrorStatus());
            return;
        }
        catch (Exception e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/media/children"}, method={RequestMethod.GET})
    public ModelAndView getMediaList(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String token;
        ModelAndView modelAndView = new ModelAndView();
        String cloudNameTemp = cloudName;
        String applicationType = request.getContentType();
        if (applicationType == null) {
            applicationType = APPLICATION_XML;
        }
        if (APPLICATION_XML.equalsIgnoreCase(applicationType)) {
            modelAndView.setViewName("xmlview");
        } else {
            modelAndView.setViewName("jsonview");
        }
        String mediaType = request.getHeader("mediaType");
        MediaListElement mediaListElement = new MediaListElement();
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), response)) {
            return null;
        }
        try {
            List<MediaElement> mediaElements = this.mediaService.getAllMediaImagesBytype(cloudId, cloudNameTemp, mediaType);
            mediaListElement.setMediaFileElementList(mediaElements);
            mediaListElement.setTotalNoofFiles(String.valueOf(mediaElements.size()));
            modelAndView.addObject((Object)mediaListElement);
        }
        catch (ParacloudMediaException e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)((Object)e));
            response.setStatus(e.getErrorStatus());
            return null;
        }
        catch (Exception e) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)e);
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/media/webdav/status"}, method={RequestMethod.GET})
    public void checkWebDavStatus(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        cloudNameTemp = cl.getCloud().getCloudName();
        try {
            if (this.mediaService.getWebDAVStatus(cloudId, cloudNameTemp)) {
                response.setStatus(200);
                response.setHeader(STATUS, "on");
                response.getOutputStream().write("enable".getBytes());
                response.getOutputStream().flush();
            } else {
                response.setStatus(200);
                response.setHeader(STATUS, "off");
                response.getOutputStream().write("disable".getBytes());
                response.getOutputStream().flush();
            }
        }
        catch (Exception ex) {
            logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)ex);
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/media/webdav/change"}, method={RequestMethod.GET})
    public void changeWebDAVStatus(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        block8: {
            User user = new User();
            logger.trace("calling /media/webdav/change ...");
            String status = request.getHeader(STATUS);
            String cloudNameTemp = cloudName;
            String userName = request.getHeader("userName");
            String password = request.getHeader("password");
            try {
                String token;
                CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
                if (!this.checkLicense(cl, response)) {
                    return;
                }
                cloudNameTemp = cl.getCloud().getCloudName();
                int cloudId = cl.getCloud().getCloudId();
                if (!this.performAuthorization(cloudId, cloudNameTemp, token = request.getHeader("token"), user, response)) {
                    return;
                }
                if (user.isAdmin()) {
                    if ("enable".equals(status) || "disable".equals(status)) {
                        if (this.mediaService.changeWebDAVStatus(cloudId, cloudNameTemp, userName, password, status) != 0) {
                            response.setStatus(500);
                        } else {
                            response.setStatus(200);
                        }
                        break block8;
                    }
                    response.setStatus(400);
                    return;
                }
                response.setStatus(401);
                return;
            }
            catch (Exception ex) {
                logger.debug(PARACLOUD_MEDIA_EXCEPTION, (Throwable)ex);
                response.setStatus(500);
            }
        }
    }
}

