/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.sync.controller;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.MiniCloudAccessControlService;
import com.parablu.cloud.security.service.DeviceAndUserSecurityService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.cloud.security.to.DeviceStatusTo;
import com.parablu.paracloud.element.CrawlDeviceElement;
import com.parablu.paracloud.element.CrawlDeviceElementList;
import com.parablu.paracloud.element.MiniCloudCompleteElementList;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.paracloud.element.response.CrawlResponseAndMinicloudAccessListElement;
import com.parablu.paracloud.element.response.CrawlResponseElement;
import com.parablu.pcbd.domain.User;
import com.parablu.rf.delegate.CrawlDelegateService;
import com.parablu.rf.delegate.CrawlDelegateServiceAsync;
import com.parablu.rf.exception.ResourceFunnelException;
import com.parablu.rf.to.CrawlResponseAndUpdatedSearchIndexTO;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CrawlController
extends BaseController {
    private static Logger logger = LogManager.getLogger(CrawlController.class);
    private static final String EXCEPTION = "Exception";
    private static final String ERROR_MESSAGE = "errorMessage";
    private static final String EXCEPTION_WHILE_CRAWL = "Error in crawl getDeltaDifference ";
    @Autowired
    private CrawlDelegateService crawlDelegateService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private DeviceAndUserSecurityService deviceAndUserSecurityService;
    @Autowired
    private MiniCloudAccessControlService miniCloudAccessControlService;
    @Autowired
    private CrawlDelegateServiceAsync crawlDelegateServiceAsync;

    @RequestMapping(value={"/cloud/{cloudName}/crawl/initiate"}, method={RequestMethod.POST})
    public ModelAndView initiateCrawl(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("CrawlController . initiateCrawl");
        String token = request.getHeader("token");
        String cloudNameTemp = cloudName;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp = cl.getCloud().getCloudName(), token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return null;
        }
        ModelAndView modelAndView = null;
        try {
            MiniCloudCompleteElementList completeElementList = this.getAllowedAndRestrictedAccess(cloudId, cloudNameTemp, code, user);
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName("xmlview");
            modelAndView.addObject((Object)completeElementList);
        }
        catch (Exception e) {
            logger.debug(EXCEPTION, (Throwable)e);
        }
        return modelAndView;
    }

    private MiniCloudCompleteElementList getAllowedAndRestrictedAccess(int cloudId, String cloudName, DeviceStatusTo code, User user) {
        MiniCloudElementList completeAccessControls = this.miniCloudAccessControlService.getAllActiveMiniCloudsForSync(cloudId);
        MiniCloudElementList accessControls = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudName, user.getUserId());
        MiniCloudCompleteElementList completeElementList = new MiniCloudCompleteElementList();
        List restrictedAccessElemnentList = completeAccessControls.getMiniClouds();
        restrictedAccessElemnentList.removeAll(accessControls.getMiniClouds());
        List allowedAccessElemnentList = accessControls.getMiniClouds();
        MiniCloudElementList allowedMiniCloudElementList = new MiniCloudElementList();
        allowedMiniCloudElementList.setMiniClouds(allowedAccessElemnentList);
        MiniCloudElementList restrictedMiniCloudElementList = new MiniCloudElementList();
        restrictedMiniCloudElementList.setMiniClouds(restrictedAccessElemnentList);
        completeElementList.setUserMiniClouds(allowedMiniCloudElementList);
        completeElementList.setRestrictedMiniClouds(restrictedMiniCloudElementList);
        return completeElementList;
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/delta"}, method={RequestMethod.POST})
    public ModelAndView getDeltaDifference(@PathVariable(value="cloudName") String cloudName, @RequestBody CrawlDeviceElement deviceCrawlElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        boolean isMobileDevice = false;
        logger.debug("CrawlController . getDeltaDifference");
        String token = request.getHeader("token");
        String miniCloudName = request.getHeader("file-path");
        String miniCloudId = request.getHeader("multi-cloud-id");
        logger.debug("mini cloud id>>>>>>>>>>>" + miniCloudId);
        ModelAndView modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return null;
        }
        MiniCloudElementList allowedMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, user.getUserId());
        MiniCloudElement miniCloudElement = new MiniCloudElement();
        miniCloudElement.setMiniCloudName(miniCloudName);
        if (!"0".equalsIgnoreCase(miniCloudId) && !allowedMiniCloudElementList.getMiniClouds().contains(miniCloudElement)) {
            response.setStatus(400);
        }
        MiniCloudElementList allMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
        try {
            CrawlResponseAndUpdatedSearchIndexTO crawlResponseAndUpdatedSearchIndexTO = this.crawlDelegateService.findDeltaDifference(cloudId, cloudNameTemp, cl.getCloud(), deviceCrawlElement, miniCloudName, miniCloudId, code.getDevice(), allMiniCloudElementList.getMiniClouds(), isMobileDevice);
            CrawlResponseElement serverResponse = crawlResponseAndUpdatedSearchIndexTO.getCrawlResponseElement();
            this.addSearchIndexToTable(cl.getCloud(), crawlResponseAndUpdatedSearchIndexTO.getSearchIndexs());
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName("gzipview");
            modelAndView.addObject((Object)serverResponse);
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting delta diffrence " + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.debug(EXCEPTION_WHILE_CRAWL + e);
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/delta/async"}, method={RequestMethod.POST})
    public void getDeltaDifferenceAsync(@PathVariable(value="cloudName") String cloudName, @RequestBody CrawlDeviceElementList crawlDeviceElementList, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        boolean isMobileDevice = false;
        logger.debug("CrawlController . getDeltaDifference Async");
        String token = request.getHeader("token");
        Object modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return;
        }
        List crawlDeviceElements = crawlDeviceElementList.getCrawlDeviceElements();
        for (CrawlDeviceElement crawlDeviceElement : crawlDeviceElements) {
            MiniCloudElementList allowedMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, user.getUserId());
            MiniCloudElement miniCloudElement = new MiniCloudElement();
            miniCloudElement.setMiniCloudName(crawlDeviceElement.getMiniCloudName());
            if ("0".equalsIgnoreCase(crawlDeviceElement.getMiniCloudId()) || allowedMiniCloudElementList.getMiniClouds().contains(miniCloudElement)) continue;
            response.setStatus(400);
        }
        MiniCloudElementList allMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
        try {
            String pollId = UUID.randomUUID().toString();
            logger.debug("Initial PollId : " + pollId);
            long crawlStatusTimestamp = System.currentTimeMillis();
            this.crawlDelegateServiceAsync.saveCrawlStatus(cloudId, cloudName, pollId, crawlStatusTimestamp);
            this.crawlDelegateServiceAsync.findDeltaDifferenceAsync(cloudId, cloudNameTemp, cl.getCloud(), crawlDeviceElements, code.getDevice(), allMiniCloudElementList.getMiniClouds(), isMobileDevice, pollId);
            response.setHeader("pollId", pollId);
            response.addHeader("deltaStatus", "InProgress");
            response.setStatus(202);
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting delta diffrence " + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.debug(EXCEPTION_WHILE_CRAWL + e);
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/mc/delta/async"}, method={RequestMethod.POST})
    public void getMiniCloudDeltaAsync(@PathVariable(value="cloudName") String cloudName, @RequestBody CrawlDeviceElementList crawlDeviceElementList, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        logger.debug("CrawlController . Minicloud getDeltaDifference");
        boolean isMobileDevice = false;
        String token = request.getHeader("token");
        Object modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return;
        }
        List crawlDeviceElements = crawlDeviceElementList.getCrawlDeviceElements();
        for (CrawlDeviceElement crawlDeviceElement : crawlDeviceElements) {
            MiniCloudElementList allowedMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, user.getUserId());
            MiniCloudElement miniCloudElement = new MiniCloudElement();
            miniCloudElement.setMiniCloudName(crawlDeviceElement.getMiniCloudName());
            if ("0".equalsIgnoreCase(crawlDeviceElement.getMiniCloudId()) || allowedMiniCloudElementList.getMiniClouds().contains(miniCloudElement)) continue;
            response.setStatus(400);
        }
        MiniCloudElementList allMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
        try {
            String pollId = UUID.randomUUID().toString();
            logger.debug("Initial PollId : " + pollId);
            long crawlStatusTimestamp = System.currentTimeMillis();
            this.crawlDelegateServiceAsync.saveCrawlStatus(cloudId, cloudName, pollId, crawlStatusTimestamp);
            this.crawlDelegateServiceAsync.findDeltaDifferenceAsync(cloudId, cloudNameTemp, cl.getCloud(), crawlDeviceElements, code.getDevice(), allMiniCloudElementList.getMiniClouds(), isMobileDevice, pollId);
            response.setHeader("pollId", pollId);
            response.addHeader("deltaStatus", "InProgress");
            response.setStatus(202);
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting minicloud children " + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.debug(EXCEPTION_WHILE_CRAWL + e);
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
        }
        logger.debug("end of CrawlController . Minicloud getDeltaDifference");
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/delta/status"}, method={RequestMethod.GET})
    public void getDeltaStatus(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Getting the delta status");
        String pollId = request.getHeader("pollId");
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return;
        }
        try {
            String status = this.crawlDelegateServiceAsync.getDeltaStatus(cloudId, cloudName, pollId);
            logger.debug("Delta status : " + status);
            response.setHeader("deltaStatus", status);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.error("Exception occurred while getting the delta status : " + e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
        }
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/delta/result"}, method={RequestMethod.GET})
    public ModelAndView getDeltaResult(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("Getting the delta result");
        String pollId = request.getHeader("pollId");
        String token = request.getHeader("token");
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudName, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return null;
        }
        ModelAndView modelAndView = null;
        try {
            CrawlResponseAndUpdatedSearchIndexTO crawlResponseAndUpdatedSearchIndexTO = this.crawlDelegateServiceAsync.getDeltaResult(cloudId, cloudName, pollId);
            if (crawlResponseAndUpdatedSearchIndexTO != null) {
                CrawlResponseElement serverResponse = crawlResponseAndUpdatedSearchIndexTO.getCrawlResponseElement();
                this.addSearchIndexToTable(cl.getCloud(), crawlResponseAndUpdatedSearchIndexTO.getSearchIndexs());
                response.setStatus(200);
                modelAndView = new ModelAndView();
                modelAndView.setViewName("gzipview");
                modelAndView.addObject((Object)serverResponse);
            } else {
                response.setStatus(500);
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while getting the delta status : " + e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
        }
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/crawl/mc/delta"}, method={RequestMethod.POST})
    public ModelAndView getMiniCloudChildren(@PathVariable(value="cloudName") String cloudName, @RequestBody CrawlDeviceElement deviceCrawlElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        logger.debug("CrawlController . Minicloud getDeltaDifference");
        boolean isMobileDevice = false;
        String token = request.getHeader("token");
        String miniCloudName = request.getHeader("file-path");
        String miniCloudId = request.getHeader("multi-cloud-id");
        logger.debug("mini cloud id>>>>>>>>>>>" + miniCloudId);
        ModelAndView modelAndView = null;
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return null;
        }
        MiniCloudElementList allowedMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, user.getUserId());
        MiniCloudElement miniCloudElement = new MiniCloudElement();
        miniCloudElement.setMiniCloudName(miniCloudName);
        if (!"0".equalsIgnoreCase(miniCloudId) && !allowedMiniCloudElementList.getMiniClouds().contains(miniCloudElement)) {
            response.setStatus(400);
        }
        MiniCloudElementList allMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
        try {
            CrawlResponseAndUpdatedSearchIndexTO crawlResponseAndUpdatedSearchIndexTO = this.crawlDelegateService.findDeltaDifference(cloudId, cloudNameTemp, cl.getCloud(), deviceCrawlElement, miniCloudName, miniCloudId, code.getDevice(), allMiniCloudElementList.getMiniClouds(), isMobileDevice);
            CrawlResponseElement serverResponse = crawlResponseAndUpdatedSearchIndexTO.getCrawlResponseElement();
            this.addSearchIndexToTable(cl.getCloud(), crawlResponseAndUpdatedSearchIndexTO.getSearchIndexs());
            response.setStatus(200);
            modelAndView = new ModelAndView();
            modelAndView.setViewName("gzipview");
            modelAndView.addObject((Object)serverResponse);
        }
        catch (ResourceFunnelException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Exception while getting minicloud children " + e.getMessage());
            response.setHeader(ERROR_MESSAGE, e.getErrMsg());
            response.setStatus(e.getResponseCode());
        }
        catch (Exception e) {
            logger.debug(EXCEPTION_WHILE_CRAWL + e);
            response.setHeader(ERROR_MESSAGE, e.toString());
            response.setStatus(500);
        }
        logger.debug("end of CrawlController . Minicloud getDeltaDifference");
        return modelAndView;
    }

    @RequestMapping(value={"/cloud/{cloudName}/mobile/crawl/delta"}, method={RequestMethod.POST})
    public ModelAndView getDeltaDifferenceForMobile(@PathVariable(value="cloudName") String cloudName, HttpServletRequest request, HttpServletResponse response) {
        String cloudNameTemp = cloudName;
        logger.debug("CrawlController . getDeltaDifference");
        boolean isMobileDevice = true;
        String token = request.getHeader("token");
        String lastSuccessfulCrawlTimeStamp = request.getHeader("lastSuccessCrawl");
        String currentCrawlTimeStamp = request.getHeader("currentCrawl");
        CrawlResponseElement serverResponse = new CrawlResponseElement();
        CrawlDeviceElement deviceCrawlElement = new CrawlDeviceElement();
        CrawlResponseAndMinicloudAccessListElement crawlResponseAndMinicloudAccessListElement = new CrawlResponseAndMinicloudAccessListElement();
        if (StringUtils.isEmpty((String)currentCrawlTimeStamp) || StringUtils.isEmpty((String)lastSuccessfulCrawlTimeStamp)) {
            return null;
        }
        CloudLicenseTo cl = this.licenseService.validateLicense(cloudNameTemp);
        if (!this.checkLicense(cl, response)) {
            return null;
        }
        cloudNameTemp = cl.getCloud().getCloudName();
        int cloudId = cl.getCloud().getCloudId();
        DeviceStatusTo code = this.deviceAndUserSecurityService.validateDevice(cloudId, cloudNameTemp, token, cl.getCloud());
        if (!this.checkLicense(code.getStatus(), response)) {
            return null;
        }
        User user = new User();
        if (!this.performAuthorization(cloudId, cloudName, token, user, response)) {
            return null;
        }
        if (!this.checkIfUserIsValid(user, 1, response)) {
            return null;
        }
        deviceCrawlElement.setCurrentCrawlTimestamp(currentCrawlTimeStamp);
        deviceCrawlElement.setLastsuccessfulCrawlTimeStamp(lastSuccessfulCrawlTimeStamp);
        MiniCloudCompleteElementList completeElementList = this.getAllowedAndRestrictedAccess(cloudId, cloudNameTemp, code, user);
        MiniCloudElementList allowedMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniCloudsForUser(cloudId, cloudNameTemp, user.getUserId());
        MiniCloudElement miniCloudElement = new MiniCloudElement();
        miniCloudElement.setMiniCloudName("ParaBlu");
        miniCloudElement.setId("0");
        allowedMiniCloudElementList.getMiniClouds().add(miniCloudElement);
        MiniCloudElementList allMiniCloudElementList = this.miniCloudAccessControlService.getAllMiniClouds(cloudId, cloudNameTemp);
        for (MiniCloudElement cloudElement : allowedMiniCloudElementList.getMiniClouds()) {
            try {
                CrawlResponseAndUpdatedSearchIndexTO crawlResponseAndUpdatedSearchIndexTO = this.crawlDelegateService.findDeltaDifference(cloudId, cloudNameTemp, cl.getCloud(), deviceCrawlElement, cloudElement.getMiniCloudName(), cloudElement.getId(), code.getDevice(), allMiniCloudElementList.getMiniClouds(), isMobileDevice);
                CrawlResponseElement responseElement = crawlResponseAndUpdatedSearchIndexTO.getCrawlResponseElement();
                this.addSearchIndexToTable(cl.getCloud(), crawlResponseAndUpdatedSearchIndexTO.getSearchIndexs());
                serverResponse.getDeletedFileList().getFileElementList().addAll(responseElement.getDeletedFileList().getFileElementList());
                serverResponse.getDownloadFileList().getFileElementList().addAll(responseElement.getDownloadFileList().getFileElementList());
                serverResponse.getFilesNotToAddList().getFileElementList().addAll(responseElement.getFilesNotToAddList().getFileElementList());
                serverResponse.getRenameList().getFileElementList().addAll(responseElement.getRenameList().getFileElementList());
                response.setStatus(200);
            }
            catch (ResourceFunnelException e) {
                logger.trace("ResourceFunnelException" + (Object)((Object)e));
                logger.error("ResourceFunnelException" + e.getMessage());
                response.setHeader(ERROR_MESSAGE, e.getErrMsg());
                response.setStatus(e.getResponseCode());
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
                logger.debug(EXCEPTION_WHILE_CRAWL + e);
                response.setHeader(ERROR_MESSAGE, e.toString());
                response.setStatus(500);
            }
        }
        crawlResponseAndMinicloudAccessListElement.setCrawlRspElement(serverResponse);
        crawlResponseAndMinicloudAccessListElement.setMinicloudlist(completeElementList);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        modelAndView.addObject((Object)crawlResponseAndMinicloudAccessListElement);
        return modelAndView;
    }
}

