/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.sync.element.SyncOverviewElement;
import com.parablu.bluvault.sync.element.SyncOverviewExcelElement;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.packs.constants.OrderConstants;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.AuditHistoryElement;
import com.parablu.paracloud.element.BackupActivityHistoryElement;
import com.parablu.paracloud.element.BackupAttemptElement;
import com.parablu.paracloud.element.BackupBatchReportElement;
import com.parablu.paracloud.element.BackupHistoryElement;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.paracloud.element.CloudOverviewElement;
import com.parablu.paracloud.element.CloudPropertyElement;
import com.parablu.paracloud.element.DailyUserBackupOverViewElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.DevicePolicyDetailsElement;
import com.parablu.paracloud.element.DiskSpaceElement;
import com.parablu.paracloud.element.FileElement;
import com.parablu.paracloud.element.LicenseElement;
import com.parablu.paracloud.element.MSPCloudOverviewElement;
import com.parablu.paracloud.element.NotificationElementList;
import com.parablu.paracloud.element.NotificationHistoryElement;
import com.parablu.paracloud.element.PackElement;
import com.parablu.paracloud.element.PolicyStatisticsElement;
import com.parablu.paracloud.element.ReportSchedulerElement;
import com.parablu.paracloud.element.RestoreEventsElement;
import com.parablu.paracloud.element.RestoreHistoryElement;
import com.parablu.paracloud.element.StorageInfoElement;
import com.parablu.paracloud.element.UserDeviceHistoryElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.paracloud.element.UserMTBackupElement;
import com.parablu.paracloud.element.UserMigratedElement;
import com.parablu.paracloud.element.bp.UserPolicyMappingElement;
import com.parablu.paracloud.element.productOverviewElement;
import com.parablu.paracloud.util.DateUtil;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.ConsolidatedImageDao;
import com.parablu.pcbd.dao.DailyUserBackupOverviewDao;
import com.parablu.pcbd.dao.DeviceBackupJobDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.EventHubDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.MigrationStatusDao;
import com.parablu.pcbd.dao.PacksDao;
import com.parablu.pcbd.dao.PortalPropertiesDao;
import com.parablu.pcbd.dao.ReportConfigDao;
import com.parablu.pcbd.dao.ReportSchedulerDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupAttempt;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CPBackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ExceptionsToExclusionsFolders;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.GlobalExcludedFolders;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.MigrationStatus;
import com.parablu.pcbd.domain.NoBkpSchedule;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PortalProperties;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.ReportConfig;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.ReportScheduler;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import com.parablu.report.service.ReportService;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReportServiceImpl
implements ReportService {
    public static final String BACKUP_NOT_COMPLETED = "Backup Not Completed";
    public static final String BACKUP_NOT_STARTED = "Backup Not Started";
    public static final String POLICY_NAME = "Backup Policy Name";
    public static final String SHAREPOINT_POLICY_NAME = "Sharepoint Policy Name";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    public static final String PRESCAN_COMMAND_EXECUTION = "PRESCAN_COMMAND_EXECUTION";
    private static final String USER_NAME = "User Name";
    private static final String DEVICE_NAME = "Asset Name";
    private static final String ASSET_NAME = "Asset Name";
    private static final String SITE_NAME = "Site Name";
    private static final String RESTORE = "RESTORE";
    private static final String POLICYNAME = "PolicyName";
    private static final String DESCRIPTION = "Description";
    private static final String SCHEDULES = "Schedules";
    private static final String NO_BACKUP_SCHEDULES = "No_Backup_windows";
    private static final String MAXVERSIONS = "Maximum number of Versions Allowed";
    private static final String MAXPERMISSIBLEFILESIZE = "Maximum Permissible File Size (In MB)";
    private static final String STORAGELIMIT = "Per asset Backup Storage Limit (In GB)";
    private static final String MAXASSETSALLOWED = "Maximum Assets Allowed";
    private static final String DEFUALTFOLDERS = "Default Folders to Backup";
    private static final String EXCLUDEDFOLDERS = "Exclusion Folders Path";
    private static final String EXCEPTIONTOEXLUSIONFOLDERS = "Exceptions to exclusions";
    private static final String FILTERTYPE = "Filter type";
    private static final String FILTERNAME = "Filter(s)";
    public static final String COMPLETED = "COMPLETED";
    public static final String SL_NO = "Sl No";
    public static final String USER_ID = "User Id";
    public static final String SITE_ID = "Site Id";
    public static final String EMAIL_ID = "Email Id";
    public static final String USER_STATUS = "User Status";
    public static final String SITE_STATUS = "Site Status";
    public static final String DEVICE_STATUS = "Device Status";
    public static final String ASSET_STATUS = "Asset Status";
    public static final String DEVICE_INSTALLATION_TIME = "Device Installation Time";
    public static final String ASSET_INSTALLATION_TIME = "Asset Installation Time";
    public static final String SITE_INSTALLATION_TIME = "Site Installation Time";
    public static final String CLIENT_VERSION = "Client Version";
    public static final String FIRST_BACKUP_START_TIME = "First Backup Start Time";
    public static final String FIRST_BACKUP_END_TIME = "First Backup End Time";
    public static final String IS_FIRST_BACKUP_COMPLETED = "Is First Backup Completed";
    public static final String LAST_SUCCESSFUL_BACKUP_STRAT_TIME = "Last Successful Backup Start Time";
    public static final String LAST_SUCCESSFUL_BACKUO_END_TIME = "Last Successful Backup End Time";
    public static final String IS_LAST_BACKUP_COMPLETED = "Is Last Backup Completed";
    public static final String CURRENT_BACKUP_START_TIME = "Current Backup Start Time";
    public static final String CURRENT_BACKUP_STATUS = "Current Backup Status";
    public static final String CURRENT_BACKUP_COMPLETION = "Current Backup Completion %";
    public static final String IS_BACKUP_RUNNING = "Is Backup Running";
    public static final String LAST_TIME_HEARD = "Last Time Heard";
    public static final String TOTAL_STORAGE_UTILIZED = "Total Data Backed Up";
    public static final String NOTES = "Notes";
    public static final String FIRST_FULL_BACKUP_FILES_SIZE = "First Full Backup Files Size";
    public static final String FIRST_FULL_BACKUP_NO_OF_FILES = "First Full Backup No Of Files";
    public static final String LAST_SUCCESSFUL_BACKUP_FILES_SIZE = "Last SucessFull Backup Files Size";
    public static final String LAST_SUCCESSFUL_BACKUP_NO_OF_FILES = "Last SucessFull Backup No Of Files";
    public static final String CURRENTLY_RUNNING_BACKUO_FILES_SIZE = "Currently Running Backup Files Size";
    public static final String CURRENTLY_RUNNING_BACKUP_NO_OF_FILES = "Currently Running Backup No Of Files";
    public static final String DISPLAY_NAME = "Display Name";
    public static final String LOCATION = "Location";
    public static final String DEPARTMENT = "Department";
    public static final String AZURE_ACTIVE_DIRECTORY_USER_STATUS = "Azure Active Directory User Status";
    public static final String ACTIVE_DIRECTORY_USER_STATUS = "Active Directory User Status";
    public static final String START_TIME = "Start Time";
    public static final String END_TIME = "End Time";
    public static final String FILES_BACKED_UP = "Files Backed Up";
    public static final String REMARKS = "Remarks";
    public static final String LAST_BACKUP_IN_DAYS = "Last Backup (in Days)";
    public static final String LAST_HEARD_TIME_IN_DAYS = "Last Heard Time (in Days)";
    public static final String STORAGE_SIZE_IN_CLOUD = "Storage Size in Cloud";
    public static final String STORAGE_SIZE_IN_SERVER = "Storage Size in Server";
    public static final String ACTUAL_STORAGE_UTILIZED = "Actual Storage Utilized";
    public static final String TOTAL_SIZE_OF_DATA_BACKED_UP = "Total Size of Data Backed up";
    public static final String COMPRESSION_RATIO = "Storage Savings (In %)";
    public static final String ACTUAL_SIZE_OF_RESTORE_DATA = "Actual Size of Restorable Data(Latest version only)";
    public static final String LAST_SERVER_CONNECTION_TIME = "Last Server Connection Time";
    public static final String RESTORED_TIME = "Restored Time";
    public static final String FILES_RESTORED = "Files Restored";
    public static final String REASON = "Reason";
    public static final String CONSENT_GIVEN = "Consent Given";
    public static final String CONSENT_GIVEN_TIME = "Consent Given Time";
    public static final String NOTE = "Note:Includes all backups that have registered an incomplete status in the selected time range";
    public static final String NOTE_NOTHEARD_7DAYS = "Note:Includes all devices that have not communicated in 7 days";
    public static final String MSP_ENV_ENABLED = "MSP Environment Enabled";
    public static final String SHARE_POINT = "Sharepoint";
    public static final String ODB = "ODB";
    public static final String MICROSOFT_SHAREPOINT_DEVICE_SUFFIX = " (Microsoft SharePoint)";
    private static Logger logger = LogManager.getLogger(ReportServiceImpl.class);
    @Resource
    private BackUpImageDao backUpImageDao;
    @Resource
    private BackupBatchDao backupBatchDao;
    @Resource
    private ReportSchedulerDao reportSchedulerDao;
    @Resource
    private DeviceDao deviceDao;
    @Resource
    private UserDao userDao;
    @Resource
    private DeviceManagementService deviceManagementService;
    @Resource
    private MigrationStatusDao migrationStatusDao;
    @Resource
    private DeviceBackupJobDao deviceBackupJobDao;
    @Resource
    private ConsolidatedImageDao consolidatedImageDao;
    @Resource
    private DailyUserBackupOverviewDao dailyUserBackupOverviewDao;
    @Resource
    private ReportConfigDao reportConfigDao;
    @Resource
    private AuditHistoryDao auditHistoryDao;
    @Resource
    private EventHubDao eventHubDao;
    @Resource
    private CloudDao cloudDao;
    @Resource
    private BackupPolicyDao backupPolicyDao;
    @Resource
    private LicenseService licenseService;
    @Resource
    private PortalPropertiesDao portalPropertiesDao;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Resource
    private ExcludedFoldersDao userExcludedFoldersDao;
    @Resource
    private PacksDao packsDao;
    private ReportUtil reportUtil;
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    private static final String PARSE_EXCEPTION = " ParseException  :";
    private static final String ERROR_TRYING_TO_ADD_USER = " Error trying to add user ";
    private static final String MSG = " msg ";
    private static final String EXCEPTION = "Exception :";
    private static final String REPORT_GENERATED_ON = "Report generated on ";
    private static final String DD_MM_YYYY = "dd-MMM-yyyy";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String INVALID_DATE_VALUE = "Invalid date value ....";
    private static final String STATUS_STARTED = "STARTED";
    private static final String STATUS_SANNING = "SCANNING";
    private static final String MM_DD_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String YYYY_MM_DD = "yyyy/MM/dd";
    private static final String FROMDATE = "From Date :";
    private static final String TODATE = "To Date :";
    private static final String noOfDays = "Number of days :";
    private static final String includeDevicesHeard = "Include devices heard from days :";
    private static final String policyName = "Policy Name :";
    private static final String SHARE_POINT_POLICY_NAME = "SharePoint Policy Name";
    private static final String userName = "User ID :";
    private static final String siteName = "Site Name :";
    private static final String deviceName = "Device Name :";
    private static final String assetName = "Asset Name :";
    private static final String reason = "Reason :";
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String DD_MMM_YYYY = "dd-MMM-yyyy";

    @Override
    public List<BackupHistoryElement> getBackupHistoryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        List<Object> backupBatchList = this.getBackupBatchListFromReportQuery(cloud, reportQueryElement);
        logger.debug("before......." + backupBatchList.size());
        backupBatchList = backupBatchList.stream().filter(batch -> StringUtils.isNotEmpty((String)batch.getStatus()) && !batch.getStatus().equalsIgnoreCase(STATUS_STARTED)).collect(Collectors.toList());
        logger.debug("after......." + backupBatchList.size());
        return this.getBackupBatchElements(backupBatchList);
    }

    private List<BackupBatch> getBackupBatchListFromReportQuery(Cloud cloud, ReportQueryElement reportQueryElement) {
        List<Object> backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        String productType = "backup";
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatch(cloudId, user.getUserName(), "", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate()))));
            }
        } else {
            logger.debug("reportQueryElement.getStartDate()" + reportQueryElement.getStartDate() + ".." + reportQueryElement.getEndDate());
            logger.debug(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate()) + "..........." + ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate()));
            List backupBatchListNew = this.backupBatchDao.getAllBackupBatchForExcelWithoutPagination(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())));
            backupBatchList.addAll(backupBatchListNew);
        }
        if (PCHelperConstant.ODB_PRODUCT_TYPE.equals(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_ONEDRIVE_DEVICE)).collect(Collectors.toList());
        } else if (PCHelperConstant.SHAREPOINT_PRODUCT_TYPE.equals(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_SHAREPOINT_DEVICE)).collect(Collectors.toList());
        }
        logger.debug(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate()));
        logger.debug("backupBatchList count : " + backupBatchList.size());
        return backupBatchList;
    }

    private List<BackupBatch> getBackupBatchListFromReportQueryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList<BackupBatch> backupBatchList = new ArrayList<BackupBatch>();
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatch(cloudId, user.getUserName(), "", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())), reportQueryElement.getPageNo(), false));
            }
        } else {
            logger.debug("reportQueryElement.getStartDate()" + reportQueryElement.getStartDate() + ".." + reportQueryElement.getEndDate());
            logger.debug(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate()) + "..........." + ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate()));
            List backupBatchListNew = this.backupBatchDao.getAllBackupBatchForExcel(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())), reportQueryElement.getPageNo(), false);
            backupBatchList.addAll(backupBatchListNew);
        }
        logger.debug(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate()));
        logger.debug("backupBatchList count : " + backupBatchList.size());
        return backupBatchList;
    }

    @Override
    public long getCountOfBackupHistory(Cloud cloud, ReportQueryElement reportQueryElement) {
        long count = 0L;
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                count = this.backupBatchDao.getAllBackupBatchCount(cloud.getCloudId(), user.getUserName(), "", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())));
            }
        } else {
            count = this.backupBatchDao.getAllBackupBatchCountForExcel(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())));
        }
        logger.debug("...count..." + count);
        return count;
    }

    @Override
    public long getCountOfBackupHistoryWithoutTime(Cloud cloud, ReportQueryElement reportQueryElement) {
        long count = 0L;
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                count = this.backupBatchDao.getAllBackupBatchCount(cloud.getCloudId(), user.getUserName(), "", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())));
            }
        } else {
            count = this.backupBatchDao.getCountOfBackupHistoryWithoutTime(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName());
        }
        logger.debug("...count..." + count);
        logger.debug(reportQueryElement.getUserName() + "...reportquery..." + reportQueryElement.getDeviceName());
        return count;
    }

    @Override
    public long getCountOfCPBackupHistory(Cloud cloud, String productType) {
        long count = 0L;
        count = this.backupBatchDao.getCountOfCPBackupHistory(cloud.getCloudId(), productType);
        logger.debug(productType + "...count..." + count);
        return count;
    }

    public static long getEndOfDayNew(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static long getStartDateNew(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    @Override
    public boolean createRestoreHistoryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList<BackupBatch> backupBatchList = new ArrayList<BackupBatch>();
        List<BackupHistoryElement> backupHistoryElements = this.getRestoreElements(cloud, reportQueryElement, backupBatchList);
        if (CollectionUtils.isEmpty(backupHistoryElements)) {
            return false;
        }
        this.createExcelRestoreHistory(backupHistoryElements, reportQueryElement);
        return true;
    }

    @Override
    public boolean createBackupBatchElementForExcel(Cloud cloud, ReportQueryElement reportQueryElement) {
        List<Object> backupBatchReportElements = new ArrayList();
        backupBatchReportElements = this.getBackupBatchForReport(cloud, reportQueryElement);
        if (CollectionUtils.isEmpty(backupBatchReportElements)) {
            return false;
        }
        this.createExcelBackupBatch(backupBatchReportElements, reportQueryElement);
        return true;
    }

    private void createExcelBackupBatch(List<BackupBatchReportElement> backupBatchReportElements, ReportQueryElement reportQueryElement) {
        if (!backupBatchReportElements.isEmpty()) {
            logger.debug("inside the Report for BackupBatch");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelBackup(backupBatchReportElements);
                this.createExcelForXlsx(recordToAdd, workbook);
                String fileName = "Backup_completion_report.xlsx";
                if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
                    fileName = "RestoreHistory_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
                }
                this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for Backup Completion Report" + e);
            }
        }
    }

    private List<List> updateValuesToExcelBackup(List<BackupBatchReportElement> backupBatchReportElements) {
        logger.debug("inside the Report for Backup Batch: Backup completion report");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_ID);
        headerRow.add("Asset Name");
        headerRow.add(START_TIME);
        headerRow.add(END_TIME);
        headerRow.add("Total No. of Files");
        headerRow.add("Uploaded Size");
        headerRow.add("Backup Completion %");
        headerRow.add("Status");
        headerRow.add("Remark");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (BackupBatchReportElement backupBatchReportElement : backupBatchReportElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)backupBatchReportElement.getUserName())) {
                firstRow.add(backupBatchReportElement.getUserName());
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupBatchReportElement.getDeviceName())) {
                firstRow.add(backupBatchReportElement.getDeviceName());
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)this.getDate(backupBatchReportElement.getBatchStartTimestamp()))) {
                firstRow.add(this.getDate(backupBatchReportElement.getBatchStartTimestamp()));
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)this.getDate(backupBatchReportElement.getBatchEndTimestamp())) && backupBatchReportElement.getStatus().equals(COMPLETED)) {
                firstRow.add(this.getDate(backupBatchReportElement.getBatchEndTimestamp()));
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupBatchReportElement.getTotalNoOfFiles())) {
                firstRow.add(backupBatchReportElement.getTotalNoOfFiles());
            } else {
                firstRow.add("-");
            }
            if (StringUtils.isNotEmpty((String)backupBatchReportElement.getUploadedSize()) && Long.parseLong(backupBatchReportElement.getUploadedSize()) != 0L) {
                firstRow.add(backupBatchReportElement.getUploadedSizeWithUnit());
            } else {
                firstRow.add("-");
            }
            if (StringUtils.isNotEmpty((String)backupBatchReportElement.getPercentageCompleted()) && !backupBatchReportElement.getStatus().equals(STATUS_SANNING) && !backupBatchReportElement.getStatus().equals(COMPLETED)) {
                firstRow.add(backupBatchReportElement.getPercentageCompleted().concat("%"));
            } else {
                firstRow.add("-");
            }
            String status = backupBatchReportElement.getStatus();
            if (StringUtils.isNotEmpty((String)status)) {
                firstRow.add(status);
            } else {
                firstRow.add("-");
            }
            if (StringUtils.isNotEmpty((String)backupBatchReportElement.getRemark())) {
                firstRow.add(backupBatchReportElement.getRemark());
            } else {
                firstRow.add("-");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<BackupHistoryElement> getRestoreElements(Cloud cloud, ReportQueryElement reportQueryElement, List<BackupBatch> backupBatchList) {
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            Object productType = "backup";
            if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), (String)productType);
            for (User user : userList) {
                if (SHARE_POINT.equals(productType)) {
                    backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobType(cloudId, user.getUserName().concat(MICROSOFT_SHAREPOINT_DEVICE_SUFFIX), "", RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getSkipValue()));
                    continue;
                }
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, "", user.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
            }
        } else {
            backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, reportQueryElement.getDeviceName(), "", RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
        }
        for (BackupBatch backupBatch : backupBatchList) {
            if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || !"0/0".equalsIgnoreCase(backupBatch.getUploadedFiles())) continue;
            backupBatch.setUploadedFiles("0");
        }
        List<Object> backupHistoryElements = this.getBackupBatchElementsForRestore(backupBatchList);
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            backupHistoryElements = backupHistoryElements.stream().filter(element -> StringUtils.isEmpty((String)element.getUserName()) || element.getUserName().equals(reportQueryElement.getUserName())).collect(Collectors.toList());
        }
        Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

            @Override
            public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        return backupHistoryElements;
    }

    @Override
    public List<BackupBatchReportElement> getBackupBatchForReport(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        ArrayList<BackupBatchReportElement> backupBatchReportElements = new ArrayList<BackupBatchReportElement>();
        backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWithStartOrEndTime(cloudId, reportQueryElement.getDeviceName(), reportQueryElement.getUserName(), reportQueryElement.getJobType(), "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getOnDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getOnDate())), reportQueryElement.isCurrentRunningBackups()));
        logger.debug("backupBatchList returned from database={}", (Object)backupBatchList.size());
        for (BackupBatch backupBatch : backupBatchList) {
            BackupBatchReportElement backupBatchReportElement = new BackupBatchReportElement();
            BeanUtils.copyProperties((Object)backupBatch, (Object)backupBatchReportElement);
            long percent = 100L;
            logger.debug("the individual backup batch element is {} ", (Object)backupBatchReportElement);
            if (backupBatchReportElement == null || StringUtils.isEmpty((String)backupBatchReportElement.getUserName()) || StringUtils.isEmpty((String)backupBatchReportElement.getDeviceUUID())) continue;
            if (StringUtils.isNotEmpty((String)backupBatchReportElement.getUploadedSize())) {
                logger.debug("backup batch uploaded size={}", (Object)backupBatchReportElement.getUploadedSize());
                if (Long.parseLong(backupBatchReportElement.getUploadedSize()) > 1024L) {
                    backupBatchReportElement.setUploadedSizeWithUnit(ReportServiceImpl.formatFileSizeIncludeKB(Long.parseLong(backupBatchReportElement.getUploadedSize()) / 1024L));
                } else {
                    backupBatchReportElement.setUploadedSizeWithUnit("1.00 KB");
                }
                percent = backupBatchReportElement.getTotalSizeToUpload() == 0L || backupBatchReportElement.getStatus().equals(COMPLETED) ? 100L : Long.parseLong(backupBatchReportElement.getUploadedSize()) * 100L / backupBatchReportElement.getTotalSizeToUpload();
            }
            logger.debug("The percentage of files uploaded={} ", (Object)percent);
            if (StringUtils.isEmpty((String)backupBatchReportElement.getUploadedSize()) && backupBatchReportElement.getTotalSizeToUpload() != 0L) {
                percent = 0L;
            }
            backupBatchReportElement.setPercentageCompleted(String.valueOf(percent));
            if (!backupBatchReportElement.getStatus().equals(COMPLETED) && !"0".equals(backupBatch.getErrorCode())) {
                backupBatchReportElement.setRemark(this.getCommentsForBackupBatch(backupBatch));
            } else {
                backupBatchReportElement.setRemark("-");
            }
            backupBatchReportElements.add(backupBatchReportElement);
        }
        return backupBatchReportElements;
    }

    @Override
    public boolean createFailedNotificationHistoryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList<BackupBatch> backupBatchList = new ArrayList<BackupBatch>();
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())), user.getUserName(), "", reportQueryElement.getSkipValue()));
            }
        } else {
            int skip = 0;
            while (true) {
                List backupBatchListNew;
                if (CollectionUtils.isEmpty((Collection)(backupBatchListNew = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartDateNew(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDayNew(reportQueryElement.getEndDate())), reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), skip)))) {
                    logger.debug("data is empty so break for skip value :" + skip);
                    break;
                }
                logger.debug(backupBatchList.size() + " Size : " + backupBatchListNew.size() + " for skip value " + skip);
                backupBatchList.addAll(backupBatchListNew);
                ++skip;
            }
        }
        List<BackupHistoryElement> backupHistoryElements = this.getBackupBatchElements(backupBatchList);
        Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

            @Override
            public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        if (CollectionUtils.isEmpty(backupHistoryElements)) {
            return false;
        }
        this.createExcelFailedBackupHistory(backupHistoryElements, reportQueryElement);
        return true;
    }

    private List<BackupHistoryElement> getBackupBatchElements(List<BackupBatch> backupBatchList) {
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        for (BackupBatch backupBatch : backupBatchList) {
            if (StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID())) continue;
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                officeProduct = true;
            }
            BackupHistoryElement backupHistoryElement = this.getBackupBatchHistoryElement(backupBatch);
            backupHistoryElement.setAction(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct));
            backupHistoryElements.add(backupHistoryElement);
        }
        logger.debug("last....." + backupHistoryElements.size());
        return backupHistoryElements;
    }

    private List<BackupAttemptElement> getBackupAttempsElements(List<BackupAttempt> backupBatchList, BackupHistoryElement backupBatch) {
        ArrayList<BackupAttemptElement> backupHistoryElements = new ArrayList();
        try {
            long totalNoUploadedFiles = 0L;
            for (BackupAttempt backupBatchAttempt : backupBatchList) {
                BackupAttemptElement backupActivityHistoryElement = new BackupAttemptElement();
                backupActivityHistoryElement.setDeviceName(backupBatchAttempt.getDeviceName());
                backupActivityHistoryElement.setUserName(backupBatchAttempt.getUserName());
                backupActivityHistoryElement.setStartTimeLong(backupBatchAttempt.getBatchStartTimestamp());
                backupActivityHistoryElement.setStartTime(this.getDate(backupBatchAttempt.getBatchStartTimestamp()));
                backupActivityHistoryElement.setStartTime(DateUtil.getDateInddMMMyyyy((long)backupBatchAttempt.getBatchStartTimestamp()));
                backupActivityHistoryElement.setStatus(backupBatchAttempt.getStatus());
                backupActivityHistoryElement.setEndTimeLong(backupBatchAttempt.getBatchEndTimestamp());
                backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatchAttempt.getBatchEndTimestamp()));
                backupActivityHistoryElement.setTotalNoOfFiles(backupBatchAttempt.getTotalNoOfFiles() + "");
                if (StringUtils.isNotEmpty((String)backupBatchAttempt.getUploadedSize())) {
                    backupActivityHistoryElement.setUploadedSize(ReportServiceImpl.formatFileSize(Long.parseLong(backupBatchAttempt.getUploadedSize()) / 1024L));
                } else {
                    logger.debug("size..0MB");
                    backupActivityHistoryElement.setUploadedSize("0.00 MB");
                }
                BackupBatch backupBatch2 = new BackupBatch();
                BeanUtils.copyProperties((Object)backupBatchAttempt, (Object)backupBatch2);
                boolean officeProduct = false;
                if (backupBatchAttempt.getDeviceName().contains("Microsoft Exchange") || backupBatchAttempt.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                    officeProduct = true;
                }
                String comments = this.getCommentsForBackupBatch(backupBatch2.getErrorCode(), officeProduct);
                try {
                    String uploadedFiles = backupBatch.getUploadedFiles();
                    if (StringUtils.isEmpty((String)uploadedFiles)) {
                        uploadedFiles = "0/0";
                    }
                    String[] parts = uploadedFiles.split("/");
                    long actualNoOfFiles = Long.parseLong(parts[1]);
                    long noOfFilesRemaing = actualNoOfFiles - (totalNoUploadedFiles += backupBatchAttempt.getTotalNoOfFiles());
                    logger.debug(comments + "...noOfFilesRemaing.." + noOfFilesRemaing);
                    logger.debug("...actualNoOfFiles.." + actualNoOfFiles);
                    logger.debug("...totaolNoFiles.." + totalNoUploadedFiles);
                    if (actualNoOfFiles == 0L && noOfFilesRemaing == 0L) {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf("100 %"));
                    } else {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf(ReportServiceImpl.getPercentageCompleted1(totalNoUploadedFiles, actualNoOfFiles)) + " %");
                    }
                }
                catch (Exception e) {
                    logger.trace(" EXCEPTION..... " + e);
                }
                logger.debug(backupBatchAttempt.getId() + "..%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%...." + backupActivityHistoryElement.getUploadedPercentage());
                backupActivityHistoryElement.setTotalNoUploadedFiles(totalNoUploadedFiles);
                backupActivityHistoryElement.setComments(comments);
                backupActivityHistoryElement.setBatchId(backupBatch.getBatchId().toString());
                backupActivityHistoryElement.setAction(this.getCommentsForBackupBatch(backupBatchAttempt.getErrorCode(), officeProduct));
                backupActivityHistoryElement.setErrorCode(backupBatchAttempt.getErrorCode());
                backupHistoryElements.add(backupActivityHistoryElement);
            }
        }
        catch (Exception e) {
            logger.trace(" EXCEPTION..... " + e);
        }
        Comparator<BackupAttemptElement> comparator = Comparator.comparing(BackupAttemptElement::getStartTimeLong).reversed();
        backupHistoryElements = backupHistoryElements.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        return backupHistoryElements;
    }

    private long getPercentageCompletedNew(long totalNoOfFiles, long noOfFilesRemaining) {
        long percentage = 0L;
        logger.debug(" totalNoOfFiles..... " + totalNoOfFiles);
        logger.debug(" noOfFilesRemaining....new. " + noOfFilesRemaining);
        if (noOfFilesRemaining != 0L) {
            percentage = totalNoOfFiles * 100L / noOfFilesRemaining;
        }
        return percentage;
    }

    private List<BackupHistoryElement> getBackupBatchElementsForRestore(List<BackupBatch> backupBatchList) {
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        Set superAdmins = this.userDao.getAllSuperAdmins(1);
        for (BackupBatch backupBatch : backupBatchList) {
            if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || !CollectionUtils.isEmpty((Collection)superAdmins) && superAdmins.contains(backupBatch.getUserName())) continue;
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                officeProduct = true;
            }
            BackupHistoryElement backupHistoryElement = this.getBackupBatchElementsForRestore(backupBatch);
            backupHistoryElement.setAction(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct));
            backupHistoryElement.setStatus(this.getCommentsForRestoreHistory(backupBatch.getErrorCode()));
            if (backupBatch.getStatus().equalsIgnoreCase(STATUS_STARTED)) {
                backupHistoryElement.setRestoreEndTime("-");
                backupHistoryElement.setEndTime("-");
                backupHistoryElement.setNoOfFiles(0L);
                backupHistoryElement.setRestoredFiles("-");
                backupHistoryElement.setRestoredSize(0L);
                backupHistoryElement.setStatus("Started");
            }
            backupHistoryElements.add(backupHistoryElement);
        }
        return backupHistoryElements;
    }

    private BackupHistoryElement getBackupBatchElementsForRestore(BackupBatch backupBatch) {
        logger.debug("..getBackupBatchElementsForRestore...." + backupBatch);
        RestoreHistory restoreHistory = this.backupBatchDao.getRestoreHistoryById(1, backupBatch.getId());
        BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
        if (restoreHistory != null) {
            backupHistoryElement.setDeviceName(restoreHistory.getDeviceName());
            backupHistoryElement.setUserName(restoreHistory.getUserName());
            backupHistoryElement.setRestoreByUserName(restoreHistory.getRestoreByUserName());
            backupHistoryElement.setRestoreByDeviceName(restoreHistory.getRestoreByDeviceName());
            backupHistoryElement.setRestoreTime(this.getDate(restoreHistory.getBatchStartTimestamp()));
            backupHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
            backupHistoryElement.setRestoreEndTime(this.getDate(restoreHistory.getBatchEndTimestamp()));
            backupHistoryElement.setRestoreFolder(restoreHistory.getRestoreFolder());
            if (!StringUtils.isEmpty((String)restoreHistory.getRestoredSize())) {
                backupHistoryElement.setRestoredSize(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L);
            }
            logger.debug(".........restoreHistory.getDestFolder()........" + restoreHistory.getDestFolder());
            backupHistoryElement.setDestFolder(restoreHistory.getDestFolder());
            backupHistoryElement.setRestoredInDiffPath(restoreHistory.isRestoredInDiffPath());
        } else {
            backupHistoryElement.setBatchId(backupBatch.getId().toString());
            backupHistoryElement.setRestoreByDeviceName(backupBatch.getDeviceName());
            backupHistoryElement.setRestoreByUserName(backupBatch.getUserName());
        }
        backupHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
        backupHistoryElement.setEndTime(this.getDate(backupBatch.getBatchEndTimestamp()));
        backupHistoryElement.setUploadedSize(backupBatch.getUploadedSize());
        if (!StringUtils.isEmpty((String)backupBatch.getConfiguredBackupFolder())) {
            backupHistoryElement.setConfiguredBackupFolder(backupBatch.getConfiguredBackupFolder().split(";"));
        }
        String uploadedFiles = backupBatch.getUploadedFiles();
        String[] parts = uploadedFiles.split("/");
        try {
            backupHistoryElement.setNoOfFiles((long)Integer.parseInt(parts[0]));
        }
        catch (Exception e) {
            logger.debug("  Error trying to split no of  files " + e);
        }
        return backupHistoryElement;
    }

    private BackupHistoryElement getBackupBatchHistoryElement(BackupBatch backupBatch) {
        List<String> diskElementStrings;
        RestoreHistory restoreHistory;
        BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
        backupHistoryElement.setBatchId(backupBatch.getId().toString());
        if (StringUtils.isEmpty((String)backupBatch.getDeviceName())) {
            Device device = this.deviceDao.getDeviceInfoByUUID(1, "", backupBatch.getDeviceUUID());
            if (device != null) {
                backupBatch.setDeviceName(device.getDeviceName());
            }
        } else {
            backupBatch.setDeviceName(backupBatch.getDeviceName());
        }
        backupHistoryElement.setDeviceName(backupBatch.getDeviceName());
        backupHistoryElement.setUserName(backupBatch.getUserName());
        backupHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
        backupHistoryElement.setEndTime(this.getDate(backupBatch.getBatchEndTimestamp()));
        backupHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
        backupHistoryElement.setEndTimeInMillis(backupBatch.getBatchEndTimestamp());
        backupHistoryElement.setUploadedSize(backupBatch.getUploadedSize());
        backupHistoryElement.setErrorCode(backupBatch.getErrorCode());
        if (!StringUtils.isEmpty((String)backupBatch.getConfiguredBackupFolder())) {
            backupHistoryElement.setConfiguredBackupFolder(backupBatch.getConfiguredBackupFolder().split(";"));
        }
        if (!"BACKUP".equalsIgnoreCase(backupBatch.getJobType()) && (restoreHistory = this.backupBatchDao.getRestoreHistoryById(1, backupBatch.getId())) != null) {
            backupHistoryElement.setRestoredInDiffPath(restoreHistory.isRestoredInDiffPath());
        }
        if (!StringUtils.isEmpty((String)backupBatch.getDiskSpaceDetails()) && !CollectionUtils.isEmpty(diskElementStrings = Arrays.asList(backupBatch.getDiskSpaceDetails().split("\\|")))) {
            ArrayList<DiskSpaceElement> diskSpaceElements = new ArrayList<DiskSpaceElement>();
            for (String diskElementString : diskElementStrings) {
                DiskSpaceElement diskSpaceElement = new DiskSpaceElement();
                List<String> de = Arrays.asList(diskElementString.split(";"));
                if (CollectionUtils.isEmpty(de) || de.size() <= 2) continue;
                diskSpaceElement.setDrive(de.get(0));
                diskSpaceElement.setDiskSpace(de.get(1));
                diskSpaceElement.setUsedSpace(de.get(2));
                diskSpaceElements.add(diskSpaceElement);
            }
            backupHistoryElement.setDiskSpaceDetails(diskSpaceElements);
        }
        String uploadedFiles = backupBatch.getUploadedFiles();
        String[] parts = uploadedFiles.split("/");
        try {
            backupHistoryElement.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            backupHistoryElement.setNoOfFiles((long)Integer.parseInt(parts[1]));
            backupHistoryElement.setUploadedFiles("" + Integer.parseInt(parts[0]));
        }
        catch (Exception e) {
            logger.debug("  Error trying to split no of  files " + e);
        }
        return backupHistoryElement;
    }

    @Override
    public void createExcelForBackupHistoryReport(Cloud cloud, String cloudName, String userName, String deviceName, String fromDate, String endDate) {
        String startDate = fromDate;
        if (!startDate.isEmpty() && !endDate.isEmpty()) {
            Calendar cal = Calendar.getInstance();
            int noOfDays = Integer.parseInt(startDate);
            SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
            cal.add(5, -noOfDays);
            startDate = dateFormat.format(cal.getTime());
            ReportQueryElement reportQueryElement = new ReportQueryElement();
            reportQueryElement.setUserName(userName);
            reportQueryElement.setDeviceName(deviceName);
            reportQueryElement.setStartDate(startDate);
            reportQueryElement.setEndDate(endDate);
            reportQueryElement.setPolicyNames(new ArrayList());
            List<BackupHistoryElement> backupHistoryElements = this.getBackupHistoryElement(cloud, reportQueryElement);
            Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

                @Override
                public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            this.createExcelBackupHistory(backupHistoryElements, null);
        }
    }

    private void createExcelBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        if (!backupHistoryElements.isEmpty()) {
            logger.debug("inside the createExcelBackupHistory ");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelforBackupHistory(backupHistoryElements, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                String fileName = "BackupHistory.xlsx";
                if (reportQueryElement != null && !StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
                    fileName = "BackupHistory_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
                }
                this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e.getMessage());
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e);
            }
        }
    }

    private void createExcelIncompleteBackupHistory(List<BackupActivityHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        if (!backupHistoryElements.isEmpty()) {
            logger.debug("inside the createExcelIncompleteBackupHistory ");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelforIncompleteBackupHistory(backupHistoryElements, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                String fileName = "IncompleteBackupHistory.xlsx";
                this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e.getMessage());
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e);
            }
        }
    }

    private List<List> updateValuesToExcelforBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        logger.debug("inside the Report for BackupHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        if (SHARE_POINT.equals(reportQueryElement.getProductType())) {
            headerRow.add(SITE_NAME);
            headerRow.add(START_TIME);
            headerRow.add(END_TIME);
            headerRow.add(FILES_BACKED_UP);
            headerRow.add(REMARKS);
        } else {
            headerRow.add(USER_NAME);
            if (ODB.equals(reportQueryElement.getProductType())) {
                headerRow.add("Asset Name");
            } else {
                headerRow.add("Asset Name");
            }
            headerRow.add(START_TIME);
            headerRow.add(END_TIME);
            headerRow.add(FILES_BACKED_UP);
            headerRow.add(REMARKS);
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            sb.append(userName + reportQueryElement.getUserName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            sb.append(deviceName + reportQueryElement.getDeviceName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            if (SHARE_POINT.equals(reportQueryElement.getProductType())) {
                firstRow.add(backupHistoryElement.getDeviceName());
                firstRow.add(backupHistoryElement.getStartTime());
                firstRow.add(backupHistoryElement.getEndTime());
                firstRow.add(Long.toString(backupHistoryElement.getNoOfFiles()));
                firstRow.add(backupHistoryElement.getAction());
                recordToAdd.add(firstRow);
                continue;
            }
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getEndTime());
            firstRow.add(Long.toString(backupHistoryElement.getNoOfFiles()));
            firstRow.add(backupHistoryElement.getAction());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforIncompleteBackupHistory(List<BackupActivityHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        logger.debug("inside the Report for BackupHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_ID);
        headerRow.add("Asset Name");
        headerRow.add("Start Date");
        headerRow.add(START_TIME);
        headerRow.add("End Date");
        headerRow.add(END_TIME);
        headerRow.add("Attempted");
        headerRow.add("\tNo.of files Backed up");
        headerRow.add("Total Items");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())) + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getReason())) {
            sb.append(reason + reportQueryElement.getReason());
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow2 = new ArrayList<String>();
        headerRow2.add(NOTE);
        recordToAdd.add(headerRow2);
        recordToAdd.add(headerRow);
        for (BackupActivityHistoryElement backupHistoryElement : backupHistoryElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            if (!StringUtils.isEmpty((String)backupHistoryElement.getStartTime())) {
                long startTime = ReportServiceImpl.getTime(backupHistoryElement.getStartTime());
                firstRow.add(ReportServiceImpl.getDateInFormat(startTime, "dd-MMM-yyyy"));
                firstRow.add(ReportServiceImpl.getDateInFormat(startTime, HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getEndTime())) {
                long endTime = ReportServiceImpl.getTime(backupHistoryElement.getEndTime());
                firstRow.add(ReportServiceImpl.getDateInFormat(endTime, "dd-MMM-yyyy"));
                firstRow.add(ReportServiceImpl.getDateInFormat(endTime, HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            long attempted = Long.valueOf(backupHistoryElement.getNoOfFilesBackedup()) + Long.valueOf(backupHistoryElement.getNoOfFilesFailed());
            firstRow.add(String.valueOf(attempted));
            firstRow.add(backupHistoryElement.getNoOfFilesBackedup());
            firstRow.add(String.valueOf(backupHistoryElement.getTotalNumberOfFiles()));
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    public static long getEndOfDay(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public static long getStartOfDay(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    @Override
    public List<UserDeviceHistoryElement> getUserDeviceHistoryElement(int cloudId, String cloudName, String userName, String deviceName) {
        List deviceHistoryElementsList = this.backUpImageDao.getDeviceHistoryElement(cloudId, cloudName, userName, deviceName);
        ArrayList<UserDeviceHistoryElement> deviceHistoryElements = new ArrayList<UserDeviceHistoryElement>();
        for (Object[] object : deviceHistoryElementsList) {
            UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
            userDeviceHistoryElement.setDeviceName((String)object[1]);
            Long storageUsed = (Long)object[0];
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            userDeviceHistoryElement.setUserName((String)object[2]);
            deviceHistoryElements.add(userDeviceHistoryElement);
        }
        return deviceHistoryElements;
    }

    @Override
    public List<UserDeviceHistoryElement> getUserHistoryElement(int cloudId, String cloudName, String userName) {
        List deviceHistoryElementsList = this.backUpImageDao.getUserHistoryElement(cloudId, cloudName, userName);
        ArrayList<UserDeviceHistoryElement> deviceHistoryElements = new ArrayList<UserDeviceHistoryElement>();
        for (Object[] object : deviceHistoryElementsList) {
            UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
            userDeviceHistoryElement.setDeviceName((String)object[1]);
            Long storageUsed = (Long)object[0];
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            userDeviceHistoryElement.setUserName((String)object[2]);
            String date = (String)object[3];
            if (!StringUtils.isEmpty((String)date)) {
                Long dateLong = Long.valueOf(date);
                userDeviceHistoryElement.setCreatedTimestamp(this.getDate(dateLong));
            } else {
                userDeviceHistoryElement.setCreatedTimestamp((String)object[3]);
            }
            deviceHistoryElements.add(userDeviceHistoryElement);
        }
        return deviceHistoryElements;
    }

    @Override
    public List<UserDeviceHistoryElement> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName) {
        List deviceHistoryElementsList = this.backUpImageDao.getDeviceHistoryElement(cloudId, cloudName, deviceName);
        ArrayList<UserDeviceHistoryElement> deviceHistoryElements = new ArrayList<UserDeviceHistoryElement>();
        for (Object[] object : deviceHistoryElementsList) {
            UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
            userDeviceHistoryElement.setDeviceName((String)object[1]);
            Long storageUsed = (Long)object[0];
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            String userName = (String)object[2];
            userDeviceHistoryElement.setUserName(userName);
            if (object[3] != null) {
                Long createdTimestamp = Long.parseLong((String)object[3]);
                userDeviceHistoryElement.setCreatedTimestamp(this.getDate(createdTimestamp));
            }
            storageUsed = this.backUpImageDao.getStorageUsedForDevice(cloudId, cloudName, deviceName, userName);
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            deviceHistoryElements.add(userDeviceHistoryElement);
        }
        return deviceHistoryElements;
    }

    @Override
    public List<RestoreHistoryElement> getRestoreHistoryElementForReport(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList<RestoreHistoryElement> restoreHistoryElements = new ArrayList<RestoreHistoryElement>();
        ArrayList backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        Set superAdmins = this.userDao.getAllSuperAdmins(cloudId);
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug(".....getPolicyNames........" + backupBatchList.size());
            String productType = "backup";
            if (!StringUtils.isEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                if (SHARE_POINT.equals(productType)) {
                    backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, user.getUserName().concat(MICROSOFT_SHAREPOINT_DEVICE_SUFFIX), "", RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
                    continue;
                }
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, "", user.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
            }
        } else {
            logger.debug("......all......." + backupBatchList.size());
            backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, reportQueryElement.getDeviceName(), "", RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
        }
        logger.debug(reportQueryElement.getProductType() + "............." + backupBatchList.size());
        for (BackupBatch backupBatch : backupBatchList) {
            Device dev;
            if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || !CollectionUtils.isEmpty((Collection)superAdmins) && superAdmins.contains(backupBatch.getUserName())) continue;
            if ("0/0".equalsIgnoreCase(backupBatch.getUploadedFiles())) {
                backupBatch.setUploadedFiles("0");
            }
            RestoreHistory restoreHistory = this.backupBatchDao.getRestoreHistoryById(cloudId, backupBatch.getId());
            RestoreHistoryElement restoreHistoryElement = new RestoreHistoryElement();
            if (restoreHistory == null) {
                dev = this.deviceDao.getDeviceInfoByUUID(cloudId, "", backupBatch.getDeviceUUID());
                restoreHistoryElement.setRestoreByDeviceName(dev.getDeviceName());
                restoreHistoryElement.setRestoreByUserName(backupBatch.getUserName());
                restoreHistoryElement.setRestoreTime(this.getDate(backupBatch.getBatchStartTimestamp()));
                restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                restoreHistoryElement.setRestoreEndTime(this.getDate(backupBatch.getBatchEndTimestamp()));
                restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
            } else {
                if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName()) && !reportQueryElement.getUserName().equals(restoreHistory.getUserName())) continue;
                dev = this.deviceDao.getDeviceInfoByUUID(cloudId, "", restoreHistory.getRestoreByDeviceUUID());
                Device restoreDevice = this.deviceDao.getDeviceByName(cloudId, "", restoreHistory.getDeviceName(), restoreHistory.getUserName(), "");
                if (restoreDevice != null) {
                    logger.debug("restoreDevice..." + restoreDevice.getDeviceName());
                    restoreHistoryElement.setDeviceName(restoreDevice.getDeviceName());
                } else {
                    restoreHistoryElement.setDeviceName(restoreHistory.getDeviceName());
                }
                restoreHistoryElement.setUserName(restoreHistory.getUserName());
                restoreHistoryElement.setRestoreByUserName(restoreHistory.getRestoreByUserName());
                restoreHistoryElement.setRestoreByDeviceName(restoreHistory.getRestoreByDeviceName());
                restoreHistoryElement.setRestoreTime(this.getDate(restoreHistory.getBatchStartTimestamp()));
                restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                restoreHistoryElement.setRestoreEndTime(this.getDate(restoreHistory.getBatchEndTimestamp()));
                restoreHistoryElement.setRestoredInDiffPath(restoreHistory.isRestoredInDiffPath());
                if (StringUtils.isNotEmpty((String)restoreHistory.getRestoreFolder())) {
                    restoreHistoryElement.setRestoreFolder(this.encodeUTFBase64(restoreHistory.getRestoreFolder()));
                }
                if (StringUtils.isNotEmpty((String)restoreHistory.getDestFolder())) {
                    restoreHistoryElement.setDestFolder(this.encodeUTFBase64(restoreHistory.getDestFolder()));
                }
                restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
                if (!StringUtils.isEmpty((String)restoreHistory.getRestoredSize())) {
                    if (dev.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                        restoreHistoryElement.setRestoredSize(ReportServiceImpl.formatFileSizeIncludeKB(Long.parseLong(restoreHistory.getRestoredSize())));
                        restoreHistoryElement.setRestoredSizeInKB(Long.parseLong(restoreHistory.getRestoredSize()));
                    } else {
                        restoreHistoryElement.setRestoredSize(ReportServiceImpl.formatFileSizeIncludeKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L));
                        restoreHistoryElement.setRestoredSizeInKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L);
                    }
                }
            }
            restoreHistoryElement.setStatus(this.getCommentsForRestoreHistory(backupBatch.getErrorCode()));
            if (backupBatch.getStatus().equalsIgnoreCase(STATUS_STARTED)) {
                restoreHistoryElement.setRestoreEndTime("-");
                restoreHistoryElement.setRestoreEndTimeInMillis(1L);
                restoreHistoryElement.setRestoredSize("-");
                restoreHistoryElement.setRestoredFiles("-");
                restoreHistoryElement.setStatus("Started");
            }
            if (restoreHistoryElement.getRestoreTimeInMillis() == restoreHistoryElement.getRestoreEndTimeInMillis() && !backupBatch.getStatus().equalsIgnoreCase("FAILED")) {
                logger.debug("**************");
                continue;
            }
            logger.debug("....errorcode for batch history..." + backupBatch.getErrorCode());
            restoreHistoryElements.add(restoreHistoryElement);
        }
        return restoreHistoryElements;
    }

    @Override
    public List<RestoreHistoryElement> getRestoreHistoryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList<RestoreHistoryElement> restoreHistoryElements = new ArrayList<RestoreHistoryElement>();
        List backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug("............." + backupBatchList.size());
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobType(cloudId, "", user.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getPageNo()));
            }
        } else {
            logger.debug("............." + backupBatchList.size());
            backupBatchList = this.backupBatchDao.getAllBackupBatchForJobType(cloudId, reportQueryElement.getDeviceName(), reportQueryElement.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getPageNo());
        }
        logger.debug("............." + backupBatchList.size());
        for (BackupBatch backupBatch : backupBatchList) {
            if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID())) continue;
            if ("0/0".equalsIgnoreCase(backupBatch.getUploadedFiles())) {
                backupBatch.setUploadedFiles("0");
            }
            Device dev = this.deviceDao.getDeviceInfoByUUID(cloudId, "", backupBatch.getDeviceUUID());
            logger.debug("..dev...." + dev);
            RestoreHistory restoreHistory = this.backupBatchDao.getRestoreHistoryById(cloudId, backupBatch.getId());
            RestoreHistoryElement restoreHistoryElement = new RestoreHistoryElement();
            if (restoreHistory == null) {
                restoreHistoryElement.setRestoreByDeviceName(dev.getDeviceName());
                restoreHistoryElement.setRestoreByUserName(backupBatch.getUserName());
                restoreHistoryElement.setRestoreTime(this.getDate(backupBatch.getBatchStartTimestamp()));
                restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                restoreHistoryElement.setRestoreEndTime(this.getDate(backupBatch.getBatchEndTimestamp()));
                restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
            } else {
                logger.debug("..Inside..restoreHistory");
                Device restoreDevice = this.deviceDao.getDeviceByName(cloudId, "", restoreHistory.getDeviceName(), restoreHistory.getUserName(), "");
                if (restoreDevice != null) {
                    logger.debug("restoreDevice..." + restoreDevice.getDeviceName());
                    restoreHistoryElement.setDeviceName(restoreDevice.getDeviceName());
                } else {
                    restoreHistoryElement.setDeviceName(restoreHistory.getDeviceName());
                }
                restoreHistoryElement.setUserName(restoreHistory.getUserName());
                restoreHistoryElement.setRestoreByUserName(restoreHistory.getRestoreByUserName());
                restoreHistoryElement.setRestoreByDeviceName(dev.getDeviceName());
                restoreHistoryElement.setRestoreTime(this.getDate(restoreHistory.getBatchStartTimestamp()));
                restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                restoreHistoryElement.setRestoreEndTime(this.getDate(restoreHistory.getBatchEndTimestamp()));
                if (StringUtils.isNotEmpty((String)restoreHistory.getRestoreFolder())) {
                    restoreHistoryElement.setRestoreFolder(this.encodeUTFBase64(restoreHistory.getRestoreFolder()));
                }
                restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
                if (!StringUtils.isEmpty((String)restoreHistory.getRestoredSize())) {
                    if (dev.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                        restoreHistoryElement.setRestoredSize(ReportServiceImpl.formatFileSizeIncludeKB(Long.parseLong(restoreHistory.getRestoredSize())));
                        restoreHistoryElement.setRestoredSizeInKB(Long.parseLong(restoreHistory.getRestoredSize()));
                    } else {
                        restoreHistoryElement.setRestoredSize(ReportServiceImpl.formatFileSizeIncludeKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L));
                        restoreHistoryElement.setRestoredSizeInKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L);
                    }
                }
            }
            restoreHistoryElement.setStatus(this.getCommentsForRestoreHistory(backupBatch.getErrorCode()));
            if (backupBatch.getStatus().equalsIgnoreCase(STATUS_STARTED)) {
                restoreHistoryElement.setRestoreEndTime("-");
                restoreHistoryElement.setRestoreEndTimeInMillis(1L);
                restoreHistoryElement.setRestoredSize("-");
                restoreHistoryElement.setRestoredFiles("-");
                restoreHistoryElement.setStatus("Started");
            }
            if (restoreHistoryElement.getRestoreTimeInMillis() == restoreHistoryElement.getRestoreEndTimeInMillis()) {
                logger.debug("**************");
                continue;
            }
            logger.debug("....errorcode for batch history..." + backupBatch.getErrorCode());
            restoreHistoryElements.add(restoreHistoryElement);
        }
        return restoreHistoryElements;
    }

    private String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    @Override
    public long getRestoreHistoryElementCount(Cloud cloud, ReportQueryElement reportQueryElement) {
        long count = 0L;
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                count = this.backupBatchDao.getCountBackupBatchForJobType(cloudId, "", user.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
            }
        } else {
            count = this.backupBatchDao.getCountBackupBatchForJobType(cloudId, reportQueryElement.getDeviceName(), reportQueryElement.getUserName(), RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
        }
        return count;
    }

    @Override
    public void createExcelForRestoreHistoryReport(int cloudId, String cloudName, String deviceName, String userName, String fromDate, String endDate, int skipValue) {
        String startDate = fromDate;
        if (!startDate.isEmpty() && !endDate.isEmpty()) {
            Calendar cal = Calendar.getInstance();
            int noOfDays = Integer.parseInt(startDate);
            SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
            cal.add(5, -noOfDays);
            startDate = dateFormat.format(cal.getTime());
            List backupBatchList = this.backupBatchDao.getAllBackupBatchForJobType(cloudId, deviceName, userName, RESTORE, "", Long.valueOf(ReportServiceImpl.getStartOfDay(startDate)), Long.valueOf(ReportServiceImpl.getEndOfDay(endDate)), skipValue);
            for (BackupBatch backupBatch : backupBatchList) {
                if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || !"0/0".equalsIgnoreCase(backupBatch.getUploadedFiles())) continue;
                backupBatch.setUploadedFiles("0");
            }
            List<BackupHistoryElement> backupHistoryElements = this.getBackupBatchElements(backupBatchList);
            Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

                @Override
                public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            this.createExcelRestoreHistory(backupHistoryElements, new ReportQueryElement());
        }
    }

    private void createExcelRestoreHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        if (!backupHistoryElements.isEmpty()) {
            logger.debug("inside the Report for RestoreHistory");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelRestoreHistory(backupHistoryElements, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                String fileName = "RestoreHistory.xlsx";
                if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
                    fileName = "RestoreHistory_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
                }
                this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for RestoreHistory" + e.getMessage());
                logger.debug("Exception while creating the excel sheet for RestoreHistory" + e);
            }
        }
    }

    private List<List> updateValuesToExcelRestoreHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        String policyNames;
        logger.debug("inside the Report for RestoreHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        if (SHARE_POINT.equals(reportQueryElement.getProductType())) {
            headerRow.add("Source Site [Path]");
        } else if (ODB.equals(reportQueryElement.getProductType())) {
            headerRow.add(USER_NAME);
            headerRow.add("Asset Name");
        } else {
            headerRow.add(USER_NAME);
            headerRow.add("Asset Name");
        }
        headerRow.add("Restore By");
        headerRow.add("Restore To");
        headerRow.add("Restore Start Date");
        headerRow.add("Restore Start Time");
        headerRow.add("Restore End Date");
        headerRow.add("Restore End Time");
        headerRow.add(FILES_RESTORED);
        headerRow.add("Restored Size");
        headerRow.add("Status");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputSRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (SHARE_POINT.equals(reportQueryElement.getProductType())) {
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(policyName + policyNames + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(siteName + reportQueryElement.getDeviceName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
                sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
            }
        } else {
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(policyName + policyNames + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                sb.append(userName + reportQueryElement.getUserName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(deviceName + reportQueryElement.getDeviceName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
                sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
            }
        }
        userInputSRow.add(sb.toString());
        recordToAdd.add(userInputSRow);
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            String folderPath;
            ArrayList<String> firstRow = new ArrayList<String>();
            if (!SHARE_POINT.equals(reportQueryElement.getProductType())) {
                if (!StringUtils.isEmpty((String)backupHistoryElement.getUserName())) {
                    firstRow.add(backupHistoryElement.getUserName());
                } else {
                    firstRow.add("-");
                }
            }
            boolean officeProduct = false;
            if (!StringUtils.isEmpty((String)backupHistoryElement.getDeviceName())) {
                if (backupHistoryElement.getDeviceName().contains("Microsoft Exchange") || backupHistoryElement.getDeviceName().contains("Microsoft OneDrive") || backupHistoryElement.getDeviceName().contains("Microsoft SharePoint")) {
                    officeProduct = true;
                }
                folderPath = backupHistoryElement.getDeviceName();
                if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreFolder())) {
                    folderPath = folderPath + " - " + backupHistoryElement.getRestoreFolder();
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreByUserName())) {
                firstRow.add(backupHistoryElement.getRestoreByUserName());
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreByDeviceName())) {
                folderPath = backupHistoryElement.getRestoreByDeviceName();
                if (!StringUtils.isEmpty((String)backupHistoryElement.getDestFolder())) {
                    folderPath = folderPath + " - " + backupHistoryElement.getDestFolder();
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getStartTime())) {
                long startTime = ReportServiceImpl.getTime(backupHistoryElement.getStartTime());
                firstRow.add(ReportServiceImpl.getDateInFormat(startTime, "dd-MMM-yyyy"));
                firstRow.add(ReportServiceImpl.getDateInFormat(startTime, HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getEndTime())) {
                long endTime = ReportServiceImpl.getTime(backupHistoryElement.getEndTime());
                firstRow.add(ReportServiceImpl.getDateInFormat(endTime, "dd-MMM-yyyy"));
                firstRow.add(ReportServiceImpl.getDateInFormat(endTime, HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (!backupHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                firstRow.add(Long.toString(backupHistoryElement.getNoOfFiles()));
            } else {
                firstRow.add("-");
            }
            if (backupHistoryElement.getRestoredSize() != 0L && !backupHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                firstRow.add(ReportServiceImpl.formatFileSizeIncludeKB(backupHistoryElement.getRestoredSize()));
            } else {
                firstRow.add("-");
            }
            String status = backupHistoryElement.getStatus();
            firstRow.add(status);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelBackupSummary(CloudOverviewElement cloudOverviewElement, int noOfDays, String productType, ReportQueryElement reportQueryElement) {
        logger.debug("inside the Report for updateValuesToExcelBackupSummary ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add("Statistic");
        headerRow.add("Values");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        sb.append(noOfDays + reportQueryElement.getNoOfDays());
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add("Backup performance summary");
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        headerRow = new ArrayList();
        if (SHARE_POINT.equals(productType)) {
            headerRow.add("Active Sites");
        } else {
            headerRow.add("Active Users");
        }
        headerRow.add(cloudOverviewElement.getActiveBackupUsers() + "");
        recordToAdd.add(headerRow);
        if (!SHARE_POINT.equals(productType) && !ODB.equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("Users with at least one device assigned");
            headerRow.add(cloudOverviewElement.getUserWithDevices() + "");
            recordToAdd.add(headerRow);
        } else if (ODB.equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("Users with at least one asset assigned");
            headerRow.add(cloudOverviewElement.getUserWithDevices() + "");
            recordToAdd.add(headerRow);
        }
        headerRow = new ArrayList();
        if (SHARE_POINT.equals(productType)) {
            headerRow.add("No. of Sites for which at least one full backup is completed");
        } else {
            headerRow.add("# of users for whom at least one full backup is complete");
        }
        headerRow.add(cloudOverviewElement.getUserWithFirstBkpCompleted() + "");
        recordToAdd.add(headerRow);
        if (!SHARE_POINT.equals(productType) && !ODB.equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("# of users with out device registered");
            headerRow.add(cloudOverviewElement.getUserWithOutDevices() + "");
            recordToAdd.add(headerRow);
        } else if (ODB.equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("# of users with out asset registered");
            headerRow.add(cloudOverviewElement.getUserWithOutDevices() + "");
            recordToAdd.add(headerRow);
        }
        if (!SHARE_POINT.equals(productType) && !ODB.equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("# of users whose devices had a heartbeat to the server in the last " + noOfDays + " days");
            headerRow.add(cloudOverviewElement.getNoOfUsersHeardCount() + "");
            recordToAdd.add(headerRow);
        }
        headerRow = new ArrayList();
        if (SHARE_POINT.equals(productType)) {
            headerRow.add("No. of Sites which have been protected in the last " + noOfDays + " days");
        } else if (ODB.equals(productType)) {
            headerRow.add("# of users whose assets have been protected in the last " + noOfDays + " days");
        } else {
            headerRow.add("# of users whose devices have been protected in the last " + noOfDays + " days");
        }
        headerRow.add(cloudOverviewElement.getNoOfUsersProtected() + "");
        recordToAdd.add(headerRow);
        return recordToAdd;
    }

    @Override
    public NotificationElementList getFailedNotificationHistoryElement(Cloud cloud, ReportQueryElement reportQueryElement) {
        NotificationElementList elementList = new NotificationElementList();
        ArrayList<BackupBatch> backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            ArrayList<String> users = new ArrayList<String>();
            for (User user : userList) {
                users.add(user.getUserName());
            }
            backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), users, "", reportQueryElement.getSkipValue()));
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), reportQueryElement.getSkipValue());
        }
        List<NotificationHistoryElement> notificationHistoryElements = this.getNotificationHistoryElements(cloudId, backupBatchList, "both", false, "ALL");
        List delayedBackupBatchList = this.backupBatchDao.getAllLongBackupBatches(cloudId, reportQueryElement.getSkipValue());
        List<NotificationHistoryElement> delayedNotificationHistoryElements = this.getNotificationHistoryElements(cloudId, delayedBackupBatchList, "both", false, "ALL");
        List incompleteBackupBatchList = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, STATUS_STARTED, reportQueryElement.getSkipValue());
        List<NotificationHistoryElement> incompleteBackupBatchElements = this.getNotificationHistoryElements(cloudId, incompleteBackupBatchList, "both", false, "ALL");
        elementList.setNotificationHistoryElementList(notificationHistoryElements);
        elementList.setDelayedNotificationHistoryElements(delayedNotificationHistoryElements);
        elementList.setCurrentBatchElements(incompleteBackupBatchElements);
        return elementList;
    }

    @Override
    public long getFailedBackupCount(Cloud cloud, ReportQueryElement reportQueryElement) {
        int cloudId = cloud.getCloudId();
        long count = 0L;
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug("....inside selected policy names..... ");
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                long usercount = this.backupBatchDao.getBackupBatchCountForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), user.getUserName(), "");
                count += usercount;
            }
        } else {
            logger.debug("....inside not selected policy names..... ");
            count = this.backupBatchDao.getBackupBatchCountForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getUserName(), reportQueryElement.getDeviceName());
        }
        logger.debug("...count..." + count);
        return count;
    }

    @Override
    public void createExcelForFailedBackupReport(int cloudId, String cloudName, String fromDate, String endDate, String userName, String deviceName, int skipValue) {
        String startDate = fromDate;
        if (!startDate.isEmpty() && !endDate.isEmpty()) {
            ArrayList<BackupBatch> backupBatchList = new ArrayList<BackupBatch>();
            Calendar cal = Calendar.getInstance();
            int noOfDays = Integer.parseInt(startDate);
            SimpleDateFormat dateFormat = new SimpleDateFormat(MM_DD_YYYY);
            cal.add(5, -noOfDays);
            startDate = dateFormat.format(cal.getTime());
            List users = this.userDao.getAllActiveUsers(cloudId);
            for (User user : users) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartDate(startDate)), Long.valueOf(ReportServiceImpl.getEndOfDay(endDate)), user.getUserName(), deviceName, skipValue));
            }
            List<BackupHistoryElement> backupHistoryElements = this.getBackupBatchElements(backupBatchList);
            Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

                @Override
                public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                    if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
                }
            });
            this.createExcelFailedBackupHistory(backupHistoryElements, new ReportQueryElement());
        }
    }

    private void createExcelFailedBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        if (!backupHistoryElements.isEmpty()) {
            logger.debug("inside the Report for Failed Backup History ");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelforFailedBackupHistory(backupHistoryElements, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                String fileName = "FailedBackupHistory.xlsx";
                if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
                    fileName = "FailedBackupHistory_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
                }
                this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for FailedBackupHistory " + e.getMessage());
                logger.debug("Exception while creating the excel sheet for FailedBackupHistory " + e);
            }
        }
    }

    private List<List> updateValuesToExcelforFailedBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        logger.debug("inside the Report for Failed Backup History ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_NAME);
        headerRow.add("Asset Name");
        headerRow.add(START_TIME);
        headerRow.add(END_TIME);
        headerRow.add(REASON);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            sb.append(userName + reportQueryElement.getUserName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            sb.append(deviceName + reportQueryElement.getDeviceName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getStartDate())));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getEndTime());
            firstRow.add(backupHistoryElement.getAction());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    @Override
    public NotificationElementList getLongBkpNotificationHistoryElement(int cloudId, String cloudName, String startDate, String endDate, String userName, String deviceName, int skipValue) {
        NotificationElementList elementList = new NotificationElementList();
        List delayedBackupBatchList = this.backupBatchDao.getAllLongBackupBatches(cloudId, skipValue);
        List<NotificationHistoryElement> delayedNotificationHistoryElements = this.getNotificationHistoryElements(cloudId, delayedBackupBatchList, "both", false, "ALL");
        elementList.setDelayedNotificationHistoryElements(delayedNotificationHistoryElements);
        return elementList;
    }

    @Override
    public NotificationElementList getCurrentBkpNotificationHistoryElement(int cloudId, String cloudName, String startDate, String endDate, String userName, String deviceName, int skipValue) {
        NotificationElementList elementList = new NotificationElementList();
        List incompleteBackupBatchList = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, STATUS_STARTED, skipValue);
        List<NotificationHistoryElement> incompleteBackupBatchElements = this.getNotificationHistoryElements(cloudId, incompleteBackupBatchList, "both", true, "ALL");
        elementList.setCurrentBatchElements(incompleteBackupBatchElements);
        return elementList;
    }

    @Override
    public NotificationElementList getCurrentBkpNotificationHistoryElement(int cloudId, ReportQueryElement reportQueryElement, String searchValue, String backupType, String productType) {
        NotificationElementList elementList = new NotificationElementList();
        List incompleteBackupBatchList = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, STATUS_STARTED, STATUS_SANNING, 0, searchValue);
        logger.debug("......elements....." + incompleteBackupBatchList.size());
        ArrayList<BackupBatch> filteredBackUpBatch = new ArrayList<BackupBatch>();
        incompleteBackupBatchList.stream().filter(p -> p.getDeviceUUID() != null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackupBatch::getDeviceUUID)).entrySet().stream().forEach(p -> filteredBackUpBatch.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackupBatch::getBatchStartTimestamp).reversed()).findFirst().get()));
        List<NotificationHistoryElement> incompleteBackupBatchElements = this.getNotificationHistoryElements(cloudId, filteredBackUpBatch, backupType, true, productType);
        logger.debug("......elements1....." + incompleteBackupBatchElements.size());
        elementList.setCurrentBatchElements(incompleteBackupBatchElements);
        return elementList;
    }

    @Override
    public NotificationElementList getCurrentCapacityBkpNotificationHistoryElement(int cloudId, ReportQueryElement reportQueryElement, String searchValue, String backupType, String productType) {
        NotificationElementList elementList = new NotificationElementList();
        List incompleteBackupBatchList = this.backupBatchDao.getAllCapacityBackupBatchForStatus(cloudId, STATUS_STARTED, searchValue, productType);
        if (CollectionUtils.isEmpty((Collection)incompleteBackupBatchList)) {
            logger.debug("....empty records...");
        } else {
            logger.debug("......fromd db...." + incompleteBackupBatchList.size());
        }
        List<NotificationHistoryElement> incompleteBackupBatchElements = this.getCapacityNotificationHistoryElements(cloudId, incompleteBackupBatchList, backupType, true, productType);
        elementList.setCurrentBatchElements(incompleteBackupBatchElements);
        return elementList;
    }

    @Override
    public long getAllRestoreCountForStatus(int cloudId, ReportQueryElement reportQueryElement) {
        return this.backupBatchDao.getAllRestoreCountForStatus(cloudId, STATUS_STARTED);
    }

    @Override
    public NotificationElementList getCurrentRestoreNotificationHistoryElement(int cloudId, ReportQueryElement reportQueryElement, String productType) {
        NotificationElementList elementList = new NotificationElementList();
        List incompleteRestoreBatchList = this.backupBatchDao.getAllRestoreBackupBatchForStatus(cloudId, STATUS_STARTED, reportQueryElement.getPageNo());
        List<NotificationHistoryElement> incompleteBackupBatchElements = this.getRestoreHistoryElements(cloudId, incompleteRestoreBatchList, productType);
        elementList.setCurrentBatchElements(incompleteBackupBatchElements);
        return elementList;
    }

    @Override
    public long getAllBackupBatchCountForStatus(int cloudId, ReportQueryElement reportQueryElement) {
        return this.backupBatchDao.getAllBackupBatchCountForStatus(cloudId, STATUS_STARTED, STATUS_SANNING);
    }

    @Override
    public List<BackupBatch> getAllBackupBatchForStatus(int cloudId) {
        return this.backupBatchDao.getAllBackupBatchForStatus(cloudId, STATUS_STARTED, STATUS_SANNING);
    }

    private List<NotificationHistoryElement> getNotificationHistoryElements(int cloudId, List<BackupBatch> backupBatchList, String backupType, boolean onlyStratedState, String productType) {
        boolean isOnedrive = false;
        boolean isOutlook = false;
        boolean isSharePoint = false;
        boolean isBackup = false;
        if (!StringUtils.isEmpty((String)productType) && (productType.equalsIgnoreCase(ODB) || productType.equalsIgnoreCase("ONEDRIVE"))) {
            isOnedrive = true;
        } else if (!StringUtils.isEmpty((String)productType) && productType.equalsIgnoreCase(SHARE_POINT)) {
            isSharePoint = true;
        } else if (!StringUtils.isEmpty((String)productType) && (productType.equalsIgnoreCase("Exchange") || productType.equalsIgnoreCase("OUTLOOK"))) {
            isOutlook = true;
        } else if (!StringUtils.isEmpty((String)productType) && productType.equalsIgnoreCase("backup")) {
            isBackup = true;
        }
        logger.debug(productType + "...$$producttype$$..." + isOnedrive + "..." + isOutlook + "...." + isSharePoint + "...." + isBackup);
        ArrayList<NotificationHistoryElement> notificationHistoryElements = new ArrayList<NotificationHistoryElement>();
        Comparator<BackupBatch> comparator = Comparator.comparing(BackupBatch::getBatchStartTimestamp).reversed();
        backupBatchList = backupBatchList.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        Set superAdmins = this.userDao.getAllSuperAdmins(cloudId);
        for (BackupBatch backupBatch : backupBatchList) {
            boolean isFirstBkpCompleted;
            if (!"BACKUP".equals(backupBatch.getJobType()) || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID())) continue;
            NotificationHistoryElement notificationHistoryElement = new NotificationHistoryElement();
            DeviceBackupOverView bkpOverview = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            if (bkpOverview.isDeviceBolcked() || bkpOverview.isDeviceDeleted()) {
                logger.debug("....Device is blocked/deleted... for deviceUUID " + backupBatch.getDeviceUUID());
                continue;
            }
            if (!CollectionUtils.isEmpty((Collection)superAdmins) && superAdmins.contains(backupBatch.getUserName())) continue;
            if (!(!onlyStratedState || StringUtils.isEmpty((String)bkpOverview.getLastBkpStatus()) || bkpOverview.getLastBkpStatus().equals(STATUS_STARTED) || bkpOverview.getLastBkpStatus().equals(STATUS_SANNING) || bkpOverview.getLastBkpStatus().equals(BackupBatch.STATUS.QUEUED.toString()))) {
                logger.debug("....Device is last backup status is not started or schanning " + backupBatch.getDeviceUUID());
                continue;
            }
            boolean bl = isFirstBkpCompleted = !StringUtils.isEmpty((String)bkpOverview.getFirstBkpEndTime()) || bkpOverview.getLastSuccessfulBackupEndTime() != 0L;
            if (!StringUtils.isEmpty((String)backupType) && backupType.equals("FULL") && isFirstBkpCompleted) {
                logger.debug("....searching for  backupType" + backupType + "...isFirstBkpCompleted.." + isFirstBkpCompleted + "..so skip");
                continue;
            }
            if (!StringUtils.isEmpty((String)backupType) && backupType.equals("INCR") && !isFirstBkpCompleted) {
                logger.debug("....searching for  backupType" + backupType + "...isFirstBkpCompleted.." + isFirstBkpCompleted + "..so skip");
                continue;
            }
            if (isFirstBkpCompleted) {
                if (backupBatch.isFullBackup()) {
                    notificationHistoryElement.setBackupType("FULL");
                } else {
                    notificationHistoryElement.setBackupType("INCR");
                }
            } else {
                notificationHistoryElement.setBackupType("FULL");
            }
            logger.debug(productType + "...status..." + backupBatch.getStatus());
            notificationHistoryElement.setUserName(backupBatch.getUserName());
            notificationHistoryElement.setDeviceName(backupBatch.getDeviceName());
            notificationHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
            notificationHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
            notificationHistoryElement.setWhenFailed(this.getDate(backupBatch.getBatchEndTimestamp()));
            notificationHistoryElement.setWhenFailedInMillis(backupBatch.getBatchEndTimestamp());
            if (isOnedrive && !backupBatch.getDeviceName().contains("Microsoft OneDrive") || isSharePoint && !backupBatch.getDeviceName().contains("Microsoft SharePoint") || isOutlook && !backupBatch.getDeviceName().contains("Microsoft Exchange") || isBackup && (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft SharePoint") || backupBatch.getDeviceName().contains("Microsoft OneDrive"))) continue;
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                officeProduct = true;
            }
            notificationHistoryElement.setFailedReason(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct));
            notificationHistoryElement.setErrorCode(backupBatch.getErrorCode());
            notificationHistoryElement.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            notificationHistoryElement.setUploadedFiles(backupBatch.getUploadedFiles());
            notificationHistoryElement.setDeviceUUID(backupBatch.getDeviceUUID());
            notificationHistoryElement.setStatus(backupBatch.getStatus());
            notificationHistoryElement.setDeviceType(bkpOverview.getDeviceType());
            notificationHistoryElement.setCurrentlyRunningBkpTotalSizeOfFilesInKB(bkpOverview.getCurrentlyRunningBkpTotalSizeOfFiles());
            notificationHistoryElement.setTotalSizeToUploadInKB(bkpOverview.getTotalSizeToUpload());
            String uploadedFiles = backupBatch.getUploadedFiles();
            try {
                String[] parts = uploadedFiles.split("/");
                notificationHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
                notificationHistoryElement.setTotalFiles(Integer.parseInt(parts[1]));
                float totalFiles = notificationHistoryElement.getTotalFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                int noOfFileRemaining = notificationHistoryElement.getTotalFiles() - notificationHistoryElement.getNoOfFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                if (noOfFileRemaining < 0) {
                    noOfFileRemaining = 0;
                }
                long percentage = 0L;
                percentage = ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalNoOfFiles(), noOfFileRemaining + "");
                if (backupBatch.getStatus().equalsIgnoreCase(STATUS_SANNING)) {
                    percentage = 0L;
                }
                if (Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(bkpOverview.getDeviceType()) || Device.TYPE.OUTLOOK.toString().equalsIgnoreCase(bkpOverview.getDeviceType())) {
                    percentage = ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalNoOfFiles(), noOfFileRemaining + "");
                }
                notificationHistoryElement.setUploadPercent(Float.toString(percentage));
            }
            catch (Exception e) {
                logger.debug("  Error trying to split no of files " + e.getMessage());
                logger.debug("  Error trying to split no of files " + e);
            }
            logger.debug("...element...." + notificationHistoryElement.getDeviceName() + "...." + notificationHistoryElement.getStatus());
            notificationHistoryElements.add(notificationHistoryElement);
            logger.debug("history elements...." + notificationHistoryElements.size());
        }
        return notificationHistoryElements;
    }

    private List<NotificationHistoryElement> getCapacityNotificationHistoryElements(int cloudId, List<CPBackupBatch> backupBatchList, String backupType, boolean onlyStratedState, String productType) {
        logger.debug(productType + "...$$producttype$$...");
        ArrayList<NotificationHistoryElement> notificationHistoryElements = new ArrayList<NotificationHistoryElement>();
        Comparator<CPBackupBatch> comparator = Comparator.comparing(CPBackupBatch::getBatchStartTimestamp).reversed();
        backupBatchList = backupBatchList.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        for (CPBackupBatch cPBackupBatch : backupBatchList) {
            NotificationHistoryElement notificationHistoryElement = new NotificationHistoryElement();
            logger.debug(productType + "...status..." + cPBackupBatch.getStatus());
            notificationHistoryElement.setUserName(cPBackupBatch.getUserName());
            notificationHistoryElement.setDeviceName(cPBackupBatch.getDeviceName());
            notificationHistoryElement.setStartTime(this.getDate(cPBackupBatch.getBatchStartTimestamp()));
            notificationHistoryElement.setStartTimeInMillis(cPBackupBatch.getBatchStartTimestamp());
            notificationHistoryElement.setWhenFailed(this.getDate(cPBackupBatch.getBatchEndTimestamp()));
            notificationHistoryElement.setWhenFailedInMillis(cPBackupBatch.getBatchEndTimestamp());
            boolean officeProduct = true;
            notificationHistoryElement.setFailedReason(this.getCommentsForBackupBatch(cPBackupBatch.getErrorCode(), officeProduct));
            notificationHistoryElement.setErrorCode(cPBackupBatch.getErrorCode());
            notificationHistoryElement.setTotalNoOfFiles(cPBackupBatch.getTotalNoOfFiles());
            notificationHistoryElement.setUploadedFiles(cPBackupBatch.getUploadedFiles());
            notificationHistoryElement.setDeviceUUID(cPBackupBatch.getDeviceUUID());
            notificationHistoryElement.setStatus(cPBackupBatch.getStatus());
            String uploadedFiles = cPBackupBatch.getUploadedFiles();
            try {
                if (!StringUtils.isEmpty((String)uploadedFiles)) {
                    String[] parts = uploadedFiles.split("/");
                    notificationHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
                    notificationHistoryElement.setTotalFiles(Integer.parseInt(parts[1]));
                }
                float totalFiles = notificationHistoryElement.getTotalFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                int noOfFileRemaining = notificationHistoryElement.getTotalFiles() - notificationHistoryElement.getNoOfFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                if (noOfFileRemaining < 0) {
                    noOfFileRemaining = 0;
                }
                long percentage = 0L;
                percentage = notificationHistoryElement.getTotalSizeToUploadInKB() != 0L && notificationHistoryElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalSizeToUploadInKB(), notificationHistoryElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalNoOfFiles(), noOfFileRemaining + "");
                if (cPBackupBatch.getStatus().equalsIgnoreCase(STATUS_SANNING)) {
                    percentage = 0L;
                }
                percentage = ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalNoOfFiles(), noOfFileRemaining + "");
                if (notificationHistoryElement.getTotalFiles() == notificationHistoryElement.getNoOfFiles()) {
                    percentage = notificationHistoryElement.getTotalFiles() > 0 ? 100L : 0L;
                    if (cPBackupBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.COMPLETED.name())) {
                        percentage = 100L;
                    }
                    if (cPBackupBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.name()) && notificationHistoryElement.getTotalFiles() == 0 && notificationHistoryElement.getNoOfFiles() == 0) {
                        percentage = 0L;
                    }
                }
                logger.debug(BackupBatch.STATUS.STARTED.name() + ".....%....." + percentage);
                logger.debug(BackupBatch.STATUS.STARTED.name() + ".....files....." + notificationHistoryElement.getTotalFiles() + "...." + notificationHistoryElement.getNoOfFiles());
                notificationHistoryElement.setUploadPercent(Float.toString(percentage));
                long size = 0L;
                try {
                    size = Long.parseLong(cPBackupBatch.getUploadedSize());
                    size /= 1024L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                notificationHistoryElement.setTotalSizeToUploadInKB(size);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.debug("  Error trying to split no of files " + e.getMessage());
                logger.debug("  Error trying to split no of files " + e);
            }
            notificationHistoryElements.add(notificationHistoryElement);
            logger.debug("...actual...");
        }
        return notificationHistoryElements;
    }

    private List<NotificationHistoryElement> getReportNotificationHistoryElements(int cloudId, List<BackupBatch> backupBatchList, String backupType, boolean onlyStratedState) {
        ArrayList<NotificationHistoryElement> notificationHistoryElements = new ArrayList<NotificationHistoryElement>();
        Comparator<BackupBatch> comparator = Comparator.comparing(BackupBatch::getBatchStartTimestamp).reversed();
        backupBatchList = backupBatchList.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        for (BackupBatch backupBatch : backupBatchList) {
            boolean isFirstBkpCompleted;
            NotificationHistoryElement notificationHistoryElement = new NotificationHistoryElement();
            DeviceBackupOverView bkpOverview = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            if (bkpOverview.isDeviceBolcked() || bkpOverview.isDeviceDeleted()) {
                logger.debug("....Device is blocked/deleted... for deviceUUID " + backupBatch.getDeviceUUID());
                continue;
            }
            if (onlyStratedState && !StringUtils.isEmpty((String)bkpOverview.getLastBkpStatus()) && !bkpOverview.getLastBkpStatus().equals(STATUS_STARTED)) {
                logger.debug("....Device is last backup status is not started " + backupBatch.getDeviceUUID());
                continue;
            }
            boolean bl = isFirstBkpCompleted = !StringUtils.isEmpty((String)bkpOverview.getFirstBkpEndTime()) || bkpOverview.getLastSuccessfulBackupEndTime() != 0L;
            if (!StringUtils.isEmpty((String)backupType) && backupType.equals("FULL") && isFirstBkpCompleted) {
                logger.debug("....searching for  backupType" + backupType + "...isFirstBkpCompleted.." + isFirstBkpCompleted + "..so skip");
                continue;
            }
            if (!StringUtils.isEmpty((String)backupType) && backupType.equals("INCR") && !isFirstBkpCompleted) {
                logger.debug("....searching for  backupType" + backupType + "...isFirstBkpCompleted.." + isFirstBkpCompleted + "..so skip");
                continue;
            }
            if (isFirstBkpCompleted) {
                notificationHistoryElement.setBackupType("INCR");
            } else {
                notificationHistoryElement.setBackupType("FULL");
            }
            logger.debug("...status..." + backupBatch.getStatus());
            notificationHistoryElement.setUserName(backupBatch.getUserName());
            notificationHistoryElement.setDeviceName(backupBatch.getDeviceName());
            notificationHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
            notificationHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
            notificationHistoryElement.setWhenFailed(this.getDate(backupBatch.getBatchEndTimestamp()));
            notificationHistoryElement.setWhenFailedInMillis(backupBatch.getBatchEndTimestamp());
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                officeProduct = true;
            }
            notificationHistoryElement.setFailedReason(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct));
            notificationHistoryElement.setErrorCode(backupBatch.getErrorCode());
            notificationHistoryElement.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            notificationHistoryElement.setUploadedFiles(backupBatch.getUploadedFiles());
            notificationHistoryElement.setDeviceUUID(backupBatch.getDeviceUUID());
            notificationHistoryElement.setStatus(backupBatch.getStatus());
            notificationHistoryElement.setDeviceType(bkpOverview.getDeviceType());
            notificationHistoryElements.add(notificationHistoryElement);
        }
        return notificationHistoryElements;
    }

    private List<NotificationHistoryElement> getRestoreHistoryElements(int cloudId, List<BackupBatch> backupBatchList, String productType) {
        boolean isOnedrive = false;
        boolean isOutlook = false;
        boolean isSharePoint = false;
        boolean isBackup = false;
        if (!StringUtils.isEmpty((String)productType) && (productType.equalsIgnoreCase(ODB) || productType.equalsIgnoreCase("ONEDRIVE"))) {
            isOnedrive = true;
        } else if (!StringUtils.isEmpty((String)productType) && productType.equalsIgnoreCase(SHARE_POINT)) {
            isSharePoint = true;
        } else if (!StringUtils.isEmpty((String)productType) && (productType.equalsIgnoreCase("Exchange") || productType.equalsIgnoreCase("OUTLOOK"))) {
            isOutlook = true;
        } else if (!StringUtils.isEmpty((String)productType) && productType.equalsIgnoreCase("backup")) {
            isBackup = true;
        }
        logger.debug(productType + "...$$producttype$$..." + isOnedrive + "..." + isOutlook + "...." + isSharePoint + "...." + isBackup);
        ArrayList<NotificationHistoryElement> notificationHistoryElements = new ArrayList<NotificationHistoryElement>();
        Comparator<BackupBatch> comparator = Comparator.comparing(BackupBatch::getBatchStartTimestamp).reversed();
        backupBatchList = backupBatchList.stream().filter(Objects::nonNull).sorted(comparator).collect(Collectors.toList());
        Set superAdmins = this.userDao.getAllSuperAdmins(cloudId);
        for (BackupBatch backupBatch : backupBatchList) {
            if (!RESTORE.equals(backupBatch.getJobType()) || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID()) || !CollectionUtils.isEmpty((Collection)superAdmins) && superAdmins.contains(backupBatch.getUserName())) continue;
            NotificationHistoryElement notificationHistoryElement = new NotificationHistoryElement();
            DeviceBackupOverView bkpOverview = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, backupBatch.getDeviceUUID());
            if (!backupBatch.getStatus().equalsIgnoreCase(STATUS_STARTED) && (bkpOverview != null && bkpOverview.isDeviceBolcked() || bkpOverview.isDeviceDeleted())) {
                logger.debug("....Device is blocked/deleted... for deviceUUID " + backupBatch.getDeviceUUID());
                continue;
            }
            logger.debug(backupBatch.getDeviceUUID() + "...status..." + backupBatch.getStatus());
            RestoreHistory restoreHistory = this.backupBatchDao.getRestoreHistoryById(cloudId, backupBatch.getId());
            logger.debug(".......restoreHistory......." + restoreHistory);
            if (restoreHistory != null) {
                logger.debug(backupBatch.getUserName() + ".....not nulll..new11...." + restoreHistory.getRestoreByUserName());
                notificationHistoryElement.setUserName(restoreHistory.getUserName());
                notificationHistoryElement.setDeviceName(restoreHistory.getDeviceName());
                if (StringUtils.isNotEmpty((String)restoreHistory.getRestoreFolder())) {
                    notificationHistoryElement.setRestoreFolder(this.encodeUTFBase64(restoreHistory.getRestoreFolder()));
                }
                if (StringUtils.isNotEmpty((String)restoreHistory.getDestFolder())) {
                    notificationHistoryElement.setDestFolder(this.encodeUTFBase64(restoreHistory.getDestFolder()));
                }
            } else {
                notificationHistoryElement.setUserName(backupBatch.getUserName());
                notificationHistoryElement.setDeviceName(backupBatch.getDeviceName());
            }
            RestoreEvents restoreEventByUUID = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, backupBatch.getDeviceUUID(), "");
            RestoreProgressEvents progressEvents = this.eventHubDao.getRestoreProgressByEvents(cloudId, backupBatch.getDeviceUUID());
            if (restoreEventByUUID != null && !StringUtils.isEmpty((String)restoreEventByUUID.getActionBy())) {
                notificationHistoryElement.setRestoreInitiatedBy(restoreEventByUUID.getActionBy());
            }
            notificationHistoryElement.setDeviceUUID(backupBatch.getDeviceUUID());
            notificationHistoryElement.setRestoreByDeviceName(restoreHistory == null ? backupBatch.getDeviceName() : restoreHistory.getRestoreByDeviceName());
            notificationHistoryElement.setRestoreByUserName(restoreHistory == null ? backupBatch.getUserName() : restoreHistory.getRestoreByUserName());
            notificationHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
            notificationHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
            notificationHistoryElement.setWhenFailed(this.getDate(backupBatch.getBatchEndTimestamp()));
            notificationHistoryElement.setWhenFailedInMillis(backupBatch.getBatchEndTimestamp());
            notificationHistoryElement.setBatchId(backupBatch.getId().toString());
            if (isOnedrive && !backupBatch.getDeviceName().contains("Microsoft OneDrive") || isSharePoint && !backupBatch.getDeviceName().contains("Microsoft SharePoint") || isOutlook && !backupBatch.getDeviceName().contains("Microsoft Exchange") || isBackup && (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft SharePoint") || backupBatch.getDeviceName().contains("Microsoft OneDrive"))) continue;
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
                officeProduct = true;
            }
            notificationHistoryElement.setFailedReason(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct));
            notificationHistoryElement.setErrorCode(backupBatch.getErrorCode());
            notificationHistoryElement.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            notificationHistoryElement.setUploadedFiles(backupBatch.getUploadedFiles());
            notificationHistoryElement.setStatus(backupBatch.getStatus());
            if (bkpOverview != null) {
                notificationHistoryElement.setDeviceType(bkpOverview.getDeviceType());
                notificationHistoryElement.setCurrentlyRunningBkpTotalSizeOfFilesInKB(bkpOverview.getCurrentlyRunningBkpTotalSizeOfFiles());
                notificationHistoryElement.setTotalSizeToUploadInKB(bkpOverview.getTotalSizeToUpload());
            }
            String uploadedFiles = backupBatch.getUploadedFiles();
            try {
                String[] parts = uploadedFiles.split("/");
                notificationHistoryElement.setNoOfFiles(Integer.parseInt(parts[0]));
                notificationHistoryElement.setTotalFiles(Integer.parseInt(parts[1]));
                float totalFiles = notificationHistoryElement.getTotalFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                int noOfFileRemaining = notificationHistoryElement.getTotalFiles() - notificationHistoryElement.getNoOfFiles();
                logger.debug("..percent.... " + notificationHistoryElement.getNoOfFiles() + "...total...." + totalFiles);
                if (noOfFileRemaining < 0) {
                    noOfFileRemaining = 0;
                }
                long percentage = 0L;
                percentage = notificationHistoryElement.getTotalSizeToUploadInKB() != 0L && notificationHistoryElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalSizeToUploadInKB(), notificationHistoryElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(notificationHistoryElement.getTotalNoOfFiles(), noOfFileRemaining + "");
                if (progressEvents != null) {
                    if (!(restoreEventByUUID != null && (restoreEventByUUID == null || restoreEventByUUID.getOfficePolicyName() != null && restoreEventByUUID.getOfficePolicyName().equalsIgnoreCase("pb-endpoint-to-onedrive-restore")) || bkpOverview == null || !StringUtils.isEmpty((String)bkpOverview.getDeviceType()) && !bkpOverview.getDeviceType().equalsIgnoreCase("BACKUP"))) {
                        if (progressEvents.getTotalRestorableSize() != 0L && progressEvents.getTotalsize() != 0L) {
                            notificationHistoryElement.setUploadPercent("" + ReportServiceImpl.getPercentageCompleted(progressEvents.getTotalRestorableSize(), progressEvents.getTotalsize()));
                        } else if (progressEvents.getTotalNoOfFilesForRestore() != 0L && progressEvents.getTotalNoOfRestoreFilesForFolder() != 0L) {
                            notificationHistoryElement.setUploadPercent("" + ReportServiceImpl.getPercentageCompleted(progressEvents.getTotalNoOfFilesForRestore(), progressEvents.getTotalNoOfRestoreFilesForFolder()));
                        } else {
                            notificationHistoryElement.setUploadPercent("0");
                        }
                    } else if (progressEvents.getTotalNoOfFilesForRestore() == 0L || progressEvents.getRestoredFiles() == 0L) {
                        notificationHistoryElement.setUploadPercent("0");
                    } else {
                        logger.debug("..calling getPercentageCompleted.." + progressEvents.getRestoredFiles() + "...." + progressEvents.getTotalNoOfFilesForRestore());
                        long percent = 100L;
                        percent = progressEvents.getRestoredFiles() * 100L / progressEvents.getTotalNoOfFilesForRestore();
                        notificationHistoryElement.setUploadPercent("" + percent);
                    }
                } else {
                    notificationHistoryElement.setUploadPercent("-");
                }
                logger.debug(".........restore percentage..." + notificationHistoryElement.getUploadPercent());
            }
            catch (Exception e) {
                logger.debug("  Error trying to split no of files " + e.getMessage());
                logger.debug("  Error trying to split no of files " + e);
            }
            notificationHistoryElements.add(notificationHistoryElement);
        }
        return notificationHistoryElements;
    }

    public static String formatFileSize(long size) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            hrSize = dec.format(t).concat(" TB");
        } else if (g > 1.0) {
            hrSize = dec.format(g).concat(" GB");
        } else {
            if (m <= 0.0) {
                m = 0.0;
            }
            hrSize = dec.format(m).concat(" MB");
        }
        return hrSize;
    }

    public static String formatFileSizeForMspDasboardTile(long size) {
        String hrSize;
        double m = (double)size / 1000.0;
        double g = (double)size / 1000.0 / 1000.0;
        double t = (double)size / 1000.0 / 1000.0 / 1000.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            hrSize = dec.format(t).concat(" TB");
        } else if (g > 1.0) {
            hrSize = dec.format(g).concat(" GB");
        } else {
            if (m <= 0.0) {
                m = 0.0;
            }
            hrSize = dec.format(m).concat(" MB");
        }
        return hrSize;
    }

    public static String formatFileSizeIncludeKB(long size) {
        double k = size;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : dec.format(k).concat(" KB")));
        return hrSize;
    }

    public static String formatFileSizeInMB(long size) {
        if (size == 0L) {
            return "0 MB";
        }
        double m = (double)size / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = dec.format(m).concat(" MB");
        return hrSize;
    }

    private String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    @Override
    public Long getNoOfRestoresDone(int cloudId, String cloudName, String startDate, String endDate) {
        Long stDate = new Long(0L);
        Long edDate = new Long(0L);
        return this.backupBatchDao.getNoOfRestoresDone(cloudId, cloudName, stDate, edDate);
    }

    @Override
    public Long getNoOfBackupsDone(int cloudId, String cloudName, String startDate, String endDate) {
        Long stDate = new Long(0L);
        Long edDate = new Long(0L);
        return this.backupBatchDao.getNoOfBackupsDone(cloudId, cloudName, stDate, edDate);
    }

    @Override
    public List<StorageInfoElement> getStorageInfoElements(int cloudId, String cloudName, String userName, String deviceName, int skipValue) {
        ArrayList<StorageInfoElement> list = new ArrayList<StorageInfoElement>();
        if (!StringUtils.isEmpty((String)userName)) {
            User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
            if (user != null) {
                List overViewList = this.deviceDao.getAllOverviews(cloudId, userName);
                if (!CollectionUtils.isEmpty((Collection)overViewList)) {
                    for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                        if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted()) continue;
                        StorageInfoElement storageInfoElement = new StorageInfoElement();
                        Long storageUsed = deviceBackupOverView.getStorageUtilized();
                        storageInfoElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                        storageInfoElement.setDeviceName(deviceBackupOverView.getDeviceName());
                        storageInfoElement.setUserName(deviceBackupOverView.getUserName());
                        list.add(storageInfoElement);
                    }
                } else {
                    StorageInfoElement storageInfoElement = new StorageInfoElement();
                    Long storageUsed = 0L;
                    storageInfoElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                    storageInfoElement.setDeviceName("");
                    storageInfoElement.setUserName(userName);
                    list.add(storageInfoElement);
                }
            }
        } else if (!StringUtils.isEmpty((String)deviceName)) {
            List overViewList = this.deviceDao.getAllOverviews(cloudId, userName);
            if (!CollectionUtils.isEmpty((Collection)overViewList)) {
                for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                    if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceBackupOverView.getDeviceName().equalsIgnoreCase(deviceName)) continue;
                    StorageInfoElement storageInfoElement = new StorageInfoElement();
                    Long storageUsed = deviceBackupOverView.getStorageUtilized();
                    storageInfoElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                    storageInfoElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    storageInfoElement.setUserName(deviceBackupOverView.getUserName());
                    list.add(storageInfoElement);
                }
            } else {
                List overviews = this.deviceDao.getAllOverviews(cloudId, skipValue);
                for (DeviceBackupOverView deviceBackupOverView : overviews) {
                    if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted()) continue;
                    StorageInfoElement storageInfoElement = new StorageInfoElement();
                    Long storageUsed = deviceBackupOverView.getStorageUtilized();
                    storageInfoElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                    storageInfoElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    storageInfoElement.setUserName(deviceBackupOverView.getUserName());
                    list.add(storageInfoElement);
                }
                if (overviews == null || overviews.isEmpty() || overviews.size() < PCHelperConstant.getReportDisplayRecords()) {
                    // empty if block
                }
            }
        }
        return list;
    }

    @Override
    public List<NotificationHistoryElement> getFailedNotificationHistoryElement(int cloudId, String cloudName) {
        List delayedBackupBatchList = this.backupBatchDao.getBackupBatchesMoreThanWeek(cloudId, cloudName);
        return this.getNotificationHistoryElements(cloudId, delayedBackupBatchList, "both", false, "ALL");
    }

    @Override
    public List<BackupHistoryElement> getLastBackup(int cloudId, String cloudName, String userName, String deviceName) {
        List list = this.backupBatchDao.getLastBackup(cloudId, cloudName, userName, deviceName);
        return this.getBackupBatchElements(list);
    }

    @Override
    public List<BackupHistoryElement> getLastBackupReport(int cloudId, String cloudName, String userName, String deviceName) {
        List list = this.backupBatchDao.getLastBackupReport(cloudId, cloudName, userName, deviceName);
        return this.getBackupBatchElements(list);
    }

    private Long getConvertedDate(String date) {
        SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        long milliseconds = 0L;
        try {
            Date d = f.parse(date);
            milliseconds = d.getTime();
        }
        catch (Exception e) {
            logger.error("...unable to parse..... " + e.getMessage());
            logger.trace(EXCEPTION + e);
        }
        return milliseconds;
    }

    @Override
    public List<BackupHistoryElement> getNoBackup(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType, boolean systemNotProtected) {
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        List<DeviceBackupOverView> overViewList = this.getBkpOverviewForNoBackupReportQuery(cloud, cloudName, reportQueryElement, productType);
        HashSet<String> protectedUserNames = new HashSet<String>();
        logger.debug(reportQueryElement.getNoOfDays() + "...overViewList1..." + overViewList.size() + "...reportQueryElement.." + reportQueryElement.toString());
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView == null || !deviceBackupOverView.isUserActive() || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isDeviceBolcked()) continue;
            BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
            backupHistoryElement.setDeviceName(deviceBackupOverView.getDeviceName());
            backupHistoryElement.setUserName(deviceBackupOverView.getUserName());
            logger.debug(deviceBackupOverView.getDeviceName() + "........." + deviceBackupOverView.getDeviceType());
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getOneDrivePolicyName());
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getExchangePolicyName());
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getSpPolicyName());
            } else {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getPolicyName());
            }
            if (deviceBackupOverView.getLastHeardTime() != 0L) {
                backupHistoryElement.setLastHeardTime(Long.toString(deviceBackupOverView.getLastHeardTime()));
            } else {
                backupHistoryElement.setLastHeardTime(deviceBackupOverView.getEpaInstallationDate());
            }
            long noOfDaysInMillisecounds = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(reportQueryElement.getNoOfDays());
            if (deviceBackupOverView.getLastSuccessfulBackupEndTime() == 0L) {
                if (StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpStartTime())) {
                    backupHistoryElement.setEndTime(BACKUP_NOT_STARTED);
                } else {
                    backupHistoryElement.setEndTime(BACKUP_NOT_COMPLETED);
                }
            }
            long lastBkpEndTime = 0L;
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpEndTime())) {
                lastBkpEndTime = this.getConvertedDate(deviceBackupOverView.getLastBkpEndTime());
                if (lastBkpEndTime == 0L && deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L && lastBkpEndTime < deviceBackupOverView.getLastSuccessfulBackupEndTime()) {
                    lastBkpEndTime = deviceBackupOverView.getLastSuccessfulBackupEndTime();
                }
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getEpaInstallationDate())) {
                lastBkpEndTime = Long.parseLong(deviceBackupOverView.getEpaInstallationDate());
            }
            logger.debug(deviceBackupOverView.getLastBkpEndTime() + "--- no backup report--" + deviceBackupOverView.getLastSuccessfulBackupEndTime());
            logger.debug(lastBkpEndTime + "--no backup report---" + noOfDaysInMillisecounds);
            if (lastBkpEndTime != 0L && lastBkpEndTime <= noOfDaysInMillisecounds) {
                if (!systemNotProtected) {
                    if (!protectedUserNames.contains(backupHistoryElement.getUserName())) {
                        if (lastBkpEndTime == 999L) {
                            backupHistoryElement.setEndTime("" + lastBkpEndTime);
                        } else {
                            backupHistoryElement.setEndTime(this.getDate(lastBkpEndTime));
                        }
                        backupHistoryElements.add(backupHistoryElement);
                    }
                } else {
                    if (lastBkpEndTime == 999L) {
                        backupHistoryElement.setEndTime("" + lastBkpEndTime);
                    } else {
                        backupHistoryElement.setEndTime(this.getDate(lastBkpEndTime));
                    }
                    backupHistoryElements.add(backupHistoryElement);
                }
            } else if (!protectedUserNames.contains(backupHistoryElement.getUserName())) {
                protectedUserNames.add(backupHistoryElement.getUserName());
                logger.debug(backupHistoryElement.getDeviceName() + "...protected user name:" + backupHistoryElement.getUserName());
            }
            logger.debug(deviceBackupOverView.getUserName() + "...." + deviceBackupOverView.getLastBkpEndTime() + "--- no backup report--" + deviceBackupOverView.getLastSuccessfulBackupEndTime());
            logger.debug(lastBkpEndTime + "--no backup report---" + noOfDaysInMillisecounds + "...noofdays..." + reportQueryElement.getNoOfDays());
        }
        ArrayList<BackupHistoryElement> backupHistoryElementFinalList = new ArrayList<BackupHistoryElement>();
        logger.debug("...final list1.... " + backupHistoryElements.size());
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            if (!systemNotProtected && protectedUserNames.contains(backupHistoryElement.getUserName())) continue;
            String daysDiff = "";
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                logger.debug(backupHistoryElement.getUserName() + "....insidefor..." + backupHistoryElement.getEndTime());
                logger.debug("...values not set...." + backupHistoryElement.getEndTime());
                Date d1 = format.parse(backupHistoryElement.getEndTime());
                DateTime dt1 = new DateTime((Object)d1);
                DateTime dt2 = new DateTime();
                daysDiff = Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays());
                d1 = format.parse(this.getDate(Long.parseLong(backupHistoryElement.getLastHeardTime())));
                dt1 = new DateTime((Object)d1);
                backupHistoryElement.setLastHeardTime(Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays()));
            }
            catch (Exception e) {
                logger.debug(backupHistoryElement.getEndTime() + "Exception while Formatting the date " + e);
            }
            if (StringUtils.isEmpty((String)daysDiff)) {
                backupHistoryElement.setNoOfDaysNotBackedUp(backupHistoryElement.getEndTime());
            } else {
                backupHistoryElement.setNoOfDaysNotBackedUp(daysDiff);
            }
            if (StringUtils.isEmpty((String)backupHistoryElement.getEndTime()) || "999".equals(backupHistoryElement.getEndTime())) {
                // empty if block
            }
            logger.debug(backupHistoryElement.getUserName() + "....before adding..." + backupHistoryElement.getNoOfDaysNotBackedUp() + "..heard.." + backupHistoryElement.getLastHeardTime());
            int lastHeardDays = 0;
            lastHeardDays = Integer.parseInt(backupHistoryElement.getLastHeardTime());
            if (reportQueryElement.isIncludeDevicesHeardFrom() && reportQueryElement.getDaysToIncludeDevicesHeardFrom() > lastHeardDays) {
                backupHistoryElementFinalList.add(backupHistoryElement);
                continue;
            }
            if (reportQueryElement.isIncludeDevicesHeardFrom()) continue;
            backupHistoryElementFinalList.add(backupHistoryElement);
        }
        return backupHistoryElementFinalList;
    }

    @Override
    public long getNoBackupTotalCount(Cloud cloud, ReportQueryElement reportQueryElement, String productType, boolean systemNotProtected) {
        String cloudName = cloud.getCloudName();
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        List<DeviceBackupOverView> overViewList = this.getBkpOverviewFromReportQuery(cloud, cloudName, reportQueryElement, productType);
        logger.debug("...overViewList..." + overViewList.size() + "...reportQueryElement.." + reportQueryElement.toString());
        HashSet<String> protectedUserNames = new HashSet<String>();
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView == null || !deviceBackupOverView.isUserActive() || deviceBackupOverView.isDeviceDeleted()) continue;
            BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
            backupHistoryElement.setDeviceName(deviceBackupOverView.getDeviceName());
            backupHistoryElement.setUserName(deviceBackupOverView.getUserName());
            logger.debug("........." + deviceBackupOverView.getDeviceType());
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getOneDrivePolicyName());
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getExchangePolicyName());
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getSpPolicyName());
            } else {
                backupHistoryElement.setPolicyName(deviceBackupOverView.getPolicyName());
            }
            if (deviceBackupOverView.getLastHeardTime() != 0L) {
                backupHistoryElement.setLastHeardTime(Long.toString(deviceBackupOverView.getLastHeardTime()));
            } else {
                backupHistoryElement.setLastHeardTime(deviceBackupOverView.getEpaInstallationDate());
            }
            long noOfDaysInMillisecounds = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(reportQueryElement.getNoOfDays());
            if (deviceBackupOverView.getLastSuccessfulBackupEndTime() == 0L) {
                if (StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpStartTime())) {
                    backupHistoryElement.setEndTime(BACKUP_NOT_STARTED);
                } else {
                    backupHistoryElement.setEndTime(BACKUP_NOT_COMPLETED);
                }
            }
            long lastBkpEndTime = 0L;
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpEndTime())) {
                lastBkpEndTime = this.getConvertedDate(deviceBackupOverView.getLastBkpEndTime());
                if (lastBkpEndTime == 0L && deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L && lastBkpEndTime < deviceBackupOverView.getLastSuccessfulBackupEndTime()) {
                    lastBkpEndTime = deviceBackupOverView.getLastSuccessfulBackupEndTime();
                }
            } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getEpaInstallationDate())) {
                lastBkpEndTime = Long.parseLong(deviceBackupOverView.getEpaInstallationDate());
            }
            logger.debug(deviceBackupOverView.getLastBkpEndTime() + "--- no backup report--" + deviceBackupOverView.getLastSuccessfulBackupEndTime());
            logger.debug(lastBkpEndTime + "--no backup report---" + noOfDaysInMillisecounds);
            if (lastBkpEndTime != 0L && lastBkpEndTime <= noOfDaysInMillisecounds) {
                if (!systemNotProtected) {
                    if (protectedUserNames.contains(backupHistoryElement.getUserName())) continue;
                    backupHistoryElement.setEndTime(this.getDate(lastBkpEndTime));
                    backupHistoryElements.add(backupHistoryElement);
                    continue;
                }
                backupHistoryElement.setEndTime(this.getDate(lastBkpEndTime));
                backupHistoryElements.add(backupHistoryElement);
                continue;
            }
            if (protectedUserNames.contains(backupHistoryElement.getUserName())) continue;
            protectedUserNames.add(backupHistoryElement.getUserName());
        }
        logger.debug("...final list.... " + backupHistoryElements.size());
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            String daysDiff = "";
            try {
                if (!systemNotProtected && protectedUserNames.contains(backupHistoryElement.getUserName())) continue;
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                Date d1 = format.parse(backupHistoryElement.getEndTime());
                DateTime dt1 = new DateTime((Object)d1);
                DateTime dt2 = new DateTime();
                daysDiff = Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays());
                d1 = format.parse(this.getDate(Long.parseLong(backupHistoryElement.getLastHeardTime())));
                dt1 = new DateTime((Object)d1);
                backupHistoryElement.setLastHeardTime(Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays()));
            }
            catch (Exception e) {
                logger.debug(backupHistoryElement.getEndTime() + "Exception while Formatting the date " + e);
            }
            if (StringUtils.isEmpty((String)daysDiff)) {
                backupHistoryElement.setNoOfDaysNotBackedUp(backupHistoryElement.getEndTime());
                continue;
            }
            backupHistoryElement.setNoOfDaysNotBackedUp(daysDiff);
        }
        return backupHistoryElements.size();
    }

    private List<DeviceBackupOverView> getBkpOverviewForNoBackupReportQuery(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType) {
        List<Object> bkpOverViewuserNames;
        User user;
        int cloudId = cloud.getCloudId();
        List<DeviceBackupOverView> overViewList = new ArrayList();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        ArrayList<User> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            user = this.userDao.getUserInfoByName(cloudId, cloudName, reportQueryElement.getUserName());
            users.add(user);
        } else {
            List usersList = this.userDao.getAllUsers(cloudId, cloudName, false);
            users.addAll(usersList);
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug("....productType...." + productType);
            overViewList = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty(overViewList)) {
                    bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(user2);
                        overViewList.add(deviceOver);
                    }
                } else {
                    List usersList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                        if (userDetails == null) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(userDetails);
                        overViewList.add(deviceOver);
                    }
                }
            }
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            logger.debug("....productType...." + productType);
            overViewList = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(overViewList)) {
                user = (User)users.get(0);
                DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                if (user != null) {
                    deviceOver = this.setUserWithoutDeviceElementvalue(user);
                    overViewList.add(deviceOver);
                }
            }
        } else {
            logger.debug("....productType...." + productType);
            overViewList = this.deviceDao.getAllOverviewsForProductType(cloudId, productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user3 = (User)users.get(i);
                    DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                    if (user3 == null) continue;
                    deviceOver = this.setUserWithoutDeviceElementvalue(user3);
                    overViewList.add(deviceOver);
                }
            }
        }
        logger.debug(reportQueryElement.getSkipValue() + "...before custom page ... " + overViewList.size());
        return overViewList;
    }

    public static <T> List<T> getPage(List<T> sourceList, int page, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = page * pageSize;
        if (sourceList == null || sourceList.size() < fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }

    private List<DeviceBackupOverView> getBkpOverviewFromReportQuery(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType) {
        DeviceBackupOverView deviceOver;
        List<Object> bkpOverViewuserNames;
        List usersList;
        int cloudId = cloud.getCloudId();
        List<DeviceBackupOverView> overViewList = new ArrayList();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        List<Object> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            User user2 = this.userDao.getUserInfoByName(cloudId, cloudName, reportQueryElement.getUserName());
            if (!user2.isGuest() && !user2.isSuperAdmin()) {
                users.add(user2);
            }
        } else {
            boolean site = false;
            if ("SHAREPOINT".equalsIgnoreCase(productType)) {
                site = true;
            }
            usersList = this.userDao.getAllUsers(cloudId, cloudName, site);
            for (User user3 : usersList) {
                if (user3.isGuest() || user3.isSuperAdmin()) continue;
                users.add(user3);
            }
        }
        if (SHARE_POINT.equals(productType)) {
            users = users.stream().filter(user -> user.getSpPolicyName() != null && !user.getSpPolicyName().isEmpty()).collect(Collectors.toList());
        } else if (ODB.equals(productType)) {
            users = users.stream().filter(user -> user.getOneDrivePolicyName() != null && !user.getOneDrivePolicyName().isEmpty()).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug(".....only policynames..." + productType);
            overViewList = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty(overViewList)) {
                    bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null || user2.isGuest() || user2.isSuperAdmin()) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(user2);
                        overViewList.add(deviceOver);
                    }
                } else {
                    usersList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceBackupOverView = new DeviceBackupOverView();
                        if (userDetails == null || userDetails.isGuest() || userDetails.isSuperAdmin()) continue;
                        DeviceBackupOverView deviceBackupOverView2 = this.setUserWithoutDeviceElementvalue(userDetails);
                        overViewList.add(deviceBackupOverView2);
                    }
                }
            }
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            logger.debug(".....only username..." + productType);
            overViewList = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(overViewList)) {
                User user3 = (User)users.get(0);
                DeviceBackupOverView deviceOver3 = new DeviceBackupOverView();
                if (user3 != null && !user3.isGuest() && !user3.isSuperAdmin()) {
                    deviceOver3 = this.setUserWithoutDeviceElementvalue(user3);
                    overViewList.add(deviceOver3);
                }
            }
        } else {
            logger.debug(".....all device..." + productType);
            overViewList = this.deviceDao.getAllOverviewsForProductType(cloudId, productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user5 = (User)users.get(i);
                    deviceOver = new DeviceBackupOverView();
                    if (user5 == null || user5.isGuest() || user5.isSuperAdmin()) continue;
                    deviceOver = this.setUserWithoutDeviceElementvalue(user5);
                    overViewList.add(deviceOver);
                }
            }
        }
        ArrayList<DeviceBackupOverView> newOverViewList = new ArrayList<DeviceBackupOverView>();
        for (DeviceBackupOverView bkpOVerview : overViewList) {
            logger.debug(bkpOVerview.getDeviceName() + "...overview details...." + bkpOVerview.getUserName());
            for (User user4 : users) {
                if (user4 == null) continue;
                logger.debug(user4.getUserName() + "... overview details username ...." + bkpOVerview.getUserName() + "..." + productType);
                if (!bkpOVerview.getUserName().equalsIgnoreCase(user4.getUserName())) continue;
                if (productType.equalsIgnoreCase("BACKUP") && (user4.isBackupEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (productType.equalsIgnoreCase("SHAREPOINT") && (user4.isSite() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (productType.equalsIgnoreCase(ODB) && (user4.isOnedriveBkpEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (!productType.equalsIgnoreCase("OUTLOOK") || !user4.isExchangeBkpEnabled() || !user4.isActive()) continue;
                newOverViewList.add(bkpOVerview);
            }
        }
        return newOverViewList;
    }

    @Override
    public boolean createExcelForNoBackup(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType, boolean systemNotProtected) {
        List<BackupHistoryElement> backupHistoryElements = this.getNoBackup(cloud, cloudName, reportQueryElement, productType, systemNotProtected);
        reportQueryElement.setProductType(productType);
        if (CollectionUtils.isEmpty(backupHistoryElements)) {
            return false;
        }
        this.createExcelForNoBabkup(cloud.getCloudId(), backupHistoryElements, reportQueryElement, systemNotProtected);
        return true;
    }

    private void createExcelForNoBabkup(int cloudId, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement, boolean systemNotProtected) {
        if (!backupHistoryElements.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for overview ....");
                List<List> recordToAdd = this.updateValuesToExcelForNoBackup(backupHistoryElements, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                this.writeExcelXlsx(workbook, reportQueryElement, systemNotProtected);
                logger.debug(" After creating excel for overview ....");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private List<List> updateValuesToExcelForNoBackup(List<BackupHistoryElement> bkpOverViewList, ReportQueryElement reportQueryElement) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        int noOfDaysDiff = 0;
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add("User ID");
        if (ODB.equals(reportQueryElement.getProductType())) {
            headerRow.add("Asset Name");
        } else {
            headerRow.add("Device");
        }
        headerRow.add(POLICY_NAME);
        headerRow.add("Last successful backup before");
        if (!ODB.equals(reportQueryElement.getProductType())) {
            headerRow.add(LAST_TIME_HEARD);
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        sb.append(noOfDays + reportQueryElement.getNoOfDays() + "   ");
        if (!ODB.equals(reportQueryElement.getProductType())) {
            sb.append("Include devices heard from :" + this.getBooleanValue(reportQueryElement.isIncludeDevicesHeardFrom()) + "   ");
        }
        if (reportQueryElement.isIncludeDevicesHeardFrom()) {
            sb.append(includeDevicesHeard + reportQueryElement.getDaysToIncludeDevicesHeardFrom());
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getPolicyName());
            logger.debug("...backupHistoryElement.getLastHeardTime().." + backupHistoryElement.getLastHeardTime());
            logger.debug("....noOfDaysDiff..." + noOfDaysDiff + "..backupHistoryElement." + backupHistoryElement.getNoOfDaysNotBackedUp());
            if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfDaysNotBackedUp())) {
                firstRow.add(backupHistoryElement.getNoOfDaysNotBackedUp() + " days");
            } else {
                firstRow.add("-");
            }
            if (!ODB.equals(reportQueryElement.getProductType())) {
                firstRow.add(backupHistoryElement.getLastHeardTime() + " days");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    @Override
    public List<UserMigratedElement> getAllMigratedUsers(int cloudId, int skipValue) {
        List migrationStatusList = this.migrationStatusDao.getAllMigrationStatus(cloudId, skipValue);
        ArrayList<UserMigratedElement> list = new ArrayList<UserMigratedElement>();
        for (MigrationStatus migrationStatus : migrationStatusList) {
            UserMigratedElement userMigratedElement = new UserMigratedElement();
            BeanUtils.copyProperties((Object)migrationStatus, (Object)userMigratedElement);
            userMigratedElement.setCreatedTimestamp(ReportServiceImpl.getDateInFormat(migrationStatus.getMigratededTimestamp(), "dd-MMM-yyyy HH:mm:ss"));
            list.add(userMigratedElement);
        }
        return list;
    }

    @Override
    public long countAllMigratedUsers(int cloudId) {
        return this.migrationStatusDao.countAllMigratedUsers(cloudId);
    }

    @Override
    public List<UserMTBackupElement> getAllUserMTBackupElements(int cloudId, String cloudName) {
        List users = this.userDao.getAllUsers(cloudId, cloudName, false);
        ArrayList<UserMTBackupElement> userMTBackupElementsList = new ArrayList<UserMTBackupElement>();
        for (User user : users) {
            List devices = this.deviceDao.getAllDeviceByUser(cloudId, cloudName, user);
            if (devices != null && !devices.isEmpty()) {
                for (Device device : devices) {
                    BackupBatch backupBatchObj;
                    UserMTBackupElement element = new UserMTBackupElement();
                    String userName = user.getUserName();
                    String deviceCreatedDate = device.getDeviceCreatedDate();
                    String dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    element.setUserName(userName);
                    element.setBkpPolicy(user.getPolicyName());
                    element.setBluSyncCreatedDate(dateStringFormat);
                    BackupBatch backupBatch = this.backupBatchDao.getLastSuccessfullBackup(cloudId, cloudName, userName, device.getDeviceName());
                    if (backupBatch != null) {
                        String lastSuccessfulBkp = ReportServiceImpl.getDateInFormat(backupBatch.getBatchEndTimestamp(), "dd-MMM-yyyy HH:mm:ss");
                        element.setLastSuccessfulBkp(lastSuccessfulBkp);
                    }
                    if ((backupBatchObj = this.backupBatchDao.getFirstBackup(cloudId, cloudName, userName, device.getDeviceName())) != null) {
                        String firstSuccessfulBkp = ReportServiceImpl.getDateInFormat(backupBatchObj.getBatchStartTimestamp(), "dd-MMM-yyyy HH:mm:ss");
                        element.setFirstBkpStartTime(firstSuccessfulBkp);
                    }
                    element.setUserMigratedTime(ReportServiceImpl.getDateInFormat(Long.parseLong(user.getCreatedTimestamp()), "dd-MMM-yyyy HH:mm:ss"));
                    element.setDeviceName(device.getDeviceName());
                    userMTBackupElementsList.add(element);
                }
                continue;
            }
            UserMTBackupElement element = new UserMTBackupElement();
            String userName = user.getUserName();
            if (StringUtils.isEmpty((String)user.getPolicyName())) {
                element.setBkpPolicy("");
            } else {
                element.setBkpPolicy(user.getPolicyName());
            }
            element.setUserName(userName);
            userMTBackupElementsList.add(element);
        }
        return userMTBackupElementsList;
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverviewElements(int cloudId, String cloudName, String userName1, int skipValue) {
        ArrayList<User> users;
        String userName = userName1;
        if (!StringUtils.isEmpty((String)userName)) {
            User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
            users = new ArrayList<User>();
            users.add(user);
        } else {
            users = this.userDao.getAllUsers(cloudId, cloudName, skipValue, false, "false");
        }
        ArrayList<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        Map devicesMap = this.deviceDao.getAllDeviceByUser(cloudId, users);
        for (User user : users) {
            if (user == null) continue;
            List devices = (List)devicesMap.get(user.getUserName());
            if (devices != null && !devices.isEmpty()) {
                for (Device device : devices) {
                    List list;
                    Object[] arr;
                    BackupOverviewElement element = new BackupOverviewElement();
                    userName = user.getUserName();
                    String deviceCreatedDate = device.getDeviceCreatedDate();
                    String dateStringFormat = "";
                    if (deviceCreatedDate != null) {
                        dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    }
                    element.setUserId(userName);
                    element.setPolicyName(user.getPolicyName());
                    element.setEpaInstallationDate(dateStringFormat);
                    element.setEmailId(user.getEmailId());
                    String deviceName = device.getDeviceName();
                    boolean officeProduct = false;
                    if (device.getDeviceName().contains("Microsoft Exchange") || device.getDeviceName().contains("Microsoft OneDrive") || device.getDeviceName().contains("Microsoft SharePoint")) {
                        officeProduct = true;
                    }
                    if ((arr = this.backupBatchDao.getBackupDateHistoryElement(cloudId, cloudName, user, device))[0] != null) {
                        String lastSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[0], "dd-MMM-yyyy HH:mm:ss");
                        element.setLastSuccessfulBkp(lastSuccessfulBkp);
                    }
                    if (arr[1] != null) {
                        String firstSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[1], "dd-MMM-yyyy HH:mm:ss");
                        element.setFirstBkpStartTime(firstSuccessfulBkp);
                    }
                    if (arr[2] != null) {
                        element.setLastBkpStatus(arr[2].toString());
                        element.setReason(this.getCommentsForBackupBatch(arr[3].toString(), officeProduct));
                        element.setLastBkpStartTime(ReportServiceImpl.getDateInFormat((Long)arr[4], "dd-MMM-yyyy HH:mm:ss"));
                    }
                    element.setTotalNoOfFiles(arr[5].toString());
                    element.setNoOfFilesRemaining(arr[6].toString());
                    element.setDeviceName(deviceName);
                    String storageUtilized = "";
                    if (!StringUtils.isEmpty((String)userName) && user != null && !CollectionUtils.isEmpty((Collection)(list = this.deviceDao.getAllOverviews(cloudId, userName)))) {
                        for (DeviceBackupOverView deviceBackupOverView : list) {
                            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceName.equals(deviceBackupOverView.getDeviceName())) continue;
                            Long storageUsed = deviceBackupOverView.getStorageUtilized();
                            storageUtilized = ReportServiceImpl.formatFileSize(storageUsed);
                        }
                    }
                    element.setStorageUtilized(storageUtilized);
                    backupOverviewElementsList.add(element);
                }
                continue;
            }
            BackupOverviewElement element = new BackupOverviewElement();
            userName = user.getUserName();
            if (StringUtils.isEmpty((String)user.getPolicyName())) {
                element.setPolicyName("");
            } else {
                element.setPolicyName(user.getPolicyName());
            }
            element.setUserId(userName);
            element.setEmailId(user.getEmailId());
            backupOverviewElementsList.add(element);
        }
        return backupOverviewElementsList;
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverviewElements(Cloud cloud, int skipValue, boolean loadAll) {
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        List deviceOverviews = this.deviceDao.getAllOverviews(cloud.getCloudId(), skipValue);
        logger.debug(" After getAllDevicesByUser .....");
        logger.debug("...after devpolicymap  details .... ");
        backupOverviewElementsList = this.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, deviceOverviews, true, true, null);
        logger.debug(" After getOverviewElementsForConnDevice ....." + backupOverviewElementsList.size());
        logger.debug(" After getUnAssignedUsers ....." + backupOverviewElementsList.size());
        Long currentmills = System.currentTimeMillis();
        for (BackupOverviewElement element : backupOverviewElementsList) {
            element.setOverviewJobTime(String.valueOf(currentmills));
        }
        Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
        backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
        return backupOverviewElementsList;
    }

    private static String getDateInFormat(Long deviceCreatedDate, String format) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(format);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            logger.error(INVALID_DATE_VALUE + deviceCreatedDate);
            logger.trace(INVALID_DATE_VALUE + e);
            logger.error(INVALID_DATE_VALUE + e.getMessage());
        }
        return dateStringFormat;
    }

    public BackUpImageDao getBackUpImageDao() {
        return this.backUpImageDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public BackupBatchDao getBackupBatchDao() {
        return this.backupBatchDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public UserDao getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public PacksDao getPacksDao() {
        return this.packsDao;
    }

    public void setPacksDao(PacksDao packsDao) {
        this.packsDao = packsDao;
    }

    @Override
    public Long getNoOfRestoresDoneForUser(int cloudId, String cloudName, String startDate, String endDate, User user) {
        Long stDate = new Long(0L);
        Long edDate = new Long(0L);
        return this.backupBatchDao.getNoOfRestoresDoneForUser(cloudId, cloudName, stDate, edDate, user);
    }

    @Override
    public Long getNoOfBackupsDoneForUser(int cloudId, String cloudName, String startDate, String endDate, User user) {
        Long stDate = new Long(0L);
        Long edDate = new Long(0L);
        return this.backupBatchDao.getNoOfBackupsDoneForUser(cloudId, cloudName, stDate, edDate, user);
    }

    private String getCommentsForBackupBatch(String errorCode, boolean officeProduct) {
        String comments = "";
        if (StringUtils.isEmpty((String)errorCode)) {
            return "";
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if ("909".equals(errorCode)) {
            comments = !officeProduct ? "Network disconnected or endpoint was shutdown during the backup" : "Network disconnected during the backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User exited the agent manually or the endpoint was shutdown during the backup";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("1947".equals(errorCode)) {
            comments = "Storage limit exceeded";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = officeProduct ? "Admin paused BackUp manually" : "User paused BackUp manually";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        if ("1210".equals(errorCode)) {
            comments = "Pre backup command failed.";
        }
        if ("1211".equals(errorCode)) {
            comments = "Pre scan command failed.";
        }
        if ("1207".equals(errorCode)) {
            comments = officeProduct ? "Admin stopped BackUp manually" : "User stopped BackUp manually";
        }
        if ("1208".equals(errorCode)) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(errorCode)) {
            comments = "Admin stopped BackUp manually";
        }
        if ("543".equals(errorCode)) {
            comments = "OneDrive target not assigned";
        }
        if ("544".equals(errorCode)) {
            comments = "Invalid Mailbox License";
        }
        if ("913".equals(errorCode)) {
            comments = "User decoupled the agent";
        }
        if ("1212".equals(errorCode)) {
            comments = "Access denied";
        }
        if ("1213".equals(errorCode)) {
            comments = "one or more databases are not set to simple recovery";
        }
        if ("1214".equals(errorCode)) {
            comments = "access denied while connecting database";
        }
        if ("1215".equals(errorCode)) {
            comments = "No Backup is allowed during this time.Please check your policy.";
        }
        if ("1216".equals(errorCode)) {
            comments = "Not connected to the selected Network";
        }
        if ("1310".equals(errorCode)) {
            comments = "Admin stopped queue manually";
        }
        if ("1311".equals(errorCode)) {
            comments = "Admin stopped scanning manually";
        }
        return comments;
    }

    private String getCommentsForRestoreHistory(String errorCode) {
        String comments = "-";
        if (StringUtils.isEmpty((String)errorCode)) {
            return "";
        }
        if ("603".equals(errorCode) || "404".equals(errorCode)) {
            comments = "Failed";
        }
        if ("909".equals(errorCode) || "200".equals(errorCode) || "0".equals(errorCode)) {
            comments = "Completed";
        }
        if ("1207".equals(errorCode) || "429".equals(errorCode)) {
            comments = "cancelled";
        }
        return comments;
    }

    @Override
    public CloudOverviewElement getCloudOverviewElement(Cloud cloud, String cloudName, String productType) {
        CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
        long deviceCount = 0L;
        long totalusers = 0L;
        totalusers = PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.toString().equals(productType) ? this.userDao.countOfPresentServerUsers(cloud.getCloudId(), cloudName, true) : this.userDao.countOfPresentUsers(cloud.getCloudId(), cloudName, true);
        String formatedTotalUsers = this.getFormattedValue(totalusers);
        logger.debug(".....formatedTotalUsers...." + formatedTotalUsers);
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long noOfFullBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        long totalActualSpaceUsed = 0L;
        long currentlyRunningBackupCount = 0L;
        long totalNoOfActiveBackupUsers = 0L;
        long noOfBlockedBackupUsers = 0L;
        long totalNoOfActiveServerUsers = 0L;
        long noOfBlockedServerUsers = 0L;
        totalNoOfActiveServerUsers = this.userDao.countOfPresentBackupServerUsers(cloud.getCloudId(), cloudName, true, true);
        noOfBlockedServerUsers = this.userDao.countOfPresentBackupServerUsers(cloud.getCloudId(), cloudName, false, false);
        totalNoOfActiveBackupUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloudName, true, true);
        noOfBlockedBackupUsers = this.userDao.countOfPresentBackupUsers(cloud.getCloudId(), cloudName, false, false);
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.toString().equals(productType)) {
            totalNoOfActiveBackupUsers -= totalNoOfActiveServerUsers;
            noOfBlockedBackupUsers -= noOfBlockedServerUsers;
        }
        List loadAllDeviceUserIds = this.deviceDao.getAllDevices(cloud.getCloudId());
        long noOfDevicesNotProtected = 0L;
        long noOfTotalBkpOverviews = 0L;
        long activeDevicesWithFullBackupsCompleted = 0L;
        long activeUsersWithFullBackupsCompleted = 0L;
        List<Object> userIds = new ArrayList();
        List<Object> blockedDevicesList = new ArrayList();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.toString().equals(productType)) {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && !dev.isBlocked() && !dev.getDeviceName().contains("Microsoft Exchange") && !dev.getDeviceName().contains("Microsoft OneDrive") && !dev.getDeviceName().contains("Microsoft SharePoint") && !Device.TYPE.BACKUP.toString().equalsIgnoreCase(dev.getDeviceType())).map(dev -> dev.getUserId()).collect(Collectors.toList());
            blockedDevicesList = loadAllDeviceUserIds.stream().filter(dev -> dev.isBlocked() && !dev.getDeviceName().contains("Microsoft Exchange") && !dev.getDeviceName().contains("Microsoft OneDrive") && !dev.getDeviceName().contains("Microsoft SharePoint") && !Device.TYPE.BACKUP.toString().equalsIgnoreCase(dev.getDeviceType())).collect(Collectors.toList());
        } else {
            userIds = loadAllDeviceUserIds.stream().filter(dev -> !dev.isDeleted() && !dev.isBlocked() && !dev.getDeviceName().contains("Microsoft Exchange") && !dev.getDeviceName().contains("Microsoft OneDrive") && !dev.getDeviceName().contains("Microsoft SharePoint") && !Device.TYPE.SERVER.toString().equalsIgnoreCase(dev.getDeviceType())).map(dev -> dev.getUserId()).collect(Collectors.toList());
            blockedDevicesList = loadAllDeviceUserIds.stream().filter(dev -> dev.isBlocked() && !dev.getDeviceName().contains("Microsoft Exchange") && !dev.getDeviceName().contains("Microsoft OneDrive") && !dev.getDeviceName().contains("Microsoft SharePoint") && !Device.TYPE.SERVER.toString().equalsIgnoreCase(dev.getDeviceType())).collect(Collectors.toList());
        }
        long noOfBlockedDevices = blockedDevicesList.size();
        logger.debug("....userIds new....." + userIds.size());
        List usersNotConnectedToDevice = this.userDao.getUsersNotConnectedToDevice(cloud.getCloudId(), userIds, true);
        usersNotConnectedToDevice = PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.toString().equals(productType) ? usersNotConnectedToDevice.stream().filter(serverUserNotProtected -> User.TYPE.SERVER.toString().equalsIgnoreCase(serverUserNotProtected.getUserType())).collect(Collectors.toList()) : usersNotConnectedToDevice.stream().filter(backupUserNotProtected -> StringUtils.isEmpty((String)backupUserNotProtected.getUserType())).collect(Collectors.toList());
        try {
            Object[] arr = this.deviceDao.getCloudOverView(cloud.getCloudId(), false, null, productType);
            totalDiskSpaceUsed = Long.parseLong(String.valueOf(arr[0]));
            noOfBackupsDone = Long.parseLong(String.valueOf(arr[1]));
            noOfRestoresDone = Long.parseLong(String.valueOf(arr[2]));
            deviceCount = Long.parseLong(String.valueOf(arr[3]));
            noOfFullBackupsDone = Long.parseLong(String.valueOf(arr[4]));
            totalActualSpaceUsed = Long.parseLong(String.valueOf(arr[5]));
            currentlyRunningBackupCount = Long.parseLong(String.valueOf(arr[6]));
            long noOfUsersProtected = Long.parseLong(String.valueOf(arr[7]));
            noOfDevicesNotProtected = Long.parseLong(String.valueOf(arr[8]));
            noOfTotalBkpOverviews = Long.parseLong(String.valueOf(arr[9]));
            activeDevicesWithFullBackupsCompleted = Long.parseLong(String.valueOf(arr[10]));
            activeUsersWithFullBackupsCompleted = Long.parseLong(String.valueOf(arr[11]));
            String compressionSizeInPercentage = this.getCompressedSize(totalDiskSpaceUsed, totalActualSpaceUsed);
            cloudOverviewElement.setTotalCompressedSizeInPercentage(compressionSizeInPercentage);
            cloudOverviewElement.setTotalActualStorageUtilized(ReportServiceImpl.formatFileSize(totalActualSpaceUsed));
            cloudOverviewElement.setTotalStorageUtilized(ReportServiceImpl.formatFileSize(totalDiskSpaceUsed));
            cloudOverviewElement.setAvgStoragePerUser(ReportServiceImpl.avgStoragePerUser(totalDiskSpaceUsed, totalusers));
            cloudOverviewElement.setDevicesConnected(this.getFormattedValue(deviceCount));
            if (StringUtils.isEmpty((String)formatedTotalUsers)) {
                cloudOverviewElement.setUsersConnected(formatedTotalUsers);
            } else {
                cloudOverviewElement.setUsersConnected(this.getFormattedValue(totalusers));
            }
            cloudOverviewElement.setRestoresDone(this.getFormattedValue(noOfRestoresDone));
            cloudOverviewElement.setBackupsDone(this.getFormattedValue(noOfBackupsDone));
            cloudOverviewElement.setFullBackupsDone(this.getFormattedValue(noOfFullBackupsDone));
            cloudOverviewElement.setAvgRestorePerUser(String.valueOf(new Double(noOfRestoresDone) / new Double(totalusers)));
            cloudOverviewElement.setActiveBackupUsers(this.getFormattedValue(totalNoOfActiveBackupUsers));
            cloudOverviewElement.setNoOfActiveServerUsers(this.getFormattedValue(totalNoOfActiveServerUsers));
            cloudOverviewElement.setCurrentlyRunningBackupCount(this.getFormattedValue(currentlyRunningBackupCount));
            int userNotConnectedSize = usersNotConnectedToDevice.size();
            long totalActiveUsersWithDevices = totalNoOfActiveBackupUsers - (long)userNotConnectedSize;
            long totalUsersWithDeviceandNotProtected = totalActiveUsersWithDevices - noOfUsersProtected;
            if (totalUsersWithDeviceandNotProtected != 0L && totalActiveUsersWithDevices != 0L) {
                long noOfUsersNotProtectedPercentage = totalUsersWithDeviceandNotProtected * 100L / totalActiveUsersWithDevices;
                cloudOverviewElement.setNoOfUsersProtected(this.getFormattedValue(totalUsersWithDeviceandNotProtected) + "(" + noOfUsersNotProtectedPercentage + "%)");
            } else {
                cloudOverviewElement.setNoOfUsersProtected("0(0%)");
            }
            if (noOfDevicesNotProtected != 0L && noOfTotalBkpOverviews != 0L) {
                long noOfDevicesNotProtectedPercentage = noOfDevicesNotProtected * 100L / noOfTotalBkpOverviews;
                cloudOverviewElement.setNoOfDevicesNotProtected(this.getFormattedValue(noOfDevicesNotProtected) + "(" + noOfDevicesNotProtectedPercentage + "%)");
            } else {
                cloudOverviewElement.setNoOfDevicesNotProtected("0(0%)");
            }
            cloudOverviewElement.setUserWithOutDevices(this.getFormattedValue(userNotConnectedSize));
            logger.debug(".....noOfBlockedBackupUsers........" + noOfBlockedBackupUsers);
            logger.debug(".....noOfBlockedServerUsers........" + noOfBlockedServerUsers);
            cloudOverviewElement.setNoOfBlockedBackupUsers(String.valueOf(noOfBlockedBackupUsers));
            cloudOverviewElement.setNoOfBlockedServerUsers(String.valueOf(noOfBlockedServerUsers));
            logger.debug(".....noOfBlockedDevices........" + noOfBlockedDevices);
            cloudOverviewElement.setNoOfBlockedDevices(String.valueOf(noOfBlockedDevices));
            cloudOverviewElement.setActiveDevicesWithFullBackupsCompleted(String.valueOf(activeDevicesWithFullBackupsCompleted));
            cloudOverviewElement.setActiveUsersWithFullBackupsCompleted(String.valueOf(activeUsersWithFullBackupsCompleted));
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
            long totalActiveAlerts = this.auditHistoryDao.getUnusualActivityCount(cloud.getCloudId(), cloudName, null, null, true, cloudPropertyElement.isOnlyRansomewarepossibilities(), false);
            cloudOverviewElement.setNoOfUnusualDataAlerts(totalActiveAlerts);
            logger.debug("activeDevicesWithFullBackupsCompleted.........." + activeDevicesWithFullBackupsCompleted + "....activeUsersWithFullBackupsCompleted..." + activeUsersWithFullBackupsCompleted);
            logger.debug("..getUserWithOutDevice...." + cloudOverviewElement.getUserWithOutDevices() + "totalActiveAlerts..........." + totalActiveAlerts);
            logger.debug("activeDevicesWithFullBackupsCompleted.........." + activeDevicesWithFullBackupsCompleted + "....activeUsersWithFullBackupsCompleted..." + activeUsersWithFullBackupsCompleted);
            logger.debug("..getUserWithOutDevice...." + cloudOverviewElement.getUserWithOutDevices() + "totalActiveAlerts...........");
            List softBlockUsers = this.userDao.getAllSoftBlockUsers(cloud.getCloudId(), null, 0);
            logger.debug("..softBlockUsers count..." + softBlockUsers.size());
            if (cloudPropertyElement.isSoftBlockEnabled()) {
                cloudOverviewElement.setSoftBlockedUsersCount((long)softBlockUsers.size());
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error("Error failed to load getCloudOverview ...", (Throwable)e);
        }
        return cloudOverviewElement;
    }

    @Override
    public MSPCloudOverviewElement getMspCloudOverviewElement(Cloud cloud, String cloudName, User user, String type) {
        MSPCloudOverviewElement mspCloudOverviewElement = new MSPCloudOverviewElement();
        String policyName = null;
        List backupPoliciesAdmin = new ArrayList();
        long totalNoOfDevices = 0L;
        long totalNoOfServerDevices = 0L;
        if (type == null || type.isEmpty()) {
            type = Device.TYPE.BACKUP.toString();
        }
        try {
            if (user.isActive() && !user.isDelegatedAdmin() && user.isReadOnlyAdmin()) {
                policyName = user.getPolicyName();
                backupPoliciesAdmin = user.getBackupPoliciesAdmin();
                logger.debug("process=setting mspCloudOverviewElement, policyName={}", (Object)policyName);
                if (policyName != null) {
                    List users = this.userDao.getAllUsersByBackupPoliciesAdmin(cloud.getCloudId(), user.getBackupPoliciesAdmin());
                    if (users != null && users.size() > 0) {
                        List backupUsers = users.stream().filter(backupUser -> !User.TYPE.SERVER.toString().equalsIgnoreCase(backupUser.getUserType())).collect(Collectors.toList());
                        List serverUsers = users.stream().filter(serverUser -> User.TYPE.SERVER.toString().equalsIgnoreCase(serverUser.getUserType())).collect(Collectors.toList());
                        logger.debug("process=setting mspCloudOverviewElement, totalNoOfActiveUsers={}, backup users={}, server users={}", (Object)users.size(), (Object)backupUsers.size(), (Object)serverUsers.size());
                        long totalNoOfActiveUsers = backupUsers.size();
                        long totalNoOfActiveServers = serverUsers.size();
                        mspCloudOverviewElement.setTotalNoOfActiveUsers(totalNoOfActiveUsers);
                        mspCloudOverviewElement.setTotalNoOfActiveServerUsers(totalNoOfActiveServers);
                        for (User policyUser : users) {
                            if (policyUser != null && StringUtils.isEmpty((String)policyUser.getUserType())) {
                                totalNoOfDevices += this.deviceDao.getAllDeviceByUserIdAndPolicyName(cloud.getCloudId(), policyUser.getUserId(), type);
                                continue;
                            }
                            if (policyUser == null || !User.TYPE.SERVER.toString().equalsIgnoreCase(policyUser.getUserType())) continue;
                            totalNoOfServerDevices += this.deviceDao.getAllDeviceByUserIdAndPolicyName(cloud.getCloudId(), policyUser.getUserId(), Device.TYPE.SERVER.toString());
                        }
                        logger.debug("process=setting mspCloudOverviewElement, totalNoOfDevices={}, totalNoOfServerDevices={}", (Object)totalNoOfDevices, (Object)totalNoOfServerDevices);
                        mspCloudOverviewElement.setTotalNoOfDevices(totalNoOfDevices);
                        mspCloudOverviewElement.setTotalNoOfServerDevices(totalNoOfServerDevices);
                    }
                    Object[] arr = this.deviceDao.getCloudOverView(cloud.getCloudId(), true, backupPoliciesAdmin, null);
                    long totalDiskSpaceUsed = Long.parseLong(String.valueOf(arr[0]));
                    logger.debug("process=setting mspCloudOverviewElement, totalActualSpaceUsed={}", (Object)totalDiskSpaceUsed);
                    mspCloudOverviewElement.setTotalStorageUtilized(ReportServiceImpl.formatFileSizeForMspDasboardTile(totalDiskSpaceUsed));
                    BackupPolicy backupPolicy = this.backupPolicyDao.getBackupPolicy(cloud.getCloudId(), cloudName, policyName);
                    if (backupPolicy != null) {
                        long totalNoOfUsersAlloted = 0L;
                        long totalNoOfServersAlloted = 0L;
                        long totalStorageAlloted = 0L;
                        List packs = backupPolicy.getPacks();
                        if (packs != null && packs.size() > 0) {
                            for (PackElement pack : packs) {
                                if (!pack.isSubscriptionActive()) continue;
                                totalNoOfUsersAlloted += (long)pack.getMinUserCount();
                                totalStorageAlloted += pack.getStorageSize();
                                List addons = pack.getAddons();
                                if (addons == null || addons.size() <= 0) break;
                                for (PackElement addon : addons) {
                                    if (!addon.isSubscriptionActive()) continue;
                                    totalStorageAlloted += addon.getStorageSize();
                                    if (!addon.getSkuCode().contains(OrderConstants.SERVER_ADDON)) {
                                        totalNoOfUsersAlloted += (long)addon.getMinUserCount();
                                        continue;
                                    }
                                    if (!addon.getSkuCode().contains(OrderConstants.SERVER_ADDON)) continue;
                                    totalNoOfServersAlloted += (long)addon.getMinUserCount();
                                }
                            }
                            logger.debug("process=setting mspCloudOverviewElement, totalNoOfUsersAlloted={}, totalNoOfServersAlloted={}", (Object)totalNoOfUsersAlloted, (Object)totalNoOfServersAlloted);
                            mspCloudOverviewElement.setTotalNoOfUsersAlloted(totalNoOfUsersAlloted);
                            mspCloudOverviewElement.setTotalNoOfServersAlloted(totalNoOfServersAlloted);
                        }
                        logger.debug("process=setting mspCloudOverviewElement, totalStorageAlloted={}", (Object)totalStorageAlloted);
                        mspCloudOverviewElement.setTotalStorageAlloted(ReportServiceImpl.formatFileSizeForMspDasboardTile(totalStorageAlloted * 1000L * 1000L));
                        if (totalStorageAlloted != 0L) {
                            double storageUtilizedPercent = (double)totalDiskSpaceUsed * 100.0 / (double)(totalStorageAlloted * 1024L * 1024L);
                            logger.debug("process=setting mspCloudOverviewElement, storageUtilizedPercent={}%", (Object)storageUtilizedPercent);
                            if (storageUtilizedPercent > 100.0) {
                                storageUtilizedPercent = 100.0;
                            }
                            mspCloudOverviewElement.setTotalStoragePercent(storageUtilizedPercent);
                        }
                        mspCloudOverviewElement.setPacks(packs);
                    }
                }
                return mspCloudOverviewElement;
            }
        }
        catch (Exception e) {
            logger.error("The exception thrown e={}", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    private String getFormattedValue(long totalusers) {
        String formatedTotalUsers = "";
        NumberFormat myFormat = NumberFormat.getInstance();
        myFormat.setGroupingUsed(true);
        formatedTotalUsers = myFormat.format(totalusers);
        return formatedTotalUsers;
    }

    private String getCompressedSize(long totalActualSpaceUsed, long totalDiskSpaceUsed) {
        String compressionSizeInPercentage = "";
        DecimalFormat twoDecimalPoint = new DecimalFormat("0.00");
        try {
            if (totalActualSpaceUsed != 0L) {
                double number = (double)((float)(totalActualSpaceUsed - totalDiskSpaceUsed) / (float)totalActualSpaceUsed) * 100.0;
                if (number < 0.0) {
                    number = 0.0;
                }
                String format = twoDecimalPoint.format(number);
                compressionSizeInPercentage = format + "%";
            } else {
                compressionSizeInPercentage = "0.00%";
            }
        }
        catch (Exception e) {
            logger.debug("Exception:" + e.getMessage());
        }
        return compressionSizeInPercentage;
    }

    @Override
    public CloudOverviewElement getCloudOverviewElementForSize(int cloudId, String cloudName) {
        CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
        try {
            Object[] arr = this.backupBatchDao.getCloudOverviewElementForSize(cloudId, cloudName);
            Long totalusers = (Long)arr[0];
            Long totalDiskSpaceUsed = (Long)arr[1];
            cloudOverviewElement.setUsersConnected(totalusers.toString());
            cloudOverviewElement.setTotalStorageUtilized(ReportServiceImpl.formatFileSize(totalDiskSpaceUsed / 1024L));
            cloudOverviewElement.setAvgStoragePerUser(ReportServiceImpl.avgStoragePerUser(totalDiskSpaceUsed / 1024L, totalusers));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.debug("Error failed to load getCloudOverview ..." + e.getMessage());
        }
        return cloudOverviewElement;
    }

    private static String avgStoragePerUser(long size, Long noOfUsers) {
        double avgSize = (double)size / (double)noOfUsers.longValue();
        double m = avgSize / 1024.0;
        double g = avgSize / 1024.0 / 1024.0;
        double t = avgSize / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @Override
    public void updateBackupOverviewElements(Cloud cloud) {
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        int cloudId = cloud.getCloudId();
        List overViews = this.deviceDao.getAllOverviews(cloudId);
        logger.debug(" After getAllDevicesByUser .....");
        logger.debug(" After getStorageMapForUserDevice .....");
        backupOverviewElementsList = this.getOverviewElementsForConnDevice(cloud, cloud.getCloudName(), backupOverviewElementsList, (List<DeviceBackupOverView>)overViews);
        logger.debug(" After getOverviewElementsForConnDevice .....");
        Long currentmills = System.currentTimeMillis();
        for (BackupOverviewElement element : backupOverviewElementsList) {
            element.setOverviewJobTime(String.valueOf(currentmills));
        }
        Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
        backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
        this.createExcelForXlsx(cloud, backupOverviewElementsList, null, false, null);
    }

    @Override
    public CloudOverviewElement getBackupSummary(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        List<BackupOverviewElement> backupOverviewElementsList = Collections.synchronizedList(new ArrayList());
        CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
        int cloudId = cloud.getCloudId();
        List<Object> deviceOverviews = new ArrayList();
        if (reportQueryElement == null) {
            deviceOverviews = this.deviceDao.getAllBkpOverviews(cloud.getCloudId());
            reportQueryElement = new ReportQueryElement();
            reportQueryElement.setNoOfDays(7);
        } else {
            deviceOverviews = this.getBkpOverviewFromReportQuery(cloud, cloud.getCloudName(), reportQueryElement, productType);
        }
        logger.debug("......reportqueryelement...." + reportQueryElement);
        long totalNoOfActiveBackupUsers = this.userDao.countOfPresentBackupUsersByPolicyByProductType(cloudId, cloud.getCloudName(), true, reportQueryElement.getPolicyNames(), productType);
        List uniqueUserNamesInDevice = new ArrayList();
        uniqueUserNamesInDevice = CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames()) ? this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), productType) : this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
        List userNames = uniqueUserNamesInDevice.stream().map(user -> user.toLowerCase()).collect(Collectors.toList());
        logger.debug(".......uniqueUserNamesInDevice......" + uniqueUserNamesInDevice.size());
        List usersInNames = this.userDao.getUsersCountInNames(cloud.getCloudId(), userNames);
        List usersCountInNames = null;
        if (productType == null || productType.equalsIgnoreCase("BACKUP")) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isBackupEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        } else if (productType.equalsIgnoreCase(ODB)) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isOnedriveBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        } else if (productType.equalsIgnoreCase("Exchange")) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isExchangeBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        } else if (productType.equalsIgnoreCase("SHAREPOINT")) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isSite()).map(user -> user.getUserName()).collect(Collectors.toList());
        }
        long uniqueUserNamesInDeviceCount = usersCountInNames.stream().distinct().count();
        userNames = uniqueUserNamesInDevice.stream().map(user -> user.toLowerCase()).collect(Collectors.toList());
        logger.debug("...before removing blocked device size..." + deviceOverviews.size());
        deviceOverviews = deviceOverviews.stream().filter(overView -> !overView.isDeviceBolcked() && overView.isUserActive()).collect(Collectors.toList());
        logger.debug("...after removing blocked device size..." + deviceOverviews.size());
        backupOverviewElementsList = this.getOverviewElementsForConnDeviceForDPS(cloudId, cloud.getCloudName(), backupOverviewElementsList, deviceOverviews);
        logger.debug("afer getOverviewElementsForConnDevice..." + backupOverviewElementsList.size());
        long usersCountInNotNames = this.userDao.getUsersCountInPolicyNamesByProductType(cloudId, userNames, reportQueryElement.getPolicyNames(), productType);
        logger.debug(backupOverviewElementsList.size() + "...usersCountInNotNames..." + usersCountInNotNames);
        Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
        backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
        AtomicLong noOfUserProtected = new AtomicLong();
        AtomicLong noOfUserHeardCount = new AtomicLong();
        Set usersHeardCountSet = Collections.synchronizedSet(new HashSet());
        Set usersProtectedSet = Collections.synchronizedSet(new HashSet());
        List protectedUsersBackupOverviewElementsList = Collections.synchronizedList(new ArrayList());
        List protectedUsersWithCurrBkpBackupOverviewElementsList = Collections.synchronizedList(new ArrayList());
        HashSet<String> usersSet = new HashSet<String>();
        for (BackupOverviewElement element2 : backupOverviewElementsList) {
            if (usersSet.contains(element2.getUserId())) continue;
            usersSet.add(element2.getUserId());
        }
        long totalOverviews = usersSet.size();
        long noOfUsersOneBackupComplted = this.deviceDao.getCountFullBkpCompletedByProductType(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
        try {
            int noOfDaysToQuery = reportQueryElement.getNoOfDays();
            backupOverviewElementsList.parallelStream().forEach(element -> {
                if (!StringUtils.isEmpty((String)element.getDeviceType()) && (element.getDeviceType().equalsIgnoreCase("ONEDRIVE") || element.getDeviceType().equalsIgnoreCase("SHAREPOINT") || element.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString()))) {
                    usersHeardCountSet.add(element.getUserId());
                }
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                DateTime dt1 = null;
                DateTime dt2 = new DateTime();
                Date yourDate = null;
                if (!StringUtils.isEmpty((String)element.getLastHeardTime())) {
                    try {
                        yourDate = format.parse(element.getLastHeardTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    dt1 = new DateTime((Object)yourDate);
                    dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference < noOfDaysToQuery) {
                        usersHeardCountSet.add(element.getUserId());
                    }
                }
                int lastBkpStartDiff = 999;
                int lastSuccessfulBkpEndDiff = 999;
                int firstBkpEndDiff = 999;
                int lastBkpEndDiff = 999;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    String currentBkpStarted = element.getCurrentBkpStartTime();
                    try {
                        yourDate = ReportServiceImpl.getDateByString(currentBkpStarted);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpStartDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpStartDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastSuccessfulBkp())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastSuccessfulBkp());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastSuccessfulBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastSuccessfulBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getFirstBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getFirstBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        firstBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (lastSuccessfulBkpEndDiff < noOfDaysToQuery) {
                    protectedUsersBackupOverviewElementsList.add(element);
                    usersProtectedSet.add(element.getUserId());
                } else if (lastBkpEndDiff < noOfDaysToQuery && lastBkpStartDiff > noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    protectedUsersWithCurrBkpBackupOverviewElementsList.add(element);
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                } else if (lastBkpStartDiff < noOfDaysToQuery || firstBkpEndDiff < noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    protectedUsersBackupOverviewElementsList.add(element);
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                }
            });
        }
        catch (Exception e) {
            logger.debug("Exception......", (Throwable)e);
            logger.trace(" Exception :" + e);
            logger.error("Exception while getting  msg " + e.getMessage());
        }
        logger.debug("PVNNNN.noOfUsersProtected......" + protectedUsersWithCurrBkpBackupOverviewElementsList.size() + "...noOfUserHeardCount:" + usersHeardCountSet.size());
        noOfUserHeardCount.set(usersHeardCountSet.size());
        noOfUserProtected.set(usersProtectedSet.size());
        long noOfUsersProtectedPercentage = noOfUserProtected.get() <= 0L || noOfUserHeardCount.get() <= 0L ? 0L : noOfUserProtected.get() * 100L / noOfUserHeardCount.get();
        logger.debug("..noofousersprotected...." + noOfUserProtected.get() + "..total.." + totalOverviews);
        if (noOfUsersProtectedPercentage == 0L || noOfUserProtected.get() == 0L) {
            cloudOverviewElement.setNoOfUsersProtected("0(0%)");
        } else {
            cloudOverviewElement.setNoOfUsersProtected(noOfUserProtected.get() + "(" + noOfUsersProtectedPercentage + "%)");
        }
        if (noOfUserHeardCount.get() == 0L || totalOverviews == 0L) {
            cloudOverviewElement.setNoOfUsersHeardCount("0(0%)");
        } else {
            logger.debug("...noOfUsersHeardCount...." + noOfUserHeardCount.get() + "...totalOverviews.." + totalOverviews + "......." + noOfUserHeardCount.get() * 100L / totalOverviews);
            long noOfUsersHeardCountPercentage = noOfUserHeardCount.get() * 100L / totalOverviews;
            logger.debug("...noOfUsersHeardCountPercentage..." + noOfUsersHeardCountPercentage);
            cloudOverviewElement.setNoOfUsersHeardCount(noOfUserHeardCount.get() + "(" + noOfUsersHeardCountPercentage + "%)");
        }
        cloudOverviewElement.setActiveBackupUsers(this.getFormattedValue(totalNoOfActiveBackupUsers));
        cloudOverviewElement.setUserWithOutDevices(this.getFormattedValue(usersCountInNotNames));
        cloudOverviewElement.setUserWithDevices(this.getFormattedValue(uniqueUserNamesInDeviceCount));
        cloudOverviewElement.setUserWithFirstBkpCompleted(this.getFormattedValue(noOfUsersOneBackupComplted));
        cloudOverviewElement.setProtectedUsersBackupOverviewElementsList(protectedUsersBackupOverviewElementsList);
        cloudOverviewElement.setProtectedUsersWithCurrBkpBackupOverviewElementsList(protectedUsersWithCurrBkpBackupOverviewElementsList);
        return cloudOverviewElement;
    }

    @Override
    public boolean createExcelBackupSummary(Cloud cloud, int noOfDays, String productType) {
        ReportQueryElement element = new ReportQueryElement();
        element.setNoOfDays(noOfDays);
        CloudOverviewElement cloudOverviewElement = this.getBackupSummary(cloud, element, productType);
        this.createExcelOfBackupSummary(cloud, cloudOverviewElement, element, productType);
        return true;
    }

    private static Date getDateByString(String currentBkpStarted) throws ParseException {
        if (StringUtils.isEmpty((String)currentBkpStarted) || currentBkpStarted.equalsIgnoreCase("-")) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date yourDate = format.parse(currentBkpStarted);
        yourDate.setHours(0);
        yourDate.setMinutes(0);
        return yourDate;
    }

    @Override
    public boolean createExcelForBackupOverview(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        List<DeviceBackupOverView> deviceOverviews = this.getBkpOverviewFromReportQuery(cloud, cloud.getCloudName(), reportQueryElement, productType);
        if (CollectionUtils.isEmpty(deviceOverviews)) {
            return false;
        }
        logger.debug("@@EXCEL Create elements for excel for users who has done backup ...." + deviceOverviews.size());
        backupOverviewElementsList = this.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, deviceOverviews, reportQueryElement.isShowBlockedUsers(), reportQueryElement.isShowBlockedDevices(), productType);
        logger.debug("@@EXCEL After Create elements for excel for users who has done backup ...." + backupOverviewElementsList.size());
        Long currentmills = System.currentTimeMillis();
        for (BackupOverviewElement element : backupOverviewElementsList) {
            element.setOverviewJobTime(String.valueOf(currentmills));
        }
        Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
        backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
        boolean officeProduct = false;
        if (!StringUtils.isEmpty((String)productType) && "office".equalsIgnoreCase(productType)) {
            officeProduct = true;
        }
        this.createExcelForXlsx(cloud, backupOverviewElementsList, reportQueryElement, officeProduct, productType);
        return true;
    }

    @Override
    public boolean createExcelForProductOverview(Cloud cloud, ReportQueryElement reportQueryElement, productOverviewElement productOverviewElement2) {
        if (productOverviewElement2 != null) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for overview ...");
                List<List> recordToAdd = this.updateValuesToProductOverviewExcel(cloud, productOverviewElement2, System.currentTimeMillis());
                this.createExcelForProductOverviewXlsx(recordToAdd, workbook);
                List<List> recordToAdd1 = this.updateValuesToProductOverviewExcel1(cloud, productOverviewElement2, System.currentTimeMillis());
                this.createExcelForProductOverviewXlsx1(recordToAdd1, workbook, "Policy Statistics");
                List<List> recordToAdd2 = this.updateValuesToProductOverviewExcel2(cloud, productOverviewElement2, System.currentTimeMillis());
                this.createExcelForProductOverviewXlsx1(recordToAdd2, workbook, "Backup Overview");
                List<List> recordToAdd3 = this.updateValuesToExcelforFailedHistoryInProductOverview(productOverviewElement2.getNotificationElementList());
                this.createExcelForProductOverviewXlsx1(recordToAdd3, workbook, "Failed Backup History");
                List<List> recordToAdd4 = this.updateValuesToExcelforBackupHistoryInProductOverview(productOverviewElement2.getBackupHistoryElements());
                this.createExcelForProductOverviewXlsx1(recordToAdd4, workbook, "Last Backup Status");
                List<List> recordToAdd5 = this.updateValuesToExcelforRestoreHistoryInProductOverview(productOverviewElement2.getRestoreHistoryElements());
                this.createExcelForProductOverviewXlsx1(recordToAdd5, workbook, "Restore Activity");
                List<List> recordToAdd6 = this.updateValuesToExcelforBlockedUsersInProductOverview(productOverviewElement2.getAllBlockedUsers());
                this.createExcelForProductOverviewXlsx1(recordToAdd6, workbook, "Blocked Users");
                List<List> recordToAdd7 = this.updateValuesToExcelforAdministratorDetailsInProductOverview(productOverviewElement2.getAllAdmins());
                this.createExcelForProductOverviewXlsx1(recordToAdd7, workbook, "Administrator Details");
                List<List> recordToAdd8 = this.updateValuesToExcelforBlockedDevicesInProductOverview(productOverviewElement2.getAllBlockedDevices());
                this.createExcelForProductOverviewXlsx1(recordToAdd8, workbook, "Blocked Assets");
                List<List> recordToAdd9 = this.updateValuesToExcelforPolicyMapInProductOverview(productOverviewElement2.getUserPolicyMappingElementList());
                this.createExcelForProductOverviewXlsx1(recordToAdd9, workbook, "Policy Mapping");
                this.writeExcelForXlsxForProductOverview(workbook, reportQueryElement);
                logger.debug(" After creating excel for overview ...");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
        return false;
    }

    private List<List> updateValuesToExcelforBlockedDevicesInProductOverview(List<DeviceElement> allBlockedDevices) {
        logger.debug("inside the Report for blocked details details .......");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_ID);
        headerRow.add("Asset Name");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Blocked Assets");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(allBlockedDevices, new Comparator<DeviceElement>(){

            @Override
            public int compare(DeviceElement u1, DeviceElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (DeviceElement userElement : allBlockedDevices) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(userElement.getUserName());
            firstRow.add(userElement.getDeviceName());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforAdministratorDetailsInProductOverview(List<UserElement> allAdmins) {
        logger.debug("inside the Report for admin details .......");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_ID);
        headerRow.add(DISPLAY_NAME);
        headerRow.add("User Role");
        headerRow.add(EMAIL_ID);
        headerRow.add("Last Logged In Date");
        headerRow.add("Last Logged In Time");
        headerRow.add("Policies Managed");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Administrator Details");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(allAdmins, new Comparator<UserElement>(){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (UserElement userElement : allAdmins) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(userElement.getUserName());
            if (StringUtils.isNotEmpty((String)userElement.getDisplayName())) {
                firstRow.add(userElement.getDisplayName());
            } else {
                firstRow.add("-");
            }
            if (userElement.isAdmin()) {
                firstRow.add("Administrator");
            } else if (userElement.isDelegatedAdmin() && userElement.isReadOnlyAdmin()) {
                firstRow.add("Read Only Administrator");
            } else {
                firstRow.add("Delegated Administrator");
            }
            firstRow.add(userElement.getEmailId());
            if (StringUtils.isNotEmpty((String)userElement.getLastLoggedInTime())) {
                firstRow.add(ReportServiceImpl.getDateInFormat(Long.parseLong(userElement.getLastLoggedInTime()), "dd-MMM-yyyy"));
                firstRow.add(ReportServiceImpl.getDateInFormat(Long.parseLong(userElement.getLastLoggedInTime()), HH_MM_SS));
            } else {
                firstRow.add("-");
            }
            if (userElement.isAdmin()) {
                firstRow.add("All");
            } else {
                ArrayList policiesList = new ArrayList();
                if (userElement.getBackupPoliciesAdminList().getBackupPoliciesAdmin() != null && !CollectionUtils.isEmpty((Collection)userElement.getBackupPoliciesAdminList().getBackupPoliciesAdmin())) {
                    policiesList.addAll(userElement.getBackupPoliciesAdminList().getBackupPoliciesAdmin());
                }
                if (userElement.getSyncPoliciesAdminList().getSyncPoliciesAdmin() != null && CollectionUtils.isEmpty((Collection)userElement.getSyncPoliciesAdminList().getSyncPoliciesAdmin())) {
                    policiesList.addAll(userElement.getSyncPoliciesAdminList().getSyncPoliciesAdmin());
                }
                if (userElement.getOdbPoliciesAdminList().getOdbPoliciesAdminForUser() != null && CollectionUtils.isEmpty((Collection)userElement.getSyncPoliciesAdminList().getSyncPoliciesAdmin())) {
                    policiesList.addAll(userElement.getOdbPoliciesAdminList().getOdbPoliciesAdminForUser());
                }
                if (userElement.getSpPoliciesAdminList().getSpPoliciesAdmin() != null && CollectionUtils.isEmpty((Collection)userElement.getSpPoliciesAdminList().getSpPoliciesAdmin())) {
                    policiesList.addAll(userElement.getSpPoliciesAdminList().getSpPoliciesAdmin());
                }
                String policies = String.join((CharSequence)", ", policiesList);
                firstRow.add(policies);
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforRestoreHistoryInProductOverview(List<RestoreHistoryElement> restoreHistoryElements) {
        logger.debug("inside the Report for RestoreHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_NAME);
        headerRow.add("Asset Name");
        headerRow.add("Restore By");
        headerRow.add("Restore To");
        headerRow.add("Restore Start Time");
        headerRow.add("Restore End Time");
        headerRow.add(FILES_RESTORED);
        headerRow.add("Restored Size");
        headerRow.add("Status");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + currentDate);
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(restoreHistoryElements, new Comparator<RestoreHistoryElement>(){

            @Override
            public int compare(RestoreHistoryElement u1, RestoreHistoryElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (RestoreHistoryElement backupHistoryElement : restoreHistoryElements) {
            String folderPath;
            ArrayList<String> firstRow = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)backupHistoryElement.getUserName())) {
                firstRow.add(backupHistoryElement.getUserName());
            } else {
                firstRow.add("-");
            }
            boolean officeProduct = false;
            if (!StringUtils.isEmpty((String)backupHistoryElement.getDeviceName())) {
                if (backupHistoryElement.getDeviceName().contains("Microsoft Exchange") || backupHistoryElement.getDeviceName().contains("Microsoft OneDrive") || backupHistoryElement.getDeviceName().contains("Microsoft SharePoint")) {
                    officeProduct = true;
                }
                folderPath = backupHistoryElement.getDeviceName();
                if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreFolder())) {
                    folderPath = folderPath + " - " + backupHistoryElement.getRestoreFolder();
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreByUserName())) {
                firstRow.add(backupHistoryElement.getRestoreByUserName());
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupHistoryElement.getRestoreByDeviceName())) {
                folderPath = backupHistoryElement.getRestoreByDeviceName();
                if (!StringUtils.isEmpty((String)backupHistoryElement.getDestFolder())) {
                    folderPath = folderPath + " - " + backupHistoryElement.getDestFolder();
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            firstRow.add(backupHistoryElement.getRestoreTime());
            firstRow.add(backupHistoryElement.getRestoreEndTime());
            firstRow.add(backupHistoryElement.getRestoredFiles());
            if (officeProduct) {
                firstRow.add("NA");
            } else if (backupHistoryElement.getRestoredSizeInKB() != 0L) {
                firstRow.add(ReportServiceImpl.formatFileSizeIncludeKB(backupHistoryElement.getRestoredSizeInKB()));
            } else {
                firstRow.add("-");
            }
            String status = backupHistoryElement.getStatus();
            firstRow.add(status);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<BackupOverviewElement> getOverviewElementsForConnDevice(Cloud cloud, String cloudName, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews) {
        String userName = "";
        if (!CollectionUtils.isEmpty(overViews)) {
            for (DeviceBackupOverView deviceBackupOverView : overViews) {
                if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceBackupOverView.isUserActive()) continue;
                try {
                    BackupOverviewElement element = new BackupOverviewElement();
                    userName = deviceBackupOverView.getUserName();
                    String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                    String dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    element.setUserId(userName);
                    element.setPolicyName(deviceBackupOverView.getPolicyName());
                    element.setEpaInstallationDate(dateStringFormat);
                    element.setEmailId(deviceBackupOverView.getEmailId());
                    String deviceName = deviceBackupOverView.getDeviceName();
                    User user = this.userDao.getUserInfoByName(cloud.getCloudId(), deviceBackupOverView.getUserName());
                    Object[] arr = this.backupBatchDao.getBackupDateHistoryElement(cloud.getCloudId(), cloudName, user.getUserName(), deviceBackupOverView.getDeviceUUID());
                    boolean officeProduct = false;
                    if (deviceBackupOverView.getDeviceName().contains("Microsoft Exchange") || deviceBackupOverView.getDeviceName().contains("Microsoft OneDrive") || deviceBackupOverView.getDeviceName().contains("Microsoft SharePoint")) {
                        officeProduct = true;
                    }
                    if (arr[0] != null) {
                        String lastSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[0], "dd-MMM-yyyy HH:mm:ss");
                        element.setLastSuccessfulBkp(lastSuccessfulBkp);
                    }
                    if (arr[1] != null) {
                        String firstSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[1], "dd-MMM-yyyy HH:mm:ss");
                        element.setFirstBkpStartTime(firstSuccessfulBkp);
                    }
                    if (arr[2] != null) {
                        element.setLastBkpStatus(arr[2].toString());
                        element.setReason(this.getCommentsForBackupBatch(arr[3].toString(), officeProduct));
                        element.setLastBkpStartTime(ReportServiceImpl.getDateInFormat((Long)arr[4], "dd-MMM-yyyy HH:mm:ss"));
                    }
                    if (user != null && ReportServiceImpl.isODBEnabled(cloud.getCloudCustomisableDetails())) {
                        element.setBackupTargetAssigned(user.isBackupTargetAssigned());
                        element.setBackupTargetErrorCode(user.getBackupTargetErrorCode());
                    }
                    element.setTotalNoOfFiles(arr[5].toString());
                    element.setNoOfFilesRemaining(arr[6].toString());
                    element.setDeviceName(deviceName);
                    element.setClientVersion(deviceBackupOverView.getClientVersion());
                    String storageUtilized = ReportServiceImpl.formatFileSize(deviceBackupOverView.getStorageUtilized());
                    element.setStorageUtilized(storageUtilized);
                    element.setUserActive(deviceBackupOverView.isUserActive());
                    element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                    backupOverviewElementsList.add(element);
                }
                catch (Exception e) {
                    logger.trace(" Exception :" + e);
                    logger.error(ERROR_TRYING_TO_ADD_USER + userName + MSG + e.getMessage());
                }
            }
        }
        return backupOverviewElementsList;
    }

    private List<BackupOverviewElement> getOverviewElementsForConnDevice(int cloudId, String cloudName, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews) {
        String userName = "";
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "25");
        if (!CollectionUtils.isEmpty(overViews)) {
            overViews.parallelStream().forEach(deviceBackupOverView -> {
                if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceBackupOverView.isUserActive()) {
                    return;
                }
                try {
                    boolean isFirstBkpCompleted;
                    Object[] arr;
                    BackupOverviewElement element = new BackupOverviewElement();
                    BeanUtils.copyProperties((Object)deviceBackupOverView, (Object)element);
                    String userName1 = deviceBackupOverView.getUserName();
                    String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                    String dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    element.setUserId(userName1);
                    element.setPolicyName(deviceBackupOverView.getPolicyName());
                    element.setEpaInstallationDate(dateStringFormat);
                    element.setEmailId(deviceBackupOverView.getEmailId());
                    String deviceName = deviceBackupOverView.getDeviceName();
                    boolean officeProduct = false;
                    if (deviceBackupOverView.getDeviceName().contains("Microsoft Exchange") || deviceBackupOverView.getDeviceName().contains("Microsoft OneDrive") || deviceBackupOverView.getDeviceName().contains("Microsoft SharePoint")) {
                        officeProduct = true;
                    }
                    if ((arr = this.backupBatchDao.getBackupDateHistoryElement(cloudId, cloudName, deviceBackupOverView.getUserName(), deviceBackupOverView.getDeviceUUID()))[0] != null) {
                        String lastSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[0], "dd-MMM-yyyy HH:mm:ss");
                        element.setLastSuccessfulBkp(lastSuccessfulBkp);
                    }
                    if (arr[1] != null) {
                        String firstSuccessfulBkp = ReportServiceImpl.getDateInFormat((Long)arr[1], "dd-MMM-yyyy HH:mm:ss");
                        element.setFirstBkpStartTime(firstSuccessfulBkp);
                    }
                    if (arr[2] != null) {
                        element.setLastBkpStatus(arr[2].toString());
                    }
                    if (arr[3] != null) {
                        element.setReason(this.getCommentsForBackupBatch(arr[3].toString(), officeProduct));
                    }
                    if (arr[4] != null) {
                        element.setLastBkpStartTime(ReportServiceImpl.getDateInFormat((Long)arr[4], "dd-MMM-yyyy HH:mm:ss"));
                    }
                    boolean bl = isFirstBkpCompleted = !StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) || deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L;
                    if (arr[5] != null) {
                        element.setTotalNoOfFiles(arr[5].toString());
                    }
                    if (arr[6] != null) {
                        element.setNoOfFilesRemaining(arr[6].toString());
                    }
                    element.setDeviceName(deviceName);
                    element.setClientVersion(deviceBackupOverView.getClientVersion());
                    String storageUtilized = ReportServiceImpl.formatFileSize(deviceBackupOverView.getStorageUtilized());
                    element.setStorageUtilized(storageUtilized);
                    element.setUserActive(deviceBackupOverView.isUserActive());
                    element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                    element.setFirstBackupCompleted(isFirstBkpCompleted);
                    if (deviceBackupOverView.getLastHeardTime() != 0L) {
                        element.setLastHeardTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastHeardTime(), "dd-MMM-yyyy HH:mm:ss"));
                    }
                    element.setCurrentBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                    logger.debug("..isFirstBkpCompleted.." + element.getLastHeardTime());
                    element.setUserId(deviceBackupOverView.getUserName());
                    backupOverviewElementsList.add(element);
                }
                catch (Exception e) {
                    logger.trace(" Exception :" + e, (Throwable)e);
                    logger.error(ERROR_TRYING_TO_ADD_USER + userName + MSG + e.getMessage());
                }
            });
        }
        return backupOverviewElementsList;
    }

    private List<BackupOverviewElement> getOverviewElementsForConnDeviceForDPS(int cloudId, String cloudName, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews) {
        String userName = "";
        if (!CollectionUtils.isEmpty(overViews)) {
            overViews.parallelStream().forEach(deviceBackupOverView -> {
                if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceBackupOverView.isUserActive()) {
                    return;
                }
                try {
                    BackupOverviewElement element = new BackupOverviewElement();
                    BeanUtils.copyProperties((Object)deviceBackupOverView, (Object)element);
                    String userName1 = deviceBackupOverView.getUserName();
                    String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                    String dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    element.setUserId(userName1);
                    element.setPolicyName(deviceBackupOverView.getPolicyName());
                    element.setEpaInstallationDate(dateStringFormat);
                    element.setEmailId(deviceBackupOverView.getEmailId());
                    String deviceName = deviceBackupOverView.getDeviceName();
                    User user = this.userDao.getUserInfoByName(cloudId, deviceBackupOverView.getUserName());
                    if (user == null) {
                        return;
                    }
                    element.setLastSuccessfulBkp(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), "dd-MMM-yyyy HH:mm:ss"));
                    element.setLastSuccessfulBackupEndTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), "dd-MMM-yyyy HH:mm:ss"));
                    element.setLastSuccessfulBackupStartTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupStartTime(), "dd-MMM-yyyy HH:mm:ss"));
                    element.setFirstBkpStartTime(deviceBackupOverView.getFirstBkpStartTime());
                    element.setLastBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                    boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) || deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L;
                    element.setDeviceName(deviceName);
                    element.setClientVersion(deviceBackupOverView.getClientVersion());
                    String storageUtilized = ReportServiceImpl.formatFileSize(deviceBackupOverView.getStorageUtilized());
                    element.setStorageUtilized(storageUtilized);
                    element.setUserActive(deviceBackupOverView.isUserActive());
                    element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                    element.setFirstBackupCompleted(isFirstBkpCompleted);
                    if (deviceBackupOverView.getLastHeardTime() != 0L) {
                        element.setLastHeardTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastHeardTime(), "dd-MMM-yyyy HH:mm:ss"));
                    }
                    element.setCurrentBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                    element.setUserId(deviceBackupOverView.getUserName());
                    if (deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles() > 0L) {
                        element.setCurrentlyRunningBkpTotalSizeOfFiles(ReportServiceImpl.formatFileSizeIncludeKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles()));
                    } else {
                        element.setCurrentlyRunningBkpTotalSizeOfFiles("0 MB");
                    }
                    backupOverviewElementsList.add(element);
                }
                catch (Exception e) {
                    logger.trace(" Exception :" + e, (Throwable)e);
                    logger.error(" Error trying to add user  msg " + e.getMessage());
                }
            });
        }
        return backupOverviewElementsList;
    }

    private static boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private List<BackupOverviewElement> getOverviewElementsForExistingUsers(Cloud cloud, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews, boolean showBlockedUsers, boolean showBlockedDevices, String productType) {
        logger.debug("...showBlockedDevices.." + showBlockedDevices + "...showBlockedUsers..." + showBlockedUsers);
        overViews = this.filterOverviews(overViews, showBlockedUsers, showBlockedDevices);
        boolean odbEnabled = ReportServiceImpl.isODBEnabled(cloud.getCloudCustomisableDetails());
        List allUsers = this.userDao.getAllUsers(cloud.getCloudId());
        boolean officeProduct = false;
        if (!StringUtils.isEmpty((String)productType) && "office".equalsIgnoreCase(productType)) {
            officeProduct = true;
        }
        Map userMap = allUsers.stream().collect(Collectors.toMap(User::getUserName, Function.identity(), (u1, u2) -> u1));
        List<BackupPolicy> backupPolicies = this.getAllBackupPolicies(1);
        List policyWithConsentEnabled = backupPolicies.stream().filter(policy -> policy.isUserConsentEnabled()).map(policyNameM -> policyNameM.getPolicyName()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(overViews)) {
            for (DeviceBackupOverView deviceBackupOverView : overViews) {
                try {
                    BackupOverviewElement element = new BackupOverviewElement();
                    element.setDecoupled(deviceBackupOverView.isDecoupled());
                    element.setUserId(deviceBackupOverView.getUserName());
                    element.setPolicyName(deviceBackupOverView.getPolicyName());
                    element.setAccountStatus(deviceBackupOverView.isAccountStatus());
                    element.setLocation(deviceBackupOverView.getLocation());
                    element.setDepartment(deviceBackupOverView.getDepartment());
                    element.setDisplayName(deviceBackupOverView.getDisplayName());
                    if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpStatus()) && deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase(COMPLETED)) {
                        element.setLastBackupCompleted(true);
                    } else {
                        element.setLastBackupCompleted(false);
                    }
                    element.setEmailId(deviceBackupOverView.getEmailId());
                    element.setUserActive(deviceBackupOverView.isUserActive());
                    element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                    String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                    String dateStringFormat = "";
                    if (!StringUtils.isEmpty((String)deviceCreatedDate)) {
                        dateStringFormat = ReportServiceImpl.getDateInFormat(this.getLongValue(deviceCreatedDate), "dd-MMM-yyyy HH:mm:ss");
                    }
                    element.setEpaInstallationDate(dateStringFormat);
                    String deviceName = deviceBackupOverView.getDeviceName();
                    element.setDeviceName(deviceName);
                    element.setClientVersion(deviceBackupOverView.getClientVersion());
                    User user = (User)userMap.get(deviceBackupOverView.getUserName());
                    if (odbEnabled && user != null) {
                        element.setBackupTargetAssigned(user.isBackupTargetAssigned());
                        element.setBackupTargetErrorCode(user.getBackupTargetErrorCode());
                    }
                    if (user.getPolicyName() != null && policyWithConsentEnabled.contains(user.getPolicyName())) {
                        element.setConsentGiven(user.getConsentGiven());
                        String dateConsentGiven = "";
                        if (user.getConsentGivenTime() != 0L) {
                            dateConsentGiven = ReportServiceImpl.getDateInFormat(this.getLongValue(String.valueOf(user.getConsentGivenTime())), "dd-MMM-yyyy HH:mm:ss");
                        }
                        element.setConsentGivenTime(dateConsentGiven);
                    } else {
                        element.setConsentGiven("");
                        element.setConsentGivenTime("");
                    }
                    element.setLastSuccessfulBkp(deviceBackupOverView.getLastSuccessfulBkp());
                    element.setFirstBkpStartTime(deviceBackupOverView.getFirstBkpStartTime());
                    element.setLastBkpStatus(deviceBackupOverView.getLastBkpStatus());
                    if (deviceBackupOverView.getDeviceName().contains("Microsoft Exchange") || deviceBackupOverView.getDeviceName().contains("Microsoft OneDrive") || deviceBackupOverView.getDeviceName().contains("Microsoft SharePoint")) {
                        officeProduct = true;
                    }
                    if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpStatus()) && (deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase(STATUS_STARTED) || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase(STATUS_SANNING) || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase(PRESCAN_COMMAND_EXECUTION))) {
                        element.setReason("-");
                    } else {
                        element.setReason(this.getCommentsForBackupBatch(deviceBackupOverView.getReason(), officeProduct));
                    }
                    element.setLastBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                    element.setLastBkpEndTime(deviceBackupOverView.getLastBkpEndTime());
                    if (StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpEndTime())) {
                        if (deviceBackupOverView.getLastSuccessfulBackupEndTime() > 0L) {
                            element.setLastBkpEndTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), "dd-MMM-yyyy HH:mm:ss"));
                        } else if (StringUtils.isNotEmpty((String)deviceBackupOverView.getLastBkpStartTime())) {
                            element.setLastBkpEndTime(deviceBackupOverView.getLastBkpStartTime());
                        }
                    }
                    element.setTotalNoOfFiles(deviceBackupOverView.getTotalNoOfFiles());
                    element.setNoOfFilesRemaining(deviceBackupOverView.getNoOfFilesRemaining());
                    element.setStorageUtilized(ReportServiceImpl.formatFileSize(deviceBackupOverView.getStorageUtilized()));
                    element.setStorageUtilizedInKB(deviceBackupOverView.getStorageUtilized());
                    element.setFirstBkpEndTime(deviceBackupOverView.getFirstBkpEndTime());
                    if (deviceBackupOverView.getLastSuccessfulBackupEndTime() > 0L) {
                        element.setLastSuccessfulBackupEndTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), "dd-MMM-yyyy HH:mm:ss"));
                        element.setLastSuccessfulBackupEndTimeInMillis(deviceBackupOverView.getLastSuccessfulBackupEndTime());
                    } else {
                        element.setLastSuccessfulBackupEndTime("");
                    }
                    if (deviceBackupOverView.getLastSuccessfulBackupStartTime() > 0L) {
                        element.setLastSuccessfulBackupStartTime(ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupStartTime(), "dd-MMM-yyyy HH:mm:ss"));
                        element.setLastSuccessfulBackupStartTimeInMillis(deviceBackupOverView.getLastSuccessfulBackupStartTime());
                    } else {
                        element.setLastSuccessfulBackupStartTime("");
                    }
                    Long devAccessTime = deviceBackupOverView.getLastHeardTime();
                    if (devAccessTime != null && devAccessTime > 0L) {
                        element.setLastAccessedTime(devAccessTime.longValue());
                    } else if (StringUtils.isNotEmpty((String)deviceBackupOverView.getEpaInstallationDate())) {
                        element.setLastAccessedTime(Long.parseLong(deviceBackupOverView.getEpaInstallationDate()));
                    } else {
                        element.setLastAccessedTime(0L);
                    }
                    element.setFirstFullBkpNoOfFiles(deviceBackupOverView.getFirstFullBkpNoOfFiles());
                    element.setFirstFullBkpTotalSizeOfFiles(ReportServiceImpl.formatFileSizeIncludeKB(deviceBackupOverView.getFirstFullBkpTotalSizeOfFiles()));
                    element.setFirstFullBkpTotalSizeOfFilesInKB(deviceBackupOverView.getFirstFullBkpTotalSizeOfFiles());
                    element.setLastSucessfulBkpNoOfFiles(deviceBackupOverView.getLastSucessfulBkpNoOfFiles());
                    element.setLastSucessfulBkpTotalSizeOfFiles(ReportServiceImpl.formatFileSizeIncludeKB(deviceBackupOverView.getLastSucessfulBkpTotalSizeOfFiles()));
                    element.setLastSucessfulBkpTotalSizeOfFilesInKB(deviceBackupOverView.getLastSucessfulBkpTotalSizeOfFiles());
                    element.setCurrentlyRunningBkpNoOfFiles(deviceBackupOverView.getCurrentlyRunningBkpNoOfFiles());
                    element.setCurrentlyRunningBkpTotalSizeOfFiles(ReportServiceImpl.formatFileSizeIncludeKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles()));
                    if (deviceBackupOverView.getTotalSizeToUpload() != 0L && StringUtils.isNotEmpty((String)(deviceBackupOverView.getTotalSizeToUpload() + "")) && !deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase(COMPLETED)) {
                        element.setTotalSizeToUpload(ReportServiceImpl.formatFileSizeIncludeKB(deviceBackupOverView.getTotalSizeToUpload()));
                        element.setTotalSizeToUploadInKB(deviceBackupOverView.getTotalSizeToUpload());
                        element.setCurrentlyRunningBkpTotalSizeOfFilesInKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles());
                        element.setTotalCurrentlyRunningBkpSizeInPer(this.setCurrentlyRunningBkpSizeInPercentage(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles(), deviceBackupOverView.getTotalSizeToUpload()));
                    } else {
                        element.setTotalSizeToUpload("");
                        element.setTotalCurrentlyRunningBkpSizeInPer("");
                    }
                    if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                        element.setOneDrivePolicyName(user.getOneDrivePolicyName());
                    } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) {
                        element.setOneDrivePolicyName(user.getExchangePolicyName());
                    } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                        element.setOneDrivePolicyName(user.getSpPolicyName());
                    }
                    if (StringUtils.isNotEmpty((String)deviceBackupOverView.getOsType())) {
                        element.setOsType(deviceBackupOverView.getOsType());
                    }
                    if (StringUtils.isNotEmpty((String)deviceBackupOverView.getOsVersion())) {
                        element.setOsVersion(deviceBackupOverView.getOsVersion());
                    }
                    logger.debug(element.getDeviceName() + "...policcc...." + element.getOneDrivePolicyName());
                    backupOverviewElementsList.add(element);
                }
                catch (Exception e) {
                    logger.trace(EXCEPTION + e);
                    logger.error(" Error trying to add device " + deviceBackupOverView.getDeviceName() + MSG + e.getMessage());
                }
            }
        }
        return backupOverviewElementsList;
    }

    private List<DeviceBackupOverView> filterOverviews(List<DeviceBackupOverView> overViews, boolean showBlockedUsers, boolean showBlockedDevices) {
        overViews = overViews.stream().filter(line -> line != null && !line.isUserDeleted() && !line.isDeviceDeleted()).collect(Collectors.toList());
        List blockedUsers = overViews.stream().filter(line -> !line.isUserActive()).collect(Collectors.toList());
        List blockedDevices = overViews.stream().filter(line -> line.isDeviceBolcked()).collect(Collectors.toList());
        overViews.removeAll(blockedDevices);
        overViews.removeAll(blockedUsers);
        if (showBlockedDevices) {
            overViews.addAll(blockedDevices);
        }
        if (showBlockedUsers) {
            for (DeviceBackupOverView overView : blockedUsers) {
                if (overViews.contains(overView)) continue;
                overViews.add(overView);
            }
        }
        return overViews;
    }

    private String setCurrentlyRunningBkpSizeInPercentage(long currentlyRunningBkpTotalSizeOfFiles, long totalSizeOfFiles) {
        String currentlyRunningBkpSizeInPercentage = "";
        DecimalFormat twoDecimalPoint = new DecimalFormat("0.00");
        try {
            currentlyRunningBkpSizeInPercentage = totalSizeOfFiles != 0L ? twoDecimalPoint.format((double)((float)currentlyRunningBkpTotalSizeOfFiles / (float)totalSizeOfFiles) * 100.0) + "%" : "0.00%";
        }
        catch (Exception e) {
            logger.debug("Exception:" + e.getMessage());
        }
        return currentlyRunningBkpSizeInPercentage;
    }

    private long getLongValue(String deviceCreatedDate) {
        if (!StringUtils.isNumeric((String)deviceCreatedDate)) {
            return 0L;
        }
        return Long.parseLong(deviceCreatedDate);
    }

    private void createExcelForXlsx(Cloud cloud, List<BackupOverviewElement> backupOverviewElementsList, ReportQueryElement reportQueryElement, boolean officeProduct, String productType) {
        if (!backupOverviewElementsList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                BackupOverviewElement element = backupOverviewElementsList.get(0);
                String overViewTime = element.getOverviewJobTime();
                logger.debug(" Before creating excel for overview ...");
                List<List> recordToAdd = this.updateValuesToExcel(cloud, backupOverviewElementsList, this.getLongValue(overViewTime), reportQueryElement, productType);
                this.createExcelForXlsx(recordToAdd, workbook);
                this.writeExcelForXlsx(workbook, reportQueryElement);
                logger.debug(" After creating excel for overview ...");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private void createExcelOfBackupSummary(Cloud cloud, CloudOverviewElement cloudOverviewElement, ReportQueryElement reportQueryElement, String productType) {
        if (cloudOverviewElement != null) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for createExcelOfBackupSummary ...");
                List<List> recordToAdd = this.updateValuesToExcelBackupSummary(cloudOverviewElement, reportQueryElement.getNoOfDays(), productType, reportQueryElement);
                this.createExcelSheetForDPS(recordToAdd, workbook, "Summary");
                if (reportQueryElement.isIncludeDetails()) {
                    HashSet<String> protectedUsersSet = new HashSet<String>();
                    List<List> recordsToAdd1 = this.updateValuesToExcelForDetailedDPS(cloud, cloudOverviewElement.getProtectedUsersBackupOverviewElementsList(), System.currentTimeMillis(), reportQueryElement, "Backup performance details", protectedUsersSet, productType);
                    this.createExcelSheetForDPS(recordsToAdd1, workbook, "DetailedView");
                    List<List> recordsToAdd2 = this.updateValuesToExcelForDetailedDPS(cloud, cloudOverviewElement.getProtectedUsersWithCurrBkpBackupOverviewElementsList(), System.currentTimeMillis(), reportQueryElement, "Long running backup details", protectedUsersSet, productType);
                    this.createExcelSheetForDPS(recordsToAdd2, workbook, "LongRunningBackups");
                }
                this.writeExcelForXlsxForSummary(workbook, reportQueryElement);
                logger.debug(" After creating excel for createExcelOfBackupSummary ...");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private void createSyncExcelForXlsx(int cloudId, List<SyncOverviewExcelElement> syncOverviewExcelElementsList) {
        if (!syncOverviewExcelElementsList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                SyncOverviewExcelElement element = syncOverviewExcelElementsList.get(0);
                String overViewTime = element.getOverviewJobTime();
                logger.debug(" Before creating excel for overview ...");
                List<List> recordToAdd = ReportServiceImpl.updateSyncValuesToExcel(syncOverviewExcelElementsList, this.getLongValue(overViewTime));
                this.createExcelForXlsx(recordToAdd, workbook);
                this.writeSyncUserExcelForXlsx(workbook);
                logger.debug(" After creating excel for overview ...");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private static boolean isODBBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isODBUserLevelAcctEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"OneDrive Backup Enabled".equals(customisableDetails.getName())) continue;
            isODBUserLevelAcctEnabled = true;
            break;
        }
        return isODBUserLevelAcctEnabled;
    }

    private static boolean isExchangeBackupEnabled(List<CloudCustomisableDetails> list) {
        boolean isExchangeBackupEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"Exchange Backup Enabled".equals(customisableDetails.getName())) continue;
            isExchangeBackupEnabled = true;
            break;
        }
        return isExchangeBackupEnabled;
    }

    private List<List> updateValuesToExcel(Cloud cloud, List<BackupOverviewElement> bkpOverViewList, long reportDate, ReportQueryElement reportQueryElement, String productType) {
        boolean showAdditionalAdAttrbs = PCHelperConstant.showAdditionalAdAttrbs();
        boolean showAddReportAttrbs = PCHelperConstant.showAddReportAttr();
        boolean isO365BkpEnabled = ReportServiceImpl.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        boolean isODBEnabled = ReportServiceImpl.isODBEnabled(cloud.getCloudCustomisableDetails());
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        if (SHARE_POINT.equalsIgnoreCase(productType)) {
            headerRow.add(SITE_NAME);
            headerRow.add(SITE_STATUS);
            headerRow.add("Site Installation Date");
            headerRow.add(SITE_INSTALLATION_TIME);
        } else {
            headerRow.add("User ID");
            headerRow.add("Email ID");
            headerRow.add(USER_STATUS);
            if (ODB.equals(productType)) {
                headerRow.add("Asset Name");
                headerRow.add(ASSET_STATUS);
                headerRow.add("Asset Installation Date");
                headerRow.add(ASSET_INSTALLATION_TIME);
            } else {
                headerRow.add("Asset Name");
                headerRow.add(DEVICE_STATUS);
                headerRow.add("Device Installation Date");
                headerRow.add(DEVICE_INSTALLATION_TIME);
            }
        }
        headerRow.add("Os Type");
        if (!SHARE_POINT.equalsIgnoreCase(productType)) {
            headerRow.add(CLIENT_VERSION);
        }
        if (isShowUserConsentFieldInPolicies.booleanValue()) {
            headerRow.add(CONSENT_GIVEN);
            headerRow.add(CONSENT_GIVEN_TIME);
        }
        if (ODB.equalsIgnoreCase(productType)) {
            headerRow.add("OneDrive for Business Policy Name");
        } else if (SHARE_POINT.equalsIgnoreCase(productType)) {
            headerRow.add("Sharepoint Online Policy Name");
        } else {
            headerRow.add(POLICY_NAME);
        }
        if (isODBEnabled) {
            headerRow.add("Backup Target Assigned");
            headerRow.add(REASON);
        }
        headerRow.add("First Backup Start Date");
        headerRow.add(FIRST_BACKUP_START_TIME);
        headerRow.add("First Backup End Date");
        headerRow.add(FIRST_BACKUP_END_TIME);
        headerRow.add("Full Backup Completed");
        headerRow.add("Last Successful Backup Start Date");
        headerRow.add(LAST_SUCCESSFUL_BACKUP_STRAT_TIME);
        headerRow.add("Last Successful Backup End Date");
        headerRow.add(LAST_SUCCESSFUL_BACKUO_END_TIME);
        if (showAddReportAttrbs) {
            headerRow.add("Last Backup Start Date");
            headerRow.add("Last Backup Start Time");
            headerRow.add("Last Backup End Date");
            headerRow.add("Last Backup End Time");
        }
        headerRow.add(IS_LAST_BACKUP_COMPLETED);
        headerRow.add("Current Backup Start Date");
        headerRow.add(CURRENT_BACKUP_START_TIME);
        headerRow.add(CURRENT_BACKUP_STATUS);
        headerRow.add(CURRENT_BACKUP_COMPLETION);
        headerRow.add(IS_BACKUP_RUNNING);
        if (!SHARE_POINT.equalsIgnoreCase(productType) && !ODB.equals(productType)) {
            headerRow.add("Last Heard Date");
            headerRow.add(LAST_TIME_HEARD);
        }
        headerRow.add(TOTAL_STORAGE_UTILIZED);
        headerRow.add(NOTES);
        if (showAdditionalAdAttrbs) {
            headerRow.add(DISPLAY_NAME);
            headerRow.add(LOCATION);
            headerRow.add(DEPARTMENT);
            if (ReportServiceImpl.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                headerRow.add(AZURE_ACTIVE_DIRECTORY_USER_STATUS);
            } else {
                headerRow.add(ACTIVE_DIRECTORY_USER_STATUS);
            }
        }
        headerRow.add("Full Backup Size");
        headerRow.add("Full Backup No. of Files");
        headerRow.add("Last Successful Backup Size");
        headerRow.add("Last Successful Backup No. of Files");
        headerRow.add("Current Backup Progress - Size");
        headerRow.add("Current Backup Progress - No. of files");
        headerRow.add("Current Backup - Expected size");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(reportDate));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        if (SHARE_POINT.equalsIgnoreCase(productType)) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(siteName + reportQueryElement.getDeviceName() + "   ");
            }
        } else {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                sb.append(userName + reportQueryElement.getUserName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(deviceName + reportQueryElement.getDeviceName() + "   ");
            }
        }
        String includeUserswithoutdevice = "No";
        String includeblockedusers = "NO";
        String includeblockeddevices = "NO";
        if (reportQueryElement.isUserWithoutDeviceEnabled()) {
            includeUserswithoutdevice = "YES";
        }
        if (reportQueryElement.isShowBlockedUsers()) {
            includeblockedusers = "YES";
        }
        if (reportQueryElement.isShowBlockedDevices()) {
            includeblockeddevices = "YES";
        }
        if (SHARE_POINT.equalsIgnoreCase(productType)) {
            sb.append("Include blocked sites: " + includeblockeddevices + "   ");
        } else if (ODB.equalsIgnoreCase(productType)) {
            sb.append("Include Users without a asset installed: " + includeUserswithoutdevice + "   ");
            sb.append("Include blocked users: " + includeblockedusers + "   ");
            sb.append("Include blocked assets: " + includeblockeddevices + "   ");
        } else {
            sb.append("Include Users without a device installed: " + includeUserswithoutdevice + "   ");
            sb.append("Include blocked users: " + includeblockedusers + "   ");
            sb.append("Include blocked Assets: " + includeblockeddevices + "   ");
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            try {
                boolean isBackupRunningStatus;
                boolean isBackupRunning;
                String lastBkpStatus;
                long firstBkpStartTime;
                boolean isDeviceActive = false;
                if (SHARE_POINT.equalsIgnoreCase(productType)) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                        firstRow.add(backupOverviewElement.getDeviceName());
                    } else {
                        firstRow.add("-");
                    }
                    isDeviceActive = backupOverviewElement.isDeviceActive();
                    String deviceActive = ReportServiceImpl.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                    if (!StringUtils.isEmpty((String)deviceActive)) {
                        firstRow.add(deviceActive);
                    } else {
                        firstRow.add("-");
                    }
                } else {
                    firstRow.add(backupOverviewElement.getUserId());
                    firstRow.add(backupOverviewElement.getEmailId());
                    String userActive = ReportServiceImpl.getUserActiveStatus(backupOverviewElement);
                    firstRow.add(userActive);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                        firstRow.add(backupOverviewElement.getDeviceName());
                    } else {
                        firstRow.add("-");
                    }
                    isDeviceActive = backupOverviewElement.isDeviceActive();
                    String deviceActive = ReportServiceImpl.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                    if (!StringUtils.isEmpty((String)deviceActive)) {
                        firstRow.add(deviceActive);
                    } else {
                        firstRow.add("-");
                    }
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                    long installtionTimeStamp = ReportServiceImpl.getTime(backupOverviewElement.getEpaInstallationDate());
                    firstRow.add(ReportServiceImpl.getDateInFormat(installtionTimeStamp, "dd-MMM-yyyy"));
                    firstRow.add(ReportServiceImpl.getDateInFormat(installtionTimeStamp, HH_MM_SS));
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
                String osVersionBits = "";
                if (!StringUtils.isEmpty((String)backupOverviewElement.getOsVersion())) {
                    osVersionBits = !StringUtils.isEmpty((String)backupOverviewElement.getOsType()) && backupOverviewElement.getOsType().startsWith("Window") ? (backupOverviewElement.getOsVersion().contains("(") ? "(" + backupOverviewElement.getOsVersion().substring(backupOverviewElement.getOsVersion().indexOf("(") + 1, backupOverviewElement.getOsVersion().indexOf(")")) + ")" : backupOverviewElement.getOsVersion()) : backupOverviewElement.getOsVersion();
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getOsType())) {
                    firstRow.add(backupOverviewElement.getOsType() + osVersionBits);
                } else {
                    firstRow.add("-");
                }
                if (!SHARE_POINT.equalsIgnoreCase(productType)) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getClientVersion())) {
                        firstRow.add(backupOverviewElement.getClientVersion());
                    } else {
                        firstRow.add("-");
                    }
                }
                if (isShowUserConsentFieldInPolicies.booleanValue()) {
                    if (backupOverviewElement.getOsType().startsWith("Window") || backupOverviewElement.getOsType().startsWith("Mac")) {
                        firstRow.add(backupOverviewElement.getConsentGiven());
                        firstRow.add(backupOverviewElement.getConsentGivenTime());
                    } else {
                        firstRow.add("");
                        firstRow.add("");
                    }
                }
                if (ODB.equalsIgnoreCase(productType)) {
                    firstRow.add(backupOverviewElement.getOneDrivePolicyName());
                } else if (SHARE_POINT.equalsIgnoreCase(productType)) {
                    firstRow.add(backupOverviewElement.getOneDrivePolicyName());
                } else {
                    firstRow.add(backupOverviewElement.getPolicyName());
                }
                if (isODBEnabled) {
                    if (backupOverviewElement.isBackupTargetAssigned()) {
                        firstRow.add("Yes");
                    } else {
                        firstRow.add("No");
                    }
                    if (backupOverviewElement.isBackupTargetAssigned() & backupOverviewElement.getBackupTargetErrorCode() == 0) {
                        firstRow.add("");
                    } else {
                        firstRow.add(ReportServiceImpl.getCommentsForErrorCode(backupOverviewElement.getBackupTargetErrorCode()));
                    }
                }
                if (!StringUtils.isEmpty((String)ReportServiceImpl.getDateInFormat(firstBkpStartTime = ReportServiceImpl.getFirstBkpStartTime(backupOverviewElement), "dd-MMM-yyyy"))) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)ReportServiceImpl.getDateInFormat(firstBkpStartTime, HH_MM_SS))) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstBkpStartTime, HH_MM_SS));
                } else {
                    firstRow.add("-");
                }
                long firstbackupEndTime = ReportServiceImpl.getTime(backupOverviewElement.getFirstBkpEndTime());
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstbackupEndTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstbackupEndTime, HH_MM_SS));
                } else {
                    firstRow.add("-");
                }
                String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
                String lastSuccessfulBackupEndDate = "";
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)lastSuccessfulBackupEndTime);
                String firstBkpCompleted = ReportServiceImpl.getFirstBkpCompletedState(isFirstBkpCompleted);
                firstRow.add(firstBkpCompleted);
                String lastSuccessBkpStartTime = "";
                String lastSuccessBkpStartDate = "";
                if (isFirstBkpCompleted) {
                    long lstBkpEndTime;
                    long lstBkpStartTime;
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getFirstBkpStartTime());
                        backupOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getFirstBkpEndTime());
                    }
                    if ((lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime())) > (lstBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpEndTime = lstBkpStartTime + 0x6DDD00L;
                    }
                    lastSuccessBkpStartTime = ReportServiceImpl.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                    lastSuccessBkpStartDate = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy");
                    lastSuccessfulBackupEndTime = ReportServiceImpl.getDateInFormat(lstBkpEndTime, HH_MM_SS);
                    lastSuccessfulBackupEndDate = ReportServiceImpl.getDateInFormat(lstBkpEndTime, "dd-MMM-yyyy");
                }
                if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                    firstRow.add(lastSuccessBkpStartDate);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessBkpStartTime)) {
                    firstRow.add(lastSuccessBkpStartTime);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                    firstRow.add(lastSuccessfulBackupEndDate);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndTime)) {
                    firstRow.add(lastSuccessfulBackupEndTime);
                } else {
                    firstRow.add("-");
                }
                if (showAddReportAttrbs) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpStartTime())) {
                        long lastBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpStartTime());
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastBkpStartTime, "dd-MMM-yyyy"));
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastBkpStartTime, HH_MM_SS));
                    } else {
                        firstRow.add("-");
                        firstRow.add("-");
                    }
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        long lastBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpEndTime());
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastBkpEndTime, "dd-MMM-yyyy"));
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastBkpEndTime, HH_MM_SS));
                    } else {
                        firstRow.add("-");
                        firstRow.add("-");
                    }
                }
                if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                    lastBkpStatus = "-";
                }
                if (backupOverviewElement.isLastBackupCompleted()) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                boolean bl = isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
                if (!StringUtils.isEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus)) {
                    String lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime();
                    String lstBkpStartDateStr = backupOverviewElement.getLastBkpStartTime();
                    if (StringUtils.isNotEmpty((String)lstBkpStartTimeStr) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        long lstsuccessBkpEndTime;
                        long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpStartTime());
                        if (lstBkpStartTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                            lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                        }
                        lstBkpStartTimeStr = ReportServiceImpl.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                        lstBkpStartDateStr = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy");
                    }
                    firstRow.add(lstBkpStartDateStr);
                    firstRow.add(lstBkpStartTimeStr);
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
                if (lastBkpStatus.equalsIgnoreCase(COMPLETED)) {
                    firstRow.add("-");
                } else {
                    firstRow.add(lastBkpStatus);
                }
                int totalNoOfFiles = 0;
                boolean noOfFilesRemaining = false;
                if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
                    totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
                }
                long percentage = 0L;
                percentage = backupOverviewElement.getTotalSizeToUploadInKB() != 0L && backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalSizeToUploadInKB(), backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
                if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && !lastBkpStatus.equalsIgnoreCase(COMPLETED) && !lastBkpStatus.equalsIgnoreCase(STATUS_SANNING)) {
                    firstRow.add(String.valueOf(percentage) + "%");
                } else {
                    firstRow.add("-");
                }
                boolean bl2 = isBackupRunningStatus = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && !"STOPPED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive && !lastBkpStatus.equalsIgnoreCase("-");
                if (isBackupRunningStatus) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                if (!SHARE_POINT.equalsIgnoreCase(productType) && !ODB.equals(productType)) {
                    String lastHeardDate = "";
                    if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                        long lstsuccessBkpEndTime;
                        String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                        if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                            lastHeardDate = lastAccessTime;
                        } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                            lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                        } else {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                                Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                                Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                                lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                            }
                            catch (Exception e) {
                                logger.error("...unable to process date...... " + e.getMessage());
                                logger.trace(EXCEPTION + e);
                            }
                        }
                        long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                        if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                            lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                        }
                        long lastHeardTimeStamp = ReportServiceImpl.getTime(lastHeardDate);
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastHeardTimeStamp, "dd-MMM-yyyy"));
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastHeardTimeStamp, HH_MM_SS));
                    } else {
                        firstRow.add("-");
                        firstRow.add("-");
                    }
                }
                firstRow.add(backupOverviewElement.getStorageUtilized());
                firstRow.add(backupOverviewElement.getReason());
                if (showAdditionalAdAttrbs) {
                    firstRow.add(backupOverviewElement.getDisplayName());
                    firstRow.add(backupOverviewElement.getLocation());
                    firstRow.add(backupOverviewElement.getDepartment());
                    if (backupOverviewElement.isAccountStatus()) {
                        firstRow.add("Y");
                    } else {
                        firstRow.add("N");
                    }
                }
                if (isFirstBkpCompleted) {
                    firstRow.add(backupOverviewElement.getFirstFullBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getFirstFullBkpNoOfFiles());
                    firstRow.add(backupOverviewElement.getLastSucessfulBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getLastSucessfulBkpNoOfFiles());
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                    firstRow.add("-");
                    firstRow.add("-");
                }
                if (StringUtils.isNotEmpty((String)lastBkpStatus) && STATUS_STARTED.equalsIgnoreCase(lastBkpStatus)) {
                    firstRow.add(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getCurrentlyRunningBkpNoOfFiles());
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
                if (StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus)) {
                    firstRow.add(backupOverviewElement.getTotalSizeToUpload());
                } else {
                    firstRow.add("-");
                }
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(" Exception in calculating percent  " + e.getMessage());
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelForLongRunningBkpDPS(Cloud cloud, List<BackupOverviewElement> bkpOverViewList, long reportDate, ReportQueryElement reportQueryElement) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Device Name");
        headerRow.add("Policy Name");
        headerRow.add("First Backup Start Date");
        headerRow.add("First Backup End Date");
        headerRow.add("Most Recent Backup Start Date");
        headerRow.add("Most Recent Backup End Date");
        headerRow.add("Last Heard Date");
        headerRow.add(TOTAL_STORAGE_UTILIZED);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        sb.append(noOfDays + reportQueryElement.getNoOfDays());
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add("Long running backup details");
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        HashSet<String> protectedUsersSet = new HashSet<String>();
        for (BackupOverviewElement backupOverviewElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            try {
                if (protectedUsersSet.contains(backupOverviewElement.getUserId())) {
                    logger.debug("user already added to the excel so skip this device...");
                    continue;
                }
                protectedUsersSet.add(backupOverviewElement.getUserId());
                firstRow.add(backupOverviewElement.getUserId());
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    firstRow.add(backupOverviewElement.getDeviceName());
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getPolicyName())) {
                    firstRow.add(backupOverviewElement.getPolicyName());
                } else {
                    firstRow.add("-");
                }
                long firstBkpStartTime = ReportServiceImpl.getFirstBkpStartTime(backupOverviewElement);
                if (!StringUtils.isEmpty((String)ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy"))) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                long firstbackupEndTime = ReportServiceImpl.getTime(backupOverviewElement.getFirstBkpEndTime());
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstbackupEndTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
                String lastSuccessfulBackupEndDate = "";
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime());
                String lastSuccessBkpStartDate = "";
                if (isFirstBkpCompleted) {
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastBkpStartTime());
                        lastSuccessfulBackupEndTime = null;
                    }
                    long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
                    if (StringUtils.isNotEmpty((String)lastSuccessfulBackupEndTime)) {
                        long lstBkpEndTime = ReportServiceImpl.getTime(lastSuccessfulBackupEndTime);
                        lastSuccessfulBackupEndDate = ReportServiceImpl.getDateInFormat(lstBkpEndTime, "dd-MMM-yyyy");
                    }
                    lastSuccessBkpStartDate = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy");
                } else {
                    lastSuccessBkpStartDate = null;
                    lastSuccessfulBackupEndDate = null;
                }
                if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                    firstRow.add(lastSuccessBkpStartDate);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                    firstRow.add(lastSuccessfulBackupEndDate);
                } else {
                    firstRow.add("-");
                }
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        lastHeardDate = lastAccessTime;
                    } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                        lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                    } else {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                            Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                            Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                            lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                        }
                        catch (Exception e) {
                            logger.error("...unable to process date...... " + e.getMessage());
                            logger.trace(EXCEPTION + e);
                        }
                    }
                    long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                    }
                    long lastHeardTimeStamp = ReportServiceImpl.getTime(lastHeardDate);
                    firstRow.add(ReportServiceImpl.getDateInFormat(lastHeardTimeStamp, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                firstRow.add(backupOverviewElement.getStorageUtilized());
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(" Exception in calculating percent  " + e.getMessage());
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelForDetailedDPS(Cloud cloud, List<BackupOverviewElement> protectedUsersBackupOverviewElementsList, long reportDate, ReportQueryElement reportQueryElement, String header, Set<String> protectedUsersSet, String productType) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        if (SHARE_POINT.equals(productType)) {
            headerRow.add(SITE_NAME);
            headerRow.add(SHARE_POINT_POLICY_NAME);
            headerRow.add("First Backup Start Date");
            headerRow.add("First Backup End Date");
            headerRow.add("Most Recent Backup Start Date");
            headerRow.add("Most Recent Backup End Date");
            headerRow.add(TOTAL_STORAGE_UTILIZED);
        } else {
            headerRow.add("User ID");
            if (ODB.equals(productType)) {
                headerRow.add("Asset Name");
            } else {
                headerRow.add("Device Name");
            }
            headerRow.add("Policy Name");
            headerRow.add("First Backup Start Date");
            headerRow.add("First Backup End Date");
            headerRow.add("Most Recent Backup Start Date");
            headerRow.add("Most Recent Backup End Date");
            if (!ODB.equals(productType)) {
                headerRow.add("Last Heard Date");
            }
            headerRow.add(TOTAL_STORAGE_UTILIZED);
            if (header.equalsIgnoreCase("Long running backup details")) {
                headerRow.add("Most Recent Backup Size");
            }
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        sb.append(noOfDays + reportQueryElement.getNoOfDays());
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add(header);
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : protectedUsersBackupOverviewElementsList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            try {
                if (!SHARE_POINT.equals(productType)) {
                    if (protectedUsersSet.contains(backupOverviewElement.getUserId())) {
                        logger.debug("user already added to the excel so skip this device...");
                        continue;
                    }
                    protectedUsersSet.add(backupOverviewElement.getUserId());
                    firstRow.add(backupOverviewElement.getUserId());
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    firstRow.add(backupOverviewElement.getDeviceName());
                } else {
                    firstRow.add("-");
                }
                if (SHARE_POINT.equals(productType)) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getSpPolicyName())) {
                        firstRow.add(backupOverviewElement.getSpPolicyName());
                    } else {
                        firstRow.add("-");
                    }
                } else if (ODB.equals(productType)) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getOneDrivePolicyName())) {
                        firstRow.add(backupOverviewElement.getOneDrivePolicyName());
                    } else {
                        firstRow.add("-");
                    }
                } else if (!StringUtils.isEmpty((String)backupOverviewElement.getPolicyName())) {
                    firstRow.add(backupOverviewElement.getPolicyName());
                } else {
                    firstRow.add("-");
                }
                long firstBkpStartTime = ReportServiceImpl.getFirstBkpStartTime(backupOverviewElement);
                if (!StringUtils.isEmpty((String)ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy"))) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                long firstbackupEndTime = ReportServiceImpl.getTime(backupOverviewElement.getFirstBkpEndTime());
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstbackupEndTime, "dd-MMM-yyyy"));
                } else {
                    firstRow.add("-");
                }
                String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
                String lastSuccessfulBackupEndDate = "";
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime());
                String lastSuccessBkpStartDate = "";
                if (isFirstBkpCompleted) {
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastBkpStartTime());
                        lastSuccessfulBackupEndTime = null;
                    }
                    long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
                    if (StringUtils.isNotEmpty((String)lastSuccessfulBackupEndTime)) {
                        long lstBkpEndTime = ReportServiceImpl.getTime(lastSuccessfulBackupEndTime);
                        lastSuccessfulBackupEndDate = ReportServiceImpl.getDateInFormat(lstBkpEndTime, "dd-MMM-yyyy");
                    }
                    lastSuccessBkpStartDate = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy");
                } else {
                    lastSuccessBkpStartDate = null;
                    lastSuccessfulBackupEndDate = null;
                }
                if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                    firstRow.add(lastSuccessBkpStartDate);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                    firstRow.add(lastSuccessfulBackupEndDate);
                } else {
                    firstRow.add("-");
                }
                if (!SHARE_POINT.equals(productType) && !ODB.equals(productType)) {
                    String lastHeardDate = "";
                    if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                        long lstsuccessBkpEndTime;
                        String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                        if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                            lastHeardDate = lastAccessTime;
                        } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                            lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                        } else {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                                Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                                Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                                lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                            }
                            catch (Exception e) {
                                logger.error("...unable to process date...... " + e.getMessage());
                                logger.trace(EXCEPTION + e);
                            }
                        }
                        long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                        if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                            lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                        }
                        long lastHeardTimeStamp = ReportServiceImpl.getTime(lastHeardDate);
                        firstRow.add(ReportServiceImpl.getDateInFormat(lastHeardTimeStamp, "dd-MMM-yyyy"));
                    } else {
                        firstRow.add("-");
                    }
                }
                firstRow.add(backupOverviewElement.getStorageUtilized());
                if (header.equalsIgnoreCase("Long running backup details")) {
                    firstRow.add(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                }
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(" Exception in calculating percent  " + e.getMessage());
            }
            recordToAdd.add(firstRow);
        }
        ArrayList<String> emptyRow = new ArrayList<String>();
        emptyRow.add("");
        recordToAdd.add(emptyRow);
        return recordToAdd;
    }

    private static boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private static String getCommentsForErrorCode(int errorCode) {
        String comments = "";
        if (errorCode == 0) {
            return "Newly created user";
        }
        if (errorCode == 201) {
            comments = "Site not present in SharePoint";
        }
        if (errorCode == 202) {
            comments = "User OneDrive license invalid";
        }
        if (errorCode == 203) {
            comments = "Insufficient space in OneDrive subscription to use for backup";
        }
        if (errorCode == 404) {
            comments = "User site not found. Make sure the email ID provided is valid";
        }
        if (errorCode == 403) {
            comments = "OneDrive permission denied";
        }
        if (errorCode == 204) {
            comments = "OneDrive target not assigned";
        }
        if (errorCode == 543) {
            comments = "OneDrive target not assigned";
        }
        if (errorCode == 544) {
            comments = "Invalid Mailbox License";
        }
        if (errorCode == 449) {
            comments = "MailBox does not exist for User";
        }
        if (errorCode == 450) {
            comments = "No secondary site admin privilege";
        }
        if (errorCode == 1947) {
            comments = "Storage limit exceeded";
        }
        return comments;
    }

    private static long getFirstBkpStartTime(BackupOverviewElement backupOverviewElement) {
        long firstBkpEndTime;
        long firstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getFirstBkpStartTime());
        if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime()) && firstBkpStartTime > (firstBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getFirstBkpEndTime()))) {
            firstBkpStartTime = firstBkpEndTime - 0x6DDD00L;
        }
        return firstBkpStartTime;
    }

    private static String getFirstBkpCompletedState(boolean isFirstBkpCompleted) {
        String firstBkpCompleted = isFirstBkpCompleted ? "Y" : "N";
        return firstBkpCompleted;
    }

    private static String getUserActiveStatus(BackupOverviewElement backupOverviewElement) {
        String userActive = backupOverviewElement.isUserActive() ? "Active" : "Blocked";
        return userActive;
    }

    private static String getDeviceActiveState(BackupOverviewElement backupOverviewElement, boolean isDeviceActive) {
        if (!isDeviceActive) {
            String deviceActive = "Blocked";
            return deviceActive;
        }
        String deviceActive = backupOverviewElement.isDecoupled() ? "Decoupled" : (isDeviceActive && !StringUtils.isEmpty((String)backupOverviewElement.getDeviceName()) ? "Active" : (StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate()) ? "" : "Blocked"));
        return deviceActive;
    }

    private static String getReason(BackupOverviewElement backupOverviewElement, String lastBkpStatus, boolean isBackupRunning) {
        String reason = backupOverviewElement.getReason();
        if (!StringUtils.isEmpty((String)lastBkpStatus) && (STATUS_STARTED.equalsIgnoreCase(lastBkpStatus) || COMPLETED.equalsIgnoreCase(lastBkpStatus) || STATUS_SANNING.equalsIgnoreCase(lastBkpStatus))) {
            reason = "";
        }
        if (StringUtils.isEmpty((String)backupOverviewElement.getReason()) && !STATUS_STARTED.equalsIgnoreCase(lastBkpStatus) && COMPLETED.equalsIgnoreCase(lastBkpStatus)) {
            reason = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if (!isBackupRunning || StringUtils.isEmpty((String)lastBkpStatus)) {
            reason = "";
        }
        return reason;
    }

    private static long getPercentageCompleted(String totalNoOfFiles, String noOfFilesRemaining) {
        long totalNoOfFilesValue = 0L;
        long noOfFilesRemainingValue = 0L;
        try {
            if (!StringUtils.isEmpty((String)totalNoOfFiles)) {
                totalNoOfFilesValue = Integer.parseInt(totalNoOfFiles);
            }
            if (!StringUtils.isEmpty((String)noOfFilesRemaining)) {
                noOfFilesRemainingValue = Integer.parseInt(noOfFilesRemaining);
            }
        }
        catch (NumberFormatException e) {
            logger.trace(EXCEPTION + e);
            logger.error(" Exception in calculating percent  " + e.getMessage());
        }
        if (noOfFilesRemainingValue == 0L) {
            return 0L;
        }
        long filesBackedup = totalNoOfFilesValue - noOfFilesRemainingValue;
        long percentage = 100L;
        if (totalNoOfFilesValue != 0L) {
            percentage = filesBackedup * 100L / totalNoOfFilesValue;
        }
        logger.debug(filesBackedup + "/" + totalNoOfFilesValue + "...getpercent...." + percentage);
        if (percentage > 100L) {
            percentage = 100L;
        }
        if (totalNoOfFilesValue <= 0L) {
            percentage = 0L;
        }
        return percentage;
    }

    private static long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        if (totalNoOfFiles == 0L && noOfFilesRemaining == 0L) {
            return 100L;
        }
        long percentage = 100L;
        if (totalNoOfFiles != 0L) {
            percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        }
        return percentage;
    }

    private static long getPercentageCompleted1(long uploadedFiles, long totalNoOfFiles) {
        if (totalNoOfFiles == 0L && totalNoOfFiles == 0L) {
            return 100L;
        }
        long percentage = 100L;
        percentage = uploadedFiles * 100L / totalNoOfFiles;
        logger.debug("..percentage.." + percentage + "....");
        return percentage;
    }

    private static List<List> updateSyncValuesToExcel(List<SyncOverviewExcelElement> syncOverviewExcelList, long reportDate) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Email ID");
        headerRow.add(POLICY_NAME);
        headerRow.add(TOTAL_STORAGE_UTILIZED);
        headerRow.add("User Active?");
        headerRow.add("Last Login Time");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(reportDate));
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (SyncOverviewExcelElement syncOverviewExcelElement : syncOverviewExcelList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(syncOverviewExcelElement.getUserId());
            firstRow.add(syncOverviewExcelElement.getEmailId());
            firstRow.add(syncOverviewExcelElement.getPolicyName());
            firstRow.add(syncOverviewExcelElement.getStorageUtilized());
            firstRow.add(Boolean.toString(syncOverviewExcelElement.isUserActive()));
            if (!StringUtils.isEmpty((String)syncOverviewExcelElement.getLastBkpStartTime())) {
                firstRow.add(ReportServiceImpl.getDateInFormat(Long.valueOf(syncOverviewExcelElement.getLastBkpStartTime()), "dd-MMM-yyyy HH:mm:ss"));
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    void writeExcelForXls(HSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/Backup_OverviewStatus.xlsx"));){
            HSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForXlsx(XSSFWorkbook workbook, ReportQueryElement reportQueryElement) {
        String fileName = "Backup_OverviewStatus.xlsx";
        if (reportQueryElement != null && !StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
            fileName = "Backup_OverviewStatus_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
        }
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForXlsxForProductOverview(XSSFWorkbook workbook, ReportQueryElement reportQueryElement) {
        String fileName = "Product_OverviewStatus.xlsx";
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForXlsxForSummary(XSSFWorkbook workbook, ReportQueryElement reportQueryElement) {
        String fileName = "DataProtectionScorecard.xlsx";
        if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
            fileName = "DataProtectionScorecard_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
        }
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeSyncUserExcelForXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/Sync_User_OverviewStatus.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelXlsx(XSSFWorkbook workbook, ReportQueryElement reportQueryElement, boolean systemNotProtected) {
        String fileName = "SystemNotProtected";
        if (!systemNotProtected) {
            fileName = "UsersWithoutAnySystemsProtected";
        }
        if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
            fileName = fileName + "_From_Scheduler_" + reportQueryElement.getDisplayName();
        }
        fileName = fileName + ".xlsx";
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeSyncExcelForXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/syncOverview/Sync_OverviewStatus.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelForXls(List<List> l1, HSSFWorkbook workbook) throws Exception {
        HSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                HSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    HSSFFont font;
                    HSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0 || rownum == 1) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont(font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum != 0) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont(font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelForXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum == 1) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A2:C2"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum != 2) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelSheetForDPS(List<List> l1, XSSFWorkbook workbook, String sheetName) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet(sheetName);
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        font.setBold(true);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum == 1) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        font.setBold(true);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A2:C2"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum == 2) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        font.setBold(true);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A3:C3"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum != 3) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelForProductOverviewXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("License Information");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum == 17) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)10);
                        font.setBoldweight((short)10);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum == 18) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)51);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)10);
                        font.setBoldweight((short)10);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                    }
                    if (rownum != 24) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)22);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                    firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                    CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void createExcelForProductOverviewXlsx1(List<List> l1, XSSFWorkbook workbook, String sheetName) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet(sheetName);
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum != 1) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private static String getTimeZoneShortFormat(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    private static String getTimeZoneShortFormatwithoutTime(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    @Override
    public List<UserDeviceHistoryElement> getUserHistoryElement(int cloudId, String cloudName, String userName, int skipValue) {
        ArrayList<UserDeviceHistoryElement> deviceHistoryElements;
        block6: {
            block5: {
                List list;
                deviceHistoryElements = new ArrayList<UserDeviceHistoryElement>();
                if (StringUtils.isEmpty((String)userName)) break block5;
                User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
                if (user == null || CollectionUtils.isEmpty((Collection)(list = this.deviceDao.getAllOverviews(cloudId, userName)))) break block6;
                for (DeviceBackupOverView deviceBackupOverView : list) {
                    if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted()) continue;
                    UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
                    userDeviceHistoryElement.setUserName(userName);
                    userDeviceHistoryElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    Long storageUsed = deviceBackupOverView.getStorageUtilized();
                    userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                    String date = user.getCreatedTimestamp();
                    if (!StringUtils.isEmpty((String)date)) {
                        Long dateLong = Long.valueOf(date);
                        userDeviceHistoryElement.setCreatedTimestamp(this.getDate(dateLong));
                    }
                    deviceHistoryElements.add(userDeviceHistoryElement);
                }
                break block6;
            }
            logger.debug("get all userss for user history....");
            List users = this.userDao.getAllUsers(cloudId, cloudName, skipValue, false, "false");
            for (User user : users) {
                List list;
                if (user == null || CollectionUtils.isEmpty((Collection)(list = this.deviceDao.getAllOverviews(cloudId, userName)))) continue;
                for (DeviceBackupOverView deviceBackupOverView : list) {
                    if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted()) continue;
                    UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
                    userDeviceHistoryElement.setUserName(user.getUserName());
                    userDeviceHistoryElement.setDeviceName(deviceBackupOverView.getDeviceName());
                    Long storageUsed = deviceBackupOverView.getStorageUtilized();
                    userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
                    String date = user.getCreatedTimestamp();
                    if (!StringUtils.isEmpty((String)date)) {
                        Long dateLong = Long.valueOf(date);
                        userDeviceHistoryElement.setCreatedTimestamp(this.getDate(dateLong));
                    }
                    deviceHistoryElements.add(userDeviceHistoryElement);
                }
            }
        }
        return deviceHistoryElements;
    }

    @Override
    public List<UserDeviceHistoryElement> getDeviceHistoryElement(int cloudId, String cloudName, String deviceName, int skipValue) {
        List deviceHistoryElementsList = this.backUpImageDao.getDeviceHistoryElement(cloudId, cloudName, deviceName, skipValue);
        ArrayList<UserDeviceHistoryElement> deviceHistoryElements = new ArrayList<UserDeviceHistoryElement>();
        for (Object[] object : deviceHistoryElementsList) {
            UserDeviceHistoryElement userDeviceHistoryElement = new UserDeviceHistoryElement();
            userDeviceHistoryElement.setDeviceName((String)object[1]);
            Long storageUsed = (Long)object[0];
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            String userName = (String)object[2];
            userDeviceHistoryElement.setUserName(userName);
            if (object[3] != null) {
                Long createdTimestamp = Long.parseLong((String)object[3]);
                userDeviceHistoryElement.setCreatedTimestamp(this.getDate(createdTimestamp));
            }
            storageUsed = this.backUpImageDao.getStorageUsedForDevice(cloudId, cloudName, deviceName, userName);
            userDeviceHistoryElement.setStorageUsed(ReportServiceImpl.formatFileSize(storageUsed));
            deviceHistoryElements.add(userDeviceHistoryElement);
        }
        return deviceHistoryElements;
    }

    @Override
    public CloudOverviewElement getCloudOverviewElementForServerBackup(int cloudId, String cloudName) {
        logger.debug("CloudOverviewElement getCloudOverviewElementForServerBackup(int cloudId, String cloudName) > BEGIN >");
        CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
        long deviceCount = 0L;
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        long totalRawDiskSpacebeforeBackup = 0L;
        try {
            Object[] arr = this.deviceDao.getCloudOverView(cloudId, false, null, null);
            totalDiskSpaceUsed = (Long)arr[0];
            noOfBackupsDone = (Long)arr[1];
            noOfRestoresDone = arr[2] == null ? 0L : (Long)arr[2];
            deviceCount = this.deviceDao.getDeviceCount(cloudId, cloudName, false);
            cloudOverviewElement.setTotalStorageUtilized(ReportServiceImpl.formatFileSize(totalDiskSpaceUsed));
            cloudOverviewElement.setDevicesConnected(String.valueOf(deviceCount));
            cloudOverviewElement.setRestoresDone(String.valueOf(noOfRestoresDone));
            cloudOverviewElement.setBackupsDone(String.valueOf(noOfBackupsDone));
            totalRawDiskSpacebeforeBackup = this.deviceBackupJobDao.getRawDataUsage(cloudId);
            cloudOverviewElement.setTotalRawDataSize(ReportServiceImpl.formatFileSize(totalRawDiskSpacebeforeBackup));
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error("Error failed to load getCloudOverview for serverbackup..." + e.getMessage());
        }
        logger.debug("CloudOverviewElement getCloudOverviewElementForServerBackup(int cloudId, String cloudName) > BEFORE RETURN > ");
        return cloudOverviewElement;
    }

    @Override
    public SyncOverviewElement getSyncOverview(int cloudId, Cloud cloud) {
        SyncOverView syncOverview = this.consolidatedImageDao.getSyncOverview(cloudId);
        SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
        syncOverviewElement.setTotalUsers(Long.toString(cloud.getNoOfSyncUsersAllowed()));
        if (syncOverview != null) {
            syncOverviewElement.setTotalFilesShared(Long.toString(syncOverview.getTotalFilesShared()));
            syncOverviewElement.setTotalFilesDownloaded(Long.toString(syncOverview.getTotalFilesDownloaded()));
            syncOverviewElement.setTotalSizeUploaded(ReportServiceImpl.formatFileSize(syncOverview.getTotalSizeUploaded()));
            syncOverviewElement.setTotalSizeDownloaded(ReportServiceImpl.formatFileSize(syncOverview.getTotalSizeDownloaded()));
        }
        return syncOverviewElement;
    }

    @Override
    public List<SyncOverviewElement> getSyncOverview(int cloudId, Cloud cloud, String startDate, String endDate) {
        List list = this.consolidatedImageDao.getDailySyncOverView(cloudId, Long.valueOf(ReportServiceImpl.getStartOfDay(startDate)), Long.valueOf(ReportServiceImpl.getEndOfDay(endDate)));
        ArrayList<SyncOverviewElement> syncOverviewList = new ArrayList<SyncOverviewElement>();
        long noOfUsers = this.getNoOfSyncUsers(cloudId, cloud);
        for (DailySyncOverView syncOverview : list) {
            if (syncOverview == null) continue;
            SyncOverviewElement syncOverviewElement = new SyncOverviewElement();
            syncOverviewElement.setTotalUsers(Long.toString(noOfUsers));
            syncOverviewElement.setTotalFilesShared(Long.toString(syncOverview.getTotalFilesShared()));
            syncOverviewElement.setTotalFilesDownloaded(Long.toString(syncOverview.getTotalFilesDownloaded()));
            syncOverviewElement.setTotalSizeUploaded(ReportServiceImpl.formatFileSize(syncOverview.getTotalSizeUploaded()));
            syncOverviewElement.setTotalSizeDownloaded(ReportServiceImpl.formatFileSize(syncOverview.getTotalSizeDownloaded()));
            String date = "";
            try {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy");
                Date dateD = new Date(syncOverview.getOverViewDate());
                date = df2.format(dateD);
            }
            catch (NumberFormatException e) {
                logger.trace(NUMBER_FORMAT_EXCEPTION + e);
                logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
            syncOverviewElement.setOverViewDate(date);
            syncOverviewList.add(syncOverviewElement);
        }
        return syncOverviewList;
    }

    @Override
    public boolean createExcelForSyncOverview(int cloudId, Cloud cloud, String startDate, String endDate) {
        List list = this.consolidatedImageDao.getDailySyncOverView(cloudId, Long.valueOf(ReportServiceImpl.getStartOfDay(startDate)), Long.valueOf(ReportServiceImpl.getEndOfDay(endDate)));
        this.createExcelForSyncOverviewList(cloudId, cloud, list, startDate, endDate);
        return true;
    }

    private void createExcelForSyncOverviewList(int cloudId, Cloud cloud, List<DailySyncOverView> list, String startDate, String endDate) {
        if (!list.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for sync overview ...");
                long noOfUsers = this.getNoOfSyncUsers(cloudId, cloud);
                List<List> recordToAdd = ReportServiceImpl.updateValuesToExcelForSyncOverview(list, noOfUsers, startDate, endDate);
                this.createExcelForXlsx(recordToAdd, workbook);
                this.writeExcelForSync(workbook);
                logger.debug(" After creating excel for sync overview ...");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    private long getNoOfSyncUsers(int cloudId, Cloud cloud) {
        boolean isSyncEnabledForCloud = this.isSyncEnabledForCloud(cloud);
        long noOfUsers = isSyncEnabledForCloud ? this.userDao.countOfPresentUsers(cloudId, cloud.getCloudName(), true) : this.userDao.countOfPresentSyncUsers(1, "", true);
        return noOfUsers;
    }

    private boolean isSyncEnabledForCloud(Cloud cloud) {
        boolean isSyncEnabled = false;
        List list = cloud.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (!"Sync Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isSyncEnabled = true;
                break;
            }
        }
        return isSyncEnabled;
    }

    private static List<List> updateValuesToExcelForSyncOverview(List<DailySyncOverView> list, long noOfUsers, String startDate, String endDate) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("Overview Date");
        headerRow.add("Users");
        headerRow.add("Total Files Shared");
        headerRow.add("Total Files Downloaded");
        headerRow.add("Total Size uploaded ");
        headerRow.add("Total Size Downloaded ");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> userInputsRow = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)startDate) && StringUtils.isNotEmpty((String)endDate)) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(startDate)) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(endDate)));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (DailySyncOverView syncOverviewElement : list) {
            ArrayList<String> firstRow = new ArrayList<String>();
            String date = "";
            try {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy");
                Date dateD = new Date(syncOverviewElement.getOverViewDate());
                date = df2.format(dateD);
            }
            catch (NumberFormatException e) {
                logger.trace(NUMBER_FORMAT_EXCEPTION + e);
                logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
            }
            firstRow.add(date);
            firstRow.add(Long.toString(noOfUsers));
            firstRow.add(Long.toString(syncOverviewElement.getTotalFilesShared()));
            firstRow.add(Long.toString(syncOverviewElement.getTotalFilesDownloaded()));
            firstRow.add(ReportServiceImpl.formatFileSize(syncOverviewElement.getTotalSizeUploaded()));
            firstRow.add(ReportServiceImpl.formatFileSize(syncOverviewElement.getTotalSizeDownloaded()));
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    void writeExcelForSync(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/Sync_OverviewStatus.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public void createExcelForSyncOverview(int cloudId) {
        ArrayList existingUserIDList = new ArrayList();
        logger.debug("@@EXCEL Create elements for excel for users who has done sync no code....");
        ArrayList<SyncOverviewExcelElement> syncOverviewExcelElementsList = new ArrayList<SyncOverviewExcelElement>();
        logger.debug("@@EXCEL After Create elements for excel for users who has done sync ...." + syncOverviewExcelElementsList.size());
        logger.debug("@@EXCEL start Get users who has not sync up ....");
        List usersNotConnectedToDevice = this.userDao.getUsersNotConnectedToDevice(cloudId, existingUserIDList, true);
        logger.debug("@@EXCEL End of Get users who has not sync up ....");
        for (Object user : usersNotConnectedToDevice) {
            if (user == null) continue;
            try {
                SyncOverviewExcelElement element = new SyncOverviewExcelElement();
                String userName = user.getUserName();
                element.setPolicyName(user.getPolicyName());
                element.setDeviceName("");
                element.setUserId(userName);
                element.setEmailId(user.getEmailId());
                if (user.getUserSyncOverView() != null) {
                    element.setStorageUtilized(ReportServiceImpl.formatFileSize((long)user.getUserSyncOverView().getStorageUtilized()));
                } else {
                    element.setStorageUtilized(ReportServiceImpl.formatFileSize(0L));
                }
                element.setUserActive(user.isActive());
                element.setLastBkpStartTime(user.getLastLoggedInTime());
                syncOverviewExcelElementsList.add(element);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(ERROR_TRYING_TO_ADD_USER + user.getUserName() + MSG + e.getMessage());
            }
        }
        Long currentmills = System.currentTimeMillis();
        for (SyncOverviewExcelElement element : syncOverviewExcelElementsList) {
            element.setOverviewJobTime(String.valueOf(currentmills));
        }
        Comparator<SyncOverviewExcelElement> comparator = Comparator.comparing(SyncOverviewExcelElement::getUserId).thenComparing(SyncOverviewExcelElement::getDeviceName);
        syncOverviewExcelElementsList.stream().filter(Objects::nonNull).sorted(comparator);
        logger.debug("@@EXCEL Before create excel sync....");
        this.createSyncExcelForXlsx(cloudId, syncOverviewExcelElementsList);
        logger.debug("@@EXCEL After create excel sync....");
    }

    private Long getDate(String date) {
        SimpleDateFormat f = new SimpleDateFormat(MM_DD_YYYY);
        Long milliseconds = null;
        try {
            Date d = f.parse(date);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            logger.trace("ParseException  " + e);
            logger.error("ParseException  " + e.getMessage());
        }
        return milliseconds;
    }

    private static long getStartOfDay(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public List<DailyUserBackupOverViewElement> getDailyUserBackupOverview(Cloud cloud, ReportQueryElement reportQueryElement) {
        ArrayList userNames = new ArrayList();
        ArrayList<DeviceBackupOverView> list = new ArrayList();
        int cloudId = cloud.getCloudId();
        logger.debug("....storage ustilization newdao....");
        list = this.deviceDao.getDeviceBackupOVerviewList(cloudId, reportQueryElement);
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("..storage utiliz result ..." + list.size());
        }
        List<DailyUserBackupOverViewElement> overviewList = this.getDailyUserBkpoverElement(cloudId, list);
        return overviewList;
    }

    @Override
    public List<DailyUserBackupOverViewElement> getDailyUserBackupOverviewForReport(int cloudId, ReportQueryElement reportQueryElement) {
        ArrayList userNames = new ArrayList();
        ArrayList<DeviceBackupOverView> list = new ArrayList();
        logger.debug("....storage ustilization newdao....");
        list = this.deviceDao.getAllDeviceBackupOVerviewList(cloudId, reportQueryElement);
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("..storage utiliz result ..." + list.size());
        }
        List<DailyUserBackupOverViewElement> overviewList = this.getDailyUserBkpoverElement(cloudId, list);
        return overviewList;
    }

    @Override
    public long getCountStorageUtilizeReport(Cloud cloud, ReportQueryElement reportQueryElement) {
        int cloudId = cloud.getCloudId();
        return this.deviceDao.getCountStorageUtilizeReport(cloudId, reportQueryElement);
    }

    void writeExcelForReport(XSSFWorkbook workbook, String filename) {
        try (FileOutputStream fos = new FileOutputStream(new File(filename));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private List<DailyUserBackupOverViewElement> getDailyUserBkpoverElement(int cloudId, List<DeviceBackupOverView> list) {
        ArrayList<DailyUserBackupOverViewElement> overViewList = new ArrayList<DailyUserBackupOverViewElement>();
        for (DeviceBackupOverView overview : list) {
            DailyUserBackupOverViewElement dailyUserBackupOverViewElement = new DailyUserBackupOverViewElement();
            dailyUserBackupOverViewElement.setDeviceUUID(overview.getDeviceUUID());
            dailyUserBackupOverViewElement.setDeviceName(overview.getDeviceName());
            dailyUserBackupOverViewElement.setUserName(overview.getUserName());
            dailyUserBackupOverViewElement.setPolicyName(overview.getPolicyName());
            long storageUtilizedInCloud = 0L;
            if (overview.getStorageUtilizedInCloud() > 0L) {
                storageUtilizedInCloud = overview.getStorageUtilizedInCloud();
            }
            long pgStorageSizeInKB = 0L;
            pgStorageSizeInKB = overview.getStorageUtilizedInPg();
            if (pgStorageSizeInKB < 0L) {
                pgStorageSizeInKB = 0L;
            }
            String fileSizePg = ReportServiceImpl.formatFileSize(pgStorageSizeInKB);
            dailyUserBackupOverViewElement.setStorageUsedInPg(fileSizePg);
            dailyUserBackupOverViewElement.setStorageUsedInPgInKB(pgStorageSizeInKB);
            if (PCHelperConstant.getEnableCloudSizeLogic()) {
                long actualSizeUtilized = storageUtilizedInCloud + pgStorageSizeInKB;
                long tempCloudSize = storageUtilizedInCloud;
                if (actualSizeUtilized > overview.getStorageUtilized() && storageUtilizedInCloud > 0L) {
                    logger.debug("actualSizeUtilized " + actualSizeUtilized + " is greater then storageUtilized " + actualSizeUtilized + " storageUtilizedInCloud " + storageUtilizedInCloud);
                    tempCloudSize = overview.getStorageUtilized() - pgStorageSizeInKB;
                    if (tempCloudSize < storageUtilizedInCloud) {
                        storageUtilizedInCloud = tempCloudSize;
                    }
                }
            }
            String fileSizeCloud = ReportServiceImpl.formatFileSize(storageUtilizedInCloud);
            dailyUserBackupOverViewElement.setStorageUsedInCloud(fileSizeCloud);
            dailyUserBackupOverViewElement.setStorageUsedInCloudInKB(storageUtilizedInCloud);
            dailyUserBackupOverViewElement.setActualStorageUtilized(ReportServiceImpl.formatFileSize(storageUtilizedInCloud + pgStorageSizeInKB));
            dailyUserBackupOverViewElement.setActualStorageUtilizedInKB(storageUtilizedInCloud + pgStorageSizeInKB);
            dailyUserBackupOverViewElement.setStorageUtilized(ReportServiceImpl.formatFileSize(overview.getStorageUtilized()));
            dailyUserBackupOverViewElement.setStorageUtilizedInKB(overview.getStorageUtilized());
            long LatestVersionsSize = 0L;
            List allBackupInfoList = this.deviceDao.getAllLatestDeviceBkpInfo(cloudId, overview.getDeviceUUID());
            for (LatestDeviceBackupInfo bkpInfo : allBackupInfoList) {
                LatestVersionsSize += bkpInfo.getLatestVersionsSize();
            }
            dailyUserBackupOverViewElement.setTotalSizeOfDataInCurrentBackupLatestVersion(ReportServiceImpl.formatFileSize(LatestVersionsSize));
            dailyUserBackupOverViewElement.setTotalSizeOfDataInCurrentBackupLatestVersionInKB(LatestVersionsSize);
            String compressionRatio = this.getCompressedSize(overview.getStorageUtilized(), storageUtilizedInCloud + pgStorageSizeInKB);
            dailyUserBackupOverViewElement.setTotalSizeOfBackupFileCompressionRatio(compressionRatio);
            overViewList.add(dailyUserBackupOverViewElement);
        }
        return overViewList;
    }

    @Override
    public boolean createExcelForDailyBkpOverview(Cloud cloud, ReportQueryElement reportQueryElement, boolean isShowLatestBkpInfo, boolean isHideCompressedSize) {
        int cloudId = cloud.getCloudId();
        List<DeviceBackupOverView> list = new ArrayList();
        list = this.deviceDao.getDeviceBackupOVerviewList(cloudId, reportQueryElement);
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("..storage utilize result ..." + list.size());
            List<DailyUserBackupOverViewElement> overviewList = this.getDailyUserBkpoverElement(cloudId, list);
            this.createExcelForDailyUserBackupOverViewList(cloudId, overviewList, isShowLatestBkpInfo, isHideCompressedSize, reportQueryElement.getDisplayName(), reportQueryElement);
            return true;
        }
        return false;
    }

    private static long getEndOfDay(long millis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTimeInMillis();
    }

    private static List<List> updateValuesToExcelForDailyBkpOverview(List<DailyUserBackupOverViewElement> list, boolean isShowLatestBkpInfo, boolean isHideCompressedSize, ReportQueryElement reportQueryElement) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_ID);
        headerRow.add("Asset Name");
        if (!PCHelperConstant.isHideStorageSizeOnServer()) {
            headerRow.add(STORAGE_SIZE_IN_SERVER);
        }
        if (!PCHelperConstant.isHideStorageSizeInCloud()) {
            headerRow.add(STORAGE_SIZE_IN_CLOUD);
        }
        headerRow.add(ACTUAL_STORAGE_UTILIZED);
        headerRow.add(TOTAL_SIZE_OF_DATA_BACKED_UP);
        if (!isHideCompressedSize) {
            headerRow.add(COMPRESSION_RATIO);
        }
        if (isShowLatestBkpInfo) {
            headerRow.add(ACTUAL_SIZE_OF_RESTORE_DATA);
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            userInputsRow.add(policyName + policyNames + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            userInputsRow.add(userName + reportQueryElement.getUserName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            userInputsRow.add(deviceName + reportQueryElement.getDeviceName());
        }
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (DailyUserBackupOverViewElement dailyUserBackupOverView : list) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add("" + dailyUserBackupOverView.getUserName());
            firstRow.add("" + dailyUserBackupOverView.getDeviceName());
            String date = "";
            try {
                SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy");
                Date dateD = new Date(dailyUserBackupOverView.getStorageDate());
                date = df2.format(dateD);
            }
            catch (NumberFormatException e) {
                logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
                logger.debug(NUMBER_FORMAT_EXCEPTION + e);
            }
            if (!PCHelperConstant.isHideStorageSizeOnServer()) {
                firstRow.add("" + dailyUserBackupOverView.getStorageUsedInPg());
            }
            if (!PCHelperConstant.isHideStorageSizeInCloud()) {
                firstRow.add("" + dailyUserBackupOverView.getStorageUsedInCloud());
            }
            firstRow.add("" + dailyUserBackupOverView.getActualStorageUtilized());
            firstRow.add("" + dailyUserBackupOverView.getStorageUtilized());
            if (!isHideCompressedSize) {
                firstRow.add(dailyUserBackupOverView.getTotalSizeOfBackupFileCompressionRatio());
            }
            if (isShowLatestBkpInfo) {
                if (StringUtils.isNotEmpty((String)dailyUserBackupOverView.getTotalSizeOfDataInCurrentBackupLatestVersion())) {
                    firstRow.add("" + dailyUserBackupOverView.getTotalSizeOfDataInCurrentBackupLatestVersion());
                } else {
                    firstRow.add("0 MB");
                }
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private void createExcelForDailyUserBackupOverViewList(int cloudId, List<DailyUserBackupOverViewElement> list, boolean isShowLatestBkpInfo, boolean isHideCompressedSize, String shedulerName, ReportQueryElement reportQueryElement) {
        if (!list.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for Daily user backup overview ...");
                List<List> recordToAdd = ReportServiceImpl.updateValuesToExcelForDailyBkpOverview(list, isShowLatestBkpInfo, isHideCompressedSize, reportQueryElement);
                this.createExcelForXlsx(recordToAdd, workbook);
                this.writeExcelForDailyBkpOverview(workbook, shedulerName);
                logger.debug(" After creating excel for sync overview ...");
            }
            catch (Exception e) {
                logger.error(EXCEPTION + e.getMessage());
                logger.debug(EXCEPTION + e);
            }
        }
    }

    void writeExcelForDailyBkpOverview(XSSFWorkbook workbook, String shedulerName) {
        String fileName = "Storage_Utilization_Report.xlsx";
        if (!StringUtils.isEmpty((String)shedulerName)) {
            fileName = "Storage_Utilization_Report_From_Scheduler_" + shedulerName + ".xlsx";
        }
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public long getCountAllOverviews(Cloud cloud, ReportQueryElement reportQueryElement) {
        if (!reportQueryElement.isUserWithoutDeviceEnabled()) {
            return this.deviceDao.getCountAllOverviews(cloud.getCloudId(), reportQueryElement.getPolicyNames(), "ALL");
        }
        return this.userDao.getAllUsersCountByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), ReportServiceImpl.isODBEnabled(cloud.getCloudCustomisableDetails()));
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverviewElementsByNewQuery(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        DeviceBackupOverView deviceOver;
        List<Object> bkpOverViewuserNames;
        List<DeviceBackupOverView> deviceOverviews = new ArrayList();
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        List<Object> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            User user2 = this.userDao.getUserInfoByName(cloud.getCloudId(), cloud.getCloudName(), reportQueryElement.getUserName());
            if (!user2.isGuest() && !user2.isSuperAdmin()) {
                users.add(user2);
            }
        } else {
            List usersList = this.userDao.getAllUsers(cloud.getCloudId());
            for (User ue : usersList) {
                if (ue.isGuest() || ue.isSuperAdmin()) continue;
                users.add(ue);
            }
        }
        if (SHARE_POINT.equals(productType)) {
            users = users.stream().filter(user -> user.getSpPolicyName() != null && !user.getSpPolicyName().isEmpty()).collect(Collectors.toList());
        } else if (ODB.equals(productType)) {
            users = users.stream().filter(user -> user.getOneDrivePolicyName() != null && !user.getOneDrivePolicyName().isEmpty()).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            deviceOverviews = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            logger.debug(deviceOverviews.size() + "..policynames..." + reportQueryElement.getPolicyNames());
            logger.debug("...isUserWithoutDeviceEnabled.." + isUserWithoutDeviceEnabled);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty(deviceOverviews)) {
                    bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        logger.debug("..check user...." + ((User)usersByPolicyName.get(i)).getUserName());
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(user2);
                        deviceOverviews.add(deviceOver);
                    }
                    logger.debug("..deviceOverviews....." + deviceOverviews.size());
                } else {
                    List usersList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
                    logger.debug("...");
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceBackupOverView = new DeviceBackupOverView();
                        if (userDetails == null) continue;
                        DeviceBackupOverView deviceBackupOverView2 = this.setUserWithoutDeviceElementvalue(userDetails);
                        deviceOverviews.add(deviceBackupOverView2);
                    }
                }
            }
            logger.debug("..deviceOverviews....." + deviceOverviews.size());
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            deviceOverviews = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloud.getCloudId(), reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(deviceOverviews)) {
                User user3 = (User)users.get(0);
                DeviceBackupOverView deviceOver3 = new DeviceBackupOverView();
                if (user3 != null) {
                    deviceOver3 = this.setUserWithoutDeviceElementvalue(user3);
                    deviceOverviews.add(deviceOver3);
                }
            }
            logger.debug("..deviceOverviews....." + deviceOverviews.size());
        } else {
            deviceOverviews = this.deviceDao.getAllOverviewsForProductType(cloud.getCloudId(), productType);
            logger.debug(productType + ".... bkp overview report.." + deviceOverviews.size());
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user4 = (User)users.get(i);
                    deviceOver = new DeviceBackupOverView();
                    if (user4 == null) continue;
                    deviceOver = this.setUserWithoutDeviceElementvalue(user4);
                    deviceOverviews.add(deviceOver);
                }
            }
        }
        ArrayList<DeviceBackupOverView> newOverViewList = new ArrayList<DeviceBackupOverView>();
        logger.debug(deviceOverviews.size() + "..deviceOverviews before processing....." + backupOverviewElementsList.size());
        for (DeviceBackupOverView bkpOVerview : deviceOverviews) {
            for (User user4 : users) {
                if (!bkpOVerview.getUserName().equalsIgnoreCase(user4.getUserName())) continue;
                if (user4 != null && productType.equalsIgnoreCase("BACKUP") && (user4.isBackupEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (user4 != null && productType.equalsIgnoreCase(ODB) && (user4.isOnedriveBkpEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (user4 != null && productType.equalsIgnoreCase("OUTLOOK") && (user4.isExchangeBkpEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (user4 == null || !productType.equalsIgnoreCase("SHAREPOINT") || !user4.isSite() && user4.isActive()) continue;
                newOverViewList.add(bkpOVerview);
            }
        }
        backupOverviewElementsList = this.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, newOverViewList, reportQueryElement.isShowBlockedUsers(), reportQueryElement.isShowBlockedDevices(), productType);
        logger.debug(deviceOverviews.size() + "..backupOverviewElementsList....." + backupOverviewElementsList.size());
        ArrayList<BackupOverviewElement> bkpOverviewElementsList = new ArrayList<BackupOverviewElement>();
        for (BackupOverviewElement backupOverviewElement : backupOverviewElementsList) {
            String lastBkpStatus;
            boolean bl = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime());
            long percentage = 0L;
            percentage = backupOverviewElement.getTotalSizeToUploadInKB() != 0L && backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalSizeToUploadInKB(), backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOsType()) && backupOverviewElement.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                percentage = ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            }
            if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                lastBkpStatus = "";
            }
            boolean isDeviceActive = backupOverviewElement.isDeviceActive();
            boolean isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && !"STOPPED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
            String lstBkpStartTimeStr = "";
            if (!StringUtils.isEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && isBackupRunning && StringUtils.isNotEmpty((String)(lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime())) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                long lstsuccessBkpEndTime;
                long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpStartTime());
                if (lstBkpStartTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                }
                lstBkpStartTimeStr = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy HH:mm:ss");
            }
            String percent = "-";
            if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && !lastBkpStatus.equalsIgnoreCase(COMPLETED) && !lastBkpStatus.equalsIgnoreCase(STATUS_SANNING) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining())) {
                percent = String.valueOf(percentage) + "%";
            }
            String lastHeardDate = "";
            if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                long lstsuccessBkpEndTime;
                String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                    lastHeardDate = lastAccessTime;
                } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                    lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                } else {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                        Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                        Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                        lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                    }
                    catch (Exception e) {
                        logger.error("...unable to process date...... " + e.getMessage());
                        logger.trace(EXCEPTION + e);
                    }
                }
                long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                }
            }
            if (StringUtils.isEmpty((String)lastHeardDate) && StringUtils.isNotEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                lastHeardDate = ReportServiceImpl.getDateInFormat(Long.parseLong(backupOverviewElement.getEpaInstallationDate()), "dd-MMM-yyyy HH:mm:ss");
            }
            backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer(percent);
            backupOverviewElement.setBackupRunning(isBackupRunning);
            backupOverviewElement.setFirstBackupCompleted(bl);
            backupOverviewElement.setCurrentBkpStartTime(lstBkpStartTimeStr);
            if (StringUtils.isNotEmpty((String)lastBkpStatus) && lastBkpStatus.equalsIgnoreCase(COMPLETED)) {
                backupOverviewElement.setCurrentBkpStatus("-");
            } else {
                backupOverviewElement.setCurrentBkpStatus(lastBkpStatus);
            }
            backupOverviewElement.setLastHeardTime(lastHeardDate);
            backupOverviewElement.setLastHeardTimeInMillis(ReportServiceImpl.getTime(lastHeardDate));
            if (!StringUtils.isNotEmpty((String)lastBkpStatus) || !lastBkpStatus.equalsIgnoreCase(STATUS_STARTED)) {
                backupOverviewElement.setCurrentlyRunningBkpNoOfFiles(0L);
                backupOverviewElement.setCurrentlyRunningBkpTotalSizeOfFiles("-");
                backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer("-");
            }
            bkpOverviewElementsList.add(backupOverviewElement);
        }
        return bkpOverviewElementsList;
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverviewElementsByQuery(Cloud cloud, ReportQueryElement reportQueryElement, boolean isODBBackupEnabled, int skipValue, String productType) {
        DeviceBackupOverView deviceOver;
        List<Object> bkpOverViewuserNames;
        List deviceOverviews;
        User user;
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        ArrayList<User> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            user = this.userDao.getUserInfoByName(cloud.getCloudId(), cloud.getCloudName(), reportQueryElement.getUserName());
            users.add(user);
        } else {
            List usersList = this.userDao.getAllUsers(cloud.getCloudId(), skipValue, reportQueryElement.getRowsPerPage());
            users.addAll(usersList);
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            deviceOverviews = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), isODBBackupEnabled, skipValue, reportQueryElement.getRowsPerPage());
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)deviceOverviews)) {
                    bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), isODBBackupEnabled, skipValue, reportQueryElement.getRowsPerPage());
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(user2);
                        deviceOverviews.add(deviceOver);
                    }
                    logger.debug("..deviceOverviews....." + deviceOverviews.size());
                } else {
                    List usersList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), isODBBackupEnabled, skipValue, reportQueryElement.getRowsPerPage());
                    logger.debug("...");
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceOver2 = new DeviceBackupOverView();
                        if (userDetails == null) continue;
                        deviceOver2 = this.setUserWithoutDeviceElementvalue(userDetails);
                        deviceOverviews.add(deviceOver2);
                    }
                }
            }
            logger.debug("..deviceOverviews....." + deviceOverviews.size());
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            deviceOverviews = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloud.getCloudId(), reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty((Collection)deviceOverviews)) {
                user = (User)users.get(0);
                DeviceBackupOverView deviceOver3 = new DeviceBackupOverView();
                if (user != null) {
                    deviceOver3 = this.setUserWithoutDeviceElementvalue(user);
                    deviceOverviews.add(deviceOver3);
                }
            }
            logger.debug("..deviceOverviews....." + deviceOverviews.size());
        } else {
            deviceOverviews = this.deviceDao.getAllOverviews(cloud.getCloudId(), skipValue, reportQueryElement.getRowsPerPage());
            logger.debug("..." + deviceOverviews.size());
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user3 = (User)users.get(i);
                    deviceOver = new DeviceBackupOverView();
                    if (user3 == null) continue;
                    deviceOver = this.setUserWithoutDeviceElementvalue(user3);
                    deviceOverviews.add(deviceOver);
                }
            }
        }
        logger.debug(deviceOverviews.size() + "..deviceOverviews before processing....." + backupOverviewElementsList.size());
        backupOverviewElementsList = this.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, deviceOverviews, reportQueryElement.isShowBlockedUsers(), reportQueryElement.isShowBlockedDevices(), productType);
        logger.debug(deviceOverviews.size() + "..backupOverviewElementsList....." + backupOverviewElementsList.size());
        ArrayList<BackupOverviewElement> bkpOverviewElementsList = new ArrayList<BackupOverviewElement>();
        for (BackupOverviewElement backupOverviewElement : backupOverviewElementsList) {
            String lastBkpStatus;
            logger.debug("...user.. storage utilized... " + backupOverviewElement.getUserId() + "....." + backupOverviewElement.getStorageUtilized());
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime());
            long percentage = 0L;
            percentage = backupOverviewElement.getTotalSizeToUploadInKB() != 0L && backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalSizeToUploadInKB(), backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOsType()) && backupOverviewElement.getOsType().equalsIgnoreCase(Device.TYPE.OUTLOOK.name())) {
                percentage = ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            }
            if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                lastBkpStatus = "";
            }
            boolean isDeviceActive = backupOverviewElement.isDeviceActive();
            boolean isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && !"STOPPED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
            String lstBkpStartTimeStr = "";
            if (!StringUtils.isEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && isBackupRunning && StringUtils.isNotEmpty((String)(lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime())) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                long lstsuccessBkpEndTime;
                long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpStartTime());
                if (lstBkpStartTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                }
                lstBkpStartTimeStr = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy HH:mm:ss");
            }
            String percent = "";
            if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && !lastBkpStatus.equalsIgnoreCase(COMPLETED) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isBackupRunning) {
                percent = String.valueOf(percentage) + "%";
            }
            String lastHeardDate = "";
            if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                long lstsuccessBkpEndTime;
                String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                    lastHeardDate = lastAccessTime;
                } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                    lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                } else {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                        Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                        Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                        lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                    }
                    catch (Exception e) {
                        logger.error("...unable to process date...... " + e.getMessage());
                        logger.trace(EXCEPTION + e);
                    }
                }
                long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                }
            }
            if (StringUtils.isEmpty((String)lastHeardDate) && StringUtils.isNotEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                lastHeardDate = ReportServiceImpl.getDateInFormat(Long.parseLong(backupOverviewElement.getEpaInstallationDate()), "dd-MMM-yyyy HH:mm:ss");
            }
            backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer(percent);
            backupOverviewElement.setBackupRunning(isBackupRunning);
            logger.debug("...isBackupRunning......" + isBackupRunning);
            backupOverviewElement.setFirstBackupCompleted(isFirstBkpCompleted);
            backupOverviewElement.setCurrentBkpStartTime(lstBkpStartTimeStr);
            if (lastBkpStatus.equalsIgnoreCase(COMPLETED) || !isBackupRunning) {
                backupOverviewElement.setCurrentBkpStatus("-");
            } else {
                backupOverviewElement.setCurrentBkpStatus(lastBkpStatus);
            }
            backupOverviewElement.setLastHeardTime(lastHeardDate);
            backupOverviewElement.setLastHeardTimeInMillis(ReportServiceImpl.getTime(lastHeardDate));
            if (!isBackupRunning) {
                backupOverviewElement.setCurrentlyRunningBkpNoOfFiles(0L);
                backupOverviewElement.setCurrentlyRunningBkpTotalSizeOfFiles("");
                backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer("");
            }
            bkpOverviewElementsList.add(backupOverviewElement);
        }
        return bkpOverviewElementsList;
    }

    private DeviceBackupOverView setUserWithoutDeviceElementvalue(User user) {
        DeviceBackupOverView deviceBkpOverView = new DeviceBackupOverView();
        try {
            if (!StringUtils.isEmpty((String)user.getUserName())) {
                deviceBkpOverView.setUserName(user.getUserName());
            } else {
                deviceBkpOverView.setUserName("");
            }
            if (!StringUtils.isEmpty((String)user.getEmailId())) {
                deviceBkpOverView.setEmailId(user.getEmailId());
            } else {
                deviceBkpOverView.setEmailId("");
            }
            if (!StringUtils.isEmpty((String)user.getPolicyName())) {
                deviceBkpOverView.setPolicyName(user.getPolicyName());
            } else {
                deviceBkpOverView.setPolicyName("");
            }
            if (!StringUtils.isEmpty((String)user.getLocation())) {
                deviceBkpOverView.setLocation(user.getLocation());
            } else {
                deviceBkpOverView.setLocation("");
            }
            if (!StringUtils.isEmpty((String)user.getDepartment())) {
                deviceBkpOverView.setDepartment(user.getDepartment());
            } else {
                deviceBkpOverView.setDepartment("");
            }
            deviceBkpOverView.setAccountStatus(user.isAccountStatus());
            deviceBkpOverView.setUserActive(user.isActive());
            deviceBkpOverView.setUserDeleted(user.isDeleted());
            deviceBkpOverView.setDisplayName(user.getDisplayName());
            deviceBkpOverView.setPolicyUpdatedTime(user.getPolicyModifiedTime());
            deviceBkpOverView.setClientVersion("");
            deviceBkpOverView.setDeviceBolcked(false);
            deviceBkpOverView.setEpaInstallationDate("");
            deviceBkpOverView.setDeviceUUID("");
            deviceBkpOverView.setFirstBkpEndTime("");
            deviceBkpOverView.setTotalNoOfFiles("");
            deviceBkpOverView.setStorageUtilizedInCloud(0L);
            deviceBkpOverView.setId(user.getUserId());
            deviceBkpOverView.setLastBkpEndTime("");
            deviceBkpOverView.setLastSuccessfulBackupStartTime(0L);
            deviceBkpOverView.setLastSuccessfulBackupEndTime(0L);
            deviceBkpOverView.setReason("");
            deviceBkpOverView.setFirstBkpStartTime("");
            deviceBkpOverView.setDeviceName("");
            deviceBkpOverView.setLastBkpStartTime("");
            deviceBkpOverView.setLastBkpStatus("");
            deviceBkpOverView.setNoOfFilesRemaining("");
            deviceBkpOverView.setNoOfSuccessfulBackups(0L);
            deviceBkpOverView.setNoOfSuccessfulRestores(0L);
            deviceBkpOverView.setLastSuccessfulBkp("");
            deviceBkpOverView.setLastHeardTime(0L);
            deviceBkpOverView.setStorageUtilized(0L);
            deviceBkpOverView.setOneDrivePolicyName(user.getOneDrivePolicyName());
            deviceBkpOverView.setExchangePolicyName(user.getExchangePolicyName());
            deviceBkpOverView.setSpPolicyName(user.getSpPolicyName());
            deviceBkpOverView.setDeviceDeleted(false);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return deviceBkpOverView;
    }

    @Override
    public List<BackupOverviewElement> getAllBackupOverviewElementsForUser(Cloud cloud, String userName1, String deviceName, int skipValue, String productType) {
        String userName = userName1;
        ArrayList<User> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)userName)) {
            User user = this.userDao.getUserInfoByName(cloud.getCloudId(), cloud.getCloudName(), userName);
            users.add(user);
        } else {
            List usersList = this.userDao.getAllUsers(cloud.getCloudId(), cloud.getCloudName(), skipValue, false, "false");
            users.addAll(usersList);
        }
        List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        List deviceOverviews = StringUtils.isEmpty((String)userName) ? this.deviceDao.getAllOverviews(cloud.getCloudId(), skipValue) : this.deviceDao.getDeviceBkpOverviewForUserName(cloud.getCloudId(), userName);
        backupOverviewElementsList = this.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, deviceOverviews, true, true, productType);
        return backupOverviewElementsList;
    }

    @Override
    public List<DevicePolicyDetailsElement> getLastAgentServerConnectionDetails(Cloud cloud, ReportQueryElement reportQueryElement) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -reportQueryElement.getNoOfDays());
        long noOfDaysMilliSecounds = cal.getTimeInMillis();
        return this.getLastAgentServerConnectionData(cloud, noOfDaysMilliSecounds, reportQueryElement);
    }

    @Override
    public List<DevicePolicyDetailsElement> getCapacityMgmtDeviceDetails(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        return this.getCapacityMgmtDeviceDetailsValues(cloud, reportQueryElement, productType);
    }

    @Override
    public long countOfLastAgentServerConnectionDetails(Cloud cloud, ReportQueryElement reportQueryElement) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -reportQueryElement.getNoOfDays());
        long noOfDaysMilliSecounds = cal.getTimeInMillis();
        return this.getTotalCountOfLastAgentServerConnectionData(cloud, noOfDaysMilliSecounds, reportQueryElement);
    }

    @Override
    public boolean generateReportForAgentLastServerConection(Cloud cloud, ReportQueryElement reportQueryElement) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -reportQueryElement.getNoOfDays());
        long noOfDaysInMilliSecounds = cal.getTimeInMillis();
        List<DevicePolicyDetailsElement> devicePolicyDetailsElements = this.getLastAgentServerConnectionData(cloud, noOfDaysInMilliSecounds, reportQueryElement);
        return this.createExcelForLastAgentServerTimer(devicePolicyDetailsElements, reportQueryElement, true);
    }

    @Override
    public boolean generateReportForAgentLastServerConectionInComplete(Cloud cloud, ReportQueryElement reportQueryElement) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -reportQueryElement.getNoOfDays());
        long noOfDaysInMilliSecounds = cal.getTimeInMillis();
        List<DevicePolicyDetailsElement> devicePolicyDetailsElements = this.getLastAgentServerConnectionData(cloud, noOfDaysInMilliSecounds, reportQueryElement);
        return this.createExcelForLastAgentServerTimerINcompleteBkp(devicePolicyDetailsElements, true, reportQueryElement);
    }

    @Override
    public boolean generateReportForUserWitoutAgentInComplete(Cloud cloud, List<DevicePolicyDetailsElement> devicePolicyDetailsElements, ReportQueryElement reportQueryElement) {
        return this.createExcelForLastAgentServerTimerINcompleteBkp(devicePolicyDetailsElements, false, reportQueryElement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createExcelForLastAgentServerTimer(List<DevicePolicyDetailsElement> devicePolicyDetailsElements, ReportQueryElement reportQueryElement, boolean isHeartBeatRep) {
        if (devicePolicyDetailsElements.isEmpty()) {
            logger.debug(" No record found for create excel For Last Agent to Server");
            return false;
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            logger.debug(" Before creating excel for Agent last connection ...");
            List<List> recordToAdd = ReportServiceImpl.updateValuesForLastAgentToServerTimer(devicePolicyDetailsElements, isHeartBeatRep, reportQueryElement);
            this.createExcelForXlsx(recordToAdd, workbook);
            boolean bl = this.writeLastAgentToServerSummeryForXlsx(workbook, reportQueryElement);
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createExcelForLastAgentServerTimerINcompleteBkp(List<DevicePolicyDetailsElement> devicePolicyDetailsElements, boolean isHeartBeatRep, ReportQueryElement reportQueryElement) {
        if (CollectionUtils.isEmpty(devicePolicyDetailsElements)) {
            logger.debug(" No record found for create excel For Last Agent to Server");
            return false;
        }
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            logger.debug(" Before creating excel for Agent last connection ...");
            List<List> recordToAdd = ReportServiceImpl.updateValuesForLastAgentToServerTimer(devicePolicyDetailsElements, isHeartBeatRep, reportQueryElement);
            this.createExcelForXlsx(recordToAdd, workbook);
            boolean bl = this.writeLastAgentToServerSummeryIncompleteBkpForXlsx(workbook);
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private List<DevicePolicyDetailsElement> getCapacityMgmtDeviceDetailsValues(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        ArrayList<DevicePolicyDetailsElement> elementList = new ArrayList<DevicePolicyDetailsElement>();
        List overViewList = new ArrayList();
        overViewList = this.deviceDao.getCPMgmtDeviceBkpOverviews(cloud.getCloudId(), reportQueryElement, productType);
        if (CollectionUtils.isEmpty(overViewList)) {
            overViewList = new ArrayList();
        }
        logger.debug("...overview list ... " + overViewList.size());
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView != null) {
                logger.debug("...device overview  ... " + deviceBackupOverView.getDeviceName() + "..." + deviceBackupOverView.getDeviceType());
                logger.debug("...device overview blocked ... " + deviceBackupOverView.isDeviceBolcked() + "..." + deviceBackupOverView.isUserDeleted());
            }
            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isUserDeleted() || deviceBackupOverView.isDeviceBolcked()) continue;
            DevicePolicyDetailsElement devicePolicyDetailsElement = new DevicePolicyDetailsElement();
            devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
            devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
            devicePolicyDetailsElement.setCpActualFileSize(deviceBackupOverView.getCpActualFileSize());
            devicePolicyDetailsElement.setCpCompressedStorage(deviceBackupOverView.getCpCompressedStorage());
            devicePolicyDetailsElement.setFormatedTime("-");
            elementList.add(devicePolicyDetailsElement);
        }
        return elementList;
    }

    private List<DevicePolicyDetailsElement> getLastAgentServerConnectionData(Cloud cloud, long noOfDaysMilliSeconds, ReportQueryElement reportQueryElement) {
        ArrayList<DevicePolicyDetailsElement> elementList = new ArrayList<DevicePolicyDetailsElement>();
        List overViewList = new ArrayList();
        boolean isODBBackupEanbled = ReportServiceImpl.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        overViewList = this.deviceDao.getLastAgentHeardDeviceBkpOverviews(cloud.getCloudId(), reportQueryElement);
        if (CollectionUtils.isEmpty(overViewList)) {
            overViewList = new ArrayList();
        }
        logger.debug("...overview list ... " + overViewList.size());
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView != null) {
                logger.debug("...device overview  ... " + deviceBackupOverView.getDeviceName() + "..." + deviceBackupOverView.getDeviceType());
                logger.debug("...device overview blocked ... " + deviceBackupOverView.isDeviceBolcked() + "..." + deviceBackupOverView.isUserDeleted());
            }
            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isUserDeleted() || deviceBackupOverView.isDeviceBolcked() || Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(deviceBackupOverView.getDeviceType())) continue;
            DevicePolicyDetailsElement devicePolicyDetailsElement = new DevicePolicyDetailsElement();
            long lastAgentHeard = deviceBackupOverView.getLastHeardTime();
            if (lastAgentHeard == 0L) {
                deviceBackupOverView.setLastHeardTime(Long.parseLong(deviceBackupOverView.getEpaInstallationDate()));
            }
            if (deviceBackupOverView.getLastHeardTime() > 0L) {
                if (deviceBackupOverView.getLastHeardTime() >= noOfDaysMilliSeconds) continue;
                devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
                devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
                lastAgentHeard = deviceBackupOverView.getLastHeardTime();
                devicePolicyDetailsElement.setFormatedTime(this.getDate(lastAgentHeard));
                devicePolicyDetailsElement.setFormatedTimeInMills(lastAgentHeard);
                elementList.add(devicePolicyDetailsElement);
                continue;
            }
            devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
            devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
            devicePolicyDetailsElement.setFormatedTime("-");
            elementList.add(devicePolicyDetailsElement);
        }
        return elementList;
    }

    private long getTotalCountOfLastAgentServerConnectionData(Cloud cloud, long noOfDaysMilliSeconds, ReportQueryElement reportQueryElement) {
        ArrayList<DevicePolicyDetailsElement> elementList = new ArrayList<DevicePolicyDetailsElement>();
        List overViewList = new ArrayList();
        boolean isODBBackupEanbled = ReportServiceImpl.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        overViewList = this.deviceDao.getLastAgentHeardDeviceBkpOverviews(cloud.getCloudId(), reportQueryElement);
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isUserDeleted() || deviceBackupOverView.isDeviceBolcked() || Device.TYPE.ONEDRIVE.toString().equalsIgnoreCase(deviceBackupOverView.getDeviceType())) continue;
            DevicePolicyDetailsElement devicePolicyDetailsElement = new DevicePolicyDetailsElement();
            long lastAgentHeard = deviceBackupOverView.getLastHeardTime();
            if (lastAgentHeard == 0L) {
                deviceBackupOverView.setLastHeardTime(Long.parseLong(deviceBackupOverView.getEpaInstallationDate()));
            }
            if (deviceBackupOverView.getLastHeardTime() > 0L) {
                if (deviceBackupOverView.getLastHeardTime() >= noOfDaysMilliSeconds) continue;
                devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
                devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
                lastAgentHeard = deviceBackupOverView.getLastHeardTime();
                devicePolicyDetailsElement.setFormatedTime(this.getDate(lastAgentHeard));
                devicePolicyDetailsElement.setFormatedTimeInMills(lastAgentHeard);
                elementList.add(devicePolicyDetailsElement);
                continue;
            }
            devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
            devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
            devicePolicyDetailsElement.setFormatedTime("-");
            elementList.add(devicePolicyDetailsElement);
        }
        return elementList.size();
    }

    private static List<List> updateValuesForLastAgentToServerTimer(List<DevicePolicyDetailsElement> devicePolicyDetailsExcelList, boolean isHeartBeatRep, ReportQueryElement reportQueryElement) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User Name ");
        headerRow.add("Asset Name");
        if (isHeartBeatRep) {
            headerRow.add("Last Server connection Date ");
            headerRow.add("Last Server connection time ");
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(policyName + policyNames + "   ");
        }
        sb.append(noOfDays + reportQueryElement.getNoOfDays() + "   ");
        if (StringUtils.isNotEmpty((String)reportQueryElement.getReason())) {
            sb.append(reason + reportQueryElement.getReason() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow2 = new ArrayList<String>();
        headerRow2.add(NOTE);
        recordToAdd.add(headerRow2);
        recordToAdd.add(headerRow);
        for (DevicePolicyDetailsElement devicePolicyDetails : devicePolicyDetailsExcelList) {
            ArrayList<String> dataRows = new ArrayList<String>();
            dataRows.add(devicePolicyDetails.getUserName());
            dataRows.add(devicePolicyDetails.getDeviceName());
            if (isHeartBeatRep) {
                if (!StringUtils.isEmpty((String)devicePolicyDetails.getFormatedTime())) {
                    long startTime = ReportServiceImpl.getTime(devicePolicyDetails.getFormatedTime());
                    dataRows.add(ReportServiceImpl.getDateInFormat(startTime, "dd-MMM-yyyy"));
                    dataRows.add(ReportServiceImpl.getDateInFormat(startTime, HH_MM_SS));
                } else {
                    dataRows.add("-");
                    dataRows.add("-");
                }
            }
            recordToAdd.add(dataRows);
        }
        return recordToAdd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeLastAgentToServerSummeryForXlsx(XSSFWorkbook workbook, ReportQueryElement reportQueryElement) {
        String fileName = "Device_Heartbeat_Report.xlsx";
        if (!StringUtils.isEmpty((String)reportQueryElement.getDisplayName())) {
            fileName = "Device_Heartbeat_Report_From_Scheduler_" + reportQueryElement.getDisplayName() + ".xlsx";
        }
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeLastAgentToServerSummeryIncompleteBkpForXlsx(XSSFWorkbook workbook) {
        String fileName = "IncompleteBackupHistory.xlsx";
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private static long getTime(String strdate) {
        if (StringUtils.isEmpty((String)strdate)) {
            return 0L;
        }
        long milliseconds = 0L;
        SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        try {
            Date d = f.parse(strdate);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return milliseconds;
    }

    @Override
    public Map<String, Object> getReportConfig(int cloudId, String property) {
        logger.debug("getReportConfig started fetching");
        try {
            List reportConfigs = this.reportConfigDao.getReportConfig(cloudId);
            for (ReportConfig reportConfig : reportConfigs) {
                if (CollectionUtils.isEmpty((Map)((Map)reportConfig.getProperties().get(property)))) continue;
                return (Map)reportConfig.getProperties().get(property);
            }
            return null;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return null;
        }
    }

    public ReportConfigDao getReportConfigDao() {
        return this.reportConfigDao;
    }

    public void setReportConfigDao(ReportConfigDao reportConfigDao) {
        this.reportConfigDao = reportConfigDao;
    }

    @Override
    public boolean createExcelForAuditHistory(int cloudId, List<String> users, String startDate, String endDate) {
        boolean success = false;
        try {
            if (!startDate.isEmpty() && !endDate.isEmpty()) {
                Calendar cal = Calendar.getInstance();
                int noOfDays = Integer.parseInt(startDate);
                SimpleDateFormat dateFormat = new SimpleDateFormat(YYYY_MM_DD);
                cal.add(5, -noOfDays);
                startDate = dateFormat.format(cal.getTime());
                success = this.createExcelForAuditHistoryForDuration(cloudId, users, startDate, endDate);
            }
        }
        catch (NumberFormatException e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
        return success;
    }

    public boolean createExcelForAuditHistoryForDuration(int cloudId, List<String> users, String startofDay, String endOfDay) {
        logger.debug("Before calling query ....");
        boolean success = false;
        try {
            int skipValue = 0;
            ArrayList<AuditHistory> auditList = new ArrayList<AuditHistory>();
            long startDate = ReportServiceImpl.getStartDate(startofDay);
            long endDate = ReportServiceImpl.getEndOfDay(endOfDay);
            for (String user : users) {
                logger.debug("FETCHING AH FOR USER>>...." + user);
                auditList.addAll(this.auditHistoryDao.getAllAuditsForUsersAndDuration(cloudId, user, startDate, endDate, skipValue));
            }
            logger.debug("after calling query ...." + auditList.size());
            logger.debug("Before calling create excel ....");
            success = this.createExcelForAuditHistoryList(cloudId, auditList);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
        return success;
    }

    private boolean createExcelForAuditHistoryList(int cloudId, List<AuditHistory> list) {
        boolean success = false;
        if (!list.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug("before updating the workbook>>>>>>>>>>>>>>>>");
                List<List> recordToAdd = ReportServiceImpl.updateValuesToExcelForAuditHistory(list, System.currentTimeMillis());
                logger.debug("After updating the workbook>>>>>>>>>>>>>>>>");
                this.createExcelForXlsx(recordToAdd, workbook);
                logger.debug(" After creating excel for overview first sheet>>> ...");
                logger.debug("before writing to  the Excel>>>>>>>>>>>>>>>>>>>>");
                success = this.writeExcelForAuditHistory(workbook);
                logger.debug(" After writing excel>>> ...");
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
                return false;
            }
        }
        return success;
    }

    private static List<List> updateValuesToExcelForAuditHistory(List<AuditHistory> list, long reportDate) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_NAME);
        headerRow.add("Date");
        headerRow.add("Action");
        headerRow.add("Action Type");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(reportDate));
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (AuditHistory audit : list) {
            String deviceType = "";
            String actionOn = "";
            if (!StringUtils.isEmpty((String)audit.getActionUsingObject())) {
                deviceType = " using " + audit.getActionUsingObject();
            }
            if (!StringUtils.isEmpty((String)audit.getActionOnObject())) {
                actionOn = audit.getActionOnObject();
            }
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add("" + audit.getActionByUserName());
            firstRow.add("" + new Date(audit.getTimestamp()).toString());
            firstRow.add("" + audit.getActionByUserName() + " " + audit.getAction() + " " + actionOn + " " + deviceType);
            logger.debug("...." + audit.getActionType());
            try {
                firstRow.add("" + PCActionTypes.getActionType((int)audit.getActionType()));
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
                logger.debug("Exception to get action type for code :" + audit.getActionType());
                firstRow.add("" + audit.getAction());
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private boolean writeExcelForAuditHistory(XSSFWorkbook workbook) {
        try {
            File f = new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Audit_OverviewStatus.xlsx");
            if (f.exists()) {
                f.delete();
            }
            if (f.exists()) {
                return false;
            }
            f.createNewFile();
            FileOutputStream fos = new FileOutputStream(f);
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            return true;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private static long getStartDate(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    @Override
    public List<BackupAttemptElement> getBackupHistoryElementForWeeklyMail(int cloudId, ReportQueryElement getBackupHistoryElement) {
        List backupBatchList = this.backupBatchDao.getAllBackupBatch(cloudId, getBackupHistoryElement.getUserName(), getBackupHistoryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartOfDay(getBackupHistoryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(getBackupHistoryElement.getEndDate())));
        logger.debug(ReportServiceImpl.getStartOfDay(getBackupHistoryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + ReportServiceImpl.getEndOfDay(getBackupHistoryElement.getEndDate()));
        if (CollectionUtils.isEmpty((Collection)backupBatchList)) {
            logger.debug("...backupBatchList... is Empty so check last backup batch...");
            List batchlist = this.backupBatchDao.getLastBackupReport(cloudId, "", getBackupHistoryElement.getUserName(), getBackupHistoryElement.getDeviceName());
            logger.debug("last backup batch size : " + batchlist.size());
            if (!CollectionUtils.isEmpty((Collection)batchlist)) {
                for (BackupBatch batch : batchlist) {
                    if (batch.getStatus().equals(COMPLETED)) continue;
                    logger.debug("..." + batch.getBatchEndTimestamp());
                    backupBatchList.add(batch);
                }
            }
        }
        logger.debug(getBackupHistoryElement.getDeviceName() + "backupBatchList count : " + backupBatchList.size());
        List<BackupHistoryElement> backupBatchElements = this.getBackupBatchElements(backupBatchList);
        ArrayList<BackupAttemptElement> attempts = new ArrayList<BackupAttemptElement>();
        for (BackupHistoryElement historyElement : backupBatchElements) {
            List backupAttempsList = this.backupBatchDao.getAllBackupAttemptById(1, historyElement.getBatchId());
            List<BackupAttemptElement> backupAttempsElements = this.getBackupAttempsElements(backupAttempsList, historyElement);
            if (CollectionUtils.isEmpty(backupAttempsElements)) continue;
            attempts.addAll(backupAttempsElements);
        }
        return attempts;
    }

    @Override
    public CloudOverviewElement getOdbCloudOverviewElement(Cloud cloud, String productType) {
        String cloudName = cloud.getCloudName();
        boolean isSharepoint = false;
        if (SHARE_POINT.equalsIgnoreCase(productType)) {
            isSharepoint = true;
        }
        boolean isOneDrive = false;
        if (ODB.equalsIgnoreCase(productType)) {
            isOneDrive = true;
        }
        boolean isExchange = false;
        if ("OUTLOOK".equalsIgnoreCase(productType) || "Exchange".equalsIgnoreCase(productType)) {
            isExchange = true;
        }
        int cloudId = cloud.getCloudId();
        CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
        long deviceCount = 0L;
        long totalusers = 0L;
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long noOfFullBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        long totalActualSpaceUsed = 0L;
        long currentlyRunningBackupCount = 0L;
        long noOfDevicesNotProtected = 0L;
        long noOfTotalBkpOverviews = 0L;
        List<Object> blockOdbList = new ArrayList();
        List<Object> blockexcList = new ArrayList();
        List<Object> blockSPList = new ArrayList();
        List blockedOdbUsers = new ArrayList();
        List blockedExchangeUsers = new ArrayList();
        HashSet blockedSet = new HashSet();
        List blockedSpSites = new ArrayList();
        HashSet<String> uniqueUsers = new HashSet<String>();
        if (isSharepoint) {
            totalusers = cloud.getNoOfSPSitesAllowed();
            List spSites = this.userDao.getActiveSPSites(cloudId);
            blockedSpSites = this.userDao.getBlockedSPSites(cloudId);
            blockSPList = blockedSpSites.stream().map(User::getUserName).collect(Collectors.toList());
            blockedSet.addAll(blockSPList);
            for (User user : spSites) {
                uniqueUsers.add(user.getUserName());
            }
            cloudOverviewElement.setNoOfActiveSPSites("" + spSites.size());
        } else if (isOneDrive) {
            totalusers = cloud.getNoOfOneDriveUsersAllowed();
            List odbUsers = this.userDao.getActiveOneDriveUsers(cloudId);
            blockedOdbUsers = this.userDao.getBlockedOneDriveUsers(cloudId);
            blockOdbList = blockedOdbUsers.stream().map(User::getUserName).collect(Collectors.toList());
            blockedSet.addAll(blockOdbList);
            for (User user : odbUsers) {
                uniqueUsers.add(user.getUserName());
            }
            cloudOverviewElement.setNoOfActiveOneDriveUsers("" + odbUsers.size());
            long noOfBlockedODBUsers = blockedOdbUsers.size();
            cloudOverviewElement.setNoOfBlockedOneDriveUsers("" + noOfBlockedODBUsers);
        } else if (isExchange) {
            totalusers = cloud.getNoOfExchangeUsersAllowed();
            List exchangeUsers = this.userDao.getActiveExchangeUsers(cloudId);
            blockedExchangeUsers = this.userDao.getBlockedExchangeUsers(cloudId);
            blockexcList = blockedExchangeUsers.stream().map(User::getUserName).collect(Collectors.toList());
            blockedSet.addAll(blockexcList);
            for (User user : exchangeUsers) {
                uniqueUsers.add(user.getUserName());
            }
            cloudOverviewElement.setNoOfActiveExchangeUsers("" + exchangeUsers.size());
            long noOfBlockedExchangeUsers = blockedExchangeUsers.size();
            cloudOverviewElement.setNoOfBlockedExchangeUsers("" + noOfBlockedExchangeUsers);
        }
        String formatedTotalUsers = this.getFormattedValue(totalusers);
        cloudOverviewElement.setNoOfO365UsersAllowed(formatedTotalUsers);
        long totalNoOfActiveBackupUsers = uniqueUsers.size();
        logger.debug(totalusers + "... vali iss... " + totalNoOfActiveBackupUsers);
        List deviceList = this.deviceDao.getAllDevices(cloud.getCloudId(), productType);
        List loadAllDeviceList = this.deviceDao.getAllDevices(cloudId);
        ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
        for (Device dev2 : loadAllDeviceList) {
            if (dev2 == null || dev2.isDeleted() || dev2.isBlocked()) continue;
            if (isOneDrive && ("ONEDRIVE".equalsIgnoreCase(dev2.getDeviceType()) || dev2.getDeviceName().contains("Microsoft OneDrive"))) {
                userIds.add(dev2.getUserId());
            }
            if (!isExchange || !"OUTLOOK".equalsIgnoreCase(dev2.getDeviceType()) && !dev2.getDeviceName().contains("Microsoft Exchange")) continue;
            userIds.add(dev2.getUserId());
        }
        List blockedDevicesList = deviceList.stream().filter(dev -> dev.isBlocked() && !dev.getDeviceType().equalsIgnoreCase(Device.TYPE.BACKUP.name())).collect(Collectors.toList());
        long noOfBlockedDevices = blockedDevicesList.size();
        logger.debug("....userIds....." + userIds.size());
        List usersNotConnectedToDeviceList = this.userDao.getOfficeUsersNotConnectedToDevice(cloud.getCloudId(), userIds, productType);
        ArrayList<User> usersNotConnectedToDevice = new ArrayList<User>();
        for (User usersobj : usersNotConnectedToDeviceList) {
            if (!usersobj.isActive()) continue;
            if (isSharepoint && usersobj.isSite()) {
                usersNotConnectedToDevice.add(usersobj);
                continue;
            }
            if (isOneDrive && usersobj.isOnedriveBkpEnabled()) {
                usersNotConnectedToDevice.add(usersobj);
                continue;
            }
            if (!isExchange || !usersobj.isExchangeBkpEnabled()) continue;
            usersNotConnectedToDevice.add(usersobj);
        }
        long activeDevicesWithFullBackupsCompleted = 0L;
        long activeUsersWithFullBackupsCompleted = 0L;
        try {
            if (isSharepoint) {
                productType = Device.TYPE.SHAREPOINT.toString();
            } else if (isOneDrive) {
                productType = Device.TYPE.ONEDRIVE.toString();
            } else if (isExchange) {
                productType = Device.TYPE.OUTLOOK.toString();
            }
            Object[] arr = this.deviceDao.getODBCloudOverView(cloudId, productType);
            totalDiskSpaceUsed = Long.parseLong(String.valueOf(arr[0]));
            noOfBackupsDone = Long.parseLong(String.valueOf(arr[1]));
            noOfRestoresDone = Long.parseLong(String.valueOf(arr[2]));
            deviceCount = Long.parseLong(String.valueOf(arr[3]));
            noOfFullBackupsDone = Long.parseLong(String.valueOf(arr[4]));
            totalActualSpaceUsed = Long.parseLong(String.valueOf(arr[5]));
            currentlyRunningBackupCount = Long.parseLong(String.valueOf(arr[6]));
            long noOfUsersProtected = Long.parseLong(String.valueOf(arr[7]));
            noOfDevicesNotProtected = Long.parseLong(String.valueOf(arr[8]));
            noOfTotalBkpOverviews = Long.parseLong(String.valueOf(arr[9]));
            activeDevicesWithFullBackupsCompleted = Long.parseLong(String.valueOf(arr[10]));
            activeUsersWithFullBackupsCompleted = Long.parseLong(String.valueOf(arr[11]));
            String compressionSizeInPercentage = this.getCompressedSize(totalDiskSpaceUsed, totalActualSpaceUsed);
            cloudOverviewElement.setTotalCompressedSizeInPercentage(compressionSizeInPercentage);
            cloudOverviewElement.setTotalActualStorageUtilized(ReportServiceImpl.formatFileSize(totalActualSpaceUsed));
            cloudOverviewElement.setTotalStorageUtilized(ReportServiceImpl.formatFileSize(totalDiskSpaceUsed));
            cloudOverviewElement.setAvgStoragePerUser(ReportServiceImpl.avgStoragePerUser(totalDiskSpaceUsed, totalusers));
            cloudOverviewElement.setDevicesConnected(this.getFormattedValue(deviceCount));
            cloudOverviewElement.setUsersConnected(this.getFormattedValue(totalusers));
            cloudOverviewElement.setRestoresDone(this.getFormattedValue(noOfRestoresDone));
            cloudOverviewElement.setBackupsDone(this.getFormattedValue(noOfBackupsDone));
            cloudOverviewElement.setFullBackupsDone(this.getFormattedValue(noOfFullBackupsDone));
            cloudOverviewElement.setActiveBackupUsers(this.getFormattedValue(totalNoOfActiveBackupUsers));
            cloudOverviewElement.setCurrentlyRunningBackupCount(this.getFormattedValue(currentlyRunningBackupCount));
            cloudOverviewElement.setAvgRestorePerUser(String.valueOf(new Double(noOfRestoresDone) / new Double(totalusers)));
            logger.debug("no of users protected in 7 days...." + noOfUsersProtected);
            cloudOverviewElement.setNoOfUsersProtected("" + noOfUsersProtected);
            cloudOverviewElement.setUserWithOutDevices(this.getFormattedValue(usersNotConnectedToDevice.size()));
            long totalActiveUsersWithDevices = totalNoOfActiveBackupUsers - (long)usersNotConnectedToDevice.size();
            long totalUsersWithDeviceandNotProtected = totalActiveUsersWithDevices - noOfUsersProtected;
            if (totalUsersWithDeviceandNotProtected != 0L && totalActiveUsersWithDevices != 0L) {
                long noOfUsersNotProtectedPercentage = totalUsersWithDeviceandNotProtected * 100L / totalActiveUsersWithDevices;
                cloudOverviewElement.setNoOfUsersProtected(this.getFormattedValue(totalUsersWithDeviceandNotProtected) + "(" + noOfUsersNotProtectedPercentage + "%)");
            } else {
                cloudOverviewElement.setNoOfUsersProtected("0(0%)");
            }
            if (noOfDevicesNotProtected != 0L && noOfTotalBkpOverviews != 0L) {
                long noOfDevicesNotProtectedPercentage = noOfDevicesNotProtected * 100L / noOfTotalBkpOverviews;
                cloudOverviewElement.setNoOfDevicesNotProtected(this.getFormattedValue(noOfDevicesNotProtected) + "(" + noOfDevicesNotProtectedPercentage + "%)");
            } else {
                cloudOverviewElement.setNoOfDevicesNotProtected("0(0%)");
            }
            logger.debug(".....totalnoOfBlockedofficeUsers........" + blockedSet.size());
            logger.debug(".....noOfBlockedodb ExchangeUsers........" + cloudOverviewElement.getNoOfBlockedOneDriveUsers() + ".." + cloudOverviewElement.getNoOfBlockedExchangeUsers());
            cloudOverviewElement.setNoOfBlockedBackupUsers(String.valueOf(blockedSet.size()));
            logger.debug(".....noOfBlockedDevices........" + noOfBlockedDevices);
            cloudOverviewElement.setNoOfBlockedDevices(String.valueOf(noOfBlockedDevices));
            logger.debug("....odb users without devices.." + cloudOverviewElement.getUserWithOutDevices());
            cloudOverviewElement.setNoOfBlockedSPSites("" + blockedSpSites.size());
            cloudOverviewElement.setActiveDevicesWithFullBackupsCompleted(String.valueOf(activeDevicesWithFullBackupsCompleted));
            cloudOverviewElement.setActiveUsersWithFullBackupsCompleted(String.valueOf(activeUsersWithFullBackupsCompleted));
            logger.debug("activeDevicesWithFullBackupsCompleted.........." + activeDevicesWithFullBackupsCompleted + "....activeUsersWithFullBackupsCompleted..." + activeUsersWithFullBackupsCompleted);
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
            List softBlockUsers = this.userDao.getAllSoftBlockUsers(cloud.getCloudId(), null, 0);
            logger.debug(cloudOverviewElement.getNoOfUsersProtected() + "..softBlockUsers count..." + softBlockUsers.size());
            if (cloudPropertyElement.isSoftBlockEnabled()) {
                cloudOverviewElement.setSoftBlockedUsersCount((long)softBlockUsers.size());
            }
        }
        catch (Exception e) {
            logger.debug(EXCEPTION + e);
            logger.error("Error failed to load getCloudOverview ... e={}", (Throwable)e);
        }
        return cloudOverviewElement;
    }

    @Override
    public boolean createExcelBkpHistory(Cloud cloud, ReportQueryElement reportQueryElement) {
        List<Object> backupBatchList = this.getBackupBatchListFromReportQueryElementVal(cloud, reportQueryElement);
        List<BackupHistoryElement> backupBatchElements = this.getBackupBatchElements(backupBatchList = backupBatchList.stream().filter(batch -> StringUtils.isNotEmpty((String)batch.getStatus()) && !batch.getStatus().equalsIgnoreCase(STATUS_STARTED)).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(backupBatchElements)) {
            return false;
        }
        this.createExcelBackupHistory(backupBatchElements, reportQueryElement);
        return true;
    }

    @Override
    public boolean createExcelIncompleteBkpHistory(Cloud cloud, List<BackupActivityHistoryElement> backupActivityHistoryElement, ReportQueryElement reportQueryElement) {
        if (CollectionUtils.isEmpty(backupActivityHistoryElement)) {
            return false;
        }
        this.createExcelIncompleteBackupHistory(backupActivityHistoryElement, reportQueryElement);
        return true;
    }

    private List<BackupBatch> getBackupBatchListFromReportQueryElementVal(Cloud cloud, ReportQueryElement reportQueryElement) {
        int cloudId = cloud.getCloudId();
        String productType = "backup";
        List<Object> backupBatchList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatch(cloudId, user.getUserName(), "", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate()))));
            }
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatch(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())));
        }
        if (PCHelperConstant.ODB_PRODUCT_TYPE.equals(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_ONEDRIVE_DEVICE)).collect(Collectors.toList());
        } else if (PCHelperConstant.SHAREPOINT_PRODUCT_TYPE.equals(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_SHAREPOINT_DEVICE)).collect(Collectors.toList());
        }
        logger.debug(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate()));
        logger.debug("backupBatchList count : " + backupBatchList.size());
        return backupBatchList;
    }

    private List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        return this.backupPolicyDao.getAllBackupPolicies(cloudId);
    }

    @Override
    public boolean createPdfForAgentToServerConnectionReport(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -reportQueryElement.getNoOfDays());
        long noOfDaysInMilliSecounds = cal.getTimeInMillis();
        List<DevicePolicyDetailsElement> devicePolicyDetailsElements = this.getLastAgentServerConnectionDataForPdf(cloud, noOfDaysInMilliSecounds, reportQueryElement, productType);
        return this.createPdfForLastAgentServerTimer(devicePolicyDetailsElements, reportQueryElement);
    }

    private List<DevicePolicyDetailsElement> getLastAgentServerConnectionDataForPdf(Cloud cloud, long noOfDaysMilliSeconds, ReportQueryElement reportQueryElement, String productType) {
        ArrayList<DevicePolicyDetailsElement> elementList = new ArrayList<DevicePolicyDetailsElement>();
        List overViewList = new ArrayList();
        overViewList = !CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames()) ? this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType) : (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) ? (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceNameForProductType(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), productType) : this.deviceDao.getDeviceBkpOverviewForUserNameForProductType(cloud.getCloudId(), reportQueryElement.getUserName(), productType)) : this.deviceDao.getAllOverviewsBasedOnProductType(cloud.getCloudId(), productType));
        long slno = 0L;
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isUserDeleted() || deviceBackupOverView.isDeviceBolcked()) continue;
            DevicePolicyDetailsElement devicePolicyDetailsElement = new DevicePolicyDetailsElement();
            long lastAgentHeard = deviceBackupOverView.getLastHeardTime();
            if (lastAgentHeard == 0L) {
                deviceBackupOverView.setLastHeardTime(Long.parseLong(deviceBackupOverView.getEpaInstallationDate()));
            }
            if (deviceBackupOverView.getLastHeardTime() >= noOfDaysMilliSeconds) continue;
            ++slno;
            devicePolicyDetailsElement.setDeviceName(deviceBackupOverView.getDeviceName());
            devicePolicyDetailsElement.setUserName(deviceBackupOverView.getUserName());
            devicePolicyDetailsElement.setFormatedTime(this.getDate(deviceBackupOverView.getLastHeardTime()));
            elementList.add(devicePolicyDetailsElement);
        }
        return elementList;
    }

    private boolean createPdfForLastAgentServerTimer(List<DevicePolicyDetailsElement> devicePolicyDetailsElements, ReportQueryElement reportQueryElement) {
        try {
            String FILE = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Device_Heartbeat_Report1.pdf";
            String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Device_Heartbeat_Report.pdf";
            StringBuilder htmlContent = new StringBuilder();
            String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
            htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>Report generated on " + currentDate + "</p>");
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                htmlContent.append("<p>Policy Name :" + policyNames + "</p>");
            }
            htmlContent.append("<p>Number of days :" + reportQueryElement.getNoOfDays() + "</p>");
            this.HeaderOfPdfForLastAgentServerTimer(htmlContent);
            this.updateLastAgentServerTimerDataOnPdf(devicePolicyDetailsElements, htmlContent);
            htmlContent.append("</table>").append("</body>").append("</html>");
            logger.debug(htmlContent + "htmlContent............");
            FileOutputStream outputStream = new FileOutputStream(new File(FILE));
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(htmlContent.toString(), null);
            builder.useDefaultPageSize(594.0f, 420.0f, BaseRendererBuilder.PageSizeUnits.MM);
            builder.toStream((OutputStream)outputStream);
            builder.run();
            ((OutputStream)outputStream).close();
            logger.debug("PDF created successfully at " + outPutFile);
            logger.debug("PDF created successfully.");
            this.addWatermarkToPDF(FILE, outPutFile, 1);
            return true;
        }
        catch (Exception e) {
            logger.error("Exception:" + e.getMessage());
            logger.trace(EXCEPTION + e);
            return false;
        }
    }

    private void addWatermarkToPDF(String src, String dest, int cloudId) {
        CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
        String watermarkText = "Parablu";
        try {
            if (StringUtils.isNotEmpty((String)cloudPropertyElement.getWaterMarkText())) {
                watermarkText = cloudPropertyElement.getWaterMarkText();
            }
            PDDocument document = PDDocument.load((File)new File(src));
            PDPageTree pages = document.getPages();
            for (PDPage page : pages) {
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 30.0f);
                contentStream.setNonStrokingColor(128, 128, 128);
                PDRectangle pageSize = page.getMediaBox();
                float x = pageSize.getWidth() / 2.0f;
                float y = pageSize.getHeight() / 2.0f;
                contentStream.beginText();
                contentStream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(45.0), (float)x, (float)y));
                contentStream.newLineAtOffset(0.0f, 0.0f);
                contentStream.showText(watermarkText);
                contentStream.endText();
                contentStream.close();
            }
            document.save(dest);
            document.close();
            System.out.println("Watermark added successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void HeaderOfPdfForLastAgentServerTimer(StringBuilder htmlContent) {
        htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">Sl No</th>").append("<th>Asset Name</th>").append("<th>User Id</th>").append("<th>Last Server Connection Time</th>");
        htmlContent.append("</tr>");
    }

    private void updateLastAgentServerTimerDataOnPdf(List<DevicePolicyDetailsElement> devicePolicyDetailsElements, StringBuilder htmlContent) {
        long slno = 0L;
        for (DevicePolicyDetailsElement devicePolicyElement : devicePolicyDetailsElements) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + devicePolicyElement.getDeviceName() + "</td>");
            htmlContent.append("<td>" + devicePolicyElement.getUserName() + "</td>");
            htmlContent.append("<td>" + devicePolicyElement.getFormatedTime() + "</td>");
            htmlContent.append("</tr>");
        }
    }

    @Override
    public List<ReportSchedulerElement> getReportConfigBySchedulerName(int cloudId, String schedulerName, String id) {
        ArrayList<ReportSchedulerElement> reportSchedulerElements;
        block6: {
            logger.debug("schedulerName :" + schedulerName);
            reportSchedulerElements = new ArrayList<ReportSchedulerElement>();
            try {
                List<ReportScheduler> reportSchedulers = new ArrayList();
                if (!StringUtils.isEmpty((String)id)) {
                    logger.debug("...Id..." + id);
                    ReportScheduler reportSchedulerById = this.reportSchedulerDao.getReportSchedulerById(cloudId, new ObjectId(id));
                    reportSchedulers.add(reportSchedulerById);
                } else {
                    reportSchedulers = this.reportSchedulerDao.getReportScheduler(cloudId, schedulerName);
                }
                if (!CollectionUtils.isEmpty(reportSchedulers)) {
                    for (ReportScheduler reportScheduler : reportSchedulers) {
                        logger.debug("........" + reportScheduler.toString());
                        ReportSchedulerElement element = new ReportSchedulerElement();
                        BeanUtils.copyProperties((Object)reportScheduler, (Object)element);
                        element.setTime(this.getTimeFromCron(reportScheduler.getCronExprestion()));
                        element.setSchedulerName(reportScheduler.getSchedulerName());
                        logger.debug("......" + element.getDate());
                        element.setId(reportScheduler.getId().toString());
                        reportSchedulerElements.add(element);
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                logger.trace("EXCEPTION" + e);
                logger.error("EXCEPTION" + e.getMessage());
                return null;
            }
        }
        return reportSchedulerElements;
    }

    @Override
    public ReportSchedulerElement getReportConfigById(int cloudId, String id) {
        ReportScheduler reportSchedulerById = this.reportSchedulerDao.getReportSchedulerById(cloudId, new ObjectId(id));
        ReportSchedulerElement element = new ReportSchedulerElement();
        BeanUtils.copyProperties((Object)reportSchedulerById, (Object)element);
        element.setTime(this.getTimeFromCron(reportSchedulerById.getCronExprestion()));
        element.setSchedulerName(reportSchedulerById.getSchedulerName());
        String daysFromCron = this.getDaysFromCron(reportSchedulerById.getCronExprestion());
        if (!StringUtils.isEmpty((String)daysFromCron) && !daysFromCron.equals("?")) {
            element.setDays(daysFromCron);
        } else {
            element.setDate(this.getDateFromCron(reportSchedulerById.getCronExprestion()));
        }
        element.setId(reportSchedulerById.getId().toString());
        return element;
    }

    @Override
    public List<ReportSchedulerElement> getAllReportConfig(int cloudId) {
        ArrayList<ReportSchedulerElement> reportSchedulerElements;
        block6: {
            reportSchedulerElements = new ArrayList<ReportSchedulerElement>();
            try {
                List reportSchedulers = new ArrayList();
                reportSchedulers = this.reportSchedulerDao.getAllReportScheduler(cloudId);
                if (!CollectionUtils.isEmpty(reportSchedulers)) {
                    for (ReportScheduler reportScheduler : reportSchedulers) {
                        logger.debug("........" + reportScheduler.toString());
                        ReportSchedulerElement element = new ReportSchedulerElement();
                        BeanUtils.copyProperties((Object)reportScheduler, (Object)element);
                        element.setTime(this.getTimeFromCron(reportScheduler.getCronExprestion()));
                        element.setSchedulerName(reportScheduler.getSchedulerName());
                        String daysFromCron = this.getDaysFromCron(reportScheduler.getCronExprestion());
                        if (!StringUtils.isEmpty((String)daysFromCron) && !daysFromCron.equals("?")) {
                            element.setDays(daysFromCron);
                        } else {
                            element.setDate(this.getDateFromCron(reportScheduler.getCronExprestion()));
                        }
                        element.setId(reportScheduler.getId().toString());
                        reportSchedulerElements.add(element);
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                logger.trace("EXCEPTION" + e);
                logger.error("EXCEPTION" + e.getMessage());
                return null;
            }
        }
        return reportSchedulerElements;
    }

    @Override
    public List<ReportSchedulerElement> getReportSchedulerNames(int cloudId, List<String> schedulerNames) {
        ArrayList<ReportSchedulerElement> reportSchedulerElements;
        block6: {
            reportSchedulerElements = new ArrayList<ReportSchedulerElement>();
            try {
                List reportSchedulers = new ArrayList();
                reportSchedulers = this.reportSchedulerDao.getReportSchedulerNames(cloudId, schedulerNames);
                if (!CollectionUtils.isEmpty(reportSchedulers)) {
                    for (ReportScheduler reportScheduler : reportSchedulers) {
                        try {
                            ReportSchedulerElement element = new ReportSchedulerElement();
                            BeanUtils.copyProperties((Object)reportScheduler, (Object)element);
                            element.setTime(this.getTimeFromCron(reportScheduler.getCronExprestion()));
                            element.setSchedulerName(reportScheduler.getSchedulerName());
                            element.setId(reportScheduler.getId().toString());
                            reportSchedulerElements.add(element);
                        }
                        catch (Exception e) {
                            logger.trace("EXCEPTION" + e);
                            logger.error("EXCEPTION" + e.getMessage());
                        }
                    }
                    break block6;
                }
                return reportSchedulerElements;
            }
            catch (Exception e) {
                logger.trace("EXCEPTION" + e);
                logger.error("EXCEPTION" + e.getMessage());
                return reportSchedulerElements;
            }
        }
        return reportSchedulerElements;
    }

    @Override
    public boolean saveReportConfigByScheduler(int cloudId, ReportSchedulerElement reportSchedulerElement, User user) {
        logger.debug("schedulerName :" + reportSchedulerElement.getSchedulerName());
        boolean isSaved = true;
        String schedulerName = reportSchedulerElement.getSchedulerName();
        String replacedSchedulerName = this.replaceSchedulerName(schedulerName);
        try {
            if (StringUtils.isEmpty((String)reportSchedulerElement.getId())) {
                ReportScheduler reportSchedulerByDisplyName = this.reportSchedulerDao.getReportSchedulerByDisplyName(cloudId, reportSchedulerElement.getSchedulerName(), reportSchedulerElement.getDisplayName());
                if (reportSchedulerByDisplyName != null) {
                    logger.debug(".........already sheduler exists so return.....");
                    return false;
                }
                StringBuilder cronExpresion = this.getCronExpression(reportSchedulerElement.getTime(), reportSchedulerElement.getDate(), reportSchedulerElement.getDays(), reportSchedulerElement.getMonths(), reportSchedulerElement.getDayOfMonth());
                ReportScheduler reportScheduler = new ReportScheduler();
                BeanUtils.copyProperties((Object)reportSchedulerElement, (Object)reportScheduler);
                reportScheduler.setCronExprestion(cronExpresion.toString());
                reportScheduler.setCreatedTimestamp(System.currentTimeMillis());
                reportScheduler.setCreatedBy(user.getUserName());
                this.reportSchedulerDao.saveReportScheduler(cloudId, reportScheduler);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, user.getUserName(), replacedSchedulerName, user.getUserName() + " created a scheduled report configuration for", "Schedule Name: " + reportSchedulerElement.getDisplayName() + ", Product Type: " + reportSchedulerElement.getProductType() + ", Schedule Time: " + reportSchedulerElement.getTime() + ", Recipient Email IDs: " + String.join((CharSequence)", ", reportSchedulerElement.getEmailIds()), "Portal", System.currentTimeMillis(), PCActionTypes.CREATE_SCHEDULED_REPORT_CONFIGURATION.getActionTypeValue());
            } else {
                ReportScheduler reportSchedulerById = this.reportSchedulerDao.getReportSchedulerById(cloudId, new ObjectId(reportSchedulerElement.getId()));
                reportSchedulerElement.setCronExprestion(reportSchedulerById.getCronExprestion());
                BeanUtils.copyProperties((Object)reportSchedulerElement, (Object)reportSchedulerById);
                StringBuilder cronExpresion = this.getCronExpression(reportSchedulerElement.getTime(), reportSchedulerElement.getDate(), reportSchedulerElement.getDays(), reportSchedulerElement.getMonths(), reportSchedulerElement.getDayOfMonth());
                reportSchedulerById.setModifiedTimestamp(System.currentTimeMillis());
                reportSchedulerById.setCronExprestion(cronExpresion.toString());
                this.reportSchedulerDao.saveReportScheduler(cloudId, reportSchedulerById);
                this.auditHistoryService.saveStatisticToDatabase(cloudId, user.getUserName(), replacedSchedulerName, user.getUserName() + " updated scheduled report configuration for", "Schedule Name: " + reportSchedulerElement.getDisplayName() + ", Product Type: " + reportSchedulerElement.getProductType() + ", Schedule Time: " + reportSchedulerElement.getTime() + ", Recipient Email IDs: " + String.join((CharSequence)", ", reportSchedulerElement.getEmailIds()), "Portal", System.currentTimeMillis(), PCActionTypes.UPDATE_SCHEDULED_REPORT_CONFIGURATION.getActionTypeValue());
            }
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            isSaved = false;
        }
        return isSaved;
    }

    private String replaceSchedulerName(String originalName) {
        switch (originalName) {
            case "sendBackupOverviewReportTimer": {
                return "Backup Overview";
            }
            case "sendRestoreHistoryReportTimer": {
                return "Restore History";
            }
            case "sendBackupHistoryReportTimer": {
                return "Backup History";
            }
            case "sendDeviceHeartbeatReportTimer": {
                return "Asset Heartbeat Report";
            }
            case "sendBkpSummeryReportTimer": {
                return "Data Protection Scorecard";
            }
            case "sendSystemwithoutBkpReportTimer": {
                return "Assets not protected";
            }
        }
        return originalName;
    }

    @Override
    public void deleteReportSchedulerById(int cloudId, String id) {
        logger.debug("id :" + id);
        try {
            this.reportSchedulerDao.deleteReportSchedulerById(cloudId, new ObjectId(id));
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
        }
    }

    private StringBuilder getCronExpression(String time, String date, String days, List<String> munths, String dayOfMonth) {
        StringBuilder cronExpresion = new StringBuilder();
        String[] split = time.split(":");
        cronExpresion.append("0 ");
        cronExpresion.append(split[1] + " ");
        cronExpresion.append(split[0] + " ");
        if (!CollectionUtils.isEmpty(munths)) {
            cronExpresion.append(dayOfMonth + " ");
            cronExpresion.append(String.join((CharSequence)",", munths));
            cronExpresion.append(" ?");
        } else if (StringUtils.isEmpty((String)date)) {
            cronExpresion.append("? ");
            cronExpresion.append("* ");
            cronExpresion.append(days);
        } else {
            String[] split1 = date.split("/");
            cronExpresion.append(split1[1] + " ");
            cronExpresion.append(split1[0] + " ");
            cronExpresion.append("?");
        }
        logger.debug("....cronExpresion......." + cronExpresion);
        return cronExpresion;
    }

    private String getTimeFromCron(String cron) {
        String[] split = cron.split(" ");
        StringBuilder cronExpresion = new StringBuilder();
        cronExpresion.append(split[2] + ":" + split[1]);
        return cronExpresion.toString();
    }

    private String getDateFromCron(String cron) {
        String[] split = cron.split(" ");
        StringBuilder cronExpresion = new StringBuilder();
        if (split.length >= 4) {
            cronExpresion.append(split[3] + "/" + split[4]);
        }
        return cronExpresion.toString();
    }

    private String getDaysFromCron(String cron) {
        String[] split = cron.split(" ");
        StringBuilder cronExpresion = new StringBuilder();
        cronExpresion.append(split[5]);
        return cronExpresion.toString();
    }

    public ReportSchedulerDao getReportSchedulerDao() {
        return this.reportSchedulerDao;
    }

    public void setReportSchedulerDao(ReportSchedulerDao reportSchedulerDao) {
        this.reportSchedulerDao = reportSchedulerDao;
    }

    @Override
    public RestoreProgressEvents getRestoreEventProgressByUUID(int cloudId, String deviceUUID) {
        return this.eventHubDao.getRestoreEventProgressByUUID(cloudId, deviceUUID);
    }

    @Override
    public boolean createExcelBackupSummary(Cloud cloud, ReportQueryElement reportQueryElement, String productType) {
        CloudOverviewElement cloudOverviewElement = this.getBackupSummary(cloud, reportQueryElement, productType);
        this.createExcelOfBackupSummary(cloud, cloudOverviewElement, reportQueryElement, productType);
        return true;
    }

    @Override
    public RestoreEventsElement getRestoreEventByUUIDAndFolder(int cloudId, String deviceUUID, String destinationFolder) {
        logger.debug(".....deviceUUID......." + deviceUUID);
        RestoreEvents restoreEventByUUIDAndFolder = this.eventHubDao.getRestoreEventsByDestUUIDAndFolder(cloudId, deviceUUID);
        RestoreEventsElement elements = null;
        if (restoreEventByUUIDAndFolder != null) {
            try {
                elements = new RestoreEventsElement();
                logger.debug("...Inside loop...." + restoreEventByUUIDAndFolder.getId());
                BeanUtils.copyProperties((Object)restoreEventByUUIDAndFolder, (Object)elements);
                elements.setSuspendBackup(restoreEventByUUIDAndFolder.isSuspendBackup());
                elements.setId(restoreEventByUUIDAndFolder.getId());
                FileElement fileElement = new FileElement();
                fileElement.setFileCompletePath(restoreEventByUUIDAndFolder.getFileInfo().getFilePath());
                fileElement.setFolder(restoreEventByUUIDAndFolder.getFileInfo().isFolder());
                fileElement.setBackupId(restoreEventByUUIDAndFolder.getFileInfo().getId());
                elements.setFileElement(fileElement);
            }
            catch (Exception e) {
                logger.error(".... exception......" + e.getMessage());
            }
        }
        return elements;
    }

    @Override
    public NotificationElementList getFailedNotificationHistoryElementForReport(Cloud cloud, ReportQueryElement reportQueryElement) {
        NotificationElementList elementList = new NotificationElementList();
        ArrayList<BackupBatch> backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            String productType = "backup";
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            ArrayList<String> users = new ArrayList<String>();
            for (User user : userList) {
                users.add(user.getUserName());
            }
            backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), users, ""));
        } else {
            backupBatchList = this.backupBatchDao.getAllBackupBatchForStatus(cloudId, "FAILED", Long.valueOf(ReportServiceImpl.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getUserName(), reportQueryElement.getDeviceName());
        }
        List<NotificationHistoryElement> notificationHistoryElements = this.getReportNotificationHistoryElements(cloudId, backupBatchList, "both", false);
        elementList.setNotificationHistoryElementList(notificationHistoryElements);
        elementList.setDelayedNotificationHistoryElements(new ArrayList());
        elementList.setCurrentBatchElements(new ArrayList());
        return elementList;
    }

    @Override
    public List<BackupActivityHistoryElement> getBackupBatchHistoryElementForWeeklyMail(int cloudId, ReportQueryElement getBackupHistoryElement) {
        List backupBatchList = this.backupBatchDao.getAllBackupBatch(cloudId, getBackupHistoryElement.getUserName(), getBackupHistoryElement.getDeviceName(), Long.valueOf(ReportServiceImpl.getStartOfDay(getBackupHistoryElement.getStartDate())), Long.valueOf(ReportServiceImpl.getEndOfDay(getBackupHistoryElement.getEndDate())));
        logger.debug(ReportServiceImpl.getStartOfDay(getBackupHistoryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + ReportServiceImpl.getEndOfDay(getBackupHistoryElement.getEndDate()));
        if (CollectionUtils.isEmpty((Collection)backupBatchList)) {
            logger.debug("...backupBatchList... is Empty so check last backup batch...");
            List batchlist = this.backupBatchDao.getLastBackupReport(cloudId, "", getBackupHistoryElement.getUserName(), getBackupHistoryElement.getDeviceName());
            logger.debug("last backup batch size : " + batchlist.size());
            if (!CollectionUtils.isEmpty((Collection)batchlist)) {
                for (BackupBatch batch : batchlist) {
                    if (batch.getStatus().equals(COMPLETED)) continue;
                    logger.debug("..." + batch.getBatchEndTimestamp());
                    backupBatchList.add(batch);
                }
            }
        }
        logger.debug(getBackupHistoryElement.getDeviceName() + "backupBatchList count : " + backupBatchList.size());
        List<BackupActivityHistoryElement> backupBatchElements = this.getBackupBatchElementsNew(backupBatchList);
        return backupBatchElements;
    }

    private List<BackupActivityHistoryElement> getBackupBatchElementsNew(List<BackupBatch> backupBatchList) {
        ArrayList<BackupActivityHistoryElement> backupHistoryElements = new ArrayList<BackupActivityHistoryElement>();
        for (BackupBatch backupBatch : backupBatchList) {
            BackupActivityHistoryElement backupActivityHistoryElement = new BackupActivityHistoryElement();
            backupActivityHistoryElement.setDeviceName(backupBatch.getDeviceName());
            backupActivityHistoryElement.setUserName(backupBatch.getUserName());
            backupActivityHistoryElement.setStartTimeLong(backupBatch.getBatchStartTimestamp());
            backupActivityHistoryElement.setEndTimeLong(backupBatch.getBatchEndTimestamp());
            backupActivityHistoryElement.setStartTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchStartTimestamp()));
            backupActivityHistoryElement.setEndTime(DateUtil.getDateInddMMMyyyy((long)backupBatch.getBatchEndTimestamp()));
            backupActivityHistoryElement.setStatus(backupBatch.getStatus());
            backupActivityHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
            backupActivityHistoryElement.setEndTimeInMillis(backupBatch.getBatchEndTimestamp());
            backupActivityHistoryElement.setErrorCode(backupBatch.getErrorCode());
            backupActivityHistoryElement.setTotalNumberOfFiles(Long.parseLong(backupBatch.getTotalNoOfFiles()));
            backupActivityHistoryElement.setType(backupBatch.getJobType());
            List attempts = this.backupBatchDao.getAllBackupAttemptById(1, backupBatch.getId().toString());
            if (!CollectionUtils.isEmpty((Collection)attempts)) {
                backupActivityHistoryElement.setAttemptIsThere(true);
            }
            if (!backupBatch.getDeviceName().contains("Microsoft ")) {
                if (!CollectionUtils.isEmpty((Collection)attempts)) {
                    String uploadedSize = this.getUploadedSize(attempts, backupBatch);
                    backupActivityHistoryElement.setAttemptIsThere(true);
                    if (backupBatch.getStatus().equalsIgnoreCase(COMPLETED)) {
                        backupActivityHistoryElement.setUploadedPercentage("100 %");
                    } else {
                        backupActivityHistoryElement.setUploadedPercentage(uploadedSize);
                    }
                }
            } else {
                long totalNoUploadedFiles = 0L;
                try {
                    String uploadedFiles = backupBatch.getUploadedFiles();
                    if (StringUtils.isEmpty((String)uploadedFiles)) {
                        uploadedFiles = "0/0";
                    }
                    String[] parts = uploadedFiles.split("/");
                    int actualNoOfFiles = Integer.parseInt(parts[0]);
                    totalNoUploadedFiles = Integer.parseInt(backupBatch.getTotalNoOfFiles());
                    logger.debug(backupBatch.getUploadedFiles() + "...backupbatch update.." + backupBatch.getTotalNoOfFiles());
                    logger.debug("...actualNoOfFiles.." + actualNoOfFiles);
                    logger.debug("...totaolNoFiles......." + totalNoUploadedFiles);
                    if (totalNoUploadedFiles != 0L) {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf(ReportServiceImpl.getPercentageCompleted(actualNoOfFiles, totalNoUploadedFiles)) + " %");
                    } else {
                        backupActivityHistoryElement.setUploadedPercentage(String.valueOf(0) + " %");
                    }
                }
                catch (Exception e) {
                    logger.trace(" EXCEPTION..... " + e);
                }
            }
            String comments = this.getCommentsForBackupBatch(backupBatch);
            this.setNoOfFilesUploadedAndFailed(backupBatch, backupActivityHistoryElement);
            if (backupBatch.getStatus().equalsIgnoreCase(BackupBatch.STATUS.STARTED.name())) {
                backupActivityHistoryElement.setStatus("Data Uploading");
                backupActivityHistoryElement.setNoOfFilesFailed("");
                comments = "Data Uploading";
            }
            if (backupBatch.getStatus().equalsIgnoreCase("PAUSED")) {
                backupActivityHistoryElement.setNoOfFilesFailed("");
            }
            logger.debug(backupBatch.getErrorCode() + "..pause..." + backupActivityHistoryElement.getNoOfFilesBackedup() + "....." + backupActivityHistoryElement.getTotalNumberOfFiles());
            try {
                if (!StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles())) {
                    backupActivityHistoryElement.setTotalNumberOfFiles(Long.parseLong(backupBatch.getTotalNoOfFiles().trim()));
                }
            }
            catch (Exception e) {
                logger.error("...error trying to parse.... ");
            }
            if (("1207".equals(backupBatch.getErrorCode()) || "1209".equals(backupBatch.getErrorCode())) && (StringUtils.isEmpty((String)backupBatch.getTotalNoOfFiles()) || backupBatch.getTotalNoOfFiles().equals("0"))) {
                if ("1209".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Backup manually";
                }
                if ("1207".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Backup manually";
                }
            }
            logger.debug("..comments..." + comments);
            backupActivityHistoryElement.setComments(comments);
            if (backupBatch.getStatus().equalsIgnoreCase(STATUS_SANNING)) {
                backupActivityHistoryElement.setComments("-");
                if ("1209".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Scanning manually";
                }
                if ("1207".equals(backupBatch.getErrorCode())) {
                    comments = "Admin stopped Scanning manually";
                }
            }
            if (backupBatch.getStatus().equalsIgnoreCase(PRESCAN_COMMAND_EXECUTION)) {
                backupActivityHistoryElement.setComments("-");
            }
            backupActivityHistoryElement.setBatchId(backupBatch.getId().toString());
            backupHistoryElements.add(backupActivityHistoryElement);
        }
        return backupHistoryElements;
    }

    private void setNoOfFilesUploadedAndFailed(BackupBatch backupBatch, BackupActivityHistoryElement backupActivityHistoryElement) {
        String uploadedFiles = backupBatch.getUploadedFiles();
        int noOfFilesBackedup = 0;
        int actualNoOfFiles = 0;
        int noOfFilesFailed = 0;
        try {
            String[] parts;
            if (StringUtils.isEmpty((String)uploadedFiles)) {
                uploadedFiles = "0/0";
            }
            if ((noOfFilesFailed = (actualNoOfFiles = Integer.parseInt((parts = uploadedFiles.split("/"))[1])) - (noOfFilesBackedup = Integer.parseInt(parts[0]))) < 0) {
                noOfFilesFailed = 0;
            }
        }
        catch (Exception e) {
            logger.trace(" no detail for uploaded files " + e);
            logger.error(" no detail for uploaded files " + e.getMessage());
        }
        backupActivityHistoryElement.setNoOfFilesBackedup(String.valueOf(noOfFilesBackedup));
        backupActivityHistoryElement.setNoOfFilesFailed(String.valueOf(noOfFilesFailed));
    }

    private String getUploadedSize(List<BackupAttempt> backupBatchList, BackupBatch batch) {
        long totalSizeUploadedFiles = 0L;
        String uploadedSize = "0 %";
        for (BackupAttempt backupBatchAttempt : backupBatchList) {
            logger.debug("..attempt......" + backupBatchAttempt.getUploadedSize());
            if (StringUtils.isEmpty((String)backupBatchAttempt.getUploadedSize())) continue;
            totalSizeUploadedFiles += Long.parseLong(backupBatchAttempt.getUploadedSize());
        }
        logger.debug(totalSizeUploadedFiles + "..attempt......" + batch.getTotalSizeToUpload());
        uploadedSize = ReportServiceImpl.getPercentageCompleted(totalSizeUploadedFiles, batch.getTotalSizeToUpload()) + " %";
        return uploadedSize;
    }

    private String getCommentsForBackupBatch(BackupBatch backupBatch) {
        String comments = "";
        if (STATUS_STARTED.equalsIgnoreCase(backupBatch.getStatus())) {
            return comments;
        }
        if ("0".equals(backupBatch.getErrorCode())) {
            comments = "Successfully Completed";
        }
        if (PRESCAN_COMMAND_EXECUTION.equals(backupBatch.getStatus())) {
            comments = "-";
        }
        boolean officeProduct = false;
        if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint")) {
            officeProduct = true;
        }
        if ("909".equals(backupBatch.getErrorCode())) {
            comments = !officeProduct ? "Network disconnected or endpoint was shutdown during the backup" : "Network disconnected during the backup";
        }
        if ("911".equals(backupBatch.getErrorCode())) {
            comments = "User exited the agent manually or the endpoint was shutdown during the backup";
        }
        if ("912".equals(backupBatch.getErrorCode())) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("2304".equals(backupBatch.getErrorCode())) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(backupBatch.getErrorCode())) {
            comments = officeProduct ? "Admin paused BackUp manually" : "User paused BackUp manually";
        }
        if ("1981".equals(backupBatch.getErrorCode())) {
            comments = "User storage limit reached.";
        }
        if ("1947".equals(backupBatch.getErrorCode())) {
            comments = "Storage limit exceeded";
        }
        if ("1996".equals(backupBatch.getErrorCode())) {
            comments = "Backup Deferred.";
        }
        if ("1207".equals(backupBatch.getErrorCode())) {
            comments = officeProduct ? "Admin stopped BackUp manually" : "User stopped BackUp manually";
        }
        if ("1208".equals(backupBatch.getErrorCode())) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(backupBatch.getErrorCode())) {
            comments = "Admin stopped BackUp manually";
        }
        if ("543".equals(backupBatch.getErrorCode())) {
            comments = "OneDrive target not assigned";
        }
        if ("544".equals(backupBatch.getErrorCode())) {
            comments = "Invalid Mailbox License";
        }
        if ("1211".equals(backupBatch.getErrorCode())) {
            comments = "Pre scan command failed.";
        }
        if ("1210".equals(backupBatch.getErrorCode())) {
            comments = "Pre backup command failed.";
        }
        if ("1212".equals(backupBatch.getErrorCode())) {
            comments = "Access denied";
        }
        if ("1310".equals(backupBatch.getErrorCode())) {
            comments = "Admin stopped queue manually";
        }
        if ("1311".equals(backupBatch.getErrorCode())) {
            comments = "Admin stopped scanning manually";
        }
        return comments;
    }

    @Override
    public boolean createAuditHistoryExcel(int cloudId, List<String> mcList, String fromDate, String toDate, String disPlayName, boolean isScheduleMail) {
        List auditList = this.auditHistoryDao.getAllMCAuditHistory(cloudId, mcList, fromDate, toDate);
        if (CollectionUtils.isEmpty((Collection)auditList)) {
            return false;
        }
        this.createExcelForAH(auditList, fromDate, toDate, disPlayName, isScheduleMail);
        return true;
    }

    private void createExcelForAH(List<AuditHistory> auditList, String fromDate, String toDate, String disPlayName, boolean isScheduleMail) {
        logger.debug("inside the createExcelBackupHistory ");
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List<List> recordToAdd = this.updateValuesToExcelforAH(auditList, fromDate, toDate, isScheduleMail);
            this.createExcelForXlsx(recordToAdd, workbook);
            String fileName = "MiniCloud_AuditHistory.xlsx";
            if (!StringUtils.isEmpty((String)disPlayName)) {
                fileName = disPlayName;
            }
            this.writeExcelForReport(workbook, PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + fileName);
        }
        catch (Exception e) {
            logger.debug("Exception while creating the excel sheet for BackupHistory" + e.getMessage());
            logger.debug("Exception while creating the excel sheet for BackupHistory" + e);
        }
    }

    private List<List> updateValuesToExcelforAH(List<AuditHistory> list, String fromDate, String toDate, boolean isScheduleMail) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_NAME);
        headerRow.add("MiniCloud Name");
        headerRow.add("Date");
        headerRow.add("Action");
        headerRow.add("Action Type");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> userInputsRow = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)fromDate) && StringUtils.isNotEmpty((String)toDate)) {
            sb.append(FROMDATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(fromDate)) + "   " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(toDate)));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        recordToAdd.add(headerRow);
        for (AuditHistory audit : list) {
            if (isScheduleMail && audit.getActionType() != 0 && (PCActionTypes.getActionType((int)audit.getActionType()).equalsIgnoreCase("MINI_CLOUD_REVOKED") || PCActionTypes.getActionType((int)audit.getActionType()).equalsIgnoreCase("MINI_CLOUD_ASSIGN") || PCActionTypes.getActionType((int)audit.getActionType()).equalsIgnoreCase("MINI_CLOUD_UPDATE") || PCActionTypes.getActionType((int)audit.getActionType()).equalsIgnoreCase("MINI_CLOUD_EXPIRED") || PCActionTypes.getActionType((int)audit.getActionType()).equalsIgnoreCase("BACKUP_POLICY_UPDATE"))) continue;
            String deviceType = "";
            String actionOn = "";
            if (!StringUtils.isEmpty((String)audit.getActionUsingObject())) {
                deviceType = " using " + audit.getActionUsingObject();
            }
            if (!StringUtils.isEmpty((String)audit.getActionOnObject())) {
                actionOn = audit.getActionOnObject();
            }
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add("" + audit.getActionByUserName());
            firstRow.add("" + audit.getMcName());
            firstRow.add("" + new Date(audit.getTimestamp()).toString());
            firstRow.add("" + audit.getActionByUserName() + " " + audit.getAction() + " " + actionOn + " " + deviceType);
            logger.debug("...." + audit.getActionType());
            try {
                firstRow.add("" + PCActionTypes.getActionType((int)audit.getActionType()));
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
                logger.debug("Exception to get action type for code :" + audit.getActionType());
                firstRow.add("" + audit.getAction());
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    @Override
    public boolean createPdfForAuditHistory(int cloudId, List<String> mcList, String fromDate, String toDate) {
        List auditList = this.auditHistoryDao.getAllMCAuditHistory(cloudId, mcList, fromDate, toDate);
        if (CollectionUtils.isEmpty((Collection)auditList)) {
            return false;
        }
        List<AuditHistoryElement> ahElementList = this.getAuditHistoryElementsForPdf(auditList);
        this.createPdfForAuditHistoryReport(ahElementList, fromDate, toDate);
        return true;
    }

    private void createPdfForAuditHistoryReport(List<AuditHistoryElement> auditHistoryElementList, String fromDate, String toDate) {
        try {
            String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Minicloud_Audit_History1.pdf";
            String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Minicloud_Audit_History.pdf";
            String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
            StringBuilder htmlContent = new StringBuilder();
            htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>Report generated on " + currentDate + "</p>");
            if (StringUtils.isNotEmpty((String)fromDate) && StringUtils.isNotEmpty((String)toDate)) {
                htmlContent.append("<p>From Date :" + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getStartOfDay(fromDate)) + "  " + TODATE + ReportServiceImpl.getTimeZoneShortFormatwithoutTime(ReportServiceImpl.getEndOfDay(toDate)) + "</p>");
            }
            try {
                this.HeaderOfPdfForAHhistoryReport(htmlContent);
                this.updateAuditHistoryDataOnPdf(auditHistoryElementList, htmlContent);
                htmlContent.append("</table>").append("</body>").append("</html>");
                logger.debug(htmlContent + "htmlContent............");
                FileOutputStream outputStream = new FileOutputStream(new File(file));
                PdfRendererBuilder builder = new PdfRendererBuilder();
                builder.withHtmlContent(htmlContent.toString(), null);
                builder.useDefaultPageSize(594.0f, 420.0f, BaseRendererBuilder.PageSizeUnits.MM);
                builder.toStream((OutputStream)outputStream);
                builder.run();
                ((OutputStream)outputStream).close();
                logger.debug("PDF created successfully at " + file);
                logger.debug("PDF created successfully.");
                this.addWatermarkToPDF(file, outPutFile, 1);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the pdf sheet for BackupHistory" + e.getMessage());
                logger.debug("Exception while creating the pdf sheet for BackupHistory" + e);
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception:" + e.getMessage());
            logger.trace(EXCEPTION + e);
        }
    }

    private void updateAuditHistoryDataOnPdf(List<AuditHistoryElement> auditHistoryElementList, StringBuilder htmlContent) {
        long slno = 0L;
        for (AuditHistoryElement auditHistoryElement : auditHistoryElementList) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + auditHistoryElement.getActionByUserName() + "</td>");
            htmlContent.append("<td>" + auditHistoryElement.getMcName() + "</td>");
            htmlContent.append("<td>" + new Date(auditHistoryElement.getTimestampInLong()).toString() + "</td>");
            htmlContent.append("<td>" + auditHistoryElement.getAction() + "</td>");
            String actionType = auditHistoryElement.getFileCompletePath();
            htmlContent.append("<td>" + actionType + "</td>");
        }
    }

    private void HeaderOfPdfForAHhistoryReport(StringBuilder htmlContent) {
        htmlContent.append("<table>").append("<tr>").append("<th>Sl No</th>");
        htmlContent.append("<th>User Name</th>");
        htmlContent.append("<th>MiniCloud Name</th>");
        htmlContent.append("<th>Date</th>");
        htmlContent.append("<th>Action</th>");
        htmlContent.append("<th>Action Type</th>");
        htmlContent.append("</tr>");
    }

    private List<AuditHistoryElement> getAuditHistoryElementsForPdf(List<AuditHistory> auditList) {
        ArrayList<AuditHistoryElement> auditHistoryElements = new ArrayList<AuditHistoryElement>();
        long slno = 0L;
        String mcName = "MiniCloud Name";
        String userName = USER_NAME;
        for (AuditHistory auditHistory : auditList) {
            ++slno;
            AuditHistoryElement auditHistoryElement = new AuditHistoryElement();
            auditHistoryElement.setActionByUserName(auditHistory.getActionByUserName());
            userName = USER_NAME.length() < auditHistory.getActionByUserName().length() ? auditHistory.getActionByUserName() : USER_NAME;
            auditHistoryElement.setMcName(auditHistory.getMcName());
            mcName = "MiniCloud Name".length() < auditHistory.getMcName().length() ? auditHistory.getMcName() : "MiniCloud Name";
            auditHistoryElement.setTimestampInLong(Long.valueOf(auditHistory.getTimestamp()));
            String action = auditHistory.getAction();
            String deviceType = "";
            String actionOn = "";
            if (!StringUtils.isEmpty((String)auditHistory.getActionUsingObject())) {
                deviceType = " using " + auditHistory.getActionUsingObject();
            }
            if (!StringUtils.isEmpty((String)auditHistory.getActionOnObject())) {
                actionOn = auditHistory.getActionOnObject();
            }
            String actionval = "" + auditHistory.getActionByUserName() + " " + auditHistory.getAction() + " " + actionOn + " " + deviceType;
            auditHistoryElement.setAction(actionval);
            String actionType = "";
            try {
                actionType = PCActionTypes.getActionType((int)auditHistory.getActionType());
            }
            catch (Exception e) {
                logger.error(auditHistory.getAction() + "..exception for action type..." + auditHistory.getActionType());
                actionType = action;
            }
            auditHistoryElement.setFileCompletePath(actionType);
            auditHistoryElements.add(auditHistoryElement);
        }
        return auditHistoryElements;
    }

    @Override
    public List<DailyUserBackupOverViewElement> getStorageStatisticsForPolicy(int cloudId, ReportQueryElement reportQueryElement) {
        ArrayList userNames = new ArrayList();
        ArrayList<DeviceBackupOverView> list = new ArrayList();
        logger.debug("....storage ustilization newdao....");
        list = this.deviceDao.getDeviceBackupOVerviewList(cloudId, reportQueryElement);
        if (!CollectionUtils.isEmpty(list)) {
            logger.debug("..storage utiliz result ..." + list.size());
        }
        List<DailyUserBackupOverViewElement> overviewList = this.getDailyUserBkpoverElement(cloudId, list);
        return overviewList;
    }

    private List<List> updateValuesToProductOverviewExcel(Cloud cloud, productOverviewElement productOverviewElement2, long reportDate) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        LicenseElement licenseElement = productOverviewElement2.getLicenseElement();
        ArrayList<String> licenseInfo9 = new ArrayList<String>();
        licenseInfo9.add("Cloud Name");
        licenseInfo9.add(licenseElement.getCloudName());
        ArrayList<String> licenseInfo = new ArrayList<String>();
        licenseInfo.add("Timezone");
        licenseInfo.add(TimeZone.getDefault().getID());
        ArrayList<String> licenseInfo1 = new ArrayList<String>();
        licenseInfo1.add("Validity ");
        licenseInfo1.add(this.getDate(licenseElement.getValidityPeriod()));
        ArrayList<String> licenseInfo2 = new ArrayList<String>();
        licenseInfo2.add("Cloud Size Allowed");
        licenseInfo2.add(String.valueOf(licenseElement.getCloudSizeAllowed()) + " GB");
        ArrayList<String> licenseInfo3 = new ArrayList<String>();
        licenseInfo3.add("No.of Users Allowed for Backup");
        licenseInfo3.add(String.valueOf(licenseElement.getNoOfUsersAllowedWithBackup()));
        ArrayList<String> licenseInfo4 = new ArrayList<String>();
        licenseInfo4.add("No.of Users Allowed for Sync");
        licenseInfo4.add(String.valueOf(licenseElement.getNoOfUsersAllowedWithSync()));
        ArrayList<String> licenseInfo5 = new ArrayList<String>();
        licenseInfo5.add("No.of Exchange Users Allowed");
        licenseInfo5.add(String.valueOf(licenseElement.getNoOfExchangeUsersAllowed()));
        ArrayList<String> licenseInfo6 = new ArrayList<String>();
        licenseInfo6.add("No.of OneDrive Users Allowed");
        licenseInfo6.add(String.valueOf(licenseElement.getNoOfOneDriveUsersAllowed()));
        ArrayList<String> licenseInfo7 = new ArrayList<String>();
        licenseInfo7.add("No.of MiniClouds Allowed");
        licenseInfo7.add(String.valueOf(licenseElement.getNoOfMiniCloudsAllowed()));
        ArrayList<String> licenseInfo8 = new ArrayList<String>();
        licenseInfo8.add("Content Search Allowed");
        if (licenseElement.getContentSearchAllowed() == 1) {
            licenseInfo8.add("True");
        } else {
            licenseInfo8.add("False");
        }
        ArrayList<String> licenseInfo10 = new ArrayList<String>();
        licenseInfo10.add("BluVault");
        licenseInfo10.add(String.valueOf(licenseElement.isBackupEnabled()));
        ArrayList<String> licenseInfo11 = new ArrayList<String>();
        licenseInfo11.add("BluSync ");
        licenseInfo11.add(String.valueOf(licenseElement.isSyncEnabled()));
        ArrayList<String> licenseInfo12 = new ArrayList<String>();
        licenseInfo12.add("OneDrive for Business Backup");
        licenseInfo12.add(String.valueOf(licenseElement.isOneDriveBackupEnabled()));
        ArrayList<String> licenseInfo13 = new ArrayList<String>();
        licenseInfo13.add("Microsoft Exchange Backup");
        licenseInfo13.add(String.valueOf(licenseElement.isExchangeBackupEnabled()));
        ArrayList<String> licenseInfo14 = new ArrayList<String>();
        licenseInfo14.add("Malware Scan");
        licenseInfo14.add(String.valueOf(licenseElement.isAntivirusLicense()));
        ArrayList<String> licenseInfo15 = new ArrayList<String>();
        licenseInfo15.add("SQL License");
        licenseInfo15.add(String.valueOf(licenseElement.isSQLLicense()));
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(reportDate));
        recordToAdd.add(headerRow1);
        recordToAdd.add(licenseInfo9);
        recordToAdd.add(licenseInfo1);
        recordToAdd.add(licenseInfo);
        recordToAdd.add(licenseInfo2);
        recordToAdd.add(licenseInfo10);
        recordToAdd.add(licenseInfo3);
        recordToAdd.add(licenseInfo11);
        recordToAdd.add(licenseInfo4);
        recordToAdd.add(licenseInfo7);
        recordToAdd.add(licenseInfo12);
        recordToAdd.add(licenseInfo6);
        recordToAdd.add(licenseInfo13);
        recordToAdd.add(licenseInfo5);
        recordToAdd.add(licenseInfo8);
        recordToAdd.add(licenseInfo14);
        recordToAdd.add(licenseInfo15);
        ArrayList<String> licenseConsRow = new ArrayList<String>();
        licenseConsRow.add("License Consumption");
        ArrayList<String> licenseConsRowHeading = new ArrayList<String>();
        licenseConsRowHeading.add("License");
        licenseConsRowHeading.add("Total");
        licenseConsRowHeading.add("Active");
        ArrayList<String> licenseConsRowValues = new ArrayList<String>();
        licenseConsRowValues.add("Users");
        licenseConsRowValues.add(String.valueOf(licenseElement.getTotalUsers()));
        licenseConsRowValues.add(String.valueOf(licenseElement.getTotalActiveUsers()));
        ArrayList<String> licenseConsRowValues1 = new ArrayList<String>();
        licenseConsRowValues1.add("Devices");
        licenseConsRowValues1.add(String.valueOf(licenseElement.getTotalDevices()));
        licenseConsRowValues1.add(String.valueOf(licenseElement.getTotalActiveDevices()));
        ArrayList<String> licenseConsRowValues2 = new ArrayList<String>();
        licenseConsRowValues2.add("Backup Users");
        licenseConsRowValues2.add(String.valueOf(licenseElement.getTotalBackupUsers()));
        licenseConsRowValues2.add(String.valueOf(licenseElement.getActiveBackupUsers()));
        ArrayList<String> licenseConsRowValues3 = new ArrayList<String>();
        licenseConsRowValues3.add("Sync Users");
        licenseConsRowValues3.add(String.valueOf(licenseElement.getTotalSyncUser()));
        licenseConsRowValues3.add(String.valueOf(licenseElement.getActiveSyncUser()));
        ArrayList<String> licenseConsRowValues4 = new ArrayList<String>();
        licenseConsRowValues4.add("OneDrive for Backup Users");
        licenseConsRowValues4.add(String.valueOf(licenseElement.getTotalOneDriveUsers()));
        licenseConsRowValues4.add(String.valueOf(licenseElement.getActiveOneDriveUsers()));
        ArrayList<String> licenseConsRowValues5 = new ArrayList<String>();
        licenseConsRowValues5.add("Exchange for Backup Users");
        licenseConsRowValues5.add(String.valueOf(licenseElement.getTotalExchangeUsers()));
        licenseConsRowValues5.add(String.valueOf(licenseElement.getActiveExchangeUsers()));
        ArrayList<String> serverStatistics = new ArrayList<String>();
        serverStatistics.add("Server Statistics");
        ArrayList<String> serverStatisticsValues = new ArrayList<String>();
        serverStatisticsValues.add("Total Users\t");
        serverStatisticsValues.add(String.valueOf(licenseElement.getTotalUsers()));
        ArrayList<String> serverStatisticsValues1 = new ArrayList<String>();
        serverStatisticsValues1.add("Active Users");
        serverStatisticsValues1.add(String.valueOf(licenseElement.getTotalActiveUsers()));
        ArrayList<String> serverStatisticsValues2 = new ArrayList<String>();
        serverStatisticsValues2.add("Blocked Users");
        serverStatisticsValues2.add(String.valueOf(licenseElement.getTotalUsers() - licenseElement.getTotalActiveUsers()));
        recordToAdd.add(licenseConsRow);
        recordToAdd.add(licenseConsRowHeading);
        recordToAdd.add(licenseConsRowValues1);
        recordToAdd.add(licenseConsRowValues2);
        recordToAdd.add(licenseConsRowValues3);
        recordToAdd.add(licenseConsRowValues4);
        recordToAdd.add(licenseConsRowValues5);
        recordToAdd.add(serverStatistics);
        recordToAdd.add(serverStatisticsValues1);
        recordToAdd.add(serverStatisticsValues2);
        return recordToAdd;
    }

    private List<List> updateValuesToProductOverviewExcel1(Cloud cloud, productOverviewElement productOverviewElement2, long reportDate) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> firstRow = null;
        try {
            ArrayList<String> headerRow = new ArrayList<String>();
            headerRow.add("Policy Name");
            headerRow.add("Product Type");
            headerRow.add("No. of Users");
            headerRow.add("Storage Usage (GB)");
            headerRow.add("Total Size of Backed Up Files (GB)");
            ArrayList<String> headerRow1 = new ArrayList<String>();
            headerRow1.add("Policy Statistics");
            recordToAdd.add(headerRow1);
            recordToAdd.add(headerRow);
            List backupPolicyStatisticsElement = productOverviewElement2.getBackupPolicyStatisticsElement();
            Collections.sort(backupPolicyStatisticsElement, new Comparator<PolicyStatisticsElement>(){

                @Override
                public int compare(PolicyStatisticsElement u1, PolicyStatisticsElement u2) {
                    if (u1 == null || u2 == null || u1.getPolicygroupName() == null || u2.getPolicygroupName() == null) {
                        return -1;
                    }
                    return new CompareToBuilder().append((Object)u1.getPolicygroupName().toLowerCase(), (Object)u2.getPolicygroupName().toLowerCase()).toComparison();
                }
            });
            for (PolicyStatisticsElement backupPolicyElement : backupPolicyStatisticsElement) {
                firstRow = new ArrayList<String>();
                firstRow.add(backupPolicyElement.getPolicygroupName());
                firstRow.add(backupPolicyElement.getProductType());
                firstRow.add(backupPolicyElement.getMappedUserCount());
                if (backupPolicyElement.getProductType().equalsIgnoreCase("Blusync")) {
                    firstRow.add("NA");
                    firstRow.add("NA");
                } else {
                    firstRow.add(String.valueOf(backupPolicyElement.getActualStorageUtilized()));
                    firstRow.add(String.valueOf(backupPolicyElement.getTotalSizeofDataBackedup()));
                }
                recordToAdd.add(firstRow);
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(" Exception in calculating percent  " + e.getMessage());
        }
        return recordToAdd;
    }

    private List<List> updateValuesToProductOverviewExcel2(Cloud cloud, productOverviewElement productOverviewElement2, long reportDate) {
        List bkpOverViewList = productOverviewElement2.getBackupOverviewElementList();
        Collections.sort(bkpOverViewList, new Comparator<BackupOverviewElement>(){

            @Override
            public int compare(BackupOverviewElement u1, BackupOverviewElement u2) {
                if (u1 == null || u2 == null || u1.getUserId() == null || u2.getUserId() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserId().toLowerCase(), (Object)u2.getUserId().toLowerCase()).toComparison();
            }
        });
        boolean showAdditionalAdAttrbs = PCHelperConstant.showAdditionalAdAttrbs();
        boolean showAddReportAttrbs = PCHelperConstant.showAddReportAttr();
        boolean isO365BkpEnabled = ReportServiceImpl.isODBBackupEnabled(cloud.getCloudCustomisableDetails());
        boolean isODBEnabled = ReportServiceImpl.isODBEnabled(cloud.getCloudCustomisableDetails());
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("User ID");
        headerRow.add("Email ID");
        headerRow.add(USER_STATUS);
        headerRow.add("Asset Name");
        headerRow.add(DEVICE_STATUS);
        headerRow.add(DEVICE_INSTALLATION_TIME);
        headerRow.add("Os Type");
        headerRow.add(CLIENT_VERSION);
        if (isShowUserConsentFieldInPolicies.booleanValue()) {
            headerRow.add(CONSENT_GIVEN);
            headerRow.add(CONSENT_GIVEN_TIME);
        }
        headerRow.add(POLICY_NAME);
        if (isO365BkpEnabled) {
            headerRow.add("Office 365 Policy Name");
        }
        if (isODBEnabled) {
            headerRow.add("Backup Target Assigned");
            headerRow.add(REASON);
        }
        headerRow.add(FIRST_BACKUP_START_TIME);
        headerRow.add(FIRST_BACKUP_END_TIME);
        headerRow.add("Full Backup Completed");
        headerRow.add(LAST_SUCCESSFUL_BACKUP_STRAT_TIME);
        headerRow.add(LAST_SUCCESSFUL_BACKUO_END_TIME);
        if (showAddReportAttrbs) {
            headerRow.add("Last Backup Start Time");
            headerRow.add("Last Backup End Time");
        }
        headerRow.add(IS_LAST_BACKUP_COMPLETED);
        headerRow.add(CURRENT_BACKUP_START_TIME);
        headerRow.add(CURRENT_BACKUP_STATUS);
        headerRow.add(CURRENT_BACKUP_COMPLETION);
        headerRow.add(IS_BACKUP_RUNNING);
        headerRow.add(LAST_TIME_HEARD);
        headerRow.add(TOTAL_STORAGE_UTILIZED);
        headerRow.add(NOTES);
        if (showAdditionalAdAttrbs) {
            headerRow.add(DISPLAY_NAME);
            headerRow.add(LOCATION);
            headerRow.add(DEPARTMENT);
            if (ReportServiceImpl.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                headerRow.add(AZURE_ACTIVE_DIRECTORY_USER_STATUS);
            } else {
                headerRow.add(ACTIVE_DIRECTORY_USER_STATUS);
            }
        }
        headerRow.add("Full Backup Size");
        headerRow.add("Full Backup No. of Files");
        headerRow.add("Last Successful Backup Size");
        headerRow.add("Last Successful Backup No. of Files");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Backup Overview");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            try {
                boolean isBackupRunningStatus;
                boolean isBackupRunning;
                String lastBkpStatus;
                long firstBkpStartTime;
                firstRow.add(backupOverviewElement.getUserId());
                firstRow.add(backupOverviewElement.getEmailId());
                String userActive = ReportServiceImpl.getUserActiveStatus(backupOverviewElement);
                firstRow.add(userActive);
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    firstRow.add(backupOverviewElement.getDeviceName());
                } else {
                    firstRow.add("-");
                }
                boolean isDeviceActive = backupOverviewElement.isDeviceActive();
                String deviceActive = ReportServiceImpl.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                if (!StringUtils.isEmpty((String)deviceActive)) {
                    firstRow.add(deviceActive);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                    firstRow.add(backupOverviewElement.getEpaInstallationDate());
                } else {
                    firstRow.add("-");
                }
                String osVersionBits = "";
                if (!StringUtils.isEmpty((String)backupOverviewElement.getOsVersion())) {
                    osVersionBits = !StringUtils.isEmpty((String)backupOverviewElement.getOsType()) && backupOverviewElement.getOsType().startsWith("Window") ? (backupOverviewElement.getOsVersion().contains("(") ? "(" + backupOverviewElement.getOsVersion().substring(backupOverviewElement.getOsVersion().indexOf("(") + 1, backupOverviewElement.getOsVersion().indexOf(")")) + ")" : backupOverviewElement.getOsVersion()) : backupOverviewElement.getOsVersion();
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getOsType())) {
                    firstRow.add(backupOverviewElement.getOsType() + osVersionBits);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getClientVersion())) {
                    firstRow.add(backupOverviewElement.getClientVersion());
                } else {
                    firstRow.add("-");
                }
                if (isShowUserConsentFieldInPolicies.booleanValue()) {
                    if (backupOverviewElement.getOsType().startsWith("Window") || backupOverviewElement.getOsType().startsWith("Mac")) {
                        firstRow.add(backupOverviewElement.getConsentGiven());
                        firstRow.add(backupOverviewElement.getConsentGivenTime());
                    } else {
                        firstRow.add("");
                        firstRow.add("");
                    }
                }
                firstRow.add(backupOverviewElement.getPolicyName());
                if (isO365BkpEnabled) {
                    firstRow.add(backupOverviewElement.getOneDrivePolicyName());
                }
                if (isODBEnabled) {
                    if (backupOverviewElement.isBackupTargetAssigned()) {
                        firstRow.add("Yes");
                    } else {
                        firstRow.add("No");
                    }
                    if (backupOverviewElement.isBackupTargetAssigned() & backupOverviewElement.getBackupTargetErrorCode() == 0) {
                        firstRow.add("");
                    } else {
                        firstRow.add(ReportServiceImpl.getCommentsForErrorCode(backupOverviewElement.getBackupTargetErrorCode()));
                    }
                }
                if (!StringUtils.isEmpty((String)ReportServiceImpl.getDateInFormat(firstBkpStartTime = ReportServiceImpl.getFirstBkpStartTime(backupOverviewElement), "dd-MMM-yyyy HH:mm:ss"))) {
                    firstRow.add(ReportServiceImpl.getDateInFormat(firstBkpStartTime, "dd-MMM-yyyy HH:mm:ss"));
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    firstRow.add(backupOverviewElement.getFirstBkpEndTime());
                } else {
                    firstRow.add("-");
                }
                String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)lastSuccessfulBackupEndTime);
                String firstBkpCompleted = ReportServiceImpl.getFirstBkpCompletedState(isFirstBkpCompleted);
                firstRow.add(firstBkpCompleted);
                String lastSuccessBkpStartTime = "";
                if (isFirstBkpCompleted) {
                    long lstBkpEndTime;
                    long lstBkpStartTime;
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getFirstBkpStartTime());
                        backupOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getFirstBkpEndTime());
                    }
                    if ((lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime())) > (lstBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpEndTime = lstBkpStartTime + 0x6DDD00L;
                    }
                    lastSuccessBkpStartTime = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy HH:mm:ss");
                    lastSuccessfulBackupEndTime = ReportServiceImpl.getDateInFormat(lstBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                }
                if (!StringUtils.isEmpty((String)lastSuccessBkpStartTime)) {
                    firstRow.add(lastSuccessBkpStartTime);
                } else {
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndTime)) {
                    firstRow.add(lastSuccessfulBackupEndTime);
                } else {
                    firstRow.add("-");
                }
                if (showAddReportAttrbs) {
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpStartTime())) {
                        firstRow.add(backupOverviewElement.getLastBkpStartTime());
                    } else {
                        firstRow.add("-");
                    }
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        firstRow.add(backupOverviewElement.getLastBkpEndTime());
                    } else {
                        firstRow.add("-");
                    }
                }
                if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                    lastBkpStatus = "-";
                }
                if (backupOverviewElement.isLastBackupCompleted()) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                boolean bl = isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
                if (!StringUtils.isEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && isBackupRunning) {
                    String lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime();
                    if (StringUtils.isNotEmpty((String)lstBkpStartTimeStr) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                        long lstsuccessBkpEndTime;
                        long lstBkpStartTime = ReportServiceImpl.getTime(backupOverviewElement.getLastBkpStartTime());
                        if (lstBkpStartTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                            lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                        }
                        lstBkpStartTimeStr = ReportServiceImpl.getDateInFormat(lstBkpStartTime, "dd-MMM-yyyy HH:mm:ss");
                    }
                    firstRow.add(lstBkpStartTimeStr);
                } else {
                    firstRow.add("-");
                }
                if (lastBkpStatus.equalsIgnoreCase(COMPLETED) || !isBackupRunning) {
                    firstRow.add("-");
                } else {
                    firstRow.add(lastBkpStatus);
                }
                int totalNoOfFiles = 0;
                boolean noOfFilesRemaining = false;
                if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
                    totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
                }
                long percentage = 0L;
                percentage = backupOverviewElement.getTotalSizeToUploadInKB() != 0L && backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalSizeToUploadInKB(), backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : ReportServiceImpl.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
                if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && lastBkpStatus.equalsIgnoreCase(STATUS_STARTED) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining())) {
                    firstRow.add(String.valueOf(percentage) + "%");
                } else {
                    firstRow.add("-");
                }
                boolean bl2 = isBackupRunningStatus = StringUtils.isNotEmpty((String)lastBkpStatus) && !COMPLETED.equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
                if (isBackupRunningStatus) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    String lastAccessTime = ReportServiceImpl.getDateInFormat(backupOverviewElement.getLastAccessedTime(), "dd-MMM-yyyy HH:mm:ss");
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        lastHeardDate = lastAccessTime;
                    } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                        lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                    } else {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                            Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                            Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                            lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                        }
                        catch (Exception e) {
                            logger.error("...unable to process date...... " + e.getMessage());
                            logger.trace(EXCEPTION + e);
                        }
                    }
                    long lastHeardDateTime = ReportServiceImpl.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = ReportServiceImpl.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = ReportServiceImpl.getDateInFormat(lstsuccessBkpEndTime, "dd-MMM-yyyy HH:mm:ss");
                    }
                    firstRow.add(lastHeardDate);
                } else {
                    firstRow.add("-");
                }
                firstRow.add(backupOverviewElement.getStorageUtilized());
                firstRow.add(backupOverviewElement.getReason());
                if (showAdditionalAdAttrbs) {
                    firstRow.add(backupOverviewElement.getDisplayName());
                    firstRow.add(backupOverviewElement.getLocation());
                    firstRow.add(backupOverviewElement.getDepartment());
                    if (backupOverviewElement.isAccountStatus()) {
                        firstRow.add("Y");
                    } else {
                        firstRow.add("N");
                    }
                }
                if (isFirstBkpCompleted) {
                    firstRow.add(backupOverviewElement.getFirstFullBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getFirstFullBkpNoOfFiles());
                    firstRow.add(backupOverviewElement.getLastSucessfulBkpTotalSizeOfFiles());
                    firstRow.add("" + backupOverviewElement.getLastSucessfulBkpNoOfFiles());
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                    firstRow.add("-");
                    firstRow.add("-");
                }
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(" Exception in calculating percent  " + e.getMessage());
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforBackupHistoryInProductOverview(List<BackupHistoryElement> backupHistoryElements) {
        logger.debug("inside the Report for BackupHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_NAME);
        headerRow.add("Asset Name");
        headerRow.add(START_TIME);
        headerRow.add(END_TIME);
        headerRow.add(FILES_BACKED_UP);
        headerRow.add(REMARKS);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Last Backup Status");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(backupHistoryElements, new Comparator<BackupHistoryElement>(){

            @Override
            public int compare(BackupHistoryElement u1, BackupHistoryElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getEndTime());
            firstRow.add(Long.toString(backupHistoryElement.getNoOfFiles()));
            firstRow.add(backupHistoryElement.getAction());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforFailedHistoryInProductOverview(NotificationElementList notificationElementList) {
        logger.debug("inside the Report for Failed Backup History ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(USER_NAME);
        headerRow.add("Asset Name");
        headerRow.add(START_TIME);
        headerRow.add(END_TIME);
        headerRow.add(REASON);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Failed Backup History");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        List backupHistoryElementList = notificationElementList.getNotificationHistoryElementList();
        Collections.sort(backupHistoryElementList, new Comparator<NotificationHistoryElement>(){

            @Override
            public int compare(NotificationHistoryElement u1, NotificationHistoryElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (NotificationHistoryElement backupHistoryElement : backupHistoryElementList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getFailedReason());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforBlockedUsersInProductOverview(List<UserElement> allBlockedUsers) {
        logger.debug("inside the Report for blocked users.....");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_ID);
        headerRow.add(DISPLAY_NAME);
        headerRow.add(EMAIL_ID);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Blocked Users");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(allBlockedUsers, new Comparator<UserElement>(){

            @Override
            public int compare(UserElement u1, UserElement u2) {
                if (u1 == null || u2 == null || u1.getUserName() == null || u2.getUserName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getUserName().toLowerCase(), (Object)u2.getUserName().toLowerCase()).toComparison();
            }
        });
        for (UserElement backupHistoryElement : allBlockedUsers) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            if (StringUtils.isNotEmpty((String)backupHistoryElement.getDisplayName())) {
                firstRow.add(backupHistoryElement.getDisplayName());
            } else {
                firstRow.add("-");
            }
            firstRow.add(backupHistoryElement.getEmailId());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private List<List> updateValuesToExcelforPolicyMapInProductOverview(List<UserPolicyMappingElement> list) {
        logger.debug("inside the Report for policy mapping .......");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(POLICY_NAME);
        headerRow.add("Product Type");
        headerRow.add("Mapped Users");
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add("Policy Mapping");
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        Collections.sort(list, new Comparator<UserPolicyMappingElement>(){

            @Override
            public int compare(UserPolicyMappingElement u1, UserPolicyMappingElement u2) {
                if (u1 == null || u2 == null || u1.getPolicyName() == null || u2.getPolicyName() == null) {
                    return -1;
                }
                return new CompareToBuilder().append((Object)u1.getPolicyName().toLowerCase(), (Object)u2.getPolicyName().toLowerCase()).toComparison();
            }
        });
        for (UserPolicyMappingElement userPolicyMappingElement : list) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(userPolicyMappingElement.getPolicyName());
            firstRow.add(userPolicyMappingElement.getProductType());
            if (!CollectionUtils.isEmpty((Collection)userPolicyMappingElement.getUserNames())) {
                String userNames = "";
                for (String un : userPolicyMappingElement.getUserNames()) {
                    if (StringUtils.isNotEmpty((String)userNames)) {
                        userNames = userNames + "," + un;
                        continue;
                    }
                    userNames = un;
                }
                firstRow.add(userNames);
            } else {
                firstRow.add("-");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    @Override
    public void CreateEmptyFile(File f) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook();
            ArrayList<List> recordToAdd = new ArrayList<List>();
            String currentDate = ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis());
            ArrayList<String> headerRow1 = new ArrayList<String>();
            headerRow1.add("REPORT_GENERATED_ON " + currentDate);
            recordToAdd.add(headerRow1);
            ArrayList<String> headerRow = new ArrayList<String>();
            headerRow.add("No records found");
            recordToAdd.add(headerRow);
            this.createExcelForXlsx(recordToAdd, workbook);
            try (FileOutputStream fos = new FileOutputStream(new File(f.getPath()));){
                XSSFCellStyle hsfstyle = workbook.createCellStyle();
                hsfstyle.setBorderBottom((short)1);
                hsfstyle.setFillBackgroundColor((short)245);
                workbook.write((OutputStream)fos);
            }
            catch (Exception e) {
                logger.error("error in CreateEmptyFile", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("error in CreateEmptyFile", (Throwable)e);
        }
    }

    @Override
    public boolean createPdfForPolicy(Cloud cloud, String policyName, User currentUser) {
        BackupPolicy bkpPolicy = this.userDao.getBackupPolicyByPolicyName(cloud.getCloudId(), policyName);
        this.createPdfForPolicy(cloud, bkpPolicy, currentUser);
        return true;
    }

    @Override
    public boolean createPdfForSyncPolicy(Cloud cloud, String policyName) {
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloud.getCloudId(), policyName);
        this.createPdfForSyncPolicy(cloud, syncPolicy);
        return true;
    }

    @Override
    public boolean createPdfForOfficePolicy(Cloud cloud, String policyName, String produtName) {
        OfficeBackupPolicy OfficeBackupPolicypPolicy = this.userDao.getOfficeBackupPolicyByPolicyName(cloud.getCloudId(), policyName);
        this.createPdfForOfficePolicy(cloud, OfficeBackupPolicypPolicy, produtName);
        return true;
    }

    private StringBuilder pdfHeadingDetails(StringBuilder htmlContent) {
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append("body { font-family: Arial, sans-serif;margin: 20px;}").append(".container {display: flex;flex-wrap: wrap;}").append(".column { flex: 1; padding: 10px; box-sizing: border-box;}").append(".heading {font-size: 13px; font-weight: bold; margin-bottom: 10px;color: gray; }").append(".subHeading {font-size:19px;font-weight: bold; margin-bottom: 10px;  color: orange; }").append(".content {font-size: 11px;padding-left: 20px;padding-bottom: 10px;}").append(".page-break { page-break-before: always;}").append("</style>").append("</head>").append("<body>").append("<div class=\"container\">");
        return htmlContent;
    }

    private StringBuilder addPolicyDetails(StringBuilder htmlContent, String Name, String Value) {
        htmlContent.append("<div class=\"column\">").append("<div class=\"heading\">" + Name + " :</div>").append("<div class=\"content\">" + Value + "</div>").append("</div>");
        return htmlContent;
    }

    private StringBuilder addPolicyDetails(StringBuilder htmlContent, String Name) {
        htmlContent.append("<div class=\"column\">").append("<div class=\"heading\">" + Name + "</div>").append("</div>");
        return htmlContent;
    }

    private StringBuilder addpolicyDetailssubheading(StringBuilder htmlContent, String Name) {
        htmlContent.append("<div class=\"column\">").append("<div class=\"subHeading\">" + Name + "</div>");
        htmlContent.append("</div>");
        return htmlContent;
    }

    private StringBuilder addPolicyDetailsForList(StringBuilder htmlContent, String Name, List<String> list) {
        htmlContent.append("<div class=\"column\">").append("<div class=\"heading\">" + Name + "</div>");
        for (String Value : list) {
            htmlContent.append("<div class=\"content\">" + Value + "</div>");
        }
        htmlContent.append("</div>");
        return htmlContent;
    }

    private void createPdfForPolicy(Cloud cloud, BackupPolicy policy, User user) {
        block60: {
            try {
                String filename;
                CloudPropertyElement cloudPropertyElement;
                StringBuilder htmlContent = new StringBuilder();
                htmlContent = this.pdfHeadingDetails(htmlContent);
                boolean isMSPEnv = false;
                List cloudCustomisableDetails = cloud.getCloudCustomisableDetails();
                for (CloudCustomisableDetails customisableDetail : cloudCustomisableDetails) {
                    if (!MSP_ENV_ENABLED.equalsIgnoreCase(customisableDetail.getName())) continue;
                    isMSPEnv = true;
                }
                logger.debug("is MSP enabled={}", (Object)isMSPEnv);
                if (!isMSPEnv || user.isAdmin()) {
                    cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
                    filename = policy.getPolicyName() + "_1Policy.pdf";
                    String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filename;
                    String filenameFinal = policy.getPolicyName() + "_Policy.pdf";
                    String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filenameFinal;
                    this.addPolicyDetails(htmlContent, POLICYNAME, policy.getPolicyName());
                    this.addPolicyDetails(htmlContent, DESCRIPTION, policy.getDescription());
                    ArrayList<String> scheduleNames = new ArrayList<String>();
                    for (Object sch : policy.getSchedules()) {
                        scheduleNames.add(sch.getScheduleName() + " - " + sch.getTime() + "\n      ");
                    }
                    this.addPolicyDetailsForList(htmlContent, SCHEDULES, scheduleNames);
                    ArrayList<String> noBackupscheduleNames = new ArrayList<String>();
                    for (NoBkpSchedule sch : policy.getNoBkpSchedules()) {
                        noBackupscheduleNames.add(sch.getScheduleName() + " -  From Time: " + sch.getFromTime() + " To Time: " + sch.getToTime() + "\n      ");
                    }
                    this.addPolicyDetailsForList(htmlContent, NO_BACKUP_SCHEDULES, noBackupscheduleNames);
                    String maxver = String.valueOf(policy.getMaxVersions());
                    if (policy.getMaxVersions() == -1) {
                        maxver = "Unlimited";
                    }
                    this.addPolicyDetails(htmlContent, MAXVERSIONS, maxver);
                    String maxFileSize = String.valueOf(policy.getMaxFileSize());
                    if (policy.getMaxFileSize().equals("1048576")) {
                        maxFileSize = "Unlimited";
                    }
                    this.addPolicyDetails(htmlContent, MAXPERMISSIBLEFILESIZE, maxFileSize);
                    String perDeviceBackupStorage = String.valueOf(policy.getUserSizeAllowed());
                    if (policy.getUserSizeAllowed() == 102400) {
                        perDeviceBackupStorage = "Unlimited";
                    }
                    this.addPolicyDetails(htmlContent, STORAGELIMIT, perDeviceBackupStorage);
                    this.addPolicyDetails(htmlContent, MAXASSETSALLOWED, String.valueOf(policy.getNoOfDevicesAllowed()));
                    ArrayList<String> backupFolderPaths = new ArrayList<String>();
                    for (BackupFolders sch : policy.getBackupFolders()) {
                        backupFolderPaths.add(sch.getFolderPath() + "\n      ");
                    }
                    String backupFolderPath = backupFolderPaths.stream().collect(Collectors.joining(""));
                    this.addPolicyDetailsForList(htmlContent, DEFUALTFOLDERS, backupFolderPaths);
                    ArrayList<String> excludedFolderpaths = new ArrayList<String>();
                    if (policy.getExcludedFolders() != null) {
                        for (ExcludedFolders sch : policy.getExcludedFolders()) {
                            excludedFolderpaths.add(sch.getFolderPath() + "\n      ");
                        }
                    }
                    String string = excludedFolderpaths.stream().collect(Collectors.joining(""));
                    this.addPolicyDetailsForList(htmlContent, EXCLUDEDFOLDERS, excludedFolderpaths);
                    ArrayList<String> exceptionToExcludedFolderpaths = new ArrayList<String>();
                    if (policy.getExceptionsToExclusions() != null) {
                        for (ExceptionsToExclusionsFolders sch : policy.getExceptionsToExclusions()) {
                            exceptionToExcludedFolderpaths.add(sch.getFolderPath() + "\n      ");
                        }
                    }
                    String exceptionToExcludedFolderpath = exceptionToExcludedFolderpaths.stream().collect(Collectors.joining(""));
                    this.addPolicyDetailsForList(htmlContent, EXCEPTIONTOEXLUSIONFOLDERS, exceptionToExcludedFolderpaths);
                    List filters = policy.getInclusionFilter();
                    ArrayList<String> inclusionFilters = new ArrayList<String>();
                    for (InclusionFilter inclusionFilter : filters) {
                        inclusionFilters.add(inclusionFilter.getFilterName() + " - " + inclusionFilter.getExtensionName() + " \n       ");
                    }
                    String inclusionFilter = inclusionFilters.stream().collect(Collectors.joining(""));
                    this.addPolicyDetails(htmlContent, FILTERTYPE, policy.getFilterType());
                    this.addPolicyDetailsForList(htmlContent, FILTERNAME, inclusionFilters);
                    this.addpolicyDetailssubheading(htmlContent, "Email Alert Configurations :");
                    this.addPolicyDetails(htmlContent, "User Created", this.getEmailRestrictions(policy, "createUser"));
                    this.addPolicyDetails(htmlContent, "User Deleted", this.getEmailRestrictions(policy, "userDeleted"));
                    this.addPolicyDetails(htmlContent, "User Blocked", this.getEmailRestrictions(policy, "userBlocked"));
                    this.addPolicyDetails(htmlContent, "Asset Deleted", this.getEmailRestrictions(policy, "deviceDeleted"));
                    this.addPolicyDetails(htmlContent, "Asset Blocked", this.getEmailRestrictions(policy, "deviceBlocked"));
                    this.addPolicyDetails(htmlContent, "Asset de-couple", this.getEmailRestrictions(policy, "deviceDecoupled"));
                    this.addPolicyDetails(htmlContent, "Asset Limit Reached", this.getEmailRestrictions(policy, "deviceLimitReached"));
                    this.addPolicyDetails(htmlContent, "Weekly backup report", this.getEmailRestrictions(policy, "weeklyBkpreport"));
                    this.addPolicyDetails(htmlContent, "First backup completed", this.getEmailRestrictions(policy, "firstBkpCompleted"));
                    this.addPolicyDetails(htmlContent, "Restore initiated", this.getEmailRestrictions(policy, "restoreInitiated"));
                    this.addPolicyDetails(htmlContent, "Restore completed", this.getEmailRestrictions(policy, "restoreCompleted"));
                    this.addPolicyDetails(htmlContent, "Storage limit reached", this.getEmailRestrictions(policy, "storageLimitReached"));
                    this.addpolicyDetailssubheading(htmlContent, "User action preferences :");
                    this.addpolicyDetailssubheading(htmlContent, "Agent");
                    this.addPolicyDetails(htmlContent, "My Backup Files", this.getBooleanValue(policy.getEndpointUiPreferences().contains("BACKUP_FILES")));
                    this.addPolicyDetails(htmlContent, "Restore", this.getBooleanValue(policy.getEndpointUiPreferences().contains(RESTORE)));
                    this.addPolicyDetails(htmlContent, "Settings", this.getBooleanValue(policy.getEndpointUiPreferences().contains("BACKUP_SETTINGS")));
                    this.addPolicyDetails(htmlContent, "Refresh Policy", this.getBooleanValue(policy.getEndpointUiPreferences().contains("REFRESH_BACKUP_POLICY")));
                    this.addPolicyDetails(htmlContent, "Initiate Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("INTIATE_BACKUP")));
                    this.addPolicyDetails(htmlContent, "Pause Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("PAUSE_BACKUP")));
                    this.addPolicyDetails(htmlContent, "Stop Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("STOP_BACKUP")));
                    this.addPolicyDetails(htmlContent, "Check for Update", this.getBooleanValue(policy.getEndpointUiPreferences().contains("UPDATE_AGENT")));
                    this.addPolicyDetails(htmlContent, "Support Request", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SUPPORT")));
                    this.addPolicyDetails(htmlContent, "Decouple Asset", this.getBooleanValue(policy.getEndpointUiPreferences().contains("DECOUPLE")));
                    this.addPolicyDetails(htmlContent, "About", this.getBooleanValue(policy.getEndpointUiPreferences().contains("ABOUT")));
                    this.addPolicyDetails(htmlContent, "Exit", this.getBooleanValue(policy.getEndpointUiPreferences().contains("EXIT")));
                    this.addPolicyDetails(htmlContent, "Systray Icon", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SYSTRAYICON")));
                    this.addPolicyDetails(htmlContent, "Network Settings", this.getBooleanValue(policy.getEndpointUiPreferences().contains("NETWORK_SETTINGS")));
                    this.addpolicyDetailssubheading(htmlContent, "Portal :");
                    this.addPolicyDetails(htmlContent, "Open", this.getBooleanValue((Boolean)policy.getMenuOptions().get("open")));
                    this.addPolicyDetails(htmlContent, "View", this.getBooleanValue((Boolean)policy.getMenuOptions().get("view")));
                    this.addPolicyDetails(htmlContent, "Versions", this.getBooleanValue((Boolean)policy.getMenuOptions().get("versions")));
                    this.addPolicyDetails(htmlContent, "Restore", this.getBooleanValue((Boolean)policy.getMenuOptions().get("restore")));
                    this.addPolicyDetails(htmlContent, "Download", this.getBooleanValue((Boolean)policy.getMenuOptions().get("download")));
                    this.addPolicyDetails(htmlContent, "Share", this.getBooleanValue((Boolean)policy.getMenuOptions().get("share")));
                    this.addpolicyDetailssubheading(htmlContent, "Throttling Attributes :");
                    String nwt = policy.getNwFromClientToPGMB() == 10000.0 ? "Unlimited" : String.valueOf(policy.getNwFromClientToPGMB());
                    this.addPolicyDetails(htmlContent, "Network Throttle Setting from Client to BluKrypt (In Mbps)", nwt);
                    this.addPolicyDetails(htmlContent, "CPU Throttling", String.valueOf(policy.getCpuThrottling()));
                    this.addPolicyDetails(htmlContent, "Enable Legal Hold", this.getBooleanValue(policy.isLegalHoldEnabled()));
                    this.addPolicyDetails(htmlContent, "Include System Folders", this.getBooleanValue(policy.isBackupSystemFilesEnabled()));
                    String noOfDaysToKeepDeviceNotHeard = String.valueOf(policy.getNoOfDaysToKeepDeviceNotHeard());
                    if (policy.getNoOfDaysToKeepDeviceNotHeard() == -1L) {
                        noOfDaysToKeepDeviceNotHeard = "Unlimited";
                    }
                    this.addPolicyDetails(htmlContent, "Block assets which have not been heard from in", noOfDaysToKeepDeviceNotHeard);
                    this.addPolicyDetails(htmlContent, "Web Based Login", this.getBooleanValue(policy.isWebBasedLogin()));
                    if (cloudPropertyElement.isOverridePolicySettings()) {
                        this.addPolicyDetails(htmlContent, "Can Administrator Restore User Data", this.getBooleanValue(cloudPropertyElement.getCanAdminRestoreAll()));
                        this.addPolicyDetails(htmlContent, "Allow end-user over-ride", this.getBooleanValue(cloudPropertyElement.isAllowEndUserTocontrolRestore()));
                        this.addPolicyDetails(htmlContent, "Can Administrator Delete User Data", this.getBooleanValue(cloudPropertyElement.getIsAdminDeleteBackupFile()));
                    } else {
                        this.addPolicyDetails(htmlContent, "Can Administrator Restore User Data", this.getBooleanValue(policy.isCanAdminRestore()));
                        this.addPolicyDetails(htmlContent, "Allow end-user over-ride", this.getBooleanValue(policy.isAllowEndUserTocontrolRestore()));
                        this.addPolicyDetails(htmlContent, "Can Administrator Delete User Data", this.getBooleanValue(policy.isCanAdminDelete()));
                    }
                    if (user.isSuperAdmin() || cloudPropertyElement.getHostedSetup().equals(false)) {
                        this.addPolicyDetails(htmlContent, "Blukrypt Search Algorithm", policy.getSearchAlgoForPg());
                        ArrayList<String> privacyGatewaynames = new ArrayList<String>();
                        if (policy.getPrivacyGateways() != null) {
                            for (PrivacyGateway privacyGateway : policy.getPrivacyGateways()) {
                                privacyGatewaynames.add(privacyGateway.getGatewayName() + "\n      ");
                            }
                        }
                        String privacyGatewayname = privacyGatewaynames.stream().collect(Collectors.joining(""));
                        this.addPolicyDetailsForList(htmlContent, "Preferred BluKrypt Hostnames", privacyGatewaynames);
                    }
                    this.addPolicyDetails(htmlContent, "Policy Refresh Frequency (In Hours)", policy.getPolicyRefresh());
                    this.addPolicyDetails(htmlContent, "Endpoint Domain Check", this.getBooleanValue(policy.isEndpointDomainCheck()));
                    this.addPolicyDetails(htmlContent, "Allowed Domains", policy.getAllowedDomains());
                    this.addPolicyDetails(htmlContent, "Agent uninstallation password", this.getBooleanValue(policy.isSwitchAgentPassword()));
                    this.addPolicyDetails(htmlContent, "Backup Hidden Files", this.getBooleanValue(policy.isCanBackupHiddenFiles()));
                    this.addPolicyDetails(htmlContent, "Enable Download Agent", this.getBooleanValue(policy.isDownloadAgent()));
                    String noOfDaysToKeepDeletedFiles = String.valueOf(policy.getNoOfDaysToKeepDeletedFiles());
                    if (policy.getNoOfDaysToKeepDeletedFiles() == -1L) {
                        noOfDaysToKeepDeletedFiles = "Unlimited";
                    }
                    this.addPolicyDetails(htmlContent, "Purge deleted files from the catalog after", noOfDaysToKeepDeletedFiles);
                    this.addPolicyDetails(htmlContent, "Enable Pre Scan Command", this.getBooleanValue(policy.isPreScanCommandEnabled()));
                    this.addPolicyDetails(htmlContent, "Pre Scan Command Path", String.valueOf(policy.getPreScanCommand()));
                    this.addPolicyDetails(htmlContent, "Continue backup on Pre Scan command-failure", this.getBooleanValue(policy.isContinueOnPreScan()));
                    this.addPolicyDetails(htmlContent, "Enable Pre Backup Command", this.getBooleanValue(policy.isPreBackupCommandEnabled()));
                    this.addPolicyDetails(htmlContent, "Pre Backup Command Path", String.valueOf(policy.getPreBackupCommand()));
                    this.addPolicyDetails(htmlContent, "Continue backup on pre Backup command-failure", this.getBooleanValue(policy.isContinueOnPreBkp()));
                    this.addPolicyDetails(htmlContent, "Enable Post Backup Command", this.getBooleanValue(policy.isPostBackupCommandEnabled()));
                    this.addPolicyDetails(htmlContent, "Post Backup Command Path", String.valueOf(policy.getPostBackupCommand()));
                    this.addPolicyDetails(htmlContent, "Continue backup on command-failure", this.getBooleanValue(policy.isContinueOnPostBkp()));
                    this.addpolicyDetailssubheading(htmlContent, "Password Enforcement ");
                    if (cloudPropertyElement.isPasswordChangeEnforce()) {
                        this.addPolicyDetails(htmlContent, "Can User Change Password", String.valueOf(cloudPropertyElement.isCanUserChangePassword()));
                        this.addPolicyDetails(htmlContent, "Can Admin Change User Password", String.valueOf(cloudPropertyElement.isCanAdminChangeUserPassword()));
                    } else {
                        this.addPolicyDetails(htmlContent, "Can User Change Password", String.valueOf(policy.isCanUserChangePassword()));
                        this.addPolicyDetails(htmlContent, "Can Admin Change User Password", String.valueOf(policy.isCanAdminChangeUserPassword()));
                    }
                    logger.debug("htmlContent..." + htmlContent);
                    try (FileOutputStream os = new FileOutputStream(file);){
                        htmlContent.append("</div>").append("</body>");
                        htmlContent.append("</html>");
                        PdfRendererBuilder builder = new PdfRendererBuilder();
                        builder.withHtmlContent(htmlContent.toString(), null);
                        builder.toStream((OutputStream)os);
                        builder.run();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.addWatermarkToPDF(file, outPutFile, cloud.getCloudId());
                    break block60;
                }
                if (!isMSPEnv || !user.isReadOnlyAdmin()) break block60;
                cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
                filename = policy.getPolicyName() + "_1Policy.pdf";
                String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filename;
                String filenameFinal = policy.getPolicyName() + "_Policy.pdf";
                String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filenameFinal;
                ArrayList<String> scheduleNames = new ArrayList<String>();
                for (Schedule sch : policy.getSchedules()) {
                    scheduleNames.add(sch.getScheduleName() + " - " + sch.getTime() + "\n      ");
                }
                String scheduleName = scheduleNames.stream().collect(Collectors.joining(""));
                System.out.println(scheduleName);
                this.addPolicyDetailsForList(htmlContent, SCHEDULES, scheduleNames);
                ArrayList<String> backupFolderPaths = new ArrayList<String>();
                for (BackupFolders sch : policy.getBackupFolders()) {
                    backupFolderPaths.add(sch.getFolderPath() + "\n      ");
                }
                String backupFolderPath = backupFolderPaths.stream().collect(Collectors.joining(""));
                this.addPolicyDetailsForList(htmlContent, DEFUALTFOLDERS, backupFolderPaths);
                List<Object> excludedFolderpaths = new ArrayList<String>();
                ArrayList<String> excludedFolderpathsForPdf = new ArrayList<String>();
                if (policy.getExcludedFolders() != null) {
                    for (Object sch : policy.getExcludedFolders()) {
                        excludedFolderpaths.add(sch.getFolderPath());
                    }
                    List globalExcludedFolders = this.userExcludedFoldersDao.getAllGlobalExcludedFolders(cloud.getCloudId()).stream().map(GlobalExcludedFolders::getFolderPath).collect(Collectors.toList());
                    if ((excludedFolderpaths = excludedFolderpaths.stream().filter(element -> !globalExcludedFolders.contains(element)).collect(Collectors.toList())).size() > 0) {
                        for (String string : excludedFolderpaths) {
                            excludedFolderpathsForPdf.add(string + "\n      ");
                        }
                    }
                }
                String excludedFolderpath = excludedFolderpathsForPdf.stream().collect(Collectors.joining(""));
                this.addPolicyDetailsForList(htmlContent, EXCLUDEDFOLDERS, excludedFolderpathsForPdf);
                List filters = policy.getInclusionFilter();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (InclusionFilter inclusionFilter : filters) {
                    arrayList.add(inclusionFilter.getFilterName() + " \n  ");
                }
                String inclusionFilter = arrayList.stream().collect(Collectors.joining(""));
                this.addPolicyDetails(htmlContent, FILTERTYPE, policy.getFilterType());
                this.addPolicyDetailsForList(htmlContent, FILTERNAME, arrayList);
                this.addPolicyDetails(htmlContent, "Throttling Attributes");
                String nwt = policy.getNwFromClientToPGMB() == 10000.0 ? "Unlimited" : String.valueOf(policy.getNwFromClientToPGMB());
                this.addPolicyDetails(htmlContent, "Network Throttle Setting from Client to BluKrypt (In Mbps)", nwt);
                this.addPolicyDetails(htmlContent, "CPU Throttling", String.valueOf(policy.getCpuThrottling()));
                this.addPolicyDetails(htmlContent, "User action preferences");
                this.addPolicyDetails(htmlContent, "Agent");
                this.addPolicyDetails(htmlContent, "My Backup Files", this.getBooleanValue(policy.getEndpointUiPreferences().contains("BACKUP_FILES")));
                this.addPolicyDetails(htmlContent, "Restore", this.getBooleanValue(policy.getEndpointUiPreferences().contains(RESTORE)));
                this.addPolicyDetails(htmlContent, "Refresh Policy", this.getBooleanValue(policy.getEndpointUiPreferences().contains("REFRESH_BACKUP_POLICY")));
                this.addPolicyDetails(htmlContent, "Initiate Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("INTIATE_BACKUP")));
                this.addPolicyDetails(htmlContent, "Pause Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("PAUSE_BACKUP")));
                this.addPolicyDetails(htmlContent, "Stop Backup", this.getBooleanValue(policy.getEndpointUiPreferences().contains("STOP_BACKUP")));
                this.addPolicyDetails(htmlContent, "Check for Update", this.getBooleanValue(policy.getEndpointUiPreferences().contains("UPDATE_AGENT")));
                this.addPolicyDetails(htmlContent, "Support Request", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SUPPORT")));
                this.addPolicyDetails(htmlContent, "Decouple Asset", this.getBooleanValue(policy.getEndpointUiPreferences().contains("DECOUPLE")));
                this.addPolicyDetails(htmlContent, "About", this.getBooleanValue(policy.getEndpointUiPreferences().contains("ABOUT")));
                this.addPolicyDetails(htmlContent, "Exit", this.getBooleanValue(policy.getEndpointUiPreferences().contains("EXIT")));
                this.addPolicyDetails(htmlContent, "Systray Icon", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SYSTRAYICON")));
                this.addPolicyDetails(htmlContent, "Network Settings", this.getBooleanValue(policy.getEndpointUiPreferences().contains("NETWORK_SETTINGS")));
                this.addPolicyDetails(htmlContent, "Portal");
                this.addPolicyDetails(htmlContent, "Open", this.getBooleanValue((Boolean)policy.getMenuOptions().get("open")));
                this.addPolicyDetails(htmlContent, "View", this.getBooleanValue((Boolean)policy.getMenuOptions().get("view")));
                this.addPolicyDetails(htmlContent, "Versions", this.getBooleanValue((Boolean)policy.getMenuOptions().get("versions")));
                this.addPolicyDetails(htmlContent, "Download", this.getBooleanValue((Boolean)policy.getMenuOptions().get("download")));
                try (FileOutputStream os = new FileOutputStream(file);){
                    htmlContent.append("</div>").append("</body>");
                    PdfRendererBuilder builder = new PdfRendererBuilder();
                    builder.withHtmlContent(htmlContent.toString(), null);
                    builder.toStream((OutputStream)os);
                    builder.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.addWatermarkToPDF(file, outPutFile, cloud.getCloudId());
            }
            catch (Exception e) {
                logger.error("Exception...", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private void createPdfForSyncPolicy(Cloud cloud, SyncPolicy policy) {
        try {
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
            boolean isBluDriveMode = false;
            boolean isAVScanEnabled = this.licenseService.isLicenseEnabled(cloud, "AV Scan Enabled");
            PortalProperties portalProperties = this.portalPropertiesDao.getPortalProperties(cloud.getCloudId(), PCHelperConstant.getPropertyValueComponentName());
            if (portalProperties.getComponentsProperties().get("BLUDRIVE_MODE").toString().equalsIgnoreCase("true")) {
                isBluDriveMode = true;
                logger.debug("....BLUDRIVE_MODE is false so set ..WEBANDENDPOINT");
            }
            StringBuilder htmlContent = new StringBuilder();
            htmlContent = this.pdfHeadingDetails(htmlContent);
            String filename = policy.getPolicyName() + "_1Policy.pdf";
            String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filename;
            String filenameNew = policy.getPolicyName() + "_Policy.pdf";
            String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filenameNew;
            this.addPolicyDetails(htmlContent, POLICYNAME, policy.getPolicyName());
            this.addPolicyDetails(htmlContent, DESCRIPTION, policy.getDescription());
            if (!isBluDriveMode) {
                this.addPolicyDetails(htmlContent, "Automatic Sync", this.getBooleanValue(policy.isSyncEnableAutomatic()));
                this.addPolicyDetails(htmlContent, "Sync Interval (In Minutes)", policy.getSyncInterval());
            }
            String maxver = String.valueOf(policy.getMaxVersions());
            if (policy.getMaxVersions() == -1) {
                maxver = "Unlimited";
            }
            this.addPolicyDetails(htmlContent, MAXVERSIONS, maxver);
            String maxFileSize = String.valueOf(policy.getMaxFileSize());
            if (policy.getMaxFileSize().equals("1048576")) {
                maxFileSize = "Unlimited";
            }
            this.addPolicyDetails(htmlContent, MAXPERMISSIBLEFILESIZE, maxFileSize);
            String perDeviceBackupStorage = String.valueOf(policy.getUserSizeAllowed());
            if (policy.getUserSizeAllowed() == 102400) {
                perDeviceBackupStorage = "Unlimited";
            }
            this.addPolicyDetails(htmlContent, "User Storage Quota (In GB)", perDeviceBackupStorage);
            this.addPolicyDetails(htmlContent, MAXASSETSALLOWED, String.valueOf(policy.getNoOfDevicesAllowed()));
            List filters = policy.getInclusionFilter();
            ArrayList<String> inclusionFilters = new ArrayList<String>();
            for (InclusionFilter inclusionFilter : filters) {
                inclusionFilters.add(inclusionFilter.getFilterName() + " - " + inclusionFilter.getExtensionName() + "\n      ");
            }
            String inclusionFilter = inclusionFilters.stream().collect(Collectors.joining(""));
            this.addPolicyDetails(htmlContent, FILTERTYPE, policy.getFilterType());
            this.addPolicyDetailsForList(htmlContent, FILTERNAME, inclusionFilters);
            this.addpolicyDetailssubheading(htmlContent, "Email Alert Configurations");
            this.addPolicyDetails(htmlContent, "User Created", this.getEmailRestrictions(policy, "createUser"));
            this.addPolicyDetails(htmlContent, "User Deleted", this.getEmailRestrictions(policy, "userDeleted"));
            this.addPolicyDetails(htmlContent, "User Blocked", this.getEmailRestrictions(policy, "userBlocked"));
            this.addpolicyDetailssubheading(htmlContent, "User action preferences");
            if (!isBluDriveMode) {
                this.addPolicyDetails(htmlContent, "Agent");
                this.addPolicyDetails(htmlContent, "Open Parablu Folder", this.getBooleanValue(policy.getEndpointUiPreferences().contains("OPEN_SYNC_FOLDER")));
                this.addPolicyDetails(htmlContent, "Initiate Sync", this.getBooleanValue(policy.getEndpointUiPreferences().contains("INITIATE_SYNC")));
                this.addPolicyDetails(htmlContent, "My Files", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SYNC_FILES")));
                this.addPolicyDetails(htmlContent, "Settings", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SYNC_SETTINGS")));
                this.addPolicyDetails(htmlContent, "Search", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SEARCH")));
                this.addPolicyDetails(htmlContent, "Refresh Sync Policy", this.getBooleanValue(policy.getEndpointUiPreferences().contains("REFRESH_SYNC_POLICY")));
                this.addPolicyDetails(htmlContent, "Check for Update", this.getBooleanValue(policy.getEndpointUiPreferences().contains("UPDATE_AGENT")));
                this.addPolicyDetails(htmlContent, "Support Request", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SUPPORT")));
                this.addPolicyDetails(htmlContent, "Decouple Device", this.getBooleanValue(policy.getEndpointUiPreferences().contains("DECOUPLE")));
                this.addPolicyDetails(htmlContent, "About", this.getBooleanValue(policy.getEndpointUiPreferences().contains("ABOUT")));
                this.addPolicyDetails(htmlContent, "Systray Icon", this.getBooleanValue(policy.getEndpointUiPreferences().contains("SYSTRAYICON")));
                this.addPolicyDetails(htmlContent, "Exit", this.getBooleanValue(policy.getEndpointUiPreferences().contains("EXIT")));
            }
            this.addpolicyDetailssubheading(htmlContent, "Portal");
            this.addPolicyDetails(htmlContent, "Open", this.getBooleanValue((Boolean)policy.getMenuOptions().get("open")));
            this.addPolicyDetails(htmlContent, "View", this.getBooleanValue((Boolean)policy.getMenuOptions().get("view")));
            this.addPolicyDetails(htmlContent, "Versions", this.getBooleanValue((Boolean)policy.getMenuOptions().get("versions")));
            this.addPolicyDetails(htmlContent, "Download", this.getBooleanValue((Boolean)policy.getMenuOptions().get("download")));
            this.addPolicyDetails(htmlContent, "Share", this.getBooleanValue((Boolean)policy.getMenuOptions().get("share")));
            this.addPolicyDetails(htmlContent, "Rename", this.getBooleanValue((Boolean)policy.getMenuOptions().get("rename")));
            this.addPolicyDetails(htmlContent, "Cut, Copy and Paste", this.getBooleanValue((Boolean)policy.getMenuOptions().get("cutCopyPaste")));
            this.addPolicyDetails(htmlContent, "File/Folder Upload", this.getBooleanValue((Boolean)policy.getMenuOptions().get("fileUpload")));
            this.addPolicyDetails(htmlContent, "Create Folder", this.getBooleanValue((Boolean)policy.getMenuOptions().get("createFolder")));
            this.addPolicyDetails(htmlContent, "Create MiniCloud", this.getBooleanValue((Boolean)policy.getMenuOptions().get("createMiniCloud")));
            this.addPolicyDetails(htmlContent, "Delete", this.getBooleanValue((Boolean)policy.getMenuOptions().get("delete")));
            this.addpolicyDetailssubheading(htmlContent, "Share Details");
            this.addPolicyDetails(htmlContent, "Enable Domain Control", this.getBooleanValue(policy.isShareDomainsEnabled()));
            ArrayList<String> shareDomainIncExclusions = new ArrayList<String>();
            if (policy.getShareDomainIncExclusions() != null) {
                for (Object shareDomainExclu : policy.getShareDomainIncExclusions()) {
                    shareDomainIncExclusions.add((String)shareDomainExclu + "\n      ");
                }
            }
            this.addPolicyDetailsForList(htmlContent, "Share Domain Inclusions/Exclusions", shareDomainIncExclusions);
            this.addPolicyDetails(htmlContent, "Share Domain Type", policy.getShareDomainType());
            ArrayList<String> allowSharingWithEmailList = new ArrayList<String>();
            if (policy.getShareDomainIncExclusions() != null) {
                for (Object shareDomainExclu : policy.getShareDomainIncExclusionsException()) {
                    allowSharingWithEmailList.add((String)shareDomainExclu + "\n      ");
                }
            }
            this.addPolicyDetailsForList(htmlContent, "Allow sharing with the following Email addresses", allowSharingWithEmailList);
            this.addPolicyDetails(htmlContent, "Allow sharer visibility to the shared link", this.getBooleanValue(policy.isShowShareLink()));
            this.addPolicyDetails(htmlContent, "Highly Secure Sharing", this.getBooleanValue(policy.isHighSecureShareEnabled()));
            this.addPolicyDetails(htmlContent, "Complex Password", this.getBooleanValue(policy.isCompressionEnabled()));
            this.addPolicyDetails(htmlContent, "Allow Download", this.getBooleanValue(policy.isPreventDownloadEnabled()));
            this.addPolicyDetails(htmlContent, "Require Expiration Date for shared data", this.getBooleanValue(policy.getExpiredDate()));
            this.addPolicyDetails(htmlContent, "Enable multi-factor authentication", this.getBooleanValue(policy.isGoogleAuth()));
            this.addpolicyDetailssubheading(htmlContent, "Advanced Options");
            if (isAVScanEnabled) {
                this.addPolicyDetails(htmlContent, "Malware Scan during file upload", this.getBooleanValue(policy.isEnableAVScan()));
            }
            this.addPolicyDetails(htmlContent, "Web Based Login", this.getBooleanValue(policy.isWebBasedLogin()));
            this.addPolicyDetails(htmlContent, "Blukrypt Search Algorithm", policy.getSearchAlgoForPg());
            ArrayList<String> privacyGatewaynames = new ArrayList<String>();
            if (policy.getPrivacyGateways() != null) {
                for (PrivacyGateway privacyGateway : policy.getPrivacyGateways()) {
                    privacyGatewaynames.add(privacyGateway.getGatewayName() + "\n      ");
                }
            }
            String privacyGatewayname = privacyGatewaynames.stream().collect(Collectors.joining(""));
            this.addPolicyDetailsForList(htmlContent, "Preferred BluKrypt Hostnames", privacyGatewaynames);
            if (!isBluDriveMode) {
                this.addPolicyDetails(htmlContent, "Policy Refresh Frequency (In Hours)", policy.getPolicyRefresh());
                this.addPolicyDetails(htmlContent, "Enable Download Agent", this.getBooleanValue(policy.isDownloadAgent()));
            }
            this.addPolicyDetails(htmlContent, "Number Of Days Old File To Be Deleted", String.valueOf(policy.getNoOfDaysToPurgeFile()));
            this.addpolicyDetailssubheading(htmlContent, "Password Enforcement ");
            if (cloudPropertyElement.isPasswordChangeEnforce()) {
                this.addPolicyDetails(htmlContent, "Can User Change Password", String.valueOf(cloudPropertyElement.isCanUserChangePassword()));
                this.addPolicyDetails(htmlContent, "Can Admin Change User Password", String.valueOf(cloudPropertyElement.isCanAdminChangeUserPassword()));
            } else {
                this.addPolicyDetails(htmlContent, "Can User Change Password", String.valueOf(policy.isCanUserChangePassword()));
                this.addPolicyDetails(htmlContent, "Can Admin Change User Password", String.valueOf(policy.isCanAdminChangeUserPassword()));
            }
            logger.debug("htmlContent..." + htmlContent);
            try (FileOutputStream os = new FileOutputStream(file);){
                htmlContent.append("</div>").append("</body>");
                htmlContent.append("</html>");
                PdfRendererBuilder builder = new PdfRendererBuilder();
                builder.withHtmlContent(htmlContent.toString(), null);
                builder.toStream((OutputStream)os);
                builder.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addWatermarkToPDF(file, outPutFile, cloud.getCloudId());
        }
        catch (Exception e) {
            logger.error("Exception...", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void createPdfForOfficePolicy(Cloud cloud, OfficeBackupPolicy policy, String produtName) {
        try {
            CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloud.getCloudId());
            boolean isExchangeProdcut = false;
            boolean isODBProduct = false;
            boolean isSharepointProduct = false;
            if (StringUtils.isNotEmpty((String)produtName) && produtName.equalsIgnoreCase("Exchange")) {
                isExchangeProdcut = true;
            }
            if (StringUtils.isNotEmpty((String)produtName) && produtName.equalsIgnoreCase(ODB)) {
                isODBProduct = true;
            }
            if (StringUtils.isNotEmpty((String)produtName) && produtName.equalsIgnoreCase(SHARE_POINT)) {
                isSharepointProduct = true;
            }
            String filename = policy.getPolicyName() + "_1Policy.pdf";
            String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filename;
            String filenameNew = policy.getPolicyName() + "_Policy.pdf";
            String outPutFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/" + filenameNew;
            StringBuilder htmlContent = new StringBuilder();
            htmlContent = this.pdfHeadingDetails(htmlContent);
            this.addPolicyDetails(htmlContent, POLICYNAME, policy.getPolicyName());
            this.addPolicyDetails(htmlContent, DESCRIPTION, policy.getDescription());
            ArrayList<String> scheduleNames = new ArrayList<String>();
            for (Schedule sch : policy.getSchedules()) {
                scheduleNames.add(sch.getScheduleName() + " - " + sch.getTime() + "\n      ");
            }
            String scheduleName = scheduleNames.stream().collect(Collectors.joining(""));
            System.out.println(scheduleName);
            this.addPolicyDetailsForList(htmlContent, SCHEDULES, scheduleNames);
            if (!isExchangeProdcut) {
                String maxver = String.valueOf(policy.getMaxVersions());
                if (policy.getMaxVersions() == -1) {
                    maxver = "Unlimited";
                }
                this.addPolicyDetails(htmlContent, MAXVERSIONS, maxver);
            }
            String maxFileSize = String.valueOf(policy.getMaxFileSize());
            if (policy.getMaxFileSize().equals("1048576")) {
                maxFileSize = "Unlimited";
            }
            if (isExchangeProdcut) {
                this.addPolicyDetails(htmlContent, "Maximum Permissible Attachment Size (In MB)", maxFileSize);
            } else {
                this.addPolicyDetails(htmlContent, MAXPERMISSIBLEFILESIZE, maxFileSize);
            }
            String perDeviceBackupStorage = String.valueOf(policy.getUserSizeAllowed());
            if (policy.getUserSizeAllowed() == 102400) {
                perDeviceBackupStorage = "Unlimited";
            }
            if (isExchangeProdcut) {
                this.addPolicyDetails(htmlContent, "Backup Storage Limit (In GB)", perDeviceBackupStorage);
            } else {
                this.addPolicyDetails(htmlContent, "Per Device Backup Storage Limit (In GB)", perDeviceBackupStorage);
            }
            if (isExchangeProdcut) {
                String purgeDeletedMailsOlderThan = String.valueOf(policy.getPurgeDeletedMailsOlderThan());
                if (policy.getPurgeDeletedMailsOlderThan() == -1) {
                    purgeDeletedMailsOlderThan = "Unlimited";
                }
                this.addPolicyDetails(htmlContent, "Purge deleted emails from the catalog after", purgeDeletedMailsOlderThan);
                String deletedMailsOlderThan = String.valueOf(policy.getDeletedMailsOlderThan());
                if (policy.getDeletedMailsOlderThan() == -1) {
                    deletedMailsOlderThan = "Unlimited";
                }
                this.addPolicyDetails(htmlContent, "Delete emails from the archive after", deletedMailsOlderThan);
                this.addPolicyDetails(htmlContent, "Backup of In-Place Archive", String.valueOf(policy.isInPlaceMailArchiveEnabled()));
            }
            String threshholdLimit = String.valueOf(policy.getThreshholdLimit());
            String purgeFilesOlderThan = String.valueOf(policy.getPurgeFilesOlderThan());
            String PurgeFilesSizeGTThan = String.valueOf(policy.getPurgeFilesSizeGTThan());
            if (policy.getThreshholdLimit() == -1L) {
                threshholdLimit = "Unlimited";
            }
            if (policy.getPurgeFilesOlderThan() == -1) {
                purgeFilesOlderThan = "Unlimited";
            }
            if (policy.getPurgeFilesSizeGTThan() == 1) {
                PurgeFilesSizeGTThan = "Unlimited";
            }
            if (isODBProduct) {
                this.addPolicyDetails(htmlContent, "Purge files from OneDrive if", String.valueOf(policy.isCreateLinkEnabled()));
                this.addPolicyDetails(htmlContent, "OneDrive consumption is higher than (%) ", threshholdLimit);
                this.addPolicyDetails(htmlContent, "Files have not been modified in (days) ", purgeFilesOlderThan);
                this.addPolicyDetails(htmlContent, "Files are of size greater than (MB) ", PurgeFilesSizeGTThan);
            }
            if (isSharepointProduct) {
                this.addPolicyDetails(htmlContent, "Archive documents from SharePoint Online if ", String.valueOf(policy.isCreateLinkEnabled()));
                this.addPolicyDetails(htmlContent, "Site consumption is higher than (%)", threshholdLimit);
                this.addPolicyDetails(htmlContent, "Documents have not been modified in (days) ", purgeFilesOlderThan);
                this.addPolicyDetails(htmlContent, "Documents are of size greater than (MB) ", PurgeFilesSizeGTThan);
            }
            this.addPolicyDetails(htmlContent, "Blukrypt Search Algorithm", policy.getSearchAlgoForPg());
            ArrayList<String> privacyGatewaynames = new ArrayList<String>();
            if (policy.getPrivacyGateways() != null) {
                for (PrivacyGateway privacyGateway : policy.getPrivacyGateways()) {
                    privacyGatewaynames.add(privacyGateway.getGatewayName() + "\n      ");
                }
            }
            String privacyGatewayname = privacyGatewaynames.stream().collect(Collectors.joining(""));
            this.addPolicyDetailsForList(htmlContent, "Preferred BluKrypt Hostnames", privacyGatewaynames);
            ArrayList<String> backupFolderPaths = new ArrayList<String>();
            for (BackupFolders sch : policy.getBackupFolders()) {
                backupFolderPaths.add(sch.getFolderPath() + "\n      ");
            }
            String backupFolderPath = backupFolderPaths.stream().collect(Collectors.joining(""));
            this.addPolicyDetailsForList(htmlContent, DEFUALTFOLDERS, backupFolderPaths);
            ArrayList<String> excludedFolderpaths = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)policy.getExcludedFolders())) {
                for (ExcludedFolders sch : policy.getExcludedFolders()) {
                    excludedFolderpaths.add(sch.getFolderPath() + "\n      ");
                }
            }
            String excludedFolderpath = excludedFolderpaths.stream().collect(Collectors.joining(""));
            this.addPolicyDetailsForList(htmlContent, EXCLUDEDFOLDERS, excludedFolderpaths);
            ArrayList filters = policy.getInclusionFilter();
            ArrayList<String> inclusionFilters = new ArrayList<String>();
            for (InclusionFilter inclusionFilter : filters) {
                inclusionFilters.add(inclusionFilter.getFilterName() + " - " + inclusionFilter.getExtensionName() + "\n      ");
            }
            String inclusionFilter = inclusionFilters.stream().collect(Collectors.joining(""));
            this.addPolicyDetails(htmlContent, FILTERTYPE, policy.getFilterType());
            this.addPolicyDetailsForList(htmlContent, FILTERNAME, inclusionFilters);
            if (isExchangeProdcut) {
                this.addPolicyDetails(htmlContent, "Email Filters");
            }
            this.addpolicyDetailssubheading(htmlContent, "Email Alert Configurations");
            this.addPolicyDetails(htmlContent, "User Created", this.getEmailRestrictions(policy, "createUser"));
            this.addPolicyDetails(htmlContent, "User Deleted", this.getEmailRestrictions(policy, "userDeleted"));
            this.addPolicyDetails(htmlContent, "User Blocked", this.getEmailRestrictions(policy, "userBlocked"));
            this.addPolicyDetails(htmlContent, "Asset Deleted", this.getEmailRestrictions(policy, "deviceDeleted"));
            this.addPolicyDetails(htmlContent, "Asset Blocked", this.getEmailRestrictions(policy, "deviceBlocked"));
            this.addPolicyDetails(htmlContent, "Asset de-couple", this.getEmailRestrictions(policy, "deviceDecoupled"));
            this.addPolicyDetails(htmlContent, "Asset Limit Reached", this.getEmailRestrictions(policy, "deviceLimitReached"));
            this.addPolicyDetails(htmlContent, "Weekly backup report", this.getEmailRestrictions(policy, "weeklyBkpreport"));
            this.addPolicyDetails(htmlContent, "First backup completed", this.getEmailRestrictions(policy, "firstBkpCompleted"));
            this.addPolicyDetails(htmlContent, "Restore initiated", this.getEmailRestrictions(policy, "restoreInitiated"));
            this.addPolicyDetails(htmlContent, "Storage limit reached", this.getEmailRestrictions(policy, "storageLimitReached"));
            this.addpolicyDetailssubheading(htmlContent, "User action preferences");
            this.addpolicyDetailssubheading(htmlContent, "Portal");
            this.addPolicyDetails(htmlContent, "Open", this.getBooleanValue((Boolean)policy.getMenuOptions().get("open")));
            this.addPolicyDetails(htmlContent, "View", this.getBooleanValue((Boolean)policy.getMenuOptions().get("view")));
            this.addPolicyDetails(htmlContent, "Versions", this.getBooleanValue((Boolean)policy.getMenuOptions().get("versions")));
            this.addPolicyDetails(htmlContent, "Restore", this.getBooleanValue((Boolean)policy.getMenuOptions().get("restore")));
            this.addPolicyDetails(htmlContent, "Download", this.getBooleanValue((Boolean)policy.getMenuOptions().get("download")));
            this.addPolicyDetails(htmlContent, "Enable Legal Hold", this.getBooleanValue(policy.isLegalHoldEnabled()));
            this.addPolicyDetails(htmlContent, "Web Based Login", this.getBooleanValue(policy.isWebBasedLogin()));
            if (cloudPropertyElement.isOverridePolicySettings()) {
                this.addPolicyDetails(htmlContent, "Can Administrator Restore User Data", this.getBooleanValue(cloudPropertyElement.getCanAdminRestoreAll()));
                this.addPolicyDetails(htmlContent, "Can Administrator Delete User Data", this.getBooleanValue(cloudPropertyElement.getIsAdminDeleteBackupFile()));
            } else {
                this.addPolicyDetails(htmlContent, "Can Administrator Restore User Data", this.getBooleanValue(policy.isCanAdminRestore()));
                this.addPolicyDetails(htmlContent, "Can Administrator Delete User Data", this.getBooleanValue(policy.isCanAdminDelete()));
            }
            this.addPolicyDetails(htmlContent, "Policy Refresh Frequency (In Hours)", policy.getPolicyRefresh());
            logger.debug("htmlContent..." + htmlContent);
            try (FileOutputStream os = new FileOutputStream(file);){
                htmlContent.append("</div>").append("</body>");
                htmlContent.append("</html>");
                PdfRendererBuilder builder = new PdfRendererBuilder();
                builder.withHtmlContent(htmlContent.toString(), null);
                builder.toStream((OutputStream)os);
                builder.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addWatermarkToPDF(file, outPutFile, cloud.getCloudId());
        }
        catch (Exception e) {
            logger.error("Exception...", (Throwable)e);
            e.printStackTrace();
        }
    }

    private String getEmailRestrictions(BackupPolicy policy, String key) {
        if (((String)policy.getEmailsRestriction().get(key)).contains("users")) {
            return "Enabled";
        }
        return "Disabled";
    }

    private String getEmailRestrictions(OfficeBackupPolicy policy, String key) {
        if (((String)policy.getEmailsRestriction().get(key)).contains("users")) {
            return "Enabled";
        }
        return "Disabled";
    }

    private String getEmailRestrictions(SyncPolicy policy, String key) {
        if (((String)policy.getEmailsRestriction().get(key)).contains("users")) {
            return "Enabled";
        }
        return "Disabled";
    }

    private String getBooleanValue(boolean bool) {
        if (bool) {
            return "Enabled";
        }
        return "Disabled";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createExcelForUserMigrationStatus(int cloudId) {
        List migrationStatusList = this.migrationStatusDao.getAllMigrationStatusWithoutPagination(cloudId);
        ArrayList<UserMigratedElement> list = new ArrayList<UserMigratedElement>();
        for (MigrationStatus migrationStatus : migrationStatusList) {
            UserMigratedElement userMigratedElement = new UserMigratedElement();
            BeanUtils.copyProperties((Object)migrationStatus, (Object)userMigratedElement);
            userMigratedElement.setCreatedTimestamp(ReportServiceImpl.getDateInFormat(migrationStatus.getMigratededTimestamp(), "dd-MMM-yyyy HH:mm:ss"));
            list.add(userMigratedElement);
        }
        if (list.isEmpty()) return false;
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            logger.debug(" Before creating excel for User Migration Status...");
            List<List> recordToAdd = ReportServiceImpl.updateValuesToExcelForUserMigrationStatus(list);
            this.createExcelForXlsxForUserMigrationStatus(recordToAdd, workbook);
            this.writeExcelForUserMigrationStatus(workbook);
            logger.debug(" After creating excel for User Migration Status...");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(EXCEPTION + e.getMessage());
            logger.debug(EXCEPTION + e);
            return false;
        }
    }

    private static List<List> updateValuesToExcelForUserMigrationStatus(List<UserMigratedElement> list) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(USER_ID);
        headerRow.add(EMAIL_ID);
        headerRow.add("Migrated Time");
        headerRow.add("Migrated By");
        headerRow.add("Status");
        headerRow.add(REASON);
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(REPORT_GENERATED_ON + ReportServiceImpl.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        recordToAdd.add(headerRow);
        for (UserMigratedElement userMigratedElement : list) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(userMigratedElement.getUserName());
            firstRow.add(userMigratedElement.getEmailId());
            firstRow.add(userMigratedElement.getCreatedTimestamp());
            firstRow.add(userMigratedElement.getMigratedBy());
            if (userMigratedElement.isMigrated()) {
                firstRow.add("Success");
            } else {
                firstRow.add("Failed");
            }
            if (StringUtils.isNotEmpty((String)userMigratedElement.getReason())) {
                firstRow.add(userMigratedElement.getReason());
            } else {
                firstRow.add("-");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    void createExcelForXlsxForUserMigrationStatus(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    XSSFFont font;
                    XSSFCellStyle cellStyle;
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum == 0) {
                        cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor((short)22);
                        cellStyle.setFillPattern((short)1);
                        font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)12);
                        font.setBoldweight((short)11);
                        cellStyle.setFont((Font)font);
                        cell.setCellStyle((CellStyle)cellStyle);
                        firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                        CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                    }
                    if (rownum != 1) continue;
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    void writeExcelForUserMigrationStatus(XSSFWorkbook workbook) {
        String fileName = "UserMigrationStatus.xlsx";
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/bkpOverview/" + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public boolean isMSPEnvEnabled(String cloudName) {
        boolean isMSPEnvEnabled = false;
        List cloudCustomisableDetails = this.cloudDao.getCloudCustomisableDetails(cloudName);
        if (cloudCustomisableDetails != null && cloudCustomisableDetails.size() > 0) {
            logger.debug("process=Iterating through the cloudCustomisableDetails to check if MSP license is enabled");
            for (CloudCustomisableDetails clouCustomisableDetail : cloudCustomisableDetails) {
                if (!MSP_ENV_ENABLED.equals(clouCustomisableDetail.getName())) continue;
                isMSPEnvEnabled = true;
                break;
            }
        }
        return isMSPEnvEnabled;
    }

    @Override
    public Set<String> getFullBkpCompletedByProductType(int cloudId, List<String> policyNameList, String productType) {
        return this.deviceDao.getFullBkpCompletedByProductType(cloudId, policyNameList, productType);
    }

    @Override
    public List<String> getUsersWithatLeastDeviceAssigned(ReportQueryElement reportQueryElement, String productType, Cloud cloud) {
        List uniqueUserNamesInDevice = new ArrayList();
        uniqueUserNamesInDevice = CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames()) ? this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), productType) : this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
        List userNames = uniqueUserNamesInDevice.stream().map(user -> user.toLowerCase()).collect(Collectors.toList());
        logger.debug(".......uniqueUserNamesInDevice......" + uniqueUserNamesInDevice.size());
        List usersInNames = this.userDao.getUsersCountInNames(cloud.getCloudId(), userNames);
        List<String> usersCountInNames = null;
        if (productType == null || productType.equalsIgnoreCase("BACKUP")) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isBackupEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        } else if (productType.equalsIgnoreCase(ODB)) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isOnedriveBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        } else if (productType.equalsIgnoreCase("Exchange")) {
            usersCountInNames = usersInNames.stream().filter(user -> user.isExchangeBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
        }
        return usersCountInNames;
    }

    @Override
    public Set<String> getUsersHadHeartBeat(ReportQueryElement reportQueryElement, String productType, Cloud cloud) {
        Set<String> usersHeardCountSet = Collections.synchronizedSet(new HashSet());
        Set usersProtectedSet = Collections.synchronizedSet(new HashSet());
        int cloudId = cloud.getCloudId();
        List<BackupOverviewElement> backupOverviewElementsList = Collections.synchronizedList(new ArrayList());
        List<Object> deviceOverviews = new ArrayList();
        if (reportQueryElement == null) {
            deviceOverviews = this.deviceDao.getAllBkpOverviews(cloud.getCloudId());
            reportQueryElement = new ReportQueryElement();
            reportQueryElement.setNoOfDays(7);
        } else {
            deviceOverviews = this.getBkpOverviewFromReportQuery(cloud, cloud.getCloudName(), reportQueryElement, productType);
        }
        try {
            logger.debug("...before removing blocked device size..." + deviceOverviews.size());
            deviceOverviews = deviceOverviews.stream().filter(overView -> !overView.isDeviceBolcked() && overView.isUserActive()).collect(Collectors.toList());
            logger.debug("...after removing blocked device size..." + deviceOverviews.size());
            backupOverviewElementsList = this.getOverviewElementsForConnDeviceForDPS(cloudId, cloud.getCloudName(), backupOverviewElementsList, deviceOverviews);
            Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
            backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
            int noOfDaysToQuery = reportQueryElement.getNoOfDays();
            backupOverviewElementsList.parallelStream().forEach(element -> {
                if (!StringUtils.isEmpty((String)element.getDeviceType()) && (element.getDeviceType().equalsIgnoreCase("ONEDRIVE") || element.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString()))) {
                    usersHeardCountSet.add(element.getUserId());
                }
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                DateTime dt1 = null;
                DateTime dt2 = new DateTime();
                Date yourDate = null;
                if (!StringUtils.isEmpty((String)element.getLastHeardTime())) {
                    try {
                        yourDate = format.parse(element.getLastHeardTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    dt1 = new DateTime((Object)yourDate);
                    dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference < noOfDaysToQuery) {
                        usersHeardCountSet.add(element.getUserId());
                    }
                }
                int lastBkpStartDiff = 999;
                int lastSuccessfulBkpEndDiff = 999;
                int firstBkpEndDiff = 999;
                int lastBkpEndDiff = 999;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    String currentBkpStarted = element.getCurrentBkpStartTime();
                    try {
                        yourDate = ReportServiceImpl.getDateByString(currentBkpStarted);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpStartDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpStartDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastSuccessfulBkp())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastSuccessfulBkp());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastSuccessfulBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastSuccessfulBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getFirstBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getFirstBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        firstBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (lastSuccessfulBkpEndDiff < noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                } else if (lastBkpEndDiff < noOfDaysToQuery && lastBkpStartDiff > noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                } else if (lastBkpStartDiff < noOfDaysToQuery || firstBkpEndDiff < noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                }
            });
        }
        catch (Exception e) {
            logger.debug("Exception......", (Throwable)e);
            logger.trace(" Exception :" + e);
            logger.error("Exception while getting  msg " + e.getMessage());
        }
        return usersHeardCountSet;
    }

    @Override
    public Set<String> getUsersProtect(ReportQueryElement reportQueryElement, String productType, Cloud cloud) {
        Set usersHeardCountSet = Collections.synchronizedSet(new HashSet());
        Set<String> usersProtectedSet = Collections.synchronizedSet(new HashSet());
        int cloudId = cloud.getCloudId();
        List<BackupOverviewElement> backupOverviewElementsList = Collections.synchronizedList(new ArrayList());
        List<Object> deviceOverviews = new ArrayList();
        if (reportQueryElement == null) {
            deviceOverviews = this.deviceDao.getAllBkpOverviews(cloud.getCloudId());
            reportQueryElement = new ReportQueryElement();
            reportQueryElement.setNoOfDays(7);
        } else {
            deviceOverviews = this.getBkpOverviewFromReportQuery(cloud, cloud.getCloudName(), reportQueryElement, productType);
        }
        try {
            logger.debug("...before removing blocked device size..." + deviceOverviews.size());
            deviceOverviews = deviceOverviews.stream().filter(overView -> !overView.isDeviceBolcked() && overView.isUserActive()).collect(Collectors.toList());
            logger.debug("...after removing blocked device size..." + deviceOverviews.size());
            backupOverviewElementsList = this.getOverviewElementsForConnDeviceForDPS(cloudId, cloud.getCloudName(), backupOverviewElementsList, deviceOverviews);
            Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
            backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
            int noOfDaysToQuery = reportQueryElement.getNoOfDays();
            backupOverviewElementsList.parallelStream().forEach(element -> {
                if (!StringUtils.isEmpty((String)element.getDeviceType()) && (element.getDeviceType().equalsIgnoreCase("ONEDRIVE") || element.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString()))) {
                    usersHeardCountSet.add(element.getUserId());
                }
                SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
                DateTime dt1 = null;
                DateTime dt2 = new DateTime();
                Date yourDate = null;
                if (!StringUtils.isEmpty((String)element.getLastHeardTime())) {
                    try {
                        yourDate = format.parse(element.getLastHeardTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    dt1 = new DateTime((Object)yourDate);
                    dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference < noOfDaysToQuery) {
                        usersHeardCountSet.add(element.getUserId());
                    }
                }
                int lastBkpStartDiff = 999;
                int lastSuccessfulBkpEndDiff = 999;
                int firstBkpEndDiff = 999;
                int lastBkpEndDiff = 999;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    String currentBkpStarted = element.getCurrentBkpStartTime();
                    try {
                        yourDate = ReportServiceImpl.getDateByString(currentBkpStarted);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpStartDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpStartDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastSuccessfulBkp())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastSuccessfulBkp());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastSuccessfulBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastSuccessfulBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getLastBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getFirstBkpEndTime())) {
                    try {
                        yourDate = ReportServiceImpl.getDateByString(element.getFirstBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        firstBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (lastSuccessfulBkpEndDiff < noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                } else if (lastBkpEndDiff < noOfDaysToQuery && lastBkpStartDiff > noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                } else if (lastBkpStartDiff < noOfDaysToQuery || firstBkpEndDiff < noOfDaysToQuery) {
                    usersProtectedSet.add(element.getUserId());
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                }
            });
        }
        catch (Exception e) {
            logger.debug("Exception......", (Throwable)e);
            logger.trace(" Exception :" + e);
            logger.error("Exception while getting  msg " + e.getMessage());
        }
        return usersProtectedSet;
    }

    @Override
    public String getLastSuccessfullBAckup(int cloudId, String deviceUUID) {
        DeviceBackupOverView deviceBackupOverView = this.deviceManagementService.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        String lastSuccessfullBAckup = deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L ? ReportServiceImpl.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), "dd-MMM-yyyy HH:mm:ss") : "-";
        return lastSuccessfullBAckup;
    }
}

