/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.paracloud.element.BackupoverviewResponse;
import com.parablu.pcbd.dao.CloudDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.CloudProperties;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportGenerator;
import com.parablu.report.util.ExcelReportUtil;
import com.parablu.report.util.PdfReportUtil;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class BackupOverviewReportGenerator
implements ReportGenerator<BackupoverviewResponse> {
    private static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    public static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    public static final String HH_MM_SS = "HH:mm:ss";
    private static final String REPORTS_PATH = "/reports/";
    private static final String PDF_EXTENSION = ".pdf";
    private static Logger logger = LogManager.getLogger();
    private DeviceDao deviceDao;
    private UserDao userDao;
    private CloudDao cloudDao;
    private ReportUtil reportUtil;
    private ExcelReportUtil excelReportUtil;
    private PdfReportUtil pdfReportUtil;

    public BackupOverviewReportGenerator(DeviceDao deviceDao, UserDao userDao, CloudDao cloudDao, ReportUtil reportUtil, ExcelReportUtil excelReportUtil, PdfReportUtil pdfReportUtil) {
        this.deviceDao = deviceDao;
        this.userDao = userDao;
        this.cloudDao = cloudDao;
        this.reportUtil = reportUtil;
        this.excelReportUtil = excelReportUtil;
        this.pdfReportUtil = pdfReportUtil;
    }

    @Override
    public BackupoverviewResponse generateReport(Cloud cloud, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("process=Inside BackupOverviewReportGenerator, status started");
        String productType = reportQueryElement.getProductType();
        BackupoverviewResponse backupoverviewResponse = new BackupoverviewResponse();
        ArrayList<BackupOverviewElement> bkpOverviewElementsList = new ArrayList<BackupOverviewElement>();
        try {
            Comparator<BackupOverviewElement> comparator;
            DeviceBackupOverView deviceOver;
            List<Object> bkpOverViewuserNames;
            List<DeviceBackupOverView> deviceOverviews = new ArrayList();
            List<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
            boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
            List<Object> users = new ArrayList<User>();
            if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
                User user2 = this.userDao.getUserInfoByName(cloud.getCloudId(), cloud.getCloudName(), reportQueryElement.getUserName());
                if (!user2.isGuest() && !user2.isSuperAdmin()) {
                    users.add(user2);
                }
            } else {
                List usersList = this.userDao.getAllUsers(cloud.getCloudId());
                for (User ue : usersList) {
                    if (ue.isGuest() || ue.isSuperAdmin()) continue;
                    users.add(ue);
                }
            }
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equalsIgnoreCase(productType)) {
                users = users.stream().filter(user -> user.getSpPolicyName() != null && !user.getSpPolicyName().isEmpty()).collect(Collectors.toList());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equalsIgnoreCase(productType)) {
                users = users.stream().filter(user -> user.getOneDrivePolicyName() != null && !user.getOneDrivePolicyName().isEmpty()).collect(Collectors.toList());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equalsIgnoreCase(productType)) {
                users = users.stream().filter(user -> user.getExchangePolicyName() != null && !user.getExchangePolicyName().isEmpty()).collect(Collectors.toList());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equalsIgnoreCase(productType)) {
                users = users.stream().filter(user -> user.getPolicyName() != null && !user.getPolicyName().isEmpty()).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
                deviceOverviews = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
                logger.debug(deviceOverviews.size() + "..policynames..." + reportQueryElement.getPolicyNames());
                logger.debug("...isUserWithoutDeviceEnabled.." + isUserWithoutDeviceEnabled);
                if (isUserWithoutDeviceEnabled) {
                    bkpOverViewuserNames = new ArrayList();
                    if (!CollectionUtils.isEmpty(deviceOverviews)) {
                        bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                        List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
                        for (int i = 0; i < usersByPolicyName.size(); ++i) {
                            logger.debug("..check user...." + ((User)usersByPolicyName.get(i)).getUserName());
                            if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                            deviceOver = new DeviceBackupOverView();
                            User user2 = (User)usersByPolicyName.get(i);
                            if (user2 == null) continue;
                            deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(user2);
                            deviceOverviews.add(deviceOver);
                        }
                        logger.debug("..deviceOverviews....." + deviceOverviews.size());
                    } else {
                        List usersList = this.userDao.getAllUsersByPolicyNames(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
                        logger.debug("...");
                        for (User userDetails : usersList) {
                            DeviceBackupOverView deviceBackupOverView = new DeviceBackupOverView();
                            if (userDetails == null) continue;
                            DeviceBackupOverView deviceBackupOverView2 = this.reportUtil.setUserWithoutDeviceElementvalue(userDetails);
                            deviceOverviews.add(deviceBackupOverView2);
                        }
                    }
                }
                logger.debug("..deviceOverviews....." + deviceOverviews.size());
            } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
                deviceOverviews = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceNameForProductType(cloud.getCloudId(), reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), productType) : this.deviceDao.getDeviceBkpOverviewForUserNameForProductType(cloud.getCloudId(), reportQueryElement.getUserName(), productType);
                if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(deviceOverviews)) {
                    User user3 = (User)users.get(0);
                    DeviceBackupOverView deviceOver3 = new DeviceBackupOverView();
                    if (user3 != null) {
                        deviceOver3 = this.reportUtil.setUserWithoutDeviceElementvalue(user3);
                        deviceOverviews.add(deviceOver3);
                    }
                }
                logger.debug("..deviceOverviews....." + deviceOverviews.size());
            } else {
                deviceOverviews = this.deviceDao.getAllOverviewsForProductType(cloud.getCloudId(), productType);
                logger.debug(productType + ".... bkp overview report.." + deviceOverviews.size());
                if (isUserWithoutDeviceEnabled) {
                    bkpOverViewuserNames = new ArrayList();
                    bkpOverViewuserNames = deviceOverviews.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    for (int i = 0; i < users.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                        User user4 = (User)users.get(i);
                        deviceOver = new DeviceBackupOverView();
                        if (user4 == null) continue;
                        deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(user4);
                        deviceOverviews.add(deviceOver);
                    }
                }
            }
            ArrayList<DeviceBackupOverView> newOverViewList = new ArrayList<DeviceBackupOverView>();
            logger.debug(deviceOverviews.size() + "..deviceOverviews before processing....." + backupOverviewElementsList.size());
            for (DeviceBackupOverView bkpOVerview : deviceOverviews) {
                for (User user4 : users) {
                    if (!bkpOVerview.getUserName().equalsIgnoreCase(user4.getUserName())) continue;
                    if (user4 != null && productType.equalsIgnoreCase(PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType()) && (user4.isBackupEnabled() || !user4.isActive())) {
                        newOverViewList.add(bkpOVerview);
                        continue;
                    }
                    if (user4 != null && productType.equalsIgnoreCase(PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType()) && (user4.isOnedriveBkpEnabled() || !user4.isActive())) {
                        newOverViewList.add(bkpOVerview);
                        continue;
                    }
                    if (user4 != null && productType.equalsIgnoreCase(PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType()) && (user4.isExchangeBkpEnabled() || !user4.isActive())) {
                        newOverViewList.add(bkpOVerview);
                        continue;
                    }
                    if (user4 == null || !productType.equalsIgnoreCase(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType()) || !user4.isSite() && user4.isActive()) continue;
                    newOverViewList.add(bkpOVerview);
                }
            }
            backupOverviewElementsList = this.reportUtil.getOverviewElementsForExistingUsers(cloud, backupOverviewElementsList, newOverViewList, reportQueryElement.isShowBlockedUsers(), reportQueryElement.isShowBlockedDevices(), productType);
            logger.debug(deviceOverviews.size() + "..backupOverviewElementsList....." + backupOverviewElementsList.size());
            for (BackupOverviewElement backupOverviewElement : backupOverviewElementsList) {
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime());
                long l = 0L;
                l = backupOverviewElement.getTotalSizeToUploadInKB() != 0L && backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB() != 0L ? this.reportUtil.getPercentageCompleted(backupOverviewElement.getTotalSizeToUploadInKB(), backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFilesInKB()) : this.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
                l = this.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
                String lastBkpStatus = backupOverviewElement.getLastBkpStatus();
                if (lastBkpStatus == null) {
                    lastBkpStatus = "";
                }
                boolean isDeviceActive = backupOverviewElement.isDeviceActive();
                boolean isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.PAUSED.toString().equalsIgnoreCase(lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.INTERRUPTED.toString().equalsIgnoreCase(lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.ABORTED.toString().equalsIgnoreCase(lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.EXITED.toString().equalsIgnoreCase(lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.STOPPED.toString().equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
                String lstBkpStartTimeStr = "";
                if (!StringUtils.isEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && isBackupRunning && StringUtils.isNotEmpty((String)(lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime())) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    long lstsuccessBkpEndTime;
                    long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpStartTime());
                    if (lstBkpStartTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                    }
                    lstBkpStartTimeStr = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY_HH_MM_SS);
                }
                String percent = "-";
                if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && !lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString()) && !lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.SCANNING.toString()) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining())) {
                    percent = String.valueOf(l) + "%";
                }
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    Date lastAgentAccessTime;
                    SimpleDateFormat sdf;
                    Date bkpEndTime;
                    String lastAccessTime = this.reportUtil.getDateInFormat(backupOverviewElement.getLastAccessedTime(), DD_MMM_YYYY_HH_MM_SS);
                    lastHeardDate = StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime()) ? lastAccessTime : (backupOverviewElement.getLastAccessedTime() <= 0L ? backupOverviewElement.getLastBkpEndTime() : ((bkpEndTime = (sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS)).parse(backupOverviewElement.getLastBkpEndTime())).compareTo(lastAgentAccessTime = sdf.parse(lastAccessTime)) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime));
                    long lastHeardDateTime = this.reportUtil.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = this.reportUtil.getDateInFormat(lstsuccessBkpEndTime, DD_MMM_YYYY_HH_MM_SS);
                    }
                }
                if (StringUtils.isEmpty((String)lastHeardDate) && StringUtils.isNotEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                    lastHeardDate = this.reportUtil.getDateInFormat(Long.parseLong(backupOverviewElement.getEpaInstallationDate()), DD_MMM_YYYY_HH_MM_SS);
                }
                backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer(percent);
                backupOverviewElement.setBackupRunning(isBackupRunning);
                backupOverviewElement.setFirstBackupCompleted(isFirstBkpCompleted);
                backupOverviewElement.setCurrentBkpStartTime(lstBkpStartTimeStr);
                if (StringUtils.isNotEmpty((String)lastBkpStatus) && lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString())) {
                    backupOverviewElement.setCurrentBkpStatus("-");
                } else {
                    backupOverviewElement.setCurrentBkpStatus(lastBkpStatus);
                }
                backupOverviewElement.setLastHeardTime(lastHeardDate);
                backupOverviewElement.setLastHeardTimeInMillis(this.reportUtil.getTime(lastHeardDate));
                if (!StringUtils.isNotEmpty((String)lastBkpStatus) || !lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.STATUS_STARTED.toString())) {
                    backupOverviewElement.setCurrentlyRunningBkpNoOfFiles(0L);
                    backupOverviewElement.setCurrentlyRunningBkpTotalSizeOfFiles("-");
                    backupOverviewElement.setTotalCurrentlyRunningBkpSizeInPer("-");
                }
                logger.debug(percent + "...percentage...." + l);
                backupOverviewElement.setCurrentBkpCompletionPct("" + percent);
                bkpOverviewElementsList.add(backupOverviewElement);
            }
            backupoverviewResponse.setBackupOverview(bkpOverviewElementsList);
            if (((Report.Product)Report.BACKUP_OVERVIEW.getProducts().get(reportQueryElement.getProductType())).isView() && ReportQueryElement.ReportOperation.GENERATE_VIEW.toString().equals(reportQueryElement.getOperationType().toString())) {
                logger.debug("Generated view as per operationType, status=completed");
                return backupoverviewResponse;
            }
            if (((Report.Product)Report.BACKUP_OVERVIEW.getProducts().get(reportQueryElement.getProductType())).isExcel() && ReportQueryElement.ReportOperation.GENERATE_EXCEL.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (bkpOverviewElementsList != null && bkpOverviewElementsList.size() > 0) {
                    comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
                    Long currentmills = System.currentTimeMillis();
                    for (BackupOverviewElement backupOverviewElement : bkpOverviewElementsList) {
                        backupOverviewElement.setOverviewJobTime(String.valueOf(currentmills));
                    }
                    bkpOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
                    this.createExcelForXlsx(cloud, bkpOverviewElementsList, reportQueryElement, productType);
                    logger.debug("BackupOverview excel report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for backup overview");
                throw new Exception(Integer.toString(403));
            }
            if (((Report.Product)Report.BACKUP_OVERVIEW.getProducts().get(reportQueryElement.getProductType())).isPdf() && ReportQueryElement.ReportOperation.GENERATE_PDF.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (bkpOverviewElementsList != null && bkpOverviewElementsList.size() > 0) {
                    comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
                    Long currentmills = System.currentTimeMillis();
                    for (BackupOverviewElement backupOverviewElement : bkpOverviewElementsList) {
                        backupOverviewElement.setOverviewJobTime(String.valueOf(currentmills));
                    }
                    bkpOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
                    this.createPdfOfBackupOverviewWithOpenPDF(cloud, bkpOverviewElementsList, reportQueryElement, productType);
                    logger.debug("BackupOverview pdf report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for backup overview");
                throw new Exception(Integer.toString(403));
            }
            throw new Exception("Not a valid operation Type");
        }
        catch (Exception e) {
            logger.error("There is an exception during generating a report for Backup overview");
            throw e;
        }
    }

    private long getPercentageCompleted(String totalNoOfFiles, String noOfFilesRemaining) throws Exception {
        long totalNoOfFilesValue = 0L;
        long noOfFilesRemainingValue = 0L;
        if (!StringUtils.isEmpty((String)totalNoOfFiles)) {
            totalNoOfFilesValue = Integer.parseInt(totalNoOfFiles);
        }
        if (!StringUtils.isEmpty((String)noOfFilesRemaining)) {
            noOfFilesRemainingValue = Integer.parseInt(noOfFilesRemaining);
        }
        long filesBackedup = totalNoOfFilesValue - noOfFilesRemainingValue;
        long percentage = 100L;
        if (totalNoOfFilesValue != 0L) {
            percentage = filesBackedup * 100L / totalNoOfFilesValue;
        }
        if (percentage > 100L) {
            percentage = 100L;
        }
        if (totalNoOfFilesValue <= 0L || noOfFilesRemainingValue <= 0L) {
            percentage = 0L;
        }
        return percentage;
    }

    private void createExcelForXlsx(Cloud cloud, List<BackupOverviewElement> backupOverviewElementsList, ReportQueryElement reportQueryElement, String productType) throws Exception {
        if (!backupOverviewElementsList.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                BackupOverviewElement element = backupOverviewElementsList.get(0);
                String overViewTime = element.getOverviewJobTime();
                logger.debug(" Before creating excel for overview ...");
                List<List> recordToAdd = this.updateValuesToExcel(cloud, backupOverviewElementsList, this.reportUtil.getLongValue(overViewTime), reportQueryElement, productType);
                this.excelReportUtil.createExcelSheet(recordToAdd, workbook, Report.BACKUP_OVERVIEW.getFileName()[0]);
                this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.BACKUP_OVERVIEW.getFileName()[0]);
                logger.debug(" After creating excel for overview ...");
            }
        }
    }

    private List<List> updateValuesToExcel(Cloud cloud, List<BackupOverviewElement> bkpOverViewList, long reportDate, ReportQueryElement reportQueryElement, String productType) throws Exception {
        boolean showAdditionalAdAttrbs = PCHelperConstant.showAdditionalAdAttrbs();
        boolean showAddReportAttrbs = PCHelperConstant.showAddReportAttr();
        boolean isODBEnabled = BackupOverviewReportGenerator.isODBEnabled(cloud.getCloudCustomisableDetails());
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.SITE_NAME.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.SITE_STATUS.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.SITE_INSTALLATION_DATE.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.SITE_INSTALLATION_TIME.getHeaders());
        } else {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.USER_ID.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.EMAIL_ID.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.USER_STATUS.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ASSET_NAME.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ASSET_STATUS.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ASSET_INSTALLATION_DATE.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ASSET_INSTALLATION_TIME.getHeaders());
        }
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.OS_TYPE.getHeaders());
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()))) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CLIENT_VERSION.getHeaders());
        }
        if (isShowUserConsentFieldInPolicies.booleanValue()) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CONSENT_GIVEN.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CONSENT_GIVEN_TIME.getHeaders());
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ONEDRIVE_FOR_BUSINESS_POLICY_NAME.getHeaders());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.EXCHANGE_FOR_BUSINESS_POLICY_NAME.getHeaders());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.SHAREPOINT_ONLINE_POLICY_NAME.getHeaders());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.POLICYNAME.getHeaders());
        }
        if (isODBEnabled) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.BACKUP_TARGET_ASSIGNED.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.REASON.getHeaders());
        }
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_START_DATE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_START_TIME.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_END_DATE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_END_TIME.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_COMPLETED.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_START_DATE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_START_TIME.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_END_DATE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_END_TIME.getHeaders());
        if (showAddReportAttrbs) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_START_DATE.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_START_TIME.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_END_DATE.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_END_TIME.getHeaders());
        }
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.IS_LAST_BACKUP_COMPLETED.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_START_DATE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_START_TIME.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_STATUS.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_COMPLETION.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.IS_BACKUP_RUNNING.getHeaders());
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType))) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_HEARD_DATE.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_TIME_HEARD.getHeaders());
        }
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.TOTAL_DATA_BACKED_UP.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.NOTES.getHeaders());
        if (showAdditionalAdAttrbs) {
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.DISPLAY_NAME.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LOCATION.getHeaders());
            headerRow.add(BACKUP_OVERVIEW_CONSTANTS.DEPARTMENT.getHeaders());
            if (BackupOverviewReportGenerator.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                headerRow.add(BACKUP_OVERVIEW_CONSTANTS.AZURE_ACTIVE_DIRECTORY_USER_STATUS.getHeaders());
            } else {
                headerRow.add(BACKUP_OVERVIEW_CONSTANTS.ACTIVE_DIRECTORY_USER_STATUS.getHeaders());
            }
        }
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_SIZE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_NO_OF_FILES.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_SIZE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_NO_OF_FILES.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_PROGRESS_SIZE.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_PROGRESS_NO_OF_FILES.getHeaders());
        headerRow.add(BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_EXPECTED_SIZE.getHeaders());
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(BACKUP_OVERVIEW_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + this.getTimeZoneShortFormat(reportDate));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(BACKUP_OVERVIEW_CONSTANTS.POLICYNAME.getHeaders() + policyNames + "   ");
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(BACKUP_OVERVIEW_CONSTANTS.SITENAME.getHeaders() + reportQueryElement.getDeviceName() + "   ");
            }
        } else {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                sb.append(BACKUP_OVERVIEW_CONSTANTS.USERNAME.getHeaders() + reportQueryElement.getUserName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(BACKUP_OVERVIEW_CONSTANTS.ASSETNAME.getHeaders() + reportQueryElement.getDeviceName() + "   ");
            }
        }
        String includeUserswithoutdevice = "No";
        String includeblockedusers = "NO";
        String includeblockeddevices = "NO";
        if (reportQueryElement.isUserWithoutDeviceEnabled()) {
            includeUserswithoutdevice = "YES";
        }
        if (reportQueryElement.isShowBlockedUsers()) {
            includeblockedusers = "YES";
        }
        if (reportQueryElement.isShowBlockedDevices()) {
            includeblockeddevices = "YES";
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            sb.append(BACKUP_OVERVIEW_CONSTANTS.INCLUDE_BLOCKED_SITES.getHeaders() + includeblockeddevices + "   ");
        } else {
            sb.append(BACKUP_OVERVIEW_CONSTANTS.INCLUDE_USERS_WITHOUT_A_ASSET_INSTALLED.getHeaders() + includeUserswithoutdevice + "   ");
            sb.append(BACKUP_OVERVIEW_CONSTANTS.INCLUDE_BLOCKED_USERS.getHeaders() + includeblockedusers + "   ");
            sb.append(BACKUP_OVERVIEW_CONSTANTS.INCLUDE_BLOCKED_ASSETS.getHeaders() + includeblockeddevices + "   ");
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add("Backup Overview");
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : bkpOverViewList) {
            boolean isBackupRunningStatus;
            boolean isBackupRunning;
            String lastBkpStatus;
            long firstBkpStartTime;
            ArrayList<String> firstRow = new ArrayList<String>();
            boolean isDeviceActive = false;
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    firstRow.add(backupOverviewElement.getDeviceName());
                } else {
                    firstRow.add("-");
                }
                isDeviceActive = backupOverviewElement.isDeviceActive();
                String deviceActive = BackupOverviewReportGenerator.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                if (!StringUtils.isEmpty((String)deviceActive)) {
                    firstRow.add(deviceActive);
                } else {
                    firstRow.add("-");
                }
            } else {
                firstRow.add(backupOverviewElement.getUserId());
                firstRow.add(backupOverviewElement.getEmailId());
                String userActive = this.getUserActiveStatus(backupOverviewElement);
                firstRow.add(userActive);
                if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                    firstRow.add(backupOverviewElement.getDeviceName());
                } else {
                    firstRow.add("-");
                }
                isDeviceActive = backupOverviewElement.isDeviceActive();
                String deviceActive = BackupOverviewReportGenerator.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                if (!StringUtils.isEmpty((String)deviceActive)) {
                    firstRow.add(deviceActive);
                } else {
                    firstRow.add("-");
                }
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate())) {
                long installtionTimeStamp = this.reportUtil.getTime(backupOverviewElement.getEpaInstallationDate());
                firstRow.add(this.reportUtil.getDateInFormat(installtionTimeStamp, DD_MMM_YYYY));
                firstRow.add(this.reportUtil.getDateInFormat(installtionTimeStamp, HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            String osVersionBits = "";
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOsVersion())) {
                osVersionBits = backupOverviewElement.getOsVersion().contains("(") ? "(" + backupOverviewElement.getOsVersion().substring(backupOverviewElement.getOsVersion().indexOf("(") + 1, backupOverviewElement.getOsVersion().indexOf(")")) + ")" : backupOverviewElement.getOsVersion();
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOsType())) {
                firstRow.add(backupOverviewElement.getOsType() + osVersionBits);
            } else {
                firstRow.add("-");
            }
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()))) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getClientVersion())) {
                    firstRow.add(backupOverviewElement.getClientVersion());
                } else {
                    firstRow.add("-");
                }
            }
            if (isShowUserConsentFieldInPolicies.booleanValue()) {
                if (backupOverviewElement.getOsType().startsWith("Window") || backupOverviewElement.getOsType().startsWith("Mac")) {
                    firstRow.add(backupOverviewElement.getConsentGiven());
                    firstRow.add(backupOverviewElement.getConsentGivenTime());
                } else {
                    firstRow.add("");
                    firstRow.add("");
                }
            }
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                firstRow.add(backupOverviewElement.getOneDrivePolicyName());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                firstRow.add(backupOverviewElement.getExchangePolicyName());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                firstRow.add(backupOverviewElement.getSpPolicyName());
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                firstRow.add(backupOverviewElement.getPolicyName());
            }
            if (isODBEnabled) {
                if (backupOverviewElement.isBackupTargetAssigned()) {
                    firstRow.add("Yes");
                } else {
                    firstRow.add("No");
                }
                if (backupOverviewElement.isBackupTargetAssigned() & backupOverviewElement.getBackupTargetErrorCode() == 0) {
                    firstRow.add("");
                } else {
                    firstRow.add(this.getCommentsForErrorCode(backupOverviewElement.getBackupTargetErrorCode()));
                }
            }
            if (!StringUtils.isEmpty((String)this.reportUtil.getDateInFormat(firstBkpStartTime = this.reportUtil.getFirstBkpStartTime(backupOverviewElement), DD_MMM_YYYY))) {
                firstRow.add(this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY));
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)this.reportUtil.getDateInFormat(firstBkpStartTime, HH_MM_SS))) {
                firstRow.add(this.reportUtil.getDateInFormat(firstBkpStartTime, HH_MM_SS));
            } else {
                firstRow.add("-");
            }
            long firstbackupEndTime = this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                firstRow.add(this.reportUtil.getDateInFormat(firstbackupEndTime, DD_MMM_YYYY));
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                firstRow.add(this.reportUtil.getDateInFormat(firstbackupEndTime, HH_MM_SS));
            } else {
                firstRow.add("-");
            }
            String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
            String lastSuccessfulBackupEndDate = "";
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)lastSuccessfulBackupEndTime);
            String firstBkpCompleted = this.getFirstBkpCompletedState(isFirstBkpCompleted);
            firstRow.add(firstBkpCompleted);
            String lastSuccessBkpStartTime = "";
            String lastSuccessBkpStartDate = "";
            if (isFirstBkpCompleted) {
                long lstBkpEndTime;
                long lstBkpStartTime;
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getFirstBkpStartTime());
                    backupOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getFirstBkpEndTime());
                }
                if ((lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime())) > (lstBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lstBkpEndTime = lstBkpStartTime + 0x6DDD00L;
                }
                lastSuccessBkpStartTime = this.reportUtil.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                lastSuccessBkpStartDate = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
                lastSuccessfulBackupEndTime = this.reportUtil.getDateInFormat(lstBkpEndTime, HH_MM_SS);
                lastSuccessfulBackupEndDate = this.reportUtil.getDateInFormat(lstBkpEndTime, DD_MMM_YYYY);
            }
            if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                firstRow.add(lastSuccessBkpStartDate);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)lastSuccessBkpStartTime)) {
                firstRow.add(lastSuccessBkpStartTime);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                firstRow.add(lastSuccessfulBackupEndDate);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndTime)) {
                firstRow.add(lastSuccessfulBackupEndTime);
            } else {
                firstRow.add("-");
            }
            if (showAddReportAttrbs) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpStartTime())) {
                    long lastBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpStartTime());
                    firstRow.add(this.reportUtil.getDateInFormat(lastBkpStartTime, DD_MMM_YYYY));
                    firstRow.add(this.reportUtil.getDateInFormat(lastBkpStartTime, HH_MM_SS));
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                    long lastBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpEndTime());
                    firstRow.add(this.reportUtil.getDateInFormat(lastBkpEndTime, DD_MMM_YYYY));
                    firstRow.add(this.reportUtil.getDateInFormat(lastBkpEndTime, HH_MM_SS));
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
            }
            if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                lastBkpStatus = "-";
            }
            if (backupOverviewElement.isLastBackupCompleted()) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            boolean bl = isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
            if (!StringUtils.isEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus)) {
                String lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime();
                String lstBkpStartDateStr = backupOverviewElement.getLastBkpStartTime();
                if (StringUtils.isNotEmpty((String)lstBkpStartTimeStr) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    long lstsuccessBkpEndTime;
                    long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpStartTime());
                    if (lstBkpStartTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                    }
                    lstBkpStartTimeStr = this.reportUtil.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                    lstBkpStartDateStr = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
                }
                firstRow.add(lstBkpStartDateStr);
                firstRow.add(lstBkpStartTimeStr);
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString())) {
                firstRow.add("-");
            } else {
                firstRow.add(lastBkpStatus);
            }
            int totalNoOfFiles = 0;
            boolean noOfFilesRemaining = false;
            if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
            }
            long percentage = 0L;
            percentage = this.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && !lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString()) && !lastBkpStatus.equalsIgnoreCase("SCANNING")) {
                firstRow.add(String.valueOf(percentage) + "%");
            } else {
                firstRow.add("-");
            }
            boolean bl2 = isBackupRunningStatus = StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && !"STOPPED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive && !lastBkpStatus.equalsIgnoreCase("-");
            if (isBackupRunningStatus) {
                firstRow.add("Y");
            } else {
                firstRow.add("N");
            }
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType))) {
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    String lastAccessTime = this.reportUtil.getDateInFormat(backupOverviewElement.getLastAccessedTime(), DD_MMM_YYYY_HH_MM_SS);
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        lastHeardDate = lastAccessTime;
                    } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                        lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                        Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                        Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                        lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                    }
                    long lastHeardDateTime = this.reportUtil.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = this.reportUtil.getDateInFormat(lstsuccessBkpEndTime, DD_MMM_YYYY_HH_MM_SS);
                    }
                    long lastHeardTimeStamp = this.reportUtil.getTime(lastHeardDate);
                    firstRow.add(this.reportUtil.getDateInFormat(lastHeardTimeStamp, DD_MMM_YYYY));
                    firstRow.add(this.reportUtil.getDateInFormat(lastHeardTimeStamp, HH_MM_SS));
                } else {
                    firstRow.add("-");
                    firstRow.add("-");
                }
            }
            firstRow.add(backupOverviewElement.getStorageUtilized());
            firstRow.add(backupOverviewElement.getReason());
            if (showAdditionalAdAttrbs) {
                firstRow.add(backupOverviewElement.getDisplayName());
                firstRow.add(backupOverviewElement.getLocation());
                firstRow.add(backupOverviewElement.getDepartment());
                if (backupOverviewElement.isAccountStatus()) {
                    firstRow.add("Y");
                } else {
                    firstRow.add("N");
                }
            }
            if (isFirstBkpCompleted) {
                firstRow.add(backupOverviewElement.getFirstFullBkpTotalSizeOfFiles());
                firstRow.add("" + backupOverviewElement.getFirstFullBkpNoOfFiles());
                firstRow.add(backupOverviewElement.getLastSucessfulBkpTotalSizeOfFiles());
                firstRow.add("" + backupOverviewElement.getLastSucessfulBkpNoOfFiles());
            } else {
                firstRow.add("-");
                firstRow.add("-");
                firstRow.add("-");
                firstRow.add("-");
            }
            if (StringUtils.isNotEmpty((String)lastBkpStatus) && PCHelperConstant.BACKUP_STATUS.STATUS_STARTED.toString().equalsIgnoreCase(lastBkpStatus)) {
                firstRow.add(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                firstRow.add("" + backupOverviewElement.getCurrentlyRunningBkpNoOfFiles());
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus)) {
                firstRow.add(backupOverviewElement.getTotalSizeToUpload());
            } else {
                firstRow.add("-");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private void createPdfOfBackupOverviewWithOpenPDF(Cloud cloud, List<BackupOverviewElement> backupOverviewElementsList, ReportQueryElement reportQueryElement, String productType) throws Exception {
        String tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.BACKUP_OVERVIEW.getFileName()[0] + "temp" + PDF_EXTENSION;
        String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.BACKUP_OVERVIEW.getFileName()[0] + PDF_EXTENSION;
        boolean showAdditionalAdAttrbs = PCHelperConstant.showAdditionalAdAttrbs();
        CloudProperties cloudProperties = this.cloudDao.getCloudProperties(1);
        Boolean isShowUserConsentFieldInPolicies = cloudProperties.isShowUserConsentFieldInPolicies();
        boolean showAddReportAttrbs = PCHelperConstant.showAddReportAttr();
        boolean isODBEnabled = BackupOverviewReportGenerator.isODBEnabled(cloud.getCloudCustomisableDetails());
        boolean isDeviceActive = false;
        String deviceActive = null;
        StringBuilder htmlContent = new StringBuilder();
        String currentDate = this.getTimeZoneShortFormat(System.currentTimeMillis());
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>" + BACKUP_OVERVIEW_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
        String includeUserswithoutdevice = "No";
        String includeblockedusers = "NO";
        String includeblockeddevices = "NO";
        if (reportQueryElement.isUserWithoutDeviceEnabled()) {
            includeUserswithoutdevice = "YES";
        }
        if (reportQueryElement.isShowBlockedUsers()) {
            includeblockedusers = "YES";
        }
        if (reportQueryElement.isShowBlockedDevices()) {
            includeblockeddevices = "YES";
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.INCLUDE_BLOCKED_SITES.getHeaders() + includeblockeddevices + "   </p>");
        } else {
            htmlContent.append("<p>Include Users without a asset installed: " + includeUserswithoutdevice + "   </p>").append("<p>Include blocked users: " + includeblockedusers + "   </p>").append("<p>Include blocked Assets: " + includeblockeddevices + "   </p>").append("<p>Include blocked Assets: " + includeblockeddevices + "   </p>");
        }
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                List ServerPolicy = reportQueryElement.getPolicyNames().stream().map(policyName -> policyName.replaceAll("-\\d+", "")).collect(Collectors.toList());
                String policyNames = String.join((CharSequence)", ", ServerPolicy);
                htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.POLICY_NAME.getHeaders() + " :" + (String)policyNames + "</p>");
            } else {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.POLICY_NAME.getHeaders() + " :" + policyNames + "</p>");
            }
        }
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.USERNAME.getHeaders() + reportQueryElement.getUserName() + "</p>");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.ASSET_NAME.getHeaders() + " :" + reportQueryElement.getDeviceName() + "</p>");
            }
        } else if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            htmlContent.append("<p>" + BACKUP_OVERVIEW_CONSTANTS.SITE_NAME.getHeaders() + " :" + reportQueryElement.getDeviceName() + "</p>");
        }
        htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + BACKUP_OVERVIEW_CONSTANTS.SL_NO.getHeaders() + "</th>");
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.SITE_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.SITE_STATUS.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.SITE_INSTALLATION_DATE.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.SITE_INSTALLATION_TIME.getHeaders() + "</th>");
        } else {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.USER_ID.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.EMAIL_ID.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.USER_STATUS.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ASSET_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ASSET_STATUS.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ASSET_INSTALLATION_DATE.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ASSET_INSTALLATION_TIME.getHeaders() + "</th>");
        }
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.OS_TYPE.getHeaders() + "</th>");
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()))) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CLIENT_VERSION.getHeaders() + "</th>");
        }
        if (isShowUserConsentFieldInPolicies.booleanValue()) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CONSENT_GIVEN.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CONSENT_GIVEN.getHeaders() + "</th>");
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ONEDRIVE_FOR_BUSINESS_POLICY_NAME.getHeaders() + "</th>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.EXCHANGE_FOR_BUSINESS_POLICY_NAME.getHeaders() + "</th>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.SHAREPOINT_ONLINE_POLICY_NAME.getHeaders() + "</th>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.POLICYNAME.getHeaders() + "</th>");
        }
        if (isODBEnabled) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.BACKUP_TARGET_ASSIGNED.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.REASON.getHeaders() + "</th>");
        }
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_START_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_START_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_END_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FIRST_BACKUP_END_TIME.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_COMPLETED.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_START_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_START_TIME.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_END_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_END_TIME.getHeaders() + "</th>");
        if (showAddReportAttrbs) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_START_DATE.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_START_TIME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_END_DATE.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_BACKUP_END_TIME.getHeaders() + "</th>");
        }
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.IS_LAST_BACKUP_COMPLETED.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_START_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_START_TIME.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_STATUS.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_COMPLETION.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.IS_BACKUP_RUNNING.getHeaders() + "</th>");
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()))) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_HEARD_DATE.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_TIME_HEARD.getHeaders() + "</th>");
        }
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.TOTAL_DATA_BACKED_UP.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.NOTES.getHeaders() + "</th>");
        if (showAdditionalAdAttrbs) {
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.DISPLAY_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LOCATION.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.DEPARTMENT.getHeaders() + "</th>");
            if (BackupOverviewReportGenerator.isAADEnabled(cloud.getCloudCustomisableDetails())) {
                htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.AZURE_ACTIVE_DIRECTORY_USER_STATUS.getHeaders() + "</th>");
            } else {
                htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.ACTIVE_DIRECTORY_USER_STATUS.getHeaders() + "</th>");
            }
        }
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_SIZE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.FULL_BACKUP_NO_OF_FILES.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_SIZE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.LAST_SUCCESSFUL_BACKUP_NO_OF_FILES.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_PROGRESS_SIZE.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_PROGRESS_NO_OF_FILES.getHeaders() + "</th>");
        htmlContent.append("<th>" + BACKUP_OVERVIEW_CONSTANTS.CURRENT_BACKUP_EXPECTED_SIZE.getHeaders() + "</th>");
        htmlContent.append("</tr>");
        int slNoCount = 0;
        for (BackupOverviewElement backupOverviewElement : backupOverviewElementsList) {
            boolean isBackupRunningStatus;
            boolean isBackupRunning;
            String lastBkpStatus;
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slNoCount + "</td>");
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupOverviewElement.getDeviceName() + "</td>");
                isDeviceActive = backupOverviewElement.isDeviceActive();
                deviceActive = BackupOverviewReportGenerator.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                htmlContent.append("<td>" + deviceActive + "</td>");
            } else {
                htmlContent.append("<td>" + backupOverviewElement.getUserId() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getEmailId() + "</td>");
                String userActive1 = this.getUserActiveStatus(backupOverviewElement);
                htmlContent.append("<td>" + userActive1 + "</td>");
                isDeviceActive = backupOverviewElement.isDeviceActive();
                deviceActive = BackupOverviewReportGenerator.getDeviceActiveState(backupOverviewElement, isDeviceActive);
                htmlContent.append("<td>" + backupOverviewElement.getDeviceName() + "</td>");
                htmlContent.append("<td>" + deviceActive + "</td>");
            }
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getTime(backupOverviewElement.getEpaInstallationDate()), DD_MMM_YYYY) + "</td>");
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getTime(backupOverviewElement.getEpaInstallationDate()), DD_MMM_YYYY) + "</td>");
            String osVersionBits = "";
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOsVersion())) {
                osVersionBits = backupOverviewElement.getOsVersion().contains("(") ? "(" + backupOverviewElement.getOsVersion().substring(backupOverviewElement.getOsVersion().indexOf("(") + 1, backupOverviewElement.getOsVersion().indexOf(")")) + ")" : backupOverviewElement.getOsVersion();
            }
            htmlContent.append("<td>" + backupOverviewElement.getOsType() + "</td>");
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()))) {
                htmlContent.append("<td>" + backupOverviewElement.getClientVersion() + "</td>");
            }
            if (isShowUserConsentFieldInPolicies.booleanValue()) {
                if (backupOverviewElement.getOsType().startsWith("Window") || backupOverviewElement.getOsType().startsWith("Mac")) {
                    htmlContent.append("<td>" + backupOverviewElement.getConsentGiven() + "</td>");
                    htmlContent.append("<td>" + backupOverviewElement.getConsentGivenTime() + "</td>");
                } else {
                    htmlContent.append("<td></td>");
                    htmlContent.append("<td></td>");
                }
            }
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupOverviewElement.getOneDrivePolicyName() + "</td>");
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupOverviewElement.getExchangePolicyName() + "</td>");
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupOverviewElement.getSpPolicyName() + "</td>");
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupOverviewElement.getPolicyName() + "</td>");
            }
            if (isODBEnabled) {
                if (backupOverviewElement.isBackupTargetAssigned()) {
                    htmlContent.append("<td>Y</td>");
                } else {
                    htmlContent.append("<td>N</td>");
                }
                if (backupOverviewElement.isBackupTargetAssigned() & backupOverviewElement.getBackupTargetErrorCode() == 0) {
                    htmlContent.append("<td></td>");
                } else {
                    htmlContent.append("<td>" + backupOverviewElement.getBackupTargetErrorCode() + "</td>");
                }
            }
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getFirstBkpStartTime(backupOverviewElement), DD_MMM_YYYY) + "</td>");
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getFirstBkpStartTime(backupOverviewElement), HH_MM_SS) + "</td>");
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime()), DD_MMM_YYYY) + "</td>");
            htmlContent.append("<td>" + this.reportUtil.getDateInFormat(this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime()), HH_MM_SS) + "</td>");
            String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
            String lastSuccessfulBackupEndDate = "";
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)lastSuccessfulBackupEndTime);
            String firstBkpCompleted = this.getFirstBkpCompletedState(isFirstBkpCompleted);
            htmlContent.append("<td>" + firstBkpCompleted + "</td>");
            String lastSuccessBkpStartTime = "";
            String lastSuccessBkpStartDate = "";
            if (isFirstBkpCompleted) {
                long lstBkpEndTime;
                long lstBkpStartTime;
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getFirstBkpStartTime());
                    backupOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getFirstBkpEndTime());
                }
                if ((lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime())) > (lstBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                    lstBkpEndTime = lstBkpStartTime + 0x6DDD00L;
                }
                lastSuccessBkpStartTime = this.reportUtil.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                lastSuccessBkpStartDate = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
                lastSuccessfulBackupEndTime = this.reportUtil.getDateInFormat(lstBkpEndTime, HH_MM_SS);
                lastSuccessfulBackupEndDate = this.reportUtil.getDateInFormat(lstBkpEndTime, DD_MMM_YYYY);
            }
            htmlContent.append("<td>" + lastSuccessBkpStartDate + "</td>");
            htmlContent.append("<td>" + lastSuccessBkpStartTime + "</td>");
            htmlContent.append("<td>" + lastSuccessfulBackupEndDate + "</td>");
            htmlContent.append("<td>" + lastSuccessfulBackupEndTime + "</td>");
            if (showAddReportAttrbs) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpStartTime())) {
                    long lastBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpStartTime());
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastBkpStartTime, DD_MMM_YYYY) + "</td>");
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastBkpStartTime, HH_MM_SS) + "</td>");
                } else {
                    htmlContent.append("<td></td>");
                    htmlContent.append("<td></td>");
                }
                if (!StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                    long lastBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpEndTime());
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastBkpEndTime, DD_MMM_YYYY) + "</td>");
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastBkpEndTime, HH_MM_SS) + "</td>");
                } else {
                    htmlContent.append("<td></td>");
                    htmlContent.append("<td></td>");
                }
            }
            if ((lastBkpStatus = backupOverviewElement.getLastBkpStatus()) == null) {
                lastBkpStatus = "-";
            }
            if (backupOverviewElement.isLastBackupCompleted()) {
                htmlContent.append("<td>Y</td>");
            } else {
                htmlContent.append("<td>N</td>");
            }
            boolean bl = isBackupRunning = StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive;
            if (!StringUtils.isEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus)) {
                String lstBkpStartTimeStr = backupOverviewElement.getLastBkpStartTime();
                String lstBkpStartDateStr = backupOverviewElement.getLastBkpStartTime();
                if (StringUtils.isNotEmpty((String)lstBkpStartTimeStr) && StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    long lstsuccessBkpEndTime;
                    long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastBkpStartTime());
                    if (lstBkpStartTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lstBkpStartTime = lstsuccessBkpEndTime + 0x6DDD00L;
                    }
                    lstBkpStartTimeStr = this.reportUtil.getDateInFormat(lstBkpStartTime, HH_MM_SS);
                    lstBkpStartDateStr = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
                }
                htmlContent.append("<td>" + lstBkpStartDateStr + "</td>");
                htmlContent.append("<td>" + lstBkpStartTimeStr + "</td>");
            } else {
                htmlContent.append("<td></td>");
                htmlContent.append("<td></td>");
            }
            if (lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString())) {
                htmlContent.append("<td></td>");
            } else {
                htmlContent.append("<td>" + lastBkpStatus + "</td>");
            }
            int totalNoOfFiles = 0;
            boolean noOfFilesRemaining = false;
            if (!StringUtils.isEmpty((String)backupOverviewElement.getTotalNoOfFiles())) {
                totalNoOfFiles = Integer.parseInt(backupOverviewElement.getTotalNoOfFiles());
            }
            long percentage = 0L;
            percentage = this.getPercentageCompleted(backupOverviewElement.getTotalNoOfFiles(), backupOverviewElement.getNoOfFilesRemaining());
            if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpStartTime()) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && !lastBkpStatus.equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.COMPLETED.toString()) && !lastBkpStatus.equalsIgnoreCase("SCANNING")) {
                htmlContent.append("<td>" + String.valueOf(percentage) + "%</td>");
            } else {
                htmlContent.append("<td></td>");
            }
            boolean bl2 = isBackupRunningStatus = StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus) && !"PAUSED".equalsIgnoreCase(lastBkpStatus) && !"INTERRUPTED".equalsIgnoreCase(lastBkpStatus) && !"ABORTED".equalsIgnoreCase(lastBkpStatus) && !"EXITED".equalsIgnoreCase(lastBkpStatus) && !"STOPPED".equalsIgnoreCase(lastBkpStatus) && StringUtils.isNotEmpty((String)backupOverviewElement.getNoOfFilesRemaining()) && isDeviceActive && !lastBkpStatus.equalsIgnoreCase("-");
            if (isBackupRunningStatus) {
                htmlContent.append("<td>Y</td>");
            } else {
                htmlContent.append("<td>N</td>");
            }
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()))) {
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    String lastAccessTime = this.reportUtil.getDateInFormat(backupOverviewElement.getLastAccessedTime(), DD_MMM_YYYY_HH_MM_SS);
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        lastHeardDate = lastAccessTime;
                    } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                        lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                        Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                        Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                        lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                    }
                    long lastHeardDateTime = this.reportUtil.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = this.reportUtil.getDateInFormat(lstsuccessBkpEndTime, DD_MMM_YYYY_HH_MM_SS);
                    }
                    long lastHeardTimeStamp = this.reportUtil.getTime(lastHeardDate);
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastHeardTimeStamp, DD_MMM_YYYY) + "</td>");
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastHeardTimeStamp, DD_MMM_YYYY) + "</td>");
                } else {
                    htmlContent.append("<td></td>");
                    htmlContent.append("<td></td>");
                }
            }
            htmlContent.append("<td>" + backupOverviewElement.getStorageUtilized() + "</td>");
            htmlContent.append("<td>" + backupOverviewElement.getReason() + "</td>");
            if (showAdditionalAdAttrbs) {
                htmlContent.append("<td>" + backupOverviewElement.getDisplayName() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getLocation() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getDepartment() + "</td>");
                if (backupOverviewElement.isAccountStatus()) {
                    htmlContent.append("<td>Y</td>");
                } else {
                    htmlContent.append("<td>N</td>");
                }
            }
            if (isFirstBkpCompleted) {
                htmlContent.append("<td>" + backupOverviewElement.getFirstFullBkpTotalSizeOfFiles() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getFirstFullBkpNoOfFiles() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getLastSucessfulBkpTotalSizeOfFiles() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getLastSucessfulBkpNoOfFiles() + "</td>");
            } else {
                htmlContent.append("<td></td>");
                htmlContent.append("<td></td>");
                htmlContent.append("<td></td>");
                htmlContent.append("<td></td>");
            }
            if (StringUtils.isNotEmpty((String)lastBkpStatus)) {
                htmlContent.append("<td>" + backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles() + "</td>");
                htmlContent.append("<td>" + backupOverviewElement.getCurrentlyRunningBkpNoOfFiles() + "</td>");
            } else {
                htmlContent.append("<td></td>");
                htmlContent.append("<td></td>");
            }
            if (StringUtils.isNotEmpty((String)lastBkpStatus) && !PCHelperConstant.BACKUP_STATUS.COMPLETED.toString().equalsIgnoreCase(lastBkpStatus)) {
                htmlContent.append("<td>" + backupOverviewElement.getTotalSizeToUpload() + "</td>");
            } else {
                htmlContent.append("<td></td>");
            }
            htmlContent.append("</tr>");
        }
        htmlContent.append("</table>").append("</body>").append("</html>");
        logger.debug(htmlContent + "htmlContent............");
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(tempFile));
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(htmlContent.toString(), null);
            builder.useDefaultPageSize(1189.0f, 841.0f, BaseRendererBuilder.PageSizeUnits.MM);
            builder.toStream((OutputStream)outputStream);
            builder.run();
            ((OutputStream)outputStream).close();
            logger.debug("PDF created successfully at " + tempFile);
            logger.debug("PDF created successfully.");
            this.pdfReportUtil.addWatermarkToPDF(tempFile, file, cloud.getCloudId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUserActiveStatus(BackupOverviewElement backupOverviewElement) {
        String userActive = backupOverviewElement.isUserActive() ? "Active" : "Blocked";
        return userActive;
    }

    private static String getDeviceActiveState(BackupOverviewElement backupOverviewElement, boolean isDeviceActive) {
        if (!isDeviceActive) {
            String deviceActive = "Blocked";
            return deviceActive;
        }
        String deviceActive = backupOverviewElement.isDecoupled() ? "Decoupled" : (isDeviceActive && !StringUtils.isEmpty((String)backupOverviewElement.getDeviceName()) ? "Active" : (StringUtils.isEmpty((String)backupOverviewElement.getEpaInstallationDate()) ? "" : "Blocked"));
        return deviceActive;
    }

    private static boolean isAADEnabled(List<CloudCustomisableDetails> list) {
        boolean isAADEnabled = false;
        for (CloudCustomisableDetails customisableDetails : list) {
            if (!"AAD Enabled".equals(customisableDetails.getName())) continue;
            isAADEnabled = true;
            break;
        }
        return isAADEnabled;
    }

    private String getCommentsForErrorCode(int errorCode) {
        String comments = "";
        if (errorCode == 0) {
            return "Newly created user";
        }
        if (errorCode == 201) {
            comments = "Site not present in SharePoint";
        }
        if (errorCode == 202) {
            comments = "User OneDrive license invalid";
        }
        if (errorCode == 203) {
            comments = "Insufficient space in OneDrive subscription to use for backup";
        }
        if (errorCode == 404) {
            comments = "User site not found. Make sure the email ID provided is valid";
        }
        if (errorCode == 403) {
            comments = "OneDrive permission denied";
        }
        if (errorCode == 204) {
            comments = "OneDrive target not assigned";
        }
        if (errorCode == 543) {
            comments = "OneDrive target not assigned";
        }
        if (errorCode == 544) {
            comments = "Invalid Mailbox License";
        }
        if (errorCode == 449) {
            comments = "MailBox does not exist for User";
        }
        if (errorCode == 450) {
            comments = "No secondary site admin privilege";
        }
        if (errorCode == 1947) {
            comments = "Storage limit exceeded";
        }
        return comments;
    }

    public long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        if (totalNoOfFiles == 0L && noOfFilesRemaining == 0L) {
            return 100L;
        }
        long percentage = 100L;
        if (totalNoOfFiles != 0L) {
            percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        }
        return percentage;
    }

    private static boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private String getFirstBkpCompletedState(boolean isFirstBkpCompleted) {
        String firstBkpCompleted = isFirstBkpCompleted ? "Y" : "N";
        return firstBkpCompleted;
    }

    private String getTimeZoneShortFormat(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    private static enum BACKUP_OVERVIEW_CONSTANTS {
        SL_NO("Sr. No."),
        SITE_NAME("Site Name"),
        SITE_STATUS("Site Status"),
        SITE_INSTALLATION_DATE("Site Installation Date"),
        SITE_INSTALLATION_TIME("Site Installation Time"),
        USER_ID("User ID"),
        EMAIL_ID("Email ID"),
        USER_STATUS("User Status"),
        ASSET_NAME("Asset Name"),
        ASSET_STATUS("Asset Status"),
        ASSET_INSTALLATION_DATE("Asset Installation Date"),
        ASSET_INSTALLATION_TIME("Asset Installation Time"),
        OS_TYPE("Os Type"),
        CLIENT_VERSION("Client Version"),
        CONSENT_GIVEN("Consent Given"),
        CONSENT_GIVEN_TIME("Consent Given Time"),
        ONEDRIVE_FOR_BUSINESS_POLICY_NAME("OneDrive for Business Policy Name"),
        EXCHANGE_FOR_BUSINESS_POLICY_NAME("Exchange for Business Policy Name"),
        SHAREPOINT_ONLINE_POLICY_NAME("Sharepoint Online Policy Name"),
        POLICY_NAME("Backup Policy Name"),
        BACKUP_TARGET_ASSIGNED("Backup Target Assigned"),
        FIRST_BACKUP_START_DATE("First Backup Start Date"),
        REASON("Reason"),
        FIRST_BACKUP_START_TIME("First Backup Start Time"),
        FIRST_BACKUP_END_DATE("First Backup End Date"),
        FIRST_BACKUP_END_TIME("First Backup End Time"),
        FULL_BACKUP_COMPLETED("Full Backup Completed"),
        LAST_SUCCESSFUL_BACKUP_START_DATE("Last Successful Backup Start Date"),
        LAST_SUCCESSFUL_BACKUP_START_TIME("Last Successful Backup Start Time"),
        LAST_SUCCESSFUL_BACKUP_END_DATE("Last Successful Backup End Date"),
        LAST_SUCCESSFUL_BACKUP_END_TIME("Last Successful Backup End Time"),
        LAST_BACKUP_START_DATE("Last Backup Start Date"),
        LAST_BACKUP_START_TIME("Last Backup Start Time"),
        LAST_BACKUP_END_DATE("Last Backup End Date"),
        LAST_BACKUP_END_TIME("Last Backup End Time"),
        IS_LAST_BACKUP_COMPLETED("Is Last Backup Completed"),
        CURRENT_BACKUP_START_DATE("Current Backup Start Date"),
        CURRENT_BACKUP_START_TIME("Current Backup Start Time"),
        CURRENT_BACKUP_STATUS("Current Backup Status"),
        CURRENT_BACKUP_COMPLETION("Current Backup Completion %"),
        IS_BACKUP_RUNNING("Is Backup Running"),
        LAST_HEARD_DATE("Last Heard Date"),
        LAST_TIME_HEARD("Last Time Heard"),
        TOTAL_DATA_BACKED_UP("Total Data Backed Up"),
        NOTES("Notes"),
        DISPLAY_NAME("Display Name"),
        LOCATION("Location"),
        DEPARTMENT("Department"),
        AZURE_ACTIVE_DIRECTORY_USER_STATUS("Azure Active Directory User Status"),
        ACTIVE_DIRECTORY_USER_STATUS("Active Directory User Status"),
        FULL_BACKUP_SIZE("Full Backup Size"),
        FULL_BACKUP_NO_OF_FILES("Full Backup No. of Files"),
        LAST_SUCCESSFUL_BACKUP_SIZE("Last Successful Backup Size"),
        LAST_SUCCESSFUL_BACKUP_NO_OF_FILES("Last Successful Backup No. of Files"),
        CURRENT_BACKUP_PROGRESS_SIZE("Current Backup Progress - Size"),
        CURRENT_BACKUP_PROGRESS_NO_OF_FILES("Current Backup Progress - No. of files"),
        CURRENT_BACKUP_EXPECTED_SIZE("Current Backup - Expected size"),
        REPORT_GENERATED_ON("Report generated on "),
        POLICYNAME("Policy Name :"),
        SITENAME("Site Name :"),
        USERNAME("User ID : "),
        INCLUDE_BLOCKED_SITES("Include blocked sites: "),
        ASSETNAME("Asset name: "),
        INCLUDE_USERS_WITHOUT_A_ASSET_INSTALLED("Include Users without a asset installed: "),
        INCLUDE_BLOCKED_USERS("Include blocked users: "),
        INCLUDE_BLOCKED_ASSETS("Include blocked assets: ");

        private final String headers;

        private BACKUP_OVERVIEW_CONSTANTS(String headers) {
            this.headers = headers;
        }

        public String getHeaders() {
            return this.headers;
        }
    }
}

