/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.BackupHistoryElement;
import com.parablu.paracloud.element.BackupHistoryResponse;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportGenerator;
import com.parablu.report.util.ExcelReportUtil;
import com.parablu.report.util.PdfReportUtil;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.util.CollectionUtils;

public class AssetsNotProtectedReportGenerator
implements ReportGenerator<BackupHistoryResponse> {
    private static final String BACKUP_NOT_STARTED = "Backup Not Started";
    public static final String BACKUP_NOT_COMPLETED = "Backup Not Completed";
    private static final String MM_DD_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String PDF_EXTENSION = ".pdf";
    private static final String REPORTS_PATH = "/reports/";
    private static Logger logger = LogManager.getLogger();
    private DeviceDao deviceDao;
    private UserDao userDao;
    private ReportUtil reportUtil;
    private ExcelReportUtil excelReportUtil;
    private PdfReportUtil pdfReportUtil;

    public AssetsNotProtectedReportGenerator(DeviceDao deviceDao, UserDao userDao, ReportUtil reportUtil, ExcelReportUtil excelReportUtil, PdfReportUtil pdfReportUtil) {
        this.deviceDao = deviceDao;
        this.userDao = userDao;
        this.reportUtil = reportUtil;
        this.excelReportUtil = excelReportUtil;
        this.pdfReportUtil = pdfReportUtil;
    }

    @Override
    public BackupHistoryResponse generateReport(Cloud cloud, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("process=Inside AssetsNotProtectedReportGenerator, status started");
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        BackupHistoryResponse backupHistoryResponse = new BackupHistoryResponse();
        try {
            String productType = reportQueryElement.getProductType();
            String cloudName = cloud.getCloudName();
            boolean systemNotProtected = reportQueryElement.isSystemBased();
            List<DeviceBackupOverView> overViewList = this.getBkpOverviewForNoBackupReportQuery(cloud, cloudName, reportQueryElement, productType);
            HashSet<String> protectedUserNames = new HashSet<String>();
            logger.debug(reportQueryElement.getNoOfDays() + "...overViewList1..." + overViewList.size() + "...reportQueryElement.." + reportQueryElement.toString());
            for (DeviceBackupOverView deviceBackupOverView : overViewList) {
                if (deviceBackupOverView == null || !deviceBackupOverView.isUserActive() || deviceBackupOverView.isDeviceDeleted() || deviceBackupOverView.isDeviceBolcked()) continue;
                BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
                backupHistoryElement.setDeviceName(deviceBackupOverView.getDeviceName());
                backupHistoryElement.setUserName(deviceBackupOverView.getUserName());
                logger.debug(deviceBackupOverView.getDeviceName() + "........." + deviceBackupOverView.getDeviceType());
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                    backupHistoryElement.setPolicyName(deviceBackupOverView.getOneDrivePolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) {
                    backupHistoryElement.setPolicyName(deviceBackupOverView.getExchangePolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                    backupHistoryElement.setPolicyName(deviceBackupOverView.getSpPolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.BACKUP.toString())) {
                    backupHistoryElement.setPolicyName(deviceBackupOverView.getPolicyName());
                }
                if (deviceBackupOverView.getLastHeardTime() != 0L) {
                    backupHistoryElement.setLastHeardTime(Long.toString(deviceBackupOverView.getLastHeardTime()));
                } else {
                    backupHistoryElement.setLastHeardTime(deviceBackupOverView.getEpaInstallationDate());
                }
                long noOfDaysInMillisecounds = System.currentTimeMillis() - TimeUnit.DAYS.toMillis(reportQueryElement.getNoOfDays());
                if (deviceBackupOverView.getLastSuccessfulBackupEndTime() == 0L) {
                    if (StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpStartTime())) {
                        backupHistoryElement.setEndTime(BACKUP_NOT_STARTED);
                    } else {
                        backupHistoryElement.setEndTime(BACKUP_NOT_COMPLETED);
                    }
                }
                long lastBkpEndTime = 0L;
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpEndTime())) {
                    lastBkpEndTime = this.reportUtil.getConvertedDate(deviceBackupOverView.getLastBkpEndTime());
                    if (lastBkpEndTime == 0L && deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L && lastBkpEndTime < deviceBackupOverView.getLastSuccessfulBackupEndTime()) {
                        lastBkpEndTime = deviceBackupOverView.getLastSuccessfulBackupEndTime();
                    }
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getEpaInstallationDate())) {
                    lastBkpEndTime = Long.parseLong(deviceBackupOverView.getEpaInstallationDate());
                }
                logger.debug(deviceBackupOverView.getLastBkpEndTime() + "--- no backup report--" + deviceBackupOverView.getLastSuccessfulBackupEndTime());
                logger.debug(lastBkpEndTime + "--no backup report---" + noOfDaysInMillisecounds);
                if (lastBkpEndTime != 0L && lastBkpEndTime <= noOfDaysInMillisecounds) {
                    if (!systemNotProtected) {
                        if (!protectedUserNames.contains(backupHistoryElement.getUserName())) {
                            if (lastBkpEndTime == 999L) {
                                backupHistoryElement.setEndTime("" + lastBkpEndTime);
                            } else {
                                backupHistoryElement.setEndTime(this.reportUtil.getDate(lastBkpEndTime));
                            }
                            backupHistoryElements.add(backupHistoryElement);
                        }
                    } else {
                        if (lastBkpEndTime == 999L) {
                            backupHistoryElement.setEndTime("" + lastBkpEndTime);
                        } else {
                            backupHistoryElement.setEndTime(this.reportUtil.getDate(lastBkpEndTime));
                        }
                        backupHistoryElements.add(backupHistoryElement);
                    }
                } else if (!protectedUserNames.contains(backupHistoryElement.getUserName())) {
                    protectedUserNames.add(backupHistoryElement.getUserName());
                    logger.debug(backupHistoryElement.getDeviceName() + "...protected user name:" + backupHistoryElement.getUserName());
                }
                logger.debug(deviceBackupOverView.getUserName() + "...." + deviceBackupOverView.getLastBkpEndTime() + "--- no backup report--" + deviceBackupOverView.getLastSuccessfulBackupEndTime());
                logger.debug(lastBkpEndTime + "--no backup report---" + noOfDaysInMillisecounds + "...noofdays..." + reportQueryElement.getNoOfDays());
            }
            ArrayList<BackupHistoryElement> backupHistoryElementFinalList = new ArrayList<BackupHistoryElement>();
            logger.debug("...final list1.... " + backupHistoryElements.size());
            for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
                if (!systemNotProtected && protectedUserNames.contains(backupHistoryElement.getUserName())) continue;
                String daysDiff = "";
                try {
                    SimpleDateFormat format = new SimpleDateFormat(MM_DD_YYYY_HH_MM_SS);
                    logger.debug(backupHistoryElement.getUserName() + "....insidefor..." + backupHistoryElement.getEndTime());
                    logger.debug("...values not set...." + backupHistoryElement.getEndTime());
                    Date d1 = format.parse(backupHistoryElement.getEndTime());
                    DateTime dt1 = new DateTime((Object)d1);
                    DateTime dt2 = new DateTime();
                    daysDiff = Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays());
                    d1 = format.parse(this.reportUtil.getDate(Long.parseLong(backupHistoryElement.getLastHeardTime())));
                    dt1 = new DateTime((Object)d1);
                    backupHistoryElement.setLastHeardTime(Integer.toString(Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays()));
                }
                catch (Exception e) {
                    logger.debug(backupHistoryElement.getEndTime() + "Exception while Formatting the date " + e);
                }
                if (StringUtils.isEmpty((String)daysDiff)) {
                    backupHistoryElement.setNoOfDaysNotBackedUp(backupHistoryElement.getEndTime());
                } else {
                    backupHistoryElement.setNoOfDaysNotBackedUp(daysDiff);
                }
                if (StringUtils.isEmpty((String)backupHistoryElement.getEndTime()) || "999".equals(backupHistoryElement.getEndTime())) {
                    // empty if block
                }
                logger.debug(backupHistoryElement.getUserName() + "....before adding..." + backupHistoryElement.getNoOfDaysNotBackedUp() + "..heard.." + backupHistoryElement.getLastHeardTime());
                int lastHeardDays = 0;
                lastHeardDays = Integer.parseInt(backupHistoryElement.getLastHeardTime());
                if (reportQueryElement.isIncludeDevicesHeardFrom() && reportQueryElement.getDaysToIncludeDevicesHeardFrom() > lastHeardDays) {
                    backupHistoryElementFinalList.add(backupHistoryElement);
                    continue;
                }
                if (reportQueryElement.isIncludeDevicesHeardFrom()) continue;
                backupHistoryElementFinalList.add(backupHistoryElement);
            }
            backupHistoryResponse.setBackupHistoryElement(backupHistoryElementFinalList);
            if (((Report.Product)Report.ASSETS_NOT_PROTECTED.getProducts().get(reportQueryElement.getProductType())).isView() && ReportQueryElement.ReportOperation.GENERATE_VIEW.toString().equals(reportQueryElement.getOperationType().toString())) {
                logger.debug("generated view as per operationType, status completed");
                return backupHistoryResponse;
            }
            if (((Report.Product)Report.ASSETS_NOT_PROTECTED.getProducts().get(reportQueryElement.getProductType())).isExcel() && ReportQueryElement.ReportOperation.GENERATE_EXCEL.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (backupHistoryElements != null && backupHistoryElements.size() > 0) {
                    this.createExcelForNoBabkup(cloud.getCloudId(), backupHistoryElementFinalList, reportQueryElement, systemNotProtected);
                    logger.debug("Assets not protected excel report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for assets not protected/users with out assets protected ");
                throw new Exception(Integer.toString(403));
            }
            if (((Report.Product)Report.ASSETS_NOT_PROTECTED.getProducts().get(reportQueryElement.getProductType())).isPdf() && ReportQueryElement.ReportOperation.GENERATE_PDF.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (backupHistoryElements != null && backupHistoryElements.size() > 0) {
                    this.createPdfForNoBabkup(cloud.getCloudId(), backupHistoryElementFinalList, reportQueryElement, systemNotProtected);
                    logger.debug("Assets not protected pdf report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for assets not protected/users with out assets protected ");
                throw new Exception(Integer.toString(403));
            }
            throw new Exception("Not a valid operation Type");
        }
        catch (Exception e) {
            logger.error("An exception has occurred during Assets not protected (Systems not protected / Users wothout systems protected)");
            throw e;
        }
    }

    private List<DeviceBackupOverView> getBkpOverviewForNoBackupReportQuery(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType) {
        List<Object> bkpOverViewuserNames;
        User user;
        int cloudId = cloud.getCloudId();
        List<DeviceBackupOverView> overViewList = new ArrayList();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        ArrayList<User> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            user = this.userDao.getUserInfoByName(cloudId, cloudName, reportQueryElement.getUserName());
            users.add(user);
        } else {
            List usersList = this.userDao.getAllUsers(cloudId, cloudName, false);
            users.addAll(usersList);
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug("....productType...." + productType);
            overViewList = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty(overViewList)) {
                    bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null) continue;
                        deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(user2);
                        overViewList.add(deviceOver);
                    }
                } else {
                    List usersList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                        if (userDetails == null) continue;
                        deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(userDetails);
                        overViewList.add(deviceOver);
                    }
                }
            }
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            logger.debug("....productType...." + productType);
            overViewList = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(overViewList)) {
                user = (User)users.get(0);
                DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                if (user != null) {
                    deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(user);
                    overViewList.add(deviceOver);
                }
            }
        } else {
            logger.debug("....productType...." + productType);
            overViewList = this.deviceDao.getAllOverviewsForProductType(cloudId, productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user3 = (User)users.get(i);
                    DeviceBackupOverView deviceOver = new DeviceBackupOverView();
                    if (user3 == null) continue;
                    deviceOver = this.reportUtil.setUserWithoutDeviceElementvalue(user3);
                    overViewList.add(deviceOver);
                }
            }
        }
        logger.debug(reportQueryElement.getSkipValue() + "...before custom page ... " + overViewList.size());
        return overViewList;
    }

    private void createExcelForNoBabkup(int cloudId, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement, boolean systemNotProtected) throws Exception {
        if (!backupHistoryElements.isEmpty()) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for overview ....");
                List<List> recordToAdd = this.updateValuesToExcelForNoBackup(backupHistoryElements, reportQueryElement);
                if (reportQueryElement.isSystemBased()) {
                    this.excelReportUtil.createExcelSheet(recordToAdd, workbook, Report.ASSETS_NOT_PROTECTED.getFileName()[1]);
                    this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.ASSETS_NOT_PROTECTED.getFileName()[1]);
                } else if (!reportQueryElement.isSystemBased()) {
                    this.excelReportUtil.createExcelSheet(recordToAdd, workbook, Report.ASSETS_NOT_PROTECTED.getFileName()[0]);
                    this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.ASSETS_NOT_PROTECTED.getFileName()[0]);
                }
                logger.debug(" After creating excel for overview ....");
            }
        }
    }

    private List<List> updateValuesToExcelForNoBackup(List<BackupHistoryElement> bkpOverViewList, ReportQueryElement reportQueryElement) {
        ArrayList<String> headerRow3;
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        int noOfDaysDiff = 0;
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(ASSETS_NOT_PROTECTED_CONSTANT.USER_ID.getHeaders());
        headerRow.add(ASSETS_NOT_PROTECTED_CONSTANT.ASSET_NAME.getHeaders());
        headerRow.add(ASSETS_NOT_PROTECTED_CONSTANT.POLICY_NAME.getHeaders());
        headerRow.add(ASSETS_NOT_PROTECTED_CONSTANT.LAST_SUCCESSFUL_BACKUP_BEFORE.getHeaders());
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
            headerRow.add(ASSETS_NOT_PROTECTED_CONSTANT.LAST_TIME_HEARD.getHeaders());
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(ASSETS_NOT_PROTECTED_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(ASSETS_NOT_PROTECTED_CONSTANT.POLICYNAME.getHeaders() + policyNames + "   ");
        }
        sb.append(ASSETS_NOT_PROTECTED_CONSTANT.NO_OF_DAYS.getHeaders() + reportQueryElement.getNoOfDays() + "   ");
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
            sb.append(ASSETS_NOT_PROTECTED_CONSTANT.INCLUDE_ASSETS_HEARD_FROM.getHeaders() + this.reportUtil.getBooleanValue(reportQueryElement.isIncludeDevicesHeardFrom()) + "   ");
        }
        if (reportQueryElement.isIncludeDevicesHeardFrom()) {
            sb.append(ASSETS_NOT_PROTECTED_CONSTANT.INCLUDE_ASSETS_HEARD.getHeaders() + reportQueryElement.getDaysToIncludeDevicesHeardFrom());
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        if (reportQueryElement.isSystemBased()) {
            headerRow3 = new ArrayList<String>();
            headerRow3.add(ASSETS_NOT_PROTECTED_CONSTANT.ASSETS_NOT_PROTECTED.getHeaders());
            recordToAdd.add(headerRow3);
        } else if (!reportQueryElement.isSystemBased()) {
            headerRow3 = new ArrayList();
            headerRow3.add(ASSETS_NOT_PROTECTED_CONSTANT.USERS_WITHOUT_ASSETS_PROTECTED.getHeaders());
            recordToAdd.add(headerRow3);
        }
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : bkpOverViewList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getPolicyName());
            logger.debug("...backupHistoryElement.getLastHeardTime().." + backupHistoryElement.getLastHeardTime());
            logger.debug("....noOfDaysDiff..." + noOfDaysDiff + "..backupHistoryElement." + backupHistoryElement.getNoOfDaysNotBackedUp());
            if (!StringUtils.isEmpty((String)backupHistoryElement.getNoOfDaysNotBackedUp())) {
                firstRow.add(backupHistoryElement.getNoOfDaysNotBackedUp() + " days");
            } else {
                firstRow.add("-");
            }
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
                firstRow.add(backupHistoryElement.getLastHeardTime() + " days");
            }
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private void createPdfForNoBabkup(int cloudId, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement, boolean systemNotProtected) throws Exception {
        HashMap pdfColSpanMap = new HashMap();
        String tempFile = null;
        String file = null;
        if (systemNotProtected) {
            tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.ASSETS_NOT_PROTECTED.getFileName()[1] + "temp" + PDF_EXTENSION;
            file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.ASSETS_NOT_PROTECTED.getFileName()[1] + PDF_EXTENSION;
        } else {
            tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.ASSETS_NOT_PROTECTED.getFileName()[0] + "temp" + PDF_EXTENSION;
            file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.ASSETS_NOT_PROTECTED.getFileName()[0] + PDF_EXTENSION;
        }
        StringBuilder htmlContent = new StringBuilder();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>" + ASSETS_NOT_PROTECTED_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            htmlContent.append("<p>" + ASSETS_NOT_PROTECTED_CONSTANT.POLICYNAME.getHeaders() + policyNames + "</p>");
        }
        htmlContent.append("<p>" + ASSETS_NOT_PROTECTED_CONSTANT.NO_OF_DAYS.getHeaders() + reportQueryElement.getNoOfDays() + "</p>");
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<p>" + ASSETS_NOT_PROTECTED_CONSTANT.INCLUDE_ASSETS_HEARD_FROM.getHeaders() + this.reportUtil.getBooleanValue(reportQueryElement.isIncludeDevicesHeardFrom()) + "</p>");
        }
        if (reportQueryElement.isIncludeDevicesHeardFrom()) {
            htmlContent.append("<p>" + ASSETS_NOT_PROTECTED_CONSTANT.INCLUDE_ASSETS_HEARD.getHeaders() + reportQueryElement.getDaysToIncludeDevicesHeardFrom() + "</p>");
        }
        try {
            this.headerOfPdfForAssetsNotProtected(htmlContent, backupHistoryElements, reportQueryElement);
            this.updateAssetsNotProtectedOnPdf(backupHistoryElements, htmlContent, reportQueryElement);
            htmlContent.append("</table>").append("</body>").append("</html>");
            logger.debug(htmlContent + "htmlContent............");
            FileOutputStream outputStream = new FileOutputStream(new File(tempFile));
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(htmlContent.toString(), null);
            builder.useDefaultPageSize(594.0f, 420.0f, BaseRendererBuilder.PageSizeUnits.MM);
            builder.toStream((OutputStream)outputStream);
            builder.run();
            ((OutputStream)outputStream).close();
            logger.debug("PDF created successfully at " + tempFile);
            logger.debug("PDF created successfully.");
            this.pdfReportUtil.addWatermarkToPDF(tempFile, file, cloudId);
        }
        catch (Exception e) {
            logger.debug("Exception while creating the pdf sheet for Assets not protected/ users without assets protected" + e.getMessage());
            logger.debug("Exception while creating the pdf sheet for  Assets not protected/ users without assets protected" + e);
            throw e;
        }
    }

    private void headerOfPdfForAssetsNotProtected(StringBuilder htmlContent, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + ASSETS_NOT_PROTECTED_CONSTANT.SL_NO.getHeaders() + "</th>");
        htmlContent.append("<th>" + ASSETS_NOT_PROTECTED_CONSTANT.USER_ID.getHeaders() + "</th>");
        htmlContent.append("<th>" + ASSETS_NOT_PROTECTED_CONSTANT.ASSET_NAME.getHeaders() + "</th>");
        htmlContent.append("<th>" + ASSETS_NOT_PROTECTED_CONSTANT.POLICY_NAME.getHeaders() + "</th>");
        htmlContent.append("<th>" + ASSETS_NOT_PROTECTED_CONSTANT.LAST_SUCCESSFUL_BACKUP_BEFORE.getHeaders() + "</th>");
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()))) {
            htmlContent.append("<th>" + ASSETS_NOT_PROTECTED_CONSTANT.LAST_TIME_HEARD.getHeaders() + "</th>");
        }
        htmlContent.append("</tr>");
    }

    private void updateAssetsNotProtectedOnPdf(List<BackupHistoryElement> backupHistoryelementList, StringBuilder htmlContent, ReportQueryElement reportQueryElement) throws Exception {
        long slNo = 0L;
        for (BackupHistoryElement backupHistoryelement : backupHistoryelementList) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slNo + "</td>");
            htmlContent.append("<td>" + backupHistoryelement.getUserName() + "</td>");
            htmlContent.append("<td>" + backupHistoryelement.getDeviceName() + "</td>");
            htmlContent.append("<td>" + backupHistoryelement.getPolicyName() + "</td>");
            if (!StringUtils.isEmpty((String)backupHistoryelement.getNoOfDaysNotBackedUp())) {
                htmlContent.append("<td>" + backupHistoryelement.getNoOfDaysNotBackedUp() + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType()))) {
                htmlContent.append("<td>" + backupHistoryelement.getLastHeardTime() + "</td>");
            }
            htmlContent.append("</tr>");
        }
    }

    private static enum ASSETS_NOT_PROTECTED_CONSTANT {
        USER_ID("User ID"),
        ASSET_NAME("Asset Name"),
        ASSET("asset"),
        POLICY_NAME("Backup Policy Name"),
        LAST_SUCCESSFUL_BACKUP_BEFORE("Last successful backup before"),
        LAST_TIME_HEARD("Last Time Heard"),
        ASSETS_NOT_PROTECTED("Assets not protected"),
        REPORT_GENERATED_ON("Report generated on "),
        POLICYNAME("Policy Name :"),
        NO_OF_DAYS("Number of days :"),
        INCLUDE_ASSETS_HEARD_FROM("Include assets heard from : "),
        INCLUDE_ASSETS_HEARD("Include assets heard from days :"),
        USERS_WITHOUT_ASSETS_PROTECTED("Users without any assets protected"),
        SL_NO("Sr. No.");

        private final String headers;

        private ASSETS_NOT_PROTECTED_CONSTANT(String headers) {
            this.headers = headers;
        }

        public String getHeaders() {
            return this.headers;
        }
    }
}

