/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.factory;

import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.BackupHistoryResponse;
import com.parablu.paracloud.element.BackupoverviewResponse;
import com.parablu.paracloud.element.CloudOverviewElement;
import com.parablu.paracloud.element.RestoreHistoyResponse;
import com.parablu.report.service.ReportGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ReportGenerationFactory {
    @Autowired
    private ReportGenerator<CloudOverviewElement> dataProtectionScorecardReportGenerator;
    @Autowired
    private ReportGenerator<BackupoverviewResponse> backupOverviewReportGenerator;
    @Autowired
    @Qualifier(value="backupHistoryReportGenerator")
    private ReportGenerator<BackupHistoryResponse> backupHistoryReportGenerator;
    @Autowired
    @Qualifier(value="assetsNotProtectedReportGenerator")
    private ReportGenerator<BackupHistoryResponse> assetsNotProtectedReportGenerator;
    @Autowired
    private ReportGenerator<RestoreHistoyResponse> restoreHistoryReportGenerator;

    public ReportGenerator<?> getReportGenerator(String reportName) {
        if (Report.DATA_PROTECTION_SCORECARD.toString().equals(reportName)) {
            return this.dataProtectionScorecardReportGenerator;
        }
        if (Report.BACKUP_OVERVIEW.toString().equals(reportName)) {
            return this.backupOverviewReportGenerator;
        }
        if (Report.BACKUP_HISTORY.toString().equals(reportName)) {
            return this.backupHistoryReportGenerator;
        }
        if (Report.ASSETS_NOT_PROTECTED.toString().equals(reportName)) {
            return this.assetsNotProtectedReportGenerator;
        }
        if (Report.RESTORE_HISTORY.toString().equals(reportName)) {
            return this.restoreHistoryReportGenerator;
        }
        return null;
    }
}

