/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.util;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupHistoryElement;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.paracloud.element.DiskSpaceElement;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.User;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ReportUtil {
    private static final String MM_DD_YYYY = "MM/dd/yyyy";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String DD_MM_YYYY = "dd-MMM-yyyy";
    private static final String PARSE_EXCEPTION = " ParseException  :";
    private static final String NUMBER_FORMAT_EXCEPTION = "NumberFormatException  ";
    private static final String EXCEPTION = "Exception :";
    private static Logger logger = LogManager.getLogger();
    private DeviceDao deviceDao;
    private BackupBatchDao backupBatchDao;
    private UserDao userDao;
    private BackupPolicyDao backupPolicyDao;

    public ReportUtil(DeviceDao deviceDao, BackupBatchDao backupBatchDao, UserDao userDao, BackupPolicyDao backupPolicyDao) {
        this.deviceDao = deviceDao;
        this.backupBatchDao = backupBatchDao;
        this.userDao = userDao;
        this.backupPolicyDao = backupPolicyDao;
    }

    public List<BackupHistoryElement> getBackupBatchElements(List<BackupBatch> backupBatchList) {
        ArrayList<BackupHistoryElement> backupHistoryElements = new ArrayList<BackupHistoryElement>();
        for (BackupBatch backupBatch : backupBatchList) {
            if (StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID())) continue;
            boolean officeProduct = false;
            if (backupBatch.getDeviceName().contains("Microsoft Exchange") || backupBatch.getDeviceName().contains("Microsoft OneDrive") || backupBatch.getDeviceName().contains("Microsoft SharePoint") || backupBatch.getDeviceName().contains("Microsoft Exchange")) {
                officeProduct = true;
            }
            BackupHistoryElement backupHistoryElement = this.getBackupBatchHistoryElement(backupBatch);
            backupHistoryElement.setAction(this.getCommentsForBackupBatch(backupBatch.getErrorCode(), officeProduct, backupBatch.getStatus()));
            backupHistoryElements.add(backupHistoryElement);
        }
        logger.debug("last....." + backupHistoryElements.size());
        return backupHistoryElements;
    }

    public BackupHistoryElement getBackupBatchHistoryElement(BackupBatch backupBatch) {
        List<String> diskElementStrings;
        RestoreHistory restoreHistory;
        BackupHistoryElement backupHistoryElement = new BackupHistoryElement();
        backupHistoryElement.setBatchId(backupBatch.getId().toString());
        if (StringUtils.isEmpty((String)backupBatch.getDeviceName())) {
            Device device = this.deviceDao.getDeviceInfoByUUID(1, "", backupBatch.getDeviceUUID());
            if (device != null) {
                backupBatch.setDeviceName(device.getDeviceName());
            }
        } else {
            backupBatch.setDeviceName(backupBatch.getDeviceName());
        }
        backupHistoryElement.setDeviceName(backupBatch.getDeviceName());
        backupHistoryElement.setUserName(backupBatch.getUserName());
        backupHistoryElement.setStartTime(this.getDate(backupBatch.getBatchStartTimestamp()));
        backupHistoryElement.setEndTime(this.getDate(backupBatch.getBatchEndTimestamp()));
        backupHistoryElement.setStartTimeInMillis(backupBatch.getBatchStartTimestamp());
        backupHistoryElement.setEndTimeInMillis(backupBatch.getBatchEndTimestamp());
        backupHistoryElement.setUploadedSize(backupBatch.getUploadedSize());
        backupHistoryElement.setErrorCode(backupBatch.getErrorCode());
        if (!StringUtils.isEmpty((String)backupBatch.getConfiguredBackupFolder())) {
            backupHistoryElement.setConfiguredBackupFolder(backupBatch.getConfiguredBackupFolder().split(";"));
        }
        if (!"BACKUP".equalsIgnoreCase(backupBatch.getJobType()) && (restoreHistory = this.backupBatchDao.getRestoreHistoryById(1, backupBatch.getId())) != null) {
            backupHistoryElement.setRestoredInDiffPath(restoreHistory.isRestoredInDiffPath());
        }
        if (!StringUtils.isEmpty((String)backupBatch.getDiskSpaceDetails()) && !CollectionUtils.isEmpty(diskElementStrings = Arrays.asList(backupBatch.getDiskSpaceDetails().split("\\|")))) {
            ArrayList<DiskSpaceElement> diskSpaceElements = new ArrayList<DiskSpaceElement>();
            for (String diskElementString : diskElementStrings) {
                DiskSpaceElement diskSpaceElement = new DiskSpaceElement();
                List<String> de = Arrays.asList(diskElementString.split(";"));
                if (CollectionUtils.isEmpty(de) || de.size() <= 2) continue;
                diskSpaceElement.setDrive(de.get(0));
                diskSpaceElement.setDiskSpace(de.get(1));
                diskSpaceElement.setUsedSpace(de.get(2));
                diskSpaceElements.add(diskSpaceElement);
            }
            backupHistoryElement.setDiskSpaceDetails(diskSpaceElements);
        }
        String uploadedFiles = backupBatch.getUploadedFiles();
        try {
            String[] parts = uploadedFiles.split("/");
            backupHistoryElement.setTotalNoOfFiles(backupBatch.getTotalNoOfFiles());
            backupHistoryElement.setNoOfFiles((long)Integer.parseInt(parts[1]));
            backupHistoryElement.setUploadedFiles("" + Integer.parseInt(parts[0]));
        }
        catch (Exception e) {
            logger.debug("  Error trying to split no of  files " + e);
        }
        return backupHistoryElement;
    }

    public long getEndOfDay(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.trace(PARSE_EXCEPTION + e);
            logger.error(PARSE_EXCEPTION + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public long getStartOfDay(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public String getCommentsForBackupBatch(String errorCode, boolean officeProduct, String status) {
        logger.debug(".....errorcode...." + errorCode);
        String comments = "";
        if (StringUtils.isEmpty((String)errorCode)) {
            return "";
        }
        if (!officeProduct && "0".equals(errorCode) && "SCANNING".equalsIgnoreCase(status)) {
            return "-";
        }
        if ("0".equals(errorCode)) {
            comments = "Successfully Completed";
        }
        if ("909".equals(errorCode)) {
            comments = !officeProduct ? "Network disconnected or endpoint was shutdown during the backup" : "Network disconnected during the backup";
        }
        if ("911".equals(errorCode)) {
            comments = "User exited the agent manually or the endpoint was shutdown during the backup";
        }
        if ("912".equals(errorCode)) {
            comments = "Machine Utilization exceeded during backup";
        }
        if ("1947".equals(errorCode)) {
            comments = "Storage limit exceeded";
        }
        if ("2304".equals(errorCode)) {
            comments = "Backup temporarily suspended because server is busy.Will be retried later";
        }
        if ("1992".equals(errorCode)) {
            comments = officeProduct ? "Admin paused BackUp manually" : "User paused BackUp manually";
        }
        if ("1981".equals(errorCode)) {
            comments = "User storage limit reached.";
        }
        if ("1996".equals(errorCode)) {
            comments = "Backup Deferred.";
        }
        if ("1210".equals(errorCode)) {
            comments = "Pre backup command failed.";
        }
        if ("1211".equals(errorCode)) {
            comments = "Pre scan command failed.";
        }
        if ("1207".equals(errorCode)) {
            comments = officeProduct ? "Admin stopped BackUp manually" : "User stopped BackUp manually";
        }
        if ("1208".equals(errorCode)) {
            comments = "Admin paused BackUp manually";
        }
        if ("1209".equals(errorCode)) {
            comments = "Admin stopped BackUp manually";
        }
        if ("1310".equals(errorCode)) {
            comments = "Admin stopped queue manually";
        }
        if ("1311".equals(errorCode)) {
            comments = "Admin stopped scanning manually";
        }
        if ("543".equals(errorCode)) {
            comments = "OneDrive target not assigned";
        }
        if ("544".equals(errorCode)) {
            comments = "Invalid Mailbox License";
        }
        if ("913".equals(errorCode)) {
            comments = "User decoupled the agent";
        }
        if ("1212".equals(errorCode)) {
            comments = "Access denied";
        }
        if ("1213".equals(errorCode)) {
            comments = "one or more databases are not set to simple recovery";
        }
        if ("1214".equals(errorCode)) {
            comments = "access denied while connecting database";
        }
        if ("1215".equals(errorCode)) {
            comments = "No Backup is allowed during this time.Please check your policy.";
        }
        if ("1216".equals(errorCode)) {
            comments = "Not connected to the selected Network";
        }
        return comments;
    }

    public String getDate(long dateVal) {
        String date = "";
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
            Date dateD = new Date(dateVal);
            date = df2.format(dateD);
        }
        catch (NumberFormatException e) {
            logger.trace(NUMBER_FORMAT_EXCEPTION + e);
            logger.error(NUMBER_FORMAT_EXCEPTION + e.getMessage());
        }
        return date;
    }

    public Long getConvertedDate(String date) {
        SimpleDateFormat f = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        long milliseconds = 0L;
        try {
            Date d = f.parse(date);
            milliseconds = d.getTime();
        }
        catch (Exception e) {
            logger.error("...unable to parse..... " + e.getMessage());
        }
        return milliseconds;
    }

    public DeviceBackupOverView setUserWithoutDeviceElementvalue(User user) {
        DeviceBackupOverView deviceBkpOverView = new DeviceBackupOverView();
        try {
            if (!StringUtils.isEmpty((String)user.getUserName())) {
                deviceBkpOverView.setUserName(user.getUserName());
            } else {
                deviceBkpOverView.setUserName("");
            }
            if (!StringUtils.isEmpty((String)user.getEmailId())) {
                deviceBkpOverView.setEmailId(user.getEmailId());
            } else {
                deviceBkpOverView.setEmailId("");
            }
            if (!StringUtils.isEmpty((String)user.getPolicyName())) {
                deviceBkpOverView.setPolicyName(user.getPolicyName());
            } else {
                deviceBkpOverView.setPolicyName("");
            }
            if (!StringUtils.isEmpty((String)user.getLocation())) {
                deviceBkpOverView.setLocation(user.getLocation());
            } else {
                deviceBkpOverView.setLocation("");
            }
            if (!StringUtils.isEmpty((String)user.getDepartment())) {
                deviceBkpOverView.setDepartment(user.getDepartment());
            } else {
                deviceBkpOverView.setDepartment("");
            }
            deviceBkpOverView.setAccountStatus(user.isAccountStatus());
            deviceBkpOverView.setUserActive(user.isActive());
            deviceBkpOverView.setUserDeleted(user.isDeleted());
            deviceBkpOverView.setDisplayName(user.getDisplayName());
            deviceBkpOverView.setPolicyUpdatedTime(user.getPolicyModifiedTime());
            deviceBkpOverView.setClientVersion("");
            deviceBkpOverView.setDeviceBolcked(false);
            deviceBkpOverView.setEpaInstallationDate("");
            deviceBkpOverView.setDeviceUUID("");
            deviceBkpOverView.setFirstBkpEndTime("");
            deviceBkpOverView.setTotalNoOfFiles("");
            deviceBkpOverView.setStorageUtilizedInCloud(0L);
            deviceBkpOverView.setId(user.getUserId());
            deviceBkpOverView.setLastBkpEndTime("");
            deviceBkpOverView.setLastSuccessfulBackupStartTime(0L);
            deviceBkpOverView.setLastSuccessfulBackupEndTime(0L);
            deviceBkpOverView.setReason("");
            deviceBkpOverView.setFirstBkpStartTime("");
            deviceBkpOverView.setDeviceName("");
            deviceBkpOverView.setLastBkpStartTime("");
            deviceBkpOverView.setLastBkpStatus("");
            deviceBkpOverView.setNoOfFilesRemaining("");
            deviceBkpOverView.setNoOfSuccessfulBackups(0L);
            deviceBkpOverView.setNoOfSuccessfulRestores(0L);
            deviceBkpOverView.setLastSuccessfulBkp("");
            deviceBkpOverView.setLastHeardTime(0L);
            deviceBkpOverView.setStorageUtilized(0L);
            deviceBkpOverView.setOneDrivePolicyName(user.getOneDrivePolicyName());
            deviceBkpOverView.setExchangePolicyName(user.getExchangePolicyName());
            deviceBkpOverView.setSpPolicyName(user.getSpPolicyName());
            deviceBkpOverView.setDeviceDeleted(false);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return deviceBkpOverView;
    }

    public String formatFileSizeIncludeKB(long size) {
        double k = size;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : (m > 1.0 ? dec.format(m).concat(" MB") : dec.format(k).concat(" KB")));
        return hrSize;
    }

    public String encodeUTFBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("UnsupportedEncodingException", (Throwable)e);
            return input;
        }
    }

    public String getTimeZoneShortFormat(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    public long getFirstBkpStartTime(BackupOverviewElement backupOverviewElement) {
        long firstBkpEndTime;
        long firstBkpStartTime = this.getTime(backupOverviewElement.getFirstBkpStartTime());
        if (StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime()) && firstBkpStartTime > (firstBkpEndTime = this.getTime(backupOverviewElement.getFirstBkpEndTime()))) {
            firstBkpStartTime = firstBkpEndTime - 0x6DDD00L;
        }
        return firstBkpStartTime;
    }

    public String getDateInFormat(Long deviceCreatedDate, String format) {
        String dateStringFormat = "";
        if (deviceCreatedDate == null || deviceCreatedDate == 0L) {
            return dateStringFormat;
        }
        try {
            SimpleDateFormat df2 = new SimpleDateFormat(format);
            Date dateD = new Date(deviceCreatedDate);
            dateStringFormat = df2.format(dateD);
        }
        catch (Exception e) {
            logger.error("Invalid date ={}", (Object)deviceCreatedDate);
            logger.error("Invalid date ={}", (Throwable)e);
        }
        return dateStringFormat;
    }

    public List<DeviceBackupOverView> getBkpOverviewFromReportQuery(Cloud cloud, String cloudName, ReportQueryElement reportQueryElement, String productType) {
        DeviceBackupOverView deviceOver;
        List<Object> bkpOverViewuserNames;
        List usersList;
        int cloudId = cloud.getCloudId();
        List<DeviceBackupOverView> overViewList = new ArrayList();
        boolean isUserWithoutDeviceEnabled = reportQueryElement.isUserWithoutDeviceEnabled();
        List<Object> users = new ArrayList<User>();
        if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            User user2 = this.userDao.getUserInfoByName(cloudId, cloudName, reportQueryElement.getUserName());
            if (!user2.isGuest() && !user2.isSuperAdmin()) {
                users.add(user2);
            }
        } else {
            boolean site = false;
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                site = true;
            }
            usersList = this.userDao.getAllUsers(cloudId, cloudName, site);
            for (User user3 : usersList) {
                if (user3.isGuest() || user3.isSuperAdmin()) continue;
                users.add(user3);
            }
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            users = users.stream().filter(user -> user.getSpPolicyName() != null && !user.getSpPolicyName().isEmpty()).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
            users = users.stream().filter(user -> user.getOneDrivePolicyName() != null && !user.getOneDrivePolicyName().isEmpty()).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
            users = users.stream().filter(user -> user.getExchangePolicyName() != null && !user.getExchangePolicyName().isEmpty()).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
            users = users.stream().filter(user -> user.getPolicyName() != null && !user.getPolicyName().isEmpty() && StringUtils.isEmpty((String)user.getUserType())).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            users = users.stream().filter(user -> user.getPolicyName() != null && !user.getPolicyName().isEmpty() && User.TYPE.SERVER.toString().equals(user.getUserType())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            logger.debug("Considering only policyNames for productType={}", (Object)productType);
            overViewList = this.deviceDao.getDeviceBkpOverviewForPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                if (!CollectionUtils.isEmpty(overViewList)) {
                    bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                    List usersByPolicyName = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (int i = 0; i < usersByPolicyName.size(); ++i) {
                        if (bkpOverViewuserNames.contains(((User)usersByPolicyName.get(i)).getUserName())) continue;
                        deviceOver = new DeviceBackupOverView();
                        User user2 = (User)usersByPolicyName.get(i);
                        if (user2 == null || user2.isGuest() || user2.isSuperAdmin()) continue;
                        deviceOver = this.setUserWithoutDeviceElementvalue(user2);
                        overViewList.add(deviceOver);
                    }
                } else {
                    usersList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                    for (User userDetails : usersList) {
                        DeviceBackupOverView deviceBackupOverView = new DeviceBackupOverView();
                        if (userDetails == null || userDetails.isGuest()) continue;
                        DeviceBackupOverView deviceBackupOverView2 = this.setUserWithoutDeviceElementvalue(userDetails);
                        overViewList.add(deviceBackupOverView2);
                    }
                }
            }
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            logger.debug(".....only username..." + productType);
            overViewList = StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName()) ? this.deviceDao.getDeviceBkpOverviewForUserNameAndDeviceName(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName()) : this.deviceDao.getDeviceBkpOverviewForUserName(cloudId, reportQueryElement.getUserName());
            if (isUserWithoutDeviceEnabled && CollectionUtils.isEmpty(overViewList)) {
                User user3 = (User)users.get(0);
                DeviceBackupOverView deviceOver3 = new DeviceBackupOverView();
                if (user3 != null && !user3.isGuest() && !user3.isSuperAdmin()) {
                    deviceOver3 = this.setUserWithoutDeviceElementvalue(user3);
                    overViewList.add(deviceOver3);
                }
            }
        } else {
            logger.debug("Get all devices for productType={}", (Object)productType);
            overViewList = this.deviceDao.getAllOverviewsForProductType(cloudId, productType);
            if (isUserWithoutDeviceEnabled) {
                bkpOverViewuserNames = new ArrayList();
                bkpOverViewuserNames = overViewList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (int i = 0; i < users.size(); ++i) {
                    if (bkpOverViewuserNames.contains(((User)users.get(i)).getUserName())) continue;
                    User user5 = (User)users.get(i);
                    deviceOver = new DeviceBackupOverView();
                    if (user5 == null || user5.isGuest() || user5.isSuperAdmin()) continue;
                    deviceOver = this.setUserWithoutDeviceElementvalue(user5);
                    overViewList.add(deviceOver);
                }
            }
        }
        ArrayList<DeviceBackupOverView> newOverViewList = new ArrayList<DeviceBackupOverView>();
        for (DeviceBackupOverView bkpOVerview : overViewList) {
            for (User user4 : users) {
                if (user4 == null || !bkpOVerview.getUserName().equalsIgnoreCase(user4.getUserName())) continue;
                if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType) && (user4.isBackupEnabled() || !user4.isActive() || !StringUtils.isEmpty((String)user4.getUserType()))) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && (user4.isSite() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) && (user4.isOnedriveBkpEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType) && (user4.isExchangeBkpEnabled() || !user4.isActive())) {
                    newOverViewList.add(bkpOVerview);
                    continue;
                }
                if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType) || !user4.isBackupEnabled() && user4.isActive() && User.TYPE.SERVER.toString().equals(user4.getUserType())) continue;
                newOverViewList.add(bkpOVerview);
            }
        }
        return newOverViewList;
    }

    public List<BackupOverviewElement> getOverviewElementsForConnDeviceForDPS(int cloudId, String cloudName, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews) {
        if (!CollectionUtils.isEmpty(overViews)) {
            overViews.parallelStream().forEach(deviceBackupOverView -> {
                if (deviceBackupOverView == null || deviceBackupOverView.isDeviceDeleted() || !deviceBackupOverView.isUserActive()) {
                    return;
                }
                BackupOverviewElement element = new BackupOverviewElement();
                BeanUtils.copyProperties((Object)deviceBackupOverView, (Object)element);
                String userName1 = deviceBackupOverView.getUserName();
                String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                String dateStringFormat = this.getDateInFormat(this.getLongValue(deviceCreatedDate), DD_MMM_YYYY_HH_MM_SS);
                element.setUserId(userName1);
                element.setPolicyName(deviceBackupOverView.getPolicyName());
                element.setEpaInstallationDate(dateStringFormat);
                element.setEmailId(deviceBackupOverView.getEmailId());
                String deviceName = deviceBackupOverView.getDeviceName();
                User user = this.userDao.getUserInfoByName(cloudId, deviceBackupOverView.getUserName());
                if (user == null) {
                    return;
                }
                element.setLastSuccessfulBkp(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), DD_MMM_YYYY_HH_MM_SS));
                element.setLastSuccessfulBackupEndTime(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), DD_MMM_YYYY_HH_MM_SS));
                element.setLastSuccessfulBackupStartTime(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupStartTime(), DD_MMM_YYYY_HH_MM_SS));
                element.setFirstBkpStartTime(deviceBackupOverView.getFirstBkpStartTime());
                element.setLastBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) || deviceBackupOverView.getLastSuccessfulBackupEndTime() != 0L;
                element.setDeviceName(deviceName);
                element.setClientVersion(deviceBackupOverView.getClientVersion());
                String storageUtilized = this.formatFileSize(deviceBackupOverView.getStorageUtilized());
                element.setStorageUtilized(storageUtilized);
                element.setUserActive(deviceBackupOverView.isUserActive());
                element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                element.setFirstBackupCompleted(isFirstBkpCompleted);
                if (deviceBackupOverView.getLastHeardTime() != 0L) {
                    element.setLastHeardTime(this.getDateInFormat(deviceBackupOverView.getLastHeardTime(), DD_MMM_YYYY_HH_MM_SS));
                }
                element.setCurrentBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                element.setUserId(deviceBackupOverView.getUserName());
                if (deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles() > 0L) {
                    element.setCurrentlyRunningBkpTotalSizeOfFiles(this.formatFileSizeIncludeKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles()));
                } else {
                    element.setCurrentlyRunningBkpTotalSizeOfFiles("0 MB");
                }
                backupOverviewElementsList.add(element);
            });
        }
        return backupOverviewElementsList;
    }

    public long getTime(String strdate) {
        if (StringUtils.isEmpty((String)strdate)) {
            return 0L;
        }
        long milliseconds = 0L;
        SimpleDateFormat f = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        try {
            Date d = f.parse(strdate);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return milliseconds;
    }

    public List<BackupOverviewElement> getOverviewElementsForExistingUsers(Cloud cloud, List<BackupOverviewElement> backupOverviewElementsList, List<DeviceBackupOverView> overViews, boolean showBlockedUsers, boolean showBlockedDevices, String productType) {
        logger.debug("...showBlockedDevices.." + showBlockedDevices + "...showBlockedUsers..." + showBlockedUsers);
        overViews = this.filterOverviews(overViews, showBlockedUsers, showBlockedDevices);
        boolean odbEnabled = ReportUtil.isODBEnabled(cloud.getCloudCustomisableDetails());
        List allUsers = this.userDao.getAllUsers(cloud.getCloudId());
        boolean officeProduct = false;
        Map userMap = allUsers.stream().collect(Collectors.toMap(User::getUserName, Function.identity(), (u1, u2) -> u1));
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(1);
        List policyWithConsentEnabled = backupPolicies.stream().filter(policy -> policy.isUserConsentEnabled()).map(policyNameM -> policyNameM.getPolicyName()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(overViews)) {
            for (DeviceBackupOverView deviceBackupOverView : overViews) {
                BackupOverviewElement element = new BackupOverviewElement();
                element.setDecoupled(deviceBackupOverView.isDecoupled());
                element.setUserId(deviceBackupOverView.getUserName());
                element.setPolicyName(deviceBackupOverView.getPolicyName());
                element.setAccountStatus(deviceBackupOverView.isAccountStatus());
                element.setLocation(deviceBackupOverView.getLocation());
                element.setDepartment(deviceBackupOverView.getDepartment());
                element.setDisplayName(deviceBackupOverView.getDisplayName());
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpStatus()) && deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("COMPLETED")) {
                    element.setLastBackupCompleted(true);
                } else {
                    element.setLastBackupCompleted(false);
                }
                element.setEmailId(deviceBackupOverView.getEmailId());
                element.setUserActive(deviceBackupOverView.isUserActive());
                element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
                String deviceCreatedDate = deviceBackupOverView.getEpaInstallationDate();
                String dateStringFormat = "";
                if (!StringUtils.isEmpty((String)deviceCreatedDate)) {
                    dateStringFormat = this.getDateInFormat(this.getLongValue(deviceCreatedDate), DD_MMM_YYYY_HH_MM_SS);
                }
                element.setEpaInstallationDate(dateStringFormat);
                String deviceName = deviceBackupOverView.getDeviceName();
                element.setDeviceName(deviceName);
                element.setClientVersion(deviceBackupOverView.getClientVersion());
                User user = (User)userMap.get(deviceBackupOverView.getUserName());
                if (odbEnabled && user != null) {
                    element.setBackupTargetAssigned(user.isBackupTargetAssigned());
                    element.setBackupTargetErrorCode(user.getBackupTargetErrorCode());
                }
                if (user.getPolicyName() != null && policyWithConsentEnabled.contains(user.getPolicyName())) {
                    element.setConsentGiven(user.getConsentGiven());
                    String dateConsentGiven = "";
                    if (user.getConsentGivenTime() != 0L) {
                        dateConsentGiven = this.getDateInFormat(this.getLongValue(String.valueOf(user.getConsentGivenTime())), DD_MMM_YYYY_HH_MM_SS);
                    }
                    element.setConsentGivenTime(dateConsentGiven);
                } else {
                    element.setConsentGiven("");
                    element.setConsentGivenTime("");
                }
                element.setLastSuccessfulBkp(deviceBackupOverView.getLastSuccessfulBkp());
                element.setFirstBkpStartTime(deviceBackupOverView.getFirstBkpStartTime());
                element.setLastBkpStatus(deviceBackupOverView.getLastBkpStatus());
                if (deviceBackupOverView.getDeviceName() == null) {
                    officeProduct = false;
                } else if (deviceBackupOverView.getDeviceName().contains("Microsoft Exchange") || deviceBackupOverView.getDeviceName().contains("Microsoft OneDrive") || deviceBackupOverView.getDeviceName().contains("Microsoft SharePoint")) {
                    officeProduct = true;
                }
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpStatus()) && (deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("STARTED") || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("SCANNING") || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("PRESCAN_COMMAND_EXECUTION"))) {
                    element.setReason("-");
                } else {
                    element.setReason(this.getCommentsForBackupBatch(deviceBackupOverView.getReason(), officeProduct, deviceBackupOverView.getLastBkpStatus()));
                }
                element.setLastBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
                element.setLastBkpEndTime(deviceBackupOverView.getLastBkpEndTime());
                if (StringUtils.isEmpty((String)deviceBackupOverView.getLastBkpEndTime())) {
                    if (deviceBackupOverView.getLastSuccessfulBackupEndTime() > 0L) {
                        element.setLastBkpEndTime(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), DD_MMM_YYYY_HH_MM_SS));
                    } else if (StringUtils.isNotEmpty((String)deviceBackupOverView.getLastBkpStartTime())) {
                        element.setLastBkpEndTime(deviceBackupOverView.getLastBkpStartTime());
                    }
                }
                element.setTotalNoOfFiles(deviceBackupOverView.getTotalNoOfFiles());
                element.setNoOfFilesRemaining(deviceBackupOverView.getNoOfFilesRemaining());
                element.setStorageUtilized(this.formatFileSize(deviceBackupOverView.getStorageUtilized()));
                element.setStorageUtilizedInKB(deviceBackupOverView.getStorageUtilized());
                element.setFirstBkpEndTime(deviceBackupOverView.getFirstBkpEndTime());
                if (deviceBackupOverView.getLastSuccessfulBackupEndTime() > 0L) {
                    element.setLastSuccessfulBackupEndTime(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupEndTime(), DD_MMM_YYYY_HH_MM_SS));
                    element.setLastSuccessfulBackupEndTimeInMillis(deviceBackupOverView.getLastSuccessfulBackupEndTime());
                } else {
                    element.setLastSuccessfulBackupEndTime("");
                }
                if (deviceBackupOverView.getLastSuccessfulBackupStartTime() > 0L) {
                    element.setLastSuccessfulBackupStartTime(this.getDateInFormat(deviceBackupOverView.getLastSuccessfulBackupStartTime(), DD_MMM_YYYY_HH_MM_SS));
                    element.setLastSuccessfulBackupStartTimeInMillis(deviceBackupOverView.getLastSuccessfulBackupStartTime());
                } else {
                    element.setLastSuccessfulBackupStartTime("");
                }
                Long devAccessTime = deviceBackupOverView.getLastHeardTime();
                if (devAccessTime != null && devAccessTime > 0L) {
                    element.setLastAccessedTime(devAccessTime.longValue());
                } else if (StringUtils.isNotEmpty((String)deviceBackupOverView.getEpaInstallationDate())) {
                    element.setLastAccessedTime(Long.parseLong(deviceBackupOverView.getEpaInstallationDate()));
                } else {
                    element.setLastAccessedTime(0L);
                }
                element.setFirstFullBkpNoOfFiles(deviceBackupOverView.getFirstFullBkpNoOfFiles());
                element.setFirstFullBkpTotalSizeOfFiles(this.formatFileSizeIncludeKB(deviceBackupOverView.getFirstFullBkpTotalSizeOfFiles()));
                element.setFirstFullBkpTotalSizeOfFilesInKB(deviceBackupOverView.getFirstFullBkpTotalSizeOfFiles());
                element.setLastSucessfulBkpNoOfFiles(deviceBackupOverView.getLastSucessfulBkpNoOfFiles());
                element.setLastSucessfulBkpTotalSizeOfFiles(this.formatFileSizeIncludeKB(deviceBackupOverView.getLastSucessfulBkpTotalSizeOfFiles()));
                element.setLastSucessfulBkpTotalSizeOfFilesInKB(deviceBackupOverView.getLastSucessfulBkpTotalSizeOfFiles());
                element.setCurrentlyRunningBkpNoOfFiles(deviceBackupOverView.getCurrentlyRunningBkpNoOfFiles());
                element.setCurrentlyRunningBkpTotalSizeOfFiles(this.formatFileSizeIncludeKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles()));
                if (deviceBackupOverView.getTotalSizeToUpload() != 0L && StringUtils.isNotEmpty((String)(deviceBackupOverView.getTotalSizeToUpload() + "")) && !deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("COMPLETED")) {
                    element.setTotalSizeToUpload(this.formatFileSizeIncludeKB(deviceBackupOverView.getTotalSizeToUpload()));
                    element.setTotalSizeToUploadInKB(deviceBackupOverView.getTotalSizeToUpload());
                    element.setCurrentlyRunningBkpTotalSizeOfFilesInKB(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles());
                    element.setTotalCurrentlyRunningBkpSizeInPer(this.setCurrentlyRunningBkpSizeInPercentage(deviceBackupOverView.getCurrentlyRunningBkpTotalSizeOfFiles(), deviceBackupOverView.getTotalSizeToUpload()));
                } else {
                    element.setTotalSizeToUpload("");
                    element.setTotalCurrentlyRunningBkpSizeInPer("");
                }
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString())) {
                    element.setOneDrivePolicyName(user.getOneDrivePolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) {
                    element.setExchangePolicyName(user.getExchangePolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.SHAREPOINT.toString())) {
                    element.setSpPolicyName(user.getSpPolicyName());
                } else if (!StringUtils.isEmpty((String)deviceBackupOverView.getDeviceType()) && deviceBackupOverView.getDeviceType().equals(Device.TYPE.BACKUP.toString())) {
                    element.setPolicyName(user.getPolicyName());
                }
                if (StringUtils.isNotEmpty((String)deviceBackupOverView.getOsType())) {
                    element.setOsType(deviceBackupOverView.getOsType());
                }
                if (StringUtils.isNotEmpty((String)deviceBackupOverView.getOsVersion())) {
                    element.setOsVersion(deviceBackupOverView.getOsVersion());
                }
                backupOverviewElementsList.add(element);
            }
        }
        return backupOverviewElementsList;
    }

    public long getPercentageCompleted(long totalNoOfFiles, long noOfFilesRemaining) {
        if (totalNoOfFiles == 0L && noOfFilesRemaining == 0L) {
            return 100L;
        }
        long percentage = 100L;
        if (totalNoOfFiles != 0L) {
            percentage = noOfFilesRemaining * 100L / totalNoOfFiles;
        }
        if (totalNoOfFiles <= 0L) {
            percentage = 0L;
        }
        if (noOfFilesRemaining <= 0L) {
            percentage = 0L;
        }
        return percentage;
    }

    public <T> List<T> getPage(List<T> sourceList, int page, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = page * pageSize;
        if (sourceList == null || sourceList.size() < fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }

    public long getLongValue(String deviceCreatedDate) {
        if (!StringUtils.isNumeric((String)deviceCreatedDate)) {
            return 0L;
        }
        return Long.parseLong(deviceCreatedDate);
    }

    private String formatFileSize(long size) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            hrSize = dec.format(t).concat(" TB");
        } else if (g > 1.0) {
            hrSize = dec.format(g).concat(" GB");
        } else {
            if (m <= 0.0) {
                m = 0.0;
            }
            hrSize = dec.format(m).concat(" MB");
        }
        return hrSize;
    }

    private List<DeviceBackupOverView> filterOverviews(List<DeviceBackupOverView> overViews, boolean showBlockedUsers, boolean showBlockedDevices) {
        overViews = overViews.stream().filter(line -> line != null && !line.isUserDeleted() && !line.isDeviceDeleted()).collect(Collectors.toList());
        List blockedUsers = overViews.stream().filter(line -> !line.isUserActive()).collect(Collectors.toList());
        List blockedDevices = overViews.stream().filter(line -> line.isDeviceBolcked()).collect(Collectors.toList());
        overViews.removeAll(blockedDevices);
        overViews.removeAll(blockedUsers);
        if (showBlockedDevices) {
            overViews.addAll(blockedDevices);
        }
        if (showBlockedUsers) {
            for (DeviceBackupOverView overView : blockedUsers) {
                if (overViews.contains(overView)) continue;
                overViews.add(overView);
            }
        }
        return overViews;
    }

    private static boolean isODBEnabled(List<CloudCustomisableDetails> licenseDetails) {
        boolean isODBEnabled = false;
        for (CloudCustomisableDetails license : licenseDetails) {
            if (license == null || !"ODB Enabled".equalsIgnoreCase(license.getName())) continue;
            isODBEnabled = true;
            break;
        }
        return isODBEnabled;
    }

    private String setCurrentlyRunningBkpSizeInPercentage(long currentlyRunningBkpTotalSizeOfFiles, long totalSizeOfFiles) {
        String currentlyRunningBkpSizeInPercentage = "";
        DecimalFormat twoDecimalPoint = new DecimalFormat("0.00");
        try {
            currentlyRunningBkpSizeInPercentage = totalSizeOfFiles != 0L ? twoDecimalPoint.format((double)((float)currentlyRunningBkpTotalSizeOfFiles / (float)totalSizeOfFiles) * 100.0) + "%" : "0.00%";
        }
        catch (Exception e) {
            logger.debug("Exception:" + e.getMessage());
        }
        return currentlyRunningBkpSizeInPercentage;
    }

    public String getTimeZoneShortFormatwithoutTime(long milliSeonds) {
        TimeZone toTimeZone = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat(DD_MM_YYYY);
        Date resultdate = new Date(milliSeonds);
        String displayName = toTimeZone.getDisplayName(false, 0);
        return sdf.format(resultdate) + " " + displayName;
    }

    public String getBooleanValue(boolean bool) {
        if (bool) {
            return "Enabled";
        }
        return "Disabled";
    }
}

