/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.util;

import com.parablu.cloud.security.service.LicenseService;
import com.parablu.paracloud.element.CloudPropertyElement;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PdfReportUtil {
    @Autowired
    LicenseService licenseService;

    public PdfReportUtil(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public void setColspanForPdf(Map<String, Integer> pdfColSpanMap, String fieldName, String fieldNameValue) {
        Integer fieldNameColSpan = pdfColSpanMap.get(fieldName);
        if (fieldNameColSpan == null) {
            if (org.springframework.util.StringUtils.isEmpty((Object)fieldNameValue)) {
                fieldNameValue = "";
            }
            fieldNameColSpan = fieldName.length() >= fieldNameValue.length() ? Integer.valueOf(fieldName.length()) : Integer.valueOf(fieldNameValue.length());
        } else {
            if (org.springframework.util.StringUtils.isEmpty((Object)fieldNameValue)) {
                fieldNameValue = "";
            }
            if (fieldNameColSpan < fieldNameValue.length()) {
                fieldNameColSpan = fieldNameValue.length();
            }
        }
        pdfColSpanMap.put(fieldName, fieldNameColSpan);
    }

    public void addWatermarkToPDF(String src, String dest, int cloudId) {
        CloudPropertyElement cloudPropertyElement = this.licenseService.getCloudPropertyElement(cloudId);
        String watermarkText = "Parablu";
        try {
            if (StringUtils.isNotEmpty((String)cloudPropertyElement.getWaterMarkText())) {
                watermarkText = cloudPropertyElement.getWaterMarkText();
            }
            PDDocument document = PDDocument.load((File)new File(src));
            PDPageTree pages = document.getPages();
            for (PDPage page : pages) {
                PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                contentStream.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 30.0f);
                contentStream.setNonStrokingColor(128, 128, 128);
                PDRectangle pageSize = page.getMediaBox();
                float x = pageSize.getWidth() / 2.0f;
                float y = pageSize.getHeight() / 2.0f;
                contentStream.beginText();
                contentStream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(45.0), (float)x, (float)y));
                contentStream.newLineAtOffset(0.0f, 0.0f);
                contentStream.showText(watermarkText);
                contentStream.endText();
                contentStream.close();
            }
            document.save(dest);
            document.close();
            System.out.println("Watermark added successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

