/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.util;

import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.pcbd.domain.ReportQueryElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelReportUtil {
    private static final String EXCEL_EXTENSION = ".xlsx";
    private static final String REPORT_PATH = "/reports/";
    private static final String BKP_OVERVIEW_PATH = "/bkpOverview/";

    public void createExcelSheet(List<List> l1, XSSFWorkbook workbook, String sheetName) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet(sheetName);
        int rownum = 0;
        for (int j = 0; j < l1.size(); ++j) {
            XSSFRow row = firstSheet.createRow(rownum);
            List l2 = l1.get(j);
            for (int k = 0; k < l2.size(); ++k) {
                XSSFFont font;
                XSSFCellStyle cellStyle;
                Cell cell = row.createCell(k);
                cell.setCellValue((String)l2.get(k));
                if (rownum == 0) {
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)22);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)12);
                    font.setBoldweight((short)11);
                    font.setBold(true);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                    firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A1:C1"));
                    CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                }
                if (rownum == 1) {
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)22);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)12);
                    font.setBoldweight((short)11);
                    font.setBold(true);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                    firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A2:C2"));
                    CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                }
                if (rownum == 2) {
                    cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)22);
                    cellStyle.setFillPattern((short)1);
                    font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)12);
                    font.setBoldweight((short)11);
                    font.setBold(true);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                    firstSheet.addMergedRegion(CellRangeAddress.valueOf((String)"A3:C3"));
                    CellUtil.setAlignment((Cell)cell, (Workbook)workbook, (short)2);
                }
                if (rownum != 3) continue;
                cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor((short)51);
                cellStyle.setFillPattern((short)1);
                font = workbook.createFont();
                font.setFontName("Arial");
                font.setFontHeightInPoints((short)10);
                font.setBoldweight((short)10);
                cellStyle.setFont((Font)font);
                cell.setCellStyle((CellStyle)cellStyle);
            }
            ++rownum;
        }
    }

    public void writeExcelForXlsx(XSSFWorkbook workbook, ReportQueryElement reportQueryElement, String fileName) throws Exception {
        fileName = !StringUtils.isEmpty((String)reportQueryElement.getDisplayName()) ? fileName + "_From_Scheduler_" + reportQueryElement.getDisplayName() + EXCEL_EXTENSION : fileName + EXCEL_EXTENSION;
        String filePath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORT_PATH;
        if (fileName.contains(Report.BACKUP_OVERVIEW.getFileName()[0]) || fileName.contains(Report.BACKUP_HISTORY.getFileName()[0]) || fileName.contains(Report.RESTORE_HISTORY.getFileName()[0])) {
            filePath = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + BKP_OVERVIEW_PATH;
        }
        try (FileOutputStream fos = new FileOutputStream(new File(filePath + fileName));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
    }
}

