/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.RestoreHistoryElement;
import com.parablu.paracloud.element.RestoreHistoyResponse;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.RestoreHistory;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportGenerator;
import com.parablu.report.util.ExcelReportUtil;
import com.parablu.report.util.PdfReportUtil;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class RestoreHistoryReportGenerator
implements ReportGenerator<RestoreHistoyResponse> {
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private static final String HH_MM_SS = "HH:mm:ss";
    private static final String REPORTS_PATH = "/reports/";
    private static final String PDF_EXTENSION = ".pdf";
    private static Logger logger = LogManager.getLogger();
    private BackupBatchDao backupBatchDao;
    private UserDao userDao;
    private ReportUtil reportUtil;
    private DeviceDao deviceDao;
    private ExcelReportUtil excelReportUtil;
    private PdfReportUtil pdfReportUtil;

    public RestoreHistoryReportGenerator(BackupBatchDao backupBatchDao, UserDao userDao, ReportUtil reportUtil, DeviceDao deviceDao, ExcelReportUtil excelReportUtil, PdfReportUtil pdfReportUtil) {
        this.backupBatchDao = backupBatchDao;
        this.userDao = userDao;
        this.reportUtil = reportUtil;
        this.deviceDao = deviceDao;
        this.excelReportUtil = excelReportUtil;
        this.pdfReportUtil = pdfReportUtil;
    }

    @Override
    public RestoreHistoyResponse generateReport(Cloud cloud, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("process=Inside RestoreHistoryReportGenerator, status started");
        RestoreHistoyResponse restoreHistoyResponse = new RestoreHistoyResponse();
        ArrayList<RestoreHistoryElement> restoreHistoryElements = new ArrayList<RestoreHistoryElement>();
        ArrayList backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        ArrayList<String> userNameList = new ArrayList<String>();
        try {
            String productType = PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType();
            if (!StringUtils.isEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
                logger.debug(".....getPolicyNames........" + backupBatchList.size());
                List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
                for (User user : userList) {
                    userNameList.add(user.getUserName());
                }
            }
            logger.debug("......all......." + backupBatchList.size());
            backupBatchList.addAll(this.backupBatchDao.getAllBackupBatchForJobTypeWOPagination(cloudId, reportQueryElement.getDeviceName(), "", "RESTORE", "", Long.valueOf(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())), reportQueryElement.getProductType()));
            logger.debug(reportQueryElement.getProductType() + "............." + backupBatchList.size());
            for (BackupBatch backupBatch : backupBatchList) {
                Device dev;
                if (backupBatch == null || StringUtils.isEmpty((String)backupBatch.getUserName()) || StringUtils.isEmpty((String)backupBatch.getDeviceUUID())) continue;
                if ("0/0".equalsIgnoreCase(backupBatch.getUploadedFiles())) {
                    backupBatch.setUploadedFiles("0");
                }
                RestoreHistory restoreHistory = this.backupBatchDao.getRestoreHistoryById(cloudId, backupBatch.getId());
                RestoreHistoryElement restoreHistoryElement = new RestoreHistoryElement();
                if (restoreHistory == null) {
                    dev = this.deviceDao.getDeviceInfoByUUID(cloudId, "", backupBatch.getDeviceUUID());
                    restoreHistoryElement.setRestoreByDeviceName(dev.getDeviceName());
                    restoreHistoryElement.setRestoreByUserName(backupBatch.getUserName());
                    restoreHistoryElement.setRestoreTime(this.reportUtil.getDate(backupBatch.getBatchStartTimestamp()));
                    restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                    restoreHistoryElement.setRestoreEndTime(this.reportUtil.getDate(backupBatch.getBatchEndTimestamp()));
                    restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                    restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
                } else {
                    if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName()) && !reportQueryElement.getUserName().equals(restoreHistory.getUserName()) || userNameList.size() > 0 && !userNameList.contains(restoreHistory.getUserName())) continue;
                    dev = this.deviceDao.getDeviceInfoByUUID(cloudId, "", restoreHistory.getRestoreByDeviceUUID());
                    Device restoreDevice = this.deviceDao.getDeviceByName(cloudId, "", restoreHistory.getDeviceName(), restoreHistory.getUserName(), "");
                    if (restoreDevice != null) {
                        logger.debug("restoreDevice..." + restoreDevice.getDeviceName());
                        restoreHistoryElement.setDeviceName(restoreDevice.getDeviceName());
                    } else {
                        restoreHistoryElement.setDeviceName(restoreHistory.getDeviceName());
                    }
                    restoreHistoryElement.setUserName(restoreHistory.getUserName());
                    restoreHistoryElement.setRestoreByUserName(restoreHistory.getRestoreByUserName());
                    restoreHistoryElement.setRestoreByDeviceName(restoreHistory.getRestoreByDeviceName());
                    restoreHistoryElement.setRestoreTime(this.reportUtil.getDate(restoreHistory.getBatchStartTimestamp()));
                    restoreHistoryElement.setRestoredFiles(backupBatch.getUploadedFiles());
                    restoreHistoryElement.setRestoreEndTime(this.reportUtil.getDate(restoreHistory.getBatchEndTimestamp()));
                    restoreHistoryElement.setRestoredInDiffPath(restoreHistory.isRestoredInDiffPath());
                    if (StringUtils.isNotEmpty((String)restoreHistory.getRestoreFolder())) {
                        restoreHistoryElement.setRestoreFolder(this.reportUtil.encodeUTFBase64(restoreHistory.getRestoreFolder()));
                    }
                    if (StringUtils.isNotEmpty((String)restoreHistory.getDestFolder())) {
                        restoreHistoryElement.setDestFolder(this.reportUtil.encodeUTFBase64(restoreHistory.getDestFolder()));
                    }
                    restoreHistoryElement.setRestoreEndTimeInMillis(backupBatch.getBatchEndTimestamp());
                    restoreHistoryElement.setRestoreTimeInMillis(backupBatch.getBatchStartTimestamp());
                    if (!StringUtils.isEmpty((String)restoreHistory.getRestoredSize())) {
                        restoreHistoryElement.setRestoredSize(this.reportUtil.formatFileSizeIncludeKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L));
                        restoreHistoryElement.setRestoredSizeInKB(Long.parseLong(restoreHistory.getRestoredSize()) / 1024L);
                    }
                }
                restoreHistoryElement.setStatus(this.getCommentsForRestoreHistory(backupBatch.getErrorCode()));
                if (backupBatch.getStatus().equalsIgnoreCase(PCHelperConstant.BACKUP_STATUS.STARTED.toString())) {
                    restoreHistoryElement.setRestoreEndTime("-");
                    restoreHistoryElement.setRestoreEndTimeInMillis(0L);
                    restoreHistoryElement.setRestoredSize("-");
                    restoreHistoryElement.setRestoredFiles("-");
                    restoreHistoryElement.setStatus("Started");
                }
                if (restoreHistoryElement.getRestoreTimeInMillis() == restoreHistoryElement.getRestoreEndTimeInMillis() && !backupBatch.getStatus().equalsIgnoreCase("FAILED")) continue;
                logger.debug("....errorcode for batch history..." + backupBatch.getErrorCode());
                restoreHistoryElements.add(restoreHistoryElement);
            }
            restoreHistoyResponse.setRestoreHistoryElement(restoreHistoryElements);
            if (((Report.Product)Report.RESTORE_HISTORY.getProducts().get(reportQueryElement.getProductType())).isView() && ReportQueryElement.ReportOperation.GENERATE_VIEW.toString().equals(reportQueryElement.getOperationType().toString())) {
                logger.debug("Generated view as per operationType, status=completed");
                return restoreHistoyResponse;
            }
            if (((Report.Product)Report.RESTORE_HISTORY.getProducts().get(reportQueryElement.getProductType())).isExcel() && ReportQueryElement.ReportOperation.GENERATE_EXCEL.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (restoreHistoryElements != null && restoreHistoryElements.size() > 0) {
                    this.createExcelRestoreHistory(restoreHistoryElements, reportQueryElement);
                    logger.debug("BackupOverview excel report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for restore history");
                throw new Exception(Integer.toString(403));
            }
            if (((Report.Product)Report.RESTORE_HISTORY.getProducts().get(reportQueryElement.getProductType())).isPdf() && ReportQueryElement.ReportOperation.GENERATE_PDF.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (restoreHistoryElements != null && restoreHistoryElements.size() > 0) {
                    this.createPdfRestoreHistory(cloud, restoreHistoryElements, reportQueryElement);
                    logger.debug("BackupOverview pdf report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for restore history");
                throw new Exception(Integer.toString(403));
            }
            throw new Exception("Not a valid operation Type");
        }
        catch (Exception e) {
            logger.error("An error occurred during restore history report creation");
            throw e;
        }
    }

    private String getCommentsForRestoreHistory(String errorCode) {
        String comments = "-";
        if (StringUtils.isEmpty((String)errorCode)) {
            return "";
        }
        if ("603".equals(errorCode) || "404".equals(errorCode)) {
            comments = "Failed";
        }
        if ("909".equals(errorCode) || "200".equals(errorCode) || "0".equals(errorCode)) {
            comments = "Completed";
        }
        if ("1207".equals(errorCode) || "429".equals(errorCode)) {
            comments = "cancelled";
        }
        return comments;
    }

    private void createExcelRestoreHistory(List<RestoreHistoryElement> restoreHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        if (!restoreHistoryElements.isEmpty()) {
            logger.debug("inside the Report for RestoreHistory");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelRestoreHistory(restoreHistoryElements, reportQueryElement);
                this.excelReportUtil.createExcelSheet(recordToAdd, workbook, Report.RESTORE_HISTORY.getFileName()[0]);
                this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.RESTORE_HISTORY.getFileName()[0]);
            }
        }
    }

    private List<List> updateValuesToExcelRestoreHistory(List<RestoreHistoryElement> restoreHistoryElements, ReportQueryElement reportQueryElement) {
        String policyNames;
        logger.debug("inside the Report for RestoreHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            headerRow.add(RESTORE_HISTORY_CONSTANT.SOURCE_SITE_PATH.getHeaders());
        } else {
            headerRow.add(RESTORE_HISTORY_CONSTANT.USER_NAME.getHeaders());
            headerRow.add(RESTORE_HISTORY_CONSTANT.ASSET_NAME.getHeaders());
        }
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_BY.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_TO.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_START_DATE.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_START_TIME.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_END_DATE.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORE_END_TIME.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.FILES_RESTORED.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.RESTORED_SIZE.getHeaders());
        headerRow.add(RESTORE_HISTORY_CONSTANT.STATUS.getHeaders());
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(RESTORE_HISTORY_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputSRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(RESTORE_HISTORY_CONSTANT.POLICYNAME.getHeaders() + policyNames + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(RESTORE_HISTORY_CONSTANT.SITENAME.getHeaders() + reportQueryElement.getDeviceName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
                sb.append(RESTORE_HISTORY_CONSTANT.FROMDATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())) + "   " + RESTORE_HISTORY_CONSTANT.TODATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())));
            }
        } else {
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(RESTORE_HISTORY_CONSTANT.POLICYNAME.getHeaders() + policyNames + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                sb.append(RESTORE_HISTORY_CONSTANT.USERNAME.getHeaders() + reportQueryElement.getUserName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                sb.append(RESTORE_HISTORY_CONSTANT.ASSETNAME.getHeaders() + reportQueryElement.getDeviceName() + "   ");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
                sb.append(RESTORE_HISTORY_CONSTANT.FROMDATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())) + "   " + RESTORE_HISTORY_CONSTANT.TODATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())));
            }
        }
        userInputSRow.add(sb.toString());
        recordToAdd.add(userInputSRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add(RESTORE_HISTORY_CONSTANT.RESTORE_HISTORY.getHeaders());
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        for (RestoreHistoryElement restoreHistoryElement : restoreHistoryElements) {
            String folderPath;
            ArrayList<String> firstRow = new ArrayList<String>();
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                if (!StringUtils.isEmpty((String)restoreHistoryElement.getUserName())) {
                    firstRow.add(restoreHistoryElement.getUserName());
                } else {
                    firstRow.add("-");
                }
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getDeviceName())) {
                folderPath = restoreHistoryElement.getDeviceName();
                if (!StringUtils.isEmpty((String)restoreHistoryElement.getRestoreFolder())) {
                    folderPath = folderPath + " - " + new String(Base64.getDecoder().decode(restoreHistoryElement.getRestoreFolder()));
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getRestoreByUserName())) {
                firstRow.add(restoreHistoryElement.getRestoreByUserName());
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getRestoreByDeviceName())) {
                folderPath = restoreHistoryElement.getRestoreByDeviceName();
                if (!StringUtils.isEmpty((String)restoreHistoryElement.getDestFolder())) {
                    folderPath = folderPath + " - " + new String(Base64.getDecoder().decode(restoreHistoryElement.getDestFolder()));
                }
                firstRow.add(folderPath);
            } else {
                firstRow.add("-");
            }
            if (restoreHistoryElement.getRestoreTimeInMillis() != 0L) {
                firstRow.add(this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreTimeInMillis(), DD_MMM_YYYY));
                firstRow.add(this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreTimeInMillis(), HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (restoreHistoryElement.getRestoreEndTimeInMillis() != 0L) {
                firstRow.add(this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreEndTimeInMillis(), DD_MMM_YYYY));
                firstRow.add(this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreEndTimeInMillis(), HH_MM_SS));
            } else {
                firstRow.add("-");
                firstRow.add("-");
            }
            if (!restoreHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                firstRow.add(restoreHistoryElement.getRestoredFiles().contains("/") ? restoreHistoryElement.getRestoredFiles().split("/")[0] : restoreHistoryElement.getRestoredFiles());
            } else {
                firstRow.add("-");
            }
            if (restoreHistoryElement.getRestoredSizeInKB() != 0L && !restoreHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                firstRow.add(this.reportUtil.formatFileSizeIncludeKB(restoreHistoryElement.getRestoredSizeInKB()));
            } else {
                firstRow.add("-");
            }
            String status = restoreHistoryElement.getStatus();
            firstRow.add(status);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private void createPdfRestoreHistory(Cloud cloud, List<RestoreHistoryElement> restoreHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        String tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.RESTORE_HISTORY.getFileName()[0] + "temp" + PDF_EXTENSION;
        String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.RESTORE_HISTORY.getFileName()[0] + PDF_EXTENSION;
        StringBuilder htmlContent = new StringBuilder();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>" + RESTORE_HISTORY_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            htmlContent.append("<p>" + RESTORE_HISTORY_CONSTANT.POLICYNAME.getHeaders() + policyNames + "</p>");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            htmlContent.append("<p>" + RESTORE_HISTORY_CONSTANT.USERNAME.getHeaders() + reportQueryElement.getUserName() + "</p>");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            htmlContent.append("<p>" + RESTORE_HISTORY_CONSTANT.ASSETNAME.getHeaders() + reportQueryElement.getDeviceName() + "</p>");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            htmlContent.append("<p>" + RESTORE_HISTORY_CONSTANT.FROMDATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())) + " " + RESTORE_HISTORY_CONSTANT.TODATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())) + "</p>");
        }
        try {
            this.headerOfPdfForRestoreHistory(htmlContent, restoreHistoryElements, reportQueryElement);
            this.updateRestoreHistoryOnPdf(restoreHistoryElements, htmlContent, reportQueryElement);
            htmlContent.append("</table>").append("</body>").append("</html>");
            logger.debug(htmlContent + "htmlContent............");
            FileOutputStream outputStream = new FileOutputStream(new File(tempFile));
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(htmlContent.toString(), null);
            builder.useDefaultPageSize(700.0f, 841.0f, BaseRendererBuilder.PageSizeUnits.MM);
            builder.toStream((OutputStream)outputStream);
            builder.run();
            ((OutputStream)outputStream).close();
            logger.debug("PDF created successfully at " + tempFile);
            logger.debug("PDF created successfully.");
            this.pdfReportUtil.addWatermarkToPDF(tempFile, file, cloud.getCloudId());
        }
        catch (Exception e) {
            logger.debug("Exception while creating the pdf sheet for restore history" + e.getMessage());
            logger.debug("Exception while creating the pdf sheet for restore history" + e);
            throw e;
        }
    }

    private void headerOfPdfForRestoreHistory(StringBuilder htmlContent, List<RestoreHistoryElement> restoreHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + RESTORE_HISTORY_CONSTANT.SL_NO.getHeaders() + "</th>");
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.SOURCE_SITE_PATH.getHeaders() + "</th>");
        } else {
            htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.USER_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.ASSET_NAME.getHeaders() + "</th>");
        }
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_BY.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_TO.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_START_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_START_TIME.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_END_DATE.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORE_END_TIME.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.FILES_RESTORED.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.RESTORED_SIZE.getHeaders() + "</th>");
        htmlContent.append("<th>" + RESTORE_HISTORY_CONSTANT.STATUS.getHeaders() + "</th>");
        htmlContent.append("</tr>");
    }

    private void updateRestoreHistoryOnPdf(List<RestoreHistoryElement> restoreHistoryElements, StringBuilder htmlContent, ReportQueryElement reportQueryElement) throws Exception {
        long slNo = 0L;
        for (RestoreHistoryElement restoreHistoryElement : restoreHistoryElements) {
            String restoredFiles;
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slNo + "</td>");
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                if (!StringUtils.isEmpty((String)restoreHistoryElement.getUserName())) {
                    htmlContent.append("<td>" + restoreHistoryElement.getUserName() + "</td>");
                } else {
                    htmlContent.append("<td>-</td>");
                }
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getDeviceName())) {
                htmlContent.append("<td>" + restoreHistoryElement.getDeviceName() + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getRestoreByUserName())) {
                htmlContent.append("<td>" + restoreHistoryElement.getRestoreByUserName() + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!StringUtils.isEmpty((String)restoreHistoryElement.getRestoreByDeviceName())) {
                String folderPath = restoreHistoryElement.getRestoreByDeviceName();
                if (!StringUtils.isEmpty((String)restoreHistoryElement.getDestFolder())) {
                    folderPath = folderPath + " - " + new String(Base64.getDecoder().decode(restoreHistoryElement.getDestFolder()));
                }
                htmlContent.append("<td>" + folderPath + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (restoreHistoryElement.getRestoreTimeInMillis() != 0L) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreTimeInMillis(), DD_MMM_YYYY) + "</td>");
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreTimeInMillis(), HH_MM_SS) + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
                htmlContent.append("<td>-</td>");
            }
            if (restoreHistoryElement.getRestoreEndTimeInMillis() != 0L) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreEndTimeInMillis(), DD_MMM_YYYY) + "</td>");
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(restoreHistoryElement.getRestoreEndTimeInMillis(), HH_MM_SS) + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
                htmlContent.append("<td>-</td>");
            }
            String string = restoredFiles = restoreHistoryElement.getRestoredFiles().contains("/") ? restoreHistoryElement.getRestoredFiles().split("/")[0] : restoreHistoryElement.getRestoredFiles();
            if (!restoreHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                htmlContent.append("<td>" + restoredFiles + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (restoreHistoryElement.getRestoredSizeInKB() != 0L && !restoreHistoryElement.getStatus().equalsIgnoreCase("Started")) {
                htmlContent.append("<td>" + this.reportUtil.formatFileSizeIncludeKB(restoreHistoryElement.getRestoredSizeInKB()) + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            String status = restoreHistoryElement.getStatus();
            htmlContent.append("<td>" + status + "</td>");
            htmlContent.append("</tr>");
        }
    }

    private static enum RESTORE_HISTORY_CONSTANT {
        SOURCE_SITE_PATH("Source Site [Path]"),
        USER_NAME("User Name"),
        ASSET_NAME("Asset Name"),
        RESTORE_BY("Restore By"),
        RESTORE_TO("Restore To"),
        RESTORE_START_DATE("Restore Start Date"),
        RESTORE_START_TIME("Restore Start Time"),
        RESTORE_END_DATE("Restore End Date"),
        RESTORE_END_TIME("Restore End Time"),
        FILES_RESTORED("Files Restored"),
        RESTORED_SIZE("Restored Size"),
        STATUS("Status"),
        REPORT_GENERATED_ON("Report generated on "),
        POLICYNAME("Policy Name :"),
        SITENAME("Site Name :"),
        USERNAME("User ID :"),
        ASSETNAME("Asset Name :"),
        FROMDATE("From Date :"),
        TODATE("To Date :"),
        RESTORE_HISTORY("Restore History"),
        SL_NO("SR. No.");

        private final String headers;

        private RESTORE_HISTORY_CONSTANT(String headers) {
            this.headers = headers;
        }

        public String getHeaders() {
            return this.headers;
        }
    }
}

