/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.paracloud.element.CloudOverviewElement;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportGenerator;
import com.parablu.report.util.ExcelReportUtil;
import com.parablu.report.util.PdfReportUtil;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.util.CollectionUtils;

public class DataProtectionScorecardReportGenerator
implements ReportGenerator<CloudOverviewElement> {
    private static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";
    private static final String DD_MMM_YYYY = "dd-MMM-yyyy";
    private static final String REPORT_PATH = "/reports/";
    private static final String PDF_EXTENSION = ".pdf";
    private static Logger logger = LogManager.getLogger();
    private DeviceDao deviceDao;
    private UserDao userDao;
    private ReportUtil reportUtil;
    private ExcelReportUtil excelReportUtil;
    private PdfReportUtil pdfReportUtil;

    public DataProtectionScorecardReportGenerator(DeviceDao deviceDao, UserDao userDao, ReportUtil reportUtil, ExcelReportUtil excelReportUtil, PdfReportUtil pdfReportUtil) {
        this.deviceDao = deviceDao;
        this.userDao = userDao;
        this.reportUtil = reportUtil;
        this.excelReportUtil = excelReportUtil;
        this.pdfReportUtil = pdfReportUtil;
    }

    @Override
    public CloudOverviewElement generateReport(Cloud cloud, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("process=Inside DataProtectionScorecardReportGenerator, status started");
        try {
            long noOfUsersProtectedPercentage;
            String productType = reportQueryElement.getProductType();
            List<BackupOverviewElement> backupOverviewElementsList = Collections.synchronizedList(new ArrayList());
            CloudOverviewElement cloudOverviewElement = new CloudOverviewElement();
            int cloudId = cloud.getCloudId();
            List<Object> deviceOverviews = new ArrayList();
            deviceOverviews = this.reportUtil.getBkpOverviewFromReportQuery(cloud, cloud.getCloudName(), reportQueryElement, productType);
            long totalNoOfActiveBackupUsers = this.userDao.countOfPresentBackupUsersByPolicyByProductType(cloudId, cloud.getCloudName(), true, reportQueryElement.getPolicyNames(), productType);
            List uniqueUserNamesInDevice = new ArrayList();
            uniqueUserNamesInDevice = CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames()) ? this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), productType) : this.deviceDao.getUniqueUserNamesInDeviceByProductType(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            List userNames = uniqueUserNamesInDevice.stream().map(user -> user.toLowerCase()).collect(Collectors.toList());
            logger.debug(".......uniqueUserNamesInDevice......" + uniqueUserNamesInDevice.size());
            List usersInNames = this.userDao.getUsersCountInNames(cloud.getCloudId(), userNames);
            List usersCountInNames = null;
            if (productType == null || productType.equals(PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType())) {
                usersCountInNames = usersInNames.stream().filter(user -> user.isBackupEnabled() && StringUtils.isEmpty((String)user.getUserType())).map(user -> user.getUserName()).collect(Collectors.toList());
            } else if (productType.equals(PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType())) {
                usersCountInNames = usersInNames.stream().filter(user -> user.isBackupEnabled() && User.TYPE.SERVER.toString().equals(user.getUserType())).map(user -> user.getUserName()).collect(Collectors.toList());
            } else if (productType.equals(PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType())) {
                usersCountInNames = usersInNames.stream().filter(user -> user.isOnedriveBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
            } else if (productType.equals(PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType())) {
                usersCountInNames = usersInNames.stream().filter(user -> user.isExchangeBkpEnabled()).map(user -> user.getUserName()).collect(Collectors.toList());
            } else if (productType.equals(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType())) {
                usersCountInNames = usersInNames.stream().filter(user -> user.isSite()).map(user -> user.getUserName()).collect(Collectors.toList());
            }
            long uniqueUserNamesInDeviceCount = usersCountInNames.stream().distinct().count();
            userNames = uniqueUserNamesInDevice.stream().map(user -> user.toLowerCase()).collect(Collectors.toList());
            logger.debug("...before removing blocked device size..." + deviceOverviews.size());
            deviceOverviews = deviceOverviews.stream().filter(overView -> !overView.isDeviceBolcked() && overView.isUserActive()).collect(Collectors.toList());
            logger.debug("...after removing blocked device size..." + deviceOverviews.size());
            backupOverviewElementsList = this.reportUtil.getOverviewElementsForConnDeviceForDPS(cloudId, cloud.getCloudName(), backupOverviewElementsList, deviceOverviews);
            logger.debug("afer getOverviewElementsForConnDevice..." + backupOverviewElementsList.size());
            long usersCountInNotNames = this.userDao.getUsersCountInPolicyNamesByProductType(cloudId, userNames, reportQueryElement.getPolicyNames(), productType);
            logger.debug(backupOverviewElementsList.size() + "...usersCountInNotNames..." + usersCountInNotNames);
            Comparator<BackupOverviewElement> comparator = Comparator.comparing(BackupOverviewElement::getUserId).thenComparing(BackupOverviewElement::getDeviceName);
            backupOverviewElementsList.stream().filter(Objects::nonNull).sorted(comparator);
            AtomicLong noOfUserProtected = new AtomicLong();
            AtomicLong noOfUserHeardCount = new AtomicLong();
            Set usersHeardCountSet = Collections.synchronizedSet(new HashSet());
            Set usersProtectedSet = Collections.synchronizedSet(new HashSet());
            List protectedUsersBackupOverviewElementsList = Collections.synchronizedList(new ArrayList());
            List protectedUsersWithCurrBkpBackupOverviewElementsList = Collections.synchronizedList(new ArrayList());
            HashSet<String> usersSet = new HashSet<String>();
            for (BackupOverviewElement element2 : backupOverviewElementsList) {
                if (usersSet.contains(element2.getUserId())) continue;
                usersSet.add(element2.getUserId());
            }
            long totalOverviews = usersSet.size();
            long noOfUsersOneBackupComplted = this.deviceDao.getCountFullBkpCompletedByProductType(cloud.getCloudId(), reportQueryElement.getPolicyNames(), productType);
            int noOfDaysToQuery = reportQueryElement.getNoOfDays();
            backupOverviewElementsList.parallelStream().forEach(element -> {
                if (!StringUtils.isEmpty((String)element.getDeviceType()) && element.getDeviceType().equalsIgnoreCase(Device.TYPE.ONEDRIVE.toString()) || element.getDeviceType().equalsIgnoreCase(Device.TYPE.SHAREPOINT.toString()) || element.getDeviceType().equalsIgnoreCase(Device.TYPE.OUTLOOK.toString())) {
                    usersHeardCountSet.add(element.getUserId());
                }
                SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                DateTime dt1 = null;
                DateTime dt2 = new DateTime();
                Date yourDate = null;
                if (!StringUtils.isEmpty((String)element.getLastHeardTime())) {
                    try {
                        yourDate = format.parse(element.getLastHeardTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    yourDate.setHours(0);
                    yourDate.setMinutes(0);
                    dt1 = new DateTime((Object)yourDate);
                    dt2 = new DateTime();
                    int daysDifference = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    if (daysDifference < noOfDaysToQuery) {
                        usersHeardCountSet.add(element.getUserId());
                    }
                }
                int lastBkpStartDiff = 999;
                int lastSuccessfulBkpEndDiff = 999;
                int firstBkpEndDiff = 999;
                int lastBkpEndDiff = 999;
                dt2 = new DateTime();
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    String currentBkpStarted = element.getCurrentBkpStartTime();
                    try {
                        yourDate = this.getDateByString(currentBkpStarted);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpStartDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpStartDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastSuccessfulBkp())) {
                    try {
                        yourDate = this.getDateByString(element.getLastSuccessfulBkp());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastSuccessfulBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastSuccessfulBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    try {
                        yourDate = this.getDateByString(element.getLastBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        lastBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                if (!StringUtils.isEmpty((String)element.getFirstBkpEndTime())) {
                    try {
                        yourDate = this.getDateByString(element.getFirstBkpEndTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (yourDate == null) {
                        firstBkpEndDiff = 200;
                    } else {
                        dt1 = new DateTime((Object)yourDate);
                        firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                    }
                }
                boolean queuedScanStatus = false;
                if (!StringUtils.isEmpty((String)element.getLastBkpStatus()) && (PCHelperConstant.BACKUP_STATUS.QUEUED.name().toString().equalsIgnoreCase(element.getLastBkpStatus()) || PCHelperConstant.BACKUP_STATUS.SCANNING.name().toString().equalsIgnoreCase(element.getLastBkpStatus()))) {
                    queuedScanStatus = true;
                }
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStatus()) && (PCHelperConstant.BACKUP_STATUS.QUEUED.name().toString().equalsIgnoreCase(element.getCurrentBkpStatus()) || PCHelperConstant.BACKUP_STATUS.SCANNING.name().toString().equalsIgnoreCase(element.getCurrentBkpStatus()))) {
                    queuedScanStatus = true;
                }
                if (lastSuccessfulBkpEndDiff < noOfDaysToQuery && !queuedScanStatus) {
                    protectedUsersBackupOverviewElementsList.add(element);
                    usersProtectedSet.add(element.getUserId());
                } else if (lastBkpEndDiff < noOfDaysToQuery && lastBkpStartDiff > noOfDaysToQuery && !queuedScanStatus) {
                    usersProtectedSet.add(element.getUserId());
                    protectedUsersWithCurrBkpBackupOverviewElementsList.add(element);
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                } else if (!(lastBkpStartDiff >= noOfDaysToQuery && firstBkpEndDiff >= noOfDaysToQuery || queuedScanStatus)) {
                    usersProtectedSet.add(element.getUserId());
                    protectedUsersBackupOverviewElementsList.add(element);
                    element.setLastSuccessfulBackupStartTime(null);
                    element.setLastSuccessfulBackupEndTime(null);
                }
            });
            logger.debug("noOfUsersProtected......" + protectedUsersWithCurrBkpBackupOverviewElementsList.size() + "...noOfUserHeardCount:" + usersHeardCountSet.size());
            logger.debug(".....noOfUsersProtected......" + usersProtectedSet.size() + "...noOfUserHeardCount:" + usersHeardCountSet.size());
            noOfUserHeardCount.set(usersHeardCountSet.size());
            noOfUserProtected.set(usersProtectedSet.size());
            if (noOfUserProtected.get() <= 0L || noOfUserHeardCount.get() <= 0L) {
                logger.debug("....officeproduct1...." + uniqueUserNamesInDeviceCount);
                noOfUsersProtectedPercentage = 0L;
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(reportQueryElement.getProductType()) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                logger.debug("....officeproduct2...." + uniqueUserNamesInDeviceCount);
                if (uniqueUserNamesInDeviceCount <= 0L) {
                    noOfUsersProtectedPercentage = 0L;
                    logger.debug("....officeproduct3...." + uniqueUserNamesInDeviceCount);
                } else {
                    logger.debug("....officeproduct4...." + uniqueUserNamesInDeviceCount);
                    noOfUsersProtectedPercentage = noOfUserProtected.get() * 100L / uniqueUserNamesInDeviceCount;
                }
            } else {
                logger.debug("....officeproduct5...." + noOfUserHeardCount);
                noOfUsersProtectedPercentage = noOfUserProtected.get() * 100L / noOfUserHeardCount.get();
            }
            logger.debug(noOfUsersProtectedPercentage + "..noofousersprotected...." + noOfUserProtected.get() + "..total.." + totalOverviews);
            if (noOfUsersProtectedPercentage == 0L || noOfUserProtected.get() == 0L) {
                cloudOverviewElement.setNoOfUsersProtected("0(0%)");
            } else {
                cloudOverviewElement.setNoOfUsersProtected(noOfUserProtected.get() + "(" + noOfUsersProtectedPercentage + "%)");
            }
            if (noOfUserHeardCount.get() == 0L || totalOverviews == 0L) {
                cloudOverviewElement.setNoOfUsersHeardCount("0(0%)");
            } else {
                logger.debug("...noOfUsersHeardCount...." + noOfUserHeardCount.get() + "...totalOverviews.." + totalOverviews + "......." + noOfUserHeardCount.get() * 100L / totalOverviews);
                long noOfUsersHeardCountPercentage = noOfUserHeardCount.get() * 100L / totalOverviews;
                logger.debug("...noOfUsersHeardCountPercentage..." + noOfUsersHeardCountPercentage);
                cloudOverviewElement.setNoOfUsersHeardCount(noOfUserHeardCount.get() + "(" + noOfUsersHeardCountPercentage + "%)");
            }
            cloudOverviewElement.setActiveBackupUsers(this.getFormattedValue(totalNoOfActiveBackupUsers));
            cloudOverviewElement.setUserWithOutDevices(this.getFormattedValue(usersCountInNotNames));
            cloudOverviewElement.setUserWithDevices(this.getFormattedValue(uniqueUserNamesInDeviceCount));
            cloudOverviewElement.setUserWithFirstBkpCompleted(this.getFormattedValue(noOfUsersOneBackupComplted));
            cloudOverviewElement.setProtectedUsersBackupOverviewElementsList(protectedUsersBackupOverviewElementsList);
            cloudOverviewElement.setProtectedUsersWithCurrBkpBackupOverviewElementsList(protectedUsersWithCurrBkpBackupOverviewElementsList);
            if (((Report.Product)Report.DATA_PROTECTION_SCORECARD.getProducts().get(reportQueryElement.getProductType())).isView() && ReportQueryElement.ReportOperation.GENERATE_VIEW.toString().equals(reportQueryElement.getOperationType().toString())) {
                logger.debug("generated view as per operationType, status completed");
                return cloudOverviewElement;
            }
            if (((Report.Product)Report.DATA_PROTECTION_SCORECARD.getProducts().get(reportQueryElement.getProductType())).isExcel() && ReportQueryElement.ReportOperation.GENERATE_EXCEL.toString().equals(reportQueryElement.getOperationType().toString())) {
                this.createExcelOfBackupSummary(cloud, cloudOverviewElement, reportQueryElement);
                logger.debug("Data protection scorecard excel report generated successfully");
                return null;
            }
            if (((Report.Product)Report.DATA_PROTECTION_SCORECARD.getProducts().get(reportQueryElement.getProductType())).isPdf() && ReportQueryElement.ReportOperation.GENERATE_PDF.toString().equals(reportQueryElement.getOperationType().toString())) {
                this.createPdfOfBackupSummary(cloud, cloudOverviewElement, reportQueryElement);
                logger.debug("Data protection scorecard pdf report generated successfully");
                return null;
            }
            throw new Exception("Not a valid operation Type");
        }
        catch (Exception e) {
            logger.error("An Exception has occurred while generating a report e={}", (Throwable)e);
            throw e;
        }
    }

    private String getFormattedValue(long totalusers) {
        String formatedTotalUsers = "";
        NumberFormat myFormat = NumberFormat.getInstance();
        myFormat.setGroupingUsed(true);
        formatedTotalUsers = myFormat.format(totalusers);
        return formatedTotalUsers;
    }

    private Date getDateByString(String currentBkpStarted) throws ParseException {
        if (StringUtils.isEmpty((String)currentBkpStarted) || currentBkpStarted.equalsIgnoreCase("-")) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date yourDate = format.parse(currentBkpStarted);
        yourDate.setHours(0);
        yourDate.setMinutes(0);
        return yourDate;
    }

    private void createExcelOfBackupSummary(Cloud cloud, CloudOverviewElement cloudOverviewElement, ReportQueryElement reportQueryElement) throws Exception {
        if (cloudOverviewElement != null) {
            String productType = reportQueryElement.getProductType();
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                logger.debug(" Before creating excel for createExcelOfBackupSummary ...");
                List<List> recordToAdd = this.updateValuesToExcelBackupSummary(cloudOverviewElement, reportQueryElement.getNoOfDays(), productType, reportQueryElement);
                this.excelReportUtil.createExcelSheet(recordToAdd, workbook, "Summary");
                if (reportQueryElement.isIncludeDetails()) {
                    HashSet<String> protectedUsersSet = new HashSet<String>();
                    List<List> recordsToAdd1 = this.updateValuesToExcelForDetailedDPS(cloud, cloudOverviewElement.getProtectedUsersBackupOverviewElementsList(), System.currentTimeMillis(), reportQueryElement, "Backup performance details", protectedUsersSet, productType);
                    this.excelReportUtil.createExcelSheet(recordsToAdd1, workbook, "DetailedView");
                    List<List> recordsToAdd2 = this.updateValuesToExcelForDetailedDPS(cloud, cloudOverviewElement.getProtectedUsersWithCurrBkpBackupOverviewElementsList(), System.currentTimeMillis(), reportQueryElement, "Long running backup details", protectedUsersSet, productType);
                    this.excelReportUtil.createExcelSheet(recordsToAdd2, workbook, "LongRunningBackups");
                }
                this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.DATA_PROTECTION_SCORECARD.getFileName()[0]);
                logger.debug(" After creating excel for createExcelOfBackupSummary ...");
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for Data protection scorecard" + e.getMessage());
                logger.debug("Exception while creating the excel sheet for Data protection scorecard" + e);
                throw e;
            }
        }
    }

    private List<List> updateValuesToExcelBackupSummary(CloudOverviewElement cloudOverviewElement, int noOfDays, String productType, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("inside the Report for updateValuesToExcelBackupSummary ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        headerRow.add(DPS_CONSTANTS.STATISTIC.getHeaders());
        headerRow.add(DPS_CONSTANTS.VALUES.getHeaders());
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(DPS_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                List ServerPolicy = reportQueryElement.getPolicyNames().stream().map(policyName -> policyName.replaceAll("-\\d+", "")).collect(Collectors.toList());
                String policyNames = String.join((CharSequence)", ", ServerPolicy);
                sb.append(DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "   ");
            } else {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "   ");
            }
        }
        sb.append(DPS_CONSTANTS.NO_OF_DAYS.getHeaders() + reportQueryElement.getNoOfDays());
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add(DPS_CONSTANTS.BACKUP_PERFORMANCE_SUMMARY.getHeaders());
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        headerRow = new ArrayList();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add(DPS_CONSTANTS.ACTIVE_SITES.getHeaders());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow.add(DPS_CONSTANTS.ACTIVE_SERVERS.getHeaders());
        } else {
            headerRow.add(DPS_CONSTANTS.ACTIVE_USERS.getHeaders());
        }
        headerRow.add(cloudOverviewElement.getActiveBackupUsers() + "");
        recordToAdd.add(headerRow);
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add(DPS_CONSTANTS.USERS_WITH_ASSET.getHeaders());
            headerRow.add(cloudOverviewElement.getUserWithDevices() + "");
            recordToAdd.add(headerRow);
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add(DPS_CONSTANTS.SERVERS_WITH_AGENT.getHeaders());
            headerRow.add(cloudOverviewElement.getUserWithDevices() + "");
            recordToAdd.add(headerRow);
        }
        headerRow = new ArrayList();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add(DPS_CONSTANTS.FULL_BACKUP_SITES.getHeaders());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow.add(DPS_CONSTANTS.FULL_BACKUP_SERVERS.getHeaders());
        } else {
            headerRow.add(DPS_CONSTANTS.FULL_BACKUP_USERS.getHeaders());
        }
        headerRow.add(cloudOverviewElement.getUserWithFirstBkpCompleted() + "");
        recordToAdd.add(headerRow);
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add(DPS_CONSTANTS.USERS_WITHOUT_ASSET.getHeaders());
            headerRow.add(cloudOverviewElement.getUserWithOutDevices() + "");
            recordToAdd.add(headerRow);
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add(DPS_CONSTANTS.SERVERS_WITHOUT_AGENT.getHeaders());
            headerRow.add(cloudOverviewElement.getUserWithOutDevices() + "");
            recordToAdd.add(headerRow);
        }
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType))) {
            headerRow = new ArrayList();
            headerRow.add("# of users whose assets had a heartbeat to the server in the last " + noOfDays + " days");
            headerRow.add(cloudOverviewElement.getNoOfUsersHeardCount() + "");
            recordToAdd.add(headerRow);
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow = new ArrayList();
            headerRow.add("# of servers whose agents had a heartbeat in the last " + noOfDays + " days");
            headerRow.add(cloudOverviewElement.getNoOfUsersHeardCount() + "");
            recordToAdd.add(headerRow);
        }
        headerRow = new ArrayList();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add("No. of Sites which have been protected in the last " + noOfDays + " days");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            headerRow.add("# of servers which have been protected in the last " + noOfDays + " days");
        } else {
            headerRow.add("# of users whose assets have been protected in the last " + noOfDays + " days");
        }
        headerRow.add(cloudOverviewElement.getNoOfUsersProtected() + "");
        recordToAdd.add(headerRow);
        return recordToAdd;
    }

    private List<List> updateValuesToExcelForDetailedDPS(Cloud cloud, List<BackupOverviewElement> protectedUsersBackupOverviewElementsList, long reportDate, ReportQueryElement reportQueryElement, String header, Set<String> protectedUsersSet, String productType) throws Exception {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            headerRow.add(DPS_CONSTANTS.SITE_NAME.getHeaders());
            headerRow.add("SharePoint Policy Name");
            headerRow.add("First Backup Start Date");
            headerRow.add("First Backup End Date");
            headerRow.add("Most Recent Backup Start Date");
            headerRow.add("Most Recent Backup End Date");
            headerRow.add("Total Data Backed Up");
        } else {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                headerRow.add("Server Name");
            } else {
                headerRow.add("User ID");
                headerRow.add("Asset Name");
            }
            headerRow.add("Policy Name");
            headerRow.add("First Backup Start Date");
            headerRow.add("First Backup End Date");
            headerRow.add("Most Recent Backup Start Date");
            headerRow.add("Most Recent Backup End Date");
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                headerRow.add("Last Heard Date");
            }
            headerRow.add("Total Data Backed Up");
            if (header.equalsIgnoreCase("Long running backup details")) {
                headerRow.add("Most Recent Backup Size");
            }
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        headerRow1.add(DPS_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis()));
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                List ServerPolicy = reportQueryElement.getPolicyNames().stream().map(policyName -> policyName.replaceAll("-\\d+", "")).collect(Collectors.toList());
                String policyNames = String.join((CharSequence)", ", ServerPolicy);
                sb.append(DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "   ");
            } else {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                sb.append(DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "   ");
            }
        }
        sb.append(DPS_CONSTANTS.NO_OF_DAYS.getHeaders() + reportQueryElement.getNoOfDays());
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add(header);
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        for (BackupOverviewElement backupOverviewElement : protectedUsersBackupOverviewElementsList) {
            ArrayList<String> firstRow = new ArrayList<String>();
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                if (protectedUsersSet.contains(backupOverviewElement.getUserId())) {
                    logger.debug("user already added to the excel so skip this device...");
                    continue;
                }
                protectedUsersSet.add(backupOverviewElement.getUserId());
                firstRow.add(backupOverviewElement.getUserId());
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                firstRow.add(backupOverviewElement.getDeviceName());
            } else {
                firstRow.add("-");
            }
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getSpPolicyName())) {
                    firstRow.add(backupOverviewElement.getSpPolicyName());
                } else {
                    firstRow.add("-");
                }
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getOneDrivePolicyName())) {
                    firstRow.add(backupOverviewElement.getOneDrivePolicyName());
                } else {
                    firstRow.add("-");
                }
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getExchangePolicyName())) {
                    firstRow.add(backupOverviewElement.getExchangePolicyName());
                } else {
                    firstRow.add("-");
                }
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getPolicyName())) {
                    firstRow.add(backupOverviewElement.getPolicyName().replaceAll("-\\d+", ""));
                } else {
                    firstRow.add("-");
                }
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                if (!StringUtils.isEmpty((String)backupOverviewElement.getPolicyName())) {
                    firstRow.add(backupOverviewElement.getPolicyName());
                } else {
                    firstRow.add("-");
                }
            }
            long firstBkpStartTime = this.reportUtil.getFirstBkpStartTime(backupOverviewElement);
            if (!StringUtils.isEmpty((String)this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY))) {
                firstRow.add(this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY));
            } else {
                firstRow.add("-");
            }
            long firstbackupEndTime = this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                firstRow.add(this.reportUtil.getDateInFormat(firstbackupEndTime, DD_MMM_YYYY));
            } else {
                firstRow.add("-");
            }
            String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
            String lastSuccessfulBackupEndDate = "";
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime());
            String lastSuccessBkpStartDate = "";
            if (isFirstBkpCompleted) {
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastBkpStartTime());
                    lastSuccessfulBackupEndTime = null;
                }
                long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
                if (StringUtils.isNotEmpty((String)lastSuccessfulBackupEndTime)) {
                    long lstBkpEndTime = this.reportUtil.getTime(lastSuccessfulBackupEndTime);
                    lastSuccessfulBackupEndDate = this.reportUtil.getDateInFormat(lstBkpEndTime, DD_MMM_YYYY);
                }
                lastSuccessBkpStartDate = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
            } else {
                lastSuccessBkpStartDate = null;
                lastSuccessfulBackupEndDate = null;
            }
            if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                firstRow.add(lastSuccessBkpStartDate);
            } else {
                firstRow.add("-");
            }
            if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                firstRow.add(lastSuccessfulBackupEndDate);
            } else {
                firstRow.add("-");
            }
            if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.toString().equalsIgnoreCase(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType))) {
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    Date lastAgentAccessTime;
                    SimpleDateFormat sdf;
                    Date bkpEndTime;
                    String lastAccessTime = this.reportUtil.getDateInFormat(backupOverviewElement.getLastAccessedTime(), DD_MMM_YYYY_HH_MM_SS);
                    lastHeardDate = StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime()) ? lastAccessTime : (backupOverviewElement.getLastAccessedTime() <= 0L ? backupOverviewElement.getLastBkpEndTime() : ((bkpEndTime = (sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS)).parse(backupOverviewElement.getLastBkpEndTime())).compareTo(lastAgentAccessTime = sdf.parse(lastAccessTime)) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime));
                    long lastHeardDateTime = this.reportUtil.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = this.reportUtil.getDateInFormat(lstsuccessBkpEndTime, DD_MMM_YYYY_HH_MM_SS);
                    }
                    long lastHeardTimeStamp = this.reportUtil.getTime(lastHeardDate);
                    firstRow.add(this.reportUtil.getDateInFormat(lastHeardTimeStamp, DD_MMM_YYYY));
                } else {
                    firstRow.add("-");
                }
            }
            firstRow.add(backupOverviewElement.getStorageUtilized());
            if (header.equalsIgnoreCase("Long running backup details")) {
                firstRow.add(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
            }
            recordToAdd.add(firstRow);
        }
        ArrayList<String> emptyRow = new ArrayList<String>();
        emptyRow.add("");
        recordToAdd.add(emptyRow);
        return recordToAdd;
    }

    private void createPdfOfBackupSummary(Cloud cloud, CloudOverviewElement cloudOverviewElement, ReportQueryElement reportQueryElement) throws Exception {
        HashMap pdfColSpanMap = new HashMap();
        String productType = reportQueryElement.getProductType();
        String tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORT_PATH + Report.DATA_PROTECTION_SCORECARD.getFileName()[0] + "temp" + PDF_EXTENSION;
        String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORT_PATH + Report.DATA_PROTECTION_SCORECARD.getFileName()[0] + PDF_EXTENSION;
        StringBuilder htmlContent = new StringBuilder();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(".page-break { page-break-before: always; }").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>" + DPS_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                List ServerPolicy = reportQueryElement.getPolicyNames().stream().map(policyName -> policyName.replaceAll("-\\d+", "")).collect(Collectors.toList());
                String policyNames = String.join((CharSequence)", ", ServerPolicy);
                htmlContent.append("<p>" + DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "</p>");
            } else {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                htmlContent.append("<p>" + DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "</p>");
            }
        }
        htmlContent.append("<p>" + DPS_CONSTANTS.NO_OF_DAYS.getHeaders() + reportQueryElement.getNoOfDays() + "</p>");
        try {
            this.headerOfPdfForDPS(htmlContent);
            this.updateDPSOnPdf(cloudOverviewElement, htmlContent, reportQueryElement.getNoOfDays(), productType);
            htmlContent.append("</table>");
            if (reportQueryElement.isIncludeDetails()) {
                HashSet<String> protectedUsersSet = new HashSet<String>();
                reportQueryElement.setProductType(productType);
                if (cloudOverviewElement.getProtectedUsersBackupOverviewElementsList().size() > 0) {
                    this.CreateDeatiledViewForDPS(cloud, cloudOverviewElement.getProtectedUsersBackupOverviewElementsList(), reportQueryElement, currentDate, htmlContent, "Backup performance details", protectedUsersSet);
                }
                if (cloudOverviewElement.getProtectedUsersWithCurrBkpBackupOverviewElementsList().size() > 0) {
                    this.CreateDeatiledViewForDPS(cloud, cloudOverviewElement.getProtectedUsersWithCurrBkpBackupOverviewElementsList(), reportQueryElement, currentDate, htmlContent, "Long running backup details", protectedUsersSet);
                }
            }
            htmlContent.append("</body>").append("</html>");
            logger.debug(htmlContent + "htmlContent............");
            try {
                FileOutputStream outputStream = new FileOutputStream(new File(tempFile));
                PdfRendererBuilder builder = new PdfRendererBuilder();
                builder.withHtmlContent(htmlContent.toString(), null);
                if (reportQueryElement.isIncludeDetails()) {
                    builder.useDefaultPageSize(700.0f, 1150.0f, BaseRendererBuilder.PageSizeUnits.MM);
                } else {
                    builder.useDefaultPageSize(210.0f, 297.0f, BaseRendererBuilder.PageSizeUnits.MM);
                }
                builder.toStream((OutputStream)outputStream);
                builder.run();
                ((OutputStream)outputStream).close();
                logger.debug("PDF created successfully at " + tempFile);
                logger.debug("PDF created successfully.");
                this.pdfReportUtil.addWatermarkToPDF(tempFile, file, cloud.getCloudId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("Exception while creating the pdf sheet for Data protection scorecard" + e.getMessage());
            logger.debug("Exception while creating the pdf sheet for Data protection scorecard" + e);
            throw e;
        }
    }

    private void headerOfPdfForDPS(StringBuilder htmlContent) throws Exception {
        htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + DPS_CONSTANTS.SL_NO.getHeaders() + "</th>");
        htmlContent.append("<th >" + DPS_CONSTANTS.STATISTIC.getHeaders() + "</th>");
        htmlContent.append("<th >" + DPS_CONSTANTS.VALUES.getHeaders() + "</th>");
        htmlContent.append("</tr>");
    }

    private void updateDPSOnPdf(CloudOverviewElement cloudOverviewElement, StringBuilder htmlContent, int noOfDays, String productType) throws Exception {
        long slno = 0L;
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.ACTIVE_SITES.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getActiveBackupUsers() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.ACTIVE_SERVERS.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getActiveBackupUsers() + "</td>");
            htmlContent.append("</tr>");
        } else {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.ACTIVE_USERS.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getActiveBackupUsers() + "</td>");
            htmlContent.append("</tr>");
        }
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.USERS_WITH_ASSET.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithDevices() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.SERVERS_WITH_AGENT.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithDevices() + "</td>");
            htmlContent.append("</tr>");
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.FULL_BACKUP_SITES.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithFirstBkpCompleted() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.FULL_BACKUP_SERVERS.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithFirstBkpCompleted() + "</td>");
            htmlContent.append("</tr>");
        } else {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.FULL_BACKUP_USERS.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithFirstBkpCompleted() + "</td>");
            htmlContent.append("</tr>");
        }
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.USERS_WITHOUT_ASSET.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithOutDevices() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.SERVERS_WITHOUT_AGENT.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getUserWithOutDevices() + "</td>");
            htmlContent.append("</tr>");
        }
        if (!(PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType) || PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType))) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.USERS_WITH_HEARTBEAT.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getNoOfUsersHeardCount() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.SERVERS_WITH_HEARTBEAT.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getNoOfUsersHeardCount() + "</td>");
            htmlContent.append("</tr>");
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.SITES_PROTECTED_LAST.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getNoOfUsersProtected() + "</td>");
            htmlContent.append("</tr>");
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.SERVERS_PROTECTED_LAST.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getNoOfUsersProtected() + "</td>");
            htmlContent.append("</tr>");
        } else {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slno + "</td>");
            htmlContent.append("<td>" + DPS_CONSTANTS.USERS_ASSETS_PROTECTED_LAST.getHeaders() + "</td>");
            htmlContent.append("<td>" + cloudOverviewElement.getNoOfUsersProtected() + "</td>");
            htmlContent.append("</tr>");
        }
    }

    private void CreateDeatiledViewForDPS(Cloud cloud, List<BackupOverviewElement> backupOverviewElementList, ReportQueryElement reportQueryElement, String currentDate, StringBuilder htmlContent, String heading, Set<String> protectedUsersSet) {
        if (backupOverviewElementList.size() == 0) {
            return;
        }
        HashMap<String, Integer> pdfColSpanMap = new HashMap<String, Integer>();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<div class=\"page-break\"></div>");
            htmlContent.append("<p>" + DPS_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                htmlContent.append("<p>" + DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "</p>");
            }
            htmlContent.append("<p>No. of Days: " + reportQueryElement.getNoOfDays() + "</p>");
            this.getCloudOverviewElementForDPSSharePointPdf(backupOverviewElementList, pdfColSpanMap, heading);
            this.HeaderOfPdfForDetailedViweofDPSSharePoint(htmlContent, heading);
            this.updatePdfForDetailedViweofDPSSharePoint(cloud, backupOverviewElementList, htmlContent, heading, protectedUsersSet);
        } else {
            this.getCloudOverviewElementForDPSPdf(backupOverviewElementList, pdfColSpanMap, heading, reportQueryElement.getProductType());
            htmlContent.append("<div class=\"page-break\"></div>");
            htmlContent.append("<p>" + DPS_CONSTANTS.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
            if (!reportQueryElement.getPolicyNames().isEmpty()) {
                String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
                htmlContent.append("<p>" + DPS_CONSTANTS.POLICY_NAME.getHeaders() + policyNames + "</p>");
            }
            htmlContent.append("<p>No. of Days: " + reportQueryElement.getNoOfDays() + "</p>");
            this.HeaderOfPdfForDetailedViweofDPS(htmlContent, heading, reportQueryElement.getProductType());
            this.updatePdfForDetailedViweofDPS(cloud, backupOverviewElementList, htmlContent, heading, protectedUsersSet, reportQueryElement.getProductType());
        }
    }

    private List<BackupOverviewElement> getCloudOverviewElementForDPSSharePointPdf(List<BackupOverviewElement> backupOverviewElementList, Map<String, Integer> pdfColSpanMap, String heading) {
        ArrayList<BackupOverviewElement> backupOverviewList = new ArrayList<BackupOverviewElement>();
        for (BackupOverviewElement backupOverviewElement : backupOverviewElementList) {
            BackupOverviewElement bkpOverviewElement = new BackupOverviewElement();
            bkpOverviewElement.setDeviceName(backupOverviewElement.getDeviceName());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Site Name", backupOverviewElement.getDeviceName());
            bkpOverviewElement.setPolicyName(backupOverviewElement.getPolicyName());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "SharePoint Policy Name", backupOverviewElement.getPolicyName());
            bkpOverviewElement.setFirstBkpStartTime(backupOverviewElement.getFirstBkpStartTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "First Backup Start Date", backupOverviewElement.getFirstBkpStartTime());
            bkpOverviewElement.setFirstBkpEndTime(backupOverviewElement.getFirstBkpEndTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "First Backup End Date", backupOverviewElement.getFirstBkpEndTime());
            bkpOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup Start Date", backupOverviewElement.getLastSuccessfulBackupStartTime());
            bkpOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getLastSuccessfulBackupEndTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup End Date", backupOverviewElement.getLastSuccessfulBackupEndTime());
            bkpOverviewElement.setStorageUtilized(backupOverviewElement.getStorageUtilized());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Total Data Backed Up", backupOverviewElement.getStorageUtilized());
            if (heading.equalsIgnoreCase("Long running backup details")) {
                this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup Size", backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                bkpOverviewElement.setCurrentlyRunningBkpTotalSizeOfFiles(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
            }
            backupOverviewList.add(bkpOverviewElement);
        }
        return backupOverviewList;
    }

    private void HeaderOfPdfForDetailedViweofDPSSharePoint(StringBuilder htmlContent, String heading) {
        htmlContent.append("<table>").append("<tr>").append("<th>Site Name</th>");
        htmlContent.append("<th>SharePoint Policy Name</th>");
        htmlContent.append("<th>First Backup Start Date</th>");
        htmlContent.append("<th>First Backup End Date</th>");
        htmlContent.append("<th>Most Recent Backup Start Date</th>");
        htmlContent.append("<th>Most Recent Backup End Date</th>");
        htmlContent.append("<th>Total Data Backed Up</th>");
        htmlContent.append("<th>Long running backup details</th>");
        htmlContent.append("<th>Most Recent Backup Size</th>");
        if (heading.equalsIgnoreCase("Long running backup details")) {
            htmlContent.append("<th>Most Recent Backup Size</th>");
        }
        htmlContent.append("</tr>");
    }

    private void updatePdfForDetailedViweofDPSSharePoint(Cloud cloud, List<BackupOverviewElement> backupBatchelementList, StringBuilder htmlContent, String header, Set<String> protectedUsersSet) {
        long slno = 0L;
        for (BackupOverviewElement backupOverviewElement : backupBatchelementList) {
            if (protectedUsersSet.contains(backupOverviewElement.getUserId())) {
                logger.debug("user already added to the excel so skip this device...");
                continue;
            }
            protectedUsersSet.add(backupOverviewElement.getUserId());
            htmlContent.append("<tr>");
            if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                htmlContent.append("<td>" + backupOverviewElement.getDeviceName() + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getSpPolicyName())) {
                htmlContent.append("<td>" + backupOverviewElement.getSpPolicyName() + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            long firstBkpStartTime = this.reportUtil.getFirstBkpStartTime(backupOverviewElement);
            if (!StringUtils.isEmpty((String)this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY))) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY) + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            long firstbackupEndTime = this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(firstbackupEndTime, DD_MMM_YYYY) + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
            String lastSuccessfulBackupEndDate = "";
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime());
            String lastSuccessBkpStartDate = "";
            if (isFirstBkpCompleted) {
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastBkpStartTime());
                    lastSuccessfulBackupEndTime = null;
                }
                long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
                if (StringUtils.isNotEmpty((String)lastSuccessfulBackupEndTime)) {
                    long lstBkpEndTime = this.reportUtil.getTime(lastSuccessfulBackupEndTime);
                    lastSuccessfulBackupEndDate = this.reportUtil.getDateInFormat(lstBkpEndTime, DD_MMM_YYYY);
                }
                lastSuccessBkpStartDate = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
            } else {
                lastSuccessBkpStartDate = null;
                lastSuccessfulBackupEndDate = null;
            }
            if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                htmlContent.append("<td>" + lastSuccessBkpStartDate + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                htmlContent.append("<td>" + lastSuccessfulBackupEndDate + "</td>");
            } else {
                htmlContent.append("<td>_</td>");
            }
            htmlContent.append("<td>" + backupOverviewElement.getStorageUtilized() + "</td>");
            if (header.equalsIgnoreCase("Long running backup details")) {
                htmlContent.append("<td>" + backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles() + "</td>");
            }
            htmlContent.append("</tr>");
        }
        htmlContent.append("</table>");
    }

    private List<BackupOverviewElement> getCloudOverviewElementForDPSPdf(List<BackupOverviewElement> backupOverviewElementList, Map<String, Integer> pdfColSpanMap, String heading, String productType) {
        ArrayList<BackupOverviewElement> backupOverviewList = new ArrayList<BackupOverviewElement>();
        for (BackupOverviewElement backupOverviewElement : backupOverviewElementList) {
            BackupOverviewElement bkpOverviewElement = new BackupOverviewElement();
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                bkpOverviewElement.setUserId(backupOverviewElement.getUserId());
                this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "User Id", backupOverviewElement.getUserId());
            }
            bkpOverviewElement.setDeviceName(backupOverviewElement.getDeviceName());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Asset Name", backupOverviewElement.getDeviceName());
            bkpOverviewElement.setPolicyName(backupOverviewElement.getPolicyName());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Policy Name", backupOverviewElement.getPolicyName());
            bkpOverviewElement.setFirstBkpStartTime(backupOverviewElement.getFirstBkpStartTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "First Backup Start Date", backupOverviewElement.getFirstBkpStartTime());
            bkpOverviewElement.setFirstBkpEndTime(backupOverviewElement.getFirstBkpEndTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "First Backup End Date", backupOverviewElement.getFirstBkpEndTime());
            bkpOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup Start Date", backupOverviewElement.getLastSuccessfulBackupStartTime());
            bkpOverviewElement.setLastSuccessfulBackupEndTime(backupOverviewElement.getLastSuccessfulBackupEndTime());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup End Date", backupOverviewElement.getLastSuccessfulBackupEndTime());
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                bkpOverviewElement.setLastAccessedTime(backupOverviewElement.getLastAccessedTime());
                this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Last Heard Date", backupOverviewElement.getLastAccessedTime() + "");
            }
            bkpOverviewElement.setStorageUtilized(backupOverviewElement.getStorageUtilized());
            this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Total Data Backed Up", backupOverviewElement.getStorageUtilized());
            if (heading.equalsIgnoreCase("Long running backup details")) {
                this.pdfReportUtil.setColspanForPdf(pdfColSpanMap, "Most Recent Backup Size", backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
                bkpOverviewElement.setCurrentlyRunningBkpTotalSizeOfFiles(backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles());
            }
            backupOverviewList.add(bkpOverviewElement);
        }
        return backupOverviewList;
    }

    private void HeaderOfPdfForDetailedViweofDPS(StringBuilder htmlContent, String heading, String productType) {
        htmlContent.append("<table>").append("<tr>");
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            htmlContent.append("<th>User Id</th>");
        }
        htmlContent.append("<th>Asset Name</th>");
        htmlContent.append("<th>Policy Name</th>");
        htmlContent.append("<th>First Backup Start Date</th>");
        htmlContent.append("<th>First Backup End Date</th>");
        htmlContent.append("<th>Most Recent Backup Start Date</th>");
        htmlContent.append("<th>Most Recent Backup End Date</th>");
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
            htmlContent.append("<th>Last Heard Date</th>");
        }
        htmlContent.append("<th>Asset Name</th>");
        if (heading.equalsIgnoreCase("Long running backup details")) {
            htmlContent.append("<th>Most Recent Backup Size</th>");
        }
        htmlContent.append("</tr>");
    }

    private void updatePdfForDetailedViweofDPS(Cloud cloud, List<BackupOverviewElement> backupBatchelementList, StringBuilder htmlContent, String header, Set<String> protectedUsersSet, String productType) {
        long slno = 0L;
        for (BackupOverviewElement backupOverviewElement : backupBatchelementList) {
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                if (protectedUsersSet.contains(backupOverviewElement.getUserId())) {
                    logger.debug("user already added to the excel so skip this device...");
                    continue;
                }
                protectedUsersSet.add(backupOverviewElement.getUserId());
                htmlContent.append("<tr>");
                htmlContent.append("<td>" + backupOverviewElement.getUserId() + "</td>");
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getDeviceName())) {
                htmlContent.append("<td>" + backupOverviewElement.getDeviceName() + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!StringUtils.isEmpty((String)backupOverviewElement.getOneDrivePolicyName())) {
                htmlContent.append("<td>" + backupOverviewElement.getOneDrivePolicyName() + "</td>");
            } else if (!StringUtils.isEmpty((String)backupOverviewElement.getPolicyName())) {
                htmlContent.append("<td>" + backupOverviewElement.getPolicyName() + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            long firstBkpStartTime = this.reportUtil.getFirstBkpStartTime(backupOverviewElement);
            if (!StringUtils.isEmpty((String)this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY))) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(firstBkpStartTime, DD_MMM_YYYY) + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            long firstbackupEndTime = this.reportUtil.getTime(backupOverviewElement.getFirstBkpEndTime());
            if (!StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                htmlContent.append("<td>" + this.reportUtil.getDateInFormat(firstbackupEndTime, DD_MMM_YYYY) + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            String lastSuccessfulBackupEndTime = backupOverviewElement.getLastSuccessfulBackupEndTime();
            String lastSuccessfulBackupEndDate = "";
            boolean isFirstBkpCompleted = !StringUtils.isEmpty((String)backupOverviewElement.getFirstBkpEndTime());
            String lastSuccessBkpStartDate = "";
            if (isFirstBkpCompleted) {
                if (StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupStartTime()) || StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime())) {
                    backupOverviewElement.setLastSuccessfulBackupStartTime(backupOverviewElement.getLastBkpStartTime());
                    lastSuccessfulBackupEndTime = null;
                }
                long lstBkpStartTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupStartTime());
                if (StringUtils.isNotEmpty((String)lastSuccessfulBackupEndTime)) {
                    long lstBkpEndTime = this.reportUtil.getTime(lastSuccessfulBackupEndTime);
                    lastSuccessfulBackupEndDate = this.reportUtil.getDateInFormat(lstBkpEndTime, DD_MMM_YYYY);
                }
                lastSuccessBkpStartDate = this.reportUtil.getDateInFormat(lstBkpStartTime, DD_MMM_YYYY);
            } else {
                lastSuccessBkpStartDate = null;
                lastSuccessfulBackupEndDate = null;
            }
            if (!StringUtils.isEmpty((String)lastSuccessBkpStartDate)) {
                htmlContent.append("<td>" + lastSuccessBkpStartDate + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!StringUtils.isEmpty((String)lastSuccessfulBackupEndDate)) {
                htmlContent.append("<td>" + lastSuccessfulBackupEndDate + "</td>");
            } else {
                htmlContent.append("<td>-</td>");
            }
            if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType) && !PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                String lastHeardDate = "";
                if (backupOverviewElement.getLastAccessedTime() > 0L || StringUtils.isNotEmpty((String)backupOverviewElement.getLastBkpEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) || StringUtils.isNotEmpty((String)backupOverviewElement.getFirstBkpEndTime())) {
                    long lstsuccessBkpEndTime;
                    String lastAccessTime = this.reportUtil.getDateInFormat(backupOverviewElement.getLastAccessedTime(), DD_MMM_YYYY_HH_MM_SS);
                    if (StringUtils.isEmpty((String)backupOverviewElement.getLastBkpEndTime())) {
                        lastHeardDate = lastAccessTime;
                    } else if (backupOverviewElement.getLastAccessedTime() <= 0L) {
                        lastHeardDate = backupOverviewElement.getLastBkpEndTime();
                    } else {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                            Date bkpEndTime = sdf.parse(backupOverviewElement.getLastBkpEndTime());
                            Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                            lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? backupOverviewElement.getLastBkpEndTime() : lastAccessTime;
                        }
                        catch (Exception e) {
                            logger.error("...unable to process date...... " + e.getMessage());
                            logger.trace("Excption e={}", (Throwable)e);
                        }
                    }
                    long lastHeardDateTime = this.reportUtil.getTime(lastHeardDate);
                    if (!StringUtils.isEmpty((String)backupOverviewElement.getLastSuccessfulBackupEndTime()) && lastHeardDateTime < (lstsuccessBkpEndTime = this.reportUtil.getTime(backupOverviewElement.getLastSuccessfulBackupEndTime()))) {
                        lastHeardDate = this.reportUtil.getDateInFormat(lstsuccessBkpEndTime, DD_MMM_YYYY_HH_MM_SS);
                    }
                    long lastHeardTimeStamp = this.reportUtil.getTime(lastHeardDate);
                    htmlContent.append("<td>" + this.reportUtil.getDateInFormat(lastHeardTimeStamp, DD_MMM_YYYY) + "</td>");
                } else {
                    htmlContent.append("<td>-</td>");
                }
            }
            htmlContent.append("<td>" + backupOverviewElement.getStorageUtilized() + "</td>");
            if (header.equalsIgnoreCase("Long running backup details")) {
                htmlContent.append("<td>" + backupOverviewElement.getCurrentlyRunningBkpTotalSizeOfFiles() + "</td>");
            }
            htmlContent.append("</tr>");
        }
        htmlContent.append("</table>");
    }

    private static enum DPS_CONSTANTS {
        REPORT_GENERATED_ON("Report generated on "),
        BACKUP_PERFORMANCE_SUMMARY("Backup performance summary"),
        STATISTIC("Statistic"),
        VALUES("Values"),
        SITE_NAME("Site Name"),
        POLICY_NAME("Policy Name :"),
        NO_OF_DAYS("Number of days :"),
        ACTIVE_SITES("Active Sites"),
        ACTIVE_SERVERS("Active servers"),
        ACTIVE_USERS("Active Users"),
        USERS_WITH_ASSET("Users with at least one asset assigned"),
        SERVERS_WITH_AGENT("Servers with agent registered"),
        FULL_BACKUP_SITES("# of Sites for which at least one full backup is completed"),
        FULL_BACKUP_USERS("# of users for whom at least one full backup is complete"),
        FULL_BACKUP_SERVERS("No. of servers for whom at least one full backup is completed"),
        USERS_WITHOUT_ASSET("# of users with out asset registered"),
        SERVERS_WITHOUT_AGENT("# of servers without agent registered"),
        USERS_WITH_HEARTBEAT("# of users whose assets had a heartbeat to the server in the last "),
        SERVERS_WITH_HEARTBEAT("# of servers whose agents had a heartbeat in the last "),
        SITES_PROTECTED_LAST("# of Sites which have been protected in the last "),
        USERS_ASSETS_PROTECTED_LAST("# of users whose assets have been protected in the last "),
        SERVERS_PROTECTED_LAST("# of servers which have been protected in the last "),
        SL_NO("Sr. No.");

        private final String headers;

        private DPS_CONSTANTS(String headers) {
            this.headers = headers;
        }

        public String getHeaders() {
            return this.headers;
        }
    }
}

