/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.report.service.impl;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.constant.Report;
import com.parablu.paracloud.element.BackupHistoryElement;
import com.parablu.paracloud.element.BackupHistoryResponse;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.report.service.ReportGenerator;
import com.parablu.report.util.ExcelReportUtil;
import com.parablu.report.util.PdfReportUtil;
import com.parablu.report.util.ReportUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.CollectionUtils;

public class BackupHistoryReportGenerator
implements ReportGenerator<BackupHistoryResponse> {
    private static final String REPORTS_PATH = "/reports/";
    private static final String PDF_EXTENSION = ".pdf";
    private static Logger logger = LogManager.getLogger();
    private BackupBatchDao backupBatchDao;
    private UserDao userDao;
    private ReportUtil reportUtil;
    private ExcelReportUtil excelReportUtil;
    private PdfReportUtil pdfReportUtil;

    public BackupHistoryReportGenerator(BackupBatchDao backupBatchDao, UserDao userDao, ReportUtil reportUtil, ExcelReportUtil excelReportUtil, PdfReportUtil pdfReportUtil) {
        this.backupBatchDao = backupBatchDao;
        this.userDao = userDao;
        this.reportUtil = reportUtil;
        this.excelReportUtil = excelReportUtil;
        this.pdfReportUtil = pdfReportUtil;
    }

    @Override
    public BackupHistoryResponse generateReport(Cloud cloud, ReportQueryElement reportQueryElement) throws Exception {
        logger.debug("process=Inside BackupHistoryReportGenerator, status started");
        BackupHistoryResponse backupHistoryResponse = new BackupHistoryResponse();
        try {
            List<Object> backupBatchList = this.getBackupBatchListFromReportQuery(cloud, reportQueryElement);
            logger.debug("before......." + backupBatchList.size());
            backupBatchList = backupBatchList.stream().filter(batch -> StringUtils.isNotEmpty((String)batch.getStatus()) && !batch.getStatus().equalsIgnoreCase("STARTED")).collect(Collectors.toList());
            logger.debug("after......." + backupBatchList.size());
            List<BackupHistoryElement> backupHistoryElements = this.reportUtil.getBackupBatchElements(backupBatchList);
            backupHistoryResponse.setBackupHistoryElement(backupHistoryElements);
            if (((Report.Product)Report.BACKUP_HISTORY.getProducts().get(reportQueryElement.getProductType())).isView() && ReportQueryElement.ReportOperation.GENERATE_VIEW.toString().equals(reportQueryElement.getOperationType().toString())) {
                logger.debug("generated view as per operationType, status=completed");
                return backupHistoryResponse;
            }
            if (((Report.Product)Report.BACKUP_HISTORY.getProducts().get(reportQueryElement.getProductType())).isExcel() && ReportQueryElement.ReportOperation.GENERATE_EXCEL.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (backupHistoryElements != null && backupHistoryElements.size() > 0) {
                    this.createExcelBackupHistory(backupHistoryElements, reportQueryElement);
                    logger.debug("Backup History excel report generated successfully");
                    return null;
                }
                logger.debug("No record found to create excel for Backup history ");
                throw new Exception(Integer.toString(403));
            }
            if (((Report.Product)Report.BACKUP_HISTORY.getProducts().get(reportQueryElement.getProductType())).isPdf() && ReportQueryElement.ReportOperation.GENERATE_PDF.toString().equals(reportQueryElement.getOperationType().toString())) {
                if (backupHistoryElements != null && backupHistoryElements.size() > 0) {
                    this.createPdfOfBackupSummary(cloud, backupHistoryElements, reportQueryElement);
                    logger.debug("Data protection scorecard pdf report generated successfully");
                    return null;
                }
                logger.debug("No record found to create pdf for Backup history ");
                throw new Exception(Integer.toString(403));
            }
            throw new Exception("Not a valid operation Type");
        }
        catch (Exception e) {
            logger.error("There is an exception during Backup history report creation");
            throw e;
        }
    }

    private List<BackupBatch> getBackupBatchListFromReportQuery(Cloud cloud, ReportQueryElement reportQueryElement) {
        List<Object> backupBatchList = new ArrayList();
        int cloudId = cloud.getCloudId();
        String productType = PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.toString().toLowerCase();
        if (!CollectionUtils.isEmpty((Collection)reportQueryElement.getPolicyNames())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getProductType())) {
                productType = reportQueryElement.getProductType();
            }
            List userList = this.userDao.getAllUsersByPolicyNames(cloudId, reportQueryElement.getPolicyNames(), productType);
            for (User user : userList) {
                backupBatchList.addAll(this.backupBatchDao.getAllBackupBatch(cloudId, user.getUserName(), "", Long.valueOf(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate()))));
            }
        } else {
            logger.debug("reportQueryElement.getStartDate()" + reportQueryElement.getStartDate() + ".." + reportQueryElement.getEndDate());
            logger.debug(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate()) + "..........." + this.reportUtil.getEndOfDay(reportQueryElement.getEndDate()));
            List backupBatchListNew = this.backupBatchDao.getAllBackupBatchForExcelWithoutPagination(cloudId, reportQueryElement.getUserName(), reportQueryElement.getDeviceName(), Long.valueOf(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())), Long.valueOf(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())));
            backupBatchList.addAll(backupBatchListNew);
        }
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.toString().equalsIgnoreCase(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_ONEDRIVE_DEVICE)).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_EXCHANGE_DEVICE)).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.toString().equalsIgnoreCase(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_SHAREPOINT_DEVICE)).collect(Collectors.toList());
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.toString().equalsIgnoreCase(reportQueryElement.getProductType())) {
            backupBatchList = backupBatchList.stream().filter(backupBatch -> !backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_SHAREPOINT_DEVICE) && !backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_EXCHANGE_DEVICE) && !backupBatch.getDeviceName().contains(PCHelperConstant.MICROSOFT_ONEDRIVE_DEVICE)).collect(Collectors.toList());
        }
        logger.debug(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate()) + "<<<<<<<<<<<<<<<<start:end>>>>>>>>>>>>>>>>>>>>>>>" + this.reportUtil.getEndOfDay(reportQueryElement.getEndDate()));
        logger.debug("backupBatchList count : " + backupBatchList.size());
        return backupBatchList;
    }

    private void createExcelBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        if (!backupHistoryElements.isEmpty()) {
            logger.debug("inside the createExcelBackupHistory ");
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateValuesToExcelforBackupHistory(backupHistoryElements, reportQueryElement);
                this.excelReportUtil.createExcelSheet(recordToAdd, workbook, Report.BACKUP_HISTORY.getFileName()[0]);
                this.excelReportUtil.writeExcelForXlsx(workbook, reportQueryElement, Report.BACKUP_HISTORY.getFileName()[0]);
            }
            catch (Exception e) {
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e.getMessage());
                logger.debug("Exception while creating the excel sheet for BackupHistory" + e);
                throw e;
            }
        }
    }

    private List<List> updateValuesToExcelforBackupHistory(List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) {
        logger.debug("inside the Report for BackupHistory ");
        ArrayList<List> recordToAdd = new ArrayList<List>();
        ArrayList<String> headerRow = new ArrayList<String>();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            headerRow.add(BACKUP_HISTORY_CONSTANT.SITE_NAME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.START_TIME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.END_TIME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.FILES_BACKED_UP.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.REMARKS.getHeaders());
        } else {
            headerRow.add(BACKUP_HISTORY_CONSTANT.USER_NAME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.ASSET_NAME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.START_TIME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.END_TIME.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.FILES_BACKED_UP.getHeaders());
            headerRow.add(BACKUP_HISTORY_CONSTANT.REMARKS.getHeaders());
        }
        ArrayList<String> headerRow1 = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        headerRow1.add(BACKUP_HISTORY_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate);
        recordToAdd.add(headerRow1);
        ArrayList<String> userInputsRow = new ArrayList<String>();
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            sb.append(BACKUP_HISTORY_CONSTANT.POLICYNAME.getHeaders() + policyNames + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
            sb.append(BACKUP_HISTORY_CONSTANT.USERNAME.getHeaders() + reportQueryElement.getUserName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            sb.append(BACKUP_HISTORY_CONSTANT.ASSET_NAME.getHeaders() + reportQueryElement.getDeviceName() + "   ");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            sb.append(BACKUP_HISTORY_CONSTANT.FROMDATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())) + "   " + BACKUP_HISTORY_CONSTANT.TODATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())));
        }
        userInputsRow.add(sb.toString());
        recordToAdd.add(userInputsRow);
        ArrayList<String> headerRow3 = new ArrayList<String>();
        headerRow3.add(BACKUP_HISTORY_CONSTANT.BACKUP_HISTORY.getHeaders());
        recordToAdd.add(headerRow3);
        recordToAdd.add(headerRow);
        for (BackupHistoryElement backupHistoryElement : backupHistoryElements) {
            ArrayList<String> firstRow = new ArrayList<String>();
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                firstRow.add(backupHistoryElement.getDeviceName());
                firstRow.add(backupHistoryElement.getStartTime());
                firstRow.add(backupHistoryElement.getEndTime());
                firstRow.add(backupHistoryElement.getUploadedFiles());
                firstRow.add(backupHistoryElement.getAction());
                recordToAdd.add(firstRow);
                continue;
            }
            firstRow.add(backupHistoryElement.getUserName());
            firstRow.add(backupHistoryElement.getDeviceName());
            firstRow.add(backupHistoryElement.getStartTime());
            firstRow.add(backupHistoryElement.getEndTime());
            firstRow.add(backupHistoryElement.getUploadedFiles());
            firstRow.add(backupHistoryElement.getAction());
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private void createPdfOfBackupSummary(Cloud cloud, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        String tempFile = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.BACKUP_HISTORY.getFileName()[0] + "temp" + PDF_EXTENSION;
        String file = PCHelperConstant.getPropertyFileValueParacloudMountPoint() + REPORTS_PATH + Report.BACKUP_HISTORY.getFileName()[0] + PDF_EXTENSION;
        StringBuilder htmlContent = new StringBuilder();
        String currentDate = this.reportUtil.getTimeZoneShortFormat(System.currentTimeMillis());
        htmlContent.append("<!DOCTYPE html>").append("<html>").append("<head>").append("<style>").append(" body {font-family: Arial, sans-serif;}").append("table { width: 100%; border-collapse: collapse;table-layout: fixed }").append("table, th, td { border: 1px solid black; }").append("th, td { padding: 5px; text-align: left; word-wrap: break-word; }").append("th { background-color: #f2f2f2; font-size: 10px; }").append(".col-1 { max-width: 30px;width: 20px; }").append("td { word-wrap: break-word; font-size: 10px; }").append("</style>").append("</head>").append("<body>").append("<p>" + BACKUP_HISTORY_CONSTANT.REPORT_GENERATED_ON.getHeaders() + currentDate + "</p>");
        if (!reportQueryElement.getPolicyNames().isEmpty()) {
            String policyNames = String.join((CharSequence)", ", reportQueryElement.getPolicyNames());
            htmlContent.append("<p>" + BACKUP_HISTORY_CONSTANT.POLICYNAME.getHeaders() + policyNames + "</p>");
        }
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getUserName())) {
                htmlContent.append("<p>" + BACKUP_HISTORY_CONSTANT.USERNAME.getHeaders() + reportQueryElement.getUserName() + "</p>");
            }
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                htmlContent.append("<p>" + BACKUP_HISTORY_CONSTANT.ASSET_NAME.getHeaders() + reportQueryElement.getDeviceName() + "</p>");
            }
        } else if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
            htmlContent.append("<p>" + BACKUP_HISTORY_CONSTANT.SITE_NAME.getHeaders() + reportQueryElement.getDeviceName() + "</p>");
        }
        if (StringUtils.isNotEmpty((String)reportQueryElement.getStartDate()) && StringUtils.isNotEmpty((String)reportQueryElement.getEndDate())) {
            htmlContent.append("<p>" + BACKUP_HISTORY_CONSTANT.FROMDATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getStartOfDay(reportQueryElement.getStartDate())) + " " + BACKUP_HISTORY_CONSTANT.TODATE.getHeaders() + this.reportUtil.getTimeZoneShortFormatwithoutTime(this.reportUtil.getEndOfDay(reportQueryElement.getEndDate())) + "</p>");
        }
        try {
            this.headerOfPdfForBackupHistory(htmlContent, backupHistoryElements, reportQueryElement);
            this.updateBackupHistoryOnPdf(backupHistoryElements, htmlContent, reportQueryElement);
            htmlContent.append("</table>").append("</body>").append("</html>");
            logger.debug(htmlContent + "htmlContent............");
            FileOutputStream outputStream = new FileOutputStream(new File(tempFile));
            PdfRendererBuilder builder = new PdfRendererBuilder();
            builder.withHtmlContent(htmlContent.toString(), null);
            builder.useDefaultPageSize(594.0f, 420.0f, BaseRendererBuilder.PageSizeUnits.MM);
            builder.toStream((OutputStream)outputStream);
            builder.run();
            ((OutputStream)outputStream).close();
            logger.debug("PDF created successfully at " + tempFile);
            logger.debug("PDF created successfully.");
            this.pdfReportUtil.addWatermarkToPDF(tempFile, file, cloud.getCloudId());
        }
        catch (Exception e) {
            logger.debug("Exception while creating the pdf sheet for BackupHistory" + e.getMessage());
            logger.debug("Exception while creating the pdf sheet for BackupHistory" + e);
            throw e;
        }
    }

    private void headerOfPdfForBackupHistory(StringBuilder htmlContent, List<BackupHistoryElement> backupHistoryElements, ReportQueryElement reportQueryElement) throws Exception {
        if (!PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
            htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + BACKUP_HISTORY_CONSTANT.SL_NO.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.USER_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.ASSET_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.START_TIME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.END_TIME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.FILES_BACKED_UP.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.REMARKS.getHeaders() + "</th>");
        } else {
            htmlContent.append("<table>").append("<tr>").append("<th class=\"col-1\">" + BACKUP_HISTORY_CONSTANT.SL_NO.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.SITE_NAME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.START_TIME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.END_TIME.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.FILES_BACKED_UP.getHeaders() + "</th>");
            htmlContent.append("<th>" + BACKUP_HISTORY_CONSTANT.REMARKS.getHeaders() + "</th>");
        }
        htmlContent.append("</tr>");
    }

    private void updateBackupHistoryOnPdf(List<BackupHistoryElement> backupBatchelementList, StringBuilder htmlContent, ReportQueryElement reportQueryElement) throws Exception {
        long slNo = 0L;
        for (BackupHistoryElement backupBatchelement : backupBatchelementList) {
            htmlContent.append("<tr>");
            htmlContent.append("<td>" + ++slNo + "</td>");
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(reportQueryElement.getProductType())) {
                htmlContent.append("<td>" + backupBatchelement.getDeviceName() + "</td>");
            } else {
                htmlContent.append("<td>" + backupBatchelement.getUserName() + "</td>");
                htmlContent.append("<td>" + backupBatchelement.getDeviceName() + "</td>");
            }
            htmlContent.append("<td>" + backupBatchelement.getStartTime() + "</td>");
            htmlContent.append("<td>" + backupBatchelement.getEndTime() + "</td>");
            htmlContent.append("<td>" + backupBatchelement.getUploadedFiles() + "</td>");
            htmlContent.append("<td>" + backupBatchelement.getAction() + "</td>");
            htmlContent.append("</tr>");
        }
    }

    private static enum BACKUP_HISTORY_CONSTANT {
        SL_NO("SR. No."),
        SITE_NAME("Site Name"),
        USER_NAME("User Name"),
        ASSET_NAME("Asset Name"),
        START_TIME("Start Time"),
        END_TIME("End Time"),
        FILES_BACKED_UP("Files Backed Up"),
        REMARKS("Remarks"),
        REPORT_GENERATED_ON("Report generated on "),
        POLICYNAME("Policy Name :"),
        USERNAME("User ID :"),
        FROMDATE("From Date :"),
        TODATE("To Date :"),
        BACKUP_HISTORY("Backup History");

        private final String headers;

        private BACKUP_HISTORY_CONSTANT(String headers) {
            this.headers = headers;
        }

        public String getHeaders() {
            return this.headers;
        }
    }
}

