/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.domain;

import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.util.mongodb.CascadeSave;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="REVISIONS")
public class FileRevision {
    @Id
    @Field
    private ObjectId id;
    @Field
    private String metaData;
    @Field
    private String md5;
    @Field
    @Indexed
    private boolean folder;
    @Field
    private double size = 0.0;
    @Field
    private String status;
    @Field
    @Indexed
    private long lastModifiedTime;
    @Field
    @Indexed
    private String fSPath;
    @Field
    private String regID;
    @Field
    @Indexed
    private String userName;
    @DBRef
    @CascadeSave
    private ConsolidatedImage consolidatedImage;
    @Field
    private String comment;
    @Field
    @Indexed
    private String storagePlace;
    @Field
    private String gatewayName;
    @Field
    private boolean isCompressed;

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getStoragePlace() {
        return this.storagePlace;
    }

    public void setStoragePlace(String storagePlace) {
        this.storagePlace = storagePlace;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId revisionId) {
        this.id = revisionId;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String getfSPath() {
        return this.fSPath;
    }

    public void setfSPath(String fSPath) {
        this.fSPath = fSPath;
    }

    public ConsolidatedImage getConsolidatedImage() {
        return this.consolidatedImage;
    }

    public void setConsolidatedImage(ConsolidatedImage consolidatedImage) {
        this.consolidatedImage = consolidatedImage;
    }

    public String getRegID() {
        return this.regID;
    }

    public void setRegID(String regID) {
        this.regID = regID;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 31).append((Object)this.id).hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FileRevision)) {
            return false;
        }
        FileRevision fileRevision = (FileRevision)object;
        if (fileRevision.getId() == this.getId()) {
            return true;
        }
        if (fileRevision.getConsolidatedImage().equals(this.getConsolidatedImage())) {
            return fileRevision.getMd5().equals(this.getMd5()) && fileRevision.getStatus().equals(this.getStatus()) && fileRevision.getfSPath().equals(this.getfSPath());
        }
        return false;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

