/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.domain;

import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="BACKUP_BATCH")
@CompoundIndexes(value={@CompoundIndex(name="user_1_device_1_jobType_1", def="{'user' : 1, 'device':1, 'jobType':1}"), @CompoundIndex(name="jobType_1_status_1", def="{'jobType':1, 'status':1}"), @CompoundIndex(name="jobType_1_status_1_deviceType_1_underProcessing", def="{'jobType':1, 'status':1, 'deviceType':1, 'underProcessing':1 }")})
public class BackupBatch {
    @Id
    @Field
    private ObjectId id;
    @Field
    @Indexed
    private String userName;
    @Field
    @Indexed
    private String deviceName;
    @Field
    @Indexed
    private String deviceUUID;
    @Field
    private long batchStartTimestamp;
    @Field
    private long batchEndTimestamp;
    @Field
    private long noOfFiles;
    @Field
    private String uploadedSize;
    @Field
    private String uploadedFiles;
    @Field
    private String totalNoOfFiles;
    @Field
    private String status;
    @Field
    private String jobType;
    @Field
    private String errorCode;
    @Field
    private String crawlTimestamp;
    @Field
    private boolean isFullBackup;
    @Field
    private String configuredBackupFolder;
    @Field
    private String diskSpaceDetails;
    @Field
    private long totalSizeToUpload;
    @Field
    private long deletedFilesSize;
    @Field
    private long encryptedFilesSize;
    @Field
    private long newFilesSize;
    @Field
    private String rapidRestoreStatus;
    private long cpConvFiles;
    @Field
    @Indexed
    private String deviceType;
    @Field
    @Indexed
    private boolean underProcessing;
    @Field
    @Indexed
    private boolean scanCompleted;
    @Field
    private boolean latestBatch;

    public boolean isLatestBatch() {
        return this.latestBatch;
    }

    public void setLatestBatch(boolean latestBatch) {
        this.latestBatch = latestBatch;
    }

    public boolean isScanCompleted() {
        return this.scanCompleted;
    }

    public void setScanCompleted(boolean scanCompleted) {
        this.scanCompleted = scanCompleted;
    }

    public boolean isUnderProcessing() {
        return this.underProcessing;
    }

    public void setUnderProcessing(boolean underProcessing) {
        this.underProcessing = underProcessing;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public long getCpConvFiles() {
        return this.cpConvFiles;
    }

    public void setCpConvFiles(long cpConvFiles) {
        this.cpConvFiles = cpConvFiles;
    }

    public long getTotalSizeToUpload() {
        return this.totalSizeToUpload;
    }

    public void setTotalSizeToUpload(long totalSizeToUpload) {
        this.totalSizeToUpload = totalSizeToUpload;
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public long getBatchStartTimestamp() {
        return this.batchStartTimestamp;
    }

    public void setBatchStartTimestamp(long batchStartTimestamp) {
        this.batchStartTimestamp = batchStartTimestamp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getBatchEndTimestamp() {
        return this.batchEndTimestamp;
    }

    public void setBatchEndTimestamp(long batchEndTimestamp) {
        this.batchEndTimestamp = batchEndTimestamp;
    }

    public long getNoOfFiles() {
        return this.noOfFiles;
    }

    public void setNoOfFiles(long noOfFiles) {
        this.noOfFiles = noOfFiles;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getUploadedSize() {
        return this.uploadedSize;
    }

    public void setUploadedSize(String uploadedSize) {
        this.uploadedSize = uploadedSize;
    }

    public String getUploadedFiles() {
        return this.uploadedFiles;
    }

    public void setUploadedFiles(String uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public String getTotalNoOfFiles() {
        return this.totalNoOfFiles;
    }

    public void setTotalNoOfFiles(String totalNoOfFiles) {
        this.totalNoOfFiles = totalNoOfFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BackupBatch: \n");
        sb.append("\t backupBatchId\t\t").append(this.id);
        return sb.toString();
    }

    public String getCrawlTimestamp() {
        return this.crawlTimestamp;
    }

    public void setCrawlTimestamp(String crawlTimestamp) {
        this.crawlTimestamp = crawlTimestamp;
    }

    public boolean isFullBackup() {
        return this.isFullBackup;
    }

    public void setFullBackup(boolean isFullBackup) {
        this.isFullBackup = isFullBackup;
    }

    public String getConfiguredBackupFolder() {
        return this.configuredBackupFolder;
    }

    public void setConfiguredBackupFolder(String configuredBackupFolder) {
        this.configuredBackupFolder = configuredBackupFolder;
    }

    public String getDiskSpaceDetails() {
        return this.diskSpaceDetails;
    }

    public void setDiskSpaceDetails(String diskSpaceDetails) {
        this.diskSpaceDetails = diskSpaceDetails;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public long getDeletedFilesSize() {
        return this.deletedFilesSize;
    }

    public void setDeletedFilesSize(long deletedFilesSize) {
        this.deletedFilesSize = deletedFilesSize;
    }

    public long getEncryptedFilesSize() {
        return this.encryptedFilesSize;
    }

    public void setEncryptedFilesSize(long encryptedFilesSize) {
        this.encryptedFilesSize = encryptedFilesSize;
    }

    public long getNewFilesSize() {
        return this.newFilesSize;
    }

    public void setNewFilesSize(long newFilesSize) {
        this.newFilesSize = newFilesSize;
    }

    public String getRapidRestoreStatus() {
        return this.rapidRestoreStatus;
    }

    public void setRapidRestoreStatus(String rapidRestoreStatus) {
        this.rapidRestoreStatus = rapidRestoreStatus;
    }

    public static enum STATUS {
        STARTED,
        COMPLETED,
        FAILED,
        INTERRUPTED,
        SCANNING,
        QUEUED,
        PAUSED;

    }
}

