/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.domain;

import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MailInfo;
import com.parablu.pcbd.util.mongodb.CascadeSave;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection="BACKUP")
@CompoundIndexes(value={@CompoundIndex(name="deviceUUID_1_devicePath_1_fileName_1", def="{'deviceUUID' : 1, 'devicePath':1, 'fileName':1}")})
public class BackUpImage
extends MailInfo
implements Serializable {
    @Id
    @Field
    private ObjectId id;
    private static final long serialVersionUID = -8783897421809089413L;
    @Field
    @Indexed
    private long lastServerModifiedTime;
    @Field
    private long lastClientModifiedTime;
    @Field
    @Indexed
    private String md5Checksum;
    @Field
    private long size = 0L;
    @Field
    private String fSPath;
    @Field
    private boolean folder = false;
    @Field
    private boolean present = false;
    @Field
    private boolean baseBackup = false;
    @Field
    private String status;
    @Field
    @Indexed
    private String userName;
    @Field
    private boolean externalStorage = false;
    @Field
    private String fileName;
    @Field
    private String devicePath;
    @Field
    private String storagePlace;
    @Field
    private String deviceUUID;
    @DBRef
    @CascadeSave
    private Device device;
    @Field
    private String gatewayName;
    @Field
    private String containerName;
    @Field
    private String containerType;
    @Field
    private boolean compressed;
    @Field
    private String sharedTimeStamp = null;
    @Field
    private String sharedBy;
    @Field
    @Indexed
    private String odItemId;
    @Field
    private String versionId;
    @Field
    private long lastCloudUploadedTime;
    @Field
    boolean isMail;
    @Field
    private boolean busy;
    @Field
    private long sizeInBytes = 0L;
    @Field
    private long crawlStartTimestamp;
    @Field
    @Indexed
    private boolean miniCloud;
    @Field
    private boolean fileInfected;
    @Field
    private boolean isSync;
    @Field
    private String comment;
    @Field
    private boolean isFileEncrypted;
    @Field
    private boolean linkDeleted = false;
    private List<ChunkFile> chunkFiles = new ArrayList<ChunkFile>();

    public boolean isLinkDeleted() {
        return this.linkDeleted;
    }

    public void setLinkDeleted(boolean linkDeleted) {
        this.linkDeleted = linkDeleted;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public boolean isMail() {
        return this.isMail;
    }

    public void setMail(boolean isMail) {
        this.isMail = isMail;
    }

    public String getOdItemId() {
        return this.odItemId;
    }

    public void setOdItemId(String odItemId) {
        this.odItemId = odItemId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getSharedTimeStamp() {
        return this.sharedTimeStamp;
    }

    public void setSharedTimeStamp(String sharedTimeStamp) {
        this.sharedTimeStamp = sharedTimeStamp;
    }

    public String getSharedBy() {
        return this.sharedBy;
    }

    public void setSharedBy(String sharedBy) {
        this.sharedBy = sharedBy;
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public List<ChunkFile> getChunkFiles() {
        return this.chunkFiles;
    }

    public void setChunkFiles(List<ChunkFile> chunkFiles) {
        this.chunkFiles = chunkFiles;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(String devicePath) {
        this.devicePath = devicePath;
    }

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 31).append(this.folder).append((Object)this.getDevicePath()).append((Object)this.getFileName()).append((Object)this.md5Checksum).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackUpImage)) {
            return false;
        }
        BackUpImage backUpImage = (BackUpImage)obj;
        return new EqualsBuilder().append(this.isFolder(), backUpImage.isFolder()).append((Object)this.getDevicePath(), (Object)backUpImage.getDevicePath()).append((Object)this.getFileName(), (Object)backUpImage.getFileName()).append((Object)this.getMd5Checksum(), (Object)backUpImage.getMd5Checksum()).isEquals();
    }

    public String getfSPath() {
        return this.fSPath;
    }

    public void setfSPath(String fSPath) {
        this.fSPath = fSPath;
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public boolean isExternalStorage() {
        return this.externalStorage;
    }

    public void setExternalStorage(boolean externalStorage) {
        this.externalStorage = externalStorage;
    }

    public long getLastServerModifiedTime() {
        return this.lastServerModifiedTime;
    }

    public void setLastServerModifiedTime(long lastServerModifiedTime) {
        this.lastServerModifiedTime = lastServerModifiedTime;
    }

    public long getLastClientModifiedTime() {
        return this.lastClientModifiedTime;
    }

    public void setLastClientModifiedTime(long lastClientModifiedTime) {
        this.lastClientModifiedTime = lastClientModifiedTime;
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public void setMd5Checksum(String md5Checksum) {
        this.md5Checksum = md5Checksum;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isBaseBackup() {
        return this.baseBackup;
    }

    public void setBaseBackup(boolean baseBackup) {
        this.baseBackup = baseBackup;
    }

    public static long getSerialversionuid() {
        return -8783897421809089413L;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getStoragePlace() {
        return this.storagePlace;
    }

    public void setStoragePlace(String storagePlace) {
        this.storagePlace = storagePlace;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public String getDeviceUUID() {
        return this.deviceUUID;
    }

    public void setDeviceUUID(String deviceUUID) {
        this.deviceUUID = deviceUUID;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public long getLastCloudUploadedTime() {
        return this.lastCloudUploadedTime;
    }

    public void setLastCloudUploadedTime(long lastCloudUploadedTime) {
        this.lastCloudUploadedTime = lastCloudUploadedTime;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public long getCrawlStartTimestamp() {
        return this.crawlStartTimestamp;
    }

    public void setCrawlStartTimestamp(long crawlStartTimestamp) {
        this.crawlStartTimestamp = crawlStartTimestamp;
    }

    public boolean isMiniCloud() {
        return this.miniCloud;
    }

    public void setMiniCloud(boolean miniCloud) {
        this.miniCloud = miniCloud;
    }

    public boolean isFileInfected() {
        return this.fileInfected;
    }

    public void setFileInfected(boolean fileInfected) {
        this.fileInfected = fileInfected;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public void setSync(boolean sync) {
        this.isSync = sync;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isFileEncrypted() {
        return this.isFileEncrypted;
    }

    public void setFileEncrypted(boolean isFileEncrypted) {
        this.isFileEncrypted = isFileEncrypted;
    }
}

