/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.result.UpdateResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.SiteElement;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.BlackListUser;
import com.parablu.pcbd.domain.CollectionDetails;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.FailedLogin;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PstBatch;
import com.parablu.pcbd.domain.PstBatchDetail;
import com.parablu.pcbd.domain.SharePointProperties;
import com.parablu.pcbd.domain.SiteDeltaPath;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UserDaoImpl
implements UserDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    static Logger logger = LogManager.getLogger(UserDaoImpl.class);
    private static final String DELETED = "deleted";
    private static final String ACTIVE = "active";
    private static final String USER_NAME = "userName";
    private static final String USER_ID = "userId";
    private static final String EMAIL_ID = "emailId";
    private static final String LOCAL_USER = "localUser";
    private static final String GUEST = "guest";
    private static final String USER_NAME_LOWER_CASE = "userNameLowerCase";
    private static final String POLICY_NAME = "policyName";
    private static final String USER_TYPE = "userType";
    private static final String ONE_DRIVE_POLICY_NAME = "oneDrivePolicyName";
    private static final String EXCHANGE_POLICY_NAME = "exchangePolicyName";
    private static final String SHARE_POINT_POLICY_NAME = "spPolicyName";
    private static final String SYNC_POLICY_NAME = "syncPolicyName";
    private static final String GUEST_USER = "guest";
    private static final String SHARE_POINT = "Sharepoint";
    private static final String EXCHANGE = "exchange";
    private static final String ODB = "ODB";
    private static final String SUPER_ADMIN = "superAdmin";
    private MongoOperations msgMongoTemplate;
    private MongoOperations mongoOps;

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, boolean site) {
        Criteria criteriaOb = new Criteria();
        criteriaOb.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Criteria criteria = new Criteria();
        Criteria criteriaOb1 = new Criteria();
        Criteria criteriaOb2 = new Criteria();
        criteriaOb1.orOperator(new Criteria[]{Criteria.where((String)"site").is((Object)site), Criteria.where((String)"site").exists(false)});
        criteriaOb2.andOperator(new Criteria[]{Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        criteria.andOperator(new Criteria[]{criteriaOb, criteriaOb1, criteriaOb2});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllActiveUsers(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, int skipValue, boolean isSite, String pagination) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)isSite), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        if (!isSite && "true".equals(pagination)) {
            if (skipValue != -99) {
                query.limit(PCHelperConstant.getReportDisplayRecords());
            }
            if (skipValue != 0 && skipValue != -99) {
                query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
            }
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, int skipValue, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString())});
        } else {
            Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSuperAdmin = Criteria.where((String)SUPER_ADMIN).is((Object)false);
            Criteria criteriaForServerUser = Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString());
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName, criteriaForSuperAdmin, criteriaForServerUser});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersWithoutPagination(int cloudId, String cloudName, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        } else {
            Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserInfoByName(int cloudId, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase()));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public boolean checkUserExistByUserNameOrEmail(int cloudId, String userName, String emailId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = Criteria.where((String)EMAIL_ID).is((Object)emailId);
        criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class) != null;
    }

    @Override
    public List<User> getAllUsers(int cloudId) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(User.class);
    }

    @Override
    public List<User> getAllUsersForProductType(int cloudId, String productType) {
        Query query = new Query();
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.toString().equalsIgnoreCase(productType)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    public static boolean validateRegex(String regex) {
        boolean validRegex = false;
        try {
            Pattern pattern = Pattern.compile(regex);
            validRegex = true;
        }
        catch (PatternSyntaxException e) {
            logger.debug("..invalid regex....");
        }
        return validRegex;
    }

    @Override
    public User getUserByUserNameOrEmail(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = null;
        if (UserDaoImpl.validateRegex("^" + userName + "$")) {
            logger.debug("...valid regex....");
            criteriaEmailId = Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + userName + "$", 2));
        } else {
            criteriaEmailId = Criteria.where((String)EMAIL_ID).is((Object)userName);
        }
        criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByUserNameOrAADLoginId(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        userName = UserDaoImpl.escapeMetaCharacters(userName);
        Criteria criteriaUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailId = Criteria.where((String)"aadLoginId").regex(Pattern.compile("^" + userName + "$", 2));
        criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId});
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("query for get user.." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByUserNameOrEmail(int cloudId, String userName, String emailId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserNameWithUserName = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Criteria criteriaEmailIdWithUserName = Criteria.where((String)EMAIL_ID).is((Object)userName);
        Criteria criteriaEmailIdWithEmail = Criteria.where((String)EMAIL_ID).is((Object)emailId);
        Criteria criteriaUserNameWithEmail = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)emailId.toLowerCase());
        criteria.orOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{criteriaUserNameWithUserName, criteriaEmailIdWithUserName}), new Criteria().orOperator(new Criteria[]{criteriaUserNameWithEmail, criteriaEmailIdWithEmail})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserInfo(int cloudId, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public User updateUser(int cloudId, String cloudName, User user) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.save((Object)user);
        return user;
    }

    @Override
    public void deleteUser(int cloudId, String cloudName, User user) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove((Object)user);
    }

    @Override
    public void deleteUsers(int cloudId, String cloudName, List<String> userIdList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIdList)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).remove(query, User.class);
    }

    @Override
    public long getUsersCountInPolicyNames(int cloudId, List<String> userNamesList, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true)});
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName, List<String> userIdlist) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIdlist), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserInfoByName(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null && !user.isDeleted()) {
            return user;
        }
        return null;
    }

    @Override
    public User getUserDetailsbyMail(int cloudId, String cloudName, String userMail) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).is((Object)userMail)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        if (user != null && !user.isDeleted()) {
            return user;
        }
        return null;
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public long countOfPresentUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentServerUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentSyncUsers(int cloudId, String cloudName, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"syncEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsers(int cloudId, String cloudName, boolean active, boolean backupEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"backupEnabled").is((Object)backupEnabled), Criteria.where((String)"site").is((Object)false), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentBackupServerUsers(int cloudId, String cloudName, boolean active, boolean backupEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"backupEnabled").is((Object)backupEnabled), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<User> getAllAdmins(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"admin").is((Object)true), Criteria.where((String)SUPER_ADMIN).is((Object)false), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Criteria orCriteria1 = new Criteria();
        orCriteria1.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)false), Criteria.where((String)"admin").is((Object)false)});
        criteria.andOperator(new Criteria[]{orCriteria1, orCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllReadOnlyAdmins(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllShareEnabledActiveUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"shareEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void saveFailedLogin(int cloudId, String cloudName, FailedLogin failedLogin) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)failedLogin);
    }

    @Override
    public User saveUser(int cloudId, String cloudName, User user) {
        user.setLastModifiedTimestamp(Long.toString(System.currentTimeMillis()));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
        return user;
    }

    @Override
    public List<User> searchUsers(int cloudId, List<String> list, boolean isSite) {
        List userDbList;
        Criteria criteria;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        HashSet<String> userSet = new HashSet<String>();
        for (String userName : list) {
            userName = userName.trim();
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile(userName, 2)), Criteria.where((String)"site").is((Object)isSite), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)"guest").is((Object)false), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                if (userSet.contains(userObj.getUserName())) continue;
                userList.add(userObj);
                userSet.add(userObj.getUserName());
            }
        }
        if (CollectionUtils.isEmpty(userList)) {
            for (String userName : list) {
                userName = userName.trim();
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"site").is((Object)isSite), Criteria.where((String)SUPER_ADMIN).is((Object)false), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
                userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
                if (userDbList == null) continue;
                for (User userObj : userDbList) {
                    if (userSet.contains(userObj.getUserName())) continue;
                    userList.add(userObj);
                    userSet.add(userObj.getUserName());
                }
            }
        }
        return userList;
    }

    @Override
    public List<User> searchUsersForReport(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> searchUserbyUsernameOrDisplaynameOrEmailId(int cloudId, List<String> list, boolean site) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            List userDbList;
            userName = userName.trim();
            Criteria criteria = new Criteria();
            Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaDisplayName = Criteria.where((String)"displayName").regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaEmailId = Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + userName, 2));
            Criteria criteriaDeleted = Criteria.where((String)DELETED).is((Object)false);
            if (site) {
                criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaDisplayName, criteriaEmailId}), criteriaDeleted, Criteria.where((String)"site").is((Object)site)});
            } else {
                criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaDisplayName, criteriaEmailId}), criteriaDeleted});
            }
            if ((userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class)) == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, boolean backup) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)backup), Criteria.where((String)"site").is((Object)false), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getOfficeUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, String productType) {
        Criteria baseCriteria = new Criteria();
        Criteria criteria = new Criteria();
        Criteria productCriteria = null;
        baseCriteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        if (!StringUtils.isEmpty((Object)productType)) {
            productCriteria = new Criteria();
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
            }
        }
        criteria.andOperator(new Criteria[]{baseCriteria, productCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void updateUserPolicy(int cloudId, String policyName, ObjectId userId, String policyType, long updatedTimeStamp) {
        Criteria criteria = Criteria.where((String)USER_ID).is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            update.set(POLICY_NAME, (Object)policyName);
        } else {
            update.set(SYNC_POLICY_NAME, (Object)policyName);
        }
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUsersNotConnectedToDevice(int cloudId, List<ObjectId> existingUserIDList, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).nin(existingUserIDList)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllDeletedUsersById(int cloudId, String cloudName, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllDeletedUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, List<ObjectId> userIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).in(userIds)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getUserById(int cloudId, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_ID).is((Object)userId)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public boolean checkIfEmailAlreadyExists(int cloudId, String emailId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).is((Object)emailId)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public boolean checkIfEmailAlreadyExistsAsUserName(int cloudId, String emailId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)emailId.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public List<User> getAllUsersForNames(int cloudId, List<String> usersNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(usersNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllBackupUsersForNamesForPolicyMap(int cloudId, List<String> usersNames) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : usersNames) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile(userName, 2)), Criteria.where((String)"site").is((Object)false), Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)"backupEnabled").is((Object)true)});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        userName = UserDaoImpl.escapeMetaCharacters(userName);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    public static String escapeMetaCharacters(String inputString) {
        String[] metaCharacters = new String[]{"\\", "^", "$", "{", "}", "[", "]", "(", ")", "*", "+", "?", "|", "<", ">", "-", "&", "%"};
        for (int i = 0; i < metaCharacters.length; ++i) {
            if (!inputString.contains(metaCharacters[i])) continue;
            inputString = inputString.replace(metaCharacters[i], "\\" + metaCharacters[i]);
        }
        return inputString;
    }

    @Override
    public User getAdminUserWithServerBackupEnabled(int cloudId) {
        logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEGIN");
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true).and("admin").is((Object)true).and("serverBackupEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        logger.debug("User getAdminUserWithServerBackupEnabled(int cloudId) > BEFORE RETURN > USER OBJ > " + user);
        return user;
    }

    @Override
    public List<User> searchUsersByEmail(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String email : list) {
            email = email.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + email, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public User getUserDetailsForEmail(int cloudId, String email) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)EMAIL_ID).regex(Pattern.compile("^" + email + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void updateUserLoggedInTime(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastLoggedInTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllActiveLdapUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public User getOneADUser(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LOCAL_USER).is((Object)false), Criteria.where((String)ACTIVE).exists(true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyNames(int cloudId, List<String> policyNames, String productType) {
        Criteria criteriaForUserType;
        Criteria criteria = new Criteria();
        Criteria criteriaForPolicyName = new Criteria();
        logger.debug(policyNames + "....getAllUsersByPolicyNames...." + productType);
        Criteria criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
        if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
            criteriaForUserType = new Criteria();
            criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            criteriaForUserType = Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString());
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
            criteriaForUserType = new Criteria();
            criteriaForUserType = Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString());
            criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForUserType, criteriaForDelete, criteriaForPolicyName});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SYNC.getProductType().equals(productType)) {
            criteriaForPolicyName = Criteria.where((String)SYNC_POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
            criteriaForPolicyName = Criteria.where((String)EXCHANGE_POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
            criteriaForPolicyName = Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
            criteriaForPolicyName = Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames);
            criteria.andOperator(new Criteria[]{criteriaForDelete, criteriaForPolicyName});
        }
        logger.debug(productType + "...office criteria..." + policyNames);
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("...odb...." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        if (isODBBackupEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), orCriteria, Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)POLICY_NAME).in(policyNames)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getAllUsersCountByPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled) {
        Criteria criteriaForDelete;
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria = Criteria.where((String)DELETED).is((Object)false);
        } else if (isODBBackupEnabled) {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForBkpPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForOdbPolicyName = Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)SYNC_POLICY_NAME).in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForOdbPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete.orOperator(new Criteria[]{criteriaForBkpPolicyName, orCriteria})});
        } else {
            criteriaForDelete = Criteria.where((String)DELETED).is((Object)false);
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)SYNC_POLICY_NAME).in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<String> getUserNamesByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<String> getUserNamesByOfficePoliciesAdmin(int cloudId, List<String> officePoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(officePoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<User> searchUsersForPolicyAdmin(int cloudId, List<String> list, List<String> backupPoliciesAdmin) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2)), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public List<User> searchUsersForPolicyAdmin(int cloudId, List<String> list, List<String> policiesAdmin, boolean isSite) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        for (String userName : list) {
            userName = userName.trim();
            Criteria criteria = new Criteria();
            Criteria policyCriteria = new Criteria();
            policyCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policiesAdmin), Criteria.where((String)SYNC_POLICY_NAME).in(policiesAdmin), Criteria.where((String)EXCHANGE_POLICY_NAME).in(policiesAdmin), Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policiesAdmin), Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policiesAdmin)});
            criteria.andOperator(new Criteria[]{policyCriteria, Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2)), Criteria.where((String)"site").is((Object)isSite)});
            List userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class);
            if (userDbList == null) continue;
            for (User userObj : userDbList) {
                if (userObj.isDeleted()) continue;
                userList.add(userObj);
            }
        }
        return userList;
    }

    @Override
    public boolean checkPolicyMappedToUsers(int cloudId, String policyName, String policyType) {
        Criteria criteria = new Criteria();
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName), Criteria.where((String)DELETED).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName), Criteria.where((String)DELETED).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        return user != null;
    }

    @Override
    public void deleteUsersByName(int cloudId, List<String> userNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(userNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAllAndRemove(query, User.class);
    }

    @Override
    public void updateAADUserInfo(int cloudId, String userName, Boolean bkpEnabled, Boolean syncEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (bkpEnabled != null) {
            update.set("backupEnabled", (Object)bkpEnabled);
        }
        if (syncEnabled != null) {
            update.set("syncEnabled", (Object)syncEnabled);
        }
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).updateFirst(query, update, User.class);
    }

    @Override
    public void saveAudit(int cloudId, String cloudName, AuditHistory audit) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    @Override
    public List<User> getAllOneDriveBkpEnabledUsers(int cloudId) {
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        Criteria criteria = new Criteria();
        Criteria criteriaActive = Criteria.where((String)ACTIVE).is((Object)true);
        Criteria criteriaODBBKpEnabled = Criteria.where((String)"onedriveBkpEnabled").is((Object)true);
        list.add(criteriaActive);
        list.add(criteriaODBBKpEnabled);
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateODBUserPolicy(int cloudId, String policyName, String userName, String policyType) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            update.set(ONE_DRIVE_POLICY_NAME, (Object)policyName);
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            update.set(EXCHANGE_POLICY_NAME, (Object)policyName);
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            update.set(SHARE_POINT_POLICY_NAME, (Object)policyName);
        }
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public long countOfPresentODBBackupUsers(int cloudId, String cloudName, boolean active) {
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)active), Criteria.where((String)"exchangeBkpEnabled").is((Object)active)});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), orCriteria, Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<BlackListUser> getAllBlockedListUser(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, BlackListUser.class);
    }

    @Override
    public List<O365BlackListUser> getAllO365BlockedListUser(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, O365BlackListUser.class);
    }

    @Override
    public List<User> getAllLdapUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LOCAL_USER).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public BackupPolicy getBackupPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public SyncPolicy getSyncPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    @Override
    public List<BackupPolicy> getAllBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public void updateBackupPolicyModifiedTime(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        paracloudMongoTemplate.updateMulti(query, update, User.class);
    }

    @Override
    public void updateSyncPolicyModifiedTime(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("syncPolicyModifiedTime", (Object)System.currentTimeMillis());
        paracloudMongoTemplate.updateMulti(query, update, User.class);
    }

    @Override
    public List<User> getUsersByBackupPolicyName(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUsersBySyncPolicyName(int cloudId, String policyName) {
        Criteria criteria = Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getBackupPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)POLICY_NAME).is((Object)policyName), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)true)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public long getODBBackupPolicyMappedUserCountbyPolicyName(int cloudId, String policyName, String policyType) {
        Criteria policyTypeCriteria = new Criteria();
        logger.debug("...policyType...." + policyName + ".." + policyType);
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)ONE_DRIVE_POLICY_NAME).is((Object)policyName), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)EXCHANGE_POLICY_NAME).is((Object)policyName), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)SHARE_POINT_POLICY_NAME).is((Object)policyName), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"site").is((Object)true)});
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), policyTypeCriteria});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public long getSyncPolicyMappedUserCountbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncEnabled").is((Object)true)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(new Query((CriteriaDefinition)criteria), User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public User getUserByUserName(int cloudId, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase()));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public User getUserByAADLoginId(int cloudId, String aadLoginId) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)"aadLoginId").regex(Pattern.compile("^" + aadLoginId, 2));
        Criteria criteriaEmailId = Criteria.where((String)USER_NAME).is((Object)aadLoginId);
        criteria.andOperator(new Criteria[]{criteria.orOperator(new Criteria[]{criteriaUserName, criteriaEmailId})});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyByPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    @Override
    public void updateODBUserPolicy(int cloudId, String policyName, ObjectId userId, String policyType, long updatedTimeStamp) {
        Criteria criteria = Criteria.where((String)USER_ID).is((Object)userId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            update.set(ONE_DRIVE_POLICY_NAME, (Object)policyName);
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            update.set(EXCHANGE_POLICY_NAME, (Object)policyName);
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            update.set(SHARE_POINT_POLICY_NAME, (Object)policyName);
        }
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public boolean checkOfficePolicyMappedToUsers(int cloudId, String policyName, String policyType) {
        Criteria policyTypeCriteria = new Criteria();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)ONE_DRIVE_POLICY_NAME).is((Object)policyName)});
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)EXCHANGE_POLICY_NAME).is((Object)policyName)});
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)SHARE_POINT_POLICY_NAME).is((Object)policyName)});
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), policyTypeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)paracloudMongoTemplate.findOne(query, User.class);
        return user != null;
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId) {
        Criteria criteria = Criteria.where((String)"migrationStatus").is((Object)User.MIGRATION_STATUS.IN_PROGRESS);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUsersForDataMigration(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"migrationStatus").ne((Object)User.MIGRATION_STATUS.IN_PROGRESS)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public boolean startMigration(int cloudId, String userName, String destOdbId) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("destOdbLoginId", (Object)destOdbId);
        update.set("migrationStatus", (Object)User.MIGRATION_STATUS.IN_PROGRESS);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
        return updateFirst.getModifiedCount() > 0L;
    }

    @Override
    public void updateMigrationStatusAndFolderName(int cloudId, String userName, String migratedFolderName) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("migratedFolderName", (Object)migratedFolderName);
        update.set("migrationStatus", (Object)User.MIGRATION_STATUS.COMPLETED);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
    }

    @Override
    public List<User> getAllNewUserForOnedrive(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"isNewOdbUser").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllFailedMailBox(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"failedMailBox").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void updateMailBoxFailStatus(int cloudId, String userName, boolean failMailBox) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("failedMailBox", (Object)failMailBox);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUserByODBLoginIdOrEmailId(int cloudId, String odbLoginId) {
        Criteria criteria = new Criteria();
        Criteria criteriaOdbLoginId = Criteria.where((String)"odbLoginId").is((Object)odbLoginId);
        Criteria criteriaEmailIdWithEmail = Criteria.where((String)EMAIL_ID).is((Object)odbLoginId);
        criteria.orOperator(new Criteria[]{criteriaOdbLoginId, criteriaEmailIdWithEmail});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getUserByODBLoginId(int cloudId, String odbLoginId) {
        Criteria criteriaOdbLoginId = Criteria.where((String)"odbLoginId").is((Object)odbLoginId);
        Query query = new Query((CriteriaDefinition)criteriaOdbLoginId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateUserBkpTargetStatus(int cloudId, String userName, int backupTargetErrorCode, boolean backupTargetAssigned, String odbLoginId) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)backupTargetErrorCode);
        update.set("backupTargetAssigned", (Object)backupTargetAssigned);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        update.set("odbLoginId", (Object)odbLoginId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserfailedMailBox(int cloudId, String userName, boolean failedMailBox) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("failedMailBox", (Object)failedMailBox);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllBackupTargetNotAssignedUser(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupTargetAssigned").in(new Object[]{false}), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<String> getAllUnMapedUserNames(int cloudId) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupTargetAssigned").is((Object)false)});
            Query query = new Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("USER").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public List<String> loadAllUsersEmailIds(int cloudId) {
        ArrayList<String> emailIds = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"admin").is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("USER").distinct(EMAIL_ID, (Bson)query.getQueryObject(), String.class);
            List<String> userNames = new ArrayList();
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return emailIds;
        }
    }

    @Override
    public boolean updateODBId(int cloudId, String userName, String destOdbId) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("odbLoginId", (Object)destOdbId);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, User.class);
        logger.debug("... update user data migration .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
        return updateFirst.getModifiedCount() > 0L;
    }

    @Override
    public long getAllUsersCount(int cloudId, List<String> policyNames, List<String> syncPolicyNames, List<String> odbPolicyNames) {
        Object criteria3;
        Criteria criteria32;
        Criteria criteria = new Criteria();
        ArrayList<Object> list = new ArrayList<Object>();
        Criteria criteriaUserDeleted = new Criteria();
        criteriaUserDeleted.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)false)});
        if (!CollectionUtils.isEmpty(policyNames) && policyNames.size() > 0) {
            criteria32 = Criteria.where((String)POLICY_NAME).in(policyNames);
            list.add(criteria32);
        }
        if (!CollectionUtils.isEmpty(syncPolicyNames) && syncPolicyNames.size() > 0) {
            criteria32 = Criteria.where((String)SYNC_POLICY_NAME).in(syncPolicyNames);
            list.add(criteria32);
        }
        ArrayList<String> oneDrivePolicyNames = new ArrayList<String>();
        ArrayList<String> exPolicyNames = new ArrayList<String>();
        ArrayList<String> spPolicyNames = new ArrayList<String>();
        for (String policName : odbPolicyNames) {
            if (policName.startsWith("EX_")) {
                exPolicyNames.add(policName);
                continue;
            }
            if (policName.startsWith("ODB_")) {
                oneDrivePolicyNames.add(policName);
                continue;
            }
            if (!policName.startsWith("SP_")) continue;
            spPolicyNames.add(policName);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(oneDrivePolicyNames);
            list.add(criteria3);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)EXCHANGE_POLICY_NAME).in(exPolicyNames);
            list.add(criteria3);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)SHARE_POINT_POLICY_NAME).in(spPolicyNames);
            list.add(criteria3);
        }
        for (String odbName : odbPolicyNames) {
            logger.debug("....policynamelatest......." + odbName);
        }
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(list.toArray(new Criteria[list.size()]));
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)false), orCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("......." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = paracloudMongoTemplate.count(query, User.class);
        logger.debug("...count is...." + count);
        return count;
    }

    @Override
    public long getAllUsersCount(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("......." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public void blockUnblockUser(int cloudId, String userName, boolean blockOrUnblock) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase())});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(ACTIVE, (Object)blockOrUnblock);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUsersCountInNames(int cloudId, List<String> userNamesList) {
        ArrayList userNames = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).in(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsersByPolicy(int cloudId, String cloudName, boolean active, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        } else {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames), Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<String> getBkpUserNamesByBackupPolicies(int cloudId, List<String> backupPoliciesAdmin) {
        ArrayList<String> userNameList = new ArrayList<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        List userDbList = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)userDbList)) {
            for (User userObj : userDbList) {
                userNameList.add(userObj.getUserName());
            }
        }
        return userNameList;
    }

    @Override
    public List<User> getAllUsers(int cloudId, boolean backupEnabled, boolean syncEnabled, boolean isODBBackupEnabled, int skipValue) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        if (backupEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)true), criteria1});
        } else if (syncEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncEnabled").is((Object)true), criteria1});
        } else if (isODBBackupEnabled) {
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"onedriveBkpEnabled").exists(true)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), orCriteria, criteria1});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllExchangeBkpEnabledUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void disabledOfficeLicense(int cloudId, String userName, boolean onedriveEnabled, boolean exchangeEnabled, boolean sharePointEnabled) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)userName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (onedriveEnabled) {
            update.set("onedriveBkpEnabled", (Object)false);
        }
        if (exchangeEnabled) {
            update.set("exchangeBkpEnabled", (Object)false);
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllSoftBlockUsers(int cloudId, String string, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long getAllSoftBlockUsersCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
        } else {
            Criteria criteriaForDelete = new Criteria();
            criteriaForDelete.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"softBlockEnabled").is((Object)true)});
            Criteria criteriaForPolicyName = Criteria.where((String)POLICY_NAME).in(policyNames);
            Criteria criteriaForSyncPolicyName = Criteria.where((String)SYNC_POLICY_NAME).in(policyNames);
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{criteriaForPolicyName, criteriaForSyncPolicyName, Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
            criteria.andOperator(new Criteria[]{criteriaForDelete, orCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug("......." + query.toString());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<User> getAllUsersForReadOnlyWithPagination(int cloudId, List<String> policyNames, List<String> syncPolicyNames, List<String> odbPolicyNames, int skipValue, boolean isSite, String pagination) {
        Object criteria3;
        Criteria criteria32;
        Criteria criteria = new Criteria();
        ArrayList<Object> list = new ArrayList<Object>();
        Criteria criteriaUserDeleted = new Criteria();
        criteriaUserDeleted.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)isSite)});
        if (!CollectionUtils.isEmpty(policyNames) && policyNames.size() > 0) {
            criteria32 = Criteria.where((String)POLICY_NAME).in(policyNames);
            list.add(criteria32);
        }
        if (!CollectionUtils.isEmpty(syncPolicyNames) && syncPolicyNames.size() > 0) {
            criteria32 = Criteria.where((String)SYNC_POLICY_NAME).in(syncPolicyNames);
            list.add(criteria32);
        }
        ArrayList<String> oneDrivePolicyNames = new ArrayList<String>();
        ArrayList<String> exPolicyNames = new ArrayList<String>();
        ArrayList<String> spPolicyNames = new ArrayList<String>();
        for (String policName : odbPolicyNames) {
            if (policName.startsWith("EX_")) {
                exPolicyNames.add(policName);
                continue;
            }
            if (policName.startsWith("ODB_")) {
                oneDrivePolicyNames.add(policName);
                continue;
            }
            if (!policName.startsWith("SP_")) continue;
            spPolicyNames.add(policName);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(oneDrivePolicyNames);
            list.add(criteria3);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)EXCHANGE_POLICY_NAME).in(exPolicyNames);
            list.add(criteria3);
        }
        if (!CollectionUtils.isEmpty(odbPolicyNames) && odbPolicyNames.size() > 0) {
            criteria3 = Criteria.where((String)SHARE_POINT_POLICY_NAME).in(spPolicyNames);
            list.add(criteria3);
        }
        for (String odbName : odbPolicyNames) {
            logger.debug("....policynamelatest......." + odbName);
        }
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(list.toArray(new Criteria[list.size()]));
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)"site").is((Object)isSite), orCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        logger.debug(" No of records ... " + PCHelperConstant.getReportDisplayRecords());
        if ("true".equals(pagination)) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List listObj = mongoTemplate.find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)listObj)) {
            logger.debug("..list..." + listObj.size());
        } else {
            logger.debug(query.toString() + "..list empty..." + listObj.size());
        }
        return listObj;
    }

    @Override
    public List<User> getAllUsersBySyncPolicyNames(int cloudId, List<String> policyNames, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)SYNC_POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long loadAllSyncPoliciesMappingCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)SYNC_POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentBackupUsersByPolicyByProductType(int cloudId, String cloudName, boolean active, List<String> policyNames, String productType) {
        Criteria productCriteria = null;
        if (!StringUtils.isEmpty((Object)productType)) {
            productCriteria = new Criteria();
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString())});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString())});
            }
        }
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), productCriteria, Criteria.where((String)SUPER_ADMIN).is((Object)false)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)"site").is((Object)false)});
            }
        } else {
            Criteria orCriteria = new Criteria();
            if (!StringUtils.isEmpty((Object)productType)) {
                if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                    orCriteria.orOperator(new Criteria[]{Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policyNames)});
                } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                    orCriteria.orOperator(new Criteria[]{Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
                } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                    orCriteria.orOperator(new Criteria[]{Criteria.where((String)EXCHANGE_POLICY_NAME).in(policyNames)});
                } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                    orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames)});
                } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                    orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames)});
                }
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), orCriteria, productCriteria});
            } else {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames)});
                criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)"site").is((Object)false), orCriteria});
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long getUsersCountInPolicyNamesByProductType(int cloudId, List<String> userNamesList, List<String> policyNames, String productType) {
        Criteria productCriteria = new Criteria();
        if (!StringUtils.isEmpty((Object)productType)) {
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)USER_TYPE).ne((Object)User.TYPE.SERVER.toString())});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true), Criteria.where((String)USER_TYPE).is((Object)User.TYPE.SERVER.toString())});
            }
        } else {
            productCriteria.andOperator(new Criteria[]{Criteria.where((String)"backupEnabled").is((Object)true)});
        }
        Criteria criteria = new Criteria();
        if (CollectionUtils.isEmpty(policyNames)) {
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)SUPER_ADMIN).is((Object)false), Criteria.where((String)"guest").is((Object)false)});
            }
        } else {
            Criteria orCriteria = new Criteria();
            if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SHAREPOINT.getProductType().equals(productType)) {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policyNames)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.ODB.getProductType().equals(productType)) {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.EXCHANGE.getProductType().equals(productType)) {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)EXCHANGE_POLICY_NAME).in(policyNames)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.BACKUP.getProductType().equals(productType)) {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames)});
            } else if (PCHelperConstant.PARABLU_PRODUCT_TYPE.SERVER.getProductType().equals(productType)) {
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(policyNames)});
            }
            if (!StringUtils.isEmpty((Object)productType)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), orCriteria, productCriteria});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).nin(userNamesList), Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false), orCriteria});
            }
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).count(query, User.class);
    }

    @Override
    public void updateTargetStatus(int cloudId, boolean targetAssigned, int backupTargetErrorCode, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)userName.toLowerCase());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupTargetErrorCode", (Object)backupTargetErrorCode);
        update.set("backupTargetAssigned", (Object)targetAssigned);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateMulti(query, update, User.class);
        if (backupTargetErrorCode > 0) {
            BlackListUser blackListUserObj = this.getBlackListUserbyName(1, userName, PCHelperConstant.getPropertyValueComponentName());
            if (blackListUserObj == null) {
                BlackListUser blackListUser = new BlackListUser();
                blackListUser.setResponseCode("404");
                blackListUser.setUserName(userName);
                blackListUser.setLocalHost(PCHelperConstant.getPropertyValueComponentName());
                this.saveBlackListUser(1, blackListUser);
            } else if (!blackListUserObj.getResponseCode().equalsIgnoreCase("404")) {
                this.updateBlackListUserWithCode(1, userName, PCHelperConstant.getPropertyValueComponentName(), "404");
            }
        }
    }

    public void updateBlackListUserWithCode(int cloudId, String userName, String gateWayName, String code) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)gateWayName);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("responseCode", (Object)code);
        update.set("blackListedTime", (Object)System.currentTimeMillis());
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).updateMulti(query, update, BlackListUser.class);
    }

    public void saveBlackListUser(int cloudId, BlackListUser blackListUser) {
        blackListUser.setBlackListedTime(System.currentTimeMillis());
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)blackListUser);
    }

    public BlackListUser getBlackListUserbyName(int cloudId, String userName, String localHost) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserName = Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2));
        Criteria criteriaLocalHost = Criteria.where((String)"localHost").is((Object)localHost);
        criteria.andOperator(new Criteria[]{criteriaUserName, criteriaLocalHost});
        Query query = new Query((CriteriaDefinition)criteria);
        return (BlackListUser)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, BlackListUser.class);
    }

    @Override
    public List<User> getActiveOneDriveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getBlockedOneDriveUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"onedriveBkpEnabled").is((Object)false), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)"site").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getActiveExchangeUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getBlockedExchangeUsers(int cloudId) {
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"exchangeBkpEnabled").is((Object)false), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)"site").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public long countOfPresentOnedriveUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"onedriveBkpEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public long countOfPresentExchangeUsers(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"exchangeBkpEnabled").is((Object)active), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public void updateAdInfoForUser(int cloudId, String userName, boolean accountStatus, String department, String displayName, String location) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("accountStatus", (Object)accountStatus);
        update.set("department", (Object)department);
        update.set("displayName", (Object)displayName);
        update.set("location", (Object)location);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getBackupPolicyMappedUserSbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getSyncPolicyMappedUsersbyPolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)SYNC_POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllBlockedUsers(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"guest").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateUserInfo(int cloudId, String userName, boolean softBlockEnabled, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("softBlockEnabled", (Object)softBlockEnabled);
        update.set(ACTIVE, (Object)active);
        if (softBlockEnabled) {
            update.set("softBlockedTime", (Object)System.currentTimeMillis());
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public void updateUserInfoLicense(int cloudId, String userName, boolean backupEnabled, boolean syncEnabled) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("backupEnabled", (Object)backupEnabled);
        update.set("syncEnabled", (Object)syncEnabled);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public long countOfUsersWithSpecifiedCollectionName(int cloudId, String destinationCollection) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"syncDestinationCollection").is((Object)destinationCollection));
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public String findDestinationCollection(int cloudId) {
        String destinationCollectionName;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long entitiesAllowed = PCHelperConstant.getEntitiesAllowedPerCollection();
        CollectionDetails collectionDetails = (CollectionDetails)mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"entityCount").lt((Object)entitiesAllowed)), CollectionDetails.class);
        if (collectionDetails == null) {
            long count = mongoTemplate.count(new Query(), CollectionDetails.class);
            long destinationCollectionCount = count + 2L;
            destinationCollectionName = "BACKUP_" + destinationCollectionCount;
            collectionDetails = new CollectionDetails();
            collectionDetails.setCollectionName(destinationCollectionName);
            collectionDetails.setEntityCount(1L);
            mongoTemplate.save((Object)collectionDetails);
        } else {
            destinationCollectionName = collectionDetails.getCollectionName();
            collectionDetails.setEntityCount(collectionDetails.getEntityCount() + 1L);
            mongoTemplate.save((Object)collectionDetails);
        }
        return destinationCollectionName;
    }

    @Override
    public String savePstBatch(PstBatch pstBatch) {
        this.mongoOps.save((Object)pstBatch);
        logger.debug("....pstbatchid..." + pstBatch.getId());
        return pstBatch.getId().toString();
    }

    @Override
    public void savePstBatchDetail(PstBatchDetail pstBatchDetail) {
        this.mongoOps.save((Object)pstBatchDetail);
    }

    @Override
    public User getSiteByName(int cloudId, String username) {
        logger.debug("...site query...." + username.toLowerCase());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)username.toLowerCase()), Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public List<User> getExistingSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class, "SITE_DISCOVERY");
    }

    @Override
    public void createSite(int cloudId, User site) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)site, "SITE_DISCOVERY");
    }

    public User getSiteByNameFromDiscovery(int cloudId, String username) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME_LOWER_CASE).is((Object)username.toLowerCase()));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return (User)paracloudMongoTemplate.findOne(query, User.class, "SITE_DISCOVERY");
    }

    @Override
    public User createUserSite(int cloudId, String siteName, String policyName) {
        logger.debug("...create sitedao..." + siteName);
        User site = this.getSiteByNameFromDiscovery(cloudId, siteName);
        SharePointProperties sharePointProperties = this.getSPProperties(cloudId);
        if (!StringUtils.isEmpty((Object)policyName)) {
            site.setSpPolicyName(policyName);
        }
        if (sharePointProperties != null && sharePointProperties.isAutoMigrationEnabled()) {
            site.setSpPolicyName(sharePointProperties.getDefaultSPPolicyName());
        }
        site.setBackupEnabled(false);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)site);
        this.removeSiteFromDiscovery(cloudId, siteName);
        return site;
    }

    @Override
    public long counofPresentActiveSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)ACTIVE).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public List<User> getExistingSites(int cloudId, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        query.with(new Sort(Sort.Direction.ASC, new String[]{USER_NAME}));
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class, "SITE_DISCOVERY");
    }

    public void removeSiteFromDiscovery(int cloudId, String siteName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)USER_NAME).is((Object)siteName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.remove(query, User.class, "SITE_DISCOVERY");
    }

    public User getSiteFromDiscovery(int cloudId, String siteName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)USER_NAME).is((Object)siteName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class, "SITE_DISCOVERY");
    }

    @Override
    public List<User> getActiveSPSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllSPSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllSPSitesForDelegatedAdmin(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getBlockedSPSites(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)false), Criteria.where((String)"site").is((Object)true), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)SUPER_ADMIN).is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void updateSiteMapping(int cloudId, String site, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)site), Criteria.where((String)"site").is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(SHARE_POINT_POLICY_NAME, (Object)policyName);
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
        criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)site)});
        query = new Query((CriteriaDefinition)criteria);
        update = new Update();
        update.set(SHARE_POINT_POLICY_NAME, (Object)policyName);
        update.set("policyModifiedTime", (Object)System.currentTimeMillis());
        paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void removeUserbyID(int cloudId, String userId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(query, User.class);
    }

    @Override
    public List<User> getAllUsers(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyNamesAndPolicyType(int cloudId, List<String> policyNames, boolean isODBBackupEnabled, int skipValue, int limit, String policyType) {
        Criteria policyTypeCriteria = new Criteria();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)ONE_DRIVE_POLICY_NAME).in(policyNames)});
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true), Criteria.where((String)EXCHANGE_POLICY_NAME).in(policyNames)});
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true), Criteria.where((String)SHARE_POINT_POLICY_NAME).in(policyNames)});
        }
        Criteria criteria = new Criteria();
        Criteria orCriteria = new Criteria();
        orCriteria.orOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        if (!StringUtils.isEmpty((Object)policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), policyTypeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)POLICY_NAME).in(policyNames)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public List<User> getAllUsersByPolicyType(int cloudId, boolean backupEnabled, boolean syncEnabled, boolean isODBBackupEnabled, int skipValue, String policyType) {
        Criteria policyTypeCriteria = new Criteria();
        if (OfficeBackupPolicy.TYPE.ODB.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true)});
        } else if (OfficeBackupPolicy.TYPE.EXCHANGE.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"exchangeBkpEnabled").is((Object)true)});
        } else if (OfficeBackupPolicy.TYPE.SHAREPOINT.toString().equalsIgnoreCase(policyType)) {
            policyTypeCriteria.andOperator(new Criteria[]{Criteria.where((String)"site").is((Object)true)});
        }
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        if (backupEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"backupEnabled").is((Object)true), criteria1});
        } else if (syncEnabled) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), Criteria.where((String)"syncEnabled").is((Object)true), criteria1});
        } else if (!StringUtils.isEmpty((Object)policyType)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)true), policyTypeCriteria, criteria1});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void blockOrUnblockUser(int cloudId, String userName, boolean active, boolean isMSPEnv) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (!active) {
            update.set("backupEnabled", (Object)false);
            update.set("syncEnabled", (Object)false);
            update.set("onedriveBkpEnabled", (Object)false);
            update.set("exchangeBkpEnabled", (Object)false);
        }
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        update.set(ACTIVE, (Object)active);
        if (isMSPEnv && active) {
            update.set("backupEnabled", (Object)true);
        }
        logger.debug("....user update...." + active);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getUsersByOneDrivePolicyName(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"onedriveBkpEnabled").is((Object)true), Criteria.where((String)ONE_DRIVE_POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return paracloudMongoTemplate.find(query, User.class);
    }

    @Override
    public void saveSPProperties(int cloudId, SiteElement siteElement) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        SharePointProperties sharePointProperties = new SharePointProperties();
        sharePointProperties.setAutoMigrationEnabled(siteElement.isAutoMigrationEnabled());
        sharePointProperties.setDefaultSPPolicyName(siteElement.getPolicyName());
        sharePointProperties.setPropertiesModifiedTime(System.currentTimeMillis());
        paracloudMongoTemplate.dropCollection(SharePointProperties.class);
        paracloudMongoTemplate.save((Object)sharePointProperties);
    }

    @Override
    public SharePointProperties getSPProperties(int cloudId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SharePointProperties)paracloudMongoTemplate.findOne(new Query(), SharePointProperties.class);
    }

    @Override
    public String getDeviceIdForUserSite(int cloudId, String siteName) {
        String deviceId = "";
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)siteName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List find = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)find)) {
            Device dev = (Device)find.get(0);
            deviceId = dev.getId().toString();
        }
        return deviceId;
    }

    @Override
    public void updateUserInfo(int cloudId, boolean backupEnabled, boolean syncEnabled, String userName, boolean softBlockEnabled, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("softBlockEnabled", (Object)softBlockEnabled);
        if (!softBlockEnabled) {
            update.set("backupEnabled", (Object)backupEnabled);
            update.set("syncEnabled", (Object)syncEnabled);
        }
        update.set(ACTIVE, (Object)active);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.updateFirst(query, update, User.class);
    }

    @Override
    public List<User> getAllUsersByBackupPoliciesAdmin(int cloudId, List<String> backupPoliciesAdmin) {
        if (backupPoliciesAdmin != null && backupPoliciesAdmin.size() > 0) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).in(backupPoliciesAdmin), Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)ACTIVE).is((Object)true)});
            Query query = new Query((CriteriaDefinition)criteria);
            logger.debug("query= " + query.toString());
            MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            return paracloudMongoTemplate.find(query, User.class);
        }
        return null;
    }

    @Override
    public List<User> getAllUsersForDelegatedAdminWithNamesAndPolicyMap(int cloudId, List<String> usersNames, List<String> policyNames, String policyType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<User> userList = new ArrayList<User>();
        logger.debug("policyNames size={}", (Object)policyNames.size());
        if (policyNames != null && policyNames.size() > 0) {
            for (String userName : usersNames) {
                List userDbList;
                userName = userName.trim();
                Criteria criteria = new Criteria();
                if ("backupPolicy".equalsIgnoreCase(policyType)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile(userName, 2)), Criteria.where((String)POLICY_NAME).in(policyNames)});
                } else if ("syncPolicy".equalsIgnoreCase(policyType)) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile(userName, 2)), Criteria.where((String)SYNC_POLICY_NAME).in(policyNames)});
                }
                if ((userDbList = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), User.class)) == null) continue;
                for (User userObj : userDbList) {
                    userList.add(userObj);
                }
            }
        }
        return userList;
    }

    @Override
    public List<User> getAllReadOnlyAdminsForPolicyName(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        Criteria policyCriteria = new Criteria();
        policyCriteria.orOperator(new Criteria[]{Criteria.where((String)"odbPoliciesAdmin").in(policyNames), Criteria.where((String)"backupPoliciesAdmin").in(policyNames)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)true), policyCriteria, criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public long countOfPresentSite(int cloudId, boolean active) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTIVE).is((Object)active), Criteria.where((String)"guest").is((Object)false), Criteria.where((String)"site").is((Object)active)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        paracloudMongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return paracloudMongoTemplate.count(query, User.class);
    }

    @Override
    public Set<String> getAllSuperAdmins(int cloudId) {
        HashSet<String> superAdminNames = new HashSet<String>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)SUPER_ADMIN).is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        List superAdmins = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
        if (!CollectionUtils.isEmpty((Collection)superAdmins)) {
            for (User user : superAdmins) {
                superAdminNames.add(user.getUserName());
            }
        }
        return superAdminNames;
    }

    @Override
    public void deleteSPToken(int cloudId, String siteId) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"siteId").is((Object)siteId)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAllAndRemove(query, SiteDeltaPath.class);
    }

    @Override
    public void deleteMailToken(int cloudId, String userName) {
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        paracloudMongoTemplate.findAllAndRemove(query, DeltaPath.class);
    }

    @Override
    public List<User> getAllDelegatedAdmins(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"readOnlyAdmin").is((Object)true), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, User.class);
    }

    @Override
    public void checkandChangePolicyRelatedBackup(String oneDrivePolicyName, String oneDrivePolicyName2, boolean b, boolean c) {
    }

    @Override
    public void checkandChangePolicyRelatedBackup(String oldPolicyName, String newPolicyName, String userName) {
        if (!oldPolicyName.equalsIgnoreCase(newPolicyName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
            Query query = new Query((CriteriaDefinition)criteria);
            String oldTable = "BACKUP_BATCH_" + oldPolicyName.toUpperCase();
            List odbBackupBatchList = this.msgMongoTemplate.find(query, ODBBackupBatch.class, oldTable);
            if (!CollectionUtils.isEmpty((Collection)odbBackupBatchList)) {
                for (ODBBackupBatch odbBackupBatch : odbBackupBatchList) {
                    this.msgMongoTemplate.save((Object)odbBackupBatch, "BACKUP_BATCH_" + newPolicyName.toUpperCase());
                    this.msgMongoTemplate.remove((Object)odbBackupBatch, oldTable);
                }
            }
        }
    }
}

