/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.client.result.UpdateResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.pcbd.dao.SyncBackUpImageDAO;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.MiniCloud;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UsersSharedFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class SyncBackUpImageDAOImpl
implements SyncBackUpImageDAO {
    private static final String BACKUP = "BACKUP";
    private static final String DEVICE_PATH = "devicePath";
    private static final String FILE_NAME = "fileName";
    private static final String USER_NAME = "userName";
    private static final String MODIFIED_TIME = "lastServerModifiedTime";
    private static final String FOLDER = "folder";
    private static final String PRESENT = "present";
    private static final String MINI_CLOUD = "miniCloud";
    private static final String CRAWL_START_TIME_STAMP = "crawlStartTimestamp";
    private static final String REG_ID = "deviceUUID";
    private static final String CONSOLIDATED_IMAGE_ID = "consolidatedImage.$id";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String STATUS = "status";
    private static final String DELETED = "DELETED";
    private static final String RESTORED = "RESTORED";
    Logger logger = LogManager.getLogger(SyncBackUpImageDAOImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    private List<String> getCollectionsForSyncQuery(User user, MiniCloud miniCloud) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            queryTablesList.add(user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            queryTablesList.add(miniCloud.getSyncDestinationCollection());
        } else if (PCHelperConstant.isBackupCollectionQueryRequired()) {
            queryTablesList.add(BACKUP);
        }
        return queryTablesList;
    }

    @Override
    public List<BackUpImage> getAllRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long currentTimeStamp, String folderPath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public List<BackUpImage> getAllPresentRecords(int cloudId, String userName, String cloudName, long curTimeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestExistingFileRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        Criteria pathCriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathCriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList filteredList = new ArrayList();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathForMiniCloud(int cloudId, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllPresentRecordsForBasePath(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)DEVICE_PATH).is((Object)folderPath)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        ArrayList filteredListTemp = new ArrayList();
        ArrayList<BackUpImage> filteredList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        Map<String, Map<String, List<BackUpImage>>> groupResult = backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        groupResult.forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredListTemp.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        filteredList = filteredListTemp.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        return filteredList;
    }

    @Override
    public List<BackUpImage> getAllPresentRecordsForBasePathExceptMiniclouds(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath, List<String> miniClouds, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).nin(miniClouds), Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        ArrayList filteredListTemp = new ArrayList();
        ArrayList<BackUpImage> filteredList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, null);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        Map<String, Map<String, List<BackUpImage>>> groupResult = backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        groupResult.forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredListTemp.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        filteredList = filteredListTemp.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        return filteredList;
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsForFolder(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String foldersToSyncList, boolean exist, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)foldersToSyncList)});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), pathLikeCriteria, Criteria.where((String)REG_ID).ne((Object)regID)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), pathLikeCriteria, Criteria.where((String)REG_ID).ne((Object)regID)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        ArrayList filteredListTemp = new ArrayList();
        List<Object> filteredList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        Map<String, Map<String, List<BackUpImage>>> groupResult = backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        groupResult.forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredListTemp.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        filteredList = exist ? filteredListTemp.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList()) : filteredListTemp.stream().filter(filteredImage -> filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        return filteredList;
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsForFoldersExceptMiniClouds(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String foldersToSyncList, List<String> miniClouds, boolean exist, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)foldersToSyncList), Criteria.where((String)FILE_NAME).nin(miniClouds), Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)REG_ID).ne((Object)regID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        ArrayList filteredListTemp = new ArrayList();
        List<Object> filteredList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, null);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        Map<String, Map<String, List<BackUpImage>>> groupResult = backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        groupResult.forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredListTemp.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        filteredList = exist ? filteredListTemp.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList()) : filteredListTemp.stream().filter(filteredImage -> filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        return filteredList;
    }

    @Override
    public void saveToBackUpImageDB(int cloudId, String cloudName, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            mongoTemplate.save((Object)backUpImage, user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            mongoTemplate.save((Object)backUpImage, miniCloud.getSyncDestinationCollection());
        } else {
            mongoTemplate.save((Object)backUpImage);
        }
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public List<BackUpImage> getBackUpImageDBRecordsByDevicePathAndFileName(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathForRestore(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public BackUpImage getExistingBackUpImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        BackUpImage backUpImage;
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List backUpImageList = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList = mongoTemplate.find(query, BackUpImage.class, dest);
        }
        if (backUpImageList != null && !backUpImageList.isEmpty() && !(backUpImage = (BackUpImage)backUpImageList.get(0)).getStatus().equalsIgnoreCase(DELETED)) {
            return backUpImage;
        }
        return null;
    }

    @Override
    public BackUpImage getExistingBackUpImageDBRecordByDevicePathForFolder(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public List<BackUpImage> getAllBackUpImageDBRecordsByDevicePaths(int cloudId, String userName, String cloudName, List<String> completePathList) {
        return null;
    }

    @Override
    public BackUpImage getExistingDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public double getTotalSizeByPath(int cloudId, String userName, String cloudName, String path) {
        return 0.0;
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsExceptFolder(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList) {
        Criteria criteria = new Criteria();
        Criteria pathCriteria = Criteria.where((String)DEVICE_PATH).ne((Object)folderToSyncList);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).not().regex(folderToSyncList);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)startTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), pathCriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllPresentRecordsWithGivenFileName(int cloudId, String userName, String cloudName, String fileName, boolean isPresent) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)isPresent), Criteria.where((String)FILE_NAME).regex(fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllDeletedFilesBetweenTimeStamps(int cloudId, String userName, String cloudName, long lastSuccessfulDeleteTimeStamp, long currentDeleteTimeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)lastSuccessfulDeleteTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentDeleteTimeStamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public long getFileCountOfFileType(int cloudId, String cloudName, String fileType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).regex(fileType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestChildrenByFolder(int cloudId, String userName, String cloudName, String folderPath, int skip, User user, MiniCloud miniCloud, boolean showDeletedFiles) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)MINI_CLOUD).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)MINI_CLOUD).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList filteredListTemp = new ArrayList();
        List<Object> filteredList = new ArrayList();
        ArrayList<BackUpImage> resultList = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> groupResult = backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        groupResult.forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredListTemp.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        filteredList = filteredListTemp;
        if (!showDeletedFiles) {
            filteredList = filteredListTemp.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
        }
        for (BackUpImage image : filteredList) {
            if (!image.isFolder() && (image.getStatus().equalsIgnoreCase(DELETED) || image.getStatus().equalsIgnoreCase(RESTORED))) {
                List<BackUpImage> groupedFiles = groupResult.get(image.getDevicePath()).get(image.getFileName());
                BackUpImage latestImage = groupedFiles.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).filter(f -> !f.getStatus().equalsIgnoreCase(DELETED) && !f.getStatus().equalsIgnoreCase(RESTORED)).findFirst().orElse(null);
                if (latestImage == null) continue;
                if (image.getStatus().equalsIgnoreCase(DELETED)) {
                    latestImage.setPresent(false);
                }
                resultList.add(latestImage);
                continue;
            }
            resultList.add(image);
        }
        return resultList;
    }

    @Override
    public List<ObjectId> getChildrenIdByFolder(int cloudId, String userName, String cloudName, String folderPath, int skip) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime", DEVICE_PATH, FILE_NAME}));
        query.limit(5000);
        if (skip != 0) {
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        ArrayList<ObjectId> deleteConsolidatedList = new ArrayList<ObjectId>();
        HashedMap consMap = new HashedMap();
        this.logger.debug(userName + "...." + folderPath + ".....getChildrenIdByFolder..." + list.size());
        for (BackUpImage backUpImage : list) {
            String uniqueUserPath = backUpImage.getUserName() + backUpImage.getDevicePath() + backUpImage.getFileName();
            if (consMap.containsValue(uniqueUserPath)) {
                deleteConsolidatedList.add(backUpImage.getId());
                continue;
            }
            consMap.put(backUpImage.getId(), uniqueUserPath);
            consolidatedList.add(backUpImage.getId());
        }
        if (!CollectionUtils.isEmpty(deleteConsolidatedList)) {
            for (ObjectId objectId : deleteConsolidatedList) {
                this.logger.debug("....delete id..... " + objectId);
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(new Object[]{objectId})});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, BackUpImage.class);
            }
        }
        return consolidatedList;
    }

    @Override
    public List<ObjectId> getChildrenIdByFolder(int cloudId, String userName, String cloudName, String folderPath, List<String> miniCloudNames, int skip) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).in(miniCloudNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(5000);
        if (skip != 0) {
            this.logger.debug(" check skip is working");
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        for (BackUpImage backUpImage : list) {
            consolidatedList.add(backUpImage.getId());
        }
        return consolidatedList;
    }

    @Override
    public List<BackUpImage> getAllExistingRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long currentTimeStamp, String folderPath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)DEVICE_PATH).regex("^" + folderPath + "/", "i")});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsByPath(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, boolean present, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathCriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)PRESENT).is((Object)present), pathCriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getSearchResultForFile(int cloudId, String userName, String cloudName, String fileName, String filePath, int start, int rows, MiniCloudElementList miniCloudElementList) {
        return null;
    }

    @Override
    public List<ObjectId> getSearchResultIdsForFile(int cloudId, String userName, String cloudName, String fileName, String filePath, int start, int rows, MiniCloudElementList miniCloudElementList) {
        this.logger.debug(filePath + " $%@#$%@#%#%@#%@#@# inside search filter ...." + fileName);
        ArrayList<ObjectId> objectIdList = new ArrayList<ObjectId>();
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(filePath);
        Criteria fileNameLikeCriteria = Criteria.where((String)FILE_NAME).regex(fileName);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), pathLikeCriteria, fileNameLikeCriteria});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), BackUpImage.class);
        for (BackUpImage backUpImage : list) {
            this.logger.debug(backUpImage.getId() + " output list  ... " + backUpImage.getFileName());
            objectIdList.add(backUpImage.getId());
        }
        this.logger.debug("END OF  $%@#$%@#%#%@#%@#@# inside search filter ...." + objectIdList.size());
        return objectIdList;
    }

    @Override
    public List<BackUpImage> getAllSharedFilesByDevicePath(int cloudId, String userName, String cloudName, String folderPath, boolean sharedByMe) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)"sharedTimeStamp").exists(true), Criteria.where((String)PRESENT).is((Object)true), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllSharedFilesInBaseFolder(int cloudId, String userName, String cloudName, String folderPath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getDeletedChildrenByFolder(int cloudId, String userName, String cloudName, String folderPath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)STATUS).is((Object)DELETED), Criteria.where((String)FOLDER).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)STATUS).is((Object)DELETED), Criteria.where((String)FOLDER).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList<BackUpImage> filteredList = new ArrayList<BackUpImage>();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList;
    }

    @Override
    public Boolean isDestinationPathExists(int cloudId, String userName, String cloudName, String path, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage != null;
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathForDeletedRecord(int cloudId, String userName, String cloudName, String devicePath, String fileName, boolean present) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)present)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)present)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathForPresentRecord(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathIsPresent(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllMySharedFiles(int cloudId, String cloudName, String userName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sharedBy").exists(true), Criteria.where((String)"sharedBy").is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public List<ObjectId> getChildrenIdByFolderForMC(int cloudId, String cloudName, String folderPath, List<String> miniCloudNames, int skip) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).in(miniCloudNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(5000);
        if (skip != 0) {
            this.logger.debug(" check skip is working");
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        for (BackUpImage backUpImage : list) {
            consolidatedList.add(backUpImage.getId());
        }
        return consolidatedList;
    }

    @Override
    public List<BackUpImage> getLatestChildrenByFolderForMC(int cloudId, String cloudName, String folderPath, List<String> miniCloudNames, List<String> destinationCollections, int skip) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).in(miniCloudNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        ArrayList backUpImageList = new ArrayList();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        for (String dest : destinationCollections) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList<BackUpImage> filteredList = new ArrayList<BackUpImage>();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList;
    }

    @Override
    public void deleteBackUpImage(int cloudId, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getLatestExistingRecordsBeforeCurrentTimeStampForPath(int cloudId, String userName, String cloudName, long currentTimeStamp, String folderPath, User user, MiniCloud miniCloud) {
        this.logger.debug("Current Timestamp : " + currentTimeStamp);
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp), Criteria.where((String)FOLDER).is((Object)false), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentTimeStamp), Criteria.where((String)FOLDER).is((Object)false), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        this.logger.debug("Query : " + query.toString());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        this.logger.debug("Query Tables : " + Arrays.toString(queryTablesList.toArray()));
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList filteredList = new ArrayList();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList.stream().filter(filteredImage -> !filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
    }

    @Override
    public void deleteBackUpImage(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (user != null && StringUtils.isNotEmpty((String)user.getSyncDestinationCollection())) {
            mongoTemplate.remove((Object)backUpImage, user.getSyncDestinationCollection());
        } else if (miniCloud != null && StringUtils.isNotEmpty((String)miniCloud.getSyncDestinationCollection())) {
            mongoTemplate.remove((Object)backUpImage, miniCloud.getSyncDestinationCollection());
        } else {
            mongoTemplate.remove((Object)backUpImage);
        }
    }

    @Override
    public boolean isPathMiniCloud(int cloudId, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)"ParaBlu"), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage != null;
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsForFolderForMC(int cloudId, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, boolean exists) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderToSyncList);
        criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)MINI_CLOUD).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getRecordsBetweenTimeStampsForFolderForSync(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, boolean exists) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderToSyncList), Criteria.where((String)DEVICE_PATH).regex("^" + folderToSyncList + "/", "i")});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public void deleteUserSharedFileImage(int cloudId, String fileName, String devicePath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        List fileImages = mongoTemplate.find(query, BackUpImage.class);
        HashSet<ObjectId> imageObjectIds = new HashSet<ObjectId>();
        for (BackUpImage backUpImage : fileImages) {
            imageObjectIds.add(backUpImage.getId());
        }
        this.logger.debug(" deleteUserSharedFileImages .............. " + imageObjectIds.size());
        if (!CollectionUtils.isEmpty(imageObjectIds)) {
            try {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"consolidatedImageId").in(imageObjectIds)});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.remove(query, UsersSharedFile.class);
            }
            catch (Exception e) {
                this.logger.trace(" Exception  :" + e);
                this.logger.error(" Exception  :" + e.getMessage());
            }
        }
    }

    @Override
    public SyncOverView getSyncOverView(int cloudId) {
        Query query = new Query();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncOverView)mongoTemplate.findOne(query, SyncOverView.class);
    }

    @Override
    public void saveSyncOverView(int cloudId, SyncOverView syncOverView) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)syncOverView);
    }

    @Override
    public List<DailySyncOverView> getDailySyncOverView(int cloudId, long fromDate, long endDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").gte((Object)fromDate), Criteria.where((String)"overViewDate").lte((Object)endDate)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, DailySyncOverView.class);
    }

    @Override
    public BackUpImage getMiniCloudRecordIfExists(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getAllBackUpImages(int cloudId, List<ObjectId> backUpImagesIdList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(backUpImagesIdList)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackUpImage.class);
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathForMiniCloudWithoutRegex(int cloudId, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getBackUpImageDBRecordByDevicePathWithoutRegex(int cloudId, String userName, String cloudName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getMiniCloudRecordIfExistsWithoutRegex(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public List<BackUpImage> getBackUpImageDBRecordByOnlyDevicePath(int cloudId, String userName, String cloudName, String devicePath, User user, MiniCloud miniCloud, boolean isFolder) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)isFolder)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)isFolder)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        this.logger.debug("Query Tables : " + Arrays.toString(queryTablesList.toArray()));
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public BackUpImage getBackUpImageById(int cloudId, String backUpImageId, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImage = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImage = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImage;
    }

    @Override
    public BackUpImage getBackUpImageByIdAndDestinationCollection(int cloudId, ObjectId backUpImageId, String destinationCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backUpImageId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, destinationCollection);
    }

    @Override
    public BackUpImage getLatestBackUpImageVersionByDevicePathAndFileNameAndDestCollection(int cloudId, String devicePath, String fileName, String destinationCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List versionLists = mongoTemplate.find(query, BackUpImage.class, destinationCollection);
        return versionLists != null && !versionLists.isEmpty() ? (BackUpImage)versionLists.get(0) : null;
    }

    @Override
    public BackUpImage getExistingBackUpImageDBRecordByDevicePathForFolderLatest(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i")});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class);
    }

    @Override
    public void updateDeletedFolder(int cloudId, ObjectId backUpImageId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backUpImageId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(PRESENT, (Object)true);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, BackUpImage.class);
        this.logger.debug("updateDeletedFolder.. " + updateFirst.getModifiedCount() + ".." + updateFirst.wasAcknowledged());
    }

    @Override
    public List<BackUpImage> getBackUpImageVersionsByDevicePathAndFileName(int cloudId, String userName, String devicePath, String fileName, int numberOfVersions, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        if (numberOfVersions != -1) {
            query.limit(numberOfVersions);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }

    @Override
    public long areFilesInBlukrypt(int cloudId, String userName, String path, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        Criteria andCriteria = new Criteria();
        Criteria folderFalseCriteria = Criteria.where((String)FOLDER).is((Object)false);
        Criteria finalCriteria = new Criteria();
        if (!StringUtils.isEmpty((String)fileName)) {
            path = path + "/" + fileName;
            this.logger.debug("Filename is present : new path : " + path);
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)path)});
        } else {
            this.logger.debug("--- FileName not present ---");
            criteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)path)});
        }
        if (!StringUtils.isEmpty((String)userName)) {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria, Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        } else {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria});
        }
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(RESTORED);
        statusList.add(DELETED);
        finalCriteria.andOperator(new Criteria[]{andCriteria, Criteria.where((String)"storagePlace").exists(false), Criteria.where((String)STATUS).nin(statusList)});
        Query query = new Query((CriteriaDefinition)finalCriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = 0L;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            count += mongoTemplate.count(query, BackUpImage.class, dest);
        }
        return count;
    }

    @Override
    public long getCountOfVersionsForFile(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(RESTORED);
        statusList.add(DELETED);
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)backUpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)backUpImage.getFileName()), Criteria.where((String)STATUS).nin(statusList)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = 0L;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            count += mongoTemplate.count(query, BackUpImage.class, dest);
        }
        return count;
    }

    @Override
    public BackUpImage getOldestRevision(int cloudId, BackUpImage backUpImage, User user, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)backUpImage.getDevicePath()), Criteria.where((String)FILE_NAME).is((Object)backUpImage.getFileName()), Criteria.where((String)STATUS).ne((Object)DELETED)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImageResult = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImageResult = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImageResult;
    }

    @Override
    public void deleteBackUpImageRevision(int cloudId, BackUpImage backUpImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)backUpImage);
    }

    @Override
    public List<BackUpImage> getDeletedBackupImagesByUser(int cloudId, String userName, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, null);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList filteredList = new ArrayList();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList.stream().filter(filteredImage -> filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
    }

    @Override
    public List<BackUpImage> getDeletedBackupImagesByMiniCloud(int cloudId, String devicePath, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(null, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList filteredList = new ArrayList();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList.stream().filter(filteredImage -> filteredImage.getStatus().equalsIgnoreCase(DELETED)).collect(Collectors.toList());
    }

    @Override
    public BackUpImage getBackUpImageForMC(int cloudId, String fileName, MiniCloud miniCloud) {
        String dest;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)"ParaBlu"), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)MINI_CLOUD).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackUpImage backUpImageResult = null;
        List<String> queryTablesList = this.getCollectionsForSyncQuery(null, miniCloud);
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (backUpImageResult = (BackUpImage)mongoTemplate.findOne(query, BackUpImage.class, dest = iterator.next())) == null) {
        }
        return backUpImageResult;
    }

    @Override
    public List<BackUpImage> getAllChildFilesOfFolderMC(int cloudId, String userName, String devicePath, boolean isFolder, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(null, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        ArrayList<BackUpImage> filteredList = new ArrayList<BackUpImage>();
        backUpImageList.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName))).forEach((key1, value1) -> value1.forEach((key2, value2) -> filteredList.add(value2.stream().max(Comparator.comparing(BackUpImage::getLastServerModifiedTime)).get())));
        return filteredList;
    }

    @Override
    public BackUpImage getLatestPresentRecordForFileNameAndDevicePath(int cloudId, String userName, String devicePath, String fileName, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(RESTORED);
        statusList.add(DELETED);
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)STATUS).nin(statusList)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)STATUS).nin(statusList)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList backUpImageList = new ArrayList();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        if (!backUpImageList.isEmpty()) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    @Override
    public List<BackUpImage> getVersions(int cloudId, String cloudName, String userName, String fileName, String fileCompletePath, User user, MiniCloud miniCloud) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)fileCompletePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{"lastServerModifiedTime"}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<BackUpImage> backUpImageList = new ArrayList<BackUpImage>();
        List<String> queryTablesList = this.getCollectionsForSyncQuery(user, miniCloud);
        for (String dest : queryTablesList) {
            backUpImageList.addAll(mongoTemplate.find(query, BackUpImage.class, dest));
        }
        return backUpImageList;
    }
}

