/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.SchedulesDao;
import com.parablu.pcbd.domain.NoBkpSchedule;
import com.parablu.pcbd.domain.Schedule;
import java.math.BigInteger;
import java.util.List;
import org.bson.types.ObjectId;
import org.hibernate.SQLQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class SchedulesDaoImpl
implements SchedulesDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String SCHEDULE_NAME = "scheduleName";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveSchedule(int cloudId, String cloudName, Schedule schedule) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)schedule);
    }

    @Override
    public Schedule getSchedule(int cloudId, String cloudName, String scheduleName) {
        return (Schedule)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).is((Object)scheduleName)), Schedule.class);
    }

    @Override
    public boolean removeSchedule(int cloudId, String scheduleName) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).is((Object)scheduleName)), Schedule.class) != null;
    }

    @Override
    public List<Schedule> getAllSchedules(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{SCHEDULE_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, Schedule.class);
    }

    @Override
    public List<Schedule> getSchedules(int cloudId, String cloudName, List<String> scheduleNames) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).in(scheduleNames));
        query.with(new Sort(Sort.Direction.ASC, new String[]{SCHEDULE_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, Schedule.class);
    }

    @Override
    public List<BigInteger> getBackupPolicyMappedValue(int cloudId, String cloudName, ObjectId scheduleId) {
        String sqlQuery = "select BKP_POLICY_ID  from BACKUP_POLICY_SCHEDULE_MAPPING where SCHEDULE_ID =:scheduleId ";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sqlQuery);
        query.setParameter("scheduleId", (Object)scheduleId);
        return query.list();
    }

    @Override
    public void saveNoBkpSchedule(int cloudId, String cloudName, NoBkpSchedule schedule) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)schedule);
    }

    @Override
    public NoBkpSchedule getNobkpSchedule(int cloudId, String cloudName, String scheduleName) {
        return (NoBkpSchedule)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).is((Object)scheduleName)), NoBkpSchedule.class);
    }

    @Override
    public List<NoBkpSchedule> getAllNoBkpSchedules(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.ASC, new String[]{SCHEDULE_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, NoBkpSchedule.class);
    }

    @Override
    public boolean removeNoBkpSchedule(int cloudId, String scheduleName) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).is((Object)scheduleName)), NoBkpSchedule.class) != null;
    }

    @Override
    public List<NoBkpSchedule> getNoBKPSchedules(int cloudId, String cloudName, List<String> scheduleNames) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)SCHEDULE_NAME).in(scheduleNames));
        query.with(new Sort(Sort.Direction.ASC, new String[]{SCHEDULE_NAME}));
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, NoBkpSchedule.class);
    }
}

