/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.PacksDao;
import com.parablu.pcbd.domain.Pack;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class PacksDaoImpl
implements PacksDao {
    private static final String PACK_VALID_TILL = "packValidTill";
    private static final String PACK_TYPE = "packType";
    private static final String SKU_CODE = "skuCode";
    private static final String BOTH = "both";
    private static final String BASE = "base";
    private static final String ADDON = "addon";
    private ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static Logger logger = LogManager.getLogger(PacksDaoImpl.class);

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<Pack> getPacks(int cloudId, String cloudName, String packType, String packActive) throws Exception {
        logger.debug("the packs of type={} termed to be active={}, at {}", (Object)packType.toLowerCase(), (Object)packActive, (Object)System.currentTimeMillis());
        Criteria criteria = new Criteria();
        if (packActive.equals("true") && !packType.equalsIgnoreCase(BOTH)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PACK_VALID_TILL).gt((Object)System.currentTimeMillis()), Criteria.where((String)PACK_TYPE).is((Object)packType.toLowerCase())});
        } else if (packActive.equals("true") && packType.equalsIgnoreCase(BOTH)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PACK_VALID_TILL).gt((Object)System.currentTimeMillis())});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List packs = mongotemplate.find(query, Pack.class, "PACK");
        if (packType.equalsIgnoreCase(BASE)) {
            for (Pack pack : packs) {
                pack.setAddons(new ArrayList<Pack>());
            }
        }
        return packs;
    }

    @Override
    public Pack getPack(int cloudId, String cloudName, String skuCode, String packActive, String packType) throws Exception {
        Criteria criteria = new Criteria();
        if (packActive.equals("true") && !packType.equalsIgnoreCase(BOTH)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PACK_VALID_TILL).gt((Object)System.currentTimeMillis()), Criteria.where((String)SKU_CODE).is((Object)skuCode), Criteria.where((String)PACK_TYPE).is((Object)packType.toLowerCase())});
        } else if (packActive.equals("true") && packType.equalsIgnoreCase(BOTH)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PACK_VALID_TILL).gt((Object)System.currentTimeMillis()), Criteria.where((String)SKU_CODE).is((Object)skuCode)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Pack pack = (Pack)mongotemplate.findOne(query, Pack.class, "PACK");
        if (packType.equals("BASE")) {
            pack.setAddons(new ArrayList<Pack>());
        }
        return pack;
    }
}

