/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.ODBConnectorSettingDao;
import com.parablu.pcbd.domain.C2CAppSettings;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBConnectorSetting;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ODBConnectorSettingDaoImpl
implements ODBConnectorSettingDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveODBConnectorSettingsToDB(int cloudId, ODBConnectorSetting odbConnectorSetting) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)odbConnectorSetting);
    }

    @Override
    public ODBConnectorSetting getConnectorSettingByConfigId(int cloudId, String configId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"_id").is((Object)configId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (ODBConnectorSetting)mongoTemplate.findOne(query, ODBConnectorSetting.class);
    }

    @Override
    public List<ODBConnectorSetting> getAllConnectorSettingImages(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(ODBConnectorSetting.class);
    }

    @Override
    public MSAppSetting getMSAppSettingsDetailsByConfigId(int cloudId, String configId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"_id").is((Object)configId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (MSAppSetting)mongoTemplate.findOne(query, MSAppSetting.class);
    }

    @Override
    public void saveMSAppSettingsDetails(int cloudId, MSAppSetting msAppSetting) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppSetting msSetting = this.getMSAppSettingsDetails(cloudId);
        if (msSetting != null && msSetting.getId() != null) {
            ObjectId id = msSetting.getId();
            mongoTemplate.remove((Object)msSetting);
            msAppSetting.setId(id);
        }
        mongoTemplate.save((Object)msAppSetting);
        mongoTemplate.save((Object)msAppSetting, "C2C_APP_SETTING");
    }

    @Override
    public MSAppSetting getMSAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MSAppSetting)mongoTemplate.findOne(new Query(), MSAppSetting.class);
    }

    @Override
    public EWSAppSetting getEwsAppSettingDetail(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        return (EWSAppSetting)mongoTemplate.findOne(query, EWSAppSetting.class);
    }

    @Override
    public void saveEWSAppSettingsDetails(int cloudId, EWSAppSetting ewsAppSetting) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        EWSAppSetting msSetting = this.getEwsAppSettingDetail(cloudId);
        if (msSetting != null && msSetting.getId() != null) {
            ObjectId id = msSetting.getId();
            mongoTemplate.remove((Object)msSetting);
            ewsAppSetting.setId(id);
        }
        mongoTemplate.save((Object)ewsAppSetting);
    }

    @Override
    public EWSAppSetting getEWAppSettingsDetailsByConfigId(int cloudId, String configId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"_id").is((Object)configId);
        Query query = new Query((CriteriaDefinition)criteria);
        return (EWSAppSetting)mongoTemplate.findOne(query, EWSAppSetting.class);
    }

    @Override
    public void saveC2CAppSettingsDetails(int cloudId, MSAppSetting msAppSetting) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        C2CAppSettings c2cAppSetting = this.getC2CAppSettingsDetails(cloudId);
        if (c2cAppSetting != null && c2cAppSetting.getId() != null) {
            ObjectId id = c2cAppSetting.getId();
            mongoTemplate.remove((Object)c2cAppSetting);
            msAppSetting.setId(id);
        }
        mongoTemplate.save((Object)msAppSetting, "C2C_APP_SETTING");
    }

    @Override
    public C2CAppSettings getC2CAppSettingsDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (C2CAppSettings)mongoTemplate.findOne(new Query(), C2CAppSettings.class);
    }
}

